
// Persistence of Vision Ray Tracer Scene Description File
// File: Globos.pov
// Date: 31/12/96
// Auth: Lorenzo Quintana Juez

global_settings { assumed_gamma 1.1 }

// ---- Include ----
#include "texturas.inc"
#include "objetos.inc"

// ---- Camera ----
camera { location  <0, 11, -10> look_at   <0, 12.1, 0> angle 58 }

// ---- Light ----
light_source { <20000, 30000, -40000> rgb 1 }

// ---- Sky ----
sky_sphere {
    pigment { gradient y
     color_map {
       [ 0 rgb<.2, .6, 1> ]
       [ .2 rgb<0, .3, 1> ]
       [ .5 rgb<0, 0, .5> ]
     }
      scale 1 translate -1 } }

// ---- Water ----
plane { y, 0 texture { tWater } }

// ---- Diente de Leon ----
object { GloboVi rotate <0,28, 8> scale .85 translate <-14,22,26.8> }
object { Flor scale 1.2 rotate <-90,35,0> translate <-11.6,2,26.7> }
object { Hojas rotate 10*y translate <-12,2,26> }
object { Hojas2 translate <0,0,-19.88> rotate -90*x
  scale <.7,3.3,.7> rotate 9*z translate <-14,22,26.8> }

// ---- Vilanos ----
object { vilano rotate <0,0,15> translate <-20,27,30>  }
object { vilano rotate <8,0,-5> translate <-6.8,22,23>  }
object { vilano rotate <-5,0,-11> translate <-.2,19,14>  }
object { vilano rotate <-12,2,-7> translate <.96,6,17.5>  }
object { vilano rotate <5,0,-1> translate <4,18,35>  }
object { vilano rotate <5,0,-2> translate <14,25,50>  }
object { vilano rotate <-4,2,0> translate <6,3.05,10>  }
object { vilano rotate <5,0,-5> translate <35,38,58>  }
object { vilano rotate <23,0,-90> translate <21,0,38>  }

// ---- Height Field 1 ----
height_field { gif "hf1.gif" texture { tHf1 }
  translate -.5 scale <75,10,60> translate 40*z }

// ---- Height Field 2 ----
object { Hf2 scale <180,15,150>  translate <-25,-2,220> }

// ---- Height Field 3 ----
object { Hf3 scale<200000,29000,110000> translate <0,11000,170000>
 texture { tHf4 } }

// -- Junco --
object { Junco scale 1.1 rotate <0,180,-1> translate <125,0,239> }
object { Junco scale .9 rotate 6*z translate <125,0,239> }
object { Hierba scale 2.15 rotate 29*y translate <123,.5,239> }

// ---- Hierbas ----
object { Hierba scale 2.15 rotate -20*y translate <128,0,240> }
object { Hierba scale 1.8 rotate 58*y translate <116,0,238> }
object { Hierba scale 2.18 rotate 33*y translate <133.5,0,235> }
object { Hierba scale <2.2,1,2.2> rotate 73*y translate <126,0,235> }
object { Hierba scale <.79,1.3,.79> rotate 25*y translate <-30.2,2.8,45> }
object { Hierba scale .8 rotate 25*y translate <-19,2.5,33> }
object { Hierba scale <.6,.8,.8> rotate -65*y translate <-19,2.5,27.8> }
object { Hierba scale <.39,.42,.39> rotate -95*y translate <-13.5,2.5,14.5> }

// ---- Hierba ----
object { Hierbas rotate 180*x scale <3.8,2.5,4> translate 25*y
  texture { tHierbas scale <64.5,25.1,1>  }
  translate <-400,-1.3,700> }

// ---- Piedras ----
object { Piedra texture { tPiedra1 }
rotate 130*y scale <5.4,3.8,4> translate <103,.5,241> }

object { Piedra texture { tPiedra3 }
rotate 180*x scale <.65,.45,.65> translate <-9.5,3.2,23> }

sphere { 0, .5 texture { tPiedra2 }
  scale <3,1.5,7>  rotate <15,0,-15>
  translate <-3.2,1.2,24.8> }

object { PBlob texture { tPiedra4 }
  scale <2,2,2> translate <-18,2,26> }

object { PBlob texture { tPiedra1 } scale <.6,.4,1>
  rotate 180*y translate <-5.4,2,22> }

sphere { 0, .5 texture { tPiedra1 }
  scale <4,3,4>  translate <1,-4.5,38> }

sphere { 0, .5 texture { tPiedra4 }
  scale <2.5,1.5,2> rotate -60*y translate <4,-4.8,36> }

// -- Golondrina --
object { Golon scale 2 rotate 40*y translate <29.5,0,72> }

// -- Globo --
object { Globo rotate -27*y scale 98 translate <1450,1720,5390> }

// -- Abeja --
object { Abeja scale 2 rotate -30*y translate <-4.5,18,26> }
