
// TEXTURAS

#declare tWater = texture {
  pigment { gradient z
    color_map {
      [0.00 rgbt<0, .1, .2, 1>]
      [0.04 rgbt<0, .1, .2, 1>]
      [0.06 rgb<0, .1, .2>]
      [1.00 rgb<0, .1, .2>] }
    scale <1, 1, 200> rotate 20*y
  }
  normal { bumps .01 }
  finish {
    reflection 0.75
    refraction 1
    ior 1.5
    phong 1
    phong_size 100 }
    scale 4 }

#declare tTierra = texture {
  pigment { bozo turbulence .8  octaves 3  omega .7
    color_map {
      [0 rgb<0, 0, 0>]
      [.1 rgb<.2, 0, 0>]
      [.15 rgb<.5, .188, .067>]
      [.20 rgb<.5, .188, .067>]
      [.50 rgb<.5, 0, 0>]
      [.55 rgb<.286, 0, 0>]
      [.90 rgb<.610, .259, .137>]
      [1 rgb<.559, .388, .298>]
    }
    scale .001 }
}

#declare tHierbaHf2 = texture {
   pigment { granite
     color_map {
       [ 0 rgb<0, .110, 0> ]
       [ .590 rgb<0, .110, 0> ]
       [ .601 rgb<0, .196, 0> ]
       [ .849 rgb<0, .196, 0> ]
       [ .899 rgb 0 ]
       [ 1 rgb 0 ]
     }
   }
   normal { bumps 1 turbulence .5 omega 2 lambda .5 }
   finish { diffuse .7 ambient .2 }
  scale .1
}

// ---- Heigh Field 1 ----
#declare tHf1 = texture { tTierra }
  texture { pigment { gradient y
   color_map {
      [0 rgbt<0, .1, 0, .4>]
      [0.1 rgbt<0, .1, 0, .5>]
      [0.51 rgbt<0, .1, 0, .5>]
      [0.52 rgbt<0, 0, 0, 1>]
      [1 rgbt<0, 0, 0, 1>] } }
}

// ---- Heigh Field 2 ----
#declare tHf2 = texture {
   material_map {
   gif "hf2cb.gif"
   map_type 0
   texture { tTierra }
   texture { tHierbaHf2 }
}    rotate 90*x }

// ---- Heigh Field 3 ----
#declare tHf3b = texture {
  pigment { rgb<.2,.05,.025> } }

  #declare tHf4 = texture {
   pigment { bozo
     color_map {
       [ 0 rgb<.2, .1, .1> ]
       [ 1 rgb<.22, .12, .1> ]
     }
     scale .1 }
   finish { diffuse .5 ambient .1 }
}

// ---- Diente de Leon ----

#declare tVilano1 = texture {
   pigment { rgb 1 }
   finish { diffuse 1 ambient .6 }
}

#declare tVilano2 = texture {
  pigment { radial frequency 9
    color_map {
      [0 rgb 0]
      [.4 rgb <.4,.1,0>]
      [.5 rgb <.6,.2,0>]
      [.6 rgb <.4,.1,0>]
      [1 rgb 0] } }
}

#declare tJunco = texture {
  pigment { rgb <.1,.05,0> }
  finish { diffuse .5 }
}

#declare tDL1 = texture {
   pigment { rgb < .5, .6, .4> }
   finish { diffuse .7 ambient .1 }
}

#declare tDL2 = texture {
   pigment { rgb <.1, .4, .1> }
   finish { diffuse .7 ambient .1 }
}

#declare tHojas2 = texture {
   pigment { rgb <.1, .2, .1> }
   finish { diffuse .7 ambient .1 }
   }

#declare tDL3 = texture {
   pigment { rgb <.5,.8,.3> }
   finish { diffuse .6 phong .5 phong_size 50 }
}

#declare tHoja = texture {
   pigment {
     image_map {
       gif "hoja2.gif"
       map_type 0
       transmit 88, 1
       interpolate 2 } }
   finish { diffuse .3 ambient .05 }
}

#declare tFlor2 = texture {
   pigment { rgb<1, 1, 0> }
   finish { diffuse 1 ambient .6 }
}

// -- Hierbas --
#declare tHierbas = texture {
   pigment {
     image_map {
       gif "hierbas1.gif"
       map_type 0
       transmit 19, 1
       interpolate 2
       }
   }
   finish { diffuse .7 }
}

// **** Globo ****

#declare tGlobo= texture {
   pigment { gradient z
     color_map {
       [ 0.0 rgb<0, 0, 0> ]
       [ 0.1 rgb<0, 0, 0> ]
       [ 0.1 rgb<1, 0, 0> ]
       [ 0.3 rgb<1, 0, 0> ]
       [ 0.3 rgb<0, 0, 0> ]
       [ 0.4 rgb<0, 0, 0> ]
       [ 0.4 rgb<1, 1, 1> ]
       [ 0.5 rgb<1, 1, 1> ]
       [ 0.5 rgb<0, 0, 0> ]
       [ 0.6 rgb<0, 0, 0> ]
       [ 0.6 rgb<1, 0, 0> ]
       [ 0.8 rgb<1, 0, 0> ]
       [ 0.8 rgb<0, 0, 0> ]
       [ 1.0 rgb<0, 0, 0> ]
     }
     scale <1,1,4>
     rotate -18*x
     translate -.48*z
   }
   finish {
     diffuse .8
     ambient .2
     specular .4
     roughness .01 }
}

#declare tCables = texture {
   pigment { rgb .6 }
   finish { diffuse 1 ambient .5 }
}

#declare tMetal = texture {
   pigment { rgb<.1, .1, .2> }
   finish { diffuse .7 ambient .2 phong 1 phong_size 50 }
}

#declare tBarquilla1 = texture {
   pigment { image_map { gif "mimbre.gif" map_type 0 } }
   finish { diffuse .7 }
}

#declare tBarquilla2 = texture {
   pigment { rgb<.5, .2, 0> }
   finish { diffuse .6 ambient .2 }
}

#declare tPiel = texture {
   pigment { rgb<.727, .485, .267> }
   finish { diffuse .7 ambient .2 }
}

#declare tBoca = texture {
   pigment { rgb<.63, .39, 0.17> }
   finish { diffuse .5 ambient .2 phong .35 phong_size 20 }
}

#declare tPelo = texture {
   pigment { rgb<.1, .1, 0> }
   normal { bumps 1 turbulence .5 omega 2 lambda .5 }
   finish { diffuse .7 ambient .2 phong .3 phong_size 10 }
}

#declare tRopa = texture {
   pigment { rgb<.05, 0, .1> }
   finish { diffuse .6 ambient .1 }
}

// **** Piedras ****

#declare tPiedra1 = texture {
   pigment {
     granite
     color_map {
       [ 0.000 rgb<0.301, 0.301, 0.301> ]
       [ 0.302 rgb<0.301, 0.301, 0.301> ]
       [ 0.306 rgb<0.4, 0.4, 0.4> ]
       [ 0.687 rgb<0.4, 0.4, 0.4> ]
       [ 0.698 rgb<0.502, 0.502, 0.502> ]
       [ 1.000 rgb<0.502, 0.502, 0.502> ]
     }
     frequency 2
     scale .1
   }
   finish { diffuse .6 ambient .1 }
}

#declare tPiedra2 = texture {
   pigment { granite
     color_map {
       [ 0 rgb<0.05, 0.05, 0.05> ]
       [ .698 rgb<0.05, 0.05, 0.05> ]
       [ .698 rgb<0.39, 0.39, 0.39> ]
       [ 1 rgb<0.39, 0.39, 0.39> ]
     }
     scale .05
   }
    finish { diffuse .6 ambient .2
     phong .1 phong_size 5
   }
}

#declare tPiedra3 = texture {
   pigment {
     granite
     color_map {
       [ 0 rgb<0.449, 0.276, 0.152> ]
       [ 0.198 rgb<0.449, 0.276, 0.152> ]
       [ 0.399 rgb<0.779, 0.573, 0.425> ]
       [ 0.601 rgb<0.779, 0.573, 0.425> ]
       [ 0.701 rgb<0.700, 0.447, 0.266> ]
       [ 1 rgb<0.700, 0.447, 0.266> ]
     }
     scale .1 }
   finish { diffuse .5 ambient .05 }
}

#declare tPiedra4 = texture {
   pigment {
     granite
     color_map {
       [ 0 rgb<0.300, 0.300, 0.300> ]
       [ 0.345 rgb<0.300, 0.300, 0.300> ]
       [ 0.399 rgb<0.690, 0.690, 0.690> ]
       [ 0.493 rgb<0.690, 0.690, 0.690> ]
       [ 0.550 rgb<0.483, 0.483, 0.483> ]
       [ 1 rgb<0.483, 0.483, 0.483> ]
     }
     scale .05 }
   finish { diffuse .6 ambient .1 }
}
