#include "colors.inc"
#include "shapes.inc"
#include "textures.inc"
#include "metals.inc"

declare part01 =
union { sphere { <0,0,-12> 3.3}
        torus {3.3,.2 rotate x*90 translate <0,0,-12>}
              cylinder { <0,0,-11.8>, <0,0,-12.2>,3.3}
        difference{
                   #declare HT=sqrt(pow((3.3+2.2),2)-pow((3.1),2))
                   #declare HC=HT*3.5/(3.3+2.2)
                   #declare RC=3.1*3.5/(3.3+2.2)
                   #declare HT01=HT-12
                   #declare RC01=RC-12
                   cylinder { <0,0,-6.09>, <0,0,RC01>,RC}
                   torus {3.1,2.2 rotate x*90 translate <0,0,HT01>}
                   }
        #declare Scale01 = 0.8/0.7
        #declare Scale02 = 0.7/0.6
        torus {1.2,.6 scale <1,Scale02,1> rotate x*90 translate <0,0,-5.4>}
              cylinder { <0,0,-5.4>, <0,0,-6.1>,1.2}
        torus {1.8,.7 scale <1,Scale01,1> rotate x*90 translate <0,0,-4.6>}
        #declare Scale03 = 1.8/1.1
        torus {2.5,1.1 scale <1,Scale03,1> rotate x*90 translate <0,0,-2.8>}
        torus {3.6,.2 rotate x*90 translate <0,0,-2.8>}
              cylinder { <0,0,-2.6>, <0,0,-3.0>,3.6}
        torus {2,.5 scale <1,2,1> rotate x*90 translate <0,0,-1>}
       }

#declare part02 =
union { sphere {<0,0,0>,1.8}
        difference{
                   #declare HTT=sqrt(pow((1.8+1.2),2)-pow((1.9),2))
                   #declare HCC=HTT*1.8/(1.8+1.2)
                   #declare RCC=1.9*1.8/(1.8+1.2)
                   cylinder {<0,0,3.8>, <0,0,RCC>,RCC}
                   torus {1.9,1.2 rotate x*90 translate <0,0,HTT>}
                   }
         #declare HTT2 = (HTT*2)
         difference{
                    sphere {<0,0,HTT2>,1.8}
                    box {<-2,2,3.8>,<2,-2,8>}
                    }
         #declare subs01=
         difference{
                   #declare HTT=sqrt(pow((1.8+1.2),2)-pow((2.1),2))
                   #declare HCC=HTT*1.8/(1.8+1.2)
                   #declare RCC=2.1*1.8/(1.8+1.2)
                   cylinder {<HTT,0,0>, <RCC,0,0>,RCC}
                   torus {2.1,1.2 rotate z*90 translate <HTT,0,0>}
                   }
         object {subs01}
         object {subs01 rotate y*180}
         cylinder { <-2.4,0,0>, <2.4,0,0>,.9}
             }
#declare rod01 =
cylinder {<0,0,0>, <0,0,-62>,1.5}

#declare rod02=
#declare T_Length = 90-3
#declare Height = 4.4
#declare Thickness = 0.7
#declare R_Height = (Height-2*Thickness)
#declare NoWaves = 1
#declare NoSegments = 36
#declare SAngle = pi/2
#declare B = (T_Length/(NoWaves*NoSegments))
#declare Angle = ((2*pi)/NoSegments)
#declare X1 = 0
#declare Y0 = (R_Height*sin(SAngle))
#declare Y1 = 0
#declare Z = 0
#declare Count = NoSegments*NoWaves
blob{threshold 0.6
     #while (Count>=1)
     #declare X2 = (X1 + B)
     #declare SAngle = (SAngle + Angle)
     #declare Y2 = (R_Height*sin(SAngle))-Y0
     cylinder {<X1,Y1,Z>,<X2,Y2,Z>,Thickness,100}
     #declare X1 = X2
     #declare Y1 = Y2
     #declare Count=Count-1
     #end
     }

#declare rod03 =
cylinder {<0,0,0>, <90,0,0>,.45}

#declare rod04 =
cylinder {<0,0,0>, <90,0,0>,.7}

#declare part03=
         union {
               cylinder {<0,0,0>, <0,0,29>,.375}
               object {part02
               scale <0.75,0.75,0.75>}
                }
#declare part031=
         union {
               cylinder {<0,0,0>, <0,0,62>,.375}
               object {part02
               scale <0.75,0.75,0.75>}
                }

#declare part04=
         union {
               torus {1.5,.5 scale <1,2,1> rotate x*90 translate <0,0,-1>}
               cylinder {<0,0,0>, <0,0,-2>,1.5}
               }

#declare B_Green=
         texture{
                 finish { F_MetalA }
                 normal { waves 0.35 frequency 2 scale 0.01 }
                 pigment { DkGreenCopper }
                 }

#declare FRONT01 =
union {
         object {rod01
                translate <0,0,-2>}
         object {rod01
                translate <90,0,-2>}
         object {rod03
                translate <1.5,0,-53>}
         object {rod04
                translate <1.5,0,-24>}
         #declare Count = 4
         #declare DDi=15
         #declare DD0=DDi
         #while (Count>=0)
                object {part03
                translate <DDi,0,-53>}
                #declare DDi=DDi+DD0
                #declare Count=Count-1
                #end
         texture { B_Green }
       }

#declare FRONT02 =
union {object {part01
              scale <0.75,0.75,0.75>
              translate <0,0,-64>}
        object {part01
              scale <0.75,0.75,0.75>
              translate <90,0,-64>}
        object {rod02
             rotate x*90
             translate <1.5,0,-60>}
        object {part04}
        object {part04
              translate <90,0,0>}
        texture { T_Brass_5C }
       }
#declare RARE01 =
union {
         object {rod01
                scale <1,1,1.5>
                translate <0,193,-2>}
         object {rod01
                scale <1,1,1.5>
                translate <90,193,-2>}
         object {rod03
                translate <1.5,193,-86>}
         object {rod04
                translate <1.5,193,-24>}
         #declare Count = 4
         #declare DDi=15
         #declare DD0=DDi
         #while (Count>=0)
                object {part031
                translate <DDi,193,-86>}
                #declare DDi=DDi+DD0
                #declare Count=Count-1
                #end
         texture { B_Green }
       }

#declare RARE02 =
union {object {part01
              scale <0.75,0.75,0.75>
              translate <0,193,-95>}
        object {part01
              scale <0.75,0.75,0.75>
              translate <90,193,-95>}
        object {rod02
             rotate x*90
             translate <1.5,193,-91>}
        object {part04
              translate <0,193,0>}
        object {part04
              translate <90,193,0>}
        texture { T_Brass_5C }
       }

#declare FRONT =
union {object {FRONT01}
       object {FRONT02}
      }

#declare RARE =
union {object {RARE01}
       object {RARE02}
      }

#declare BED01=
union{
object {FRONT}
object {RARE}
box {<0,1.5,-20>,<90,191.5,-25>texture {B_Green}}
translate <5,300,0>
}
// box {<5,490,-30>,<100,310,-40>}
// object {BED01}
