#include "colors.inc"
#include "shapes.inc"
#include "textures.inc"
#include "metals.inc"
#include "r02.pov"


background { color red .07 green .1 blue .15 }

camera {
        location <300, 80, -420>
        angle 45
        sky  <0, 0, -1>
        look_at <100,500,-120>
        }

light_source {
    <350, 30, -500 > color rgb <.8,.83,.86>
    spotlight
    point_at <30, 470, -80>
    tightness 10
    radius 15
    falloff 30
    fade_distance 550
    fade_power 1
    area_light <5, 0, 0>, <0, 0, 5>, 4, 4
    adaptive 1
    jitter
}

light_source
{<350, 1000, -800 > color rgb <.95,.95,.97>
    area_light <3, 0, 0>, <0, 0, 3>, 3, 3
    adaptive 1
    jitter
}


difference{
           box {<-50,-50,0>,<550,550,-500>}
           box {<0,0,10>,<500,500,-510>}
           box {<170,490,-90>,<270,560,-240>}
              texture {
   finish {
      ambient color rgb <0.21,0.21,0.25>
      diffuse 0.8
      phong 0.5
      phong_size 60
      }
   normal {bumps 0.085 scale 5}
   pigment { rgb <1, 1, 1> }
   }
}

union{
      cylinder {<220,534,-165>,<220,531,-165>,.5}
      sphere {<0,0,0>,1 scale <5,1,2> translate <222,531,-165>}
      texture { T_Brass_5C }
      }

declare Window01=
union{
      box {<216,534,-90>,<224,540,-240>}
      box {<170,535,-90-(140/3)+2>,<270,540,-90-(140/3)-2>}
      box {<170,535,-90-(140/3)*2+2>,<270,540,-90-(140/3)*2-2>}
      difference{
           box {<170,535,-90>,<270,540,-240>}
           box {<175,530,-95>,<265,550,-235>}}
              texture {
   finish {
      ambient 0.2
      diffuse 0.9
      phong 0.4
      phong_size 60
      }
   pigment { rgb <1, 1, 1> }
   }
}

#declare Glass=
texture {
    finish {ambient 0.1
            diffuse 0.1
            reflection .25
            refraction 1
            ior 1.5
            specular 1
            roughness 0.001}
            normal {bumps 0.05 scale <3,3,10>}
    pigment { color rgbf <0.85, 0.9, 0.87, 0.87> }
}

#declare Window02=
        box {<170,537,-90>,<270,538,-240>
        texture {Glass}
        }

#declare WIN=
merge {object {Window01}
      object {Window02}
      }

object {WIN}

box {<-50,-50,-500>,<550,550,-510>
              texture {
   finish {
      ambient 0.1
      diffuse 0.5
      phong 0.5
      phong_size 40
      }
   pigment { rgb <.7,.71,.73> }
   }
}
#declare Board01=
difference {
            union { box {<1,0,0>,<-1,7,-1>}
                    box {<0,0,0>,<-1.75,6,-1>}
                    cylinder {<-1,6,0>,<-1,6,-1>.5}
                    cylinder {<0,7,0>,<0,7,-1>.5}}
            cylinder {<-1,7,1>,<-1,7,-2>.5}
            box {<0.25,-1,1>,<2,8,-2>}
            translate <-.25,0,0>
            rotate x*-90
            rotate z*90
            }
union {
object { Board01
         scale <500,1,1>
         translate <0,500,0>}
object { Board01
         scale <500,1,1>
         rotate z*90}
texture {WOOD01}
}

#include "room03.pov"
object {BAN}

#include "f01.pov"
object { head02 rotate x*15 rotate z*35 scale 7 translate <35, 470, -87> }

object {FINGERS scale 2.5  rotate x*75 rotate y*-35 translate <52, 458, -81>
       texture {
               finish {
                      ambient 0.5
                      diffuse 0.5
                      phong 0.5
                      phong_size 40
                      }
                pigment { rgb <1,.8,.7> }
                }
        }

#include "f02.pov"
object {bb03 rotate z*15 translate <68,471,-40>}

#include "body01.pov"
