#include "colors.inc"
#include "metals.inc"
#include "golds.inc"

sky_sphere {
  pigment {
    gradient y
    color_map {
      [ 0 color rgb <1, 1, 1> ]
      [ 1 color rgb <0,0,0> ]
      }
      scale 2
      translate -1
    }
}

camera{location <0,-40,-10>
       angle 15
       up <0, 0, 1>
       sky  <0, 0, 1>
       right <1.333, 0, 0>
       look_at <0,0,1.5>
      }

light_source{<10,-50,10> color rgb<1,1,1>}

box {<-6.8,6,-10><6.8,7,10> texture {
                            finish {
                                   ambient 1
                                   diffuse 1}
                            pigment {color rgb <1,1,1>}
                            }
    }

#declare tg15 = tan(pi/18) // 10 degrees not 15
#declare tg30 = tan(pi/12) // 15 degrees not 30
#declare H01 = 1.1
#declare H02 = 2.2
#declare R01 = 3
#declare R02 = R01 + (tg15*(H01*0.2))
#declare R03 = R01 + (tg15*(H01*0.5))
#declare R04 = R01 + (tg15*(H01*0.8))
#declare R11 = R01 + (tg15*(H01))
#declare R12 = R11 + (tg30*(H02))
#declare TH = 0.03
#declare TH01 = TH/(cos(pi/12))
#declare TH02 = TH/(cos(pi/6))
#declare iR01 = R01 - TH01
#declare iR02 = iR01 + (tg15*(H02*1.2))
#declare iR11 = R11 - TH02
#declare iR12 = iR11 + (tg30*(H02*1.2))

#declare Count = 12
#declare CR = R12-(TH02/2)
#declare sA = (2*pi)/Count
#declare sA01 = 0
#declare sR01 = 0.15
#declare sH = H02

#declare C01 =
   union{
      #while (Count > 0)
         sphere{<0,0,0>,sR01
         translate <CR*cos(sA01),CR*sin(sA01),sH>}
         #declare sA01 = sA01 + sA
         #declare Count = Count - 1
      #end
   }

#declare Count = 12
#declare CR = R03
#declare sA = (2*pi)/Count
#declare sA01 = 0
#declare sR01 = 0.1
#declare sH = H01*0.5

#declare C02 =
   union{
      #while (Count > 0)
         sphere{<0,0,0>,sR01*1.5
         translate <CR*cos(sA01),CR*sin(sA01),sH>}
         #declare sA01 = sA01 + sA
         #declare Count = Count - 1
      #end
   }
      
#declare Tri01 =
   prism{
      linear_sweep
      linear_spline
      R12*-1.2
      R12*1.2
       6
   <-.5,0>,<-.5,.5>,<.5,.5>,<.5,0>,<0,-1>,<-.5,0>
}

#declare Count = 12
#declare CR = R12
#declare sA = (2*pi)/(Count)
#declare sA01 = 0
#declare X_scale=CR*sin(sA/2)*2

#declare Tri =
   union{
      #while (Count > 0)
         object {Tri01
                scale <X_scale,1,H02-H01>
                rotate z*(degrees(sA01))
                translate <0,0,H02>}
         #declare sA01 = sA01 + sA
         #declare Count = Count - 1
      #end
      cylinder{<0,0,H02*.999><0,0,H02*1.2>,R12*1.2}
      rotate z*(degrees(sA/2))
   }
   
#declare K01=
union{
      object{C01}
difference{
   union{
      cone{<0,0,0>,R01,<0,0,H01>,R11}
      cone{<0,0,H01>,R11,<0,0,H02>,R12}
      object{C02}
      torus {R02,sR01 rotate x*90 translate <0,0,H01*0.2>}
      torus {R04,sR01 rotate x*90 translate <0,0,H01*0.8>}
   }
   union{
      cone{<0,0,0>,iR01,<0,0,H02*1.2>,iR02}
      cylinder{<0,0,0.1>,<0,0,-1>,iR01}
      cone{<0,0,H01>,iR11,<0,0,H02*1.2>,iR12}
      torus {R02-TH01,sR01 rotate x*90 translate <0,0,H01*0.2>}
      torus {R04-TH01,sR01 rotate x*90 translate <0,0,H01*0.8>}
      object {Tri}
   }
}
// texture{T_Silver_3E}
texture{T_Gold_5E}
}
object {K01}
