#include "colors.inc"
// #include "shapes.inc"
// #include "textures.inc"
// #include "metals.inc"
// #include "woods.inc"
#include "bed01.pov"
#include "f02.pov"
#include "curt01.inc"

#declare TEX01=
texture{
   finish{ ambient .5
           diffuse .8
           phong 0.2
           phong_size 20
   }
   pigment{ color rgb <0.8,0.8,0.8>}
}

#declare TEX02=
texture{
   finish{ ambient .5
           diffuse .8
           phong 0.2
           phong_size 20
           reflection .2
   }
   pigment{ color rgbt <1,1,1,0.8>}
}

#declare FABRIC03=
         texture {
          finish {
               ambient <0.63,0.6,0.4>
               diffuse 0.8
               specular 0.2 roughness 0.3
               }
          normal {bumps 0.3 scale <5,5,20>}
          pigment {color rgbf <1,1,1,.2>}
          }

#declare WOOD01=
 texture {
 pigment {
           wood
           frequency .5
           turbulence 0.1
           octaves 3
           scale <0.03,.3,.03>
           color_map {
             [0.0, 0.1 color rgb <1, 0.87, 0.70>
                       color rgb <1, 0.87, 0.70>]
             [0.1, 0.9 color rgb <1, 0.87, 0.70>
                       color rgb <1*.75, 0.87*.75, 0.70*.75>]
             [0.9, 1.0 color rgb <1*.75, 0.87*.75, 0.70*.75>
                       color rgb <1*.75, 0.87*.75, 0.70*.75>]
            }
          }
          finish {
            ambient 0.4
            diffuse 0.6
            phong 0.2
            phong_size 20
}
}

#declare RING01=
torus{3,.4 rotate x*90 rotate y*90 translate <0,0,-1.1>}

#declare Ang = seed (0)
#declare RING02=
union{
   object {RING01 rotate z*((0.5-rand(Ang))*20) translate <-49,0,0>}
   object {RING01 rotate z*((0.5-rand(Ang))*20) translate <-44,0,0>}
   object {RING01 rotate z*((0.5-rand(Ang))*20) translate <-42,0,0>}
   object {RING01 rotate z*((0.5-rand(Ang))*20) translate <-36,0,0>}
   object {RING01 rotate z*((0.5-rand(Ang))*20) translate <-32,0,0>}
   object {RING01 rotate z*((0.5-rand(Ang))*20) translate <-28,0,0>}
   object {RING01 rotate z*((0.5-rand(Ang))*20) translate <-26,0,0>}
   object {RING01 rotate z*((0.5-rand(Ang))*20) translate <-22,0,0>}
   object {RING01 rotate z*((0.5-rand(Ang))*20) translate <-18,0,0>}
   object {RING01 rotate z*((0.5-rand(Ang))*20) translate <-14,0,0>}
   object {RING01 rotate z*((0.5-rand(Ang))*20) translate <24,0,0>}
   object {RING01 rotate z*((0.5-rand(Ang))*20) translate <26,0,0>}
   object {RING01 rotate z*((0.5-rand(Ang))*20) translate <30,0,0>}
   object {RING01 rotate z*((0.5-rand(Ang))*20) translate <32,0,0>}
   object {RING01 rotate z*((0.5-rand(Ang))*20) translate <34,0,0>}
   object {RING01 rotate z*((0.5-rand(Ang))*20) translate <38,0,0>}
   object {RING01 rotate z*((0.5-rand(Ang))*20) translate <40,0,0>}
   object {RING01 rotate z*((0.5-rand(Ang))*20) translate <42,0,0>}
   object {RING01 rotate z*((0.5-rand(Ang))*20) translate <46,0,0>}
   object {RING01 rotate z*((0.5-rand(Ang))*20) translate <48,0,0>}
texture{WOOD01}
}

#declare CURT02=
union{
   object {RING02}
   object {CURT01 scale <.5,1.5,.7>
                  texture{FABRIC03}
                  translate <0,0,-4.1>}
rotate x*-15
}

#declare SPADE01=
union{
   torus{1.5,.3 rotate x*90 translate <0,0,.3>}
   torus{1.5,.3 rotate x*90 translate <0,0,1.7>}
   cylinder{<0,0,0.3><0,0,1.7>,1.8}
   sphere{<0,0,3>,1.5}
   sphere{<0,0,5.5>,1.3}
   sphere{0,1 scale<.7,.5,7> translate <0,0,10>}
   difference{
      box{<-5,-0.2,0><5,0.2,20>}
      cylinder{<0,-1,0><0,1,0>,1 scale <5,1,10> translate <-5,0,0>}
      cylinder{<0,-1,0><0,1,0>,1 scale <5,1,10> translate <5,0,0>}
      cylinder{<0,-1,0><0,1,0>,1 scale <5,1,10> translate <-5,0,20>}
      cylinder{<0,-1,0><0,1,0>,1 scale <5,1,10> translate <5,0,20>}
      scale<.8,1,1> translate <0,0,2>
   }
texture{T_Brass_5C}
}

#declare MOUNT01=
difference{
   union{
      torus{1.5,.5 rotate x*90 translate <0,0,1.5>}
      torus{1.5,.5 rotate x*90 translate <0,0,-1.5>}
      cylinder{<0,0,-1.5><0,0,1.5>,2}
      cylinder{<0,0,0><0,10,0>,1.5}
      sphere{<0,10,0>,2.5}
   rotate y*90
   }
   box{<-3,-1.5,0>,<3,1.5,3>}
texture{T_Brass_5C}
}

#declare ROD01=
cylinder {<60,-10,0>,<-60,-10,0>,1.5
texture {WOOD01}
}

#declare CURT03=
union{
   object {SPADE01 rotate y*90 translate <60,-10,0>}
   object {SPADE01 rotate y*-90 translate <-60,-10,0>}
   object {MOUNT01 translate <55,-10,0>}
   object {MOUNT01 translate <-55,-10,0>}
   object {ROD01}
   object {CURT02 translate <0,-10,0>}
rotate y*180
translate <220,500,-270>
}

object {CURT03}

#declare FRAME01=
union{
   difference {
      union {box {<0.1,-0.1,0>,<-3,3,1>}
             cylinder {<-3,0,0>,<-3,0,1>.7}
             cylinder {<0,3,0>,<0,3,1>.7}
             }
      cylinder {<-3,3,-1>,<-3,3,2>2}
      }
   box {<-3.7,0,0>,<.7,-.7,1>}
   box {<0,3.7,0>,<.7,0,1>}

texture {T_Brass_5C}
translate <-.7,.7,0>
}

#declare FRAME02=
union{
object {FRAME01 rotate z*-90 scale <1,1,63> translate y*-54}
object {FRAME01 rotate z*180 scale <1,1,63>}
object {FRAME01 rotate z*-90 scale <1,1,54> rotate x*90}
object {FRAME01 rotate z*180 scale <1,1,54> rotate x*90 translate z*63}
}

object {FRAME02 rotate x*90 translate<0.3,420,-150>}

#declare PICT01=
 union{
   box{<-61,-52,0><-2,-2,.1>
      texture{TEX01 pigment {image_map {tga "butt.tga"} scale 40 translate <-12,-8,0>}}}
   difference{
      box{<-61,-52,.1><-2,-2,.3>}
      box{<-51,-42,1><-12,-12,-1>}
         texture{TEX01}
      }
   box{<-61,-52,.3><-2,-2,.7> texture{TEX02}}
rotate x*90
rotate z*90
translate<0,420,-150>}

object{PICT01}

#declare PLANK01=
union {
   box{<0.5,-10,0><24.5,510,1>}
   cylinder{<0.5,-10,0.5><0.5,510,0.5>.5}
   cylinder{<24.5,-10,0.5><24.5,510,0.5>.5}
}

#declare XXX=0
#declare Count=20
#declare FLOOR01=
union{
   box{<0,-10,.5><510,510,3> texture {WOOD01}}
#while (Count>0)
   object {PLANK01 translate x*XXX texture {WOOD01}}
   #declare XXX=XXX+25
   #declare Count=Count-1
#end
}

object{FLOOR01}

#declare MAT01=
union {
   box{<3,3,0><87,187,-6>}
   sphere{<3,3,-3>,3}
   sphere{<87,3,-3>,3}
   sphere{<3,187,-3>,3}
   sphere{<87,187,-3>,3}
   cylinder{<3,3,-3><87,3,-3>,3}
   cylinder{<3,187,-3><87,187,-3>,3}
   cylinder{<3,3,-3><3,187,-3>,3}
   cylinder{<87,3,-3><87,187,-3>,3}
scale <1,1,15/6>
translate <5,301.5,-25>
texture{FABRIC02}
}
object {MAT01}
object {BED01}
