// POV-Ray 3.0 scene file by Ian Armstrong   -  Nov 1996
//
// Subject: Flight Scene
// Entry for IRTC competition Nov/Dec 1996
//
// (c) 1996 Ian Armstrong (iarmstrong@cix.compulink.co.uk)
//
//
#include "colors.inc"
#include "textures.inc"
#include "woods.inc"
#include "stones.inc"

#declare Area_Lights = 1

/* ==== Cameras ==== */

#declare Camera1 =    // Main view
camera {
  location <0, 11, -34>
  direction <0, 0,  2.25>
  right x*1.33
  look_at <0,6,0>
}
#declare Camera2 =    // Ground level view
camera {
  location <0, 3, -34>
  direction <0, 0,  2.25>
  right x*1.33
  look_at <0,6,0>
}

camera { Camera1 }

/* ==== Lights ==== */

light_source {< -30, 30, -50> color White	        	// Left Side Light
  fade_distance 30 fade_power 2
}

light_source {< 0, 10, -100> color 0.6*White        // Front Light
  shadowless
  fade_distance 200 fade_power 2
}

#ifdef (Area_Lights)
  light_source {< 100, 1000,  -100> color 0.5*White		// Top Light
    area_light <50, 0, 0>, <0, 0, 50>, 2, 2
    adaptive 1
    jitter
  }

  light_source {< 100, 1000,  -100> color 0.5*White		// Top Light
    area_light <1000, 0, 0>, <0, 0, 1000>, 2, 2
    adaptive 1
    jitter
  }

#else
  light_source {< 100, 1000,  -100> color White }		  // Top Light
#end

/* ==== Scenery ==== */

#declare Grass =      // taken from Cork texture
texture {
  pigment {
    granite
    color_map {
      [0.00, 0.60 color rgb <0.71, 0.93, 0.532>
                  color rgb <0.81, 0.98, 0.60>]
      [0.60, 0.65 color rgb <0.30, 0.50, 0.20>
                  color rgb <0.30, 0.50, 0.20>]
      [0.65, 1.00 color rgb <0.40, 0.83, 0.46>
                  color rgb <0.75, 0.85, 0.35>]
  }
}
  finish{ 
    roughness 0.5
    ambient 0.3
    diffuse 0.4
  }
  scale 0.25
}

#declare Grass_Tex =
texture { 
  Grass scale <2,2,2>
  normal { wrinkles 1 scale 12}
} 
#declare Mud_Tex =
texture { 
  Cork scale <2,2,2>
  normal { wrinkles .7 scale 12}
} 
#declare Ground =
difference {
  union {
    plane { <0, 1, 0>, 0}     // field
    height_field {            // distant hills
    	tga "hills.tga"
    	smooth
    	scale <500, 30, 200>
    	translate <-400, -0.5, 1000>
    }
    texture { Grass_Tex }
  }
  sphere { <0,0,0>,1          // mud patch around the hangar door
    texture {
      onion
      frequency 0.99
      texture_map {
        [0.0 Mud_Tex scale 1/30 ]
        [0.7 Mud_Tex scale 1/30 ]
        [1.0 Grass_Tex scale 1/30 ]
      }
      scale <1,2,1>
      ramp_wave
    }
    scale <30,.2,30> rotate 30*y translate <30,0,200>
  }
}

fog {color White distance 1550 }

#declare Sky =
difference {
  sphere { <0,0,0>,1}
  sphere { <0,0,0>,0.98}

  texture {
    pigment { Blue_Sky3 }
    finish {reflection 0.0 diffuse 0.0 ambient 1.0}
  }
  scale <2500,500,2500>
  no_shadow
}

/* **** Build the model **** */

#include "hart.inc"

#include "bldngs.inc"

#include "trees.inc"

union {

      object { Ground }
      object { Sky }
//-- Main subject
      object { Flying_Hart scale .4 rotate <0,30,0> translate <-6.5,6,5> }

//-- Harts in the air
      object { Flying_Hart scale .4 rotate <10,50,0> translate <-15,22,200> }
      object { Flying_Hart scale .4 rotate <20,70,0> translate <-130,45,600> }

//-- Harts on the ground
      object { Static_Hart scale .4 rotate <0,-60,0> translate <-35,0,100> }
      object { Static_Hart scale .4 rotate <0,-60,0> translate <-10,0,100> }
      object { Static_Hart scale .4 rotate <0,-60,0> translate <22,0,100> }

//-- Scenery
      object { Shed rotate 30*y scale 0.4 translate <30,0,200> }
      object { Hut rotate 10*y scale 0.3 translate <-50,0,200> }
      object { Hut rotate 10*y scale 0.3 translate <-70,0,200> }
      object { Complete_Tree scale 1 rotate 0*y translate <-90,0,300> }
      object { Complete_Tree scale 1 rotate 75*y translate <-70,0,300> }
      object { Complete_Tree scale 1 rotate 135*y translate <-35,0,350> }

}


