// Daedalus.inc
// Include file for ICARUS, entry to Dec96 POVRAY Competition
// Copyright The Butter-Fingered Juggler


// ---------------------------------------
// Basic Body Shape

#declare Head = difference {

union {

blob {
	threshold 0.5
	component 1.0, 0.9, <0.2, 0.3, -0.1>	// main head
	component 1.0, 0.9, <-0.2, 0.3, -0.1>
	component 1.0, 0.9, <0.2, -0.3, -0.1>
	component 1.0, 0.9, <-0.2, -0.3, -0.1>
	component 1.0, 0.8, <0.2, 0.3, 0.3>	// back of skull
	component 1.0, 0.8, <-0.2, 0.3, 0.3>
	component 1.0, 0.8, <0.2, -0.2, 0.3>
	component 1.0, 0.8, <-0.2, -0.2, 0.3>
	component 1.0, 0.4, <0, -1, -0.3>	// jaw
	component 1.0, 0.4, <0.2, -0.9, -0.3>
	component 1.0, 0.4, <-0.2, -0.9, -0.3>
	component 1.0, 0.4, <0.3, -0.9, -0.2>
	component 1.0, 0.4, <-0.3, -0.9, -0.2>
	component 1.0, 0.4, <0.4, -0.8, -0.1>
	component 1.0, 0.4, <-0.4, -0.8, -0.1>
	component 1.0, 0.3, <0.4, -0.7, 0>
	component 1.0, 0.3, <-0.4, -0.7, 0>
	component 1.0, 0.2, <0.4, -0.6, 0.1>
	component 1.0, 0.2, <-0.4, -0.6, 0.1>
	component 1.0, 0.4, <0.25, -0.65, -0.35>	// cheeks
	component 1.0, 0.4, <-0.25, -0.65, -0.35>
	component 1.0, 0.4, <0.3, -0.6, -0.2>
	component 1.0, 0.4, <-0.3, -0.6, -0.2>
	component 1.0, 0.35, <0, -0.25, -0.6>	// nose
	component 1.0, 0.2, <0, -0.4, -0.8>
	component 1.0, 0.1, <0.15, -0.45, -0.7>	// nostrils
	component 1.0, 0.1, <-0.15, -0.45, -0.7> 	
	component -1.0, 0.3, <0.25, -0.2, -0.85>	// eye sockets
	component -1.0, 0.3, <-0.25, -0.2, -0.85>
	component -1.0, 0.1, <0.2, -0.15, -0.7>
	component -1.0, 0.1, <0.2, -0.15, -0.7>
texture {Skin}
}

// left ear
sphere {<0, 0, 0>, 0.2
	scale <0.6, 1.3, 0.2>
	rotate <0, 0, -25>
	rotate <0, -50, 0>
	translate <0.785, -0.15, -0.1>
		
texture {Skin}
} 

// right ear
sphere {<0, 0, 0>, 0.2
	scale <0.6, 1.3, 0.2>
	rotate <0, 0, 25>
	rotate <0, 50, 0>
	translate <-0.785, -0.15, -0.1>
		
texture {Skin}
} 

object {Eye
	translate <0.3, -0.15, -0.5>} 
object {Eye
	translate <-0.3, -0.15, -0.5>}

// Eye brow left
union {

sphere {<0.2, 0, -0.7>, 0.05}
sphere {<0.23, 0.02, -0.7>, 0.045}
sphere {<0.26, 0.02, -0.7>, 0.04}
sphere {<0.29, 0.01, -0.7>, 0.04}
sphere {<0.32, 0, -0.7>, 0.035}
sphere {<0.34, 0, -0.69>, 0.03}
sphere {<0.36, 0, -0.68>, 0.03}
sphere {<0.38, 0, -0.68>, 0.03}

pigment {color Gray70}
}

// Eye brow Right
union {

sphere {<-0.2, 0, -0.7>, 0.05}
sphere {<-0.23, 0.02, -0.7>, 0.045}
sphere {<-0.26, 0.02, -0.7>, 0.04}
sphere {<-0.29, 0.01, -0.7>, 0.04}
sphere {<-0.32, 0, -0.7>, 0.035}
sphere {<-0.34, 0, -0.69>, 0.03}
sphere {<-0.36, 0, -0.68>, 0.03}
sphere {<-0.38, 0, -0.68>, 0.03}

pigment {color Gray70}
}

// hair/beard
// thousands (!) of spheres used
union {

sphere {<0, 1, 0>, 0.2}
sphere {<0.3, 0.97, 0>, 0.2}
sphere {<-0.3, 0.97, 0>, 0.2}
sphere {<0.5, 0.92, 0>, 0.2}
sphere {<-0.5, 0.92, 0>, 0.2}
sphere {<0.65, 0.84, 0>, 0.2}
sphere {<-0.65, 0.84, 0>, 0.2}
sphere {<0.68, 0.68, 0>, 0.2}
sphere {<-0.68, 0.68, 0>, 0.2}
sphere {<0.66, 0.52, 0>, 0.2}
sphere {<-0.66, 0.52, 0>, 0.2}
sphere {<0.68, 0.36, 0>, 0.2}
sphere {<-0.68, 0.36, 0>, 0.2}

pigment {color Gray70}
}

} // end head union

// this is diff'd from main head
// mouth
sphere {<0, 0, 0>, 0.3
	scale <1.2, 0.25, 1>
	translate <0, -0.8, -0.7>
	pigment {color rgb <0.95, 0.6, 0.4>}
}

} // end head diff

// -----------------------------------------------------
// Wings

#declare WingD = union {
// top row
object {Feather
	translate <-0.5, -0.05, 0>}
object {Feather
	translate <-1, -0.05, 0>}
object {Feather
	translate <-1.5, -0.1, 0>}
object {Feather
	translate <-2, -0.15, 0>}
object {Feather
	translate <-2.5, -0.2, 0>}
object {Feather
	translate <-3, -0.25, 0>}
object {Feather
	translate <-3.5, -0.3, 0>}
object {Feather
	rotate <0, 0, -10>
	translate <-3.75, -0.3, 0>}
object {Feather
	rotate <0, 0, -20>
	translate <-4, -0.3, 0>}
object {Feather
	rotate <0, 0, -30>
	translate <-4.25, -0.3, 0>}
object {Feather
	rotate <0, 0, -40>
	translate <-4.5, -0.3, 0>}
object {Feather
	rotate <0, 0, -50>
	translate <-4.75, -0.3, 0>}
object {Feather
	rotate <0, 0, -60>
	translate <-5, -0.3, 0>}

// middle row
object {Feather
	scale <1, 1.5, 1>
	translate <mrh, mrv, 0>}
object {Feather
	scale <1, 1.5, 1>
	translate <mrh-0.5, mrv, 0>}
object {Feather
	scale <1, 1.5, 1>
	translate <mrh-1, mrv-0.05, 0>}
object {Feather
	scale <1, 1.5, 1>
	translate <mrh-1.5, mrv-0.1, 0>}
object {Feather
	scale <1, 1.5, 1>
	translate <mrh-2, mrv-0.15, 0>}
object {Feather
	scale <1, 1.5, 1>
	translate <mrh-2.5, mrv-0.2, 0>}
object {Feather
	scale <1, 1.5, 1>
	translate <mrh-3, mrv-0.25, 0>}
object {Feather
	scale <1, 1.5, 1>
	translate <mrh-3.5, mrv-0.3, 0>}
object {Feather
	scale <1, 1.5, 1>
	rotate <0, 0, -10>
	translate <mrh-3.75, mrv-0.3, 0>}
object {Feather
	scale <1, 1.5, 1>
	rotate <0, 0, -20>
	translate <mrh-4, mrv-0.3, 0>}
object {Feather
	scale <1, 1.5, 1>
	rotate <0, 0, -30>
	translate <mrh-4.25, mrv-0.3, 0>}
object {Feather
	scale <1, 1.5, 1>
	rotate <0, 0, -40>
	translate <mrh-4.5, mrv-0.3, 0>}
object {Feather
	scale <1, 1.5, 1>
	rotate <0, 0, -50>
	translate <mrh-4.75, mrv-0.3, 0>}
object {Feather
	scale <1, 1.5, 1>
	rotate <0, 0, -60>
	translate <mrh-5, mrv-0.3, 0>}

// bottom row
object {Feather
	scale <1, 2.5, 1>
	translate <brh, brv, 0>}
object {Feather
	scale <1, 2.5, 1>
	translate <brh-0.5, brv, 0>}
object {Feather
	scale <1, 2.5, 1>
	translate <brh-1, brv-0.05, 0>}
object {Feather
	scale <1, 2.5, 1>
	translate <brh-1.5, brv-0.1, 0>}
object {Feather
	scale <1, 2.5, 1>
	translate <brh-2, brv-0.15, 0>}
object {Feather
	scale <1, 2.5, 1>
	translate <brh-2.5, brv-0.2, 0>}
object {Feather
	scale <1, 2.5, 1>
	translate <brh-3, brv-0.25, 0>}
object {Feather
	scale <1, 2.5, 1>
	translate <brh-3.5, brv-0.3, 0>}
object {Feather
	scale <1, 2.5, 1>
	rotate <0, 0, -5>
	translate <brh-3.6, brv-0.3, 0>}
object {Feather
	scale <1, 2.5, 1>
	rotate <0, 0, -10>
	translate <brh-3.75, brv-0.3, 0>}
object {Feather
	scale <1, 2.5, 1>
	rotate <0, 0, -15>
	translate <brh-3.85, brv-0.3, 0>}
object {Feather
	scale <1, 2.5, 1>
	rotate <0, 0, -20>
	translate <brh-4, brv-0.3, 0>}
object {Feather
	scale <1, 2.5, 1>
	rotate <0, 0, -25>
	translate <brh-4.1, brv-0.3, 0>}
object {Feather
	scale <1, 2.5, 1>
	rotate <0, 0, -30>
	translate <brh-4.25, brv-0.3, 0>}
object {Feather
	scale <1, 2.5, 1>
	rotate <0, 0, -35>
	translate <brh-4.35, brv-0.3, 0>}
object {Feather
	scale <1, 2.5, 1>
	rotate <0, 0, -40>
	translate <brh-4.5, brv-0.3, 0>}
object {Feather
	scale <1, 2.5, 1>
	rotate <0, 0, -45>
	translate <brh-4.6, brv-0.3, 0>}
object {Feather
	scale <1, 2.5, 1>
	rotate <0, 0, -50>
	translate <brh-4.75, brv-0.3, 0>}
object {Feather
	scale <1, 2.5, 1>
	rotate <0, 0, -55>
	translate <brh-4.85, brv-0.3, 0>}
object {Feather
	scale <1, 2.5, 1>
	rotate <0, 0, -60>
	translate <brh-5, brv-0.3, 0>}

} // end union WingD

// ------------------------------------------------
// Glue all the objects together to make Daedalus


#declare Daedalus = union {

union {

object {Head
	scale 1.2
	translate <0, -0.3, 0>}
cylinder {<0, -1.5, 0>, <0, -3, 0>, 0.5}

// torso
sphere {<0, -3, 0>, 1
	scale <2.1, 1, 1>}
cone {<0, -3, 0>, 1
	<0, -6, 0>, 0.75
	scale <2.1, 1, 1>}
cylinder {<0, -6, 0>, <0, -8, 0>, 0.75
	scale <2, 1, 1>}

// left arm
object {Arm
	rotate <0,180,0>	
	translate <0, -1.5, 0>}

// right arm
object {Arm
	translate <0, -1.5, 0>}

// left leg
sphere {<0.75, -8, 0>, 0.75}	// hip
cone {<0.75, -8, 0>, 0.75
	<0.75, -12, -0.5>, 0.5}
sphere {<0.75, -12, -0.5>, 0.5}	// knee
cone {<0.75, -12, -0.5>,0.5
	<0.75, -16, 0>, 0.4} 
sphere {<0.75, -16, 0>, 0.4}	// ankle
cone {<0, 0, 0>, 0.4		// foot
	<0, 1.5, 0>, 0.3
	scale <1, 1, 0.8>
	rotate <-135, 0, 0>
	translate <0.75, -16, 0>
}

// right leg
sphere {<-0.75, -8, 0>, 0.75}	// hip
cone {<-0.75, -8, 0>, 0.75
	<-0.75, -12, -0.5>, 0.5}
sphere {<-0.75, -12, -0.5>, 0.5}	// knee
cone {<-0.75, -12, -0.5>,0.5
	<-0.75, -16, 0>, 0.4} 
sphere {<-0.75, -16, 0>, 0.4}	// ankle
cone {<0, 0, 0>, 0.4		// foot
	<0, 1.5, 0>, 0.3
	scale <1, 1, 0.8>
	rotate <-135, 0, 0>
	translate <-0.75, -16, 0>
}

texture {Skin}

} //end body union

// ---------------------------------------------------------
// Clothes 

// Tunic
union {

object {Fold				// "skirt"
	translate <0, 0, -0.54>}
object {Fold
	translate <0.3, 0.1, -0.48>}
object {Fold 
	translate <0.6, 0.1, -0.44>}
object {Fold
	translate <0.9, 0.15, -0.34>}
object {Fold
	translate <1.1, 0.15, -0.2>}
object {Fold
	translate <1.3, 0.1, -0.15>}
object {Fold
	rotate <0, -90, 0>
	translate <1.4, 0, 0>}
object {Fold
	rotate <0, 180, 0>
	translate <1.2, 0.1, 0.2>}
object {Fold
	rotate <0, 180, 0>
	translate <0.8, 0.15, 0.4>}
object {Fold 
	rotate <0, 180, 0>
	translate <0.6, 0.1, 0.48>}
object {Fold
	rotate <0, 180, 0>
	translate <0.3, 0.1, 0.48>}
object {Fold
	rotate <0, 180, 0>
	translate <0, 0, 0.55>}
object {Fold 
	translate <-0.2, 0, -0.48>}
object {Fold
	translate <-0.5, 0.1, -0.44>}
object {Fold
	translate <-0.7, 0.15, -0.4>}
object {Fold
	translate <-0.9, 0.1, -0.3>}
object {Fold 
	translate <-1.2, 0, -0.2>}
object {Fold 
	rotate <0, 90, 0>
	translate <-1.4, 0, 0>}
object {Fold 
	rotate <0, 180, 0>
	translate <-0.2, 0, 0.54>}
object {Fold
	rotate <0, 180, 0>
	translate <-0.5, 0.1, 0.48>}
object {Fold
	rotate <0, 180, 0>
	translate <-0.6, 0.15, 0.44>}
object {Fold
	rotate <0, 180, 0>
	translate <-0.9, 0.1, 0.3>}
object {Fold 
	rotate <0, 180, 0>
	translate <-1.2, 0, 0.2>}

difference {
	union {
	 sphere {<0, -3, 0>, 1.1		// main body
		scale <2.1, 1, 1>}
	 cone {<0, -3, 0>, 1.1
		<0, -6, 0>, 0.75
		open
		scale <2.1, 1, 1>
		}
	} // end union
	sphere {<-11, 2, 0>, 12}
	sphere {<2, -3, 0>, 1.5}
} // end diff

// rhs shoulder loops
torus {1, 0.1
	scale <2, 1, 1.1>
	rotate <0, 0, 60>
	translate <-0.2, -3.7, 0>
}
torus {1, 0.1
	scale <2, 1, 1.15>
	rotate <0, 0, 61>
	translate <-0.4, -3.7, 0>
}
torus {1, 0.1
	scale <2, 1, 1.1>
	rotate <0, 0, 59>
	translate <-0.5, -3.7, 0>
}

// belt
cylinder {<0, -6, 0>, <0, -6.5, 0>, 0.78
	scale <2, 1, 1>
	pigment {color Brown}}

texture {
	pigment {color rgb <0.9, 0.9, 0.7>}
	normal {wrinkles 1.0 scale 5}
	finish {crand 0.05}
	}

} // end tunic union


// Wings
object {WingD 
	translate <-2.3, -1.5, 0>
}
object {Wing_Frame
	translate <-2.3, -1.5, 0>
}
object {WingD
	rotate <0, 180, 0> 
	translate <2.3, -1.5, 0>
}
object {Wing_Frame
	rotate <0, 180, 0>
	translate <2.3, -1.5, 0>
}

} // end Daedalus union
