// ***************************
// *     Future flight 1     *
// ***************************
// *   by : Dran Draggore    *
// ***************************


#declare TEXTURE_CTRL = 1		// 0 = Testing Textures; 1 = Normal Textures
#declare CAMERA_CTRL = 5		// 0 = Testing Camera; 1 = Camera1; 2 = Camera2; 3 = Camera3; 4 = Camera4;
#declare EXHAUST_FLAME = 0		// 0 = no flame; 1 = minimum; 10 = afterburners to the max!
#declare LIGHTS_C = 1			// 0 = no lights; 1 = lights on

#include "colors.inc"
#include "skies.inc"

#include "ffmodel.inc"
#include "ffairprt.inc"

#if (CAMERA_CTRL = 0)
// * Testing Camera = 0
camera {
	location <-30, 200, 16>
	direction <0, 0, 1.5>
	look_at <90, 150, 64>
}
#end
#if (CAMERA_CTRL = 1)
// * Camera1 = 1
camera {
	location <-150, 40, -40>
	direction <0, 0, 10>
	look_at <-5, 0, 0>
}
#end
#if (CAMERA_CTRL = 2)
// * Camera2 = 2
camera {
	location <110, 15, -20>
	direction <0, 0, 8>
	look_at <5, 0, 0>
}
#end
#if (CAMERA_CTRL = 3)
// * Camera3 = 3
camera {
	location <-80, 80, 16>
	direction <0, 0, 2>
	look_at <32, 2, 32>
}
#end
#if (CAMERA_CTRL = 4)
// * Camera4 = 4
camera {
	location <-30, 20, 16>
	direction <0, 0, 1.5>
	look_at <90, 18, 64>
}
#end
#if (CAMERA_CTRL = 5)
// * Camera5 = 5
camera {
	location <70, 10, 180>
	direction <0, 0, 4>
	look_at <155, 13, 158>
}
#end

light_source { <-50000, 10000, -50000> color rgb <0.8, 0.7, 0.6>
/*
	area_light <-3000, -3000, 3000>, <3000, 3000, -3000>, 6, 6
	adaptive 1
	jitter
*/
}

// background { color rgb <0.4, 0.5, 0.9> }

// * ** *** **** ***** **** *** ** *

object { Flier scale 1.5 rotate <0, 20, 0> translate <40, 6, 32> }

object { Flier scale 1.5 rotate <0, 0, -10> rotate <0, 45, 0> translate <168, 15, 32> }


#declare EXHAUST_FLAME = 10		// 0 = no flame; 1 = minimum; 10 = afterburners to the max!
#include "ffmodel.inc"

object { Flier scale 1.5 rotate <0, 180, 0> rotate <0, 0, 15> translate <160, 15, 160> }

object { Flier scale 1.5 rotate <0, 180, 0> rotate <0, 0, 10> rotate <-45, 0, 0> rotate <0, 45, 0> translate <700, 95, 20> }

object { Airport }

// *********************************

height_field { gif "planine2.gif"
	smooth
	texture {
		pigment { crackle
			color_map {
				[ 0 color rgb <0.6, 0.5, 0> ]
				[ 0.03 color rgb <0.8, 0.7, 0> ]
				[ 0.5 color rgb <1, 0.85, 0> ]
			}
			scale 5
			turbulence 0.4
		}
		normal { crackle 1 scale 5 turbulence 0.4 }
		finish { brilliance 0.325
			ambient rgb <0.2, 0.2, 0>
		}
		scale <(1/2000), (1/2000), (1/2000)>
	}
	translate <-0.5, 0, -0.5>
	rotate <0, 90, 0>
	translate <0.5, 0, 0.5>
	scale <2000, 400, 2000>
	translate <-500, -257.8125, -500>
}

sky_sphere {
    pigment {
        gradient y
        pigment_map {
            [0 rgb <0.8, 0.2, 0> ]
            [0.15 P_Cloud2 scale 0.1 rotate z*5]
            [0.60 P_Cloud3 scale <0.15, 0.08, 0.15> rotate z*10]
        }
    }
}

