// Matthew Buckley
// sauron@cmu.edu
// Glibregibila
// Begun: 11-12-96
// Completed:
// Version: 3.0 for Windows

global_settings { max_trace_level 20 }

#declare AlienLoc = <0,1.4,0>

#declare CameraLoc = <3,10,-15>

//camera { location CameraLoc look_at<0,1.4,0> }

// Body
#declare topopen = 0
#declare coloring = 0

// Parameters for all limbs
#declare splinethickness = 0.4
#declare smoothness = 100

  //////////////////////
 // Limb Arrangement //////////////////
//////////////////////              //
       //        +z                //
      //                          //
     //          7               //
    //        6 \|/ 8           //
   //       5 ---O--- 1  +x    //
  //          4 /|\ 2         //
 //              3           //
//////////////////////////////
#declare eep = 0

  ////////////
 // Limb 1 //
////////////
  #declare looseness = 1       // Spline looseness

  #declare dilation = 0.2      // eye dilation
  #declare openness = 1        // Eye open
  #declare Look = CameraLoc - AlienLoc    // Where is eye looking?

  // Variable Control Points
  #declare Control2 = < 2.7,   0.3,  0>
  #declare Control3 = < 3.0,   1.0,  0>
  #declare Control4 = < 3.5,   2.0,  0>
  #declare Control5 = < 4.25,  2.6,  0>
  #declare Control6 = < 5.0,   2.0,  0>
  #declare Control7 = < 6.0,   0.0,  0>
  #declare Control8 = < 7.0,  -1.0, -1>
  #declare Control9 = < 7.0,  -0.5, -1.5>

  #include "limb.inc"
  #declare Limb1 = union {
    object { CatmullRomSpline texture { pigment { color rgb<1,1,0> } } }
    cylinder { 0, Control1, splinethickness texture { pigment { color rgb<1,1,0> } } }
    object { AlienEye } //object {ControlPoints}
  } // Limb 1


  ////////////
 // Limb 2 //
////////////
  // Variables
  #declare looseness = 1       // Spline looseness

  #declare dilation = 0.2      // eye dilation
  #declare openness = 1        // Eye open
  #declare Look = CameraLoc - AlienLoc    // Where is eye looking?

  // Variable Control Points
  #declare Control2 = < 2.5,  0.5, -2.5>
  #declare Control3 = < 2.7,  1.0, -2.7>
  #declare Control4 = < 3.0,  2.0, -3>
  #declare Control5 = < 4.0,  2.6, -4>
  #declare Control6 = < 4.5,  2.0, -4.5>
  #declare Control7 = < 5.0,  0.0, -5>
  #declare Control8 = < 5.5, -1.0, -5.5>
  #declare Control9 = < 5.5, -0.3, -6>

  #include "limb.inc"
  #declare Limb2 = union {
    object { CatmullRomSpline texture { pigment { color rgb<1,1,0> } } }
    cylinder { 0, Control1, splinethickness texture { pigment { color rgb<1,1,0> } } }
    object { AlienEye }
    //object {ControlPoints}
  } // Limb 2


  ////////////
 // Limb 3 //
////////////
  // Variables
  #declare looseness = 1       // Spline looseness

  #declare dilation = 0.2      // eye dilation
  #declare openness = 1        // Eye open
  #declare Look = CameraLoc - AlienLoc    // Where is eye looking?

  // Variable Control Points
  #declare Control2 = <-0.0,  0.2, -2.7>
  #declare Control3 = <-0.2,  1.0, -3.5>
  #declare Control4 = <-0.4,  2.0, -3.5>
  #declare Control5 = <-0.6,  2.5, -2.5>
  #declare Control6 = <-0.8,  3.4, -2.1>
  #declare Control7 = <-0.9,  4.2, -2.8>
  #declare Control8 = <-1.0,  4.5, -3.5>
  #declare Control9 = <-1.0,  4.5, -5>

  #include "limb.inc"
  #declare Limb3 = union {
    object { CatmullRomSpline texture { pigment { color rgb<1,1,0> } } }
    cylinder { 0, Control1, splinethickness texture { pigment { color rgb<1,1,0> } } }
    object { AlienEye } //object {ControlPoints}
  } // Limb 3


  ////////////
 // Limb 4 //
////////////
  // Variables
  #declare looseness = 1       // Spline looseness

  #declare dilation = 0.2      // eye dilation
  #declare openness = 1        // Eye open
  #declare Look = CameraLoc - AlienLoc    // Where is eye looking?

  // Variable Control Points
  #declare Control2 = <-2.2,  0.3, -2.2>
  #declare Control3 = <-2.7,  0.9, -2.7>
  #declare Control4 = <-3.0,  2.1, -3>
  #declare Control5 = <-3.5,  2.6, -3.5>
  #declare Control6 = <-4.1,  1.9, -4.1>
  #declare Control7 = <-4.5,  0.0, -4.5>
  #declare Control8 = <-5.5, -1.0, -5.5>
  #declare Control9 = <-5.5, -0.3, -6>

  #include "limb.inc"
  #declare Limb4 = union {
    object { CatmullRomSpline texture { pigment { color rgb<1,1,0> } } }
    cylinder { 0, Control1, splinethickness texture { pigment { color rgb<1,1,0> } } }
    object { AlienEye } //object {ControlPoints}
  } // Limb 4


  ////////////
 // Limb 5 //
////////////
  // Variables
  #declare looseness = 1       // Spline looseness

  #declare dilation = 0.2      // eye dilation
  #declare openness = 1        // Eye open
  #declare Look = CameraLoc - AlienLoc    // Where is eye looking?

  // Variable Control Points
  #declare Control2 = <-2.7,   0.3,  0>
  #declare Control3 = <-3.0,   1.1,  0>
  #declare Control4 = <-3.5,   2.0,  0>
  #declare Control5 = <-4.25,  2.6,  0>
  #declare Control6 = <-5.0,   2.1,  0>
  #declare Control7 = <-6.0,   0.0,  0>
  #declare Control8 = <-7.0,  -1.0, -1>
  #declare Control9 = <-6.9,  -0.5, -1.6>

  #include "limb.inc"
  #declare Limb5 = union {
    object { CatmullRomSpline texture { pigment { color rgb<1,1,0> } } }
    cylinder { 0, Control1, splinethickness texture { pigment { color rgb<1,1,0> } } }
    object { AlienEye } //object {ControlPoints}
  } // Limb 5


  ////////////
 // Limb 6 //
////////////
  // Variables
  #declare looseness = 1       // Spline looseness

  #declare dilation = 0.2      // eye dilation
  #declare openness = 1        // Eye open
  #declare Look = <-15,12,15>    // Where is eye looking?

  // Variable Control Points
  #declare Control2 = <-2.2,  0.4,  2.2>
  #declare Control3 = <-2.7,  1.0,  2.7>
  #declare Control4 = <-3.0,  2.2,  3>
  #declare Control5 = <-3.4,  2.6,  3.4>
  #declare Control6 = <-4.1,  1.8,  4.1>
  #declare Control7 = <-4.4,  0.0,  4.4>
  #declare Control8 = <-5.5, -1.0,  5.5>
  #declare Control9 = <-5.5, -0.3,  6>

  #include "limb.inc"
  #declare Limb6 = union {
    object { CatmullRomSpline texture { pigment { color rgb<1,1,0> } } }
    cylinder { 0, Control1, splinethickness texture { pigment { color rgb<1,1,0> } } }
    object { AlienEye } //object {ControlPoints}
  } // Limb 6


  ////////////
 // Limb 7 //
////////////
  // Variables
  #declare looseness = 1       // Spline looseness

  #declare dilation = 0.2      // eye dilation
  #declare openness = 1        // Eye open
  #declare Look = CameraLoc - AlienLoc    // Where is eye looking?

  // Variable Control Points
  #declare Control2 = < 0.0,  0.2,  2.5>
  #declare Control3 = < 0.1,  0.7,  3.1>
  #declare Control4 = < 0.3,  1.5,  4.2>
  #declare Control5 = < 0.5,  3.0,  5.0>
  #declare Control6 = < 0.7,  4.1,  4.2>
  #declare Control7 = < 0.9,  5.0,  3.1>
  #declare Control8 = < 1.0,  5.5,  2.0>
  #declare Control9 = < 1.0,  5.5,  1.0>

  #include "limb.inc"
  #declare Limb7 = union {
    object { CatmullRomSpline texture { pigment { color rgb<1,1,0> } } }
    cylinder { 0, Control1, splinethickness texture { pigment { color rgb<1,1,0> } } }
    object { AlienEye } //object {ControlPoints}
  } // Limb 7


  ////////////
 // Limb 8 //
////////////
  // Variables
  #declare looseness = 1       // Spline looseness

  #declare dilation = 0.2      // eye dilation
  #declare openness = 1        // Eye open
  #declare Look = <14,10,14>    // Where is eye looking?

  // Variable Control Points
  #declare Control2 = < 2.5,  0.4, 2.5>
  #declare Control3 = < 2.7,  1.0, 2.7>
  #declare Control4 = < 3.0,  2.1, 3>
  #declare Control5 = < 4.0,  2.5, 4>
  #declare Control6 = < 4.5,  2.0, 4.5>
  #declare Control7 = < 5.0,  0.0, 5>
  #declare Control8 = < 5.5, -1.0, 5.5>
  #declare Control9 = < 6, -0.3, 6>

  #include "limb.inc"
  #declare Limb8 = union {
    object { CatmullRomSpline texture { pigment { color rgb<1,1,0> } } }
    cylinder { 0, Control1, splinethickness texture { pigment { color rgb<1,1,0> } } }
    object { AlienEye } //object {ControlPoints}
  } // Limb 8

#include "body.inc"
// END ALIEN DECLARATION

/*
object { Alien translate AlienLoc}

plane { y, 0 texture { pigment { checker color rgb<1,0,0> color rgb<0,0,0> } } }

background { color rgb 0 }

light_source {
  <-20,30,-60>
  color rgb<1,1,1>
  rotate<0,360*clock,0>
}

light_source {
  <60,50,-40>
  color rgb<1,1,1>
  rotate<0,360*clock,0>
}

*/
