// Matthew Buckley
// sauron@cmu.edu
// Eye for Glibregibila
// Begun: 11-12-96
// Completed:
// Version: 3.0 for Windows
// Predefine:  Prev:            (vector) Point prevoius to eye (for slope calculation)
//             Base:            (vector) Base of eye
//             Mid:             (vector) Middle of eye
//             End:             (vector) End of eye
//             Look:            (vector) Where is it looking
//             smoothness:      (float)  number of subdivisions along eye
//             splinethickness: (float)  radius at base
//             eyethickness:    (float)  radius at eye
//             dilation:        (float)  dilation of eye
//             openness:        (float)  how open is the eye

//+KFI0     +KFF-1    +KI0      +KF1      +uv +ul +mb3 +vb +vl

global_settings { max_trace_level 100 }

//#declare DEBUG = 1

#ifndef (smoothness)
  #declare smoothness = 10
#end //ifndef(smoothness)

#ifndef (splinethickness)
  #declare splinethickness = 0.4
#end //ifndef(splinethickness)

#ifndef (eyethickness)
  #declare eyethickness = 1
#end //ifndef(splinethickness)

#ifndef (dilation)
  #declare dilation = 0.3
#end //ifndef(dilation)

#ifndef (openness)
  #declare openness = 1
#end //ifndef(openness)

#ifndef (Base)
  #declare Prev = <-1,1,1>
  #declare Base = <0,0,0>
  #declare Mid = <1,0.0,0>
  #declare End = <2,0,1>
  #declare Look = <7,0,5> + (End + (openness * vnormalize(End - Mid)))

  background { color rgb(1 * <1,1,1>) }

  #declare openvector = vnormalize(End - Mid)

  camera {
    location (<1,3,1> + (End + (openness * openvector)))
    look_at (End + ( ( ((openness * 0.1) + 0.1) * (eyethickness - splinethickness) / (0.6)) + 0.1) * openvector)
  }

  light_source { <-30,30,30> color rgb<1,1,1> }

  light_source { <30,30,30> color rgb(1 * <1,1,1>) }

  light_source { <30,30,-30> color rgb<1,1,1> }

  #declare renderingthisfile = 1
#end  //ifndef (Control0)

#declare openvector = vnormalize(End - Mid)
#declare eyeballLoc = (End + ((((openness*0.1) * (eyethickness - splinethickness) / (0.6)) + 0.1) * openvector))
#declare lookdirection = vnormalize(Look - eyeballLoc)
#declare mwbtemp = vcross(y,(lookdirection))

#declare AlienEye =
union {
  union {
    #declare mbase = (Mid - Prev) / 2
    #declare mrest = (End - Mid)
    #declare A = (mrest + mbase) + 2 * (Base - Mid)
    #declare B = (Mid - Base) - mbase - A
    #declare C = mbase
    #declare D = Base

    #declare lastLoc = Base + (0.0001 * <1,1,1>)
    #declare lastRad = 0.01

    #declare tt = 0
    #while (tt < 1)
      #declare Rad = ((((eyethickness - splinethickness) / 4) * tt * tt) + splinethickness)
      #declare Loc = ((A * tt * tt * tt) + (B * tt * tt) + (C * tt) + D)

      difference {
        sphere { Loc Rad }
        sphere { eyeballLoc (eyethickness * 0.901) }
      } // difference
/*
      difference {
        cone { Loc, Rad, lastLoc, lastRad }
        sphere { eyeballLoc (eyethickness * 0.901) }
      } // difference
*/
      #declare lastRad = Rad
      #declare lastLoc = Loc
      #declare tt = tt + (1 / smoothness)
    #end // while(tt < 1)

    #declare lastLoc = Loc + 0.0001 * <1,1,1>
    #declare tt = 0
    #while (tt <= 1)
      #declare Loc = ((mrest * tt) + Mid)
      #declare Rad = ((((eyethickness - splinethickness) / 4) * (tt + 1) * (tt + 1)) + splinethickness)

      difference {
        sphere { Loc Rad }
        sphere { eyeballLoc (eyethickness * 0.901) }
      } // difference
/*
      difference {
        cone { Loc, Rad, lastLoc, lastRad }
        sphere { eyeballLoc (eyethickness * 0.901) }
      } // difference
*/
      #declare lastLoc = Loc
      #declare lastRad = Rad
      #declare tt = tt + (1 / smoothness)
    #end // while(tt < 1)

    texture {
      pigment {
        color rgb<1,1,0>
      }
    }
  } // union



  // Eyeball
  sphere {
     <0,0,0> (eyethickness * 0.9)
    texture {
      pigment {
        color rgbt<1,1,1,0.9>
      }
      finish {
        ambient 0
        diffuse 0.05
        brilliance 4
        specular 0.6
        roughness 0.0001
        reflection 0.1
        refraction 1
        ior 1.5
        fade_distance eyethickness * 4
        fade_power 1
        irid {0.25 thickness 0.2 turbulence 1}
      } // finish
      translate <0,clock,0>
    } // texture
    rotate < degrees (atan2 (vlength (lookdirection * <1, 0, 1>), lookdirection.y)),
             degrees (atan2 (lookdirection.x, lookdirection.z)),
             0>

    translate eyeballLoc

  } // sphere

  sphere {
    <0,0,0> (eyethickness * 0.89)

    texture {
      pigment {
        radial
        color_map {
          [0.0 color rgb  <0.5,0.25,0>]
          [0.5 color rgb  <0.5,0.5,0>]
          [1.0 color rgb  <0.5,0.25,0>]
        }
        frequency 50
      } // pigment

    } // texture

    texture {
      pigment {
        gradient y
        color_map {
          [0.0 rgbt<0,0,0.50,0>]
          [0.4 rgbt<0,0,0.50,0>]
          [0.6 rgbt<0,0,0.50,1>]
          [1.0 rgbt<1,1,1,1>]
        } // color_map
      } // pigment
      scale <1, ((eyethickness * 0.89) * 2), 1>
      translate y * -(eyethickness * 0.89)
    } // texture

    hollow

    clipped_by {
      cylinder {
        <0,-eyethickness * 0.891,0> //(eyeballLoc - (lookdirection * eyethickness * 0.89))
        <0,eyethickness * 0.44 + eyethickness * 0.44 * (1 - dilation),0>
         //(eyeballLoc + ((lookdirection * eyethickness * 0.89) * (1 - dilation)))
        eyethickness
      } // cylinder
    } // clipped_by

    rotate < degrees (atan2 (vlength (lookdirection * <1, 0, 1>), lookdirection.y)),
             degrees (atan2 (lookdirection.x, lookdirection.z)),
             0>

    translate eyeballLoc
  } // sphere

//sphere { eyeballLoc, (eyethickness * 0.89) texture { pigment { color rgb <1,0,0> } } }

  #ifdef (DEBUG)
    //cylinder {<0,-1,0> <0,100,0> 0.055 texture{pigment{rgb<0,1,0>}}}
  #end
} // union

#ifdef (DEBUG)
  union {
    sphere {Prev, eyethickness*1.1}
    sphere {Base, eyethickness*1.1}
    sphere {Mid, eyethickness*1.1}
    sphere {End, eyethickness*1.1}
    texture { pigment { color rgbt<1,0,0,0.9>}}
  }
#end

// If rendering this file, put the demo eye in.
#ifdef (renderingthisfile)
  object {
    AlienEye
  }
  plane {    y, -2    texture { pigment { checker color rgb<1,0,0> color rgb<0,0,0> } } no_shadow }

#end
