//  Persistance of Vision Raytracer V3.0
//  World definition file.
//
//  Contains 1 lights, 11 textures and 72 primitives.
//
//  This file was generated for POV-Ray V3.0 by
//  MORAY.EXE V2.5.wat(c) 1991-1995 Lutz + Kretzschmar
//

//  Date : 12/17/1996    (17.12.1996)
//

//
//  This is the standard include file for POV-Ray. It is included with
//  every scene that Moray V2.0 exports for POV-Ray.
//





global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.8
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

camera {  //  Camera StdCam
  location  <-4.544, -13.156, 4.510>
  direction <0.0,     0.0,  1.8883>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  look_at   <0.337, 0.164, 1.210>
}

// *******  L I G H T S *******
light_source {   // Light1
  <99.532, -93.639, 10.316>
  color rgb <1.108, 1.108, 1.108>
  atmosphere off
}


// ********  TEXTURES  *******
//

#include "flight01.inc"



// ********  REFERENCED OBJECTS  *******



// ********  OBJECTS  *******

union { // CROSS
  box { // CROSSMHORIZ
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 1.5, 0.2>
    translate  0.75*z
  }
  box { // CROSSMVERT
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.2, 2.0>
  }
  texture {
    Yellow_Pine1
  }
  bounded_by { // Bound00004
    box {
      <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
      scale <0.249333, 1.549333, 2.049333>
    }
  }
  rotate 30.631569*z
  translate  <56.879884, 65.392655, 4.787955>
}


#declare eye6 = union {
  sphere { // Sphere17
    <0,0,0>,1
    texture {
      EYEMPUPIL
    }
    translate  <-0.108264, -1.461712, 0.0>
  }
  sphere { // Sphere18
    <0,0,0>,1
    texture {
      IRISMBLUE
    }
    scale 1.15
    translate  <-0.1, -1.3, 0.0>
  }
  sphere { // Sphere19
    <0,0,0>,1
    texture {
      Texture01
    }
    scale 2.3
  }
  bounded_by { // Bound11
    box {
      <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
      scale <2.393078, 2.473934, 2.393078>
      translate  <0.0, -0.080856, 0.0>
    }
  }
  scale <0.4, 0.2, 0.4>
  rotate <-90.0, -25.0, 0.0>
  translate  <-13.5, 1.5, 0.2>
}
#declare WING7 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.383242, -0.453965, -0.119353>, <0.239568, -1.043325, -0.119353>, <0.956675, -1.420515, -0.119353>, <1.273017, -1.821280, -0.119353>, 
      <-0.760432, -0.043325, -0.119353>, <-0.043325, -0.420515, -0.119353>, <0.956675, -0.420515, 0.000000>, <1.449825, -0.715195, 0.000000>, 
      <-1.043325, 0.579485, -0.119353>, <-0.043325, 0.579485, 0.000000>, <-1.000000, -1.000000, 0.000000>, <-0.153234, -1.082510, -0.059676>, 
      <-1.550175, 1.284805, -0.119353>, <-0.550175, 1.284805, 0.000000>, <-1.000000, 0.000000, -0.059676>, <-0.076617, -0.041255, -0.059676>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.550175, 1.284805, -0.119353>, <-0.550175, 1.284805, 0.000000>, <-1.000000, 0.000000, -0.059676>, <-0.076617, -0.041255, -0.059676>, 
      <-2.057024, 1.990125, -0.119353>, <-1.057024, 1.990125, 0.000000>, <-1.000000, 1.000000, -0.119353>, <0.000000, 1.000000, -0.059676>, 
      <-3.000000, 2.000000, -0.119353>, <-2.000000, 2.000000, -0.119353>, <-1.000000, 2.000000, 0.000000>, <0.000000, 2.000000, 0.000000>, 
      <-3.000000, 3.000000, -0.119353>, <-2.000000, 3.000000, 0.000000>, <-1.000000, 3.000000, 0.000000>, <0.000000, 3.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.273017, -1.821280, -0.119353>, <1.589360, -2.222045, -0.119353>, <2.000000, -3.000000, 0.417734>, <3.000000, -3.000000, 0.417734>, 
      <1.449825, -0.715195, 0.000000>, <1.942976, -1.009875, 0.000000>, <1.646384, -2.212170, -0.119353>, <3.000000, -2.000000, 0.000000>, 
      <-0.153234, -1.082510, -0.059676>, <0.693533, -1.165021, -0.119353>, <2.000000, -1.000000, 0.000000>, <3.000000, -1.000000, 0.000000>, 
      <-0.076617, -0.041255, -0.059676>, <0.846766, -0.082510, -0.059676>, <2.000000, 0.000000, 0.000000>, <3.000000, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.076617, -0.041255, -0.059676>, <0.846766, -0.082510, -0.059676>, <2.000000, 0.000000, 0.000000>, <3.000000, 0.000000, 0.000000>, 
      <0.000000, 1.000000, -0.059676>, <1.000000, 1.000000, 0.000000>, <2.000000, 1.000000, 0.000000>, <3.000000, 1.000000, 0.000000>, 
      <0.000000, 2.000000, 0.000000>, <1.000000, 2.000000, 0.000000>, <2.000000, 2.000000, 0.000000>, <3.000000, 2.000000, 0.000000>, 
      <0.000000, 3.000000, 0.000000>, <1.000000, 3.000000, 0.000000>, <2.000000, 3.000000, 0.000000>, <3.000000, 3.000000, 0.000000>
    }
  }
  translate  -3.0*y
}
#declare WING8 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.383242, 0.453965, -0.119353>, <0.239568, 1.043325, -0.119353>, <0.956675, 1.420515, -0.119353>, <1.273017, 1.821280, -0.119353>, 
      <-0.760432, 0.043325, -0.119353>, <-0.043325, 0.420515, -0.119353>, <0.956675, 0.420515, 0.000000>, <1.449825, 0.715195, 0.000000>, 
      <-1.043325, -0.579485, -0.119353>, <-0.043325, -0.579485, 0.000000>, <-1.000000, 1.000000, 0.000000>, <-0.153234, 1.082510, -0.059676>, 
      <-1.550175, -1.284805, -0.119353>, <-0.550175, -1.284805, 0.000000>, <-1.000000, 0.000000, -0.059676>, <-0.076617, 0.041255, -0.059676>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.550175, -1.284805, -0.119353>, <-0.550175, -1.284805, 0.000000>, <-1.000000, 0.000000, -0.059676>, <-0.076617, 0.041255, -0.059676>, 
      <-2.057024, -1.990125, -0.119353>, <-1.057024, -1.990125, 0.000000>, <-1.000000, -1.000000, -0.119353>, <0.000000, -1.000000, -0.059676>, 
      <-3.000000, -2.000000, -0.119353>, <-2.000000, -2.000000, -0.119353>, <-1.000000, -2.000000, 0.000000>, <0.000000, -2.000000, 0.000000>, 
      <-3.000000, -3.000000, -0.119353>, <-2.000000, -3.000000, 0.000000>, <-1.000000, -3.000000, 0.000000>, <0.000000, -3.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.273017, 1.821280, -0.119353>, <1.589360, 2.222045, -0.119353>, <2.000000, 3.000000, 0.417734>, <3.000000, 3.000000, 0.417734>, 
      <1.449825, 0.715195, 0.000000>, <1.942976, 1.009875, 0.000000>, <1.646384, 2.212170, -0.119353>, <3.000000, 2.000000, 0.000000>, 
      <-0.153234, 1.082510, -0.059676>, <0.693533, 1.165021, -0.119353>, <2.000000, 1.000000, 0.000000>, <3.000000, 1.000000, 0.000000>, 
      <-0.076617, 0.041255, -0.059676>, <0.846766, 0.082510, -0.059676>, <2.000000, 0.000000, 0.000000>, <3.000000, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.076617, 0.041255, -0.059676>, <0.846766, 0.082510, -0.059676>, <2.000000, 0.000000, 0.000000>, <3.000000, 0.000000, 0.000000>, 
      <0.000000, -1.000000, -0.059676>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.000000, -1.000000, 0.000000>, 
      <0.000000, -2.000000, 0.000000>, <1.000000, -2.000000, 0.000000>, <2.000000, -2.000000, 0.000000>, <3.000000, -2.000000, 0.000000>, 
      <0.000000, -3.000000, 0.000000>, <1.000000, -3.000000, 0.000000>, <2.000000, -3.000000, 0.000000>, <3.000000, -3.000000, 0.000000>
    }
  }
  translate  3.0*y
}
#declare NOSECONE3 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.675752, -0.012036, 0.000000>, <0.675752, -0.010966, 0.000000>, <0.673388, -0.010966, 0.000000>, <0.673388, -0.012036, 0.000000>, 
      <-1.000000, 0.000000, 2.000000>, <-1.000000, -1.000000, 2.000000>, <1.000000, -1.000000, 2.000000>, <1.000000, 0.000000, 2.000000>, 
      <-1.000000, 0.000000, 4.000000>, <-1.000000, -1.000000, 4.000000>, <1.000000, -1.000000, 4.000000>, <1.000000, 0.000000, 4.000000>, 
      <-1.000000, 0.000000, 6.000000>, <-1.000000, -1.000000, 6.000000>, <1.000000, -1.000000, 6.000000>, <1.000000, 0.000000, 6.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.673388, -0.012036, 0.000000>, <0.673388, -0.013105, 0.000000>, <0.675752, -0.013105, 0.000000>, <0.675752, -0.012036, 0.000000>, 
      <1.000000, 0.000000, 2.000000>, <1.000000, 1.000000, 2.000000>, <-1.000000, 1.000000, 2.000000>, <-1.000000, 0.000000, 2.000000>, 
      <1.000000, 0.000000, 4.000000>, <1.000000, 1.000000, 4.000000>, <-1.000000, 1.000000, 4.000000>, <-1.000000, 0.000000, 4.000000>, 
      <1.000000, 0.000000, 6.000000>, <1.000000, 1.000000, 6.000000>, <-1.000000, 1.000000, 6.000000>, <-1.000000, 0.000000, 6.000000>
    }
  }
  scale <1.0, 1.6, 0.24>
  rotate 90.0*y
  translate  -3.2*x
}
#declare TAILPLANE3 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.000000, -3.000000, 0.000000>, <-2.000000, -3.000000, 0.000000>, <-1.000000, -3.000000, 0.000000>, <0.000000, -3.000000, 0.000000>, 
      <-3.000000, -2.000000, 0.000000>, <-2.000000, -2.000000, 0.000000>, <-1.000000, -2.000000, 0.000000>, <0.000000, -2.000000, 0.000000>, 
      <-3.000000, -1.000000, 0.000000>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.000000, 0.000000, 0.000000>, <-2.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-0.251584, -0.277791, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.000000, 0.000000, 0.000000>, <-2.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-0.251584, -0.277791, 0.000000>, 
      <-3.000000, 1.000000, 0.000000>, <-2.000000, 1.000000, 0.000000>, <-1.000000, 1.000000, 0.000000>, <-0.503168, 0.444418, 0.000000>, 
      <-3.000000, 2.000000, 0.000000>, <-2.000000, 2.000000, 0.000000>, <-1.482203, 1.727451, 0.000000>, <-1.016819, 0.972698, 0.000000>, 
      <-3.000000, 3.000000, 0.000000>, <-2.482203, 2.727451, 0.000000>, <-2.006336, 1.888837, 0.000000>, <-1.457091, 1.385669, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -3.000000, 0.000000>, <1.000000, -3.000000, 0.000000>, <2.000000, -3.000000, 0.000000>, <3.000000, -3.000000, 0.000000>, 
      <0.000000, -2.000000, 0.000000>, <1.000000, -2.000000, 0.000000>, <2.000000, -2.000000, 0.000000>, <2.517797, -2.272549, 0.000000>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <1.517797, -1.272549, 0.000000>, <1.993664, -2.111163, 0.000000>, 
      <-0.251584, -0.277791, 0.000000>, <0.496832, -0.555582, 0.000000>, <0.983181, -1.027302, 0.000000>, <1.542909, -1.614331, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.251584, -0.277791, 0.000000>, <0.496832, -0.555582, 0.000000>, <0.983181, -1.027302, 0.000000>, <1.542909, -1.614331, 0.000000>, 
      <-0.503168, 0.444418, 0.000000>, <-0.006336, -0.111163, 0.000000>, <0.448565, -0.782054, 0.000000>, <1.092154, -1.117499, 0.000000>, 
      <-1.016819, 0.972698, 0.000000>, <-0.551435, 0.217946, 0.000000>, <0.092154, -0.117499, 0.000000>, <0.630917, -0.662598, 0.000000>, 
      <-1.457091, 1.385669, 0.000000>, <-0.907846, 0.882501, 0.000000>, <-0.369083, 0.337402, 0.000000>, <0.211610, -0.228662, 0.000000>
    }
  }
  scale <0.2, 1.0, 0.4>
  rotate <90.0, 0.0, 180.0>
  translate  <2.4, 0.0, 3.5>
}
#declare WINGS3 = union {
  object { WING7 }
  object { WING8 }
  cylinder { // FUSILAGE3
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.2, 5.0>
    rotate -90.0*y
    translate  3.2*x
  }
  object { NOSECONE3 }
  object { TAILPLANE3 }
  texture {
    petelMyellow
  }
  bounded_by { // Bound12
    box {
      <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
      scale <3.372667, 6.172667, 3.922667>
      translate  <0.0, 0.0, 2.75>
    }
  }
  scale <5.0, 2.5, 1.0>
}
#declare eye7 = union {
  sphere { // Sphere20
    <0,0,0>,1
    texture {
      EYEMPUPIL
    }
    translate  <-0.108264, -1.461712, 0.0>
  }
  sphere { // Sphere21
    <0,0,0>,1
    texture {
      IRISMBLUE
    }
    scale 1.15
    translate  <-0.1, -1.3, 0.0>
  }
  sphere { // Sphere22
    <0,0,0>,1
    texture {
      Texture01
    }
    scale 2.3
  }
  bounded_by { // Bound14
    box {
      <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
      scale <2.393078, 2.473934, 2.393078>
      translate  <0.0, -0.080856, 0.0>
    }
  }
  scale <0.4, 0.2, 0.4>
  rotate <-90.0, -25.0, 0.0>
  translate  <-13.5, -1.5, 0.2>
}
union { // SPACEMSHIPMPL3
  object { eye6 }
  object { WINGS3 }
  cone { // flame3
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      Flame
    }
    bounded_by { // Bound13
      box {
        <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
        scale <1.033333, 1.033333, 0.533333>
        translate  <0.0, 0.0, 0.5>
      }
    }
    scale <1.0, 3.0, 25.0>
    rotate -90.0*y
    translate  41.0*x
  }
  object { eye7 }
  scale 0.3
  rotate -363.94101*z
  translate  <10.714277, -1.270182, 1.784265>
}


#declare eye4 = union {
  sphere { // Sphere11
    <0,0,0>,1
    texture {
      EYEMPUPIL
    }
    translate  <-0.108264, -1.461712, 0.0>
  }
  sphere { // Sphere12
    <0,0,0>,1
    texture {
      IRISMBLUE
    }
    scale 1.15
    translate  <-0.1, -1.3, 0.0>
  }
  sphere { // Sphere13
    <0,0,0>,1
    texture {
      Texture01
    }
    scale 2.3
  }
  bounded_by { // Bound7
    box {
      <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
      scale <2.393078, 2.473934, 2.393078>
      translate  <0.0, -0.080856, 0.0>
    }
  }
  scale <0.4, 0.2, 0.4>
  rotate <-90.0, -25.0, 0.0>
  translate  <-13.5, 1.5, 0.2>
}
#declare WING5 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.383242, -0.453965, -0.119353>, <0.239568, -1.043325, -0.119353>, <0.956675, -1.420515, -0.119353>, <1.273017, -1.821280, -0.119353>, 
      <-0.760432, -0.043325, -0.119353>, <-0.043325, -0.420515, -0.119353>, <0.956675, -0.420515, 0.000000>, <1.449825, -0.715195, 0.000000>, 
      <-1.043325, 0.579485, -0.119353>, <-0.043325, 0.579485, 0.000000>, <-1.000000, -1.000000, 0.000000>, <-0.153234, -1.082510, -0.059676>, 
      <-1.550175, 1.284805, -0.119353>, <-0.550175, 1.284805, 0.000000>, <-1.000000, 0.000000, -0.059676>, <-0.076617, -0.041255, -0.059676>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.550175, 1.284805, -0.119353>, <-0.550175, 1.284805, 0.000000>, <-1.000000, 0.000000, -0.059676>, <-0.076617, -0.041255, -0.059676>, 
      <-2.057024, 1.990125, -0.119353>, <-1.057024, 1.990125, 0.000000>, <-1.000000, 1.000000, -0.119353>, <0.000000, 1.000000, -0.059676>, 
      <-3.000000, 2.000000, -0.119353>, <-2.000000, 2.000000, -0.119353>, <-1.000000, 2.000000, 0.000000>, <0.000000, 2.000000, 0.000000>, 
      <-3.000000, 3.000000, -0.119353>, <-2.000000, 3.000000, 0.000000>, <-1.000000, 3.000000, 0.000000>, <0.000000, 3.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.273017, -1.821280, -0.119353>, <1.589360, -2.222045, -0.119353>, <2.000000, -3.000000, 0.417734>, <3.000000, -3.000000, 0.417734>, 
      <1.449825, -0.715195, 0.000000>, <1.942976, -1.009875, 0.000000>, <1.646384, -2.212170, -0.119353>, <3.000000, -2.000000, 0.000000>, 
      <-0.153234, -1.082510, -0.059676>, <0.693533, -1.165021, -0.119353>, <2.000000, -1.000000, 0.000000>, <3.000000, -1.000000, 0.000000>, 
      <-0.076617, -0.041255, -0.059676>, <0.846766, -0.082510, -0.059676>, <2.000000, 0.000000, 0.000000>, <3.000000, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.076617, -0.041255, -0.059676>, <0.846766, -0.082510, -0.059676>, <2.000000, 0.000000, 0.000000>, <3.000000, 0.000000, 0.000000>, 
      <0.000000, 1.000000, -0.059676>, <1.000000, 1.000000, 0.000000>, <2.000000, 1.000000, 0.000000>, <3.000000, 1.000000, 0.000000>, 
      <0.000000, 2.000000, 0.000000>, <1.000000, 2.000000, 0.000000>, <2.000000, 2.000000, 0.000000>, <3.000000, 2.000000, 0.000000>, 
      <0.000000, 3.000000, 0.000000>, <1.000000, 3.000000, 0.000000>, <2.000000, 3.000000, 0.000000>, <3.000000, 3.000000, 0.000000>
    }
  }
  translate  -3.0*y
}
#declare WING6 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.383242, 0.453965, -0.119353>, <0.239568, 1.043325, -0.119353>, <0.956675, 1.420515, -0.119353>, <1.273017, 1.821280, -0.119353>, 
      <-0.760432, 0.043325, -0.119353>, <-0.043325, 0.420515, -0.119353>, <0.956675, 0.420515, 0.000000>, <1.449825, 0.715195, 0.000000>, 
      <-1.043325, -0.579485, -0.119353>, <-0.043325, -0.579485, 0.000000>, <-1.000000, 1.000000, 0.000000>, <-0.153234, 1.082510, -0.059676>, 
      <-1.550175, -1.284805, -0.119353>, <-0.550175, -1.284805, 0.000000>, <-1.000000, 0.000000, -0.059676>, <-0.076617, 0.041255, -0.059676>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.550175, -1.284805, -0.119353>, <-0.550175, -1.284805, 0.000000>, <-1.000000, 0.000000, -0.059676>, <-0.076617, 0.041255, -0.059676>, 
      <-2.057024, -1.990125, -0.119353>, <-1.057024, -1.990125, 0.000000>, <-1.000000, -1.000000, -0.119353>, <0.000000, -1.000000, -0.059676>, 
      <-3.000000, -2.000000, -0.119353>, <-2.000000, -2.000000, -0.119353>, <-1.000000, -2.000000, 0.000000>, <0.000000, -2.000000, 0.000000>, 
      <-3.000000, -3.000000, -0.119353>, <-2.000000, -3.000000, 0.000000>, <-1.000000, -3.000000, 0.000000>, <0.000000, -3.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.273017, 1.821280, -0.119353>, <1.589360, 2.222045, -0.119353>, <2.000000, 3.000000, 0.417734>, <3.000000, 3.000000, 0.417734>, 
      <1.449825, 0.715195, 0.000000>, <1.942976, 1.009875, 0.000000>, <1.646384, 2.212170, -0.119353>, <3.000000, 2.000000, 0.000000>, 
      <-0.153234, 1.082510, -0.059676>, <0.693533, 1.165021, -0.119353>, <2.000000, 1.000000, 0.000000>, <3.000000, 1.000000, 0.000000>, 
      <-0.076617, 0.041255, -0.059676>, <0.846766, 0.082510, -0.059676>, <2.000000, 0.000000, 0.000000>, <3.000000, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.076617, 0.041255, -0.059676>, <0.846766, 0.082510, -0.059676>, <2.000000, 0.000000, 0.000000>, <3.000000, 0.000000, 0.000000>, 
      <0.000000, -1.000000, -0.059676>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.000000, -1.000000, 0.000000>, 
      <0.000000, -2.000000, 0.000000>, <1.000000, -2.000000, 0.000000>, <2.000000, -2.000000, 0.000000>, <3.000000, -2.000000, 0.000000>, 
      <0.000000, -3.000000, 0.000000>, <1.000000, -3.000000, 0.000000>, <2.000000, -3.000000, 0.000000>, <3.000000, -3.000000, 0.000000>
    }
  }
  translate  3.0*y
}
#declare NOSECONE2 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.675752, -0.012036, 0.000000>, <0.675752, -0.010966, 0.000000>, <0.673388, -0.010966, 0.000000>, <0.673388, -0.012036, 0.000000>, 
      <-1.000000, 0.000000, 2.000000>, <-1.000000, -1.000000, 2.000000>, <1.000000, -1.000000, 2.000000>, <1.000000, 0.000000, 2.000000>, 
      <-1.000000, 0.000000, 4.000000>, <-1.000000, -1.000000, 4.000000>, <1.000000, -1.000000, 4.000000>, <1.000000, 0.000000, 4.000000>, 
      <-1.000000, 0.000000, 6.000000>, <-1.000000, -1.000000, 6.000000>, <1.000000, -1.000000, 6.000000>, <1.000000, 0.000000, 6.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.673388, -0.012036, 0.000000>, <0.673388, -0.013105, 0.000000>, <0.675752, -0.013105, 0.000000>, <0.675752, -0.012036, 0.000000>, 
      <1.000000, 0.000000, 2.000000>, <1.000000, 1.000000, 2.000000>, <-1.000000, 1.000000, 2.000000>, <-1.000000, 0.000000, 2.000000>, 
      <1.000000, 0.000000, 4.000000>, <1.000000, 1.000000, 4.000000>, <-1.000000, 1.000000, 4.000000>, <-1.000000, 0.000000, 4.000000>, 
      <1.000000, 0.000000, 6.000000>, <1.000000, 1.000000, 6.000000>, <-1.000000, 1.000000, 6.000000>, <-1.000000, 0.000000, 6.000000>
    }
  }
  scale <1.0, 1.6, 0.24>
  rotate 90.0*y
  translate  -3.2*x
}
#declare TAILPLANE2 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.000000, -3.000000, 0.000000>, <-2.000000, -3.000000, 0.000000>, <-1.000000, -3.000000, 0.000000>, <0.000000, -3.000000, 0.000000>, 
      <-3.000000, -2.000000, 0.000000>, <-2.000000, -2.000000, 0.000000>, <-1.000000, -2.000000, 0.000000>, <0.000000, -2.000000, 0.000000>, 
      <-3.000000, -1.000000, 0.000000>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.000000, 0.000000, 0.000000>, <-2.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-0.251584, -0.277791, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.000000, 0.000000, 0.000000>, <-2.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-0.251584, -0.277791, 0.000000>, 
      <-3.000000, 1.000000, 0.000000>, <-2.000000, 1.000000, 0.000000>, <-1.000000, 1.000000, 0.000000>, <-0.503168, 0.444418, 0.000000>, 
      <-3.000000, 2.000000, 0.000000>, <-2.000000, 2.000000, 0.000000>, <-1.482203, 1.727451, 0.000000>, <-1.016819, 0.972698, 0.000000>, 
      <-3.000000, 3.000000, 0.000000>, <-2.482203, 2.727451, 0.000000>, <-2.006336, 1.888837, 0.000000>, <-1.457091, 1.385669, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -3.000000, 0.000000>, <1.000000, -3.000000, 0.000000>, <2.000000, -3.000000, 0.000000>, <3.000000, -3.000000, 0.000000>, 
      <0.000000, -2.000000, 0.000000>, <1.000000, -2.000000, 0.000000>, <2.000000, -2.000000, 0.000000>, <2.517797, -2.272549, 0.000000>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <1.517797, -1.272549, 0.000000>, <1.993664, -2.111163, 0.000000>, 
      <-0.251584, -0.277791, 0.000000>, <0.496832, -0.555582, 0.000000>, <0.983181, -1.027302, 0.000000>, <1.542909, -1.614331, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.251584, -0.277791, 0.000000>, <0.496832, -0.555582, 0.000000>, <0.983181, -1.027302, 0.000000>, <1.542909, -1.614331, 0.000000>, 
      <-0.503168, 0.444418, 0.000000>, <-0.006336, -0.111163, 0.000000>, <0.448565, -0.782054, 0.000000>, <1.092154, -1.117499, 0.000000>, 
      <-1.016819, 0.972698, 0.000000>, <-0.551435, 0.217946, 0.000000>, <0.092154, -0.117499, 0.000000>, <0.630917, -0.662598, 0.000000>, 
      <-1.457091, 1.385669, 0.000000>, <-0.907846, 0.882501, 0.000000>, <-0.369083, 0.337402, 0.000000>, <0.211610, -0.228662, 0.000000>
    }
  }
  scale <0.2, 1.0, 0.4>
  rotate <90.0, 0.0, 180.0>
  translate  <2.4, 0.0, 3.5>
}
#declare WINGS2 = union {
  object { WING5 }
  object { WING6 }
  cylinder { // FUSILAGE2
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.2, 5.0>
    rotate -90.0*y
    translate  3.2*x
  }
  object { NOSECONE2 }
  object { TAILPLANE2 }
  texture {
    petelMyellow
  }
  bounded_by { // Bound8
    box {
      <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
      scale <3.372667, 6.172667, 3.922667>
      translate  <0.0, 0.0, 2.75>
    }
  }
  scale <5.0, 2.5, 1.0>
}
#declare eye5 = union {
  sphere { // Sphere14
    <0,0,0>,1
    texture {
      EYEMPUPIL
    }
    translate  <-0.108264, -1.461712, 0.0>
  }
  sphere { // Sphere15
    <0,0,0>,1
    texture {
      IRISMBLUE
    }
    scale 1.15
    translate  <-0.1, -1.3, 0.0>
  }
  sphere { // Sphere16
    <0,0,0>,1
    texture {
      Texture01
    }
    scale 2.3
  }
  bounded_by { // Bound10
    box {
      <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
      scale <2.393078, 2.473934, 2.393078>
      translate  <0.0, -0.080856, 0.0>
    }
  }
  scale <0.4, 0.2, 0.4>
  rotate <-90.0, -25.0, 0.0>
  translate  <-13.5, -1.5, 0.2>
}
union { // SPACEMSHIPMPL2
  object { eye4 }
  object { WINGS2 }
  cone { // flame2
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      Flame
    }
    bounded_by { // Bound9
      box {
        <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
        scale <1.033333, 1.033333, 0.533333>
        translate  <0.0, 0.0, 0.5>
      }
    }
    scale <1.0, 3.0, 25.0>
    rotate -90.0*y
    translate  41.0*x
  }
  object { eye5 }
  scale 0.2
  rotate <19.608274, 8.853139, 47.882221>
  translate  <-2.096862, 10.615246, 1.784265>
}


#declare eye2 = union {
  sphere { // Sphere5
    <0,0,0>,1
    texture {
      EYEMPUPIL
    }
    translate  <-0.108264, -1.461712, 0.0>
  }
  sphere { // Sphere6
    <0,0,0>,1
    texture {
      IRISMBLUE
    }
    scale 1.15
    translate  <-0.1, -1.3, 0.0>
  }
  sphere { // Sphere7
    <0,0,0>,1
    texture {
      Texture01
    }
    scale 2.3
  }
  bounded_by { // Bound4
    box {
      <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
      scale <2.393078, 2.473934, 2.393078>
      translate  <0.0, -0.080856, 0.0>
    }
  }
  scale <0.4, 0.2, 0.4>
  rotate <-90.0, -25.0, 0.0>
  translate  <-13.5, 1.5, 0.2>
}
#declare WING3 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.383242, -0.453965, -0.119353>, <0.239568, -1.043325, -0.119353>, <0.956675, -1.420515, -0.119353>, <1.273017, -1.821280, -0.119353>, 
      <-0.760432, -0.043325, -0.119353>, <-0.043325, -0.420515, -0.119353>, <0.956675, -0.420515, 0.000000>, <1.449825, -0.715195, 0.000000>, 
      <-1.043325, 0.579485, -0.119353>, <-0.043325, 0.579485, 0.000000>, <-1.000000, -1.000000, 0.000000>, <-0.153234, -1.082510, -0.059676>, 
      <-1.550175, 1.284805, -0.119353>, <-0.550175, 1.284805, 0.000000>, <-1.000000, 0.000000, -0.059676>, <-0.076617, -0.041255, -0.059676>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.550175, 1.284805, -0.119353>, <-0.550175, 1.284805, 0.000000>, <-1.000000, 0.000000, -0.059676>, <-0.076617, -0.041255, -0.059676>, 
      <-2.057024, 1.990125, -0.119353>, <-1.057024, 1.990125, 0.000000>, <-1.000000, 1.000000, -0.119353>, <0.000000, 1.000000, -0.059676>, 
      <-3.000000, 2.000000, -0.119353>, <-2.000000, 2.000000, -0.119353>, <-1.000000, 2.000000, 0.000000>, <0.000000, 2.000000, 0.000000>, 
      <-3.000000, 3.000000, -0.119353>, <-2.000000, 3.000000, 0.000000>, <-1.000000, 3.000000, 0.000000>, <0.000000, 3.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.273017, -1.821280, -0.119353>, <1.589360, -2.222045, -0.119353>, <2.000000, -3.000000, 0.417734>, <3.000000, -3.000000, 0.417734>, 
      <1.449825, -0.715195, 0.000000>, <1.942976, -1.009875, 0.000000>, <1.646384, -2.212170, -0.119353>, <3.000000, -2.000000, 0.000000>, 
      <-0.153234, -1.082510, -0.059676>, <0.693533, -1.165021, -0.119353>, <2.000000, -1.000000, 0.000000>, <3.000000, -1.000000, 0.000000>, 
      <-0.076617, -0.041255, -0.059676>, <0.846766, -0.082510, -0.059676>, <2.000000, 0.000000, 0.000000>, <3.000000, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.076617, -0.041255, -0.059676>, <0.846766, -0.082510, -0.059676>, <2.000000, 0.000000, 0.000000>, <3.000000, 0.000000, 0.000000>, 
      <0.000000, 1.000000, -0.059676>, <1.000000, 1.000000, 0.000000>, <2.000000, 1.000000, 0.000000>, <3.000000, 1.000000, 0.000000>, 
      <0.000000, 2.000000, 0.000000>, <1.000000, 2.000000, 0.000000>, <2.000000, 2.000000, 0.000000>, <3.000000, 2.000000, 0.000000>, 
      <0.000000, 3.000000, 0.000000>, <1.000000, 3.000000, 0.000000>, <2.000000, 3.000000, 0.000000>, <3.000000, 3.000000, 0.000000>
    }
  }
  translate  -3.0*y
}
#declare WING4 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.383242, 0.453965, -0.119353>, <0.239568, 1.043325, -0.119353>, <0.956675, 1.420515, -0.119353>, <1.273017, 1.821280, -0.119353>, 
      <-0.760432, 0.043325, -0.119353>, <-0.043325, 0.420515, -0.119353>, <0.956675, 0.420515, 0.000000>, <1.449825, 0.715195, 0.000000>, 
      <-1.043325, -0.579485, -0.119353>, <-0.043325, -0.579485, 0.000000>, <-1.000000, 1.000000, 0.000000>, <-0.153234, 1.082510, -0.059676>, 
      <-1.550175, -1.284805, -0.119353>, <-0.550175, -1.284805, 0.000000>, <-1.000000, 0.000000, -0.059676>, <-0.076617, 0.041255, -0.059676>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.550175, -1.284805, -0.119353>, <-0.550175, -1.284805, 0.000000>, <-1.000000, 0.000000, -0.059676>, <-0.076617, 0.041255, -0.059676>, 
      <-2.057024, -1.990125, -0.119353>, <-1.057024, -1.990125, 0.000000>, <-1.000000, -1.000000, -0.119353>, <0.000000, -1.000000, -0.059676>, 
      <-3.000000, -2.000000, -0.119353>, <-2.000000, -2.000000, -0.119353>, <-1.000000, -2.000000, 0.000000>, <0.000000, -2.000000, 0.000000>, 
      <-3.000000, -3.000000, -0.119353>, <-2.000000, -3.000000, 0.000000>, <-1.000000, -3.000000, 0.000000>, <0.000000, -3.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.273017, 1.821280, -0.119353>, <1.589360, 2.222045, -0.119353>, <2.000000, 3.000000, 0.417734>, <3.000000, 3.000000, 0.417734>, 
      <1.449825, 0.715195, 0.000000>, <1.942976, 1.009875, 0.000000>, <1.646384, 2.212170, -0.119353>, <3.000000, 2.000000, 0.000000>, 
      <-0.153234, 1.082510, -0.059676>, <0.693533, 1.165021, -0.119353>, <2.000000, 1.000000, 0.000000>, <3.000000, 1.000000, 0.000000>, 
      <-0.076617, 0.041255, -0.059676>, <0.846766, 0.082510, -0.059676>, <2.000000, 0.000000, 0.000000>, <3.000000, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.076617, 0.041255, -0.059676>, <0.846766, 0.082510, -0.059676>, <2.000000, 0.000000, 0.000000>, <3.000000, 0.000000, 0.000000>, 
      <0.000000, -1.000000, -0.059676>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.000000, -1.000000, 0.000000>, 
      <0.000000, -2.000000, 0.000000>, <1.000000, -2.000000, 0.000000>, <2.000000, -2.000000, 0.000000>, <3.000000, -2.000000, 0.000000>, 
      <0.000000, -3.000000, 0.000000>, <1.000000, -3.000000, 0.000000>, <2.000000, -3.000000, 0.000000>, <3.000000, -3.000000, 0.000000>
    }
  }
  translate  3.0*y
}
#declare NOSECONE1 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.675752, -0.012036, 0.000000>, <0.675752, -0.010966, 0.000000>, <0.673388, -0.010966, 0.000000>, <0.673388, -0.012036, 0.000000>, 
      <-1.000000, 0.000000, 2.000000>, <-1.000000, -1.000000, 2.000000>, <1.000000, -1.000000, 2.000000>, <1.000000, 0.000000, 2.000000>, 
      <-1.000000, 0.000000, 4.000000>, <-1.000000, -1.000000, 4.000000>, <1.000000, -1.000000, 4.000000>, <1.000000, 0.000000, 4.000000>, 
      <-1.000000, 0.000000, 6.000000>, <-1.000000, -1.000000, 6.000000>, <1.000000, -1.000000, 6.000000>, <1.000000, 0.000000, 6.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.673388, -0.012036, 0.000000>, <0.673388, -0.013105, 0.000000>, <0.675752, -0.013105, 0.000000>, <0.675752, -0.012036, 0.000000>, 
      <1.000000, 0.000000, 2.000000>, <1.000000, 1.000000, 2.000000>, <-1.000000, 1.000000, 2.000000>, <-1.000000, 0.000000, 2.000000>, 
      <1.000000, 0.000000, 4.000000>, <1.000000, 1.000000, 4.000000>, <-1.000000, 1.000000, 4.000000>, <-1.000000, 0.000000, 4.000000>, 
      <1.000000, 0.000000, 6.000000>, <1.000000, 1.000000, 6.000000>, <-1.000000, 1.000000, 6.000000>, <-1.000000, 0.000000, 6.000000>
    }
  }
  scale <1.0, 1.6, 0.24>
  rotate 90.0*y
  translate  -3.2*x
}
#declare TAILPLANE1 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.000000, -3.000000, 0.000000>, <-2.000000, -3.000000, 0.000000>, <-1.000000, -3.000000, 0.000000>, <0.000000, -3.000000, 0.000000>, 
      <-3.000000, -2.000000, 0.000000>, <-2.000000, -2.000000, 0.000000>, <-1.000000, -2.000000, 0.000000>, <0.000000, -2.000000, 0.000000>, 
      <-3.000000, -1.000000, 0.000000>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.000000, 0.000000, 0.000000>, <-2.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-0.251584, -0.277791, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.000000, 0.000000, 0.000000>, <-2.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-0.251584, -0.277791, 0.000000>, 
      <-3.000000, 1.000000, 0.000000>, <-2.000000, 1.000000, 0.000000>, <-1.000000, 1.000000, 0.000000>, <-0.503168, 0.444418, 0.000000>, 
      <-3.000000, 2.000000, 0.000000>, <-2.000000, 2.000000, 0.000000>, <-1.482203, 1.727451, 0.000000>, <-1.016819, 0.972698, 0.000000>, 
      <-3.000000, 3.000000, 0.000000>, <-2.482203, 2.727451, 0.000000>, <-2.006336, 1.888837, 0.000000>, <-1.457091, 1.385669, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -3.000000, 0.000000>, <1.000000, -3.000000, 0.000000>, <2.000000, -3.000000, 0.000000>, <3.000000, -3.000000, 0.000000>, 
      <0.000000, -2.000000, 0.000000>, <1.000000, -2.000000, 0.000000>, <2.000000, -2.000000, 0.000000>, <2.517797, -2.272549, 0.000000>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <1.517797, -1.272549, 0.000000>, <1.993664, -2.111163, 0.000000>, 
      <-0.251584, -0.277791, 0.000000>, <0.496832, -0.555582, 0.000000>, <0.983181, -1.027302, 0.000000>, <1.542909, -1.614331, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.251584, -0.277791, 0.000000>, <0.496832, -0.555582, 0.000000>, <0.983181, -1.027302, 0.000000>, <1.542909, -1.614331, 0.000000>, 
      <-0.503168, 0.444418, 0.000000>, <-0.006336, -0.111163, 0.000000>, <0.448565, -0.782054, 0.000000>, <1.092154, -1.117499, 0.000000>, 
      <-1.016819, 0.972698, 0.000000>, <-0.551435, 0.217946, 0.000000>, <0.092154, -0.117499, 0.000000>, <0.630917, -0.662598, 0.000000>, 
      <-1.457091, 1.385669, 0.000000>, <-0.907846, 0.882501, 0.000000>, <-0.369083, 0.337402, 0.000000>, <0.211610, -0.228662, 0.000000>
    }
  }
  scale <0.2, 1.0, 0.4>
  rotate <90.0, 0.0, 180.0>
  translate  <2.4, 0.0, 3.5>
}
#declare WINGS1 = union {
  object { WING3 }
  object { WING4 }
  cylinder { // FUSILAGE1
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.2, 5.0>
    rotate -90.0*y
    translate  3.2*x
  }
  object { NOSECONE1 }
  object { TAILPLANE1 }
  texture {
    petelMyellow
  }
  bounded_by { // Bound2
    box {
      <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
      scale <3.372667, 6.172667, 3.922667>
      translate  <0.0, 0.0, 2.75>
    }
  }
  scale <5.0, 2.5, 1.0>
}
#declare eye3 = union {
  sphere { // Sphere8
    <0,0,0>,1
    texture {
      EYEMPUPIL
    }
    translate  <-0.108264, -1.461712, 0.0>
  }
  sphere { // Sphere9
    <0,0,0>,1
    texture {
      IRISMBLUE
    }
    scale 1.15
    translate  <-0.1, -1.3, 0.0>
  }
  sphere { // Sphere10
    <0,0,0>,1
    texture {
      Texture01
    }
    scale 2.3
  }
  bounded_by { // Bound6
    box {
      <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
      scale <2.393078, 2.473934, 2.393078>
      translate  <0.0, -0.080856, 0.0>
    }
  }
  scale <0.4, 0.2, 0.4>
  rotate <-90.0, -25.0, 0.0>
  translate  <-13.5, -1.5, 0.2>
}
union { // SPACEMSHIPMPL1
  object { eye2 }
  object { WINGS1 }
  cone { // flame1
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      Flame
    }
    bounded_by { // Bound5
      box {
        <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
        scale <1.033333, 1.033333, 0.533333>
        translate  <0.0, 0.0, 0.5>
      }
    }
    scale <1.0, 3.0, 25.0>
    rotate -90.0*y
    translate  41.0*x
  }
  object { eye3 }
  scale 0.1
  rotate <19.5231, -0.1228, 17.683916>
  translate  <12.196955, 14.273854, 1.784265>
}


sphere { // STARSMBALL
  <0,0,0>,1
  texture {
    STARS
    scale 1000.0
  }
  hollow
  scale 500000.0
}


#declare PORTHOLESMGRP = union {
  sphere { // PORTHOLE
    <0,0,0>,1
    scale <0.3, 0.2, 0.2>
    translate  <0.0, -5.0, 1.1>
  }
  sphere { // PORTHOLE1
    <0,0,0>,1
    scale <0.3, 0.2, 0.2>
    rotate -60.0*z
    translate  <-4.330127, -2.5, 1.1>
  }
  sphere { // PORTHOLE5
    <0,0,0>,1
    scale <0.3, 0.2, 0.2>
    rotate 60.0*z
    translate  <4.330127, -2.5, 1.1>
  }
  sphere { // PORTHOLE4
    <0,0,0>,1
    scale <0.3, 0.2, 0.2>
    rotate 120.0*z
    translate  <4.330127, 2.5, 1.1>
  }
  sphere { // PORTHOLE3
    <0,0,0>,1
    scale <0.3, 0.2, 0.2>
    rotate 180.0*z
    translate  <0.0, 5.0, 1.1>
  }
  sphere { // PORTHOLE2
    <0,0,0>,1
    scale <0.3, 0.2, 0.2>
    rotate -120.0*z
    translate  <-4.330127, 2.5, 1.1>
  }
  texture {
    Glass5
  }
}
#declare RADARMBOWL = intersection {
  plane { // RADARMCUT
    z,0
    scale <1.2, 1.2, 1.0>
    rotate <180.0, -80.0, 130.0>
    translate  3.2*z
  }
  sphere { // RADAR
    <0,0,0>,1
    translate  3.2*z
  }
  texture {
    Silver4
  }
}
#declare RADARMGROUP = union {
  torus { // RADARMRINGMSUPP
    1.05, 0.05  rotate -x*90
    rotate <-50.0, -90.0, 0.0>
    translate  3.2*z
  }
  cylinder { // RADARMSUPPORT
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 2.06>
    rotate <40.0, -90.0, 0.0>
    translate  <0.8, 0.67, 3.2>
  }
  object { RADARMBOWL }
  cylinder { // UPRIGHT
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 1.0>
    rotate 20.0*z
    translate  1.15*z
  }
  rotate -20.0*z
}
#declare SPACEMSTATION = union {
  superellipsoid { // BODY
    <1.0, 0.1>
    scale <1.0, 1.0, 3.0>
    translate  -1.0*z
  }
  cylinder { // ARM6
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 3.0>
    rotate <0.0, -70.0, 60.0>
    translate  <-0.45, -0.779423, 0.0>
  }
  cylinder { // ARM5
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 3.0>
    rotate <0.0, -70.0, 120.0>
    translate  <0.45, -0.779423, 0.0>
  }
  cylinder { // ARM4
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 3.0>
    rotate <0.0, -70.0, 180.0>
    translate  <0.9, 0.0, 0.0>
  }
  cylinder { // ARM3
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 3.0>
    rotate <0.0, -70.0, -120.0>
    translate  <0.45, 0.779423, 0.0>
  }
  cylinder { // ARM2
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 3.0>
    rotate <0.0, -70.0, -60.0>
    translate  <-0.45, 0.779423, 0.0>
  }
  cylinder { // ARM01
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 3.0>
    rotate -70.0*y
    translate  -0.9*x
  }
  torus { // Torus001
    4.25, 0.75  rotate -x*90
    texture {
      Silver4
    }
    translate  1.1*z
  }
  object { RADARMGROUP }
  texture {
    Silver4
  }
}
union { // SPACEMSTNMASSY
  object { PORTHOLESMGRP }
  object { SPACEMSTATION }
}


sphere { // WORLD
  <0,0,0>,1
  texture {
    WORLDMBALL
  }
  scale 10.0
  rotate -15.0*z
  translate  <3.912848, 51.443133, -1.761629>
}




#declare eye = union {
  sphere { // Sphere003
    <0,0,0>,1
    texture {
      EYEMPUPIL
    }
    translate  <-0.108264, -1.461712, 0.0>
  }
  sphere { // Sphere002
    <0,0,0>,1
    texture {
      IRISMBLUE
    }
    scale 1.15
    translate  <-0.1, -1.3, 0.0>
  }
  sphere { // Sphere001
    <0,0,0>,1
    texture {
      Texture01
    }
    scale 2.3
  }
  bounded_by { // Bound00002
    box {
      <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
      scale <2.393078, 2.473934, 2.393078>
      translate  <0.0, -0.080856, 0.0>
    }
  }
  scale <0.4, 0.2, 0.4>
  rotate <-90.0, -25.0, 0.0>
  translate  <-13.5, 1.5, 0.2>
}
#declare WING01 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.383242, -0.453965, -0.119353>, <0.239568, -1.043325, -0.119353>, <0.956675, -1.420515, -0.119353>, <1.273017, -1.821280, -0.119353>, 
      <-0.760432, -0.043325, -0.119353>, <-0.043325, -0.420515, -0.119353>, <0.956675, -0.420515, 0.000000>, <1.449825, -0.715195, 0.000000>, 
      <-1.043325, 0.579485, -0.119353>, <-0.043325, 0.579485, 0.000000>, <-1.000000, -1.000000, 0.000000>, <-0.153234, -1.082510, -0.059676>, 
      <-1.550175, 1.284805, -0.119353>, <-0.550175, 1.284805, 0.000000>, <-1.000000, 0.000000, -0.059676>, <-0.076617, -0.041255, -0.059676>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.550175, 1.284805, -0.119353>, <-0.550175, 1.284805, 0.000000>, <-1.000000, 0.000000, -0.059676>, <-0.076617, -0.041255, -0.059676>, 
      <-2.057024, 1.990125, -0.119353>, <-1.057024, 1.990125, 0.000000>, <-1.000000, 1.000000, -0.119353>, <0.000000, 1.000000, -0.059676>, 
      <-3.000000, 2.000000, -0.119353>, <-2.000000, 2.000000, -0.119353>, <-1.000000, 2.000000, 0.000000>, <0.000000, 2.000000, 0.000000>, 
      <-3.000000, 3.000000, -0.119353>, <-2.000000, 3.000000, 0.000000>, <-1.000000, 3.000000, 0.000000>, <0.000000, 3.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.273017, -1.821280, -0.119353>, <1.589360, -2.222045, -0.119353>, <2.000000, -3.000000, 0.417734>, <3.000000, -3.000000, 0.417734>, 
      <1.449825, -0.715195, 0.000000>, <1.942976, -1.009875, 0.000000>, <1.646384, -2.212170, -0.119353>, <3.000000, -2.000000, 0.000000>, 
      <-0.153234, -1.082510, -0.059676>, <0.693533, -1.165021, -0.119353>, <2.000000, -1.000000, 0.000000>, <3.000000, -1.000000, 0.000000>, 
      <-0.076617, -0.041255, -0.059676>, <0.846766, -0.082510, -0.059676>, <2.000000, 0.000000, 0.000000>, <3.000000, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.076617, -0.041255, -0.059676>, <0.846766, -0.082510, -0.059676>, <2.000000, 0.000000, 0.000000>, <3.000000, 0.000000, 0.000000>, 
      <0.000000, 1.000000, -0.059676>, <1.000000, 1.000000, 0.000000>, <2.000000, 1.000000, 0.000000>, <3.000000, 1.000000, 0.000000>, 
      <0.000000, 2.000000, 0.000000>, <1.000000, 2.000000, 0.000000>, <2.000000, 2.000000, 0.000000>, <3.000000, 2.000000, 0.000000>, 
      <0.000000, 3.000000, 0.000000>, <1.000000, 3.000000, 0.000000>, <2.000000, 3.000000, 0.000000>, <3.000000, 3.000000, 0.000000>
    }
  }
  translate  -3.0*y
}
#declare WING2 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.383242, 0.453965, -0.119353>, <0.239568, 1.043325, -0.119353>, <0.956675, 1.420515, -0.119353>, <1.273017, 1.821280, -0.119353>, 
      <-0.760432, 0.043325, -0.119353>, <-0.043325, 0.420515, -0.119353>, <0.956675, 0.420515, 0.000000>, <1.449825, 0.715195, 0.000000>, 
      <-1.043325, -0.579485, -0.119353>, <-0.043325, -0.579485, 0.000000>, <-1.000000, 1.000000, 0.000000>, <-0.153234, 1.082510, -0.059676>, 
      <-1.550175, -1.284805, -0.119353>, <-0.550175, -1.284805, 0.000000>, <-1.000000, 0.000000, -0.059676>, <-0.076617, 0.041255, -0.059676>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.550175, -1.284805, -0.119353>, <-0.550175, -1.284805, 0.000000>, <-1.000000, 0.000000, -0.059676>, <-0.076617, 0.041255, -0.059676>, 
      <-2.057024, -1.990125, -0.119353>, <-1.057024, -1.990125, 0.000000>, <-1.000000, -1.000000, -0.119353>, <0.000000, -1.000000, -0.059676>, 
      <-3.000000, -2.000000, -0.119353>, <-2.000000, -2.000000, -0.119353>, <-1.000000, -2.000000, 0.000000>, <0.000000, -2.000000, 0.000000>, 
      <-3.000000, -3.000000, -0.119353>, <-2.000000, -3.000000, 0.000000>, <-1.000000, -3.000000, 0.000000>, <0.000000, -3.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.273017, 1.821280, -0.119353>, <1.589360, 2.222045, -0.119353>, <2.000000, 3.000000, 0.417734>, <3.000000, 3.000000, 0.417734>, 
      <1.449825, 0.715195, 0.000000>, <1.942976, 1.009875, 0.000000>, <1.646384, 2.212170, -0.119353>, <3.000000, 2.000000, 0.000000>, 
      <-0.153234, 1.082510, -0.059676>, <0.693533, 1.165021, -0.119353>, <2.000000, 1.000000, 0.000000>, <3.000000, 1.000000, 0.000000>, 
      <-0.076617, 0.041255, -0.059676>, <0.846766, 0.082510, -0.059676>, <2.000000, 0.000000, 0.000000>, <3.000000, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.076617, 0.041255, -0.059676>, <0.846766, 0.082510, -0.059676>, <2.000000, 0.000000, 0.000000>, <3.000000, 0.000000, 0.000000>, 
      <0.000000, -1.000000, -0.059676>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.000000, -1.000000, 0.000000>, 
      <0.000000, -2.000000, 0.000000>, <1.000000, -2.000000, 0.000000>, <2.000000, -2.000000, 0.000000>, <3.000000, -2.000000, 0.000000>, 
      <0.000000, -3.000000, 0.000000>, <1.000000, -3.000000, 0.000000>, <2.000000, -3.000000, 0.000000>, <3.000000, -3.000000, 0.000000>
    }
  }
  translate  3.0*y
}
#declare NOSECONE = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.675752, -0.012036, 0.000000>, <0.675752, -0.010966, 0.000000>, <0.673388, -0.010966, 0.000000>, <0.673388, -0.012036, 0.000000>, 
      <-1.000000, 0.000000, 2.000000>, <-1.000000, -1.000000, 2.000000>, <1.000000, -1.000000, 2.000000>, <1.000000, 0.000000, 2.000000>, 
      <-1.000000, 0.000000, 4.000000>, <-1.000000, -1.000000, 4.000000>, <1.000000, -1.000000, 4.000000>, <1.000000, 0.000000, 4.000000>, 
      <-1.000000, 0.000000, 6.000000>, <-1.000000, -1.000000, 6.000000>, <1.000000, -1.000000, 6.000000>, <1.000000, 0.000000, 6.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.673388, -0.012036, 0.000000>, <0.673388, -0.013105, 0.000000>, <0.675752, -0.013105, 0.000000>, <0.675752, -0.012036, 0.000000>, 
      <1.000000, 0.000000, 2.000000>, <1.000000, 1.000000, 2.000000>, <-1.000000, 1.000000, 2.000000>, <-1.000000, 0.000000, 2.000000>, 
      <1.000000, 0.000000, 4.000000>, <1.000000, 1.000000, 4.000000>, <-1.000000, 1.000000, 4.000000>, <-1.000000, 0.000000, 4.000000>, 
      <1.000000, 0.000000, 6.000000>, <1.000000, 1.000000, 6.000000>, <-1.000000, 1.000000, 6.000000>, <-1.000000, 0.000000, 6.000000>
    }
  }
  scale <1.0, 1.6, 0.24>
  rotate 90.0*y
  translate  -3.2*x
}
#declare TAILPLANE = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.000000, -3.000000, 0.000000>, <-2.000000, -3.000000, 0.000000>, <-1.000000, -3.000000, 0.000000>, <0.000000, -3.000000, 0.000000>, 
      <-3.000000, -2.000000, 0.000000>, <-2.000000, -2.000000, 0.000000>, <-1.000000, -2.000000, 0.000000>, <0.000000, -2.000000, 0.000000>, 
      <-3.000000, -1.000000, 0.000000>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.000000, 0.000000, 0.000000>, <-2.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-0.251584, -0.277791, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.000000, 0.000000, 0.000000>, <-2.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-0.251584, -0.277791, 0.000000>, 
      <-3.000000, 1.000000, 0.000000>, <-2.000000, 1.000000, 0.000000>, <-1.000000, 1.000000, 0.000000>, <-0.503168, 0.444418, 0.000000>, 
      <-3.000000, 2.000000, 0.000000>, <-2.000000, 2.000000, 0.000000>, <-1.482203, 1.727451, 0.000000>, <-1.016819, 0.972698, 0.000000>, 
      <-3.000000, 3.000000, 0.000000>, <-2.482203, 2.727451, 0.000000>, <-2.006336, 1.888837, 0.000000>, <-1.457091, 1.385669, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -3.000000, 0.000000>, <1.000000, -3.000000, 0.000000>, <2.000000, -3.000000, 0.000000>, <3.000000, -3.000000, 0.000000>, 
      <0.000000, -2.000000, 0.000000>, <1.000000, -2.000000, 0.000000>, <2.000000, -2.000000, 0.000000>, <2.517797, -2.272549, 0.000000>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <1.517797, -1.272549, 0.000000>, <1.993664, -2.111163, 0.000000>, 
      <-0.251584, -0.277791, 0.000000>, <0.496832, -0.555582, 0.000000>, <0.983181, -1.027302, 0.000000>, <1.542909, -1.614331, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.251584, -0.277791, 0.000000>, <0.496832, -0.555582, 0.000000>, <0.983181, -1.027302, 0.000000>, <1.542909, -1.614331, 0.000000>, 
      <-0.503168, 0.444418, 0.000000>, <-0.006336, -0.111163, 0.000000>, <0.448565, -0.782054, 0.000000>, <1.092154, -1.117499, 0.000000>, 
      <-1.016819, 0.972698, 0.000000>, <-0.551435, 0.217946, 0.000000>, <0.092154, -0.117499, 0.000000>, <0.630917, -0.662598, 0.000000>, 
      <-1.457091, 1.385669, 0.000000>, <-0.907846, 0.882501, 0.000000>, <-0.369083, 0.337402, 0.000000>, <0.211610, -0.228662, 0.000000>
    }
  }
  scale <0.2, 1.0, 0.4>
  rotate <90.0, 0.0, 180.0>
  translate  <2.4, 0.0, 3.5>
}
#declare WINGS = union {
  object { WING01 }
  object { WING2 }
  cylinder { // FUSILAGE
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.2, 5.0>
    rotate -90.0*y
    translate  3.2*x
  }
  object { NOSECONE }
  object { TAILPLANE }
  texture {
    petelMyellow
  }
  bounded_by { // Bound00001
    box {
      <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
      scale <3.372667, 6.172667, 3.922667>
      translate  <0.0, 0.0, 2.75>
    }
  }
  scale <5.0, 2.5, 1.0>
}
#declare eye1 = union {
  sphere { // Sphere4
    <0,0,0>,1
    texture {
      EYEMPUPIL
    }
    translate  <-0.108264, -1.461712, 0.0>
  }
  sphere { // Sphere3
    <0,0,0>,1
    texture {
      IRISMBLUE
    }
    scale 1.15
    translate  <-0.1, -1.3, 0.0>
  }
  sphere { // Sphere2
    <0,0,0>,1
    texture {
      Texture01
    }
    scale 2.3
  }
  bounded_by { // Bound3
    box {
      <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
      scale <2.393078, 2.473934, 2.393078>
      translate  <0.0, -0.080856, 0.0>
    }
  }
  scale <0.4, 0.2, 0.4>
  rotate <-90.0, -25.0, 0.0>
  translate  <-13.5, -1.5, 0.2>
}
union { // SPACEMSHIPMPLN
  object { eye }
  object { WINGS }
  cone { // flame
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      Flame
    }
    bounded_by { // Bound00003
      box {
        <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
        scale <1.033333, 1.033333, 0.533333>
        translate  <0.0, 0.0, 0.5>
      }
    }
    scale <1.0, 3.0, 25.0>
    rotate -90.0*y
    translate  41.0*x
  }
  object { eye1 }
  no_shadow
  scale 0.3
  rotate <-22.282852, 22.982307, -157.137619>
  translate  <-7.459116, -11.234468, 1.401209>
}


