//  Resting glider

#declare Dragon_Skin = texture {
    pigment {
      image_map {
        gif "c:\povray3\include\d-scales.gif"
        map_type 1
      }
      scale 5
    }
 }

#declare Inferno_1 = texture {
  pigment {
    wood
    turbulence 0.3
    color_map {
      [0   0.58   color rgb <0.3501, 0.4402, 0.0798>
                  color rgb <0.3501, 0.4402, 0.0798>]
      [0.58 0.44  color rgb <0.3623, 0.1044, 0.5842>
                  color rgb <0.9410, 0.9179, 0.3361>]
      [0.44 0.00  color rgb <0.5917, 0.8572, 0.5896>
                  color rgb <0.7324, 0.2038, 0.2956>]
      [0.00 1.001 color rgb <0.7324, 0.2038, 0.2956>
                  color rgb <0.6273, 0.9007, 0.1178>]
    }
  }
  finish {phong 0.33 phong_size 90 ambient 0.4}
  normal {wrinkles 0.2}
  scale <0.5 0.4 0.7>
  rotate <3 340 91>
}

#declare Leopard = texture {
  pigment {
    leopard
    turbulence 0.4
    color_map {
      [0   0.07   color rgbf <0.8944, 0.8251, 0.1203, .31>
                  color rgbf <0.8944, 0.8251, 0.1203, .31>]
      [0.07 0.19  color rgbf <0.6406, 0.1485, 0.1700, .02>
                  color rgbf <0.6406, 0.1485, 0.1700, .02>]
      [0.19 0.37  color rgbf <0.3889, 0.0074, 0.3002, .9>
                  color rgbf <0.3889, 0.0074, 0.3002, .9>]
      [0.37 0.57  color rgbf <0.2357, 0.2495, 0.1793, .62>
                  color rgbf <0.2357, 0.2495, 0.1793, .62>]
      [0.57 0.84  color rgbf <0.3302, 0.1342, 0.0686, .89>
                  color rgbf <0.3302, 0.1342, 0.0686, .89>]
      [0.84 1.00  color rgbf <0.0260, 0.8683, 0.9984, .93>
                  color rgbf <0.0260, 0.8683, 0.9984, .93>]
    }
  }
  finish {phong 0.57 phong_size 90 ambient 0.4}
  normal {bumps 0.1}
  scale <0.06 0.09 0.06>
  rotate <318 279 203>
}

//****************** ACTION **********************

#declare rwing_skin = union {  // Layer name: rwing_skin
    cone { <0.0, 0.0, 0.0>, 3, <0.0, 14, 0.0>, 0
        scale <1, 1, 0.01>
        rotate <65, .0, .0>
        rotate <.0, 215, .0>
        translate <10.5879, 0.813701, 1.61535>
    }
    cone { <0.0, 0.0, 0.0>, 4, <0.0, 14, 0.0>, 0
        scale <1, 1, 0.01>
        rotate <65, .0, .0>
        rotate <.0, 180, .0>
        translate <3.37, 0.813701, 4.30192>
    }
    cone { <0.0, 0.0, 0.0>, 3.5, <0.0, 14, 0.0>, 0
        scale <1, 1, 0.01>
        rotate <65, .0, .0>
        rotate <.0, 145, .0>
        translate <-4.35388, 0.813701, 2.06311>
    }
}

#declare lwing_skin = union {  // Layer name: lwing_skin
    cone { <0.0, 0.0, 0.0>, 3.5, <0.0, 14, 0.0>, 0
        scale <1, 1, 0.01>
        rotate <65, .0, .0>
        rotate <.0, 145, .0>
        translate <-30.1987, 0.813701, 2.06311>
    }
    cone { <0.0, 0.0, 0.0>, 4, <0.0, 14, 0.0>, 0
        scale <1, 1, 0.01>
        rotate <65, .0, .0>
        rotate <.0, 180, .0>
        translate <-22.4748, 0.813701, 4.30192>
    }
    cone { <0.0, 0.0, 0.0>, 3, <0.0, 14, 0.0>, 0
        scale <1, 1, 0.01>
        rotate <65, .0, .0>
        rotate <.0, 215, .0>
        translate <-15.4225, 0.813701, 1.61535>
    }
}

#declare right_wing = union {  // Layer name: right_wing
    cone { <0.0, 0.0, 0.0>, 0, <0.0, 6, 0.0>, 0.6010269
        rotate <295, .0, .0>
        rotate <.0, 20, .0>
        translate <10.2862, -2.61718, 9.87509>
    }
    cone { <0.0, 0.0, 0.0>, 0, <0.0, 6, 0.0>, 0.6010269
        rotate <295, .0, .0>
        rotate <.0, 340, .0>
        translate <-3.18722, -2.61718, 9.87509>
    }
    cone { <0.0, 0.0, 0.0>, 0, <0.0, 5, 0.0>, 0.6010269
        rotate <295, .0, .0>
        rotate <.0, 50, .0>
        translate <17.6819, -2.21686, 3.55643>
    }
    cone { <0.0, 0.0, 0.0>, 0.6010269, <0.0, 16, 0.0>, 0.6010269
        rotate <295, .0, .0>
        rotate <.0, 50, .0>
        translate <14.1737, -0.08182134, 0.6310601>
    }
    cone { <0.0, 0.0, 0.0>, 0.6010269, <0.0, 16, 0.0>, 0.6010269
        rotate <295, .0, .0>
        rotate <.0, 340, .0>
        translate <-1.43528, -0.08182134, 4.79345>
    }
    cone { <0.0, 0.0, 0.0>, 0.6010269, <0.0, 16, 0.0>, 0.6010269
        rotate <295, .0, .0>
        rotate <.0, 20, .0>
        translate <8.27696, -0.08182134, 4.79345>
    }
    cone { <0.0, 0.0, 0.0>, 0.6010269, <0.0, 14.0435, 0.0>, 0.6010269
        rotate <65, .0, .0>
        rotate <.0, 130, .0>
        translate <-6.43592, 0.7839554, -0.3587906>
    }
    cone { <0.0, 0.0, 0.0>, 0.6626866, <0.0, 4.63881, 0.0>, 0
        rotate <240, .0, .0>
        translate <3.38621, 6.58087, -8.73331>
    }
}

#declare left_wing = union {  // Layer name: left_wing
    cone { <0.0, 0.0, 0.0>, 0, <0.0, 6, 0.0>, 0.6010269
        rotate <295, .0, .0>
        rotate <.0, 20, .0>
        translate <-15.6839, -2.61718, 9.87509>
    }
    cone { <0.0, 0.0, 0.0>, 0, <0.0, 6, 0.0>, 0.6010269
        rotate <295, .0, .0>
        rotate <.0, 340, .0>
        translate <-29.1574, -2.61718, 9.87509>
    }
    cone { <0.0, 0.0, 0.0>, 0, <0.0, 5, 0.0>, 0.6010269
        rotate <295, .0, .0>
        rotate <.0, 310, .0>
        translate <-36.9449, -2.21686, 3.55643>
    }
    cone { <0.0, 0.0, 0.0>, 0.6626866, <0.0, 4.63881, 0.0>, 0
        rotate <240, .0, .0>
        translate <-22.4188, 6.58087, -8.46823>
    }
    cone { <0.0, 0.0, 0.0>, 0.6010269, <0.0, 16, 0.0>, 0.6010269
        rotate <295, .0, .0>
        rotate <.0, 310, .0>
        translate <-33.3927, -0.08182134, 0.6310601>
    }
    cone { <0.0, 0.0, 0.0>, 0.6010269, <0.0, 16, 0.0>, 0.6010269
        rotate <295, .0, .0>
        rotate <.0, 340, .0>
        translate <-27.2768, -0.08182134, 4.79345>
    }
    cone { <0.0, 0.0, 0.0>, 0.6010269, <0.0, 16, 0.0>, 0.6010269
        rotate <295, .0, .0>
        rotate <.0, 20, .0>
        translate <-17.5645, -0.08182134, 4.79345>
    }
    cone { <0.0, 0.0, 0.0>, 0.6010269, <0.0, 14.0435, 0.0>, 0.6010269
        rotate <65, .0, .0>
        rotate <.0, 230, .0>
        translate <-12.6917, 0.761756, -0.4303608>
    }
}

#declare head = difference {  // Layer name: lower_head
    sphere { <0.0, 0.0, 0.0>, 6.47653
        texture { Dragon_Skin }
        scale <0.2, 0.1, 1>
        rotate <340, .0, .0>
        translate <-9.92945, 2.68146, -7.08008>
    }
    box { <0.0, 0.0, 0.0>, <3, 2, 11> // Layer name: lower_head_c
            texture { Dragon_Skin }
            rotate <340, .0, .0>
            translate <-11.4836, 0.1063667, -14.0321>
    }
}

#declare tail = union {  // Layer name: tail without cutouts
    cone { <0.0, 0.0, 0.0>, 0.2298507, <0.0, 3, 0.0>, 0
        pigment {DMFLightOak }
        rotate <330, .0, .0>
        translate <-9.58, 5.25015, 45.1465>
    }
    cone { <0.0, 0.0, 0.0>, 0.6, <0.0, 3.13633, 0.0>, 0.6
        pigment {DMFLightOak }
        scale <0.3, 1, 0.3>
        rotate <350, .0, .0>
        translate <-9.91582, 1.72537, 45.8722>
    }
    cone { <0.0, 0.0, 0.0>, 0.6, <0.0, 3.13633, 0.0>, 0.6
        pigment {DMFLightOak }
        scale <0.4, 1, 0.4>
        rotate <40, .0, .0>
        translate <-9.91582, -1.03284, 43.8035>
    }
    cone { <0.0, 0.0, 0.0>, 0.6, <0.0, 3.13633, 0.0>, 0.6
        pigment {DMFLightOak }
        scale <0.5, 1, 0.5>
        rotate <85, .0, .0>
        translate <-9.91582, -1.4006, 40.3098>
    }
    cone { <0.0, 0.0, 0.0>, 0.6, <0.0, 3.13633, 0.0>, 0.6
        pigment {DMFLightOak }
        scale <0.55, 1, 0.55>
        rotate <120, .0, .0>
        translate <-9.91582, 0.2543284, 37.1838>
    }
    cone { <0.0, 0.0, 0.0>, 0.6, <0.0, 3.13633, 0.0>, 0.6
        pigment {DMFLightOak }
        scale <0.6, 1, 0.6>
        rotate <155, .0, .0>
        translate <-9.91582, 3.42328, 35.6453>
    }
    cone { <0.0, 0.0, 0.0>, 0.6, <0.0, 3.13633, 0.0>, 0.6
        pigment {DMFLightOak }
        scale <0.65, 1, 0.65>
        rotate <155, .0, .0>
        translate <-9.91582, 6.60179, 34.2005>
    }
    cone { <0.0, 0.0, 0.0>, 0.6, <0.0, 3.13633, 0.0>, 0.6
        pigment {DMFLightOak }
        scale <0.7, 1, 0.7>
        rotate <135, .0, .0>
        translate <-9.91582, 8.91343, 31.6722>
    }
    cone { <0.0, 0.0, 0.0>, 0.6, <0.0, 3.13633, 0.0>, 0.6
        pigment {DMFLightOak }
        scale <0.75, 1, 0.75>
        rotate <115, .0, .0>
        translate <-9.91582, 10.3582, 28.5659>
    }
    cone { <0.0, 0.0, 0.0>, 0.6, <0.0, 3.13633, 0.0>, 0.6
        pigment {DMFLightOak }
        scale <0.75, 1, 0.75>
        rotate <95, .0, .0>
        translate <-9.91582, 10.7594, 25.0053>
    }
    cone { <0.0, 0.0, 0.0>, 0.6, <0.0, 3.13633, 0.0>, 0.6
        pigment {DMFLightOak }
        scale <0.8, 1, 0.8>
        rotate <70, .0, .0>
        translate <-9.91582, 9.55582, 21.6954>
    }
    cone { <0.0, 0.0, 0.0>, 0.6, <0.0, 3.13633, 0.0>, 0.6
        pigment {DMFLightOak }
        scale <0.85, 1, 0.85>
        rotate <55, .0, .0>
        translate <-9.91582, 7.56418, 18.7605>
    }
    cone { <0.0, 0.0, 0.0>, 0.6, <0.0, 3.13633, 0.0>, 0.6
        pigment {DMFLightOak }
        scale <0.9, 1, 0.9>
        rotate <40, .0, .0>
        translate <-9.91582, 5.01493, 16.4895>
    }
    cone { <0.0, 0.0, 0.0>, 0.6, <0.0, 3.13633, 0.0>, 0.6
        pigment {DMFLightOak }
        scale <0.95, 1, 0.95>
        rotate <40, .0, .0>
        translate <-9.91582, 2.3403, 14.2829>
    }
    cone { <0.0, 0.0, 0.0>, 0.6, <0.0, 3.13633, 0.0>, 0.6
        pigment {DMFLightOak }
        rotate <55, .0, .0>
        translate <-9.91582, 0.4, 11.4471>
    }
}

#declare right_leg = union {  // Layer name: right_leg
    sphere { <0.0, 0.0, 0.0>, 0.1433535
        texture { Copper_Metal }
        rotate <.0, 180, .0>
        translate <-13.0646, -5.36955, 2.40405>
    }
    sphere { <0.0, 0.0, 0.0>, 0.4061567
        texture { Copper_Metal }
        rotate <.0, 180, .0>
        translate <-12.2795, -4.00334, 9.77291>
    }
    sphere { <0.0, 0.0, 0.0>, 0.1567164
        texture { Copper_Metal }
        rotate <.0, 180, .0>
        translate <-11.5027, -5.36955, 2.45671>
    }
    cone { <0.0, 0.0, 0.0>, 0.1, <0.0, 1, 0.0>, 0
        texture { Copper_Metal }
        scale <1, 1.2, 1>
        rotate <270, .0, .0>
        rotate <.0, 360, .0>
        translate <-11.4802, -6.17552, 1.78278>
    }
    sphere { <0.0, 0.0, 0.0>, 0.1405418
        texture { Copper_Metal }
        rotate <.0, 180, .0>
        translate <-11.4893, -6.17552, 1.77938>
    }
    sphere { <0.0, 0.0, 0.0>, 0.1405418
        texture { Copper_Metal }
        rotate <.0, 180, .0>
        translate <-13.0564, -6.17552, 1.77938>
    }
    cone { <0.0, 0.0, 0.0>, 0.1, <0.0, 1, 0.0>, 0
        texture { Copper_Metal }
        scale <1, 1.2, 1>
        rotate <270, .0, .0>
        rotate <.0, 360, .0>
        translate <-13.0474, -6.17552, 1.78278>
    }
    cone { <0.0, 0.0, 0.0>, 0.08, <0.0, 1, 0.0>, 0.08
        texture { Red_Marble }
        rotate <140, .0, .0>
        rotate <.0, 180, .0>
        translate <-13.0631, -5.35164, 2.46785>
    }
    cone { <0.0, 0.0, 0.0>, 0.08, <0.0, 1, 0.0>, 0.08
        texture { Red_Marble }
        rotate <140, .0, .0>
        rotate <.0, 180, .0>
        translate <-11.4735, -5.35164, 2.46785>
    }
    sphere { <0.0, 0.0, 0.0>, 0.3589079
        texture { Copper_Metal }
        rotate <.0, 180, .0>
        translate <-12.281, -6.13075, 4.06865>
    }
    cone { <0.0, 0.0, 0.0>, 0.1, <0.0, 1, 0.0>, 0
        texture { Red_Marble }
        scale <1, 0.7, 1>
        rotate <270, .0, .0>
        rotate <.0, 205, .0>
        translate <-13.4056, -6.26507, 5.81263>
    }
    sphere { <0.0, 0.0, 0.0>, 0.1405418
        texture { Copper_Metal }
        rotate <.0, 180, .0>
        translate <-13.4146, -6.26507, 5.80923>
    }
    cone { <0.0, 0.0, 0.0>, 0.1, <0.0, 1, 0.0>, 0
        texture { Red_Marble }
        scale <1, 0.7, 1>
        rotate <270, .0, .0>
        rotate <.0, 205, .0>
        translate <-12.2862, -6.26507, 6.17084>
    }
    sphere { <0.0, 0.0, 0.0>, 0.1405418
        texture { Copper_Metal }
        rotate <.0, 180, .0>
        translate <-12.2952, -6.26507, 6.16744>
    }
    sphere { <0.0, 0.0, 0.0>, 0.1405418
        texture { Copper_Metal }
        rotate <.0, 180, .0>
        translate <-11.1311, -6.26507, 5.80923>
    }
    cone { <0.0, 0.0, 0.0>, 0.1, <0.0, 1, 0.0>, 0
        texture { Red_Marble }
        scale <1, 0.7, 1>
        rotate <270, .0, .0>
        rotate <.0, 205, .0>
        translate <-11.122, -6.26507, 5.81263>
    }
    cone { <0.0, 0.0, 0.0>, 0.1, <0.0, 2, 0.0>, 0.1
        texture { Red_Marble }
        rotate <90, .0, .0>
        rotate <.0, 180, .0>
        translate <-12.2867, -6.29502, 6.14446>
    }
    cone { <0.0, 0.0, 0.0>, 0.1, <0.0, 2, 0.0>, 0.1
        texture { Red_Marble }
        rotate <70, .0, .0>
        rotate <.0, 155, .0>
        translate <-12.2795, -6.06806, 4.14695>
    }
    cone { <0.0, 0.0, 0.0>, 0.1, <0.0, 2, 0.0>, 0.1
        texture { Red_Marble }
        rotate <90, .0, .0>
        rotate <.0, 145, .0>
        translate <-13.4215, -6.29502, 5.76099>
    }
    cone { <0.0, 0.0, 0.0>, 0.1, <0.0, 2, 0.0>, 0.1
        texture { Red_Marble }
        rotate <90, .0, .0>
        rotate <.0, 215, .0>
        translate <-11.1304, -6.29502, 5.78968>
    }
    cone { <0.0, 0.0, 0.0>, 0.1, <0.0, 2, 0.0>, 0.1
        texture { Red_Marble }
        rotate <70, .0, .0>
        rotate <.0, 205, .0>
        translate <-12.2795, -6.06806, 4.14695>
    }
    cone { <0.0, 0.0, 0.0>, 0.2, <0.0, 6, 0.0>, 0.25
        texture { Red_Marble }
        rotate <110, .0, .0>
        rotate <.0, 180, .0>
        translate <-12.2795, -4.09791, 9.69016>
    }
    cone { <0.0, 0.0, 0.0>, 0.45, <0.0, 9, 0.0>, 0.3
        texture { Red_Marble }
        rotate <250, .0, .0>
        rotate <.0, 180, .0>
        translate <-12.2795, -0.9456716, 1.31703>
    }
}

#declare left_leg = union {  // Layer name: left_leg
    sphere { <0.0, 0.0, 0.0>, 0.1567164
        texture { Copper_Metal }
        rotate <.0, 180, .0>
        translate <-7.2846, -5.36955, 2.45671>
    }
    sphere { <0.0, 0.0, 0.0>, 0.1433535
        texture { Copper_Metal }
        rotate <.0, 180, .0>
        translate <-8.84648, -5.36955, 2.40405>
    }
    cone { <0.0, 0.0, 0.0>, 0.1, <0.0, 1, 0.0>, 0
        texture { Red_Marble }
        scale <1, 1.2, 1>
        rotate <270, .0, .0>
        rotate <.0, 360, .0>
        translate <-7.26206, -6.17552, 1.78278>
    }
    sphere { <0.0, 0.0, 0.0>, 0.1405418
        texture { Red_Marble }
        rotate <.0, 180, .0>
        translate <-7.27113, -6.17552, 1.77938>
    }
    sphere { <0.0, 0.0, 0.0>, 0.1405418
        texture { Red_Marble }
        rotate <.0, 180, .0>
        translate <-8.83829, -6.17552, 1.77938>
    }
    cone { <0.0, 0.0, 0.0>, 0.1, <0.0, 1, 0.0>, 0
        texture { Red_Marble }
        scale <1, 1.2, 1>
        rotate <270, .0, .0>
        rotate <.0, 360, .0>
        translate <-8.82922, -6.17552, 1.78278>
    }
    cone { <0.0, 0.0, 0.0>, 0.08, <0.0, 1, 0.0>, 0.08
        texture { Red_Marble }
        rotate <140, .0, .0>
        rotate <.0, 180, .0>
        translate <-8.84494, -5.35164, 2.46785>
    }
    cone { <0.0, 0.0, 0.0>, 0.08, <0.0, 1, 0.0>, 0.08
        texture { Red_Marble }
        rotate <140, .0, .0>
        rotate <.0, 180, .0>
        translate <-7.25538, -5.35164, 2.46785>
    }
    sphere { <0.0, 0.0, 0.0>, 0.3589079
        texture { Copper_Metal }
        rotate <.0, 180, .0>
        translate <-8.06289, -6.13075, 4.06865>
    }
    cone { <0.0, 0.0, 0.0>, 0.1, <0.0, 1, 0.0>, 0
        texture { Red_Marble }
        scale <1, 0.7, 1>
        rotate <270, .0, .0>
        rotate <.0, 205, .0>
        translate <-9.18743, -6.26507, 5.81263>
    }
    sphere { <0.0, 0.0, 0.0>, 0.1405418
        texture { Red_Marble }
        rotate <.0, 180, .0>
        translate <-9.1965, -6.26507, 5.80923>
    }
    cone { <0.0, 0.0, 0.0>, 0.1, <0.0, 1, 0.0>, 0
        texture { Red_Marble }
        scale <1, 0.7, 1>
        rotate <270, .0, .0>
        rotate <.0, 205, .0>
        translate <-8.06803, -6.26507, 6.17084>
    }
    sphere { <0.0, 0.0, 0.0>, 0.1405418
        texture { Copper_Metal }
        rotate <.0, 180, .0>
        translate <-8.0771, -6.26507, 6.16744>
    }
    sphere { <0.0, 0.0, 0.0>, 0.1405418
        texture { Red_Marble }
        rotate <.0, 180, .0>
        translate <-6.91292, -6.26507, 5.80923>
    }
    cone { <0.0, 0.0, 0.0>, 0.1, <0.0, 1, 0.0>, 0
        texture { Red_Marble }
        scale <1, 0.7, 1>
        rotate <270, .0, .0>
        rotate <.0, 205, .0>
        translate <-6.90385, -6.26507, 5.81263>
    }
    cone { <0.0, 0.0, 0.0>, 0.1, <0.0, 2, 0.0>, 0.1
        texture { Red_Marble }
        rotate <90, .0, .0>
        rotate <.0, 180, .0>
        translate <-8.06853, -6.29502, 6.14446>
    }
    cone { <0.0, 0.0, 0.0>, 0.1, <0.0, 2, 0.0>, 0.1
        texture { Red_Marble }
        rotate <70, .0, .0>
        rotate <.0, 155, .0>
        translate <-8.06135, -6.06806, 4.14695>
    }
    cone { <0.0, 0.0, 0.0>, 0.1, <0.0, 2, 0.0>, 0.1
        texture { Red_Marble }
        rotate <90, .0, .0>
        rotate <.0, 145, .0>
        translate <-9.20333, -6.29502, 5.76099>
    }
    cone { <0.0, 0.0, 0.0>, 0.1, <0.0, 2, 0.0>, 0.1
        texture { Red_Marble }
        rotate <90, .0, .0>
        rotate <.0, 215, .0>
        translate <-6.9122, -6.29502, 5.78968>
    }
    cone { <0.0, 0.0, 0.0>, 0.1, <0.0, 2, 0.0>, 0.1
        texture { Red_Marble }
        rotate <70, .0, .0>
        rotate <.0, 205, .0>
        translate <-8.06135, -6.06806, 4.14695>
    }
    cone { <0.0, 0.0, 0.0>, 0.2, <0.0, 6, 0.0>, 0.25
        texture { Red_Marble }
        rotate <110, .0, .0>
        rotate <.0, 180, .0>
        translate <-8.06135, -4.09791, 9.69016>
    }
    sphere { <0.0, 0.0, 0.0>, 0.4061567
        texture { Copper_Metal }
        rotate <.0, 180, .0>
        translate <-8.06135, -4.00334, 9.77291>
    }
    cone { <0.0, 0.0, 0.0>, 0.45, <0.0, 9, 0.0>, 0.3
        texture { Red_Marble }
        rotate <250, .0, .0>
        rotate <.0, 180, .0>
        translate <-8.06135, -0.9456716, 1.31703>
    }
}

#declare eyes = union {  // Layer name: eyes
    light_source {  <-10.8424, 4.00358, -8.57444>
        color rgb<1, 1, 1>
    }
    light_source {  <-9.05915, 4.00358, -8.57444>
        color rgb<1, 1, 1>
    }
    sphere { <0.0, 0.0, 0.0>, 0.667483
        texture { Inferno_1 }
        scale <1, 0.8, 1>
        translate <-9.05879, 4.00358, -8.53085>
    }
    sphere { <0.0, 0.0, 0.0>, 0.667483
        texture { Inferno_1 }
        scale <1, 0.8, 1>
        translate <-10.807, 4.00358, -8.53085>
    }
}

#declare head_upper = union {  // Layer name: head_upper
    sphere { <0.0, 0.0, 0.0>, 4.00003
        texture { Dragon_Skin }
        scale <0.05, 0.2, 1>
        rotate <352, .0, .0>
        translate <-9.90452, 4.74985, -2.41145>
    }
    sphere { <0.0, 0.0, 0.0>, 6.47653
        texture { Dragon_Skin }
        scale <0.2, 0.1, 1>
        rotate <350, .0, .0>
        translate <-9.92945, 3.57698, -7.45322>
    }
    cone { <0.0, 0.0, 0.0>, 0.6, <0.0, 5, 0.0>, 0.6
        texture { Dragon_Skin }
        scale <0.5, 1, 1>
        rotate <45, .0, .0>
        translate <-9.89517, 0.5863399, -7.17532>
    }
}

#declare head2 = difference {  // Layer name: head_upper_c
        object {head_upper}
        box { <0.0, 0.0, 0.0>, <3, 2, 11>
            texture { Dragon_Skin }
            rotate <350, .0, .0>
            translate <-11.4836, 0.4048741, -14.1813>
        }
}
#declare body = union {  // Layer name: body
    sphere { <0.0, 0.0, 0.0>, 11
      texture {Dragon_Skin}
        scale <0.4, 0.15, 1>
        translate <-9.92223, 0.2485632, 1.85626>
    }
}

#declare Glider1 = union {
object {lwing_skin
  texture { Leopard
    scale 5
  }
}

object {rwing_skin
  texture { Leopard
    scale 5
  }
}

object { right_wing
  texture {Copper_Metal}
}

object {left_wing
  texture { Copper_Metal}
}

object {head}

object {tail}

object {right_leg}

object {left_leg}

object {eyes}

object {head2}

object {body}
}

