// detail.cpp
//
// This program generates random detail objects for the Tibanna Gas Mine.
//
// Parameters:
//  * filename
//  * objectName
//  * minimum radius
//  * maximum radius
//  * number of objects
//
// Written by: Henry Wagner (henryw@panix.com)
// Started: 12/28/96

#include <stdio.h>
#include <stdlib.h>

void main (int argc, char *argv[])
{
   FILE *o;
   int c1, c2, minr, maxr, nObjects, distance;

   if (argc < 6) {
      printf("\nERROR: You didn't pass in enough parameters\n" );
      printf("detail filename.inc objectName minradius maxradius nObjects\n");
      exit(0);
   }
   else {
      o = fopen(argv[1], "w");

      minr = atoi(argv[3]);
      maxr = atoi(argv[4]);
      distance = maxr - minr;
      nObjects = atoi(argv[5]);

      randomize(); // Seed the random number generator

      fprintf(o, "// %s\n", argv[1]);
      fprintf(o, "//\n" );
      fprintf(o, "// Generated by: Henry Wagner (henryW@panix.com)\n\n");

      fprintf(o, "#declare %s = union {\n", argv[2]);

      for( c1 = 0; c1 < nObjects; c1++) {
	 c2 = random(4);

	 if (c2 == 0) {
	    // Create a simple box
	    fprintf(o, "   box {\n" );
	    fprintf(o, "      < -%d,  0, -%d >,\n", (random(5) + 1), (random(5) + 1)); // Add 1 to eliminate zero values
	    fprintf(o, "      <  %d, %d,  %d >\n", (random(5) + 1), (random(15) + 3), (random(5) + 1));
	 }
	 else if (c2 == 1) {
	    int cHeight = random(15) + 3;
	    // Create a simple cylinder
	    fprintf(o, "   union {\n" );
	    fprintf(o, "      cylinder {\n" );
	    fprintf(o, "         < 0, 0, 0 >,\n" );
	    fprintf(o, "         < 0, %d, 0 >,\n", cHeight ); // Make it atleast 3 units tall
	    fprintf(o, "         %d\n", (random(3) + 1));
	    fprintf(o, "      }\n" );
	    fprintf(o, "      sphere { 0, 1\n" );
	    fprintf(o, "	 pigment { color rgbt <1, 1, 1, 1> }\n" );
	    fprintf(o, "	 halo {\n" );
	    fprintf(o, "	    emitting\n" );
	    fprintf(o, "	    spherical_mapping\n" );
	    fprintf(o, "	    linear\n" );
	    fprintf(o, "	    color_map {\n" );
	    fprintf(o, "	       [ 0 color rgbt <1, 1, 0.5,  1.0> ]\n" );
	    fprintf(o, "	       [ 1 color rgbt <1, 1, 1, -1.0> ]\n" );
	    fprintf(o, "            }\n" );
	    fprintf(o, "	    samples 10\n" );
	    fprintf(o, "         }\n" );
	    fprintf(o, "       	 hollow\n" );
	    fprintf(o, "	 scale 5\n" );
	    fprintf(o, "         translate < 0, %d, 0 >\n", cHeight + 1 );
	    fprintf(o, "      }\n" );
	 }
	 else if (c2 == 2) {
	    // Create a simple sphere
	    fprintf(o, "   sphere {\n" );
	    fprintf(o, "      < 0, 0, 0 >, %d\n", (random(13) + 1));
	 }
	 else if (c2 == 3) {
	    // Create a simple cone
	    fprintf(o, "   cone {\n" );
	    fprintf(o, "      < 0, 0, 0 >, %d\n", (random(3) + 1));
	    fprintf(o, "      < 0, %d, 0 >, %d\n", (random(15) + 3), (random(3) + 1));
	 }
	 fprintf(o, "      translate < %d, 0, 0 >\n", random(distance) + minr);
	 fprintf(o, "      rotate < 0, %d, 0 >\n", random(360));
	 fprintf(o, "   }\n" );
      }

      fprintf(o, "}\n" );
      fclose(o);
   }
}