// lgtower.inc
//
// This file contains the POV objects that make up the light towers.
//
// Written by: Henry Wagner (henryw@panix.com)
// Started: 12/15/1996

#declare Light_Pole = union {
   cylinder {
      < 0, -90, 0 >,
      < 25, -90, 0 >,
      2.0
      texture { Main_Metal }
   }
   sphere { 0, 1
      pigment { color rgbt <1, 1, 1, 1> }
      halo {
         emitting
         spherical_mapping
         linear
         color_map {
            [ 0 color rgbt <1, 1, 0.5,  1.0> ]
            [ 1 color rgbt <1, 1, 1, -1.0> ]
         }
         samples 10
      }
      hollow
      scale 5
      translate < 25, -90, 0 >
   }
}
   
#declare Light_Tower = union {
   cylinder {
      < 0, 0, 0 >,
      < 0, -30, 0 >,
      20.0
   }
   cylinder {
      < 0, -30, 0 >,
      < 0, -35, 0 >,
      16.0
   }
   cylinder {
      < 0, -35, 0 >,
      < 0, -45, 0 >,
      20.0
   }
   cone {
      < 0, -45, 0 >, 20.0
      < 0, -55, 0 >, 15.0
   }
   cylinder {
      < 0, -55, 0 >,
      < 0, -65, 0 >,
      10.0
   }
   cylinder {
      < 0, -65, 0 >,
      < 0, -73, 0 >,
      20.0
   }
   cone {
      < 0, -73, 0 >, 20.0
      < 0, -80, 0 >, 5.0
   }
   cylinder {
      < 0, -80, 0 >,
      < 0, -100, 0 >,
      5.0
   }
   object { Light_Pole }
   object {
      Light_Pole
      rotate < 0, 45, 0 >
   }
   object {
      Light_Pole
      rotate < 0, 90, 0 >
   }
   object {
      Light_Pole
      rotate < 0, 135, 0 >
   }
   object {
      Light_Pole
      rotate < 0, 180, 0 >
   }
   object {
      Light_Pole
      rotate < 0, 225, 0 >
   }
   object {
      Light_Pole
      rotate < 0, 270, 0 >
   }
   object {
      Light_Pole
      rotate < 0, 315, 0 >
   }
   cone {
      < 0, -100, 0 >, 5.0
      < 0, -130, 0 >, 0.0
   }
   texture { Main_Metal }
}