//  Persistance of Vision Raytracer V3.0
//  World definition file.
//
//  Contains 11 lights, 5 textures and 2046 primitives.
//
//  This file was generated for POV-Ray V3.0 by
//  MORAY.EXE V2.5.wat(c) 1991-1995 Lutz + Kretzschmar
//

//  Date : 12/19/1996    (19.12.1996)
//

//
//  This is the standard include file for POV-Ray. It is included with
//  every scene that Moray V2.0 exports for POV-Ray.
//





global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.8
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
}

background { color <0.000,0.000,0.000> }

atmosphere {
  type 1    // Isotropic
  distance     200.0
  color <0.0,0.0,0.0,0.0,0.0>
  scattering   0.05
  samples      150
  jitter       4.0
  aa_threshold 0.1
  aa_level     0.2
}

fog {
  fog_type 2    // Ground Fog
  distance     10.0
  color <0.606,0.0,0.0,0.0,0.37>
  up           <0,0,1>
  fog_offset   0.0
  fog_alt      20.0
}

camera {  //  Camera StdCam
  location  <-2.983, -4.434, 305.574>
  direction <0.0,     0.0,  4.1440>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  look_at   <3.947, 4.443, 212.077>
}

// *******  L I G H T S *******
light_source {   // OuterLight2
  <-24.925, 17.358, 121.459>
  color rgb <1.008, 0.800, 0.506>
  fade_distance  50.0
  fade_power 1.0
  atmospheric_attenuation on
}

light_source {   // OuterLight1
  <21.645, -16.239, 166.490>
  color rgb <1.000, 0.796, 0.510>
  fade_distance  50.0
  fade_power 1.0
  atmospheric_attenuation on
}

light_source {   // OuterLight
  <0.000, 30.000, 223.000>
  color rgb <1.000, 0.796, 0.510>
  fade_distance  50.0
  fade_power 1.0
  atmospheric_attenuation on
}

light_source {   // InnerLight
  <-7.738, 0.000, 4.993>
  color rgb <0.510, 0.510, 0.510>
  atmosphere off
}

light_source {   // InnerLight1
  <-5.540, 0.000, 46.936>
  color rgb <0.510, 0.510, 0.510>
  atmosphere off
}

light_source {   // InnerLight2
  <-3.342, 0.000, 88.878>
  color rgb <0.510, 0.510, 0.510>
  atmosphere off
}

light_source {   // InnerLight3
  <-1.144, 0.000, 130.820>
  color rgb <0.510, 0.510, 0.510>
  atmosphere off
  atmospheric_attenuation on
}

light_source {   // InnerLight4
  <1.054, 0.000, 172.763>
  color rgb <0.510, 0.510, 0.510>
  atmosphere off
}

light_source {   // InnerLight5
  <3.252, 0.000, 214.705>
  color rgb <0.510, 0.510, 0.510>
  atmosphere off
}

light_source {   // InnerLight6
  <5.450, 0.000, 256.648>
  color rgb <0.510, 0.510, 0.510>
  atmosphere off
}

light_source {   // InnerLight7
  <7.648, 0.000, 298.590>
  color rgb <1.000, 0.906, 0.804>
  atmosphere off
}


// ********  TEXTURES  *******
//

#include "stairs06.inc"



// ********  REFERENCED OBJECTS  *******

#declare MusterCSG1 = union {
  box { // Muster1
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.3, 0.25>
    translate  <0.0, -2.0, -3.0>
  }
  box { // Muster2
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.3, 0.25>
    translate  <0.0, -2.0, -3.9>
  }
  box { // Muster3
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.3, 0.25>
    translate  <0.0, -2.0, -4.8>
  }
  box { // Muster4
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.3, 0.75>
    translate  <0.0, -2.0, -6.3>
  }
  translate  -0.5*z
}
#declare MusterCSG2 = union {
  box { // Muster5
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.3, 0.25>
    translate  <0.0, -2.0, -3.0>
  }
  box { // Muster6
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.3, 0.25>
    translate  <0.0, -2.0, -3.9>
  }
  box { // Muster7
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.3, 0.25>
    translate  <0.0, -2.0, -4.8>
  }
  box { // Muster8
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.3, 0.75>
    translate  <0.0, -2.0, -6.3>
  }
  scale <1.5, 1.0, 1.0>
  rotate -90.0*z
  translate  <0.6, 0.0, -0.5>
}
#declare MusterCSG3 = union {
  box { // Muster9
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.3, 0.25>
    translate  <0.0, -2.0, -3.0>
  }
  box { // Muster10
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.3, 0.25>
    translate  <0.0, -2.0, -3.9>
  }
  box { // Muster11
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.3, 0.25>
    translate  <0.0, -2.0, -4.8>
  }
  box { // Muster12
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.3, 0.75>
    translate  <0.0, -2.0, -6.3>
  }
  rotate 180.0*z
  translate  -0.5*z
}
#declare MusterCSG4 = union {
  box { // Muster13
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.3, 0.25>
    translate  <0.0, -2.0, -3.0>
  }
  box { // Muster14
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.3, 0.25>
    translate  <0.0, -2.0, -3.9>
  }
  box { // Muster15
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.3, 0.25>
    translate  <0.0, -2.0, -4.8>
  }
  box { // Muster16
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.3, 0.75>
    translate  <0.0, -2.0, -6.3>
  }
  scale <1.5, 1.0, 1.0>
  rotate 90.0*z
  translate  <-0.6, 0.0, -0.5>
}
#declare MusterKugelCS3 = union {
  sphere { // KugelMuster31
    <0,0,0>,1
    scale 0.2
    translate  <-1.0, -2.1, -8.5>
  }
  sphere { // KugelMuster32
    <0,0,0>,1
    scale 0.2
    translate  <1.0, -2.1, -8.5>
  }
  sphere { // KugelMuster33
    <0,0,0>,1
    scale 0.2
    translate  <-1.0, -2.1, -10.5>
  }
  sphere { // KugelMuster34
    <0,0,0>,1
    scale 0.2
    translate  <-1.0, -2.1, -12.5>
  }
  sphere { // KugelMuster35
    <0,0,0>,1
    scale 0.2
    translate  <-1.0, -2.1, -14.5>
  }
  sphere { // KugelMuster36
    <0,0,0>,1
    scale 0.2
    translate  <-1.0, -2.1, -16.5>
  }
  sphere { // KugelMuster37
    <0,0,0>,1
    scale 0.2
    translate  <1.0, -2.1, -10.5>
  }
  sphere { // KugelMuster38
    <0,0,0>,1
    scale 0.2
    translate  <1.0, -2.1, -12.5>
  }
  sphere { // KugelMuster39
    <0,0,0>,1
    scale 0.2
    translate  <1.0, -2.1, -14.5>
  }
  sphere { // KugelMuster40
    <0,0,0>,1
    scale 0.2
    translate  <1.0, -2.1, -16.5>
  }
  rotate 90.0*z
  translate  -0.7*x
}
#declare MusterKugelCS2 = union {
  sphere { // KugelMuster21
    <0,0,0>,1
    scale 0.2
    translate  <-1.0, -2.1, -8.5>
  }
  sphere { // KugelMuster22
    <0,0,0>,1
    scale 0.2
    translate  <1.0, -2.1, -8.5>
  }
  sphere { // KugelMuster23
    <0,0,0>,1
    scale 0.2
    translate  <-1.0, -2.1, -10.5>
  }
  sphere { // KugelMuster24
    <0,0,0>,1
    scale 0.2
    translate  <-1.0, -2.1, -12.5>
  }
  sphere { // KugelMuster25
    <0,0,0>,1
    scale 0.2
    translate  <-1.0, -2.1, -14.5>
  }
  sphere { // KugelMuster26
    <0,0,0>,1
    scale 0.2
    translate  <-1.0, -2.1, -16.5>
  }
  sphere { // KugelMuster27
    <0,0,0>,1
    scale 0.2
    translate  <1.0, -2.1, -10.5>
  }
  sphere { // KugelMuster28
    <0,0,0>,1
    scale 0.2
    translate  <1.0, -2.1, -12.5>
  }
  sphere { // KugelMuster29
    <0,0,0>,1
    scale 0.2
    translate  <1.0, -2.1, -14.5>
  }
  sphere { // KugelMuster30
    <0,0,0>,1
    scale 0.2
    translate  <1.0, -2.1, -16.5>
  }
  rotate 180.0*z
}
#declare MusterKugelCS1 = union {
  sphere { // KugelMuster11
    <0,0,0>,1
    scale 0.2
    translate  <-1.0, -2.1, -8.5>
  }
  sphere { // KugelMuster12
    <0,0,0>,1
    scale 0.2
    translate  <1.0, -2.1, -8.5>
  }
  sphere { // KugelMuster13
    <0,0,0>,1
    scale 0.2
    translate  <-1.0, -2.1, -10.5>
  }
  sphere { // KugelMuster14
    <0,0,0>,1
    scale 0.2
    translate  <-1.0, -2.1, -12.5>
  }
  sphere { // KugelMuster15
    <0,0,0>,1
    scale 0.2
    translate  <-1.0, -2.1, -14.5>
  }
  sphere { // KugelMuster16
    <0,0,0>,1
    scale 0.2
    translate  <-1.0, -2.1, -16.5>
  }
  sphere { // KugelMuster17
    <0,0,0>,1
    scale 0.2
    translate  <1.0, -2.1, -10.5>
  }
  sphere { // KugelMuster18
    <0,0,0>,1
    scale 0.2
    translate  <1.0, -2.1, -12.5>
  }
  sphere { // KugelMuster19
    <0,0,0>,1
    scale 0.2
    translate  <1.0, -2.1, -14.5>
  }
  sphere { // KugelMuster20
    <0,0,0>,1
    scale 0.2
    translate  <1.0, -2.1, -16.5>
  }
  rotate -90.0*z
  translate  0.7*x
}
#declare MusterKugelCSG = union {
  sphere { // KugelMuster1
    <0,0,0>,1
    scale 0.2
    translate  <-1.0, -2.1, -8.5>
  }
  sphere { // KugelMuster2
    <0,0,0>,1
    scale 0.2
    translate  <1.0, -2.1, -8.5>
  }
  sphere { // KugelMuster3
    <0,0,0>,1
    scale 0.2
    translate  <-1.0, -2.1, -10.5>
  }
  sphere { // KugelMuster4
    <0,0,0>,1
    scale 0.2
    translate  <-1.0, -2.1, -12.5>
  }
  sphere { // KugelMuster5
    <0,0,0>,1
    scale 0.2
    translate  <-1.0, -2.1, -14.5>
  }
  sphere { // KugelMuster6
    <0,0,0>,1
    scale 0.2
    translate  <-1.0, -2.1, -16.5>
  }
  sphere { // KugelMuster7
    <0,0,0>,1
    scale 0.2
    translate  <1.0, -2.1, -10.5>
  }
  sphere { // KugelMuster8
    <0,0,0>,1
    scale 0.2
    translate  <1.0, -2.1, -12.5>
  }
  sphere { // KugelMuster9
    <0,0,0>,1
    scale 0.2
    translate  <1.0, -2.1, -14.5>
  }
  sphere { // KugelMuster10
    <0,0,0>,1
    scale 0.2
    translate  <1.0, -2.1, -16.5>
  }
}
#declare StuetzeCSG = union {
  box { // TraegerTop1
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.5, 1.0>
  }
  box { // TraegerTop2
    <-1, -1, -1>, <1, 1, 1>
    scale <1.2, 1.8, 1.2>
    translate  -1.0*z
  }
  box { // TraegerTop3
    <-1, -1, -1>, <1, 1, 1>
    scale <1.4, 2.1, 1280.0>
    translate  <0.0, 0.0, -1300.0>
  }
  object { MusterCSG1 }
  object { MusterCSG2 }
  object { MusterCSG3 }
  object { MusterCSG4 }
  object { MusterKugelCS3 }
  object { MusterKugelCS2 }
  object { MusterKugelCS1 }
  object { MusterKugelCSG }
  box { // TraegerTop4
    <-1, -1, -1>, <1, 1, 1>
    scale <1.4, 2.1, 20.0>
    translate  <0.0, 0.0, -22.0>
  }
  texture {
    WhitePaint_Tex
  }
  scale 0.1
  translate  <0.1, 4.8, 258.0>
}


#declare LaufSp = object {
  sphere { // LaufSp
    <0,0,0>,1
    texture {
      DMFLightOak1
    }
    scale <0.3, 0.1, 0.1>
    rotate <0.0, -51.485332, 0.0>
    translate  <0.101724, 5.000835, 3.999062>
  }
}


#declare Stufe = union {
  box { // step
    <-1, -1, -1>, <1, 1, 1>
    scale <0.7, 4.0, 0.3>
    translate  <0.1, 5.1, 0.3>
  }
  box { // step1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.8, 4.0, 0.08>
    translate  <0.006971, 5.1, 0.676743>
  }
  box { // step2
    <-1, -1, -1>, <1, 1, 1>
    texture {
      DMFDarkOak1
    }
    scale <0.6, 3.0, 0.06>
    translate  <0.124677, 5.1, 0.702472>
  }
  texture {
    White_Marble1
  }
  translate  3.920834*y
}
#declare GelaenderCsg = union {
  box { // Gitterstab
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.05, 2.0>
    translate  <0.1, 5.0, 2.0>
  }
  texture {
    DMFLightOak1
  }
}




// ********  OBJECTS  *******









plane { // Boden
  z,0
  texture {
    Floor_Tex
  }
}


union { // Streben
  object { StuetzeCSG }
  object { // StuetzeCSG1->StuetzeCSG
    StuetzeCSG
    rotate -36.0*z
    translate  4.2*z
  }
  object { // StuetzeCSG2->StuetzeCSG
    StuetzeCSG
    rotate -72.0*z
    translate  <0.0, 0.0, 8.4>
  }
  object { // StuetzeCSG3->StuetzeCSG
    StuetzeCSG
    rotate -108.0*z
    translate  <0.0, 0.0, 12.6>
  }
  object { // StuetzeCSG4->StuetzeCSG
    StuetzeCSG
    rotate -144.0*z
    translate  <0.0, 0.0, 16.8>
  }
  object { // StuetzeCSG5->StuetzeCSG
    StuetzeCSG
    rotate 180.0*z
    translate  <0.0, 0.0, 21.0>
  }
  object { // StuetzeCSG6->StuetzeCSG
    StuetzeCSG
    rotate 144.0*z
    translate  <0.0, 0.0, 25.2>
  }
  object { // StuetzeCSG7->StuetzeCSG
    StuetzeCSG
    rotate 108.0*z
    translate  <0.0, 0.0, 29.4>
  }
  object { // StuetzeCSG8->StuetzeCSG
    StuetzeCSG
    rotate 72.0*z
    translate  <0.0, 0.0, 33.6>
  }
  object { // StuetzeCSG9->StuetzeCSG
    StuetzeCSG
    rotate 36.0*z
    translate  <0.0, 0.0, 37.8>
  }
}


union { // LaufGrp
  object { LaufSp }
  object { // LaufSp1->LaufSp
    LaufSp
    rotate <0.0, 0.0, -2.0>
    translate  <0.0, 0.0, 0.233333>
  }
  object { // LaufSp2->LaufSp
    LaufSp
    rotate <0.0, 0.0, -4.0>
    translate  <0.0, 0.0, 0.466666>
  }
  object { // LaufSp3->LaufSp
    LaufSp
    rotate <0.0, 0.0, -6.0>
    translate  <0.0, 0.0, 0.699999>
  }
  object { // LaufSp4->LaufSp
    LaufSp
    rotate <0.0, 0.0, -8.0>
    translate  <0.0, 0.0, 0.933332>
  }
  object { // LaufSp5->LaufSp
    LaufSp
    rotate <0.0, 0.0, -10.0>
    translate  <0.0, 0.0, 1.166665>
  }
  object { // LaufSp6->LaufSp
    LaufSp
    rotate <0.0, 0.0, -12.0>
    translate  <0.0, 0.0, 1.399998>
  }
  object { // LaufSp7->LaufSp
    LaufSp
    rotate <0.0, 0.0, -14.0>
    translate  <0.0, 0.0, 1.633331>
  }
  object { // LaufSp8->LaufSp
    LaufSp
    rotate <0.0, 0.0, -16.0>
    translate  <0.0, 0.0, 1.866664>
  }
  object { // LaufSp9->LaufSp
    LaufSp
    rotate <0.0, 0.0, -18.0>
    translate  <0.0, 0.0, 2.099997>
  }
  object { // LaufSp10->LaufSp
    LaufSp
    rotate <0.0, 0.0, -20.0>
    translate  <0.0, 0.0, 2.33333>
  }
  object { // LaufSp11->LaufSp
    LaufSp
    rotate <0.0, 0.0, -22.0>
    translate  <0.0, 0.0, 2.566663>
  }
  object { // LaufSp12->LaufSp
    LaufSp
    rotate <0.0, 0.0, -24.0>
    translate  2.799996*z
  }
  object { // LaufSp13->LaufSp
    LaufSp
    rotate <0.0, 0.0, -26.0>
    translate  3.033329*z
  }
  object { // LaufSp14->LaufSp
    LaufSp
    rotate <0.0, 0.0, -28.0>
    translate  <0.0, 0.0, 3.266662>
  }
  object { // LaufSp15->LaufSp
    LaufSp
    rotate <0.0, 0.0, -30.0>
    translate  3.499995*z
  }
  object { // LaufSp16->LaufSp
    LaufSp
    rotate <0.0, 0.0, -32.0>
    translate  <0.0, 0.0, 3.733328>
  }
  object { // LaufSp17->LaufSp
    LaufSp
    rotate <0.0, 0.0, -34.0>
    translate  <0.0, 0.0, 3.966661>
  }
  object { // LaufSp18->LaufSp
    LaufSp
    rotate <0.0, 0.0, -36.0>
    translate  <0.0, 0.0, 4.199994>
  }
  object { // LaufSp19->LaufSp
    LaufSp
    rotate <0.0, 0.0, -38.0>
    translate  <0.0, 0.0, 4.433327>
  }
  object { // LaufSp20->LaufSp
    LaufSp
    rotate <0.0, 0.0, -40.0>
    translate  <0.0, 0.0, 4.66666>
  }
  object { // LaufSp21->LaufSp
    LaufSp
    rotate <0.0, 0.0, -42.0>
    translate  <0.0, 0.0, 4.899993>
  }
  object { // LaufSp22->LaufSp
    LaufSp
    rotate <0.0, 0.0, -44.0>
    translate  <0.0, 0.0, 5.133326>
  }
  object { // LaufSp23->LaufSp
    LaufSp
    rotate <0.0, 0.0, -46.0>
    translate  <0.0, 0.0, 5.366659>
  }
  object { // LaufSp24->LaufSp
    LaufSp
    rotate <0.0, 0.0, -48.0>
    translate  <0.0, 0.0, 5.599992>
  }
  object { // LaufSp25->LaufSp
    LaufSp
    rotate <0.0, 0.0, -50.0>
    translate  <0.0, 0.0, 5.833325>
  }
  object { // LaufSp26->LaufSp
    LaufSp
    rotate <0.0, 0.0, -52.0>
    translate  <0.0, 0.0, 6.066658>
  }
  object { // LaufSp27->LaufSp
    LaufSp
    rotate <0.0, 0.0, -54.0>
    translate  <0.0, 0.0, 6.299991>
  }
  object { // LaufSp28->LaufSp
    LaufSp
    rotate <0.0, 0.0, -56.0>
    translate  <0.0, 0.0, 6.533324>
  }
  object { // LaufSp29->LaufSp
    LaufSp
    rotate <0.0, 0.0, -58.0>
    translate  <0.0, 0.0, 6.766657>
  }
  object { // LaufSp30->LaufSp
    LaufSp
    rotate <0.0, 0.0, -60.0>
    translate  <0.0, 0.0, 6.99999>
  }
  object { // LaufSp31->LaufSp
    LaufSp
    rotate <0.0, 0.0, -62.0>
    translate  <0.0, 0.0, 7.233323>
  }
  object { // LaufSp32->LaufSp
    LaufSp
    rotate <0.0, 0.0, -64.0>
    translate  <0.0, 0.0, 7.466656>
  }
  object { // LaufSp33->LaufSp
    LaufSp
    rotate <0.0, 0.0, -66.0>
    translate  <0.0, 0.0, 7.699989>
  }
  object { // LaufSp34->LaufSp
    LaufSp
    rotate <0.0, 0.0, -68.0>
    translate  <0.0, 0.0, 7.933322>
  }
  object { // LaufSp35->LaufSp
    LaufSp
    rotate <0.0, 0.0, -70.0>
    translate  <0.0, 0.0, 8.166655>
  }
  object { // LaufSp36->LaufSp
    LaufSp
    rotate <0.0, 0.0, -72.0>
    translate  <0.0, 0.0, 8.399988>
  }
  object { // LaufSp37->LaufSp
    LaufSp
    rotate <0.0, 0.0, -74.0>
    translate  <0.0, 0.0, 8.633321>
  }
  object { // LaufSp38->LaufSp
    LaufSp
    rotate <0.0, 0.0, -76.0>
    translate  <0.0, 0.0, 8.866654>
  }
  object { // LaufSp39->LaufSp
    LaufSp
    rotate <0.0, 0.0, -78.0>
    translate  <0.0, 0.0, 9.099987>
  }
  object { // LaufSp40->LaufSp
    LaufSp
    rotate <0.0, 0.0, -80.0>
    translate  <0.0, 0.0, 9.33332>
  }
  object { // LaufSp41->LaufSp
    LaufSp
    rotate <0.0, 0.0, -82.0>
    translate  <0.0, 0.0, 9.566653>
  }
  object { // LaufSp42->LaufSp
    LaufSp
    rotate <0.0, 0.0, -84.0>
    translate  <0.0, 0.0, 9.799986>
  }
  object { // LaufSp43->LaufSp
    LaufSp
    rotate <0.0, 0.0, -86.0>
    translate  <0.0, 0.0, 10.033319>
  }
  object { // LaufSp44->LaufSp
    LaufSp
    rotate <0.0, 0.0, -88.0>
    translate  <0.0, 0.0, 10.266652>
  }
  object { // LaufSp45->LaufSp
    LaufSp
    rotate <0.0, 0.0, -90.0>
    translate  <0.0, 0.0, 10.499985>
  }
  object { // LaufSp46->LaufSp
    LaufSp
    rotate <0.0, 0.0, -92.0>
    translate  <0.0, 0.0, 10.733318>
  }
  object { // LaufSp47->LaufSp
    LaufSp
    rotate <0.0, 0.0, -94.0>
    translate  <0.0, 0.0, 10.966651>
  }
  object { // LaufSp48->LaufSp
    LaufSp
    rotate <0.0, 0.0, -96.0>
    translate  <0.0, 0.0, 11.199984>
  }
  object { // LaufSp49->LaufSp
    LaufSp
    rotate <0.0, 0.0, -98.0>
    translate  <0.0, 0.0, 11.433317>
  }
  object { // LaufSp50->LaufSp
    LaufSp
    rotate <0.0, 0.0, -100.0>
    translate  <0.0, 0.0, 11.66665>
  }
  object { // LaufSp51->LaufSp
    LaufSp
    rotate <0.0, 0.0, -102.0>
    translate  <0.0, 0.0, 11.899983>
  }
  object { // LaufSp52->LaufSp
    LaufSp
    rotate <0.0, 0.0, -104.0>
    translate  <0.0, 0.0, 12.133316>
  }
  object { // LaufSp53->LaufSp
    LaufSp
    rotate <0.0, 0.0, -106.0>
    translate  <0.0, 0.0, 12.366649>
  }
  object { // LaufSp54->LaufSp
    LaufSp
    rotate <0.0, 0.0, -108.0>
    translate  <0.0, 0.0, 12.599982>
  }
  object { // LaufSp55->LaufSp
    LaufSp
    rotate <0.0, 0.0, -110.0>
    translate  <0.0, 0.0, 12.833315>
  }
  object { // LaufSp56->LaufSp
    LaufSp
    rotate <0.0, 0.0, -112.0>
    translate  <0.0, 0.0, 13.066648>
  }
  object { // LaufSp57->LaufSp
    LaufSp
    rotate <0.0, 0.0, -114.0>
    translate  <0.0, 0.0, 13.299981>
  }
  object { // LaufSp58->LaufSp
    LaufSp
    rotate <0.0, 0.0, -116.0>
    translate  <0.0, 0.0, 13.533314>
  }
  object { // LaufSp59->LaufSp
    LaufSp
    rotate <0.0, 0.0, -118.0>
    translate  13.766647*z
  }
  object { // LaufSp60->LaufSp
    LaufSp
    rotate <0.0, 0.0, -120.0>
    translate  <0.0, 0.0, 13.99998>
  }
  object { // LaufSp61->LaufSp
    LaufSp
    rotate <0.0, 0.0, -122.0>
    translate  <0.0, 0.0, 14.233313>
  }
  object { // LaufSp62->LaufSp
    LaufSp
    rotate <0.0, 0.0, -124.0>
    translate  <0.0, 0.0, 14.466646>
  }
  object { // LaufSp63->LaufSp
    LaufSp
    rotate <0.0, 0.0, -126.0>
    translate  <0.0, 0.0, 14.699979>
  }
  object { // LaufSp64->LaufSp
    LaufSp
    rotate <0.0, 0.0, -128.0>
    translate  <0.0, 0.0, 14.933312>
  }
  object { // LaufSp65->LaufSp
    LaufSp
    rotate <0.0, 0.0, -130.0>
    translate  <0.0, 0.0, 15.166645>
  }
  object { // LaufSp66->LaufSp
    LaufSp
    rotate <0.0, 0.0, -132.0>
    translate  <0.0, 0.0, 15.399978>
  }
  object { // LaufSp67->LaufSp
    LaufSp
    rotate <0.0, 0.0, -134.0>
    translate  <0.0, 0.0, 15.633311>
  }
  object { // LaufSp68->LaufSp
    LaufSp
    rotate <0.0, 0.0, -136.0>
    translate  <0.0, 0.0, 15.866644>
  }
  object { // LaufSp69->LaufSp
    LaufSp
    rotate <0.0, 0.0, -138.0>
    translate  <0.0, 0.0, 16.099977>
  }
  object { // LaufSp70->LaufSp
    LaufSp
    rotate <0.0, 0.0, -140.0>
    translate  <0.0, 0.0, 16.33331>
  }
  object { // LaufSp71->LaufSp
    LaufSp
    rotate <0.0, 0.0, -142.0>
    translate  <0.0, 0.0, 16.566643>
  }
  object { // LaufSp72->LaufSp
    LaufSp
    rotate <0.0, 0.0, -144.0>
    translate  <0.0, 0.0, 16.799976>
  }
  object { // LaufSp73->LaufSp
    LaufSp
    rotate <0.0, 0.0, -146.0>
    translate  <0.0, 0.0, 17.033309>
  }
  object { // LaufSp74->LaufSp
    LaufSp
    rotate <0.0, 0.0, -148.0>
    translate  <0.0, 0.0, 17.266642>
  }
  object { // LaufSp75->LaufSp
    LaufSp
    rotate <0.0, 0.0, -150.0>
    translate  <0.0, 0.0, 17.499975>
  }
  object { // LaufSp76->LaufSp
    LaufSp
    rotate <0.0, 0.0, -152.0>
    translate  <0.0, 0.0, 17.733308>
  }
  object { // LaufSp77->LaufSp
    LaufSp
    rotate <0.0, 0.0, -154.0>
    translate  <0.0, 0.0, 17.966641>
  }
  object { // LaufSp78->LaufSp
    LaufSp
    rotate <0.0, 0.0, -156.0>
    translate  <0.0, 0.0, 18.199974>
  }
  object { // LaufSp79->LaufSp
    LaufSp
    rotate <0.0, 0.0, -158.0>
    translate  <0.0, 0.0, 18.433307>
  }
  object { // LaufSp80->LaufSp
    LaufSp
    rotate <0.0, 0.0, -160.0>
    translate  <0.0, 0.0, 18.66664>
  }
  object { // LaufSp81->LaufSp
    LaufSp
    rotate <0.0, 0.0, -162.0>
    translate  <0.0, 0.0, 18.899973>
  }
  object { // LaufSp82->LaufSp
    LaufSp
    rotate <0.0, 0.0, -164.0>
    translate  <0.0, 0.0, 19.133306>
  }
  object { // LaufSp83->LaufSp
    LaufSp
    rotate <0.0, 0.0, -166.0>
    translate  <0.0, 0.0, 19.366639>
  }
  object { // LaufSp84->LaufSp
    LaufSp
    rotate <0.0, 0.0, -168.0>
    translate  <0.0, 0.0, 19.599972>
  }
  object { // LaufSp85->LaufSp
    LaufSp
    rotate <0.0, 0.0, -170.0>
    translate  <0.0, 0.0, 19.833305>
  }
  object { // LaufSp86->LaufSp
    LaufSp
    rotate <0.0, 0.0, -172.0>
    translate  <0.0, 0.0, 20.066638>
  }
  object { // LaufSp87->LaufSp
    LaufSp
    rotate <0.0, 0.0, -174.0>
    translate  <0.0, 0.0, 20.299971>
  }
  object { // LaufSp88->LaufSp
    LaufSp
    rotate <0.0, 0.0, -176.0>
    translate  <0.0, 0.0, 20.533304>
  }
  object { // LaufSp89->LaufSp
    LaufSp
    rotate <0.0, 0.0, -178.0>
    translate  <0.0, 0.0, 20.766637>
  }
  object { // LaufSp90->LaufSp
    LaufSp
    rotate <0.0, 0.0, 180.0>
    translate  <0.0, 0.0, 20.99997>
  }
  object { // LaufSp91->LaufSp
    LaufSp
    rotate <0.0, 0.0, 178.0>
    translate  <0.0, 0.0, 21.233303>
  }
  object { // LaufSp92->LaufSp
    LaufSp
    rotate <0.0, 0.0, 176.0>
    translate  <0.0, 0.0, 21.466636>
  }
  object { // LaufSp93->LaufSp
    LaufSp
    rotate <0.0, 0.0, 174.0>
    translate  <0.0, 0.0, 21.699969>
  }
  object { // LaufSp94->LaufSp
    LaufSp
    rotate <0.0, 0.0, 172.0>
    translate  <0.0, 0.0, 21.933302>
  }
  object { // LaufSp95->LaufSp
    LaufSp
    rotate <0.0, 0.0, 170.0>
    translate  <0.0, 0.0, 22.166635>
  }
  object { // LaufSp96->LaufSp
    LaufSp
    rotate <0.0, 0.0, 168.0>
    translate  <0.0, 0.0, 22.399968>
  }
  object { // LaufSp97->LaufSp
    LaufSp
    rotate <0.0, 0.0, 166.0>
    translate  <0.0, 0.0, 22.633301>
  }
  object { // LaufSp98->LaufSp
    LaufSp
    rotate <0.0, 0.0, 164.0>
    translate  <0.0, 0.0, 22.866634>
  }
  object { // LaufSp99->LaufSp
    LaufSp
    rotate <0.0, 0.0, 162.0>
    translate  <0.0, 0.0, 23.099967>
  }
  object { // LaufSp100->LaufSp
    LaufSp
    rotate <0.0, 0.0, 160.0>
    translate  <0.0, 0.0, 23.3333>
  }
  object { // LaufSp101->LaufSp
    LaufSp
    rotate <0.0, 0.0, 158.0>
    translate  <0.0, 0.0, 23.566633>
  }
  object { // LaufSp102->LaufSp
    LaufSp
    rotate <0.0, 0.0, 156.0>
    translate  <0.0, 0.0, 23.799966>
  }
  object { // LaufSp103->LaufSp
    LaufSp
    rotate <0.0, 0.0, 154.0>
    translate  <0.0, 0.0, 24.033299>
  }
  object { // LaufSp104->LaufSp
    LaufSp
    rotate <0.0, 0.0, 152.0>
    translate  <0.0, 0.0, 24.266632>
  }
  object { // LaufSp105->LaufSp
    LaufSp
    rotate <0.0, 0.0, 150.0>
    translate  <0.0, 0.0, 24.499965>
  }
  object { // LaufSp106->LaufSp
    LaufSp
    rotate <0.0, 0.0, 148.0>
    translate  <0.0, 0.0, 24.733298>
  }
  object { // LaufSp107->LaufSp
    LaufSp
    rotate <0.0, 0.0, 146.0>
    translate  <0.0, 0.0, 24.966631>
  }
  object { // LaufSp108->LaufSp
    LaufSp
    rotate <0.0, 0.0, 144.0>
    translate  <0.0, 0.0, 25.199964>
  }
  object { // LaufSp109->LaufSp
    LaufSp
    rotate <0.0, 0.0, 142.0>
    translate  <0.0, 0.0, 25.433297>
  }
  object { // LaufSp110->LaufSp
    LaufSp
    rotate <0.0, 0.0, 140.0>
    translate  <0.0, 0.0, 25.66663>
  }
  object { // LaufSp111->LaufSp
    LaufSp
    rotate <0.0, 0.0, 138.0>
    translate  <0.0, 0.0, 25.899963>
  }
  object { // LaufSp112->LaufSp
    LaufSp
    rotate <0.0, 0.0, 136.0>
    translate  <0.0, 0.0, 26.133296>
  }
  object { // LaufSp113->LaufSp
    LaufSp
    rotate <0.0, 0.0, 134.0>
    translate  <0.0, 0.0, 26.366629>
  }
  object { // LaufSp114->LaufSp
    LaufSp
    rotate <0.0, 0.0, 132.0>
    translate  <0.0, 0.0, 26.599962>
  }
  object { // LaufSp115->LaufSp
    LaufSp
    rotate <0.0, 0.0, 130.0>
    translate  <0.0, 0.0, 26.833295>
  }
  object { // LaufSp116->LaufSp
    LaufSp
    rotate <0.0, 0.0, 128.0>
    translate  <0.0, 0.0, 27.066628>
  }
  object { // LaufSp117->LaufSp
    LaufSp
    rotate <0.0, 0.0, 126.0>
    translate  <0.0, 0.0, 27.299961>
  }
  object { // LaufSp118->LaufSp
    LaufSp
    rotate <0.0, 0.0, 124.0>
    translate  <0.0, 0.0, 27.533294>
  }
  object { // LaufSp119->LaufSp
    LaufSp
    rotate <0.0, 0.0, 122.0>
    translate  <0.0, 0.0, 27.766627>
  }
  object { // LaufSp120->LaufSp
    LaufSp
    rotate <0.0, 0.0, 120.0>
    translate  <0.0, 0.0, 27.99996>
  }
  object { // LaufSp121->LaufSp
    LaufSp
    rotate <0.0, 0.0, 118.0>
    translate  <0.0, 0.0, 28.233293>
  }
  object { // LaufSp122->LaufSp
    LaufSp
    rotate <0.0, 0.0, 116.0>
    translate  <0.0, 0.0, 28.466626>
  }
  object { // LaufSp123->LaufSp
    LaufSp
    rotate <0.0, 0.0, 114.0>
    translate  <0.0, 0.0, 28.699959>
  }
  object { // LaufSp124->LaufSp
    LaufSp
    rotate <0.0, 0.0, 112.0>
    translate  <0.0, 0.0, 28.933292>
  }
  object { // LaufSp125->LaufSp
    LaufSp
    rotate <0.0, 0.0, 110.0>
    translate  <0.0, 0.0, 29.166625>
  }
  object { // LaufSp126->LaufSp
    LaufSp
    rotate <0.0, 0.0, 108.0>
    translate  <0.0, 0.0, 29.399958>
  }
  object { // LaufSp127->LaufSp
    LaufSp
    rotate <0.0, 0.0, 106.0>
    translate  <0.0, 0.0, 29.633291>
  }
  object { // LaufSp128->LaufSp
    LaufSp
    rotate <0.0, 0.0, 104.0>
    translate  <0.0, 0.0, 29.866624>
  }
  object { // LaufSp129->LaufSp
    LaufSp
    rotate <0.0, 0.0, 102.0>
    translate  <0.0, 0.0, 30.099957>
  }
  object { // LaufSp130->LaufSp
    LaufSp
    rotate <0.0, 0.0, 100.0>
    translate  <0.0, 0.0, 30.33329>
  }
  object { // LaufSp131->LaufSp
    LaufSp
    rotate <0.0, 0.0, 98.0>
    translate  <0.0, 0.0, 30.566623>
  }
  object { // LaufSp132->LaufSp
    LaufSp
    rotate <0.0, 0.0, 96.0>
    translate  <0.0, 0.0, 30.799956>
  }
  object { // LaufSp133->LaufSp
    LaufSp
    rotate <0.0, 0.0, 94.0>
    translate  <0.0, 0.0, 31.033289>
  }
  object { // LaufSp134->LaufSp
    LaufSp
    rotate <0.0, 0.0, 92.0>
    translate  <0.0, 0.0, 31.266622>
  }
  object { // LaufSp135->LaufSp
    LaufSp
    rotate <0.0, 0.0, 90.0>
    translate  <0.0, 0.0, 31.499955>
  }
  object { // LaufSp136->LaufSp
    LaufSp
    rotate <0.0, 0.0, 88.0>
    translate  <0.0, 0.0, 31.733288>
  }
  object { // LaufSp137->LaufSp
    LaufSp
    rotate <0.0, 0.0, 86.0>
    translate  <0.0, 0.0, 31.966621>
  }
  object { // LaufSp138->LaufSp
    LaufSp
    rotate <0.0, 0.0, 84.0>
    translate  <0.0, 0.0, 32.199954>
  }
  object { // LaufSp139->LaufSp
    LaufSp
    rotate <0.0, 0.0, 82.0>
    translate  <0.0, 0.0, 32.433287>
  }
  object { // LaufSp140->LaufSp
    LaufSp
    rotate <0.0, 0.0, 80.0>
    translate  <0.0, 0.0, 32.66662>
  }
  object { // LaufSp141->LaufSp
    LaufSp
    rotate <0.0, 0.0, 78.0>
    translate  <0.0, 0.0, 32.899953>
  }
  object { // LaufSp142->LaufSp
    LaufSp
    rotate <0.0, 0.0, 76.0>
    translate  <0.0, 0.0, 33.133286>
  }
  object { // LaufSp143->LaufSp
    LaufSp
    rotate <0.0, 0.0, 74.0>
    translate  <0.0, 0.0, 33.366619>
  }
  object { // LaufSp144->LaufSp
    LaufSp
    rotate <0.0, 0.0, 72.0>
    translate  <0.0, 0.0, 33.599952>
  }
  object { // LaufSp145->LaufSp
    LaufSp
    rotate <0.0, 0.0, 70.0>
    translate  <0.0, 0.0, 33.833285>
  }
  object { // LaufSp146->LaufSp
    LaufSp
    rotate <0.0, 0.0, 68.0>
    translate  <0.0, 0.0, 34.066618>
  }
  object { // LaufSp147->LaufSp
    LaufSp
    rotate <0.0, 0.0, 66.0>
    translate  <0.0, 0.0, 34.299951>
  }
  object { // LaufSp148->LaufSp
    LaufSp
    rotate <0.0, 0.0, 64.0>
    translate  <0.0, 0.0, 34.533284>
  }
  object { // LaufSp149->LaufSp
    LaufSp
    rotate <0.0, 0.0, 62.0>
    translate  <0.0, 0.0, 34.766617>
  }
  object { // LaufSp150->LaufSp
    LaufSp
    rotate <0.0, 0.0, 60.0>
    translate  <0.0, 0.0, 34.99995>
  }
  object { // LaufSp151->LaufSp
    LaufSp
    rotate <0.0, 0.0, 58.0>
    translate  <0.0, 0.0, 35.233283>
  }
  object { // LaufSp152->LaufSp
    LaufSp
    rotate <0.0, 0.0, 56.0>
    translate  <0.0, 0.0, 35.466616>
  }
  object { // LaufSp153->LaufSp
    LaufSp
    rotate <0.0, 0.0, 54.0>
    translate  <0.0, 0.0, 35.699949>
  }
  object { // LaufSp154->LaufSp
    LaufSp
    rotate <0.0, 0.0, 52.0>
    translate  <0.0, 0.0, 35.933282>
  }
  object { // LaufSp155->LaufSp
    LaufSp
    rotate <0.0, 0.0, 50.0>
    translate  <0.0, 0.0, 36.166615>
  }
  object { // LaufSp156->LaufSp
    LaufSp
    rotate <0.0, 0.0, 48.0>
    translate  <0.0, 0.0, 36.399948>
  }
  object { // LaufSp157->LaufSp
    LaufSp
    rotate <0.0, 0.0, 46.0>
    translate  <0.0, 0.0, 36.633281>
  }
  object { // LaufSp158->LaufSp
    LaufSp
    rotate <0.0, 0.0, 44.0>
    translate  <0.0, 0.0, 36.866614>
  }
  object { // LaufSp159->LaufSp
    LaufSp
    rotate <0.0, 0.0, 42.0>
    translate  <0.0, 0.0, 37.099947>
  }
  object { // LaufSp160->LaufSp
    LaufSp
    rotate <0.0, 0.0, 40.0>
    translate  <0.0, 0.0, 37.33328>
  }
  object { // LaufSp161->LaufSp
    LaufSp
    rotate <0.0, 0.0, 38.0>
    translate  <0.0, 0.0, 37.566613>
  }
  object { // LaufSp162->LaufSp
    LaufSp
    rotate <0.0, 0.0, 36.0>
    translate  <0.0, 0.0, 37.799946>
  }
  object { // LaufSp163->LaufSp
    LaufSp
    rotate <0.0, 0.0, 34.0>
    translate  <0.0, 0.0, 38.033279>
  }
  object { // LaufSp164->LaufSp
    LaufSp
    rotate <0.0, 0.0, 32.0>
    translate  <0.0, 0.0, 38.266612>
  }
  object { // LaufSp165->LaufSp
    LaufSp
    rotate <0.0, 0.0, 30.0>
    translate  <0.0, 0.0, 38.499945>
  }
  object { // LaufSp166->LaufSp
    LaufSp
    rotate <0.0, 0.0, 28.0>
    translate  <0.0, 0.0, 38.733278>
  }
  object { // LaufSp167->LaufSp
    LaufSp
    rotate <0.0, 0.0, 26.0>
    translate  <0.0, 0.0, 38.966611>
  }
  object { // LaufSp168->LaufSp
    LaufSp
    rotate <0.0, 0.0, 24.0>
    translate  <0.0, 0.0, 39.199944>
  }
  object { // LaufSp169->LaufSp
    LaufSp
    rotate <0.0, 0.0, 22.0>
    translate  <0.0, 0.0, 39.433277>
  }
  object { // LaufSp170->LaufSp
    LaufSp
    rotate <0.0, 0.0, 20.0>
    translate  <0.0, 0.0, 39.66661>
  }
  object { // LaufSp171->LaufSp
    LaufSp
    rotate <0.0, 0.0, 18.0>
    translate  <0.0, 0.0, 39.899943>
  }
  object { // LaufSp172->LaufSp
    LaufSp
    rotate <0.0, 0.0, 16.0>
    translate  <0.0, 0.0, 40.133276>
  }
  object { // LaufSp173->LaufSp
    LaufSp
    rotate <0.0, 0.0, 14.0>
    translate  <0.0, 0.0, 40.366609>
  }
  object { // LaufSp174->LaufSp
    LaufSp
    rotate <0.0, 0.0, 12.0>
    translate  <0.0, 0.0, 40.599942>
  }
  object { // LaufSp175->LaufSp
    LaufSp
    rotate <0.0, 0.0, 10.0>
    translate  <0.0, 0.0, 40.833275>
  }
  object { // LaufSp176->LaufSp
    LaufSp
    rotate <0.0, 0.0, 8.0>
    translate  <0.0, 0.0, 41.066608>
  }
  object { // LaufSp177->LaufSp
    LaufSp
    rotate <0.0, 0.0, 6.0>
    translate  <0.0, 0.0, 41.299941>
  }
  object { // LaufSp178->LaufSp
    LaufSp
    rotate <0.0, 0.0, 4.0>
    translate  <0.0, 0.0, 41.533274>
  }
  object { // LaufSp179->LaufSp
    LaufSp
    rotate <0.0, 0.0, 2.0>
    translate  <0.0, 0.0, 41.766607>
  }
  object { // LaufSp180->LaufSp
    LaufSp
    rotate <0.0, 0.0, 0.0>
    translate  <0.0, 0.0, 41.99994>
  }
  object { // LaufSp181->LaufSp
    LaufSp
    rotate <0.0, 0.0, -2.0>
    translate  <0.0, 0.0, 42.233273>
  }
  object { // LaufSp182->LaufSp
    LaufSp
    rotate <0.0, 0.0, -4.0>
    translate  <0.0, 0.0, 42.466606>
  }
  object { // LaufSp183->LaufSp
    LaufSp
    rotate <0.0, 0.0, -6.0>
    translate  <0.0, 0.0, 42.699939>
  }
  object { // LaufSp184->LaufSp
    LaufSp
    rotate <0.0, 0.0, -8.0>
    translate  <0.0, 0.0, 42.933272>
  }
  object { // LaufSp185->LaufSp
    LaufSp
    rotate <0.0, 0.0, -10.0>
    translate  <0.0, 0.0, 43.166605>
  }
  object { // LaufSp186->LaufSp
    LaufSp
    rotate <0.0, 0.0, -12.0>
    translate  <0.0, 0.0, 43.399938>
  }
  object { // LaufSp187->LaufSp
    LaufSp
    rotate <0.0, 0.0, -14.0>
    translate  <0.0, 0.0, 43.633271>
  }
  object { // LaufSp188->LaufSp
    LaufSp
    rotate <0.0, 0.0, -16.0>
    translate  <0.0, 0.0, 43.866604>
  }
  object { // LaufSp189->LaufSp
    LaufSp
    rotate <0.0, 0.0, -18.0>
    translate  <0.0, 0.0, 44.099937>
  }
  object { // LaufSp190->LaufSp
    LaufSp
    rotate <0.0, 0.0, -20.0>
    translate  <0.0, 0.0, 44.33327>
  }
  object { // LaufSp191->LaufSp
    LaufSp
    rotate <0.0, 0.0, -22.0>
    translate  <0.0, 0.0, 44.566603>
  }
  object { // LaufSp192->LaufSp
    LaufSp
    rotate <0.0, 0.0, -24.0>
    translate  <0.0, 0.0, 44.799936>
  }
  object { // LaufSp193->LaufSp
    LaufSp
    rotate <0.0, 0.0, -26.0>
    translate  <0.0, 0.0, 45.033269>
  }
  object { // LaufSp194->LaufSp
    LaufSp
    rotate <0.0, 0.0, -28.0>
    translate  <0.0, 0.0, 45.266602>
  }
  object { // LaufSp195->LaufSp
    LaufSp
    rotate <0.0, 0.0, -30.0>
    translate  <0.0, 0.0, 45.499935>
  }
  object { // LaufSp196->LaufSp
    LaufSp
    rotate <0.0, 0.0, -32.0>
    translate  <0.0, 0.0, 45.733268>
  }
  object { // LaufSp197->LaufSp
    LaufSp
    rotate <0.0, 0.0, -34.0>
    translate  <0.0, 0.0, 45.966601>
  }
  object { // LaufSp198->LaufSp
    LaufSp
    rotate <0.0, 0.0, -36.0>
    translate  <0.0, 0.0, 46.199934>
  }
  object { // LaufSp199->LaufSp
    LaufSp
    rotate <0.0, 0.0, -38.0>
    translate  <0.0, 0.0, 46.433267>
  }
  object { // LaufSp200->LaufSp
    LaufSp
    rotate <0.0, 0.0, -40.0>
    translate  <0.0, 0.0, 46.6666>
  }
  object { // LaufSp201->LaufSp
    LaufSp
    rotate <0.0, 0.0, -42.0>
    translate  <0.0, 0.0, 46.899933>
  }
  object { // LaufSp202->LaufSp
    LaufSp
    rotate <0.0, 0.0, -44.0>
    translate  <0.0, 0.0, 47.133266>
  }
  object { // LaufSp203->LaufSp
    LaufSp
    rotate <0.0, 0.0, -46.0>
    translate  <0.0, 0.0, 47.366599>
  }
  object { // LaufSp204->LaufSp
    LaufSp
    rotate <0.0, 0.0, -48.0>
    translate  <0.0, 0.0, 47.599932>
  }
  object { // LaufSp205->LaufSp
    LaufSp
    rotate <0.0, 0.0, -50.0>
    translate  <0.0, 0.0, 47.833265>
  }
  object { // LaufSp206->LaufSp
    LaufSp
    rotate <0.0, 0.0, -52.0>
    translate  <0.0, 0.0, 48.066598>
  }
  object { // LaufSp207->LaufSp
    LaufSp
    rotate <0.0, 0.0, -54.0>
    translate  <0.0, 0.0, 48.299931>
  }
  object { // LaufSp208->LaufSp
    LaufSp
    rotate <0.0, 0.0, -56.0>
    translate  <0.0, 0.0, 48.533264>
  }
  object { // LaufSp209->LaufSp
    LaufSp
    rotate <0.0, 0.0, -58.0>
    translate  <0.0, 0.0, 48.766597>
  }
  object { // LaufSp210->LaufSp
    LaufSp
    rotate <0.0, 0.0, -60.0>
    translate  <0.0, 0.0, 48.99993>
  }
  object { // LaufSp211->LaufSp
    LaufSp
    rotate <0.0, 0.0, -62.0>
    translate  <0.0, 0.0, 49.233263>
  }
  object { // LaufSp212->LaufSp
    LaufSp
    rotate <0.0, 0.0, -64.0>
    translate  <0.0, 0.0, 49.466596>
  }
  object { // LaufSp213->LaufSp
    LaufSp
    rotate <0.0, 0.0, -66.0>
    translate  <0.0, 0.0, 49.699929>
  }
  object { // LaufSp214->LaufSp
    LaufSp
    rotate <0.0, 0.0, -68.0>
    translate  <0.0, 0.0, 49.933262>
  }
  object { // LaufSp215->LaufSp
    LaufSp
    rotate <0.0, 0.0, -70.0>
    translate  <0.0, 0.0, 50.166595>
  }
  object { // LaufSp216->LaufSp
    LaufSp
    rotate <0.0, 0.0, -72.0>
    translate  <0.0, 0.0, 50.399928>
  }
  object { // LaufSp217->LaufSp
    LaufSp
    rotate <0.0, 0.0, -74.0>
    translate  <0.0, 0.0, 50.633261>
  }
  object { // LaufSp218->LaufSp
    LaufSp
    rotate <0.0, 0.0, -76.0>
    translate  <0.0, 0.0, 50.866594>
  }
  object { // LaufSp219->LaufSp
    LaufSp
    rotate <0.0, 0.0, -78.0>
    translate  <0.0, 0.0, 51.099927>
  }
  object { // LaufSp220->LaufSp
    LaufSp
    rotate <0.0, 0.0, -80.0>
    translate  <0.0, 0.0, 51.33326>
  }
  object { // LaufSp221->LaufSp
    LaufSp
    rotate <0.0, 0.0, -82.0>
    translate  <0.0, 0.0, 51.566593>
  }
  object { // LaufSp222->LaufSp
    LaufSp
    rotate <0.0, 0.0, -84.0>
    translate  <0.0, 0.0, 51.799926>
  }
  object { // LaufSp223->LaufSp
    LaufSp
    rotate <0.0, 0.0, -86.0>
    translate  <0.0, 0.0, 52.033259>
  }
  object { // LaufSp224->LaufSp
    LaufSp
    rotate <0.0, 0.0, -88.0>
    translate  <0.0, 0.0, 52.266592>
  }
  object { // LaufSp225->LaufSp
    LaufSp
    rotate <0.0, 0.0, -90.0>
    translate  <0.0, 0.0, 52.499925>
  }
  object { // LaufSp226->LaufSp
    LaufSp
    rotate <0.0, 0.0, -92.0>
    translate  <0.0, 0.0, 52.733258>
  }
  object { // LaufSp227->LaufSp
    LaufSp
    rotate <0.0, 0.0, -94.0>
    translate  <0.0, 0.0, 52.966591>
  }
  object { // LaufSp228->LaufSp
    LaufSp
    rotate <0.0, 0.0, -96.0>
    translate  <0.0, 0.0, 53.199924>
  }
  object { // LaufSp229->LaufSp
    LaufSp
    rotate <0.0, 0.0, -98.0>
    translate  <0.0, 0.0, 53.433257>
  }
  object { // LaufSp230->LaufSp
    LaufSp
    rotate <0.0, 0.0, -100.0>
    translate  <0.0, 0.0, 53.66659>
  }
  object { // LaufSp231->LaufSp
    LaufSp
    rotate <0.0, 0.0, -102.0>
    translate  <0.0, 0.0, 53.899923>
  }
  object { // LaufSp232->LaufSp
    LaufSp
    rotate <0.0, 0.0, -104.0>
    translate  <0.0, 0.0, 54.133256>
  }
  object { // LaufSp233->LaufSp
    LaufSp
    rotate <0.0, 0.0, -106.0>
    translate  <0.0, 0.0, 54.366589>
  }
  object { // LaufSp234->LaufSp
    LaufSp
    rotate <0.0, 0.0, -108.0>
    translate  <0.0, 0.0, 54.599922>
  }
  object { // LaufSp235->LaufSp
    LaufSp
    rotate <0.0, 0.0, -110.0>
    translate  <0.0, 0.0, 54.833255>
  }
  object { // LaufSp236->LaufSp
    LaufSp
    rotate <0.0, 0.0, -112.0>
    translate  <0.0, 0.0, 55.066588>
  }
  object { // LaufSp237->LaufSp
    LaufSp
    rotate <0.0, 0.0, -114.0>
    translate  <0.0, 0.0, 55.299921>
  }
  object { // LaufSp238->LaufSp
    LaufSp
    rotate <0.0, 0.0, -116.0>
    translate  <0.0, 0.0, 55.533254>
  }
  object { // LaufSp239->LaufSp
    LaufSp
    rotate <0.0, 0.0, -118.0>
    translate  <0.0, 0.0, 55.766587>
  }
  object { // LaufSp240->LaufSp
    LaufSp
    rotate <0.0, 0.0, -120.0>
    translate  <0.0, 0.0, 55.99992>
  }
  object { // LaufSp241->LaufSp
    LaufSp
    rotate <0.0, 0.0, -122.0>
    translate  <0.0, 0.0, 56.233253>
  }
  object { // LaufSp242->LaufSp
    LaufSp
    rotate <0.0, 0.0, -124.0>
    translate  <0.0, 0.0, 56.466586>
  }
  object { // LaufSp243->LaufSp
    LaufSp
    rotate <0.0, 0.0, -126.0>
    translate  <0.0, 0.0, 56.699919>
  }
  object { // LaufSp244->LaufSp
    LaufSp
    rotate <0.0, 0.0, -128.0>
    translate  <0.0, 0.0, 56.933252>
  }
  object { // LaufSp245->LaufSp
    LaufSp
    rotate <0.0, 0.0, -130.0>
    translate  <0.0, 0.0, 57.166585>
  }
  object { // LaufSp246->LaufSp
    LaufSp
    rotate <0.0, 0.0, -132.0>
    translate  <0.0, 0.0, 57.399918>
  }
  object { // LaufSp247->LaufSp
    LaufSp
    rotate <0.0, 0.0, -134.0>
    translate  <0.0, 0.0, 57.633251>
  }
  object { // LaufSp248->LaufSp
    LaufSp
    rotate <0.0, 0.0, -136.0>
    translate  <0.0, 0.0, 57.866584>
  }
  object { // LaufSp249->LaufSp
    LaufSp
    rotate <0.0, 0.0, -138.0>
    translate  <0.0, 0.0, 58.099917>
  }
  object { // LaufSp250->LaufSp
    LaufSp
    rotate <0.0, 0.0, -140.0>
    translate  <0.0, 0.0, 58.33325>
  }
  object { // LaufSp251->LaufSp
    LaufSp
    rotate <0.0, 0.0, -142.0>
    translate  <0.0, 0.0, 58.566583>
  }
  object { // LaufSp252->LaufSp
    LaufSp
    rotate <0.0, 0.0, -144.0>
    translate  <0.0, 0.0, 58.799916>
  }
  object { // LaufSp253->LaufSp
    LaufSp
    rotate <0.0, 0.0, -146.0>
    translate  <0.0, 0.0, 59.033249>
  }
  object { // LaufSp254->LaufSp
    LaufSp
    rotate <0.0, 0.0, -148.0>
    translate  <0.0, 0.0, 59.266582>
  }
  object { // LaufSp255->LaufSp
    LaufSp
    rotate <0.0, 0.0, -150.0>
    translate  <0.0, 0.0, 59.499915>
  }
  object { // LaufSp256->LaufSp
    LaufSp
    rotate <0.0, 0.0, -152.0>
    translate  <0.0, 0.0, 59.733248>
  }
  object { // LaufSp257->LaufSp
    LaufSp
    rotate <0.0, 0.0, -154.0>
    translate  <0.0, 0.0, 59.966581>
  }
  object { // LaufSp258->LaufSp
    LaufSp
    rotate <0.0, 0.0, -156.0>
    translate  <0.0, 0.0, 60.199914>
  }
  object { // LaufSp259->LaufSp
    LaufSp
    rotate <0.0, 0.0, -158.0>
    translate  <0.0, 0.0, 60.433247>
  }
  object { // LaufSp260->LaufSp
    LaufSp
    rotate <0.0, 0.0, -160.0>
    translate  <0.0, 0.0, 60.66658>
  }
  object { // LaufSp261->LaufSp
    LaufSp
    rotate <0.0, 0.0, -162.0>
    translate  <0.0, 0.0, 60.899913>
  }
  object { // LaufSp262->LaufSp
    LaufSp
    rotate <0.0, 0.0, -164.0>
    translate  <0.0, 0.0, 61.133246>
  }
  object { // LaufSp263->LaufSp
    LaufSp
    rotate <0.0, 0.0, -166.0>
    translate  <0.0, 0.0, 61.366579>
  }
  object { // LaufSp264->LaufSp
    LaufSp
    rotate <0.0, 0.0, -168.0>
    translate  <0.0, 0.0, 61.599912>
  }
  object { // LaufSp265->LaufSp
    LaufSp
    rotate <0.0, 0.0, -170.0>
    translate  <0.0, 0.0, 61.833245>
  }
  object { // LaufSp266->LaufSp
    LaufSp
    rotate <0.0, 0.0, -172.0>
    translate  <0.0, 0.0, 62.066578>
  }
  object { // LaufSp267->LaufSp
    LaufSp
    rotate <0.0, 0.0, -174.0>
    translate  <0.0, 0.0, 62.299911>
  }
  object { // LaufSp268->LaufSp
    LaufSp
    rotate <0.0, 0.0, -176.0>
    translate  <0.0, 0.0, 62.533244>
  }
  object { // LaufSp269->LaufSp
    LaufSp
    rotate <0.0, 0.0, -178.0>
    translate  <0.0, 0.0, 62.766577>
  }
  object { // LaufSp270->LaufSp
    LaufSp
    rotate <0.0, 0.0, 180.0>
    translate  <0.0, 0.0, 62.99991>
  }
  object { // LaufSp271->LaufSp
    LaufSp
    rotate <0.0, 0.0, 178.0>
    translate  <0.0, 0.0, 63.233243>
  }
  object { // LaufSp272->LaufSp
    LaufSp
    rotate <0.0, 0.0, 176.0>
    translate  <0.0, 0.0, 63.466576>
  }
  object { // LaufSp273->LaufSp
    LaufSp
    rotate <0.0, 0.0, 174.0>
    translate  <0.0, 0.0, 63.699909>
  }
  object { // LaufSp274->LaufSp
    LaufSp
    rotate <0.0, 0.0, 172.0>
    translate  <0.0, 0.0, 63.933242>
  }
  object { // LaufSp275->LaufSp
    LaufSp
    rotate <0.0, 0.0, 170.0>
    translate  <0.0, 0.0, 64.166575>
  }
  object { // LaufSp276->LaufSp
    LaufSp
    rotate <0.0, 0.0, 168.0>
    translate  <0.0, 0.0, 64.399908>
  }
  object { // LaufSp277->LaufSp
    LaufSp
    rotate <0.0, 0.0, 166.0>
    translate  <0.0, 0.0, 64.633241>
  }
  object { // LaufSp278->LaufSp
    LaufSp
    rotate <0.0, 0.0, 164.0>
    translate  <0.0, 0.0, 64.866574>
  }
  object { // LaufSp279->LaufSp
    LaufSp
    rotate <0.0, 0.0, 162.0>
    translate  <0.0, 0.0, 65.099907>
  }
  object { // LaufSp280->LaufSp
    LaufSp
    rotate <0.0, 0.0, 160.0>
    translate  <0.0, 0.0, 65.33324>
  }
  object { // LaufSp281->LaufSp
    LaufSp
    rotate <0.0, 0.0, 158.0>
    translate  <0.0, 0.0, 65.566573>
  }
  object { // LaufSp282->LaufSp
    LaufSp
    rotate <0.0, 0.0, 156.0>
    translate  <0.0, 0.0, 65.799906>
  }
  object { // LaufSp283->LaufSp
    LaufSp
    rotate <0.0, 0.0, 154.0>
    translate  <0.0, 0.0, 66.033239>
  }
  object { // LaufSp284->LaufSp
    LaufSp
    rotate <0.0, 0.0, 152.0>
    translate  <0.0, 0.0, 66.266572>
  }
  object { // LaufSp285->LaufSp
    LaufSp
    rotate <0.0, 0.0, 150.0>
    translate  <0.0, 0.0, 66.499905>
  }
  object { // LaufSp286->LaufSp
    LaufSp
    rotate <0.0, 0.0, 148.0>
    translate  <0.0, 0.0, 66.733238>
  }
  object { // LaufSp287->LaufSp
    LaufSp
    rotate <0.0, 0.0, 146.0>
    translate  <0.0, 0.0, 66.966571>
  }
  object { // LaufSp288->LaufSp
    LaufSp
    rotate <0.0, 0.0, 144.0>
    translate  <0.0, 0.0, 67.199904>
  }
  object { // LaufSp289->LaufSp
    LaufSp
    rotate <0.0, 0.0, 142.0>
    translate  <0.0, 0.0, 67.433237>
  }
  object { // LaufSp290->LaufSp
    LaufSp
    rotate <0.0, 0.0, 140.0>
    translate  <0.0, 0.0, 67.66657>
  }
  object { // LaufSp291->LaufSp
    LaufSp
    rotate <0.0, 0.0, 138.0>
    translate  <0.0, 0.0, 67.899903>
  }
  object { // LaufSp292->LaufSp
    LaufSp
    rotate <0.0, 0.0, 136.0>
    translate  <0.0, 0.0, 68.133236>
  }
  object { // LaufSp293->LaufSp
    LaufSp
    rotate <0.0, 0.0, 134.0>
    translate  <0.0, 0.0, 68.366569>
  }
  object { // LaufSp294->LaufSp
    LaufSp
    rotate <0.0, 0.0, 132.0>
    translate  <0.0, 0.0, 68.599902>
  }
  object { // LaufSp295->LaufSp
    LaufSp
    rotate <0.0, 0.0, 130.0>
    translate  <0.0, 0.0, 68.833235>
  }
  object { // LaufSp296->LaufSp
    LaufSp
    rotate <0.0, 0.0, 128.0>
    translate  <0.0, 0.0, 69.066568>
  }
  object { // LaufSp297->LaufSp
    LaufSp
    rotate <0.0, 0.0, 126.0>
    translate  <0.0, 0.0, 69.299901>
  }
  object { // LaufSp298->LaufSp
    LaufSp
    rotate <0.0, 0.0, 124.0>
    translate  <0.0, 0.0, 69.533234>
  }
  object { // LaufSp299->LaufSp
    LaufSp
    rotate <0.0, 0.0, 122.0>
    translate  <0.0, 0.0, 69.766567>
  }
  object { // LaufSp300->LaufSp
    LaufSp
    rotate <0.0, 0.0, 120.0>
    translate  <0.0, 0.0, 69.9999>
  }
  object { // LaufSp301->LaufSp
    LaufSp
    rotate <0.0, 0.0, 118.0>
    translate  <0.0, 0.0, 70.233233>
  }
  object { // LaufSp302->LaufSp
    LaufSp
    rotate <0.0, 0.0, 116.0>
    translate  <0.0, 0.0, 70.466566>
  }
  object { // LaufSp303->LaufSp
    LaufSp
    rotate <0.0, 0.0, 114.0>
    translate  <0.0, 0.0, 70.699899>
  }
  object { // LaufSp304->LaufSp
    LaufSp
    rotate <0.0, 0.0, 112.0>
    translate  <0.0, 0.0, 70.933232>
  }
  object { // LaufSp305->LaufSp
    LaufSp
    rotate <0.0, 0.0, 110.0>
    translate  <0.0, 0.0, 71.166565>
  }
  object { // LaufSp306->LaufSp
    LaufSp
    rotate <0.0, 0.0, 108.0>
    translate  <0.0, 0.0, 71.399898>
  }
  object { // LaufSp307->LaufSp
    LaufSp
    rotate <0.0, 0.0, 106.0>
    translate  <0.0, 0.0, 71.633231>
  }
  object { // LaufSp308->LaufSp
    LaufSp
    rotate <0.0, 0.0, 104.0>
    translate  <0.0, 0.0, 71.866564>
  }
  object { // LaufSp309->LaufSp
    LaufSp
    rotate <0.0, 0.0, 102.0>
    translate  <0.0, 0.0, 72.099897>
  }
  object { // LaufSp310->LaufSp
    LaufSp
    rotate <0.0, 0.0, 100.0>
    translate  <0.0, 0.0, 72.33323>
  }
  object { // LaufSp311->LaufSp
    LaufSp
    rotate <0.0, 0.0, 98.0>
    translate  <0.0, 0.0, 72.566563>
  }
  object { // LaufSp312->LaufSp
    LaufSp
    rotate <0.0, 0.0, 96.0>
    translate  <0.0, 0.0, 72.799896>
  }
  object { // LaufSp313->LaufSp
    LaufSp
    rotate <0.0, 0.0, 94.0>
    translate  <0.0, 0.0, 73.033229>
  }
  object { // LaufSp314->LaufSp
    LaufSp
    rotate <0.0, 0.0, 92.0>
    translate  <0.0, 0.0, 73.266562>
  }
  object { // LaufSp315->LaufSp
    LaufSp
    rotate <0.0, 0.0, 90.0>
    translate  <0.0, 0.0, 73.499895>
  }
  object { // LaufSp316->LaufSp
    LaufSp
    rotate <0.0, 0.0, 88.0>
    translate  <0.0, 0.0, 73.733228>
  }
  object { // LaufSp317->LaufSp
    LaufSp
    rotate <0.0, 0.0, 86.0>
    translate  <0.0, 0.0, 73.966561>
  }
  object { // LaufSp318->LaufSp
    LaufSp
    rotate <0.0, 0.0, 84.0>
    translate  <0.0, 0.0, 74.199894>
  }
  object { // LaufSp319->LaufSp
    LaufSp
    rotate <0.0, 0.0, 82.0>
    translate  <0.0, 0.0, 74.433227>
  }
  object { // LaufSp320->LaufSp
    LaufSp
    rotate <0.0, 0.0, 80.0>
    translate  <0.0, 0.0, 74.66656>
  }
  object { // LaufSp321->LaufSp
    LaufSp
    rotate <0.0, 0.0, 78.0>
    translate  <0.0, 0.0, 74.899893>
  }
  object { // LaufSp322->LaufSp
    LaufSp
    rotate <0.0, 0.0, 76.0>
    translate  <0.0, 0.0, 75.133226>
  }
  object { // LaufSp323->LaufSp
    LaufSp
    rotate <0.0, 0.0, 74.0>
    translate  <0.0, 0.0, 75.366559>
  }
  object { // LaufSp324->LaufSp
    LaufSp
    rotate <0.0, 0.0, 72.0>
    translate  <0.0, 0.0, 75.599892>
  }
  object { // LaufSp325->LaufSp
    LaufSp
    rotate <0.0, 0.0, 70.0>
    translate  <0.0, 0.0, 75.833225>
  }
  object { // LaufSp326->LaufSp
    LaufSp
    rotate <0.0, 0.0, 68.0>
    translate  <0.0, 0.0, 76.066558>
  }
  object { // LaufSp327->LaufSp
    LaufSp
    rotate <0.0, 0.0, 66.0>
    translate  <0.0, 0.0, 76.299891>
  }
  object { // LaufSp328->LaufSp
    LaufSp
    rotate <0.0, 0.0, 64.0>
    translate  <0.0, 0.0, 76.533224>
  }
  object { // LaufSp329->LaufSp
    LaufSp
    rotate <0.0, 0.0, 62.0>
    translate  <0.0, 0.0, 76.766557>
  }
  object { // LaufSp330->LaufSp
    LaufSp
    rotate <0.0, 0.0, 60.0>
    translate  <0.0, 0.0, 76.99989>
  }
  object { // LaufSp331->LaufSp
    LaufSp
    rotate <0.0, 0.0, 58.0>
    translate  <0.0, 0.0, 77.233223>
  }
  object { // LaufSp332->LaufSp
    LaufSp
    rotate <0.0, 0.0, 56.0>
    translate  <0.0, 0.0, 77.466556>
  }
  object { // LaufSp333->LaufSp
    LaufSp
    rotate <0.0, 0.0, 54.0>
    translate  <0.0, 0.0, 77.699889>
  }
  object { // LaufSp334->LaufSp
    LaufSp
    rotate <0.0, 0.0, 52.0>
    translate  <0.0, 0.0, 77.933222>
  }
  object { // LaufSp335->LaufSp
    LaufSp
    rotate <0.0, 0.0, 50.0>
    translate  <0.0, 0.0, 78.166555>
  }
  object { // LaufSp336->LaufSp
    LaufSp
    rotate <0.0, 0.0, 48.0>
    translate  <0.0, 0.0, 78.399888>
  }
  object { // LaufSp337->LaufSp
    LaufSp
    rotate <0.0, 0.0, 46.0>
    translate  <0.0, 0.0, 78.633221>
  }
  object { // LaufSp338->LaufSp
    LaufSp
    rotate <0.0, 0.0, 44.0>
    translate  <0.0, 0.0, 78.866554>
  }
  object { // LaufSp339->LaufSp
    LaufSp
    rotate <0.0, 0.0, 42.0>
    translate  <0.0, 0.0, 79.099887>
  }
  object { // LaufSp340->LaufSp
    LaufSp
    rotate <0.0, 0.0, 40.0>
    translate  <0.0, 0.0, 79.33322>
  }
  object { // LaufSp341->LaufSp
    LaufSp
    rotate <0.0, 0.0, 38.0>
    translate  <0.0, 0.0, 79.566553>
  }
  object { // LaufSp342->LaufSp
    LaufSp
    rotate <0.0, 0.0, 36.0>
    translate  <0.0, 0.0, 79.799886>
  }
  object { // LaufSp343->LaufSp
    LaufSp
    rotate <0.0, 0.0, 34.0>
    translate  <0.0, 0.0, 80.033219>
  }
  object { // LaufSp344->LaufSp
    LaufSp
    rotate <0.0, 0.0, 32.0>
    translate  <0.0, 0.0, 80.266552>
  }
  object { // LaufSp345->LaufSp
    LaufSp
    rotate <0.0, 0.0, 30.0>
    translate  <0.0, 0.0, 80.499885>
  }
  object { // LaufSp346->LaufSp
    LaufSp
    rotate <0.0, 0.0, 28.0>
    translate  <0.0, 0.0, 80.733218>
  }
  object { // LaufSp347->LaufSp
    LaufSp
    rotate <0.0, 0.0, 26.0>
    translate  <0.0, 0.0, 80.966551>
  }
  object { // LaufSp348->LaufSp
    LaufSp
    rotate <0.0, 0.0, 24.0>
    translate  <0.0, 0.0, 81.199884>
  }
  object { // LaufSp349->LaufSp
    LaufSp
    rotate <0.0, 0.0, 22.0>
    translate  <0.0, 0.0, 81.433217>
  }
  object { // LaufSp350->LaufSp
    LaufSp
    rotate <0.0, 0.0, 20.0>
    translate  <0.0, 0.0, 81.66655>
  }
  object { // LaufSp351->LaufSp
    LaufSp
    rotate <0.0, 0.0, 18.0>
    translate  <0.0, 0.0, 81.899883>
  }
  object { // LaufSp352->LaufSp
    LaufSp
    rotate <0.0, 0.0, 16.0>
    translate  <0.0, 0.0, 82.133216>
  }
  object { // LaufSp353->LaufSp
    LaufSp
    rotate <0.0, 0.0, 14.0>
    translate  <0.0, 0.0, 82.366549>
  }
  object { // LaufSp354->LaufSp
    LaufSp
    rotate <0.0, 0.0, 12.0>
    translate  <0.0, 0.0, 82.599882>
  }
  object { // LaufSp355->LaufSp
    LaufSp
    rotate <0.0, 0.0, 10.0>
    translate  <0.0, 0.0, 82.833215>
  }
  object { // LaufSp356->LaufSp
    LaufSp
    rotate <0.0, 0.0, 8.0>
    translate  <0.0, 0.0, 83.066548>
  }
  object { // LaufSp357->LaufSp
    LaufSp
    rotate <0.0, 0.0, 6.0>
    translate  <0.0, 0.0, 83.299881>
  }
  object { // LaufSp358->LaufSp
    LaufSp
    rotate <0.0, 0.0, 4.0>
    translate  <0.0, 0.0, 83.533214>
  }
  object { // LaufSp359->LaufSp
    LaufSp
    rotate <0.0, 0.0, 2.0>
    translate  <0.0, 0.0, 83.766547>
  }
  object { // LaufSp360->LaufSp
    LaufSp
    rotate <0.0, 0.0, 0.0>
    translate  <0.0, 0.0, 83.99988>
  }
  object { // LaufSp361->LaufSp
    LaufSp
    rotate <0.0, 0.0, -2.0>
    translate  <0.0, 0.0, 84.233213>
  }
  object { // LaufSp362->LaufSp
    LaufSp
    rotate <0.0, 0.0, -4.0>
    translate  <0.0, 0.0, 84.466546>
  }
  object { // LaufSp363->LaufSp
    LaufSp
    rotate <0.0, 0.0, -6.0>
    translate  <0.0, 0.0, 84.699879>
  }
  object { // LaufSp364->LaufSp
    LaufSp
    rotate <0.0, 0.0, -8.0>
    translate  <0.0, 0.0, 84.933212>
  }
  object { // LaufSp365->LaufSp
    LaufSp
    rotate <0.0, 0.0, -10.0>
    translate  <0.0, 0.0, 85.166545>
  }
  object { // LaufSp366->LaufSp
    LaufSp
    rotate <0.0, 0.0, -12.0>
    translate  <0.0, 0.0, 85.399878>
  }
  object { // LaufSp367->LaufSp
    LaufSp
    rotate <0.0, 0.0, -14.0>
    translate  <0.0, 0.0, 85.633211>
  }
  object { // LaufSp368->LaufSp
    LaufSp
    rotate <0.0, 0.0, -16.0>
    translate  <0.0, 0.0, 85.866544>
  }
  object { // LaufSp369->LaufSp
    LaufSp
    rotate <0.0, 0.0, -18.0>
    translate  <0.0, 0.0, 86.099877>
  }
  object { // LaufSp370->LaufSp
    LaufSp
    rotate <0.0, 0.0, -20.0>
    translate  <0.0, 0.0, 86.33321>
  }
  object { // LaufSp371->LaufSp
    LaufSp
    rotate <0.0, 0.0, -22.0>
    translate  <0.0, 0.0, 86.566543>
  }
  object { // LaufSp372->LaufSp
    LaufSp
    rotate <0.0, 0.0, -24.0>
    translate  <0.0, 0.0, 86.799876>
  }
  object { // LaufSp373->LaufSp
    LaufSp
    rotate <0.0, 0.0, -26.0>
    translate  <0.0, 0.0, 87.033209>
  }
  object { // LaufSp374->LaufSp
    LaufSp
    rotate <0.0, 0.0, -28.0>
    translate  <0.0, 0.0, 87.266542>
  }
  object { // LaufSp375->LaufSp
    LaufSp
    rotate <0.0, 0.0, -30.0>
    translate  <0.0, 0.0, 87.499875>
  }
  object { // LaufSp376->LaufSp
    LaufSp
    rotate <0.0, 0.0, -32.0>
    translate  <0.0, 0.0, 87.733208>
  }
  object { // LaufSp377->LaufSp
    LaufSp
    rotate <0.0, 0.0, -34.0>
    translate  <0.0, 0.0, 87.966541>
  }
  object { // LaufSp378->LaufSp
    LaufSp
    rotate <0.0, 0.0, -36.0>
    translate  <0.0, 0.0, 88.199874>
  }
  object { // LaufSp379->LaufSp
    LaufSp
    rotate <0.0, 0.0, -38.0>
    translate  <0.0, 0.0, 88.433207>
  }
  object { // LaufSp380->LaufSp
    LaufSp
    rotate <0.0, 0.0, -40.0>
    translate  <0.0, 0.0, 88.66654>
  }
  object { // LaufSp381->LaufSp
    LaufSp
    rotate <0.0, 0.0, -42.0>
    translate  <0.0, 0.0, 88.899873>
  }
  object { // LaufSp382->LaufSp
    LaufSp
    rotate <0.0, 0.0, -44.0>
    translate  <0.0, 0.0, 89.133206>
  }
  object { // LaufSp383->LaufSp
    LaufSp
    rotate <0.0, 0.0, -46.0>
    translate  <0.0, 0.0, 89.366539>
  }
  object { // LaufSp384->LaufSp
    LaufSp
    rotate <0.0, 0.0, -48.0>
    translate  <0.0, 0.0, 89.599872>
  }
  object { // LaufSp385->LaufSp
    LaufSp
    rotate <0.0, 0.0, -50.0>
    translate  <0.0, 0.0, 89.833205>
  }
  object { // LaufSp386->LaufSp
    LaufSp
    rotate <0.0, 0.0, -52.0>
    translate  <0.0, 0.0, 90.066538>
  }
  object { // LaufSp387->LaufSp
    LaufSp
    rotate <0.0, 0.0, -54.0>
    translate  <0.0, 0.0, 90.299871>
  }
  object { // LaufSp388->LaufSp
    LaufSp
    rotate <0.0, 0.0, -56.0>
    translate  <0.0, 0.0, 90.533204>
  }
  object { // LaufSp389->LaufSp
    LaufSp
    rotate <0.0, 0.0, -58.0>
    translate  <0.0, 0.0, 90.766537>
  }
  object { // LaufSp390->LaufSp
    LaufSp
    rotate <0.0, 0.0, -60.0>
    translate  <0.0, 0.0, 90.99987>
  }
  object { // LaufSp391->LaufSp
    LaufSp
    rotate <0.0, 0.0, -62.0>
    translate  <0.0, 0.0, 91.233203>
  }
  object { // LaufSp392->LaufSp
    LaufSp
    rotate <0.0, 0.0, -64.0>
    translate  <0.0, 0.0, 91.466536>
  }
  object { // LaufSp393->LaufSp
    LaufSp
    rotate <0.0, 0.0, -66.0>
    translate  <0.0, 0.0, 91.699869>
  }
  object { // LaufSp394->LaufSp
    LaufSp
    rotate <0.0, 0.0, -68.0>
    translate  <0.0, 0.0, 91.933202>
  }
  object { // LaufSp395->LaufSp
    LaufSp
    rotate <0.0, 0.0, -70.0>
    translate  <0.0, 0.0, 92.166535>
  }
  object { // LaufSp396->LaufSp
    LaufSp
    rotate <0.0, 0.0, -72.0>
    translate  <0.0, 0.0, 92.399868>
  }
  object { // LaufSp397->LaufSp
    LaufSp
    rotate <0.0, 0.0, -74.0>
    translate  <0.0, 0.0, 92.633201>
  }
  object { // LaufSp398->LaufSp
    LaufSp
    rotate <0.0, 0.0, -76.0>
    translate  <0.0, 0.0, 92.866534>
  }
  object { // LaufSp399->LaufSp
    LaufSp
    rotate <0.0, 0.0, -78.0>
    translate  <0.0, 0.0, 93.099867>
  }
  object { // LaufSp400->LaufSp
    LaufSp
    rotate <0.0, 0.0, -80.0>
    translate  <0.0, 0.0, 93.3332>
  }
  object { // LaufSp401->LaufSp
    LaufSp
    rotate <0.0, 0.0, -82.0>
    translate  <0.0, 0.0, 93.566533>
  }
  object { // LaufSp402->LaufSp
    LaufSp
    rotate <0.0, 0.0, -84.0>
    translate  <0.0, 0.0, 93.799866>
  }
  object { // LaufSp403->LaufSp
    LaufSp
    rotate <0.0, 0.0, -86.0>
    translate  <0.0, 0.0, 94.033199>
  }
  object { // LaufSp404->LaufSp
    LaufSp
    rotate <0.0, 0.0, -88.0>
    translate  <0.0, 0.0, 94.266532>
  }
  object { // LaufSp405->LaufSp
    LaufSp
    rotate <0.0, 0.0, -90.0>
    translate  <0.0, 0.0, 94.499865>
  }
  object { // LaufSp406->LaufSp
    LaufSp
    rotate <0.0, 0.0, -92.0>
    translate  <0.0, 0.0, 94.733198>
  }
  object { // LaufSp407->LaufSp
    LaufSp
    rotate <0.0, 0.0, -94.0>
    translate  <0.0, 0.0, 94.966531>
  }
  object { // LaufSp408->LaufSp
    LaufSp
    rotate <0.0, 0.0, -96.0>
    translate  <0.0, 0.0, 95.199864>
  }
  object { // LaufSp409->LaufSp
    LaufSp
    rotate <0.0, 0.0, -98.0>
    translate  <0.0, 0.0, 95.433197>
  }
  object { // LaufSp410->LaufSp
    LaufSp
    rotate <0.0, 0.0, -100.0>
    translate  <0.0, 0.0, 95.66653>
  }
  object { // LaufSp411->LaufSp
    LaufSp
    rotate <0.0, 0.0, -102.0>
    translate  <0.0, 0.0, 95.899863>
  }
  object { // LaufSp412->LaufSp
    LaufSp
    rotate <0.0, 0.0, -104.0>
    translate  <0.0, 0.0, 96.133196>
  }
  object { // LaufSp413->LaufSp
    LaufSp
    rotate <0.0, 0.0, -106.0>
    translate  <0.0, 0.0, 96.366529>
  }
  object { // LaufSp414->LaufSp
    LaufSp
    rotate <0.0, 0.0, -108.0>
    translate  <0.0, 0.0, 96.599862>
  }
  object { // LaufSp415->LaufSp
    LaufSp
    rotate <0.0, 0.0, -110.0>
    translate  <0.0, 0.0, 96.833195>
  }
  object { // LaufSp416->LaufSp
    LaufSp
    rotate <0.0, 0.0, -112.0>
    translate  <0.0, 0.0, 97.066528>
  }
  object { // LaufSp417->LaufSp
    LaufSp
    rotate <0.0, 0.0, -114.0>
    translate  <0.0, 0.0, 97.299861>
  }
  object { // LaufSp418->LaufSp
    LaufSp
    rotate <0.0, 0.0, -116.0>
    translate  <0.0, 0.0, 97.533194>
  }
  object { // LaufSp419->LaufSp
    LaufSp
    rotate <0.0, 0.0, -118.0>
    translate  <0.0, 0.0, 97.766527>
  }
  object { // LaufSp420->LaufSp
    LaufSp
    rotate <0.0, 0.0, -120.0>
    translate  <0.0, 0.0, 97.99986>
  }
  object { // LaufSp421->LaufSp
    LaufSp
    rotate <0.0, 0.0, -122.0>
    translate  <0.0, 0.0, 98.233193>
  }
  object { // LaufSp422->LaufSp
    LaufSp
    rotate <0.0, 0.0, -124.0>
    translate  <0.0, 0.0, 98.466526>
  }
  object { // LaufSp423->LaufSp
    LaufSp
    rotate <0.0, 0.0, -126.0>
    translate  <0.0, 0.0, 98.699859>
  }
  object { // LaufSp424->LaufSp
    LaufSp
    rotate <0.0, 0.0, -128.0>
    translate  <0.0, 0.0, 98.933192>
  }
  object { // LaufSp425->LaufSp
    LaufSp
    rotate <0.0, 0.0, -130.0>
    translate  <0.0, 0.0, 99.166525>
  }
  object { // LaufSp426->LaufSp
    LaufSp
    rotate <0.0, 0.0, -132.0>
    translate  <0.0, 0.0, 99.399858>
  }
  object { // LaufSp427->LaufSp
    LaufSp
    rotate <0.0, 0.0, -134.0>
    translate  <0.0, 0.0, 99.633191>
  }
  object { // LaufSp428->LaufSp
    LaufSp
    rotate <0.0, 0.0, -136.0>
    translate  <0.0, 0.0, 99.866524>
  }
  object { // LaufSp429->LaufSp
    LaufSp
    rotate <0.0, 0.0, -138.0>
    translate  <0.0, 0.0, 100.099857>
  }
  object { // LaufSp430->LaufSp
    LaufSp
    rotate <0.0, 0.0, -140.0>
    translate  <0.0, 0.0, 100.33319>
  }
  object { // LaufSp431->LaufSp
    LaufSp
    rotate <0.0, 0.0, -142.0>
    translate  <0.0, 0.0, 100.566523>
  }
  object { // LaufSp432->LaufSp
    LaufSp
    rotate <0.0, 0.0, -144.0>
    translate  <0.0, 0.0, 100.799856>
  }
  object { // LaufSp433->LaufSp
    LaufSp
    rotate <0.0, 0.0, -146.0>
    translate  <0.0, 0.0, 101.033189>
  }
  object { // LaufSp434->LaufSp
    LaufSp
    rotate <0.0, 0.0, -148.0>
    translate  <0.0, 0.0, 101.266522>
  }
  object { // LaufSp435->LaufSp
    LaufSp
    rotate <0.0, 0.0, -150.0>
    translate  <0.0, 0.0, 101.499855>
  }
  object { // LaufSp436->LaufSp
    LaufSp
    rotate <0.0, 0.0, -152.0>
    translate  <0.0, 0.0, 101.733188>
  }
  object { // LaufSp437->LaufSp
    LaufSp
    rotate <0.0, 0.0, -154.0>
    translate  <0.0, 0.0, 101.966521>
  }
  object { // LaufSp438->LaufSp
    LaufSp
    rotate <0.0, 0.0, -156.0>
    translate  <0.0, 0.0, 102.199854>
  }
  object { // LaufSp439->LaufSp
    LaufSp
    rotate <0.0, 0.0, -158.0>
    translate  <0.0, 0.0, 102.433187>
  }
  object { // LaufSp440->LaufSp
    LaufSp
    rotate <0.0, 0.0, -160.0>
    translate  <0.0, 0.0, 102.66652>
  }
  object { // LaufSp441->LaufSp
    LaufSp
    rotate <0.0, 0.0, -162.0>
    translate  <0.0, 0.0, 102.899853>
  }
  object { // LaufSp442->LaufSp
    LaufSp
    rotate <0.0, 0.0, -164.0>
    translate  <0.0, 0.0, 103.133186>
  }
  object { // LaufSp443->LaufSp
    LaufSp
    rotate <0.0, 0.0, -166.0>
    translate  <0.0, 0.0, 103.366519>
  }
  object { // LaufSp444->LaufSp
    LaufSp
    rotate <0.0, 0.0, -168.0>
    translate  <0.0, 0.0, 103.599852>
  }
  object { // LaufSp445->LaufSp
    LaufSp
    rotate <0.0, 0.0, -170.0>
    translate  <0.0, 0.0, 103.833185>
  }
  object { // LaufSp446->LaufSp
    LaufSp
    rotate <0.0, 0.0, -172.0>
    translate  <0.0, 0.0, 104.066518>
  }
  object { // LaufSp447->LaufSp
    LaufSp
    rotate <0.0, 0.0, -174.0>
    translate  <0.0, 0.0, 104.299851>
  }
  object { // LaufSp448->LaufSp
    LaufSp
    rotate <0.0, 0.0, -176.0>
    translate  <0.0, 0.0, 104.533184>
  }
  object { // LaufSp449->LaufSp
    LaufSp
    rotate <0.0, 0.0, -178.0>
    translate  <0.0, 0.0, 104.766517>
  }
  object { // LaufSp450->LaufSp
    LaufSp
    rotate <0.0, 0.0, 180.0>
    translate  <0.0, 0.0, 104.99985>
  }
  object { // LaufSp451->LaufSp
    LaufSp
    rotate <0.0, 0.0, 178.0>
    translate  <0.0, 0.0, 105.233183>
  }
  object { // LaufSp452->LaufSp
    LaufSp
    rotate <0.0, 0.0, 176.0>
    translate  <0.0, 0.0, 105.466516>
  }
  object { // LaufSp453->LaufSp
    LaufSp
    rotate <0.0, 0.0, 174.0>
    translate  <0.0, 0.0, 105.699849>
  }
  object { // LaufSp454->LaufSp
    LaufSp
    rotate <0.0, 0.0, 172.0>
    translate  <0.0, 0.0, 105.933182>
  }
  object { // LaufSp455->LaufSp
    LaufSp
    rotate <0.0, 0.0, 170.0>
    translate  <0.0, 0.0, 106.166515>
  }
  object { // LaufSp456->LaufSp
    LaufSp
    rotate <0.0, 0.0, 168.0>
    translate  <0.0, 0.0, 106.399848>
  }
  object { // LaufSp457->LaufSp
    LaufSp
    rotate <0.0, 0.0, 166.0>
    translate  <0.0, 0.0, 106.633181>
  }
  object { // LaufSp458->LaufSp
    LaufSp
    rotate <0.0, 0.0, 164.0>
    translate  <0.0, 0.0, 106.866514>
  }
  object { // LaufSp459->LaufSp
    LaufSp
    rotate <0.0, 0.0, 162.0>
    translate  <0.0, 0.0, 107.099847>
  }
  object { // LaufSp460->LaufSp
    LaufSp
    rotate <0.0, 0.0, 160.0>
    translate  <0.0, 0.0, 107.33318>
  }
  object { // LaufSp461->LaufSp
    LaufSp
    rotate <0.0, 0.0, 158.0>
    translate  <0.0, 0.0, 107.566513>
  }
  object { // LaufSp462->LaufSp
    LaufSp
    rotate <0.0, 0.0, 156.0>
    translate  <0.0, 0.0, 107.799846>
  }
  object { // LaufSp463->LaufSp
    LaufSp
    rotate <0.0, 0.0, 154.0>
    translate  <0.0, 0.0, 108.033179>
  }
  object { // LaufSp464->LaufSp
    LaufSp
    rotate <0.0, 0.0, 152.0>
    translate  <0.0, 0.0, 108.266512>
  }
  object { // LaufSp465->LaufSp
    LaufSp
    rotate <0.0, 0.0, 150.0>
    translate  <0.0, 0.0, 108.499845>
  }
  object { // LaufSp466->LaufSp
    LaufSp
    rotate <0.0, 0.0, 148.0>
    translate  <0.0, 0.0, 108.733178>
  }
  object { // LaufSp467->LaufSp
    LaufSp
    rotate <0.0, 0.0, 146.0>
    translate  <0.0, 0.0, 108.966511>
  }
  object { // LaufSp468->LaufSp
    LaufSp
    rotate <0.0, 0.0, 144.0>
    translate  <0.0, 0.0, 109.199844>
  }
  object { // LaufSp469->LaufSp
    LaufSp
    rotate <0.0, 0.0, 142.0>
    translate  <0.0, 0.0, 109.433177>
  }
  object { // LaufSp470->LaufSp
    LaufSp
    rotate <0.0, 0.0, 140.0>
    translate  <0.0, 0.0, 109.66651>
  }
  object { // LaufSp471->LaufSp
    LaufSp
    rotate <0.0, 0.0, 138.0>
    translate  <0.0, 0.0, 109.899843>
  }
  object { // LaufSp472->LaufSp
    LaufSp
    rotate <0.0, 0.0, 136.0>
    translate  <0.0, 0.0, 110.133176>
  }
  object { // LaufSp473->LaufSp
    LaufSp
    rotate <0.0, 0.0, 134.0>
    translate  <0.0, 0.0, 110.366509>
  }
  object { // LaufSp474->LaufSp
    LaufSp
    rotate <0.0, 0.0, 132.0>
    translate  <0.0, 0.0, 110.599842>
  }
  object { // LaufSp475->LaufSp
    LaufSp
    rotate <0.0, 0.0, 130.0>
    translate  <0.0, 0.0, 110.833175>
  }
  object { // LaufSp476->LaufSp
    LaufSp
    rotate <0.0, 0.0, 128.0>
    translate  <0.0, 0.0, 111.066508>
  }
  object { // LaufSp477->LaufSp
    LaufSp
    rotate <0.0, 0.0, 126.0>
    translate  <0.0, 0.0, 111.299841>
  }
  object { // LaufSp478->LaufSp
    LaufSp
    rotate <0.0, 0.0, 124.0>
    translate  <0.0, 0.0, 111.533174>
  }
  object { // LaufSp479->LaufSp
    LaufSp
    rotate <0.0, 0.0, 122.0>
    translate  <0.0, 0.0, 111.766507>
  }
  object { // LaufSp480->LaufSp
    LaufSp
    rotate <0.0, 0.0, 120.0>
    translate  <0.0, 0.0, 111.99984>
  }
  object { // LaufSp481->LaufSp
    LaufSp
    rotate <0.0, 0.0, 118.0>
    translate  <0.0, 0.0, 112.233173>
  }
  object { // LaufSp482->LaufSp
    LaufSp
    rotate <0.0, 0.0, 116.0>
    translate  <0.0, 0.0, 112.466506>
  }
  object { // LaufSp483->LaufSp
    LaufSp
    rotate <0.0, 0.0, 114.0>
    translate  <0.0, 0.0, 112.699839>
  }
  object { // LaufSp484->LaufSp
    LaufSp
    rotate <0.0, 0.0, 112.0>
    translate  <0.0, 0.0, 112.933172>
  }
  object { // LaufSp485->LaufSp
    LaufSp
    rotate <0.0, 0.0, 110.0>
    translate  <0.0, 0.0, 113.166505>
  }
  object { // LaufSp486->LaufSp
    LaufSp
    rotate <0.0, 0.0, 108.0>
    translate  <0.0, 0.0, 113.399838>
  }
  object { // LaufSp487->LaufSp
    LaufSp
    rotate <0.0, 0.0, 106.0>
    translate  <0.0, 0.0, 113.633171>
  }
  object { // LaufSp488->LaufSp
    LaufSp
    rotate <0.0, 0.0, 104.0>
    translate  <0.0, 0.0, 113.866504>
  }
  object { // LaufSp489->LaufSp
    LaufSp
    rotate <0.0, 0.0, 102.0>
    translate  <0.0, 0.0, 114.099837>
  }
  object { // LaufSp490->LaufSp
    LaufSp
    rotate <0.0, 0.0, 100.0>
    translate  <0.0, 0.0, 114.33317>
  }
  object { // LaufSp491->LaufSp
    LaufSp
    rotate <0.0, 0.0, 98.0>
    translate  <0.0, 0.0, 114.566503>
  }
  object { // LaufSp492->LaufSp
    LaufSp
    rotate <0.0, 0.0, 96.0>
    translate  <0.0, 0.0, 114.799836>
  }
  object { // LaufSp493->LaufSp
    LaufSp
    rotate <0.0, 0.0, 94.0>
    translate  <0.0, 0.0, 115.033169>
  }
  object { // LaufSp494->LaufSp
    LaufSp
    rotate <0.0, 0.0, 92.0>
    translate  <0.0, 0.0, 115.266502>
  }
  object { // LaufSp495->LaufSp
    LaufSp
    rotate <0.0, 0.0, 90.0>
    translate  <0.0, 0.0, 115.499835>
  }
  object { // LaufSp496->LaufSp
    LaufSp
    rotate <0.0, 0.0, 88.0>
    translate  <0.0, 0.0, 115.733168>
  }
  object { // LaufSp497->LaufSp
    LaufSp
    rotate <0.0, 0.0, 86.0>
    translate  <0.0, 0.0, 115.966501>
  }
  object { // LaufSp498->LaufSp
    LaufSp
    rotate <0.0, 0.0, 84.0>
    translate  <0.0, 0.0, 116.199834>
  }
  object { // LaufSp499->LaufSp
    LaufSp
    rotate <0.0, 0.0, 82.0>
    translate  <0.0, 0.0, 116.433167>
  }
  object { // LaufSp500->LaufSp
    LaufSp
    rotate <0.0, 0.0, 80.0>
    translate  <0.0, 0.0, 116.6665>
  }
  object { // LaufSp501->LaufSp
    LaufSp
    rotate <0.0, 0.0, 78.0>
    translate  <0.0, 0.0, 116.899833>
  }
  object { // LaufSp502->LaufSp
    LaufSp
    rotate <0.0, 0.0, 76.0>
    translate  <0.0, 0.0, 117.133166>
  }
  object { // LaufSp503->LaufSp
    LaufSp
    rotate <0.0, 0.0, 74.0>
    translate  <0.0, 0.0, 117.366499>
  }
  object { // LaufSp504->LaufSp
    LaufSp
    rotate <0.0, 0.0, 72.0>
    translate  <0.0, 0.0, 117.599832>
  }
  object { // LaufSp505->LaufSp
    LaufSp
    rotate <0.0, 0.0, 70.0>
    translate  <0.0, 0.0, 117.833165>
  }
  object { // LaufSp506->LaufSp
    LaufSp
    rotate <0.0, 0.0, 68.0>
    translate  <0.0, 0.0, 118.066498>
  }
  object { // LaufSp507->LaufSp
    LaufSp
    rotate <0.0, 0.0, 66.0>
    translate  <0.0, 0.0, 118.299831>
  }
  object { // LaufSp508->LaufSp
    LaufSp
    rotate <0.0, 0.0, 64.0>
    translate  <0.0, 0.0, 118.533164>
  }
  object { // LaufSp509->LaufSp
    LaufSp
    rotate <0.0, 0.0, 62.0>
    translate  <0.0, 0.0, 118.766497>
  }
  object { // LaufSp510->LaufSp
    LaufSp
    rotate <0.0, 0.0, 60.0>
    translate  <0.0, 0.0, 118.99983>
  }
  object { // LaufSp511->LaufSp
    LaufSp
    rotate <0.0, 0.0, 58.0>
    translate  <0.0, 0.0, 119.233163>
  }
  object { // LaufSp512->LaufSp
    LaufSp
    rotate <0.0, 0.0, 56.0>
    translate  <0.0, 0.0, 119.466496>
  }
  object { // LaufSp513->LaufSp
    LaufSp
    rotate <0.0, 0.0, 54.0>
    translate  <0.0, 0.0, 119.699829>
  }
  object { // LaufSp514->LaufSp
    LaufSp
    rotate <0.0, 0.0, 52.0>
    translate  <0.0, 0.0, 119.933162>
  }
  object { // LaufSp515->LaufSp
    LaufSp
    rotate <0.0, 0.0, 50.0>
    translate  <0.0, 0.0, 120.166495>
  }
  object { // LaufSp516->LaufSp
    LaufSp
    rotate <0.0, 0.0, 48.0>
    translate  <0.0, 0.0, 120.399828>
  }
  object { // LaufSp517->LaufSp
    LaufSp
    rotate <0.0, 0.0, 46.0>
    translate  <0.0, 0.0, 120.633161>
  }
  object { // LaufSp518->LaufSp
    LaufSp
    rotate <0.0, 0.0, 44.0>
    translate  <0.0, 0.0, 120.866494>
  }
  object { // LaufSp519->LaufSp
    LaufSp
    rotate <0.0, 0.0, 42.0>
    translate  <0.0, 0.0, 121.099827>
  }
  object { // LaufSp520->LaufSp
    LaufSp
    rotate <0.0, 0.0, 40.0>
    translate  <0.0, 0.0, 121.33316>
  }
  object { // LaufSp521->LaufSp
    LaufSp
    rotate <0.0, 0.0, 38.0>
    translate  <0.0, 0.0, 121.566493>
  }
  object { // LaufSp522->LaufSp
    LaufSp
    rotate <0.0, 0.0, 36.0>
    translate  <0.0, 0.0, 121.799826>
  }
  object { // LaufSp523->LaufSp
    LaufSp
    rotate <0.0, 0.0, 34.0>
    translate  <0.0, 0.0, 122.033159>
  }
  object { // LaufSp524->LaufSp
    LaufSp
    rotate <0.0, 0.0, 32.0>
    translate  <0.0, 0.0, 122.266492>
  }
  object { // LaufSp525->LaufSp
    LaufSp
    rotate <0.0, 0.0, 30.0>
    translate  <0.0, 0.0, 122.499825>
  }
  object { // LaufSp526->LaufSp
    LaufSp
    rotate <0.0, 0.0, 28.0>
    translate  <0.0, 0.0, 122.733158>
  }
  object { // LaufSp527->LaufSp
    LaufSp
    rotate <0.0, 0.0, 26.0>
    translate  <0.0, 0.0, 122.966491>
  }
  object { // LaufSp528->LaufSp
    LaufSp
    rotate <0.0, 0.0, 24.0>
    translate  <0.0, 0.0, 123.199824>
  }
  object { // LaufSp529->LaufSp
    LaufSp
    rotate <0.0, 0.0, 22.0>
    translate  <0.0, 0.0, 123.433157>
  }
  object { // LaufSp530->LaufSp
    LaufSp
    rotate <0.0, 0.0, 20.0>
    translate  <0.0, 0.0, 123.66649>
  }
  object { // LaufSp531->LaufSp
    LaufSp
    rotate <0.0, 0.0, 18.0>
    translate  <0.0, 0.0, 123.899823>
  }
  object { // LaufSp532->LaufSp
    LaufSp
    rotate <0.0, 0.0, 16.0>
    translate  <0.0, 0.0, 124.133156>
  }
  object { // LaufSp533->LaufSp
    LaufSp
    rotate <0.0, 0.0, 14.0>
    translate  <0.0, 0.0, 124.366489>
  }
  object { // LaufSp534->LaufSp
    LaufSp
    rotate <0.0, 0.0, 12.0>
    translate  <0.0, 0.0, 124.599822>
  }
  object { // LaufSp535->LaufSp
    LaufSp
    rotate <0.0, 0.0, 10.0>
    translate  <0.0, 0.0, 124.833155>
  }
  object { // LaufSp536->LaufSp
    LaufSp
    rotate <0.0, 0.0, 8.0>
    translate  <0.0, 0.0, 125.066488>
  }
  object { // LaufSp537->LaufSp
    LaufSp
    rotate <0.0, 0.0, 6.0>
    translate  <0.0, 0.0, 125.299821>
  }
  object { // LaufSp538->LaufSp
    LaufSp
    rotate <0.0, 0.0, 4.0>
    translate  <0.0, 0.0, 125.533154>
  }
  object { // LaufSp539->LaufSp
    LaufSp
    rotate <0.0, 0.0, 2.0>
    translate  <0.0, 0.0, 125.766487>
  }
  object { // LaufSp540->LaufSp
    LaufSp
    rotate <0.0, 0.0, 0.0>
    translate  <0.0, 0.0, 125.99982>
  }
  object { // LaufSp541->LaufSp
    LaufSp
    rotate <0.0, 0.0, -2.0>
    translate  <0.0, 0.0, 126.233153>
  }
  object { // LaufSp542->LaufSp
    LaufSp
    rotate <0.0, 0.0, -4.0>
    translate  <0.0, 0.0, 126.466486>
  }
  object { // LaufSp543->LaufSp
    LaufSp
    rotate <0.0, 0.0, -6.0>
    translate  <0.0, 0.0, 126.699819>
  }
  object { // LaufSp544->LaufSp
    LaufSp
    rotate <0.0, 0.0, -8.0>
    translate  <0.0, 0.0, 126.933152>
  }
  object { // LaufSp545->LaufSp
    LaufSp
    rotate <0.0, 0.0, -10.0>
    translate  <0.0, 0.0, 127.166485>
  }
  object { // LaufSp546->LaufSp
    LaufSp
    rotate <0.0, 0.0, -12.0>
    translate  <0.0, 0.0, 127.399818>
  }
  object { // LaufSp547->LaufSp
    LaufSp
    rotate <0.0, 0.0, -14.0>
    translate  <0.0, 0.0, 127.633151>
  }
  object { // LaufSp548->LaufSp
    LaufSp
    rotate <0.0, 0.0, -16.0>
    translate  <0.0, 0.0, 127.866484>
  }
  object { // LaufSp549->LaufSp
    LaufSp
    rotate <0.0, 0.0, -18.0>
    translate  <0.0, 0.0, 128.099817>
  }
  object { // LaufSp550->LaufSp
    LaufSp
    rotate <0.0, 0.0, -20.0>
    translate  <0.0, 0.0, 128.33315>
  }
  object { // LaufSp551->LaufSp
    LaufSp
    rotate <0.0, 0.0, -22.0>
    translate  <0.0, 0.0, 128.566483>
  }
  object { // LaufSp552->LaufSp
    LaufSp
    rotate <0.0, 0.0, -24.0>
    translate  <0.0, 0.0, 128.799816>
  }
  object { // LaufSp553->LaufSp
    LaufSp
    rotate <0.0, 0.0, -26.0>
    translate  <0.0, 0.0, 129.033149>
  }
  object { // LaufSp554->LaufSp
    LaufSp
    rotate <0.0, 0.0, -28.0>
    translate  <0.0, 0.0, 129.266482>
  }
  object { // LaufSp555->LaufSp
    LaufSp
    rotate <0.0, 0.0, -30.0>
    translate  <0.0, 0.0, 129.499815>
  }
  object { // LaufSp556->LaufSp
    LaufSp
    rotate <0.0, 0.0, -32.0>
    translate  <0.0, 0.0, 129.733148>
  }
  object { // LaufSp557->LaufSp
    LaufSp
    rotate <0.0, 0.0, -34.0>
    translate  <0.0, 0.0, 129.966481>
  }
  object { // LaufSp558->LaufSp
    LaufSp
    rotate <0.0, 0.0, -36.0>
    translate  <0.0, 0.0, 130.199814>
  }
  object { // LaufSp559->LaufSp
    LaufSp
    rotate <0.0, 0.0, -38.0>
    translate  <0.0, 0.0, 130.433147>
  }
  object { // LaufSp560->LaufSp
    LaufSp
    rotate <0.0, 0.0, -40.0>
    translate  <0.0, 0.0, 130.66648>
  }
  object { // LaufSp561->LaufSp
    LaufSp
    rotate <0.0, 0.0, -42.0>
    translate  <0.0, 0.0, 130.899813>
  }
  object { // LaufSp562->LaufSp
    LaufSp
    rotate <0.0, 0.0, -44.0>
    translate  <0.0, 0.0, 131.133146>
  }
  object { // LaufSp563->LaufSp
    LaufSp
    rotate <0.0, 0.0, -46.0>
    translate  <0.0, 0.0, 131.366479>
  }
  object { // LaufSp564->LaufSp
    LaufSp
    rotate <0.0, 0.0, -48.0>
    translate  <0.0, 0.0, 131.599812>
  }
  object { // LaufSp565->LaufSp
    LaufSp
    rotate <0.0, 0.0, -50.0>
    translate  <0.0, 0.0, 131.833145>
  }
  object { // LaufSp566->LaufSp
    LaufSp
    rotate <0.0, 0.0, -52.0>
    translate  <0.0, 0.0, 132.066478>
  }
  object { // LaufSp567->LaufSp
    LaufSp
    rotate <0.0, 0.0, -54.0>
    translate  <0.0, 0.0, 132.299811>
  }
  object { // LaufSp568->LaufSp
    LaufSp
    rotate <0.0, 0.0, -56.0>
    translate  <0.0, 0.0, 132.533144>
  }
  object { // LaufSp569->LaufSp
    LaufSp
    rotate <0.0, 0.0, -58.0>
    translate  <0.0, 0.0, 132.766477>
  }
  object { // LaufSp570->LaufSp
    LaufSp
    rotate <0.0, 0.0, -60.0>
    translate  <0.0, 0.0, 132.99981>
  }
  object { // LaufSp571->LaufSp
    LaufSp
    rotate <0.0, 0.0, -62.0>
    translate  <0.0, 0.0, 133.233143>
  }
  object { // LaufSp572->LaufSp
    LaufSp
    rotate <0.0, 0.0, -64.0>
    translate  <0.0, 0.0, 133.466476>
  }
  object { // LaufSp573->LaufSp
    LaufSp
    rotate <0.0, 0.0, -66.0>
    translate  <0.0, 0.0, 133.699809>
  }
  object { // LaufSp574->LaufSp
    LaufSp
    rotate <0.0, 0.0, -68.0>
    translate  <0.0, 0.0, 133.933142>
  }
  object { // LaufSp575->LaufSp
    LaufSp
    rotate <0.0, 0.0, -70.0>
    translate  <0.0, 0.0, 134.166475>
  }
  object { // LaufSp576->LaufSp
    LaufSp
    rotate <0.0, 0.0, -72.0>
    translate  <0.0, 0.0, 134.399808>
  }
  object { // LaufSp577->LaufSp
    LaufSp
    rotate <0.0, 0.0, -74.0>
    translate  <0.0, 0.0, 134.633141>
  }
  object { // LaufSp578->LaufSp
    LaufSp
    rotate <0.0, 0.0, -76.0>
    translate  <0.0, 0.0, 134.866474>
  }
  object { // LaufSp579->LaufSp
    LaufSp
    rotate <0.0, 0.0, -78.0>
    translate  <0.0, 0.0, 135.099807>
  }
  object { // LaufSp580->LaufSp
    LaufSp
    rotate <0.0, 0.0, -80.0>
    translate  <0.0, 0.0, 135.33314>
  }
  object { // LaufSp581->LaufSp
    LaufSp
    rotate <0.0, 0.0, -82.0>
    translate  <0.0, 0.0, 135.566473>
  }
  object { // LaufSp582->LaufSp
    LaufSp
    rotate <0.0, 0.0, -84.0>
    translate  <0.0, 0.0, 135.799806>
  }
  object { // LaufSp583->LaufSp
    LaufSp
    rotate <0.0, 0.0, -86.0>
    translate  <0.0, 0.0, 136.033139>
  }
  object { // LaufSp584->LaufSp
    LaufSp
    rotate <0.0, 0.0, -88.0>
    translate  <0.0, 0.0, 136.266472>
  }
  object { // LaufSp585->LaufSp
    LaufSp
    rotate <0.0, 0.0, -90.0>
    translate  <0.0, 0.0, 136.499805>
  }
  object { // LaufSp586->LaufSp
    LaufSp
    rotate <0.0, 0.0, -92.0>
    translate  <0.0, 0.0, 136.733138>
  }
  object { // LaufSp587->LaufSp
    LaufSp
    rotate <0.0, 0.0, -94.0>
    translate  <0.0, 0.0, 136.966471>
  }
  object { // LaufSp588->LaufSp
    LaufSp
    rotate <0.0, 0.0, -96.0>
    translate  <0.0, 0.0, 137.199804>
  }
  object { // LaufSp589->LaufSp
    LaufSp
    rotate <0.0, 0.0, -98.0>
    translate  <0.0, 0.0, 137.433137>
  }
  object { // LaufSp590->LaufSp
    LaufSp
    rotate <0.0, 0.0, -100.0>
    translate  <0.0, 0.0, 137.66647>
  }
  object { // LaufSp591->LaufSp
    LaufSp
    rotate <0.0, 0.0, -102.0>
    translate  <0.0, 0.0, 137.899803>
  }
  object { // LaufSp592->LaufSp
    LaufSp
    rotate <0.0, 0.0, -104.0>
    translate  <0.0, 0.0, 138.133136>
  }
  object { // LaufSp593->LaufSp
    LaufSp
    rotate <0.0, 0.0, -106.0>
    translate  <0.0, 0.0, 138.366469>
  }
  object { // LaufSp594->LaufSp
    LaufSp
    rotate <0.0, 0.0, -108.0>
    translate  <0.0, 0.0, 138.599802>
  }
  object { // LaufSp595->LaufSp
    LaufSp
    rotate <0.0, 0.0, -110.0>
    translate  <0.0, 0.0, 138.833135>
  }
  object { // LaufSp596->LaufSp
    LaufSp
    rotate <0.0, 0.0, -112.0>
    translate  <0.0, 0.0, 139.066468>
  }
  object { // LaufSp597->LaufSp
    LaufSp
    rotate <0.0, 0.0, -114.0>
    translate  <0.0, 0.0, 139.299801>
  }
  object { // LaufSp598->LaufSp
    LaufSp
    rotate <0.0, 0.0, -116.0>
    translate  <0.0, 0.0, 139.533134>
  }
  object { // LaufSp599->LaufSp
    LaufSp
    rotate <0.0, 0.0, -118.0>
    translate  <0.0, 0.0, 139.766467>
  }
  object { // LaufSp600->LaufSp
    LaufSp
    rotate <0.0, 0.0, -120.0>
    translate  <0.0, 0.0, 139.9998>
  }
  object { // LaufSp601->LaufSp
    LaufSp
    rotate <0.0, 0.0, -122.0>
    translate  <0.0, 0.0, 140.233133>
  }
  object { // LaufSp602->LaufSp
    LaufSp
    rotate <0.0, 0.0, -124.0>
    translate  <0.0, 0.0, 140.466466>
  }
  object { // LaufSp603->LaufSp
    LaufSp
    rotate <0.0, 0.0, -126.0>
    translate  <0.0, 0.0, 140.699799>
  }
  object { // LaufSp604->LaufSp
    LaufSp
    rotate <0.0, 0.0, -128.0>
    translate  <0.0, 0.0, 140.933132>
  }
  object { // LaufSp605->LaufSp
    LaufSp
    rotate <0.0, 0.0, -130.0>
    translate  <0.0, 0.0, 141.166465>
  }
  object { // LaufSp606->LaufSp
    LaufSp
    rotate <0.0, 0.0, -132.0>
    translate  <0.0, 0.0, 141.399798>
  }
  object { // LaufSp607->LaufSp
    LaufSp
    rotate <0.0, 0.0, -134.0>
    translate  <0.0, 0.0, 141.633131>
  }
  object { // LaufSp608->LaufSp
    LaufSp
    rotate <0.0, 0.0, -136.0>
    translate  <0.0, 0.0, 141.866464>
  }
  object { // LaufSp609->LaufSp
    LaufSp
    rotate <0.0, 0.0, -138.0>
    translate  <0.0, 0.0, 142.099797>
  }
  object { // LaufSp610->LaufSp
    LaufSp
    rotate <0.0, 0.0, -140.0>
    translate  <0.0, 0.0, 142.33313>
  }
  object { // LaufSp611->LaufSp
    LaufSp
    rotate <0.0, 0.0, -142.0>
    translate  <0.0, 0.0, 142.566463>
  }
  object { // LaufSp612->LaufSp
    LaufSp
    rotate <0.0, 0.0, -144.0>
    translate  <0.0, 0.0, 142.799796>
  }
  object { // LaufSp613->LaufSp
    LaufSp
    rotate <0.0, 0.0, -146.0>
    translate  <0.0, 0.0, 143.033129>
  }
  object { // LaufSp614->LaufSp
    LaufSp
    rotate <0.0, 0.0, -148.0>
    translate  <0.0, 0.0, 143.266462>
  }
  object { // LaufSp615->LaufSp
    LaufSp
    rotate <0.0, 0.0, -150.0>
    translate  <0.0, 0.0, 143.499795>
  }
  object { // LaufSp616->LaufSp
    LaufSp
    rotate <0.0, 0.0, -152.0>
    translate  <0.0, 0.0, 143.733128>
  }
  object { // LaufSp617->LaufSp
    LaufSp
    rotate <0.0, 0.0, -154.0>
    translate  <0.0, 0.0, 143.966461>
  }
  object { // LaufSp618->LaufSp
    LaufSp
    rotate <0.0, 0.0, -156.0>
    translate  <0.0, 0.0, 144.199794>
  }
  object { // LaufSp619->LaufSp
    LaufSp
    rotate <0.0, 0.0, -158.0>
    translate  <0.0, 0.0, 144.433127>
  }
  object { // LaufSp620->LaufSp
    LaufSp
    rotate <0.0, 0.0, -160.0>
    translate  <0.0, 0.0, 144.66646>
  }
  object { // LaufSp621->LaufSp
    LaufSp
    rotate <0.0, 0.0, -162.0>
    translate  <0.0, 0.0, 144.899793>
  }
  object { // LaufSp622->LaufSp
    LaufSp
    rotate <0.0, 0.0, -164.0>
    translate  <0.0, 0.0, 145.133126>
  }
  object { // LaufSp623->LaufSp
    LaufSp
    rotate <0.0, 0.0, -166.0>
    translate  <0.0, 0.0, 145.366459>
  }
  object { // LaufSp624->LaufSp
    LaufSp
    rotate <0.0, 0.0, -168.0>
    translate  <0.0, 0.0, 145.599792>
  }
  object { // LaufSp625->LaufSp
    LaufSp
    rotate <0.0, 0.0, -170.0>
    translate  <0.0, 0.0, 145.833125>
  }
  object { // LaufSp626->LaufSp
    LaufSp
    rotate <0.0, 0.0, -172.0>
    translate  <0.0, 0.0, 146.066458>
  }
  object { // LaufSp627->LaufSp
    LaufSp
    rotate <0.0, 0.0, -174.0>
    translate  <0.0, 0.0, 146.299791>
  }
  object { // LaufSp628->LaufSp
    LaufSp
    rotate <0.0, 0.0, -176.0>
    translate  <0.0, 0.0, 146.533124>
  }
  object { // LaufSp629->LaufSp
    LaufSp
    rotate <0.0, 0.0, -178.0>
    translate  <0.0, 0.0, 146.766457>
  }
  object { // LaufSp630->LaufSp
    LaufSp
    rotate <0.0, 0.0, 180.0>
    translate  <0.0, 0.0, 146.99979>
  }
  object { // LaufSp631->LaufSp
    LaufSp
    rotate <0.0, 0.0, 178.0>
    translate  <0.0, 0.0, 147.233123>
  }
  object { // LaufSp632->LaufSp
    LaufSp
    rotate <0.0, 0.0, 176.0>
    translate  <0.0, 0.0, 147.466456>
  }
  object { // LaufSp633->LaufSp
    LaufSp
    rotate <0.0, 0.0, 174.0>
    translate  <0.0, 0.0, 147.699789>
  }
  object { // LaufSp634->LaufSp
    LaufSp
    rotate <0.0, 0.0, 172.0>
    translate  <0.0, 0.0, 147.933122>
  }
  object { // LaufSp635->LaufSp
    LaufSp
    rotate <0.0, 0.0, 170.0>
    translate  <0.0, 0.0, 148.166455>
  }
  object { // LaufSp636->LaufSp
    LaufSp
    rotate <0.0, 0.0, 168.0>
    translate  <0.0, 0.0, 148.399788>
  }
  object { // LaufSp637->LaufSp
    LaufSp
    rotate <0.0, 0.0, 166.0>
    translate  <0.0, 0.0, 148.633121>
  }
  object { // LaufSp638->LaufSp
    LaufSp
    rotate <0.0, 0.0, 164.0>
    translate  <0.0, 0.0, 148.866454>
  }
  object { // LaufSp639->LaufSp
    LaufSp
    rotate <0.0, 0.0, 162.0>
    translate  <0.0, 0.0, 149.099787>
  }
  object { // LaufSp640->LaufSp
    LaufSp
    rotate <0.0, 0.0, 160.0>
    translate  <0.0, 0.0, 149.33312>
  }
  object { // LaufSp641->LaufSp
    LaufSp
    rotate <0.0, 0.0, 158.0>
    translate  <0.0, 0.0, 149.566453>
  }
  object { // LaufSp642->LaufSp
    LaufSp
    rotate <0.0, 0.0, 156.0>
    translate  <0.0, 0.0, 149.799786>
  }
  object { // LaufSp643->LaufSp
    LaufSp
    rotate <0.0, 0.0, 154.0>
    translate  <0.0, 0.0, 150.033119>
  }
  object { // LaufSp644->LaufSp
    LaufSp
    rotate <0.0, 0.0, 152.0>
    translate  <0.0, 0.0, 150.266452>
  }
  object { // LaufSp645->LaufSp
    LaufSp
    rotate <0.0, 0.0, 150.0>
    translate  <0.0, 0.0, 150.499785>
  }
  object { // LaufSp646->LaufSp
    LaufSp
    rotate <0.0, 0.0, 148.0>
    translate  <0.0, 0.0, 150.733118>
  }
  object { // LaufSp647->LaufSp
    LaufSp
    rotate <0.0, 0.0, 146.0>
    translate  <0.0, 0.0, 150.966451>
  }
  object { // LaufSp648->LaufSp
    LaufSp
    rotate <0.0, 0.0, 144.0>
    translate  <0.0, 0.0, 151.199784>
  }
  object { // LaufSp649->LaufSp
    LaufSp
    rotate <0.0, 0.0, 142.0>
    translate  <0.0, 0.0, 151.433117>
  }
  object { // LaufSp650->LaufSp
    LaufSp
    rotate <0.0, 0.0, 140.0>
    translate  <0.0, 0.0, 151.66645>
  }
  object { // LaufSp651->LaufSp
    LaufSp
    rotate <0.0, 0.0, 138.0>
    translate  <0.0, 0.0, 151.899783>
  }
  object { // LaufSp652->LaufSp
    LaufSp
    rotate <0.0, 0.0, 136.0>
    translate  <0.0, 0.0, 152.133116>
  }
  object { // LaufSp653->LaufSp
    LaufSp
    rotate <0.0, 0.0, 134.0>
    translate  <0.0, 0.0, 152.366449>
  }
  object { // LaufSp654->LaufSp
    LaufSp
    rotate <0.0, 0.0, 132.0>
    translate  <0.0, 0.0, 152.599782>
  }
  object { // LaufSp655->LaufSp
    LaufSp
    rotate <0.0, 0.0, 130.0>
    translate  <0.0, 0.0, 152.833115>
  }
  object { // LaufSp656->LaufSp
    LaufSp
    rotate <0.0, 0.0, 128.0>
    translate  <0.0, 0.0, 153.066448>
  }
  object { // LaufSp657->LaufSp
    LaufSp
    rotate <0.0, 0.0, 126.0>
    translate  <0.0, 0.0, 153.299781>
  }
  object { // LaufSp658->LaufSp
    LaufSp
    rotate <0.0, 0.0, 124.0>
    translate  <0.0, 0.0, 153.533114>
  }
  object { // LaufSp659->LaufSp
    LaufSp
    rotate <0.0, 0.0, 122.0>
    translate  <0.0, 0.0, 153.766447>
  }
  object { // LaufSp660->LaufSp
    LaufSp
    rotate <0.0, 0.0, 120.0>
    translate  <0.0, 0.0, 153.99978>
  }
  object { // LaufSp661->LaufSp
    LaufSp
    rotate <0.0, 0.0, 118.0>
    translate  <0.0, 0.0, 154.233113>
  }
  object { // LaufSp662->LaufSp
    LaufSp
    rotate <0.0, 0.0, 116.0>
    translate  <0.0, 0.0, 154.466446>
  }
  object { // LaufSp663->LaufSp
    LaufSp
    rotate <0.0, 0.0, 114.0>
    translate  <0.0, 0.0, 154.699779>
  }
  object { // LaufSp664->LaufSp
    LaufSp
    rotate <0.0, 0.0, 112.0>
    translate  <0.0, 0.0, 154.933112>
  }
  object { // LaufSp665->LaufSp
    LaufSp
    rotate <0.0, 0.0, 110.0>
    translate  <0.0, 0.0, 155.166445>
  }
  object { // LaufSp666->LaufSp
    LaufSp
    rotate <0.0, 0.0, 108.0>
    translate  <0.0, 0.0, 155.399778>
  }
  object { // LaufSp667->LaufSp
    LaufSp
    rotate <0.0, 0.0, 106.0>
    translate  <0.0, 0.0, 155.633111>
  }
  object { // LaufSp668->LaufSp
    LaufSp
    rotate <0.0, 0.0, 104.0>
    translate  <0.0, 0.0, 155.866444>
  }
  object { // LaufSp669->LaufSp
    LaufSp
    rotate <0.0, 0.0, 102.0>
    translate  <0.0, 0.0, 156.099777>
  }
  object { // LaufSp670->LaufSp
    LaufSp
    rotate <0.0, 0.0, 100.0>
    translate  <0.0, 0.0, 156.33311>
  }
  object { // LaufSp671->LaufSp
    LaufSp
    rotate <0.0, 0.0, 98.0>
    translate  <0.0, 0.0, 156.566443>
  }
  object { // LaufSp672->LaufSp
    LaufSp
    rotate <0.0, 0.0, 96.0>
    translate  <0.0, 0.0, 156.799776>
  }
  object { // LaufSp673->LaufSp
    LaufSp
    rotate <0.0, 0.0, 94.0>
    translate  <0.0, 0.0, 157.033109>
  }
  object { // LaufSp674->LaufSp
    LaufSp
    rotate <0.0, 0.0, 92.0>
    translate  <0.0, 0.0, 157.266442>
  }
  object { // LaufSp675->LaufSp
    LaufSp
    rotate <0.0, 0.0, 90.0>
    translate  <0.0, 0.0, 157.499775>
  }
  object { // LaufSp676->LaufSp
    LaufSp
    rotate <0.0, 0.0, 88.0>
    translate  <0.0, 0.0, 157.733108>
  }
  object { // LaufSp677->LaufSp
    LaufSp
    rotate <0.0, 0.0, 86.0>
    translate  <0.0, 0.0, 157.966441>
  }
  object { // LaufSp678->LaufSp
    LaufSp
    rotate <0.0, 0.0, 84.0>
    translate  <0.0, 0.0, 158.199774>
  }
  object { // LaufSp679->LaufSp
    LaufSp
    rotate <0.0, 0.0, 82.0>
    translate  <0.0, 0.0, 158.433107>
  }
  object { // LaufSp680->LaufSp
    LaufSp
    rotate <0.0, 0.0, 80.0>
    translate  <0.0, 0.0, 158.66644>
  }
  object { // LaufSp681->LaufSp
    LaufSp
    rotate <0.0, 0.0, 78.0>
    translate  <0.0, 0.0, 158.899773>
  }
  object { // LaufSp682->LaufSp
    LaufSp
    rotate <0.0, 0.0, 76.0>
    translate  <0.0, 0.0, 159.133106>
  }
  object { // LaufSp683->LaufSp
    LaufSp
    rotate <0.0, 0.0, 74.0>
    translate  <0.0, 0.0, 159.366439>
  }
  object { // LaufSp684->LaufSp
    LaufSp
    rotate <0.0, 0.0, 72.0>
    translate  <0.0, 0.0, 159.599772>
  }
  object { // LaufSp685->LaufSp
    LaufSp
    rotate <0.0, 0.0, 70.0>
    translate  <0.0, 0.0, 159.833105>
  }
  object { // LaufSp686->LaufSp
    LaufSp
    rotate <0.0, 0.0, 68.0>
    translate  <0.0, 0.0, 160.066438>
  }
  object { // LaufSp687->LaufSp
    LaufSp
    rotate <0.0, 0.0, 66.0>
    translate  <0.0, 0.0, 160.299771>
  }
  object { // LaufSp688->LaufSp
    LaufSp
    rotate <0.0, 0.0, 64.0>
    translate  <0.0, 0.0, 160.533104>
  }
  object { // LaufSp689->LaufSp
    LaufSp
    rotate <0.0, 0.0, 62.0>
    translate  <0.0, 0.0, 160.766437>
  }
  object { // LaufSp690->LaufSp
    LaufSp
    rotate <0.0, 0.0, 60.0>
    translate  <0.0, 0.0, 160.99977>
  }
  object { // LaufSp691->LaufSp
    LaufSp
    rotate <0.0, 0.0, 58.0>
    translate  <0.0, 0.0, 161.233103>
  }
  object { // LaufSp692->LaufSp
    LaufSp
    rotate <0.0, 0.0, 56.0>
    translate  <0.0, 0.0, 161.466436>
  }
  object { // LaufSp693->LaufSp
    LaufSp
    rotate <0.0, 0.0, 54.0>
    translate  <0.0, 0.0, 161.699769>
  }
  object { // LaufSp694->LaufSp
    LaufSp
    rotate <0.0, 0.0, 52.0>
    translate  <0.0, 0.0, 161.933102>
  }
  object { // LaufSp695->LaufSp
    LaufSp
    rotate <0.0, 0.0, 50.0>
    translate  <0.0, 0.0, 162.166435>
  }
  object { // LaufSp696->LaufSp
    LaufSp
    rotate <0.0, 0.0, 48.0>
    translate  <0.0, 0.0, 162.399768>
  }
  object { // LaufSp697->LaufSp
    LaufSp
    rotate <0.0, 0.0, 46.0>
    translate  <0.0, 0.0, 162.633101>
  }
  object { // LaufSp698->LaufSp
    LaufSp
    rotate <0.0, 0.0, 44.0>
    translate  <0.0, 0.0, 162.866434>
  }
  object { // LaufSp699->LaufSp
    LaufSp
    rotate <0.0, 0.0, 42.0>
    translate  <0.0, 0.0, 163.099767>
  }
  object { // LaufSp700->LaufSp
    LaufSp
    rotate <0.0, 0.0, 40.0>
    translate  <0.0, 0.0, 163.3331>
  }
  object { // LaufSp701->LaufSp
    LaufSp
    rotate <0.0, 0.0, 38.0>
    translate  <0.0, 0.0, 163.566433>
  }
  object { // LaufSp702->LaufSp
    LaufSp
    rotate <0.0, 0.0, 36.0>
    translate  <0.0, 0.0, 163.799766>
  }
  object { // LaufSp703->LaufSp
    LaufSp
    rotate <0.0, 0.0, 34.0>
    translate  <0.0, 0.0, 164.033099>
  }
  object { // LaufSp704->LaufSp
    LaufSp
    rotate <0.0, 0.0, 32.0>
    translate  <0.0, 0.0, 164.266432>
  }
  object { // LaufSp705->LaufSp
    LaufSp
    rotate <0.0, 0.0, 30.0>
    translate  <0.0, 0.0, 164.499765>
  }
  object { // LaufSp706->LaufSp
    LaufSp
    rotate <0.0, 0.0, 28.0>
    translate  <0.0, 0.0, 164.733098>
  }
  object { // LaufSp707->LaufSp
    LaufSp
    rotate <0.0, 0.0, 26.0>
    translate  <0.0, 0.0, 164.966431>
  }
  object { // LaufSp708->LaufSp
    LaufSp
    rotate <0.0, 0.0, 24.0>
    translate  <0.0, 0.0, 165.199764>
  }
  object { // LaufSp709->LaufSp
    LaufSp
    rotate <0.0, 0.0, 22.0>
    translate  <0.0, 0.0, 165.433097>
  }
  object { // LaufSp710->LaufSp
    LaufSp
    rotate <0.0, 0.0, 20.0>
    translate  <0.0, 0.0, 165.66643>
  }
  object { // LaufSp711->LaufSp
    LaufSp
    rotate <0.0, 0.0, 18.0>
    translate  <0.0, 0.0, 165.899763>
  }
  object { // LaufSp712->LaufSp
    LaufSp
    rotate <0.0, 0.0, 16.0>
    translate  <0.0, 0.0, 166.133096>
  }
  object { // LaufSp713->LaufSp
    LaufSp
    rotate <0.0, 0.0, 14.0>
    translate  <0.0, 0.0, 166.366429>
  }
  object { // LaufSp714->LaufSp
    LaufSp
    rotate <0.0, 0.0, 12.0>
    translate  <0.0, 0.0, 166.599762>
  }
  object { // LaufSp715->LaufSp
    LaufSp
    rotate <0.0, 0.0, 10.0>
    translate  <0.0, 0.0, 166.833095>
  }
  object { // LaufSp716->LaufSp
    LaufSp
    rotate <0.0, 0.0, 8.0>
    translate  <0.0, 0.0, 167.066428>
  }
  object { // LaufSp717->LaufSp
    LaufSp
    rotate <0.0, 0.0, 6.0>
    translate  <0.0, 0.0, 167.299761>
  }
  object { // LaufSp718->LaufSp
    LaufSp
    rotate <0.0, 0.0, 4.0>
    translate  <0.0, 0.0, 167.533094>
  }
  object { // LaufSp719->LaufSp
    LaufSp
    rotate <0.0, 0.0, 2.0>
    translate  <0.0, 0.0, 167.766427>
  }
  object { // LaufSp720->LaufSp
    LaufSp
    rotate <0.0, 0.0, 0.0>
    translate  <0.0, 0.0, 167.99976>
  }
  object { // LaufSp721->LaufSp
    LaufSp
    rotate <0.0, 0.0, -2.0>
    translate  <0.0, 0.0, 168.233093>
  }
  object { // LaufSp722->LaufSp
    LaufSp
    rotate <0.0, 0.0, -4.0>
    translate  <0.0, 0.0, 168.466426>
  }
  object { // LaufSp723->LaufSp
    LaufSp
    rotate <0.0, 0.0, -6.0>
    translate  <0.0, 0.0, 168.699759>
  }
  object { // LaufSp724->LaufSp
    LaufSp
    rotate <0.0, 0.0, -8.0>
    translate  <0.0, 0.0, 168.933092>
  }
  object { // LaufSp725->LaufSp
    LaufSp
    rotate <0.0, 0.0, -10.0>
    translate  <0.0, 0.0, 169.166425>
  }
  object { // LaufSp726->LaufSp
    LaufSp
    rotate <0.0, 0.0, -12.0>
    translate  <0.0, 0.0, 169.399758>
  }
  object { // LaufSp727->LaufSp
    LaufSp
    rotate <0.0, 0.0, -14.0>
    translate  <0.0, 0.0, 169.633091>
  }
  object { // LaufSp728->LaufSp
    LaufSp
    rotate <0.0, 0.0, -16.0>
    translate  <0.0, 0.0, 169.866424>
  }
  object { // LaufSp729->LaufSp
    LaufSp
    rotate <0.0, 0.0, -18.0>
    translate  <0.0, 0.0, 170.099757>
  }
  object { // LaufSp730->LaufSp
    LaufSp
    rotate <0.0, 0.0, -20.0>
    translate  <0.0, 0.0, 170.33309>
  }
  object { // LaufSp731->LaufSp
    LaufSp
    rotate <0.0, 0.0, -22.0>
    translate  <0.0, 0.0, 170.566423>
  }
  object { // LaufSp732->LaufSp
    LaufSp
    rotate <0.0, 0.0, -24.0>
    translate  <0.0, 0.0, 170.799756>
  }
  object { // LaufSp733->LaufSp
    LaufSp
    rotate <0.0, 0.0, -26.0>
    translate  <0.0, 0.0, 171.033089>
  }
  object { // LaufSp734->LaufSp
    LaufSp
    rotate <0.0, 0.0, -28.0>
    translate  <0.0, 0.0, 171.266422>
  }
  object { // LaufSp735->LaufSp
    LaufSp
    rotate <0.0, 0.0, -30.0>
    translate  <0.0, 0.0, 171.499755>
  }
  object { // LaufSp736->LaufSp
    LaufSp
    rotate <0.0, 0.0, -32.0>
    translate  <0.0, 0.0, 171.733088>
  }
  object { // LaufSp737->LaufSp
    LaufSp
    rotate <0.0, 0.0, -34.0>
    translate  <0.0, 0.0, 171.966421>
  }
  object { // LaufSp738->LaufSp
    LaufSp
    rotate <0.0, 0.0, -36.0>
    translate  <0.0, 0.0, 172.199754>
  }
  object { // LaufSp739->LaufSp
    LaufSp
    rotate <0.0, 0.0, -38.0>
    translate  <0.0, 0.0, 172.433087>
  }
  object { // LaufSp740->LaufSp
    LaufSp
    rotate <0.0, 0.0, -40.0>
    translate  <0.0, 0.0, 172.66642>
  }
  object { // LaufSp741->LaufSp
    LaufSp
    rotate <0.0, 0.0, -42.0>
    translate  <0.0, 0.0, 172.899753>
  }
  object { // LaufSp742->LaufSp
    LaufSp
    rotate <0.0, 0.0, -44.0>
    translate  <0.0, 0.0, 173.133086>
  }
  object { // LaufSp743->LaufSp
    LaufSp
    rotate <0.0, 0.0, -46.0>
    translate  <0.0, 0.0, 173.366419>
  }
  object { // LaufSp744->LaufSp
    LaufSp
    rotate <0.0, 0.0, -48.0>
    translate  <0.0, 0.0, 173.599752>
  }
  object { // LaufSp745->LaufSp
    LaufSp
    rotate <0.0, 0.0, -50.0>
    translate  <0.0, 0.0, 173.833085>
  }
  object { // LaufSp746->LaufSp
    LaufSp
    rotate <0.0, 0.0, -52.0>
    translate  <0.0, 0.0, 174.066418>
  }
  object { // LaufSp747->LaufSp
    LaufSp
    rotate <0.0, 0.0, -54.0>
    translate  <0.0, 0.0, 174.299751>
  }
  object { // LaufSp748->LaufSp
    LaufSp
    rotate <0.0, 0.0, -56.0>
    translate  <0.0, 0.0, 174.533084>
  }
  object { // LaufSp749->LaufSp
    LaufSp
    rotate <0.0, 0.0, -58.0>
    translate  <0.0, 0.0, 174.766417>
  }
  object { // LaufSp750->LaufSp
    LaufSp
    rotate <0.0, 0.0, -60.0>
    translate  <0.0, 0.0, 174.99975>
  }
  object { // LaufSp751->LaufSp
    LaufSp
    rotate <0.0, 0.0, -62.0>
    translate  <0.0, 0.0, 175.233083>
  }
  object { // LaufSp752->LaufSp
    LaufSp
    rotate <0.0, 0.0, -64.0>
    translate  <0.0, 0.0, 175.466416>
  }
  object { // LaufSp753->LaufSp
    LaufSp
    rotate <0.0, 0.0, -66.0>
    translate  <0.0, 0.0, 175.699749>
  }
  object { // LaufSp754->LaufSp
    LaufSp
    rotate <0.0, 0.0, -68.0>
    translate  <0.0, 0.0, 175.933082>
  }
  object { // LaufSp755->LaufSp
    LaufSp
    rotate <0.0, 0.0, -70.0>
    translate  <0.0, 0.0, 176.166415>
  }
  object { // LaufSp756->LaufSp
    LaufSp
    rotate <0.0, 0.0, -72.0>
    translate  <0.0, 0.0, 176.399748>
  }
  object { // LaufSp757->LaufSp
    LaufSp
    rotate <0.0, 0.0, -74.0>
    translate  <0.0, 0.0, 176.633081>
  }
  object { // LaufSp758->LaufSp
    LaufSp
    rotate <0.0, 0.0, -76.0>
    translate  <0.0, 0.0, 176.866414>
  }
  object { // LaufSp759->LaufSp
    LaufSp
    rotate <0.0, 0.0, -78.0>
    translate  <0.0, 0.0, 177.099747>
  }
  object { // LaufSp760->LaufSp
    LaufSp
    rotate <0.0, 0.0, -80.0>
    translate  <0.0, 0.0, 177.33308>
  }
  object { // LaufSp761->LaufSp
    LaufSp
    rotate <0.0, 0.0, -82.0>
    translate  <0.0, 0.0, 177.566413>
  }
  object { // LaufSp762->LaufSp
    LaufSp
    rotate <0.0, 0.0, -84.0>
    translate  <0.0, 0.0, 177.799746>
  }
  object { // LaufSp763->LaufSp
    LaufSp
    rotate <0.0, 0.0, -86.0>
    translate  <0.0, 0.0, 178.033079>
  }
  object { // LaufSp764->LaufSp
    LaufSp
    rotate <0.0, 0.0, -88.0>
    translate  <0.0, 0.0, 178.266412>
  }
  object { // LaufSp765->LaufSp
    LaufSp
    rotate <0.0, 0.0, -90.0>
    translate  <0.0, 0.0, 178.499745>
  }
  object { // LaufSp766->LaufSp
    LaufSp
    rotate <0.0, 0.0, -92.0>
    translate  <0.0, 0.0, 178.733078>
  }
  object { // LaufSp767->LaufSp
    LaufSp
    rotate <0.0, 0.0, -94.0>
    translate  <0.0, 0.0, 178.966411>
  }
  object { // LaufSp768->LaufSp
    LaufSp
    rotate <0.0, 0.0, -96.0>
    translate  <0.0, 0.0, 179.199744>
  }
  object { // LaufSp769->LaufSp
    LaufSp
    rotate <0.0, 0.0, -98.0>
    translate  <0.0, 0.0, 179.433077>
  }
  object { // LaufSp770->LaufSp
    LaufSp
    rotate <0.0, 0.0, -100.0>
    translate  <0.0, 0.0, 179.66641>
  }
  object { // LaufSp771->LaufSp
    LaufSp
    rotate <0.0, 0.0, -102.0>
    translate  <0.0, 0.0, 179.899743>
  }
  object { // LaufSp772->LaufSp
    LaufSp
    rotate <0.0, 0.0, -104.0>
    translate  <0.0, 0.0, 180.133076>
  }
  object { // LaufSp773->LaufSp
    LaufSp
    rotate <0.0, 0.0, -106.0>
    translate  <0.0, 0.0, 180.366409>
  }
  object { // LaufSp774->LaufSp
    LaufSp
    rotate <0.0, 0.0, -108.0>
    translate  <0.0, 0.0, 180.599742>
  }
  object { // LaufSp775->LaufSp
    LaufSp
    rotate <0.0, 0.0, -110.0>
    translate  <0.0, 0.0, 180.833075>
  }
  object { // LaufSp776->LaufSp
    LaufSp
    rotate <0.0, 0.0, -112.0>
    translate  <0.0, 0.0, 181.066408>
  }
  object { // LaufSp777->LaufSp
    LaufSp
    rotate <0.0, 0.0, -114.0>
    translate  <0.0, 0.0, 181.299741>
  }
  object { // LaufSp778->LaufSp
    LaufSp
    rotate <0.0, 0.0, -116.0>
    translate  <0.0, 0.0, 181.533074>
  }
  object { // LaufSp779->LaufSp
    LaufSp
    rotate <0.0, 0.0, -118.0>
    translate  <0.0, 0.0, 181.766407>
  }
  object { // LaufSp780->LaufSp
    LaufSp
    rotate <0.0, 0.0, -120.0>
    translate  <0.0, 0.0, 181.99974>
  }
  object { // LaufSp781->LaufSp
    LaufSp
    rotate <0.0, 0.0, -122.0>
    translate  <0.0, 0.0, 182.233073>
  }
  object { // LaufSp782->LaufSp
    LaufSp
    rotate <0.0, 0.0, -124.0>
    translate  <0.0, 0.0, 182.466406>
  }
  object { // LaufSp783->LaufSp
    LaufSp
    rotate <0.0, 0.0, -126.0>
    translate  <0.0, 0.0, 182.699739>
  }
  object { // LaufSp784->LaufSp
    LaufSp
    rotate <0.0, 0.0, -128.0>
    translate  <0.0, 0.0, 182.933072>
  }
  object { // LaufSp785->LaufSp
    LaufSp
    rotate <0.0, 0.0, -130.0>
    translate  <0.0, 0.0, 183.166405>
  }
  object { // LaufSp786->LaufSp
    LaufSp
    rotate <0.0, 0.0, -132.0>
    translate  <0.0, 0.0, 183.399738>
  }
  object { // LaufSp787->LaufSp
    LaufSp
    rotate <0.0, 0.0, -134.0>
    translate  <0.0, 0.0, 183.633071>
  }
  object { // LaufSp788->LaufSp
    LaufSp
    rotate <0.0, 0.0, -136.0>
    translate  <0.0, 0.0, 183.866404>
  }
  object { // LaufSp789->LaufSp
    LaufSp
    rotate <0.0, 0.0, -138.0>
    translate  <0.0, 0.0, 184.099737>
  }
  object { // LaufSp790->LaufSp
    LaufSp
    rotate <0.0, 0.0, -140.0>
    translate  <0.0, 0.0, 184.33307>
  }
  object { // LaufSp791->LaufSp
    LaufSp
    rotate <0.0, 0.0, -142.0>
    translate  <0.0, 0.0, 184.566403>
  }
  object { // LaufSp792->LaufSp
    LaufSp
    rotate <0.0, 0.0, -144.0>
    translate  <0.0, 0.0, 184.799736>
  }
  object { // LaufSp793->LaufSp
    LaufSp
    rotate <0.0, 0.0, -146.0>
    translate  <0.0, 0.0, 185.033069>
  }
  object { // LaufSp794->LaufSp
    LaufSp
    rotate <0.0, 0.0, -148.0>
    translate  <0.0, 0.0, 185.266402>
  }
  object { // LaufSp795->LaufSp
    LaufSp
    rotate <0.0, 0.0, -150.0>
    translate  <0.0, 0.0, 185.499735>
  }
  object { // LaufSp796->LaufSp
    LaufSp
    rotate <0.0, 0.0, -152.0>
    translate  <0.0, 0.0, 185.733068>
  }
  object { // LaufSp797->LaufSp
    LaufSp
    rotate <0.0, 0.0, -154.0>
    translate  <0.0, 0.0, 185.966401>
  }
  object { // LaufSp798->LaufSp
    LaufSp
    rotate <0.0, 0.0, -156.0>
    translate  <0.0, 0.0, 186.199734>
  }
  object { // LaufSp799->LaufSp
    LaufSp
    rotate <0.0, 0.0, -158.0>
    translate  <0.0, 0.0, 186.433067>
  }
  object { // LaufSp800->LaufSp
    LaufSp
    rotate <0.0, 0.0, -160.0>
    translate  <0.0, 0.0, 186.6664>
  }
  object { // LaufSp801->LaufSp
    LaufSp
    rotate <0.0, 0.0, -162.0>
    translate  <0.0, 0.0, 186.899733>
  }
  object { // LaufSp802->LaufSp
    LaufSp
    rotate <0.0, 0.0, -164.0>
    translate  <0.0, 0.0, 187.133066>
  }
  object { // LaufSp803->LaufSp
    LaufSp
    rotate <0.0, 0.0, -166.0>
    translate  <0.0, 0.0, 187.366399>
  }
  object { // LaufSp804->LaufSp
    LaufSp
    rotate <0.0, 0.0, -168.0>
    translate  <0.0, 0.0, 187.599732>
  }
  object { // LaufSp805->LaufSp
    LaufSp
    rotate <0.0, 0.0, -170.0>
    translate  <0.0, 0.0, 187.833065>
  }
  object { // LaufSp806->LaufSp
    LaufSp
    rotate <0.0, 0.0, -172.0>
    translate  <0.0, 0.0, 188.066398>
  }
  object { // LaufSp807->LaufSp
    LaufSp
    rotate <0.0, 0.0, -174.0>
    translate  <0.0, 0.0, 188.299731>
  }
  object { // LaufSp808->LaufSp
    LaufSp
    rotate <0.0, 0.0, -176.0>
    translate  <0.0, 0.0, 188.533064>
  }
  object { // LaufSp809->LaufSp
    LaufSp
    rotate <0.0, 0.0, -178.0>
    translate  <0.0, 0.0, 188.766397>
  }
  object { // LaufSp810->LaufSp
    LaufSp
    rotate <0.0, 0.0, 180.0>
    translate  <0.0, 0.0, 188.99973>
  }
  object { // LaufSp811->LaufSp
    LaufSp
    rotate <0.0, 0.0, 178.0>
    translate  <0.0, 0.0, 189.233063>
  }
  object { // LaufSp812->LaufSp
    LaufSp
    rotate <0.0, 0.0, 176.0>
    translate  <0.0, 0.0, 189.466396>
  }
  object { // LaufSp813->LaufSp
    LaufSp
    rotate <0.0, 0.0, 174.0>
    translate  <0.0, 0.0, 189.699729>
  }
  object { // LaufSp814->LaufSp
    LaufSp
    rotate <0.0, 0.0, 172.0>
    translate  <0.0, 0.0, 189.933062>
  }
  object { // LaufSp815->LaufSp
    LaufSp
    rotate <0.0, 0.0, 170.0>
    translate  <0.0, 0.0, 190.166395>
  }
  object { // LaufSp816->LaufSp
    LaufSp
    rotate <0.0, 0.0, 168.0>
    translate  <0.0, 0.0, 190.399728>
  }
  object { // LaufSp817->LaufSp
    LaufSp
    rotate <0.0, 0.0, 166.0>
    translate  <0.0, 0.0, 190.633061>
  }
  object { // LaufSp818->LaufSp
    LaufSp
    rotate <0.0, 0.0, 164.0>
    translate  <0.0, 0.0, 190.866394>
  }
  object { // LaufSp819->LaufSp
    LaufSp
    rotate <0.0, 0.0, 162.0>
    translate  <0.0, 0.0, 191.099727>
  }
  object { // LaufSp820->LaufSp
    LaufSp
    rotate <0.0, 0.0, 160.0>
    translate  <0.0, 0.0, 191.33306>
  }
  object { // LaufSp821->LaufSp
    LaufSp
    rotate <0.0, 0.0, 158.0>
    translate  <0.0, 0.0, 191.566393>
  }
  object { // LaufSp822->LaufSp
    LaufSp
    rotate <0.0, 0.0, 156.0>
    translate  <0.0, 0.0, 191.799726>
  }
  object { // LaufSp823->LaufSp
    LaufSp
    rotate <0.0, 0.0, 154.0>
    translate  <0.0, 0.0, 192.033059>
  }
  object { // LaufSp824->LaufSp
    LaufSp
    rotate <0.0, 0.0, 152.0>
    translate  <0.0, 0.0, 192.266392>
  }
  object { // LaufSp825->LaufSp
    LaufSp
    rotate <0.0, 0.0, 150.0>
    translate  <0.0, 0.0, 192.499725>
  }
  object { // LaufSp826->LaufSp
    LaufSp
    rotate <0.0, 0.0, 148.0>
    translate  <0.0, 0.0, 192.733058>
  }
  object { // LaufSp827->LaufSp
    LaufSp
    rotate <0.0, 0.0, 146.0>
    translate  <0.0, 0.0, 192.966391>
  }
  object { // LaufSp828->LaufSp
    LaufSp
    rotate <0.0, 0.0, 144.0>
    translate  <0.0, 0.0, 193.199724>
  }
  object { // LaufSp829->LaufSp
    LaufSp
    rotate <0.0, 0.0, 142.0>
    translate  <0.0, 0.0, 193.433057>
  }
  object { // LaufSp830->LaufSp
    LaufSp
    rotate <0.0, 0.0, 140.0>
    translate  <0.0, 0.0, 193.66639>
  }
  object { // LaufSp831->LaufSp
    LaufSp
    rotate <0.0, 0.0, 138.0>
    translate  <0.0, 0.0, 193.899723>
  }
  object { // LaufSp832->LaufSp
    LaufSp
    rotate <0.0, 0.0, 136.0>
    translate  <0.0, 0.0, 194.133056>
  }
  object { // LaufSp833->LaufSp
    LaufSp
    rotate <0.0, 0.0, 134.0>
    translate  <0.0, 0.0, 194.366389>
  }
  object { // LaufSp834->LaufSp
    LaufSp
    rotate <0.0, 0.0, 132.0>
    translate  <0.0, 0.0, 194.599722>
  }
  object { // LaufSp835->LaufSp
    LaufSp
    rotate <0.0, 0.0, 130.0>
    translate  <0.0, 0.0, 194.833055>
  }
  object { // LaufSp836->LaufSp
    LaufSp
    rotate <0.0, 0.0, 128.0>
    translate  <0.0, 0.0, 195.066388>
  }
  object { // LaufSp837->LaufSp
    LaufSp
    rotate <0.0, 0.0, 126.0>
    translate  <0.0, 0.0, 195.299721>
  }
  object { // LaufSp838->LaufSp
    LaufSp
    rotate <0.0, 0.0, 124.0>
    translate  <0.0, 0.0, 195.533054>
  }
  object { // LaufSp839->LaufSp
    LaufSp
    rotate <0.0, 0.0, 122.0>
    translate  <0.0, 0.0, 195.766387>
  }
  object { // LaufSp840->LaufSp
    LaufSp
    rotate <0.0, 0.0, 120.0>
    translate  <0.0, 0.0, 195.99972>
  }
  object { // LaufSp841->LaufSp
    LaufSp
    rotate <0.0, 0.0, 118.0>
    translate  <0.0, 0.0, 196.233053>
  }
  object { // LaufSp842->LaufSp
    LaufSp
    rotate <0.0, 0.0, 116.0>
    translate  <0.0, 0.0, 196.466386>
  }
  object { // LaufSp843->LaufSp
    LaufSp
    rotate <0.0, 0.0, 114.0>
    translate  <0.0, 0.0, 196.699719>
  }
  object { // LaufSp844->LaufSp
    LaufSp
    rotate <0.0, 0.0, 112.0>
    translate  <0.0, 0.0, 196.933052>
  }
  object { // LaufSp845->LaufSp
    LaufSp
    rotate <0.0, 0.0, 110.0>
    translate  <0.0, 0.0, 197.166385>
  }
  object { // LaufSp846->LaufSp
    LaufSp
    rotate <0.0, 0.0, 108.0>
    translate  <0.0, 0.0, 197.399718>
  }
  object { // LaufSp847->LaufSp
    LaufSp
    rotate <0.0, 0.0, 106.0>
    translate  <0.0, 0.0, 197.633051>
  }
  object { // LaufSp848->LaufSp
    LaufSp
    rotate <0.0, 0.0, 104.0>
    translate  <0.0, 0.0, 197.866384>
  }
  object { // LaufSp849->LaufSp
    LaufSp
    rotate <0.0, 0.0, 102.0>
    translate  <0.0, 0.0, 198.099717>
  }
  object { // LaufSp850->LaufSp
    LaufSp
    rotate <0.0, 0.0, 100.0>
    translate  <0.0, 0.0, 198.33305>
  }
  object { // LaufSp851->LaufSp
    LaufSp
    rotate <0.0, 0.0, 98.0>
    translate  <0.0, 0.0, 198.566383>
  }
  object { // LaufSp852->LaufSp
    LaufSp
    rotate <0.0, 0.0, 96.0>
    translate  <0.0, 0.0, 198.799716>
  }
  object { // LaufSp853->LaufSp
    LaufSp
    rotate <0.0, 0.0, 94.0>
    translate  <0.0, 0.0, 199.033049>
  }
  object { // LaufSp854->LaufSp
    LaufSp
    rotate <0.0, 0.0, 92.0>
    translate  <0.0, 0.0, 199.266382>
  }
  object { // LaufSp855->LaufSp
    LaufSp
    rotate <0.0, 0.0, 90.0>
    translate  <0.0, 0.0, 199.499715>
  }
  object { // LaufSp856->LaufSp
    LaufSp
    rotate <0.0, 0.0, 88.0>
    translate  <0.0, 0.0, 199.733048>
  }
  object { // LaufSp857->LaufSp
    LaufSp
    rotate <0.0, 0.0, 86.0>
    translate  <0.0, 0.0, 199.966381>
  }
  object { // LaufSp858->LaufSp
    LaufSp
    rotate <0.0, 0.0, 84.0>
    translate  <0.0, 0.0, 200.199714>
  }
  object { // LaufSp859->LaufSp
    LaufSp
    rotate <0.0, 0.0, 82.0>
    translate  <0.0, 0.0, 200.433047>
  }
  object { // LaufSp860->LaufSp
    LaufSp
    rotate <0.0, 0.0, 80.0>
    translate  <0.0, 0.0, 200.66638>
  }
  object { // LaufSp861->LaufSp
    LaufSp
    rotate <0.0, 0.0, 78.0>
    translate  <0.0, 0.0, 200.899713>
  }
  object { // LaufSp862->LaufSp
    LaufSp
    rotate <0.0, 0.0, 76.0>
    translate  <0.0, 0.0, 201.133046>
  }
  object { // LaufSp863->LaufSp
    LaufSp
    rotate <0.0, 0.0, 74.0>
    translate  <0.0, 0.0, 201.366379>
  }
  object { // LaufSp864->LaufSp
    LaufSp
    rotate <0.0, 0.0, 72.0>
    translate  <0.0, 0.0, 201.599712>
  }
  object { // LaufSp865->LaufSp
    LaufSp
    rotate <0.0, 0.0, 70.0>
    translate  <0.0, 0.0, 201.833045>
  }
  object { // LaufSp866->LaufSp
    LaufSp
    rotate <0.0, 0.0, 68.0>
    translate  <0.0, 0.0, 202.066378>
  }
  object { // LaufSp867->LaufSp
    LaufSp
    rotate <0.0, 0.0, 66.0>
    translate  <0.0, 0.0, 202.299711>
  }
  object { // LaufSp868->LaufSp
    LaufSp
    rotate <0.0, 0.0, 64.0>
    translate  <0.0, 0.0, 202.533044>
  }
  object { // LaufSp869->LaufSp
    LaufSp
    rotate <0.0, 0.0, 62.0>
    translate  <0.0, 0.0, 202.766377>
  }
  object { // LaufSp870->LaufSp
    LaufSp
    rotate <0.0, 0.0, 60.0>
    translate  <0.0, 0.0, 202.99971>
  }
  object { // LaufSp871->LaufSp
    LaufSp
    rotate <0.0, 0.0, 58.0>
    translate  <0.0, 0.0, 203.233043>
  }
  object { // LaufSp872->LaufSp
    LaufSp
    rotate <0.0, 0.0, 56.0>
    translate  <0.0, 0.0, 203.466376>
  }
  object { // LaufSp873->LaufSp
    LaufSp
    rotate <0.0, 0.0, 54.0>
    translate  <0.0, 0.0, 203.699709>
  }
  object { // LaufSp874->LaufSp
    LaufSp
    rotate <0.0, 0.0, 52.0>
    translate  <0.0, 0.0, 203.933042>
  }
  object { // LaufSp875->LaufSp
    LaufSp
    rotate <0.0, 0.0, 50.0>
    translate  <0.0, 0.0, 204.166375>
  }
  object { // LaufSp876->LaufSp
    LaufSp
    rotate <0.0, 0.0, 48.0>
    translate  <0.0, 0.0, 204.399708>
  }
  object { // LaufSp877->LaufSp
    LaufSp
    rotate <0.0, 0.0, 46.0>
    translate  <0.0, 0.0, 204.633041>
  }
  object { // LaufSp878->LaufSp
    LaufSp
    rotate <0.0, 0.0, 44.0>
    translate  <0.0, 0.0, 204.866374>
  }
  object { // LaufSp879->LaufSp
    LaufSp
    rotate <0.0, 0.0, 42.0>
    translate  <0.0, 0.0, 205.099707>
  }
  object { // LaufSp880->LaufSp
    LaufSp
    rotate <0.0, 0.0, 40.0>
    translate  <0.0, 0.0, 205.33304>
  }
  object { // LaufSp881->LaufSp
    LaufSp
    rotate <0.0, 0.0, 38.0>
    translate  <0.0, 0.0, 205.566373>
  }
  object { // LaufSp882->LaufSp
    LaufSp
    rotate <0.0, 0.0, 36.0>
    translate  <0.0, 0.0, 205.799706>
  }
  object { // LaufSp883->LaufSp
    LaufSp
    rotate <0.0, 0.0, 34.0>
    translate  <0.0, 0.0, 206.033039>
  }
  object { // LaufSp884->LaufSp
    LaufSp
    rotate <0.0, 0.0, 32.0>
    translate  <0.0, 0.0, 206.266372>
  }
  object { // LaufSp885->LaufSp
    LaufSp
    rotate <0.0, 0.0, 30.0>
    translate  <0.0, 0.0, 206.499705>
  }
  object { // LaufSp886->LaufSp
    LaufSp
    rotate <0.0, 0.0, 28.0>
    translate  <0.0, 0.0, 206.733038>
  }
  object { // LaufSp887->LaufSp
    LaufSp
    rotate <0.0, 0.0, 26.0>
    translate  <0.0, 0.0, 206.966371>
  }
  object { // LaufSp888->LaufSp
    LaufSp
    rotate <0.0, 0.0, 24.0>
    translate  <0.0, 0.0, 207.199704>
  }
  object { // LaufSp889->LaufSp
    LaufSp
    rotate <0.0, 0.0, 22.0>
    translate  <0.0, 0.0, 207.433037>
  }
  object { // LaufSp890->LaufSp
    LaufSp
    rotate <0.0, 0.0, 20.0>
    translate  <0.0, 0.0, 207.66637>
  }
  object { // LaufSp891->LaufSp
    LaufSp
    rotate <0.0, 0.0, 18.0>
    translate  <0.0, 0.0, 207.899703>
  }
  object { // LaufSp892->LaufSp
    LaufSp
    rotate <0.0, 0.0, 16.0>
    translate  <0.0, 0.0, 208.133036>
  }
  object { // LaufSp893->LaufSp
    LaufSp
    rotate <0.0, 0.0, 14.0>
    translate  <0.0, 0.0, 208.366369>
  }
  object { // LaufSp894->LaufSp
    LaufSp
    rotate <0.0, 0.0, 12.0>
    translate  <0.0, 0.0, 208.599702>
  }
  object { // LaufSp895->LaufSp
    LaufSp
    rotate <0.0, 0.0, 10.0>
    translate  <0.0, 0.0, 208.833035>
  }
  object { // LaufSp896->LaufSp
    LaufSp
    rotate <0.0, 0.0, 8.0>
    translate  <0.0, 0.0, 209.066368>
  }
  object { // LaufSp897->LaufSp
    LaufSp
    rotate <0.0, 0.0, 6.0>
    translate  <0.0, 0.0, 209.299701>
  }
  object { // LaufSp898->LaufSp
    LaufSp
    rotate <0.0, 0.0, 4.0>
    translate  <0.0, 0.0, 209.533034>
  }
  object { // LaufSp899->LaufSp
    LaufSp
    rotate <0.0, 0.0, 2.0>
    translate  <0.0, 0.0, 209.766367>
  }
  object { // LaufSp900->LaufSp
    LaufSp
    rotate <0.0, 0.0, 0.0>
    translate  <0.0, 0.0, 209.9997>
  }
  object { // LaufSp901->LaufSp
    LaufSp
    rotate <0.0, 0.0, -2.0>
    translate  <0.0, 0.0, 210.233033>
  }
  object { // LaufSp902->LaufSp
    LaufSp
    rotate <0.0, 0.0, -4.0>
    translate  <0.0, 0.0, 210.466366>
  }
  object { // LaufSp903->LaufSp
    LaufSp
    rotate <0.0, 0.0, -6.0>
    translate  <0.0, 0.0, 210.699699>
  }
  object { // LaufSp904->LaufSp
    LaufSp
    rotate <0.0, 0.0, -8.0>
    translate  <0.0, 0.0, 210.933032>
  }
  object { // LaufSp905->LaufSp
    LaufSp
    rotate <0.0, 0.0, -10.0>
    translate  <0.0, 0.0, 211.166365>
  }
  object { // LaufSp906->LaufSp
    LaufSp
    rotate <0.0, 0.0, -12.0>
    translate  <0.0, 0.0, 211.399698>
  }
  object { // LaufSp907->LaufSp
    LaufSp
    rotate <0.0, 0.0, -14.0>
    translate  <0.0, 0.0, 211.633031>
  }
  object { // LaufSp908->LaufSp
    LaufSp
    rotate <0.0, 0.0, -16.0>
    translate  <0.0, 0.0, 211.866364>
  }
  object { // LaufSp909->LaufSp
    LaufSp
    rotate <0.0, 0.0, -18.0>
    translate  <0.0, 0.0, 212.099697>
  }
  object { // LaufSp910->LaufSp
    LaufSp
    rotate <0.0, 0.0, -20.0>
    translate  <0.0, 0.0, 212.33303>
  }
  object { // LaufSp911->LaufSp
    LaufSp
    rotate <0.0, 0.0, -22.0>
    translate  <0.0, 0.0, 212.566363>
  }
  object { // LaufSp912->LaufSp
    LaufSp
    rotate <0.0, 0.0, -24.0>
    translate  <0.0, 0.0, 212.799696>
  }
  object { // LaufSp913->LaufSp
    LaufSp
    rotate <0.0, 0.0, -26.0>
    translate  <0.0, 0.0, 213.033029>
  }
  object { // LaufSp914->LaufSp
    LaufSp
    rotate <0.0, 0.0, -28.0>
    translate  <0.0, 0.0, 213.266362>
  }
  object { // LaufSp915->LaufSp
    LaufSp
    rotate <0.0, 0.0, -30.0>
    translate  <0.0, 0.0, 213.499695>
  }
  object { // LaufSp916->LaufSp
    LaufSp
    rotate <0.0, 0.0, -32.0>
    translate  <0.0, 0.0, 213.733028>
  }
  object { // LaufSp917->LaufSp
    LaufSp
    rotate <0.0, 0.0, -34.0>
    translate  <0.0, 0.0, 213.966361>
  }
  object { // LaufSp918->LaufSp
    LaufSp
    rotate <0.0, 0.0, -36.0>
    translate  <0.0, 0.0, 214.199694>
  }
  object { // LaufSp919->LaufSp
    LaufSp
    rotate <0.0, 0.0, -38.0>
    translate  <0.0, 0.0, 214.433027>
  }
  object { // LaufSp920->LaufSp
    LaufSp
    rotate <0.0, 0.0, -40.0>
    translate  <0.0, 0.0, 214.66636>
  }
  object { // LaufSp921->LaufSp
    LaufSp
    rotate <0.0, 0.0, -42.0>
    translate  <0.0, 0.0, 214.899693>
  }
  object { // LaufSp922->LaufSp
    LaufSp
    rotate <0.0, 0.0, -44.0>
    translate  <0.0, 0.0, 215.133026>
  }
  object { // LaufSp923->LaufSp
    LaufSp
    rotate <0.0, 0.0, -46.0>
    translate  <0.0, 0.0, 215.366359>
  }
  object { // LaufSp924->LaufSp
    LaufSp
    rotate <0.0, 0.0, -48.0>
    translate  <0.0, 0.0, 215.599692>
  }
  object { // LaufSp925->LaufSp
    LaufSp
    rotate <0.0, 0.0, -50.0>
    translate  <0.0, 0.0, 215.833025>
  }
  object { // LaufSp926->LaufSp
    LaufSp
    rotate <0.0, 0.0, -52.0>
    translate  <0.0, 0.0, 216.066358>
  }
  object { // LaufSp927->LaufSp
    LaufSp
    rotate <0.0, 0.0, -54.0>
    translate  <0.0, 0.0, 216.299691>
  }
  object { // LaufSp928->LaufSp
    LaufSp
    rotate <0.0, 0.0, -56.0>
    translate  <0.0, 0.0, 216.533024>
  }
  object { // LaufSp929->LaufSp
    LaufSp
    rotate <0.0, 0.0, -58.0>
    translate  <0.0, 0.0, 216.766357>
  }
  object { // LaufSp930->LaufSp
    LaufSp
    rotate <0.0, 0.0, -60.0>
    translate  <0.0, 0.0, 216.99969>
  }
  object { // LaufSp931->LaufSp
    LaufSp
    rotate <0.0, 0.0, -62.0>
    translate  <0.0, 0.0, 217.233023>
  }
  object { // LaufSp932->LaufSp
    LaufSp
    rotate <0.0, 0.0, -64.0>
    translate  <0.0, 0.0, 217.466356>
  }
  object { // LaufSp933->LaufSp
    LaufSp
    rotate <0.0, 0.0, -66.0>
    translate  <0.0, 0.0, 217.699689>
  }
  object { // LaufSp934->LaufSp
    LaufSp
    rotate <0.0, 0.0, -68.0>
    translate  <0.0, 0.0, 217.933022>
  }
  object { // LaufSp935->LaufSp
    LaufSp
    rotate <0.0, 0.0, -70.0>
    translate  <0.0, 0.0, 218.166355>
  }
  object { // LaufSp936->LaufSp
    LaufSp
    rotate <0.0, 0.0, -72.0>
    translate  <0.0, 0.0, 218.399688>
  }
  object { // LaufSp937->LaufSp
    LaufSp
    rotate <0.0, 0.0, -74.0>
    translate  <0.0, 0.0, 218.633021>
  }
  object { // LaufSp938->LaufSp
    LaufSp
    rotate <0.0, 0.0, -76.0>
    translate  <0.0, 0.0, 218.866354>
  }
  object { // LaufSp939->LaufSp
    LaufSp
    rotate <0.0, 0.0, -78.0>
    translate  <0.0, 0.0, 219.099687>
  }
  object { // LaufSp940->LaufSp
    LaufSp
    rotate <0.0, 0.0, -80.0>
    translate  <0.0, 0.0, 219.33302>
  }
  object { // LaufSp941->LaufSp
    LaufSp
    rotate <0.0, 0.0, -82.0>
    translate  <0.0, 0.0, 219.566353>
  }
  object { // LaufSp942->LaufSp
    LaufSp
    rotate <0.0, 0.0, -84.0>
    translate  <0.0, 0.0, 219.799686>
  }
  object { // LaufSp943->LaufSp
    LaufSp
    rotate <0.0, 0.0, -86.0>
    translate  <0.0, 0.0, 220.033019>
  }
  object { // LaufSp944->LaufSp
    LaufSp
    rotate <0.0, 0.0, -88.0>
    translate  <0.0, 0.0, 220.266352>
  }
  object { // LaufSp945->LaufSp
    LaufSp
    rotate <0.0, 0.0, -90.0>
    translate  <0.0, 0.0, 220.499685>
  }
  object { // LaufSp946->LaufSp
    LaufSp
    rotate <0.0, 0.0, -92.0>
    translate  <0.0, 0.0, 220.733018>
  }
  object { // LaufSp947->LaufSp
    LaufSp
    rotate <0.0, 0.0, -94.0>
    translate  <0.0, 0.0, 220.966351>
  }
  object { // LaufSp948->LaufSp
    LaufSp
    rotate <0.0, 0.0, -96.0>
    translate  <0.0, 0.0, 221.199684>
  }
  object { // LaufSp949->LaufSp
    LaufSp
    rotate <0.0, 0.0, -98.0>
    translate  <0.0, 0.0, 221.433017>
  }
  object { // LaufSp950->LaufSp
    LaufSp
    rotate <0.0, 0.0, -100.0>
    translate  <0.0, 0.0, 221.66635>
  }
  object { // LaufSp951->LaufSp
    LaufSp
    rotate <0.0, 0.0, -102.0>
    translate  <0.0, 0.0, 221.899683>
  }
  object { // LaufSp952->LaufSp
    LaufSp
    rotate <0.0, 0.0, -104.0>
    translate  <0.0, 0.0, 222.133016>
  }
  object { // LaufSp953->LaufSp
    LaufSp
    rotate <0.0, 0.0, -106.0>
    translate  <0.0, 0.0, 222.366349>
  }
  object { // LaufSp954->LaufSp
    LaufSp
    rotate <0.0, 0.0, -108.0>
    translate  <0.0, 0.0, 222.599682>
  }
  object { // LaufSp955->LaufSp
    LaufSp
    rotate <0.0, 0.0, -110.0>
    translate  <0.0, 0.0, 222.833015>
  }
  object { // LaufSp956->LaufSp
    LaufSp
    rotate <0.0, 0.0, -112.0>
    translate  <0.0, 0.0, 223.066348>
  }
  object { // LaufSp957->LaufSp
    LaufSp
    rotate <0.0, 0.0, -114.0>
    translate  <0.0, 0.0, 223.299681>
  }
  object { // LaufSp958->LaufSp
    LaufSp
    rotate <0.0, 0.0, -116.0>
    translate  <0.0, 0.0, 223.533014>
  }
  object { // LaufSp959->LaufSp
    LaufSp
    rotate <0.0, 0.0, -118.0>
    translate  <0.0, 0.0, 223.766347>
  }
  object { // LaufSp960->LaufSp
    LaufSp
    rotate <0.0, 0.0, -120.0>
    translate  <0.0, 0.0, 223.99968>
  }
  object { // LaufSp961->LaufSp
    LaufSp
    rotate <0.0, 0.0, -122.0>
    translate  <0.0, 0.0, 224.233013>
  }
  object { // LaufSp962->LaufSp
    LaufSp
    rotate <0.0, 0.0, -124.0>
    translate  <0.0, 0.0, 224.466346>
  }
  object { // LaufSp963->LaufSp
    LaufSp
    rotate <0.0, 0.0, -126.0>
    translate  <0.0, 0.0, 224.699679>
  }
  object { // LaufSp964->LaufSp
    LaufSp
    rotate <0.0, 0.0, -128.0>
    translate  <0.0, 0.0, 224.933012>
  }
  object { // LaufSp965->LaufSp
    LaufSp
    rotate <0.0, 0.0, -130.0>
    translate  <0.0, 0.0, 225.166345>
  }
  object { // LaufSp966->LaufSp
    LaufSp
    rotate <0.0, 0.0, -132.0>
    translate  <0.0, 0.0, 225.399678>
  }
  object { // LaufSp967->LaufSp
    LaufSp
    rotate <0.0, 0.0, -134.0>
    translate  <0.0, 0.0, 225.633011>
  }
  object { // LaufSp968->LaufSp
    LaufSp
    rotate <0.0, 0.0, -136.0>
    translate  <0.0, 0.0, 225.866344>
  }
  object { // LaufSp969->LaufSp
    LaufSp
    rotate <0.0, 0.0, -138.0>
    translate  <0.0, 0.0, 226.099677>
  }
  object { // LaufSp970->LaufSp
    LaufSp
    rotate <0.0, 0.0, -140.0>
    translate  <0.0, 0.0, 226.33301>
  }
  object { // LaufSp971->LaufSp
    LaufSp
    rotate <0.0, 0.0, -142.0>
    translate  <0.0, 0.0, 226.566343>
  }
  object { // LaufSp972->LaufSp
    LaufSp
    rotate <0.0, 0.0, -144.0>
    translate  <0.0, 0.0, 226.799676>
  }
  object { // LaufSp973->LaufSp
    LaufSp
    rotate <0.0, 0.0, -146.0>
    translate  <0.0, 0.0, 227.033009>
  }
  object { // LaufSp974->LaufSp
    LaufSp
    rotate <0.0, 0.0, -148.0>
    translate  <0.0, 0.0, 227.266342>
  }
  object { // LaufSp975->LaufSp
    LaufSp
    rotate <0.0, 0.0, -150.0>
    translate  <0.0, 0.0, 227.499675>
  }
  object { // LaufSp976->LaufSp
    LaufSp
    rotate <0.0, 0.0, -152.0>
    translate  <0.0, 0.0, 227.733008>
  }
  object { // LaufSp977->LaufSp
    LaufSp
    rotate <0.0, 0.0, -154.0>
    translate  <0.0, 0.0, 227.966341>
  }
  object { // LaufSp978->LaufSp
    LaufSp
    rotate <0.0, 0.0, -156.0>
    translate  <0.0, 0.0, 228.199674>
  }
  object { // LaufSp979->LaufSp
    LaufSp
    rotate <0.0, 0.0, -158.0>
    translate  <0.0, 0.0, 228.433007>
  }
  object { // LaufSp980->LaufSp
    LaufSp
    rotate <0.0, 0.0, -160.0>
    translate  <0.0, 0.0, 228.66634>
  }
  object { // LaufSp981->LaufSp
    LaufSp
    rotate <0.0, 0.0, -162.0>
    translate  <0.0, 0.0, 228.899673>
  }
  object { // LaufSp982->LaufSp
    LaufSp
    rotate <0.0, 0.0, -164.0>
    translate  <0.0, 0.0, 229.133006>
  }
  object { // LaufSp983->LaufSp
    LaufSp
    rotate <0.0, 0.0, -166.0>
    translate  <0.0, 0.0, 229.366339>
  }
  object { // LaufSp984->LaufSp
    LaufSp
    rotate <0.0, 0.0, -168.0>
    translate  <0.0, 0.0, 229.599672>
  }
  object { // LaufSp985->LaufSp
    LaufSp
    rotate <0.0, 0.0, -170.0>
    translate  <0.0, 0.0, 229.833005>
  }
  object { // LaufSp986->LaufSp
    LaufSp
    rotate <0.0, 0.0, -172.0>
    translate  <0.0, 0.0, 230.066338>
  }
  object { // LaufSp987->LaufSp
    LaufSp
    rotate <0.0, 0.0, -174.0>
    translate  <0.0, 0.0, 230.299671>
  }
  object { // LaufSp988->LaufSp
    LaufSp
    rotate <0.0, 0.0, -176.0>
    translate  <0.0, 0.0, 230.533004>
  }
  object { // LaufSp989->LaufSp
    LaufSp
    rotate <0.0, 0.0, -178.0>
    translate  <0.0, 0.0, 230.766337>
  }
  object { // LaufSp990->LaufSp
    LaufSp
    rotate <0.0, 0.0, 180.0>
    translate  <0.0, 0.0, 230.99967>
  }
  object { // LaufSp991->LaufSp
    LaufSp
    rotate <0.0, 0.0, 178.0>
    translate  <0.0, 0.0, 231.233003>
  }
  object { // LaufSp992->LaufSp
    LaufSp
    rotate <0.0, 0.0, 176.0>
    translate  <0.0, 0.0, 231.466336>
  }
  object { // LaufSp993->LaufSp
    LaufSp
    rotate <0.0, 0.0, 174.0>
    translate  <0.0, 0.0, 231.699669>
  }
  object { // LaufSp994->LaufSp
    LaufSp
    rotate <0.0, 0.0, 172.0>
    translate  <0.0, 0.0, 231.933002>
  }
  object { // LaufSp995->LaufSp
    LaufSp
    rotate <0.0, 0.0, 170.0>
    translate  <0.0, 0.0, 232.166335>
  }
  object { // LaufSp996->LaufSp
    LaufSp
    rotate <0.0, 0.0, 168.0>
    translate  <0.0, 0.0, 232.399668>
  }
  object { // LaufSp997->LaufSp
    LaufSp
    rotate <0.0, 0.0, 166.0>
    translate  <0.0, 0.0, 232.633001>
  }
  object { // LaufSp998->LaufSp
    LaufSp
    rotate <0.0, 0.0, 164.0>
    translate  <0.0, 0.0, 232.866334>
  }
  object { // LaufSp999->LaufSp
    LaufSp
    rotate <0.0, 0.0, 162.0>
    translate  <0.0, 0.0, 233.099667>
  }
  object { // LaufSp1000->LaufSp
    LaufSp
    rotate <0.0, 0.0, 160.0>
    translate  <0.0, 0.0, 233.333>
  }
  object { // LaufSp1001->LaufSp
    LaufSp
    rotate <0.0, 0.0, 158.0>
    translate  <0.0, 0.0, 233.566333>
  }
  object { // LaufSp1002->LaufSp
    LaufSp
    rotate <0.0, 0.0, 156.0>
    translate  <0.0, 0.0, 233.799666>
  }
  object { // LaufSp1003->LaufSp
    LaufSp
    rotate <0.0, 0.0, 154.0>
    translate  <0.0, 0.0, 234.032999>
  }
  object { // LaufSp1004->LaufSp
    LaufSp
    rotate <0.0, 0.0, 152.0>
    translate  <0.0, 0.0, 234.266332>
  }
  object { // LaufSp1005->LaufSp
    LaufSp
    rotate <0.0, 0.0, 150.0>
    translate  <0.0, 0.0, 234.499665>
  }
  object { // LaufSp1006->LaufSp
    LaufSp
    rotate <0.0, 0.0, 148.0>
    translate  <0.0, 0.0, 234.732998>
  }
  object { // LaufSp1007->LaufSp
    LaufSp
    rotate <0.0, 0.0, 146.0>
    translate  <0.0, 0.0, 234.966331>
  }
  object { // LaufSp1008->LaufSp
    LaufSp
    rotate <0.0, 0.0, 144.0>
    translate  <0.0, 0.0, 235.199664>
  }
  object { // LaufSp1009->LaufSp
    LaufSp
    rotate <0.0, 0.0, 142.0>
    translate  <0.0, 0.0, 235.432997>
  }
  object { // LaufSp1010->LaufSp
    LaufSp
    rotate <0.0, 0.0, 140.0>
    translate  <0.0, 0.0, 235.66633>
  }
  object { // LaufSp1011->LaufSp
    LaufSp
    rotate <0.0, 0.0, 138.0>
    translate  <0.0, 0.0, 235.899663>
  }
  object { // LaufSp1012->LaufSp
    LaufSp
    rotate <0.0, 0.0, 136.0>
    translate  <0.0, 0.0, 236.132996>
  }
  object { // LaufSp1013->LaufSp
    LaufSp
    rotate <0.0, 0.0, 134.0>
    translate  <0.0, 0.0, 236.366329>
  }
  object { // LaufSp1014->LaufSp
    LaufSp
    rotate <0.0, 0.0, 132.0>
    translate  <0.0, 0.0, 236.599662>
  }
  object { // LaufSp1015->LaufSp
    LaufSp
    rotate <0.0, 0.0, 130.0>
    translate  <0.0, 0.0, 236.832995>
  }
  object { // LaufSp1016->LaufSp
    LaufSp
    rotate <0.0, 0.0, 128.0>
    translate  <0.0, 0.0, 237.066328>
  }
  object { // LaufSp1017->LaufSp
    LaufSp
    rotate <0.0, 0.0, 126.0>
    translate  <0.0, 0.0, 237.299661>
  }
  object { // LaufSp1018->LaufSp
    LaufSp
    rotate <0.0, 0.0, 124.0>
    translate  <0.0, 0.0, 237.532994>
  }
  object { // LaufSp1019->LaufSp
    LaufSp
    rotate <0.0, 0.0, 122.0>
    translate  <0.0, 0.0, 237.766327>
  }
  object { // LaufSp1020->LaufSp
    LaufSp
    rotate <0.0, 0.0, 120.0>
    translate  <0.0, 0.0, 237.99966>
  }
  object { // LaufSp1021->LaufSp
    LaufSp
    rotate <0.0, 0.0, 118.0>
    translate  <0.0, 0.0, 238.232993>
  }
  object { // LaufSp1022->LaufSp
    LaufSp
    rotate <0.0, 0.0, 116.0>
    translate  <0.0, 0.0, 238.466326>
  }
  object { // LaufSp1023->LaufSp
    LaufSp
    rotate <0.0, 0.0, 114.0>
    translate  <0.0, 0.0, 238.699659>
  }
  object { // LaufSp1024->LaufSp
    LaufSp
    rotate <0.0, 0.0, 112.0>
    translate  <0.0, 0.0, 238.932992>
  }
  object { // LaufSp1025->LaufSp
    LaufSp
    rotate <0.0, 0.0, 110.0>
    translate  <0.0, 0.0, 239.166325>
  }
  object { // LaufSp1026->LaufSp
    LaufSp
    rotate <0.0, 0.0, 108.0>
    translate  <0.0, 0.0, 239.399658>
  }
  object { // LaufSp1027->LaufSp
    LaufSp
    rotate <0.0, 0.0, 106.0>
    translate  <0.0, 0.0, 239.632991>
  }
  object { // LaufSp1028->LaufSp
    LaufSp
    rotate <0.0, 0.0, 104.0>
    translate  <0.0, 0.0, 239.866324>
  }
  object { // LaufSp1029->LaufSp
    LaufSp
    rotate <0.0, 0.0, 102.0>
    translate  <0.0, 0.0, 240.099657>
  }
  object { // LaufSp1030->LaufSp
    LaufSp
    rotate <0.0, 0.0, 100.0>
    translate  <0.0, 0.0, 240.33299>
  }
  object { // LaufSp1031->LaufSp
    LaufSp
    rotate <0.0, 0.0, 98.0>
    translate  <0.0, 0.0, 240.566323>
  }
  object { // LaufSp1032->LaufSp
    LaufSp
    rotate <0.0, 0.0, 96.0>
    translate  <0.0, 0.0, 240.799656>
  }
  object { // LaufSp1033->LaufSp
    LaufSp
    rotate <0.0, 0.0, 94.0>
    translate  <0.0, 0.0, 241.032989>
  }
  object { // LaufSp1034->LaufSp
    LaufSp
    rotate <0.0, 0.0, 92.0>
    translate  <0.0, 0.0, 241.266322>
  }
  object { // LaufSp1035->LaufSp
    LaufSp
    rotate <0.0, 0.0, 90.0>
    translate  <0.0, 0.0, 241.499655>
  }
  object { // LaufSp1036->LaufSp
    LaufSp
    rotate <0.0, 0.0, 88.0>
    translate  <0.0, 0.0, 241.732988>
  }
  object { // LaufSp1037->LaufSp
    LaufSp
    rotate <0.0, 0.0, 86.0>
    translate  <0.0, 0.0, 241.966321>
  }
  object { // LaufSp1038->LaufSp
    LaufSp
    rotate <0.0, 0.0, 84.0>
    translate  <0.0, 0.0, 242.199654>
  }
  object { // LaufSp1039->LaufSp
    LaufSp
    rotate <0.0, 0.0, 82.0>
    translate  <0.0, 0.0, 242.432987>
  }
  object { // LaufSp1040->LaufSp
    LaufSp
    rotate <0.0, 0.0, 80.0>
    translate  <0.0, 0.0, 242.66632>
  }
  object { // LaufSp1041->LaufSp
    LaufSp
    rotate <0.0, 0.0, 78.0>
    translate  <0.0, 0.0, 242.899653>
  }
  object { // LaufSp1042->LaufSp
    LaufSp
    rotate <0.0, 0.0, 76.0>
    translate  <0.0, 0.0, 243.132986>
  }
  object { // LaufSp1043->LaufSp
    LaufSp
    rotate <0.0, 0.0, 74.0>
    translate  <0.0, 0.0, 243.366319>
  }
  object { // LaufSp1044->LaufSp
    LaufSp
    rotate <0.0, 0.0, 72.0>
    translate  <0.0, 0.0, 243.599652>
  }
  object { // LaufSp1045->LaufSp
    LaufSp
    rotate <0.0, 0.0, 70.0>
    translate  <0.0, 0.0, 243.832985>
  }
  object { // LaufSp1046->LaufSp
    LaufSp
    rotate <0.0, 0.0, 68.0>
    translate  <0.0, 0.0, 244.066318>
  }
  object { // LaufSp1047->LaufSp
    LaufSp
    rotate <0.0, 0.0, 66.0>
    translate  <0.0, 0.0, 244.299651>
  }
  object { // LaufSp1048->LaufSp
    LaufSp
    rotate <0.0, 0.0, 64.0>
    translate  <0.0, 0.0, 244.532984>
  }
  object { // LaufSp1049->LaufSp
    LaufSp
    rotate <0.0, 0.0, 62.0>
    translate  <0.0, 0.0, 244.766317>
  }
  object { // LaufSp1050->LaufSp
    LaufSp
    rotate <0.0, 0.0, 60.0>
    translate  <0.0, 0.0, 244.99965>
  }
  object { // LaufSp1051->LaufSp
    LaufSp
    rotate <0.0, 0.0, 58.0>
    translate  <0.0, 0.0, 245.232983>
  }
  object { // LaufSp1052->LaufSp
    LaufSp
    rotate <0.0, 0.0, 56.0>
    translate  <0.0, 0.0, 245.466316>
  }
  object { // LaufSp1053->LaufSp
    LaufSp
    rotate <0.0, 0.0, 54.0>
    translate  <0.0, 0.0, 245.699649>
  }
  object { // LaufSp1054->LaufSp
    LaufSp
    rotate <0.0, 0.0, 52.0>
    translate  <0.0, 0.0, 245.932982>
  }
  object { // LaufSp1055->LaufSp
    LaufSp
    rotate <0.0, 0.0, 50.0>
    translate  <0.0, 0.0, 246.166315>
  }
  object { // LaufSp1056->LaufSp
    LaufSp
    rotate <0.0, 0.0, 48.0>
    translate  <0.0, 0.0, 246.399648>
  }
  object { // LaufSp1057->LaufSp
    LaufSp
    rotate <0.0, 0.0, 46.0>
    translate  <0.0, 0.0, 246.632981>
  }
  object { // LaufSp1058->LaufSp
    LaufSp
    rotate <0.0, 0.0, 44.0>
    translate  <0.0, 0.0, 246.866314>
  }
  object { // LaufSp1059->LaufSp
    LaufSp
    rotate <0.0, 0.0, 42.0>
    translate  <0.0, 0.0, 247.099647>
  }
  object { // LaufSp1060->LaufSp
    LaufSp
    rotate <0.0, 0.0, 40.0>
    translate  <0.0, 0.0, 247.33298>
  }
  object { // LaufSp1061->LaufSp
    LaufSp
    rotate <0.0, 0.0, 38.0>
    translate  <0.0, 0.0, 247.566313>
  }
  object { // LaufSp1062->LaufSp
    LaufSp
    rotate <0.0, 0.0, 36.0>
    translate  <0.0, 0.0, 247.799646>
  }
  object { // LaufSp1063->LaufSp
    LaufSp
    rotate <0.0, 0.0, 34.0>
    translate  <0.0, 0.0, 248.032979>
  }
  object { // LaufSp1064->LaufSp
    LaufSp
    rotate <0.0, 0.0, 32.0>
    translate  <0.0, 0.0, 248.266312>
  }
  object { // LaufSp1065->LaufSp
    LaufSp
    rotate <0.0, 0.0, 30.0>
    translate  <0.0, 0.0, 248.499645>
  }
  object { // LaufSp1066->LaufSp
    LaufSp
    rotate <0.0, 0.0, 28.0>
    translate  <0.0, 0.0, 248.732978>
  }
  object { // LaufSp1067->LaufSp
    LaufSp
    rotate <0.0, 0.0, 26.0>
    translate  <0.0, 0.0, 248.966311>
  }
  object { // LaufSp1068->LaufSp
    LaufSp
    rotate <0.0, 0.0, 24.0>
    translate  <0.0, 0.0, 249.199644>
  }
  object { // LaufSp1069->LaufSp
    LaufSp
    rotate <0.0, 0.0, 22.0>
    translate  <0.0, 0.0, 249.432977>
  }
  object { // LaufSp1070->LaufSp
    LaufSp
    rotate <0.0, 0.0, 20.0>
    translate  <0.0, 0.0, 249.66631>
  }
  object { // LaufSp1071->LaufSp
    LaufSp
    rotate <0.0, 0.0, 18.0>
    translate  <0.0, 0.0, 249.899643>
  }
  object { // LaufSp1072->LaufSp
    LaufSp
    rotate <0.0, 0.0, 16.0>
    translate  <0.0, 0.0, 250.132976>
  }
  object { // LaufSp1073->LaufSp
    LaufSp
    rotate <0.0, 0.0, 14.0>
    translate  <0.0, 0.0, 250.366309>
  }
  object { // LaufSp1074->LaufSp
    LaufSp
    rotate <0.0, 0.0, 12.0>
    translate  <0.0, 0.0, 250.599642>
  }
  object { // LaufSp1075->LaufSp
    LaufSp
    rotate <0.0, 0.0, 10.0>
    translate  <0.0, 0.0, 250.832975>
  }
  object { // LaufSp1076->LaufSp
    LaufSp
    rotate <0.0, 0.0, 8.0>
    translate  <0.0, 0.0, 251.066308>
  }
  object { // LaufSp1077->LaufSp
    LaufSp
    rotate <0.0, 0.0, 6.0>
    translate  <0.0, 0.0, 251.299641>
  }
  object { // LaufSp1078->LaufSp
    LaufSp
    rotate <0.0, 0.0, 4.0>
    translate  <0.0, 0.0, 251.532974>
  }
  object { // LaufSp1079->LaufSp
    LaufSp
    rotate <0.0, 0.0, 2.0>
    translate  <0.0, 0.0, 251.766307>
  }
  object { // LaufSp1080->LaufSp
    LaufSp
    rotate <0.0, 0.0, 0.0>
    translate  <0.0, 0.0, 251.99964>
  }
  object { // LaufSp1081->LaufSp
    LaufSp
    rotate <0.0, 0.0, -2.0>
    translate  <0.0, 0.0, 252.232973>
  }
  object { // LaufSp1082->LaufSp
    LaufSp
    rotate <0.0, 0.0, -4.0>
    translate  <0.0, 0.0, 252.466306>
  }
  object { // LaufSp1083->LaufSp
    LaufSp
    rotate <0.0, 0.0, -6.0>
    translate  <0.0, 0.0, 252.699639>
  }
  object { // LaufSp1084->LaufSp
    LaufSp
    rotate <0.0, 0.0, -8.0>
    translate  <0.0, 0.0, 252.932972>
  }
  object { // LaufSp1085->LaufSp
    LaufSp
    rotate <0.0, 0.0, -10.0>
    translate  <0.0, 0.0, 253.166305>
  }
  object { // LaufSp1086->LaufSp
    LaufSp
    rotate <0.0, 0.0, -12.0>
    translate  <0.0, 0.0, 253.399638>
  }
  object { // LaufSp1087->LaufSp
    LaufSp
    rotate <0.0, 0.0, -14.0>
    translate  <0.0, 0.0, 253.632971>
  }
  object { // LaufSp1088->LaufSp
    LaufSp
    rotate <0.0, 0.0, -16.0>
    translate  <0.0, 0.0, 253.866304>
  }
  object { // LaufSp1089->LaufSp
    LaufSp
    rotate <0.0, 0.0, -18.0>
    translate  <0.0, 0.0, 254.099637>
  }
  object { // LaufSp1090->LaufSp
    LaufSp
    rotate <0.0, 0.0, -20.0>
    translate  <0.0, 0.0, 254.33297>
  }
  object { // LaufSp1091->LaufSp
    LaufSp
    rotate <0.0, 0.0, -22.0>
    translate  <0.0, 0.0, 254.566303>
  }
  object { // LaufSp1092->LaufSp
    LaufSp
    rotate <0.0, 0.0, -24.0>
    translate  <0.0, 0.0, 254.799636>
  }
  object { // LaufSp1093->LaufSp
    LaufSp
    rotate <0.0, 0.0, -26.0>
    translate  <0.0, 0.0, 255.032969>
  }
  object { // LaufSp1094->LaufSp
    LaufSp
    rotate <0.0, 0.0, -28.0>
    translate  <0.0, 0.0, 255.266302>
  }
  object { // LaufSp1095->LaufSp
    LaufSp
    rotate <0.0, 0.0, -30.0>
    translate  <0.0, 0.0, 255.499635>
  }
  object { // LaufSp1096->LaufSp
    LaufSp
    rotate <0.0, 0.0, -32.0>
    translate  <0.0, 0.0, 255.732968>
  }
  object { // LaufSp1097->LaufSp
    LaufSp
    rotate <0.0, 0.0, -34.0>
    translate  <0.0, 0.0, 255.966301>
  }
  object { // LaufSp1098->LaufSp
    LaufSp
    rotate <0.0, 0.0, -36.0>
    translate  <0.0, 0.0, 256.199634>
  }
  object { // LaufSp1099->LaufSp
    LaufSp
    rotate <0.0, 0.0, -38.0>
    translate  <0.0, 0.0, 256.432967>
  }
  object { // LaufSp1100->LaufSp
    LaufSp
    rotate <0.0, 0.0, -40.0>
    translate  <0.0, 0.0, 256.6663>
  }
  object { // LaufSp1101->LaufSp
    LaufSp
    rotate <0.0, 0.0, -42.0>
    translate  <0.0, 0.0, 256.899633>
  }
  object { // LaufSp1102->LaufSp
    LaufSp
    rotate <0.0, 0.0, -44.0>
    translate  <0.0, 0.0, 257.132966>
  }
  object { // LaufSp1103->LaufSp
    LaufSp
    rotate <0.0, 0.0, -46.0>
    translate  <0.0, 0.0, 257.366299>
  }
  object { // LaufSp1104->LaufSp
    LaufSp
    rotate <0.0, 0.0, -48.0>
    translate  <0.0, 0.0, 257.599632>
  }
  object { // LaufSp1105->LaufSp
    LaufSp
    rotate <0.0, 0.0, -50.0>
    translate  <0.0, 0.0, 257.832965>
  }
  object { // LaufSp1106->LaufSp
    LaufSp
    rotate <0.0, 0.0, -52.0>
    translate  <0.0, 0.0, 258.066298>
  }
  object { // LaufSp1107->LaufSp
    LaufSp
    rotate <0.0, 0.0, -54.0>
    translate  <0.0, 0.0, 258.299631>
  }
  object { // LaufSp1108->LaufSp
    LaufSp
    rotate <0.0, 0.0, -56.0>
    translate  <0.0, 0.0, 258.532964>
  }
  object { // LaufSp1109->LaufSp
    LaufSp
    rotate <0.0, 0.0, -58.0>
    translate  <0.0, 0.0, 258.766297>
  }
  object { // LaufSp1110->LaufSp
    LaufSp
    rotate <0.0, 0.0, -60.0>
    translate  <0.0, 0.0, 258.99963>
  }
  object { // LaufSp1111->LaufSp
    LaufSp
    rotate <0.0, 0.0, -62.0>
    translate  <0.0, 0.0, 259.232963>
  }
  object { // LaufSp1112->LaufSp
    LaufSp
    rotate <0.0, 0.0, -64.0>
    translate  <0.0, 0.0, 259.466296>
  }
  object { // LaufSp1113->LaufSp
    LaufSp
    rotate <0.0, 0.0, -66.0>
    translate  <0.0, 0.0, 259.699629>
  }
  object { // LaufSp1114->LaufSp
    LaufSp
    rotate <0.0, 0.0, -68.0>
    translate  <0.0, 0.0, 259.932962>
  }
  object { // LaufSp1115->LaufSp
    LaufSp
    rotate <0.0, 0.0, -70.0>
    translate  <0.0, 0.0, 260.166295>
  }
  object { // LaufSp1116->LaufSp
    LaufSp
    rotate <0.0, 0.0, -72.0>
    translate  <0.0, 0.0, 260.399628>
  }
  object { // LaufSp1117->LaufSp
    LaufSp
    rotate <0.0, 0.0, -74.0>
    translate  <0.0, 0.0, 260.632961>
  }
  object { // LaufSp1118->LaufSp
    LaufSp
    rotate <0.0, 0.0, -76.0>
    translate  <0.0, 0.0, 260.866294>
  }
  object { // LaufSp1119->LaufSp
    LaufSp
    rotate <0.0, 0.0, -78.0>
    translate  <0.0, 0.0, 261.099627>
  }
  object { // LaufSp1120->LaufSp
    LaufSp
    rotate <0.0, 0.0, -80.0>
    translate  <0.0, 0.0, 261.33296>
  }
  object { // LaufSp1121->LaufSp
    LaufSp
    rotate <0.0, 0.0, -82.0>
    translate  <0.0, 0.0, 261.566293>
  }
  object { // LaufSp1122->LaufSp
    LaufSp
    rotate <0.0, 0.0, -84.0>
    translate  <0.0, 0.0, 261.799626>
  }
  object { // LaufSp1123->LaufSp
    LaufSp
    rotate <0.0, 0.0, -86.0>
    translate  <0.0, 0.0, 262.032959>
  }
  object { // LaufSp1124->LaufSp
    LaufSp
    rotate <0.0, 0.0, -88.0>
    translate  <0.0, 0.0, 262.266292>
  }
  object { // LaufSp1125->LaufSp
    LaufSp
    rotate <0.0, 0.0, -90.0>
    translate  <0.0, 0.0, 262.499625>
  }
  object { // LaufSp1126->LaufSp
    LaufSp
    rotate <0.0, 0.0, -92.0>
    translate  <0.0, 0.0, 262.732958>
  }
  object { // LaufSp1127->LaufSp
    LaufSp
    rotate <0.0, 0.0, -94.0>
    translate  <0.0, 0.0, 262.966291>
  }
  object { // LaufSp1128->LaufSp
    LaufSp
    rotate <0.0, 0.0, -96.0>
    translate  <0.0, 0.0, 263.199624>
  }
  object { // LaufSp1129->LaufSp
    LaufSp
    rotate <0.0, 0.0, -98.0>
    translate  <0.0, 0.0, 263.432957>
  }
  object { // LaufSp1130->LaufSp
    LaufSp
    rotate <0.0, 0.0, -100.0>
    translate  <0.0, 0.0, 263.66629>
  }
  object { // LaufSp1131->LaufSp
    LaufSp
    rotate <0.0, 0.0, -102.0>
    translate  <0.0, 0.0, 263.899623>
  }
  object { // LaufSp1132->LaufSp
    LaufSp
    rotate <0.0, 0.0, -104.0>
    translate  <0.0, 0.0, 264.132956>
  }
  object { // LaufSp1133->LaufSp
    LaufSp
    rotate <0.0, 0.0, -106.0>
    translate  <0.0, 0.0, 264.366289>
  }
  object { // LaufSp1134->LaufSp
    LaufSp
    rotate <0.0, 0.0, -108.0>
    translate  <0.0, 0.0, 264.599622>
  }
  object { // LaufSp1135->LaufSp
    LaufSp
    rotate <0.0, 0.0, -110.0>
    translate  <0.0, 0.0, 264.832955>
  }
  object { // LaufSp1136->LaufSp
    LaufSp
    rotate <0.0, 0.0, -112.0>
    translate  <0.0, 0.0, 265.066288>
  }
  object { // LaufSp1137->LaufSp
    LaufSp
    rotate <0.0, 0.0, -114.0>
    translate  <0.0, 0.0, 265.299621>
  }
  object { // LaufSp1138->LaufSp
    LaufSp
    rotate <0.0, 0.0, -116.0>
    translate  <0.0, 0.0, 265.532954>
  }
  object { // LaufSp1139->LaufSp
    LaufSp
    rotate <0.0, 0.0, -118.0>
    translate  <0.0, 0.0, 265.766287>
  }
  object { // LaufSp1140->LaufSp
    LaufSp
    rotate <0.0, 0.0, -120.0>
    translate  <0.0, 0.0, 265.99962>
  }
  object { // LaufSp1141->LaufSp
    LaufSp
    rotate <0.0, 0.0, -122.0>
    translate  <0.0, 0.0, 266.232953>
  }
  object { // LaufSp1142->LaufSp
    LaufSp
    rotate <0.0, 0.0, -124.0>
    translate  <0.0, 0.0, 266.466286>
  }
  object { // LaufSp1143->LaufSp
    LaufSp
    rotate <0.0, 0.0, -126.0>
    translate  <0.0, 0.0, 266.699619>
  }
  object { // LaufSp1144->LaufSp
    LaufSp
    rotate <0.0, 0.0, -128.0>
    translate  <0.0, 0.0, 266.932952>
  }
  object { // LaufSp1145->LaufSp
    LaufSp
    rotate <0.0, 0.0, -130.0>
    translate  <0.0, 0.0, 267.166285>
  }
  object { // LaufSp1146->LaufSp
    LaufSp
    rotate <0.0, 0.0, -132.0>
    translate  <0.0, 0.0, 267.399618>
  }
  object { // LaufSp1147->LaufSp
    LaufSp
    rotate <0.0, 0.0, -134.0>
    translate  <0.0, 0.0, 267.632951>
  }
  object { // LaufSp1148->LaufSp
    LaufSp
    rotate <0.0, 0.0, -136.0>
    translate  <0.0, 0.0, 267.866284>
  }
  object { // LaufSp1149->LaufSp
    LaufSp
    rotate <0.0, 0.0, -138.0>
    translate  <0.0, 0.0, 268.099617>
  }
  object { // LaufSp1150->LaufSp
    LaufSp
    rotate <0.0, 0.0, -140.0>
    translate  <0.0, 0.0, 268.33295>
  }
  object { // LaufSp1151->LaufSp
    LaufSp
    rotate <0.0, 0.0, -142.0>
    translate  <0.0, 0.0, 268.566283>
  }
  object { // LaufSp1152->LaufSp
    LaufSp
    rotate <0.0, 0.0, -144.0>
    translate  <0.0, 0.0, 268.799616>
  }
  object { // LaufSp1153->LaufSp
    LaufSp
    rotate <0.0, 0.0, -146.0>
    translate  <0.0, 0.0, 269.032949>
  }
  object { // LaufSp1154->LaufSp
    LaufSp
    rotate <0.0, 0.0, -148.0>
    translate  <0.0, 0.0, 269.266282>
  }
  object { // LaufSp1155->LaufSp
    LaufSp
    rotate <0.0, 0.0, -150.0>
    translate  <0.0, 0.0, 269.499615>
  }
  object { // LaufSp1156->LaufSp
    LaufSp
    rotate <0.0, 0.0, -152.0>
    translate  <0.0, 0.0, 269.732948>
  }
  object { // LaufSp1157->LaufSp
    LaufSp
    rotate <0.0, 0.0, -154.0>
    translate  <0.0, 0.0, 269.966281>
  }
  object { // LaufSp1158->LaufSp
    LaufSp
    rotate <0.0, 0.0, -156.0>
    translate  <0.0, 0.0, 270.199614>
  }
  object { // LaufSp1159->LaufSp
    LaufSp
    rotate <0.0, 0.0, -158.0>
    translate  <0.0, 0.0, 270.432947>
  }
  object { // LaufSp1160->LaufSp
    LaufSp
    rotate <0.0, 0.0, -160.0>
    translate  <0.0, 0.0, 270.66628>
  }
  object { // LaufSp1161->LaufSp
    LaufSp
    rotate <0.0, 0.0, -162.0>
    translate  <0.0, 0.0, 270.899613>
  }
  object { // LaufSp1162->LaufSp
    LaufSp
    rotate <0.0, 0.0, -164.0>
    translate  <0.0, 0.0, 271.132946>
  }
  object { // LaufSp1163->LaufSp
    LaufSp
    rotate <0.0, 0.0, -166.0>
    translate  <0.0, 0.0, 271.366279>
  }
  object { // LaufSp1164->LaufSp
    LaufSp
    rotate <0.0, 0.0, -168.0>
    translate  <0.0, 0.0, 271.599612>
  }
  object { // LaufSp1165->LaufSp
    LaufSp
    rotate <0.0, 0.0, -170.0>
    translate  <0.0, 0.0, 271.832945>
  }
  object { // LaufSp1166->LaufSp
    LaufSp
    rotate <0.0, 0.0, -172.0>
    translate  <0.0, 0.0, 272.066278>
  }
  object { // LaufSp1167->LaufSp
    LaufSp
    rotate <0.0, 0.0, -174.0>
    translate  <0.0, 0.0, 272.299611>
  }
  object { // LaufSp1168->LaufSp
    LaufSp
    rotate <0.0, 0.0, -176.0>
    translate  <0.0, 0.0, 272.532944>
  }
  object { // LaufSp1169->LaufSp
    LaufSp
    rotate <0.0, 0.0, -178.0>
    translate  <0.0, 0.0, 272.766277>
  }
  object { // LaufSp1170->LaufSp
    LaufSp
    rotate <0.0, 0.0, 180.0>
    translate  <0.0, 0.0, 272.99961>
  }
  object { // LaufSp1171->LaufSp
    LaufSp
    rotate <0.0, 0.0, 178.0>
    translate  <0.0, 0.0, 273.232943>
  }
  object { // LaufSp1172->LaufSp
    LaufSp
    rotate <0.0, 0.0, 176.0>
    translate  <0.0, 0.0, 273.466276>
  }
  object { // LaufSp1173->LaufSp
    LaufSp
    rotate <0.0, 0.0, 174.0>
    translate  <0.0, 0.0, 273.699609>
  }
  object { // LaufSp1174->LaufSp
    LaufSp
    rotate <0.0, 0.0, 172.0>
    translate  <0.0, 0.0, 273.932942>
  }
  object { // LaufSp1175->LaufSp
    LaufSp
    rotate <0.0, 0.0, 170.0>
    translate  <0.0, 0.0, 274.166275>
  }
  object { // LaufSp1176->LaufSp
    LaufSp
    rotate <0.0, 0.0, 168.0>
    translate  <0.0, 0.0, 274.399608>
  }
  object { // LaufSp1177->LaufSp
    LaufSp
    rotate <0.0, 0.0, 166.0>
    translate  <0.0, 0.0, 274.632941>
  }
  object { // LaufSp1178->LaufSp
    LaufSp
    rotate <0.0, 0.0, 164.0>
    translate  <0.0, 0.0, 274.866274>
  }
  object { // LaufSp1179->LaufSp
    LaufSp
    rotate <0.0, 0.0, 162.0>
    translate  <0.0, 0.0, 275.099607>
  }
  object { // LaufSp1180->LaufSp
    LaufSp
    rotate <0.0, 0.0, 160.0>
    translate  <0.0, 0.0, 275.33294>
  }
  object { // LaufSp1181->LaufSp
    LaufSp
    rotate <0.0, 0.0, 158.0>
    translate  <0.0, 0.0, 275.566273>
  }
  object { // LaufSp1182->LaufSp
    LaufSp
    rotate <0.0, 0.0, 156.0>
    translate  <0.0, 0.0, 275.799606>
  }
  object { // LaufSp1183->LaufSp
    LaufSp
    rotate <0.0, 0.0, 154.0>
    translate  <0.0, 0.0, 276.032939>
  }
  object { // LaufSp1184->LaufSp
    LaufSp
    rotate <0.0, 0.0, 152.0>
    translate  <0.0, 0.0, 276.266272>
  }
  object { // LaufSp1185->LaufSp
    LaufSp
    rotate <0.0, 0.0, 150.0>
    translate  <0.0, 0.0, 276.499605>
  }
  object { // LaufSp1186->LaufSp
    LaufSp
    rotate <0.0, 0.0, 148.0>
    translate  <0.0, 0.0, 276.732938>
  }
  object { // LaufSp1187->LaufSp
    LaufSp
    rotate <0.0, 0.0, 146.0>
    translate  <0.0, 0.0, 276.966271>
  }
  object { // LaufSp1188->LaufSp
    LaufSp
    rotate <0.0, 0.0, 144.0>
    translate  <0.0, 0.0, 277.199604>
  }
  object { // LaufSp1189->LaufSp
    LaufSp
    rotate <0.0, 0.0, 142.0>
    translate  <0.0, 0.0, 277.432937>
  }
  object { // LaufSp1190->LaufSp
    LaufSp
    rotate <0.0, 0.0, 140.0>
    translate  <0.0, 0.0, 277.66627>
  }
  object { // LaufSp1191->LaufSp
    LaufSp
    rotate <0.0, 0.0, 138.0>
    translate  <0.0, 0.0, 277.899603>
  }
  object { // LaufSp1192->LaufSp
    LaufSp
    rotate <0.0, 0.0, 136.0>
    translate  <0.0, 0.0, 278.132936>
  }
  object { // LaufSp1193->LaufSp
    LaufSp
    rotate <0.0, 0.0, 134.0>
    translate  <0.0, 0.0, 278.366269>
  }
  object { // LaufSp1194->LaufSp
    LaufSp
    rotate <0.0, 0.0, 132.0>
    translate  <0.0, 0.0, 278.599602>
  }
  object { // LaufSp1195->LaufSp
    LaufSp
    rotate <0.0, 0.0, 130.0>
    translate  <0.0, 0.0, 278.832935>
  }
  object { // LaufSp1196->LaufSp
    LaufSp
    rotate <0.0, 0.0, 128.0>
    translate  <0.0, 0.0, 279.066268>
  }
  object { // LaufSp1197->LaufSp
    LaufSp
    rotate <0.0, 0.0, 126.0>
    translate  <0.0, 0.0, 279.299601>
  }
  object { // LaufSp1198->LaufSp
    LaufSp
    rotate <0.0, 0.0, 124.0>
    translate  <0.0, 0.0, 279.532934>
  }
  object { // LaufSp1199->LaufSp
    LaufSp
    rotate <0.0, 0.0, 122.0>
    translate  <0.0, 0.0, 279.766267>
  }
  object { // LaufSp1200->LaufSp
    LaufSp
    rotate <0.0, 0.0, 120.0>
    translate  <0.0, 0.0, 279.9996>
  }
  object { // LaufSp1201->LaufSp
    LaufSp
    rotate <0.0, 0.0, 118.0>
    translate  <0.0, 0.0, 280.232933>
  }
  object { // LaufSp1202->LaufSp
    LaufSp
    rotate <0.0, 0.0, 116.0>
    translate  <0.0, 0.0, 280.466266>
  }
  object { // LaufSp1203->LaufSp
    LaufSp
    rotate <0.0, 0.0, 114.0>
    translate  <0.0, 0.0, 280.699599>
  }
  object { // LaufSp1204->LaufSp
    LaufSp
    rotate <0.0, 0.0, 112.0>
    translate  <0.0, 0.0, 280.932932>
  }
  object { // LaufSp1205->LaufSp
    LaufSp
    rotate <0.0, 0.0, 110.0>
    translate  <0.0, 0.0, 281.166265>
  }
  object { // LaufSp1206->LaufSp
    LaufSp
    rotate <0.0, 0.0, 108.0>
    translate  <0.0, 0.0, 281.399598>
  }
  object { // LaufSp1207->LaufSp
    LaufSp
    rotate <0.0, 0.0, 106.0>
    translate  <0.0, 0.0, 281.632931>
  }
  object { // LaufSp1208->LaufSp
    LaufSp
    rotate <0.0, 0.0, 104.0>
    translate  <0.0, 0.0, 281.866264>
  }
  object { // LaufSp1209->LaufSp
    LaufSp
    rotate <0.0, 0.0, 102.0>
    translate  <0.0, 0.0, 282.099597>
  }
  object { // LaufSp1210->LaufSp
    LaufSp
    rotate <0.0, 0.0, 100.0>
    translate  <0.0, 0.0, 282.33293>
  }
  object { // LaufSp1211->LaufSp
    LaufSp
    rotate <0.0, 0.0, 98.0>
    translate  <0.0, 0.0, 282.566263>
  }
  object { // LaufSp1212->LaufSp
    LaufSp
    rotate <0.0, 0.0, 96.0>
    translate  <0.0, 0.0, 282.799596>
  }
  object { // LaufSp1213->LaufSp
    LaufSp
    rotate <0.0, 0.0, 94.0>
    translate  <0.0, 0.0, 283.032929>
  }
  object { // LaufSp1214->LaufSp
    LaufSp
    rotate <0.0, 0.0, 92.0>
    translate  <0.0, 0.0, 283.266262>
  }
  object { // LaufSp1215->LaufSp
    LaufSp
    rotate <0.0, 0.0, 90.0>
    translate  <0.0, 0.0, 283.499595>
  }
  object { // LaufSp1216->LaufSp
    LaufSp
    rotate <0.0, 0.0, 88.0>
    translate  <0.0, 0.0, 283.732928>
  }
  object { // LaufSp1217->LaufSp
    LaufSp
    rotate <0.0, 0.0, 86.0>
    translate  <0.0, 0.0, 283.966261>
  }
  object { // LaufSp1218->LaufSp
    LaufSp
    rotate <0.0, 0.0, 84.0>
    translate  <0.0, 0.0, 284.199594>
  }
  object { // LaufSp1219->LaufSp
    LaufSp
    rotate <0.0, 0.0, 82.0>
    translate  <0.0, 0.0, 284.432927>
  }
  object { // LaufSp1220->LaufSp
    LaufSp
    rotate <0.0, 0.0, 80.0>
    translate  <0.0, 0.0, 284.66626>
  }
  object { // LaufSp1221->LaufSp
    LaufSp
    rotate <0.0, 0.0, 78.0>
    translate  <0.0, 0.0, 284.899593>
  }
  object { // LaufSp1222->LaufSp
    LaufSp
    rotate <0.0, 0.0, 76.0>
    translate  <0.0, 0.0, 285.132926>
  }
  object { // LaufSp1223->LaufSp
    LaufSp
    rotate <0.0, 0.0, 74.0>
    translate  <0.0, 0.0, 285.366259>
  }
  object { // LaufSp1224->LaufSp
    LaufSp
    rotate <0.0, 0.0, 72.0>
    translate  <0.0, 0.0, 285.599592>
  }
  object { // LaufSp1225->LaufSp
    LaufSp
    rotate <0.0, 0.0, 70.0>
    translate  <0.0, 0.0, 285.832925>
  }
  object { // LaufSp1226->LaufSp
    LaufSp
    rotate <0.0, 0.0, 68.0>
    translate  <0.0, 0.0, 286.066258>
  }
  object { // LaufSp1227->LaufSp
    LaufSp
    rotate <0.0, 0.0, 66.0>
    translate  <0.0, 0.0, 286.299591>
  }
  object { // LaufSp1228->LaufSp
    LaufSp
    rotate <0.0, 0.0, 64.0>
    translate  <0.0, 0.0, 286.532924>
  }
  object { // LaufSp1229->LaufSp
    LaufSp
    rotate <0.0, 0.0, 62.0>
    translate  <0.0, 0.0, 286.766257>
  }
  object { // LaufSp1230->LaufSp
    LaufSp
    rotate <0.0, 0.0, 60.0>
    translate  <0.0, 0.0, 286.99959>
  }
  object { // LaufSp1231->LaufSp
    LaufSp
    rotate <0.0, 0.0, 58.0>
    translate  <0.0, 0.0, 287.232923>
  }
  object { // LaufSp1232->LaufSp
    LaufSp
    rotate <0.0, 0.0, 56.0>
    translate  <0.0, 0.0, 287.466256>
  }
  object { // LaufSp1233->LaufSp
    LaufSp
    rotate <0.0, 0.0, 54.0>
    translate  <0.0, 0.0, 287.699589>
  }
  object { // LaufSp1234->LaufSp
    LaufSp
    rotate <0.0, 0.0, 52.0>
    translate  <0.0, 0.0, 287.932922>
  }
  object { // LaufSp1235->LaufSp
    LaufSp
    rotate <0.0, 0.0, 50.0>
    translate  <0.0, 0.0, 288.166255>
  }
  object { // LaufSp1236->LaufSp
    LaufSp
    rotate <0.0, 0.0, 48.0>
    translate  <0.0, 0.0, 288.399588>
  }
  object { // LaufSp1237->LaufSp
    LaufSp
    rotate <0.0, 0.0, 46.0>
    translate  <0.0, 0.0, 288.632921>
  }
  object { // LaufSp1238->LaufSp
    LaufSp
    rotate <0.0, 0.0, 44.0>
    translate  <0.0, 0.0, 288.866254>
  }
  object { // LaufSp1239->LaufSp
    LaufSp
    rotate <0.0, 0.0, 42.0>
    translate  <0.0, 0.0, 289.099587>
  }
  object { // LaufSp1240->LaufSp
    LaufSp
    rotate <0.0, 0.0, 40.0>
    translate  <0.0, 0.0, 289.33292>
  }
  object { // LaufSp1241->LaufSp
    LaufSp
    rotate <0.0, 0.0, 38.0>
    translate  <0.0, 0.0, 289.566253>
  }
  object { // LaufSp1242->LaufSp
    LaufSp
    rotate <0.0, 0.0, 36.0>
    translate  <0.0, 0.0, 289.799586>
  }
  object { // LaufSp1243->LaufSp
    LaufSp
    rotate <0.0, 0.0, 34.0>
    translate  <0.0, 0.0, 290.032919>
  }
  object { // LaufSp1244->LaufSp
    LaufSp
    rotate <0.0, 0.0, 32.0>
    translate  <0.0, 0.0, 290.266252>
  }
  object { // LaufSp1245->LaufSp
    LaufSp
    rotate <0.0, 0.0, 30.0>
    translate  <0.0, 0.0, 290.499585>
  }
  object { // LaufSp1246->LaufSp
    LaufSp
    rotate <0.0, 0.0, 28.0>
    translate  <0.0, 0.0, 290.732918>
  }
  object { // LaufSp1247->LaufSp
    LaufSp
    rotate <0.0, 0.0, 26.0>
    translate  <0.0, 0.0, 290.966251>
  }
  object { // LaufSp1248->LaufSp
    LaufSp
    rotate <0.0, 0.0, 24.0>
    translate  <0.0, 0.0, 291.199584>
  }
  object { // LaufSp1249->LaufSp
    LaufSp
    rotate <0.0, 0.0, 22.0>
    translate  <0.0, 0.0, 291.432917>
  }
  object { // LaufSp1250->LaufSp
    LaufSp
    rotate <0.0, 0.0, 20.0>
    translate  <0.0, 0.0, 291.66625>
  }
  object { // LaufSp1251->LaufSp
    LaufSp
    rotate <0.0, 0.0, 18.0>
    translate  <0.0, 0.0, 291.899583>
  }
  object { // LaufSp1252->LaufSp
    LaufSp
    rotate <0.0, 0.0, 16.0>
    translate  <0.0, 0.0, 292.132916>
  }
  object { // LaufSp1253->LaufSp
    LaufSp
    rotate <0.0, 0.0, 14.0>
    translate  <0.0, 0.0, 292.366249>
  }
  object { // LaufSp1254->LaufSp
    LaufSp
    rotate <0.0, 0.0, 12.0>
    translate  <0.0, 0.0, 292.599582>
  }
  object { // LaufSp1255->LaufSp
    LaufSp
    rotate <0.0, 0.0, 10.0>
    translate  <0.0, 0.0, 292.832915>
  }
  object { // LaufSp1256->LaufSp
    LaufSp
    rotate <0.0, 0.0, 8.0>
    translate  <0.0, 0.0, 293.066248>
  }
  object { // LaufSp1257->LaufSp
    LaufSp
    rotate <0.0, 0.0, 6.0>
    translate  <0.0, 0.0, 293.299581>
  }
  object { // LaufSp1258->LaufSp
    LaufSp
    rotate <0.0, 0.0, 4.0>
    translate  <0.0, 0.0, 293.532914>
  }
  object { // LaufSp1259->LaufSp
    LaufSp
    rotate <0.0, 0.0, 2.0>
    translate  <0.0, 0.0, 293.766247>
  }
  object { // LaufSp1260->LaufSp
    LaufSp
    rotate <0.0, 0.0, 0.0>
    translate  <0.0, 0.0, 293.99958>
  }
}


union { // Stiege
  object { Stufe }
  object { // Stufe1->Stufe
    Stufe
    rotate -6.0*z
    translate  <0.0, 0.0, 0.7>
  }
  object { // Stufe2->Stufe
    Stufe
    rotate -12.0*z
    translate  <0.0, 0.0, 1.4>
  }
  object { // Stufe3->Stufe
    Stufe
    rotate -18.0*z
    translate  <0.0, 0.0, 2.1>
  }
  object { // Stufe4->Stufe
    Stufe
    rotate -24.0*z
    translate  <0.0, 0.0, 2.8>
  }
  object { // Stufe5->Stufe
    Stufe
    rotate -30.0*z
    translate  <0.0, 0.0, 3.5>
  }
  object { // Stufe6->Stufe
    Stufe
    rotate -36.0*z
    translate  <0.0, 0.0, 4.2>
  }
  object { // Stufe7->Stufe
    Stufe
    rotate -42.0*z
    translate  <0.0, 0.0, 4.9>
  }
  object { // Stufe8->Stufe
    Stufe
    rotate -48.0*z
    translate  <0.0, 0.0, 5.6>
  }
  object { // Stufe9->Stufe
    Stufe
    rotate -54.0*z
    translate  <0.0, 0.0, 6.3>
  }
  object { // Stufe10->Stufe
    Stufe
    rotate -60.0*z
    translate  <0.0, 0.0, 7.0>
  }
  object { // Stufe11->Stufe
    Stufe
    rotate -66.0*z
    translate  <0.0, 0.0, 7.7>
  }
  object { // Stufe12->Stufe
    Stufe
    rotate -72.0*z
    translate  <0.0, 0.0, 8.4>
  }
  object { // Stufe13->Stufe
    Stufe
    rotate -78.0*z
    translate  <0.0, 0.0, 9.1>
  }
  object { // Stufe14->Stufe
    Stufe
    rotate -84.0*z
    translate  <0.0, 0.0, 9.8>
  }
  object { // Stufe15->Stufe
    Stufe
    rotate -90.0*z
    translate  <0.0, 0.0, 10.5>
  }
  object { // Stufe16->Stufe
    Stufe
    rotate -96.0*z
    translate  <0.0, 0.0, 11.2>
  }
  object { // Stufe17->Stufe
    Stufe
    rotate -102.0*z
    translate  <0.0, 0.0, 11.9>
  }
  object { // Stufe18->Stufe
    Stufe
    rotate -108.0*z
    translate  <0.0, 0.0, 12.6>
  }
  object { // Stufe19->Stufe
    Stufe
    rotate -114.0*z
    translate  <0.0, 0.0, 13.3>
  }
  object { // Stufe20->Stufe
    Stufe
    rotate -120.0*z
    translate  <0.0, 0.0, 14.0>
  }
  object { // Stufe21->Stufe
    Stufe
    rotate -126.0*z
    translate  <0.0, 0.0, 14.7>
  }
  object { // Stufe22->Stufe
    Stufe
    rotate -132.0*z
    translate  <0.0, 0.0, 15.4>
  }
  object { // Stufe23->Stufe
    Stufe
    rotate -138.0*z
    translate  <0.0, 0.0, 16.1>
  }
  object { // Stufe24->Stufe
    Stufe
    rotate -144.0*z
    translate  <0.0, 0.0, 16.8>
  }
  object { // Stufe25->Stufe
    Stufe
    rotate -150.0*z
    translate  <0.0, 0.0, 17.5>
  }
  object { // Stufe26->Stufe
    Stufe
    rotate -156.0*z
    translate  <0.0, 0.0, 18.2>
  }
  object { // Stufe27->Stufe
    Stufe
    rotate -162.0*z
    translate  <0.0, 0.0, 18.9>
  }
  object { // Stufe28->Stufe
    Stufe
    rotate -168.0*z
    translate  <0.0, 0.0, 19.6>
  }
  object { // Stufe29->Stufe
    Stufe
    rotate -174.0*z
    translate  <0.0, 0.0, 20.3>
  }
  object { // Stufe30->Stufe
    Stufe
    rotate 180.0*z
    translate  <0.0, 0.0, 21.0>
  }
  object { // Stufe31->Stufe
    Stufe
    rotate 174.0*z
    translate  <0.0, 0.0, 21.7>
  }
  object { // Stufe32->Stufe
    Stufe
    rotate 168.0*z
    translate  <0.0, 0.0, 22.4>
  }
  object { // Stufe33->Stufe
    Stufe
    rotate 162.0*z
    translate  <0.0, 0.0, 23.1>
  }
  object { // Stufe34->Stufe
    Stufe
    rotate 156.0*z
    translate  <0.0, 0.0, 23.8>
  }
  object { // Stufe35->Stufe
    Stufe
    rotate 150.0*z
    translate  <0.0, 0.0, 24.5>
  }
  object { // Stufe36->Stufe
    Stufe
    rotate 144.0*z
    translate  <0.0, 0.0, 25.2>
  }
  object { // Stufe37->Stufe
    Stufe
    rotate 138.0*z
    translate  <0.0, 0.0, 25.9>
  }
  object { // Stufe38->Stufe
    Stufe
    rotate 132.0*z
    translate  <0.0, 0.0, 26.6>
  }
  object { // Stufe39->Stufe
    Stufe
    rotate 126.0*z
    translate  <0.0, 0.0, 27.3>
  }
  object { // Stufe40->Stufe
    Stufe
    rotate 120.0*z
    translate  <0.0, 0.0, 28.0>
  }
  object { // Stufe41->Stufe
    Stufe
    rotate 114.0*z
    translate  <0.0, 0.0, 28.7>
  }
  object { // Stufe42->Stufe
    Stufe
    rotate 108.0*z
    translate  <0.0, 0.0, 29.4>
  }
  object { // Stufe43->Stufe
    Stufe
    rotate 102.0*z
    translate  <0.0, 0.0, 30.1>
  }
  object { // Stufe44->Stufe
    Stufe
    rotate 96.0*z
    translate  <0.0, 0.0, 30.8>
  }
  object { // Stufe45->Stufe
    Stufe
    rotate 90.0*z
    translate  <0.0, 0.0, 31.5>
  }
  object { // Stufe46->Stufe
    Stufe
    rotate 84.0*z
    translate  <0.0, 0.0, 32.2>
  }
  object { // Stufe47->Stufe
    Stufe
    rotate 78.0*z
    translate  <0.0, 0.0, 32.9>
  }
  object { // Stufe48->Stufe
    Stufe
    rotate 72.0*z
    translate  <0.0, 0.0, 33.6>
  }
  object { // Stufe49->Stufe
    Stufe
    rotate 66.0*z
    translate  <0.0, 0.0, 34.3>
  }
  object { // Stufe50->Stufe
    Stufe
    rotate 60.0*z
    translate  <0.0, 0.0, 35.0>
  }
  object { // Stufe51->Stufe
    Stufe
    rotate 54.0*z
    translate  <0.0, 0.0, 35.7>
  }
  object { // Stufe52->Stufe
    Stufe
    rotate 48.0*z
    translate  <0.0, 0.0, 36.4>
  }
  object { // Stufe53->Stufe
    Stufe
    rotate 42.0*z
    translate  <0.0, 0.0, 37.1>
  }
  object { // Stufe54->Stufe
    Stufe
    rotate 36.0*z
    translate  <0.0, 0.0, 37.8>
  }
  object { // Stufe55->Stufe
    Stufe
    rotate 30.0*z
    translate  <0.0, 0.0, 38.5>
  }
  object { // Stufe56->Stufe
    Stufe
    rotate 24.0*z
    translate  <0.0, 0.0, 39.2>
  }
  object { // Stufe57->Stufe
    Stufe
    rotate 18.0*z
    translate  <0.0, 0.0, 39.9>
  }
  object { // Stufe58->Stufe
    Stufe
    rotate 12.0*z
    translate  <0.0, 0.0, 40.6>
  }
  object { // Stufe59->Stufe
    Stufe
    rotate 6.0*z
    translate  <0.0, 0.0, 41.3>
  }
  object { // Stufe60->Stufe
    Stufe
    rotate 0.0*z
    translate  <0.0, 0.0, 42.0>
  }
  object { // Stufe61->Stufe
    Stufe
    rotate -6.0*z
    translate  <0.0, 0.0, 42.7>
  }
  object { // Stufe62->Stufe
    Stufe
    rotate -12.0*z
    translate  <0.0, 0.0, 43.4>
  }
  object { // Stufe63->Stufe
    Stufe
    rotate -18.0*z
    translate  <0.0, 0.0, 44.1>
  }
  object { // Stufe64->Stufe
    Stufe
    rotate -24.0*z
    translate  <0.0, 0.0, 44.8>
  }
  object { // Stufe65->Stufe
    Stufe
    rotate -30.0*z
    translate  <0.0, 0.0, 45.5>
  }
  object { // Stufe66->Stufe
    Stufe
    rotate -36.0*z
    translate  <0.0, 0.0, 46.2>
  }
  object { // Stufe67->Stufe
    Stufe
    rotate -42.0*z
    translate  <0.0, 0.0, 46.9>
  }
  object { // Stufe68->Stufe
    Stufe
    rotate -48.0*z
    translate  <0.0, 0.0, 47.6>
  }
  object { // Stufe69->Stufe
    Stufe
    rotate -54.0*z
    translate  <0.0, 0.0, 48.3>
  }
  object { // Stufe70->Stufe
    Stufe
    rotate -60.0*z
    translate  <0.0, 0.0, 49.0>
  }
  object { // Stufe71->Stufe
    Stufe
    rotate -66.0*z
    translate  <0.0, 0.0, 49.7>
  }
  object { // Stufe72->Stufe
    Stufe
    rotate -72.0*z
    translate  <0.0, 0.0, 50.4>
  }
  object { // Stufe73->Stufe
    Stufe
    rotate -78.0*z
    translate  <0.0, 0.0, 51.1>
  }
  object { // Stufe74->Stufe
    Stufe
    rotate -84.0*z
    translate  <0.0, 0.0, 51.8>
  }
  object { // Stufe75->Stufe
    Stufe
    rotate -90.0*z
    translate  <0.0, 0.0, 52.5>
  }
  object { // Stufe76->Stufe
    Stufe
    rotate -96.0*z
    translate  <0.0, 0.0, 53.2>
  }
  object { // Stufe77->Stufe
    Stufe
    rotate -102.0*z
    translate  <0.0, 0.0, 53.9>
  }
  object { // Stufe78->Stufe
    Stufe
    rotate -108.0*z
    translate  <0.0, 0.0, 54.6>
  }
  object { // Stufe79->Stufe
    Stufe
    rotate -114.0*z
    translate  <0.0, 0.0, 55.3>
  }
  object { // Stufe80->Stufe
    Stufe
    rotate -120.0*z
    translate  <0.0, 0.0, 56.0>
  }
  object { // Stufe81->Stufe
    Stufe
    rotate -126.0*z
    translate  <0.0, 0.0, 56.7>
  }
  object { // Stufe82->Stufe
    Stufe
    rotate -132.0*z
    translate  <0.0, 0.0, 57.4>
  }
  object { // Stufe83->Stufe
    Stufe
    rotate -138.0*z
    translate  <0.0, 0.0, 58.1>
  }
  object { // Stufe84->Stufe
    Stufe
    rotate -144.0*z
    translate  <0.0, 0.0, 58.8>
  }
  object { // Stufe85->Stufe
    Stufe
    rotate -150.0*z
    translate  <0.0, 0.0, 59.5>
  }
  object { // Stufe86->Stufe
    Stufe
    rotate -156.0*z
    translate  <0.0, 0.0, 60.2>
  }
  object { // Stufe87->Stufe
    Stufe
    rotate -162.0*z
    translate  <0.0, 0.0, 60.9>
  }
  object { // Stufe88->Stufe
    Stufe
    rotate -168.0*z
    translate  <0.0, 0.0, 61.6>
  }
  object { // Stufe89->Stufe
    Stufe
    rotate -174.0*z
    translate  <0.0, 0.0, 62.3>
  }
  object { // Stufe90->Stufe
    Stufe
    rotate 180.0*z
    translate  <0.0, 0.0, 63.0>
  }
  object { // Stufe91->Stufe
    Stufe
    rotate 174.0*z
    translate  <0.0, 0.0, 63.7>
  }
  object { // Stufe92->Stufe
    Stufe
    rotate 168.0*z
    translate  <0.0, 0.0, 64.4>
  }
  object { // Stufe93->Stufe
    Stufe
    rotate 162.0*z
    translate  <0.0, 0.0, 65.1>
  }
  object { // Stufe94->Stufe
    Stufe
    rotate 156.0*z
    translate  <0.0, 0.0, 65.8>
  }
  object { // Stufe95->Stufe
    Stufe
    rotate 150.0*z
    translate  <0.0, 0.0, 66.5>
  }
  object { // Stufe96->Stufe
    Stufe
    rotate 144.0*z
    translate  <0.0, 0.0, 67.2>
  }
  object { // Stufe97->Stufe
    Stufe
    rotate 138.0*z
    translate  <0.0, 0.0, 67.9>
  }
  object { // Stufe98->Stufe
    Stufe
    rotate 132.0*z
    translate  <0.0, 0.0, 68.6>
  }
  object { // Stufe99->Stufe
    Stufe
    rotate 126.0*z
    translate  <0.0, 0.0, 69.3>
  }
  object { // Stufe100->Stufe
    Stufe
    rotate 120.0*z
    translate  <0.0, 0.0, 70.0>
  }
  object { // Stufe101->Stufe
    Stufe
    rotate 114.0*z
    translate  <0.0, 0.0, 70.7>
  }
  object { // Stufe102->Stufe
    Stufe
    rotate 108.0*z
    translate  <0.0, 0.0, 71.4>
  }
  object { // Stufe103->Stufe
    Stufe
    rotate 102.0*z
    translate  <0.0, 0.0, 72.1>
  }
  object { // Stufe104->Stufe
    Stufe
    rotate 96.0*z
    translate  <0.0, 0.0, 72.8>
  }
  object { // Stufe105->Stufe
    Stufe
    rotate 90.0*z
    translate  <0.0, 0.0, 73.5>
  }
  object { // Stufe106->Stufe
    Stufe
    rotate 84.0*z
    translate  <0.0, 0.0, 74.2>
  }
  object { // Stufe107->Stufe
    Stufe
    rotate 78.0*z
    translate  <0.0, 0.0, 74.9>
  }
  object { // Stufe108->Stufe
    Stufe
    rotate 72.0*z
    translate  <0.0, 0.0, 75.6>
  }
  object { // Stufe109->Stufe
    Stufe
    rotate 66.0*z
    translate  <0.0, 0.0, 76.3>
  }
  object { // Stufe110->Stufe
    Stufe
    rotate 60.0*z
    translate  <0.0, 0.0, 77.0>
  }
  object { // Stufe111->Stufe
    Stufe
    rotate 54.0*z
    translate  <0.0, 0.0, 77.7>
  }
  object { // Stufe112->Stufe
    Stufe
    rotate 48.0*z
    translate  <0.0, 0.0, 78.4>
  }
  object { // Stufe113->Stufe
    Stufe
    rotate 42.0*z
    translate  <0.0, 0.0, 79.1>
  }
  object { // Stufe114->Stufe
    Stufe
    rotate 36.0*z
    translate  <0.0, 0.0, 79.8>
  }
  object { // Stufe115->Stufe
    Stufe
    rotate 30.0*z
    translate  <0.0, 0.0, 80.5>
  }
  object { // Stufe116->Stufe
    Stufe
    rotate 24.0*z
    translate  <0.0, 0.0, 81.2>
  }
  object { // Stufe117->Stufe
    Stufe
    rotate 18.0*z
    translate  <0.0, 0.0, 81.9>
  }
  object { // Stufe118->Stufe
    Stufe
    rotate 12.0*z
    translate  <0.0, 0.0, 82.6>
  }
  object { // Stufe119->Stufe
    Stufe
    rotate 6.0*z
    translate  <0.0, 0.0, 83.3>
  }
  object { // Stufe120->Stufe
    Stufe
    rotate 0.0*z
    translate  <0.0, 0.0, 84.0>
  }
  object { // Stufe121->Stufe
    Stufe
    rotate -6.0*z
    translate  <0.0, 0.0, 84.7>
  }
  object { // Stufe122->Stufe
    Stufe
    rotate -12.0*z
    translate  <0.0, 0.0, 85.4>
  }
  object { // Stufe123->Stufe
    Stufe
    rotate -18.0*z
    translate  <0.0, 0.0, 86.1>
  }
  object { // Stufe124->Stufe
    Stufe
    rotate -24.0*z
    translate  <0.0, 0.0, 86.8>
  }
  object { // Stufe125->Stufe
    Stufe
    rotate -30.0*z
    translate  <0.0, 0.0, 87.5>
  }
  object { // Stufe126->Stufe
    Stufe
    rotate -36.0*z
    translate  <0.0, 0.0, 88.2>
  }
  object { // Stufe127->Stufe
    Stufe
    rotate -42.0*z
    translate  <0.0, 0.0, 88.9>
  }
  object { // Stufe128->Stufe
    Stufe
    rotate -48.0*z
    translate  <0.0, 0.0, 89.6>
  }
  object { // Stufe129->Stufe
    Stufe
    rotate -54.0*z
    translate  <0.0, 0.0, 90.3>
  }
  object { // Stufe130->Stufe
    Stufe
    rotate -60.0*z
    translate  <0.0, 0.0, 91.0>
  }
  object { // Stufe131->Stufe
    Stufe
    rotate -66.0*z
    translate  <0.0, 0.0, 91.7>
  }
  object { // Stufe132->Stufe
    Stufe
    rotate -72.0*z
    translate  <0.0, 0.0, 92.4>
  }
  object { // Stufe133->Stufe
    Stufe
    rotate -78.0*z
    translate  <0.0, 0.0, 93.1>
  }
  object { // Stufe134->Stufe
    Stufe
    rotate -84.0*z
    translate  <0.0, 0.0, 93.8>
  }
  object { // Stufe135->Stufe
    Stufe
    rotate -90.0*z
    translate  <0.0, 0.0, 94.5>
  }
  object { // Stufe136->Stufe
    Stufe
    rotate -96.0*z
    translate  <0.0, 0.0, 95.2>
  }
  object { // Stufe137->Stufe
    Stufe
    rotate -102.0*z
    translate  <0.0, 0.0, 95.9>
  }
  object { // Stufe138->Stufe
    Stufe
    rotate -108.0*z
    translate  <0.0, 0.0, 96.6>
  }
  object { // Stufe139->Stufe
    Stufe
    rotate -114.0*z
    translate  <0.0, 0.0, 97.3>
  }
  object { // Stufe140->Stufe
    Stufe
    rotate -120.0*z
    translate  <0.0, 0.0, 98.0>
  }
  object { // Stufe141->Stufe
    Stufe
    rotate -126.0*z
    translate  <0.0, 0.0, 98.7>
  }
  object { // Stufe142->Stufe
    Stufe
    rotate -132.0*z
    translate  <0.0, 0.0, 99.4>
  }
  object { // Stufe143->Stufe
    Stufe
    rotate -138.0*z
    translate  <0.0, 0.0, 100.1>
  }
  object { // Stufe144->Stufe
    Stufe
    rotate -144.0*z
    translate  <0.0, 0.0, 100.8>
  }
  object { // Stufe145->Stufe
    Stufe
    rotate -150.0*z
    translate  <0.0, 0.0, 101.5>
  }
  object { // Stufe146->Stufe
    Stufe
    rotate -156.0*z
    translate  <0.0, 0.0, 102.2>
  }
  object { // Stufe147->Stufe
    Stufe
    rotate -162.0*z
    translate  <0.0, 0.0, 102.9>
  }
  object { // Stufe148->Stufe
    Stufe
    rotate -168.0*z
    translate  <0.0, 0.0, 103.6>
  }
  object { // Stufe149->Stufe
    Stufe
    rotate -174.0*z
    translate  <0.0, 0.0, 104.3>
  }
  object { // Stufe150->Stufe
    Stufe
    rotate 180.0*z
    translate  <0.0, 0.0, 105.0>
  }
  object { // Stufe151->Stufe
    Stufe
    rotate 174.0*z
    translate  <0.0, 0.0, 105.7>
  }
  object { // Stufe152->Stufe
    Stufe
    rotate 168.0*z
    translate  <0.0, 0.0, 106.4>
  }
  object { // Stufe153->Stufe
    Stufe
    rotate 162.0*z
    translate  <0.0, 0.0, 107.1>
  }
  object { // Stufe154->Stufe
    Stufe
    rotate 156.0*z
    translate  <0.0, 0.0, 107.8>
  }
  object { // Stufe155->Stufe
    Stufe
    rotate 150.0*z
    translate  <0.0, 0.0, 108.5>
  }
  object { // Stufe156->Stufe
    Stufe
    rotate 144.0*z
    translate  <0.0, 0.0, 109.2>
  }
  object { // Stufe157->Stufe
    Stufe
    rotate 138.0*z
    translate  <0.0, 0.0, 109.9>
  }
  object { // Stufe158->Stufe
    Stufe
    rotate 132.0*z
    translate  <0.0, 0.0, 110.6>
  }
  object { // Stufe159->Stufe
    Stufe
    rotate 126.0*z
    translate  <0.0, 0.0, 111.3>
  }
  object { // Stufe160->Stufe
    Stufe
    rotate 120.0*z
    translate  <0.0, 0.0, 112.0>
  }
  object { // Stufe161->Stufe
    Stufe
    rotate 114.0*z
    translate  <0.0, 0.0, 112.7>
  }
  object { // Stufe162->Stufe
    Stufe
    rotate 108.0*z
    translate  <0.0, 0.0, 113.4>
  }
  object { // Stufe163->Stufe
    Stufe
    rotate 102.0*z
    translate  <0.0, 0.0, 114.1>
  }
  object { // Stufe164->Stufe
    Stufe
    rotate 96.0*z
    translate  <0.0, 0.0, 114.8>
  }
  object { // Stufe165->Stufe
    Stufe
    rotate 90.0*z
    translate  <0.0, 0.0, 115.5>
  }
  object { // Stufe166->Stufe
    Stufe
    rotate 84.0*z
    translate  <0.0, 0.0, 116.2>
  }
  object { // Stufe167->Stufe
    Stufe
    rotate 78.0*z
    translate  <0.0, 0.0, 116.9>
  }
  object { // Stufe168->Stufe
    Stufe
    rotate 72.0*z
    translate  <0.0, 0.0, 117.6>
  }
  object { // Stufe169->Stufe
    Stufe
    rotate 66.0*z
    translate  <0.0, 0.0, 118.3>
  }
  object { // Stufe170->Stufe
    Stufe
    rotate 60.0*z
    translate  <0.0, 0.0, 119.0>
  }
  object { // Stufe171->Stufe
    Stufe
    rotate 54.0*z
    translate  <0.0, 0.0, 119.7>
  }
  object { // Stufe172->Stufe
    Stufe
    rotate 48.0*z
    translate  <0.0, 0.0, 120.4>
  }
  object { // Stufe173->Stufe
    Stufe
    rotate 42.0*z
    translate  <0.0, 0.0, 121.1>
  }
  object { // Stufe174->Stufe
    Stufe
    rotate 36.0*z
    translate  <0.0, 0.0, 121.8>
  }
  object { // Stufe175->Stufe
    Stufe
    rotate 30.0*z
    translate  <0.0, 0.0, 122.5>
  }
  object { // Stufe176->Stufe
    Stufe
    rotate 24.0*z
    translate  <0.0, 0.0, 123.2>
  }
  object { // Stufe177->Stufe
    Stufe
    rotate 18.0*z
    translate  <0.0, 0.0, 123.9>
  }
  object { // Stufe178->Stufe
    Stufe
    rotate 12.0*z
    translate  <0.0, 0.0, 124.6>
  }
  object { // Stufe179->Stufe
    Stufe
    rotate 6.0*z
    translate  <0.0, 0.0, 125.3>
  }
  object { // Stufe180->Stufe
    Stufe
    rotate 0.0*z
    translate  <0.0, 0.0, 126.0>
  }
  object { // Stufe181->Stufe
    Stufe
    rotate -6.0*z
    translate  <0.0, 0.0, 126.7>
  }
  object { // Stufe182->Stufe
    Stufe
    rotate -12.0*z
    translate  <0.0, 0.0, 127.4>
  }
  object { // Stufe183->Stufe
    Stufe
    rotate -18.0*z
    translate  <0.0, 0.0, 128.1>
  }
  object { // Stufe184->Stufe
    Stufe
    rotate -24.0*z
    translate  <0.0, 0.0, 128.8>
  }
  object { // Stufe185->Stufe
    Stufe
    rotate -30.0*z
    translate  <0.0, 0.0, 129.5>
  }
  object { // Stufe186->Stufe
    Stufe
    rotate -36.0*z
    translate  <0.0, 0.0, 130.2>
  }
  object { // Stufe187->Stufe
    Stufe
    rotate -42.0*z
    translate  <0.0, 0.0, 130.9>
  }
  object { // Stufe188->Stufe
    Stufe
    rotate -48.0*z
    translate  <0.0, 0.0, 131.6>
  }
  object { // Stufe189->Stufe
    Stufe
    rotate -54.0*z
    translate  <0.0, 0.0, 132.3>
  }
  object { // Stufe190->Stufe
    Stufe
    rotate -60.0*z
    translate  <0.0, 0.0, 133.0>
  }
  object { // Stufe191->Stufe
    Stufe
    rotate -66.0*z
    translate  <0.0, 0.0, 133.7>
  }
  object { // Stufe192->Stufe
    Stufe
    rotate -72.0*z
    translate  <0.0, 0.0, 134.4>
  }
  object { // Stufe193->Stufe
    Stufe
    rotate -78.0*z
    translate  <0.0, 0.0, 135.1>
  }
  object { // Stufe194->Stufe
    Stufe
    rotate -84.0*z
    translate  <0.0, 0.0, 135.8>
  }
  object { // Stufe195->Stufe
    Stufe
    rotate -90.0*z
    translate  <0.0, 0.0, 136.5>
  }
  object { // Stufe196->Stufe
    Stufe
    rotate -96.0*z
    translate  <0.0, 0.0, 137.2>
  }
  object { // Stufe197->Stufe
    Stufe
    rotate -102.0*z
    translate  <0.0, 0.0, 137.9>
  }
  object { // Stufe198->Stufe
    Stufe
    rotate -108.0*z
    translate  <0.0, 0.0, 138.6>
  }
  object { // Stufe199->Stufe
    Stufe
    rotate -114.0*z
    translate  <0.0, 0.0, 139.3>
  }
  object { // Stufe200->Stufe
    Stufe
    rotate -120.0*z
    translate  <0.0, 0.0, 140.0>
  }
  object { // Stufe201->Stufe
    Stufe
    rotate -126.0*z
    translate  <0.0, 0.0, 140.7>
  }
  object { // Stufe202->Stufe
    Stufe
    rotate -132.0*z
    translate  <0.0, 0.0, 141.4>
  }
  object { // Stufe203->Stufe
    Stufe
    rotate -138.0*z
    translate  <0.0, 0.0, 142.1>
  }
  object { // Stufe204->Stufe
    Stufe
    rotate -144.0*z
    translate  <0.0, 0.0, 142.8>
  }
  object { // Stufe205->Stufe
    Stufe
    rotate -150.0*z
    translate  <0.0, 0.0, 143.5>
  }
  object { // Stufe206->Stufe
    Stufe
    rotate -156.0*z
    translate  <0.0, 0.0, 144.2>
  }
  object { // Stufe207->Stufe
    Stufe
    rotate -162.0*z
    translate  <0.0, 0.0, 144.9>
  }
  object { // Stufe208->Stufe
    Stufe
    rotate -168.0*z
    translate  <0.0, 0.0, 145.6>
  }
  object { // Stufe209->Stufe
    Stufe
    rotate -174.0*z
    translate  <0.0, 0.0, 146.3>
  }
  object { // Stufe210->Stufe
    Stufe
    rotate 180.0*z
    translate  <0.0, 0.0, 147.0>
  }
  object { // Stufe211->Stufe
    Stufe
    rotate 174.0*z
    translate  <0.0, 0.0, 147.7>
  }
  object { // Stufe212->Stufe
    Stufe
    rotate 168.0*z
    translate  <0.0, 0.0, 148.4>
  }
  object { // Stufe213->Stufe
    Stufe
    rotate 162.0*z
    translate  <0.0, 0.0, 149.1>
  }
  object { // Stufe214->Stufe
    Stufe
    rotate 156.0*z
    translate  <0.0, 0.0, 149.8>
  }
  object { // Stufe215->Stufe
    Stufe
    rotate 150.0*z
    translate  <0.0, 0.0, 150.5>
  }
  object { // Stufe216->Stufe
    Stufe
    rotate 144.0*z
    translate  <0.0, 0.0, 151.2>
  }
  object { // Stufe217->Stufe
    Stufe
    rotate 138.0*z
    translate  <0.0, 0.0, 151.9>
  }
  object { // Stufe218->Stufe
    Stufe
    rotate 132.0*z
    translate  <0.0, 0.0, 152.6>
  }
  object { // Stufe219->Stufe
    Stufe
    rotate 126.0*z
    translate  <0.0, 0.0, 153.3>
  }
  object { // Stufe220->Stufe
    Stufe
    rotate 120.0*z
    translate  <0.0, 0.0, 154.0>
  }
  object { // Stufe221->Stufe
    Stufe
    rotate 114.0*z
    translate  <0.0, 0.0, 154.7>
  }
  object { // Stufe222->Stufe
    Stufe
    rotate 108.0*z
    translate  <0.0, 0.0, 155.4>
  }
  object { // Stufe223->Stufe
    Stufe
    rotate 102.0*z
    translate  <0.0, 0.0, 156.1>
  }
  object { // Stufe224->Stufe
    Stufe
    rotate 96.0*z
    translate  <0.0, 0.0, 156.8>
  }
  object { // Stufe225->Stufe
    Stufe
    rotate 90.0*z
    translate  <0.0, 0.0, 157.5>
  }
  object { // Stufe226->Stufe
    Stufe
    rotate 84.0*z
    translate  <0.0, 0.0, 158.2>
  }
  object { // Stufe227->Stufe
    Stufe
    rotate 78.0*z
    translate  <0.0, 0.0, 158.9>
  }
  object { // Stufe228->Stufe
    Stufe
    rotate 72.0*z
    translate  <0.0, 0.0, 159.6>
  }
  object { // Stufe229->Stufe
    Stufe
    rotate 66.0*z
    translate  <0.0, 0.0, 160.3>
  }
  object { // Stufe230->Stufe
    Stufe
    rotate 60.0*z
    translate  <0.0, 0.0, 161.0>
  }
  object { // Stufe231->Stufe
    Stufe
    rotate 54.0*z
    translate  <0.0, 0.0, 161.7>
  }
  object { // Stufe232->Stufe
    Stufe
    rotate 48.0*z
    translate  <0.0, 0.0, 162.4>
  }
  object { // Stufe233->Stufe
    Stufe
    rotate 42.0*z
    translate  <0.0, 0.0, 163.1>
  }
  object { // Stufe234->Stufe
    Stufe
    rotate 36.0*z
    translate  <0.0, 0.0, 163.8>
  }
  object { // Stufe235->Stufe
    Stufe
    rotate 30.0*z
    translate  <0.0, 0.0, 164.5>
  }
  object { // Stufe236->Stufe
    Stufe
    rotate 24.0*z
    translate  <0.0, 0.0, 165.2>
  }
  object { // Stufe237->Stufe
    Stufe
    rotate 18.0*z
    translate  <0.0, 0.0, 165.9>
  }
  object { // Stufe238->Stufe
    Stufe
    rotate 12.0*z
    translate  <0.0, 0.0, 166.6>
  }
  object { // Stufe239->Stufe
    Stufe
    rotate 6.0*z
    translate  <0.0, 0.0, 167.3>
  }
  object { // Stufe240->Stufe
    Stufe
    rotate 0.0*z
    translate  <0.0, 0.0, 168.0>
  }
  object { // Stufe241->Stufe
    Stufe
    rotate -6.0*z
    translate  <0.0, 0.0, 168.7>
  }
  object { // Stufe242->Stufe
    Stufe
    rotate -12.0*z
    translate  <0.0, 0.0, 169.4>
  }
  object { // Stufe243->Stufe
    Stufe
    rotate -18.0*z
    translate  <0.0, 0.0, 170.1>
  }
  object { // Stufe244->Stufe
    Stufe
    rotate -24.0*z
    translate  <0.0, 0.0, 170.8>
  }
  object { // Stufe245->Stufe
    Stufe
    rotate -30.0*z
    translate  <0.0, 0.0, 171.5>
  }
  object { // Stufe246->Stufe
    Stufe
    rotate -36.0*z
    translate  <0.0, 0.0, 172.2>
  }
  object { // Stufe247->Stufe
    Stufe
    rotate -42.0*z
    translate  <0.0, 0.0, 172.9>
  }
  object { // Stufe248->Stufe
    Stufe
    rotate -48.0*z
    translate  <0.0, 0.0, 173.6>
  }
  object { // Stufe249->Stufe
    Stufe
    rotate -54.0*z
    translate  <0.0, 0.0, 174.3>
  }
  object { // Stufe250->Stufe
    Stufe
    rotate -60.0*z
    translate  <0.0, 0.0, 175.0>
  }
  object { // Stufe251->Stufe
    Stufe
    rotate -66.0*z
    translate  <0.0, 0.0, 175.7>
  }
  object { // Stufe252->Stufe
    Stufe
    rotate -72.0*z
    translate  <0.0, 0.0, 176.4>
  }
  object { // Stufe253->Stufe
    Stufe
    rotate -78.0*z
    translate  <0.0, 0.0, 177.1>
  }
  object { // Stufe254->Stufe
    Stufe
    rotate -84.0*z
    translate  <0.0, 0.0, 177.8>
  }
  object { // Stufe255->Stufe
    Stufe
    rotate -90.0*z
    translate  <0.0, 0.0, 178.5>
  }
  object { // Stufe256->Stufe
    Stufe
    rotate -96.0*z
    translate  <0.0, 0.0, 179.2>
  }
  object { // Stufe257->Stufe
    Stufe
    rotate -102.0*z
    translate  <0.0, 0.0, 179.9>
  }
  object { // Stufe258->Stufe
    Stufe
    rotate -108.0*z
    translate  <0.0, 0.0, 180.6>
  }
  object { // Stufe259->Stufe
    Stufe
    rotate -114.0*z
    translate  <0.0, 0.0, 181.3>
  }
  object { // Stufe260->Stufe
    Stufe
    rotate -120.0*z
    translate  <0.0, 0.0, 182.0>
  }
  object { // Stufe261->Stufe
    Stufe
    rotate -126.0*z
    translate  <0.0, 0.0, 182.7>
  }
  object { // Stufe262->Stufe
    Stufe
    rotate -132.0*z
    translate  <0.0, 0.0, 183.4>
  }
  object { // Stufe263->Stufe
    Stufe
    rotate -138.0*z
    translate  <0.0, 0.0, 184.1>
  }
  object { // Stufe264->Stufe
    Stufe
    rotate -144.0*z
    translate  <0.0, 0.0, 184.8>
  }
  object { // Stufe265->Stufe
    Stufe
    rotate -150.0*z
    translate  <0.0, 0.0, 185.5>
  }
  object { // Stufe266->Stufe
    Stufe
    rotate -156.0*z
    translate  <0.0, 0.0, 186.2>
  }
  object { // Stufe267->Stufe
    Stufe
    rotate -162.0*z
    translate  <0.0, 0.0, 186.9>
  }
  object { // Stufe268->Stufe
    Stufe
    rotate -168.0*z
    translate  <0.0, 0.0, 187.6>
  }
  object { // Stufe269->Stufe
    Stufe
    rotate -174.0*z
    translate  <0.0, 0.0, 188.3>
  }
  object { // Stufe270->Stufe
    Stufe
    rotate 180.0*z
    translate  <0.0, 0.0, 189.0>
  }
  object { // Stufe271->Stufe
    Stufe
    rotate 174.0*z
    translate  <0.0, 0.0, 189.7>
  }
  object { // Stufe272->Stufe
    Stufe
    rotate 168.0*z
    translate  <0.0, 0.0, 190.4>
  }
  object { // Stufe273->Stufe
    Stufe
    rotate 162.0*z
    translate  <0.0, 0.0, 191.1>
  }
  object { // Stufe274->Stufe
    Stufe
    rotate 156.0*z
    translate  <0.0, 0.0, 191.8>
  }
  object { // Stufe275->Stufe
    Stufe
    rotate 150.0*z
    translate  <0.0, 0.0, 192.5>
  }
  object { // Stufe276->Stufe
    Stufe
    rotate 144.0*z
    translate  <0.0, 0.0, 193.2>
  }
  object { // Stufe277->Stufe
    Stufe
    rotate 138.0*z
    translate  <0.0, 0.0, 193.9>
  }
  object { // Stufe278->Stufe
    Stufe
    rotate 132.0*z
    translate  <0.0, 0.0, 194.6>
  }
  object { // Stufe279->Stufe
    Stufe
    rotate 126.0*z
    translate  <0.0, 0.0, 195.3>
  }
  object { // Stufe280->Stufe
    Stufe
    rotate 120.0*z
    translate  <0.0, 0.0, 196.0>
  }
  object { // Stufe281->Stufe
    Stufe
    rotate 114.0*z
    translate  <0.0, 0.0, 196.7>
  }
  object { // Stufe282->Stufe
    Stufe
    rotate 108.0*z
    translate  <0.0, 0.0, 197.4>
  }
  object { // Stufe283->Stufe
    Stufe
    rotate 102.0*z
    translate  <0.0, 0.0, 198.1>
  }
  object { // Stufe284->Stufe
    Stufe
    rotate 96.0*z
    translate  <0.0, 0.0, 198.8>
  }
  object { // Stufe285->Stufe
    Stufe
    rotate 90.0*z
    translate  <0.0, 0.0, 199.5>
  }
  object { // Stufe286->Stufe
    Stufe
    rotate 84.0*z
    translate  <0.0, 0.0, 200.2>
  }
  object { // Stufe287->Stufe
    Stufe
    rotate 78.0*z
    translate  <0.0, 0.0, 200.9>
  }
  object { // Stufe288->Stufe
    Stufe
    rotate 72.0*z
    translate  <0.0, 0.0, 201.6>
  }
  object { // Stufe289->Stufe
    Stufe
    rotate 66.0*z
    translate  <0.0, 0.0, 202.3>
  }
  object { // Stufe290->Stufe
    Stufe
    rotate 60.0*z
    translate  <0.0, 0.0, 203.0>
  }
  object { // Stufe291->Stufe
    Stufe
    rotate 54.0*z
    translate  <0.0, 0.0, 203.7>
  }
  object { // Stufe292->Stufe
    Stufe
    rotate 48.0*z
    translate  <0.0, 0.0, 204.4>
  }
  object { // Stufe293->Stufe
    Stufe
    rotate 42.0*z
    translate  <0.0, 0.0, 205.1>
  }
  object { // Stufe294->Stufe
    Stufe
    rotate 36.0*z
    translate  <0.0, 0.0, 205.8>
  }
  object { // Stufe295->Stufe
    Stufe
    rotate 30.0*z
    translate  <0.0, 0.0, 206.5>
  }
  object { // Stufe296->Stufe
    Stufe
    rotate 24.0*z
    translate  <0.0, 0.0, 207.2>
  }
  object { // Stufe297->Stufe
    Stufe
    rotate 18.0*z
    translate  <0.0, 0.0, 207.9>
  }
  object { // Stufe298->Stufe
    Stufe
    rotate 12.0*z
    translate  <0.0, 0.0, 208.6>
  }
  object { // Stufe299->Stufe
    Stufe
    rotate 6.0*z
    translate  <0.0, 0.0, 209.3>
  }
  object { // Stufe300->Stufe
    Stufe
    rotate 0.0*z
    translate  <0.0, 0.0, 210.0>
  }
  object { // Stufe301->Stufe
    Stufe
    rotate -6.0*z
    translate  <0.0, 0.0, 210.7>
  }
  object { // Stufe302->Stufe
    Stufe
    rotate -12.0*z
    translate  <0.0, 0.0, 211.4>
  }
  object { // Stufe303->Stufe
    Stufe
    rotate -18.0*z
    translate  <0.0, 0.0, 212.1>
  }
  object { // Stufe304->Stufe
    Stufe
    rotate -24.0*z
    translate  <0.0, 0.0, 212.8>
  }
  object { // Stufe305->Stufe
    Stufe
    rotate -30.0*z
    translate  <0.0, 0.0, 213.5>
  }
  object { // Stufe306->Stufe
    Stufe
    rotate -36.0*z
    translate  <0.0, 0.0, 214.2>
  }
  object { // Stufe307->Stufe
    Stufe
    rotate -42.0*z
    translate  <0.0, 0.0, 214.9>
  }
  object { // Stufe308->Stufe
    Stufe
    rotate -48.0*z
    translate  <0.0, 0.0, 215.6>
  }
  object { // Stufe309->Stufe
    Stufe
    rotate -54.0*z
    translate  <0.0, 0.0, 216.3>
  }
  object { // Stufe310->Stufe
    Stufe
    rotate -60.0*z
    translate  <0.0, 0.0, 217.0>
  }
  object { // Stufe311->Stufe
    Stufe
    rotate -66.0*z
    translate  <0.0, 0.0, 217.7>
  }
  object { // Stufe312->Stufe
    Stufe
    rotate -72.0*z
    translate  <0.0, 0.0, 218.4>
  }
  object { // Stufe313->Stufe
    Stufe
    rotate -78.0*z
    translate  <0.0, 0.0, 219.1>
  }
  object { // Stufe314->Stufe
    Stufe
    rotate -84.0*z
    translate  <0.0, 0.0, 219.8>
  }
  object { // Stufe315->Stufe
    Stufe
    rotate -90.0*z
    translate  <0.0, 0.0, 220.5>
  }
  object { // Stufe316->Stufe
    Stufe
    rotate -96.0*z
    translate  <0.0, 0.0, 221.2>
  }
  object { // Stufe317->Stufe
    Stufe
    rotate -102.0*z
    translate  <0.0, 0.0, 221.9>
  }
  object { // Stufe318->Stufe
    Stufe
    rotate -108.0*z
    translate  <0.0, 0.0, 222.6>
  }
  object { // Stufe319->Stufe
    Stufe
    rotate -114.0*z
    translate  <0.0, 0.0, 223.3>
  }
  object { // Stufe320->Stufe
    Stufe
    rotate -120.0*z
    translate  <0.0, 0.0, 224.0>
  }
  object { // Stufe321->Stufe
    Stufe
    rotate -126.0*z
    translate  <0.0, 0.0, 224.7>
  }
  object { // Stufe322->Stufe
    Stufe
    rotate -132.0*z
    translate  <0.0, 0.0, 225.4>
  }
  object { // Stufe323->Stufe
    Stufe
    rotate -138.0*z
    translate  <0.0, 0.0, 226.1>
  }
  object { // Stufe324->Stufe
    Stufe
    rotate -144.0*z
    translate  <0.0, 0.0, 226.8>
  }
  object { // Stufe325->Stufe
    Stufe
    rotate -150.0*z
    translate  <0.0, 0.0, 227.5>
  }
  object { // Stufe326->Stufe
    Stufe
    rotate -156.0*z
    translate  <0.0, 0.0, 228.2>
  }
  object { // Stufe327->Stufe
    Stufe
    rotate -162.0*z
    translate  <0.0, 0.0, 228.9>
  }
  object { // Stufe328->Stufe
    Stufe
    rotate -168.0*z
    translate  <0.0, 0.0, 229.6>
  }
  object { // Stufe329->Stufe
    Stufe
    rotate -174.0*z
    translate  <0.0, 0.0, 230.3>
  }
  object { // Stufe330->Stufe
    Stufe
    rotate 180.0*z
    translate  <0.0, 0.0, 231.0>
  }
  object { // Stufe331->Stufe
    Stufe
    rotate 174.0*z
    translate  <0.0, 0.0, 231.7>
  }
  object { // Stufe332->Stufe
    Stufe
    rotate 168.0*z
    translate  <0.0, 0.0, 232.4>
  }
  object { // Stufe333->Stufe
    Stufe
    rotate 162.0*z
    translate  <0.0, 0.0, 233.1>
  }
  object { // Stufe334->Stufe
    Stufe
    rotate 156.0*z
    translate  <0.0, 0.0, 233.8>
  }
  object { // Stufe335->Stufe
    Stufe
    rotate 150.0*z
    translate  <0.0, 0.0, 234.5>
  }
  object { // Stufe336->Stufe
    Stufe
    rotate 144.0*z
    translate  <0.0, 0.0, 235.2>
  }
  object { // Stufe337->Stufe
    Stufe
    rotate 138.0*z
    translate  <0.0, 0.0, 235.9>
  }
  object { // Stufe338->Stufe
    Stufe
    rotate 132.0*z
    translate  <0.0, 0.0, 236.6>
  }
  object { // Stufe339->Stufe
    Stufe
    rotate 126.0*z
    translate  <0.0, 0.0, 237.3>
  }
  object { // Stufe340->Stufe
    Stufe
    rotate 120.0*z
    translate  <0.0, 0.0, 238.0>
  }
  object { // Stufe341->Stufe
    Stufe
    rotate 114.0*z
    translate  <0.0, 0.0, 238.7>
  }
  object { // Stufe342->Stufe
    Stufe
    rotate 108.0*z
    translate  <0.0, 0.0, 239.4>
  }
  object { // Stufe343->Stufe
    Stufe
    rotate 102.0*z
    translate  <0.0, 0.0, 240.1>
  }
  object { // Stufe344->Stufe
    Stufe
    rotate 96.0*z
    translate  <0.0, 0.0, 240.8>
  }
  object { // Stufe345->Stufe
    Stufe
    rotate 90.0*z
    translate  <0.0, 0.0, 241.5>
  }
  object { // Stufe346->Stufe
    Stufe
    rotate 84.0*z
    translate  <0.0, 0.0, 242.2>
  }
  object { // Stufe347->Stufe
    Stufe
    rotate 78.0*z
    translate  <0.0, 0.0, 242.9>
  }
  object { // Stufe348->Stufe
    Stufe
    rotate 72.0*z
    translate  <0.0, 0.0, 243.6>
  }
  object { // Stufe349->Stufe
    Stufe
    rotate 66.0*z
    translate  <0.0, 0.0, 244.3>
  }
  object { // Stufe350->Stufe
    Stufe
    rotate 60.0*z
    translate  <0.0, 0.0, 245.0>
  }
  object { // Stufe351->Stufe
    Stufe
    rotate 54.0*z
    translate  <0.0, 0.0, 245.7>
  }
  object { // Stufe352->Stufe
    Stufe
    rotate 48.0*z
    translate  <0.0, 0.0, 246.4>
  }
  object { // Stufe353->Stufe
    Stufe
    rotate 42.0*z
    translate  <0.0, 0.0, 247.1>
  }
  object { // Stufe354->Stufe
    Stufe
    rotate 36.0*z
    translate  <0.0, 0.0, 247.8>
  }
  object { // Stufe355->Stufe
    Stufe
    rotate 30.0*z
    translate  <0.0, 0.0, 248.5>
  }
  object { // Stufe356->Stufe
    Stufe
    rotate 24.0*z
    translate  <0.0, 0.0, 249.2>
  }
  object { // Stufe357->Stufe
    Stufe
    rotate 18.0*z
    translate  <0.0, 0.0, 249.9>
  }
  object { // Stufe358->Stufe
    Stufe
    rotate 12.0*z
    translate  <0.0, 0.0, 250.6>
  }
  object { // Stufe359->Stufe
    Stufe
    rotate 6.0*z
    translate  <0.0, 0.0, 251.3>
  }
  object { // Stufe360->Stufe
    Stufe
    rotate 0.0*z
    translate  <0.0, 0.0, 252.0>
  }
  object { // Stufe361->Stufe
    Stufe
    rotate -6.0*z
    translate  <0.0, 0.0, 252.7>
  }
  object { // Stufe362->Stufe
    Stufe
    rotate -12.0*z
    translate  <0.0, 0.0, 253.4>
  }
  object { // Stufe363->Stufe
    Stufe
    rotate -18.0*z
    translate  <0.0, 0.0, 254.1>
  }
  object { // Stufe364->Stufe
    Stufe
    rotate -24.0*z
    translate  <0.0, 0.0, 254.8>
  }
  object { // Stufe365->Stufe
    Stufe
    rotate -30.0*z
    translate  <0.0, 0.0, 255.5>
  }
  object { // Stufe366->Stufe
    Stufe
    rotate -36.0*z
    translate  <0.0, 0.0, 256.2>
  }
  object { // Stufe367->Stufe
    Stufe
    rotate -42.0*z
    translate  <0.0, 0.0, 256.9>
  }
  object { // Stufe368->Stufe
    Stufe
    rotate -48.0*z
    translate  <0.0, 0.0, 257.6>
  }
  object { // Stufe369->Stufe
    Stufe
    rotate -54.0*z
    translate  <0.0, 0.0, 258.3>
  }
  object { // Stufe370->Stufe
    Stufe
    rotate -60.0*z
    translate  <0.0, 0.0, 259.0>
  }
  object { // Stufe371->Stufe
    Stufe
    rotate -66.0*z
    translate  <0.0, 0.0, 259.7>
  }
  object { // Stufe372->Stufe
    Stufe
    rotate -72.0*z
    translate  <0.0, 0.0, 260.4>
  }
  object { // Stufe373->Stufe
    Stufe
    rotate -78.0*z
    translate  <0.0, 0.0, 261.1>
  }
  object { // Stufe374->Stufe
    Stufe
    rotate -84.0*z
    translate  <0.0, 0.0, 261.8>
  }
  object { // Stufe375->Stufe
    Stufe
    rotate -90.0*z
    translate  <0.0, 0.0, 262.5>
  }
  object { // Stufe376->Stufe
    Stufe
    rotate -96.0*z
    translate  <0.0, 0.0, 263.2>
  }
  object { // Stufe377->Stufe
    Stufe
    rotate -102.0*z
    translate  <0.0, 0.0, 263.9>
  }
  object { // Stufe378->Stufe
    Stufe
    rotate -108.0*z
    translate  <0.0, 0.0, 264.6>
  }
  object { // Stufe379->Stufe
    Stufe
    rotate -114.0*z
    translate  <0.0, 0.0, 265.3>
  }
  object { // Stufe380->Stufe
    Stufe
    rotate -120.0*z
    translate  <0.0, 0.0, 266.0>
  }
  object { // Stufe381->Stufe
    Stufe
    rotate -126.0*z
    translate  <0.0, 0.0, 266.7>
  }
  object { // Stufe382->Stufe
    Stufe
    rotate -132.0*z
    translate  <0.0, 0.0, 267.4>
  }
  object { // Stufe383->Stufe
    Stufe
    rotate -138.0*z
    translate  <0.0, 0.0, 268.1>
  }
  object { // Stufe384->Stufe
    Stufe
    rotate -144.0*z
    translate  <0.0, 0.0, 268.8>
  }
  object { // Stufe385->Stufe
    Stufe
    rotate -150.0*z
    translate  <0.0, 0.0, 269.5>
  }
  object { // Stufe386->Stufe
    Stufe
    rotate -156.0*z
    translate  <0.0, 0.0, 270.2>
  }
  object { // Stufe387->Stufe
    Stufe
    rotate -162.0*z
    translate  <0.0, 0.0, 270.9>
  }
  object { // Stufe388->Stufe
    Stufe
    rotate -168.0*z
    translate  <0.0, 0.0, 271.6>
  }
  object { // Stufe389->Stufe
    Stufe
    rotate -174.0*z
    translate  <0.0, 0.0, 272.3>
  }
  object { // Stufe390->Stufe
    Stufe
    rotate 180.0*z
    translate  <0.0, 0.0, 273.0>
  }
  object { // Stufe391->Stufe
    Stufe
    rotate 174.0*z
    translate  <0.0, 0.0, 273.7>
  }
  object { // Stufe392->Stufe
    Stufe
    rotate 168.0*z
    translate  <0.0, 0.0, 274.4>
  }
  object { // Stufe393->Stufe
    Stufe
    rotate 162.0*z
    translate  <0.0, 0.0, 275.1>
  }
  object { // Stufe394->Stufe
    Stufe
    rotate 156.0*z
    translate  <0.0, 0.0, 275.8>
  }
  object { // Stufe395->Stufe
    Stufe
    rotate 150.0*z
    translate  <0.0, 0.0, 276.5>
  }
  object { // Stufe396->Stufe
    Stufe
    rotate 144.0*z
    translate  <0.0, 0.0, 277.2>
  }
  object { // Stufe397->Stufe
    Stufe
    rotate 138.0*z
    translate  <0.0, 0.0, 277.9>
  }
  object { // Stufe398->Stufe
    Stufe
    rotate 132.0*z
    translate  <0.0, 0.0, 278.6>
  }
  object { // Stufe399->Stufe
    Stufe
    rotate 126.0*z
    translate  <0.0, 0.0, 279.3>
  }
  object { // Stufe400->Stufe
    Stufe
    rotate 120.0*z
    translate  <0.0, 0.0, 280.0>
  }
  object { // Stufe401->Stufe
    Stufe
    rotate 114.0*z
    translate  <0.0, 0.0, 280.7>
  }
  object { // Stufe402->Stufe
    Stufe
    rotate 108.0*z
    translate  <0.0, 0.0, 281.4>
  }
  object { // Stufe403->Stufe
    Stufe
    rotate 102.0*z
    translate  <0.0, 0.0, 282.1>
  }
  object { // Stufe404->Stufe
    Stufe
    rotate 96.0*z
    translate  <0.0, 0.0, 282.8>
  }
  object { // Stufe405->Stufe
    Stufe
    rotate 90.0*z
    translate  <0.0, 0.0, 283.5>
  }
  object { // Stufe406->Stufe
    Stufe
    rotate 84.0*z
    translate  <0.0, 0.0, 284.2>
  }
  object { // Stufe407->Stufe
    Stufe
    rotate 78.0*z
    translate  <0.0, 0.0, 284.9>
  }
  object { // Stufe408->Stufe
    Stufe
    rotate 72.0*z
    translate  <0.0, 0.0, 285.6>
  }
  object { // Stufe409->Stufe
    Stufe
    rotate 66.0*z
    translate  <0.0, 0.0, 286.3>
  }
  object { // Stufe410->Stufe
    Stufe
    rotate 60.0*z
    translate  <0.0, 0.0, 287.0>
  }
  object { // Stufe411->Stufe
    Stufe
    rotate 54.0*z
    translate  <0.0, 0.0, 287.7>
  }
  object { // Stufe412->Stufe
    Stufe
    rotate 48.0*z
    translate  <0.0, 0.0, 288.4>
  }
  object { // Stufe413->Stufe
    Stufe
    rotate 42.0*z
    translate  <0.0, 0.0, 289.1>
  }
  object { // Stufe414->Stufe
    Stufe
    rotate 36.0*z
    translate  <0.0, 0.0, 289.8>
  }
  object { // Stufe415->Stufe
    Stufe
    rotate 30.0*z
    translate  <0.0, 0.0, 290.5>
  }
  object { // Stufe416->Stufe
    Stufe
    rotate 24.0*z
    translate  <0.0, 0.0, 291.2>
  }
  object { // Stufe417->Stufe
    Stufe
    rotate 18.0*z
    translate  <0.0, 0.0, 291.9>
  }
  object { // Stufe418->Stufe
    Stufe
    rotate 12.0*z
    translate  <0.0, 0.0, 292.6>
  }
  object { // Stufe419->Stufe
    Stufe
    rotate 6.0*z
    translate  <0.0, 0.0, 293.3>
  }
  object { // Stufe420->Stufe
    Stufe
    rotate 0.0*z
    translate  <0.0, 0.0, 294.0>
  }
  object { GelaenderCsg }
  object { // GelaenderCsg1->GelaenderCsg
    GelaenderCsg
    rotate -12.0*z
    translate  1.4*z
  }
  object { // GelaenderCsg2->GelaenderCsg
    GelaenderCsg
    rotate -24.0*z
    translate  2.8*z
  }
  object { // GelaenderCsg3->GelaenderCsg
    GelaenderCsg
    rotate -36.0*z
    translate  4.2*z
  }
  object { // GelaenderCsg4->GelaenderCsg
    GelaenderCsg
    rotate -48.0*z
    translate  5.6*z
  }
  object { // GelaenderCsg5->GelaenderCsg
    GelaenderCsg
    rotate -60.0*z
    translate  7.0*z
  }
  object { // GelaenderCsg6->GelaenderCsg
    GelaenderCsg
    rotate -72.0*z
    translate  8.4*z
  }
  object { // GelaenderCsg7->GelaenderCsg
    GelaenderCsg
    rotate -84.0*z
    translate  9.8*z
  }
  object { // GelaenderCsg8->GelaenderCsg
    GelaenderCsg
    rotate -96.0*z
    translate  11.2*z
  }
  object { // GelaenderCsg9->GelaenderCsg
    GelaenderCsg
    rotate -108.0*z
    translate  12.6*z
  }
  object { // GelaenderCsg10->GelaenderCsg
    GelaenderCsg
    rotate -120.0*z
    translate  14.0*z
  }
  object { // GelaenderCsg11->GelaenderCsg
    GelaenderCsg
    rotate -132.0*z
    translate  15.4*z
  }
  object { // GelaenderCsg12->GelaenderCsg
    GelaenderCsg
    rotate -144.0*z
    translate  16.8*z
  }
  object { // GelaenderCsg13->GelaenderCsg
    GelaenderCsg
    rotate -156.0*z
    translate  18.2*z
  }
  object { // GelaenderCsg14->GelaenderCsg
    GelaenderCsg
    rotate -168.0*z
    translate  19.6*z
  }
  object { // GelaenderCsg15->GelaenderCsg
    GelaenderCsg
    rotate 180.0*z
    translate  21.0*z
  }
  object { // GelaenderCsg16->GelaenderCsg
    GelaenderCsg
    rotate 168.0*z
    translate  22.4*z
  }
  object { // GelaenderCsg17->GelaenderCsg
    GelaenderCsg
    rotate 156.0*z
    translate  23.8*z
  }
  object { // GelaenderCsg18->GelaenderCsg
    GelaenderCsg
    rotate 144.0*z
    translate  25.2*z
  }
  object { // GelaenderCsg19->GelaenderCsg
    GelaenderCsg
    rotate 132.0*z
    translate  26.6*z
  }
  object { // GelaenderCsg20->GelaenderCsg
    GelaenderCsg
    rotate 120.0*z
    translate  28.0*z
  }
  object { // GelaenderCsg21->GelaenderCsg
    GelaenderCsg
    rotate 108.0*z
    translate  29.4*z
  }
  object { // GelaenderCsg22->GelaenderCsg
    GelaenderCsg
    rotate 96.0*z
    translate  30.8*z
  }
  object { // GelaenderCsg23->GelaenderCsg
    GelaenderCsg
    rotate 84.0*z
    translate  32.2*z
  }
  object { // GelaenderCsg24->GelaenderCsg
    GelaenderCsg
    rotate 72.0*z
    translate  33.6*z
  }
  object { // GelaenderCsg25->GelaenderCsg
    GelaenderCsg
    rotate 60.0*z
    translate  35.0*z
  }
  object { // GelaenderCsg26->GelaenderCsg
    GelaenderCsg
    rotate 48.0*z
    translate  36.4*z
  }
  object { // GelaenderCsg27->GelaenderCsg
    GelaenderCsg
    rotate 36.0*z
    translate  37.8*z
  }
  object { // GelaenderCsg28->GelaenderCsg
    GelaenderCsg
    rotate 24.0*z
    translate  39.2*z
  }
  object { // GelaenderCsg29->GelaenderCsg
    GelaenderCsg
    rotate 12.0*z
    translate  40.6*z
  }
  object { // GelaenderCsg30->GelaenderCsg
    GelaenderCsg
    rotate 0.0*z
    translate  42.0*z
  }
  object { // GelaenderCsg31->GelaenderCsg
    GelaenderCsg
    rotate -12.0*z
    translate  43.4*z
  }
  object { // GelaenderCsg32->GelaenderCsg
    GelaenderCsg
    rotate -24.0*z
    translate  44.8*z
  }
  object { // GelaenderCsg33->GelaenderCsg
    GelaenderCsg
    rotate -36.0*z
    translate  46.2*z
  }
  object { // GelaenderCsg34->GelaenderCsg
    GelaenderCsg
    rotate -48.0*z
    translate  47.6*z
  }
  object { // GelaenderCsg35->GelaenderCsg
    GelaenderCsg
    rotate -60.0*z
    translate  49.0*z
  }
  object { // GelaenderCsg36->GelaenderCsg
    GelaenderCsg
    rotate -72.0*z
    translate  50.4*z
  }
  object { // GelaenderCsg37->GelaenderCsg
    GelaenderCsg
    rotate -84.0*z
    translate  51.8*z
  }
  object { // GelaenderCsg38->GelaenderCsg
    GelaenderCsg
    rotate -96.0*z
    translate  53.2*z
  }
  object { // GelaenderCsg39->GelaenderCsg
    GelaenderCsg
    rotate -108.0*z
    translate  54.6*z
  }
  object { // GelaenderCsg40->GelaenderCsg
    GelaenderCsg
    rotate -120.0*z
    translate  56.0*z
  }
  object { // GelaenderCsg41->GelaenderCsg
    GelaenderCsg
    rotate -132.0*z
    translate  57.4*z
  }
  object { // GelaenderCsg42->GelaenderCsg
    GelaenderCsg
    rotate -144.0*z
    translate  58.8*z
  }
  object { // GelaenderCsg43->GelaenderCsg
    GelaenderCsg
    rotate -156.0*z
    translate  60.2*z
  }
  object { // GelaenderCsg44->GelaenderCsg
    GelaenderCsg
    rotate -168.0*z
    translate  61.6*z
  }
  object { // GelaenderCsg45->GelaenderCsg
    GelaenderCsg
    rotate 180.0*z
    translate  63.0*z
  }
  object { // GelaenderCsg46->GelaenderCsg
    GelaenderCsg
    rotate 168.0*z
    translate  64.4*z
  }
  object { // GelaenderCsg47->GelaenderCsg
    GelaenderCsg
    rotate 156.0*z
    translate  65.8*z
  }
  object { // GelaenderCsg48->GelaenderCsg
    GelaenderCsg
    rotate 144.0*z
    translate  67.2*z
  }
  object { // GelaenderCsg49->GelaenderCsg
    GelaenderCsg
    rotate 132.0*z
    translate  68.6*z
  }
  object { // GelaenderCsg50->GelaenderCsg
    GelaenderCsg
    rotate 120.0*z
    translate  70.0*z
  }
  object { // GelaenderCsg51->GelaenderCsg
    GelaenderCsg
    rotate 108.0*z
    translate  71.4*z
  }
  object { // GelaenderCsg52->GelaenderCsg
    GelaenderCsg
    rotate 96.0*z
    translate  72.8*z
  }
  object { // GelaenderCsg53->GelaenderCsg
    GelaenderCsg
    rotate 84.0*z
    translate  74.2*z
  }
  object { // GelaenderCsg54->GelaenderCsg
    GelaenderCsg
    rotate 72.0*z
    translate  75.6*z
  }
  object { // GelaenderCsg55->GelaenderCsg
    GelaenderCsg
    rotate 60.0*z
    translate  77.0*z
  }
  object { // GelaenderCsg56->GelaenderCsg
    GelaenderCsg
    rotate 48.0*z
    translate  78.4*z
  }
  object { // GelaenderCsg57->GelaenderCsg
    GelaenderCsg
    rotate 36.0*z
    translate  79.8*z
  }
  object { // GelaenderCsg58->GelaenderCsg
    GelaenderCsg
    rotate 24.0*z
    translate  81.2*z
  }
  object { // GelaenderCsg59->GelaenderCsg
    GelaenderCsg
    rotate 12.0*z
    translate  82.6*z
  }
  object { // GelaenderCsg60->GelaenderCsg
    GelaenderCsg
    rotate 0.0*z
    translate  84.0*z
  }
  object { // GelaenderCsg61->GelaenderCsg
    GelaenderCsg
    rotate -12.0*z
    translate  85.4*z
  }
  object { // GelaenderCsg62->GelaenderCsg
    GelaenderCsg
    rotate -24.0*z
    translate  86.8*z
  }
  object { // GelaenderCsg63->GelaenderCsg
    GelaenderCsg
    rotate -36.0*z
    translate  88.2*z
  }
  object { // GelaenderCsg64->GelaenderCsg
    GelaenderCsg
    rotate -48.0*z
    translate  89.6*z
  }
  object { // GelaenderCsg65->GelaenderCsg
    GelaenderCsg
    rotate -60.0*z
    translate  91.0*z
  }
  object { // GelaenderCsg66->GelaenderCsg
    GelaenderCsg
    rotate -72.0*z
    translate  92.4*z
  }
  object { // GelaenderCsg67->GelaenderCsg
    GelaenderCsg
    rotate -84.0*z
    translate  93.8*z
  }
  object { // GelaenderCsg68->GelaenderCsg
    GelaenderCsg
    rotate -96.0*z
    translate  95.2*z
  }
  object { // GelaenderCsg69->GelaenderCsg
    GelaenderCsg
    rotate -108.0*z
    translate  96.6*z
  }
  object { // GelaenderCsg70->GelaenderCsg
    GelaenderCsg
    rotate -120.0*z
    translate  98.0*z
  }
  object { // GelaenderCsg71->GelaenderCsg
    GelaenderCsg
    rotate -132.0*z
    translate  99.4*z
  }
  object { // GelaenderCsg72->GelaenderCsg
    GelaenderCsg
    rotate -144.0*z
    translate  100.8*z
  }
  object { // GelaenderCsg73->GelaenderCsg
    GelaenderCsg
    rotate -156.0*z
    translate  102.2*z
  }
  object { // GelaenderCsg74->GelaenderCsg
    GelaenderCsg
    rotate -168.0*z
    translate  103.6*z
  }
  object { // GelaenderCsg75->GelaenderCsg
    GelaenderCsg
    rotate 180.0*z
    translate  105.0*z
  }
  object { // GelaenderCsg76->GelaenderCsg
    GelaenderCsg
    rotate 168.0*z
    translate  106.4*z
  }
  object { // GelaenderCsg77->GelaenderCsg
    GelaenderCsg
    rotate 156.0*z
    translate  107.8*z
  }
  object { // GelaenderCsg78->GelaenderCsg
    GelaenderCsg
    rotate 144.0*z
    translate  109.2*z
  }
  object { // GelaenderCsg79->GelaenderCsg
    GelaenderCsg
    rotate 132.0*z
    translate  110.6*z
  }
  object { // GelaenderCsg80->GelaenderCsg
    GelaenderCsg
    rotate 120.0*z
    translate  112.0*z
  }
  object { // GelaenderCsg81->GelaenderCsg
    GelaenderCsg
    rotate 108.0*z
    translate  113.4*z
  }
  object { // GelaenderCsg82->GelaenderCsg
    GelaenderCsg
    rotate 96.0*z
    translate  114.8*z
  }
  object { // GelaenderCsg83->GelaenderCsg
    GelaenderCsg
    rotate 84.0*z
    translate  116.2*z
  }
  object { // GelaenderCsg84->GelaenderCsg
    GelaenderCsg
    rotate 72.0*z
    translate  117.6*z
  }
  object { // GelaenderCsg85->GelaenderCsg
    GelaenderCsg
    rotate 60.0*z
    translate  119.0*z
  }
  object { // GelaenderCsg86->GelaenderCsg
    GelaenderCsg
    rotate 48.0*z
    translate  120.4*z
  }
  object { // GelaenderCsg87->GelaenderCsg
    GelaenderCsg
    rotate 36.0*z
    translate  121.8*z
  }
  object { // GelaenderCsg88->GelaenderCsg
    GelaenderCsg
    rotate 24.0*z
    translate  123.2*z
  }
  object { // GelaenderCsg89->GelaenderCsg
    GelaenderCsg
    rotate 12.0*z
    translate  124.6*z
  }
  object { // GelaenderCsg90->GelaenderCsg
    GelaenderCsg
    rotate 0.0*z
    translate  126.0*z
  }
  object { // GelaenderCsg91->GelaenderCsg
    GelaenderCsg
    rotate -12.0*z
    translate  127.4*z
  }
  object { // GelaenderCsg92->GelaenderCsg
    GelaenderCsg
    rotate -24.0*z
    translate  128.8*z
  }
  object { // GelaenderCsg93->GelaenderCsg
    GelaenderCsg
    rotate -36.0*z
    translate  130.2*z
  }
  object { // GelaenderCsg94->GelaenderCsg
    GelaenderCsg
    rotate -48.0*z
    translate  131.6*z
  }
  object { // GelaenderCsg95->GelaenderCsg
    GelaenderCsg
    rotate -60.0*z
    translate  133.0*z
  }
  object { // GelaenderCsg96->GelaenderCsg
    GelaenderCsg
    rotate -72.0*z
    translate  134.4*z
  }
  object { // GelaenderCsg97->GelaenderCsg
    GelaenderCsg
    rotate -84.0*z
    translate  135.8*z
  }
  object { // GelaenderCsg98->GelaenderCsg
    GelaenderCsg
    rotate -96.0*z
    translate  137.2*z
  }
  object { // GelaenderCsg99->GelaenderCsg
    GelaenderCsg
    rotate -108.0*z
    translate  138.6*z
  }
  object { // GelaenderCs100->GelaenderCsg
    GelaenderCsg
    rotate -120.0*z
    translate  140.0*z
  }
  object { // GelaenderCs101->GelaenderCsg
    GelaenderCsg
    rotate -132.0*z
    translate  141.4*z
  }
  object { // GelaenderCs102->GelaenderCsg
    GelaenderCsg
    rotate -144.0*z
    translate  142.8*z
  }
  object { // GelaenderCs103->GelaenderCsg
    GelaenderCsg
    rotate -156.0*z
    translate  144.2*z
  }
  object { // GelaenderCs104->GelaenderCsg
    GelaenderCsg
    rotate -168.0*z
    translate  145.6*z
  }
  object { // GelaenderCs105->GelaenderCsg
    GelaenderCsg
    rotate 180.0*z
    translate  147.0*z
  }
  object { // GelaenderCs106->GelaenderCsg
    GelaenderCsg
    rotate 168.0*z
    translate  148.4*z
  }
  object { // GelaenderCs107->GelaenderCsg
    GelaenderCsg
    rotate 156.0*z
    translate  149.8*z
  }
  object { // GelaenderCs108->GelaenderCsg
    GelaenderCsg
    rotate 144.0*z
    translate  151.2*z
  }
  object { // GelaenderCs109->GelaenderCsg
    GelaenderCsg
    rotate 132.0*z
    translate  152.6*z
  }
  object { // GelaenderCs110->GelaenderCsg
    GelaenderCsg
    rotate 120.0*z
    translate  154.0*z
  }
  object { // GelaenderCs111->GelaenderCsg
    GelaenderCsg
    rotate 108.0*z
    translate  155.4*z
  }
  object { // GelaenderCs112->GelaenderCsg
    GelaenderCsg
    rotate 96.0*z
    translate  156.8*z
  }
  object { // GelaenderCs113->GelaenderCsg
    GelaenderCsg
    rotate 84.0*z
    translate  158.2*z
  }
  object { // GelaenderCs114->GelaenderCsg
    GelaenderCsg
    rotate 72.0*z
    translate  159.6*z
  }
  object { // GelaenderCs115->GelaenderCsg
    GelaenderCsg
    rotate 60.0*z
    translate  161.0*z
  }
  object { // GelaenderCs116->GelaenderCsg
    GelaenderCsg
    rotate 48.0*z
    translate  162.4*z
  }
  object { // GelaenderCs117->GelaenderCsg
    GelaenderCsg
    rotate 36.0*z
    translate  163.8*z
  }
  object { // GelaenderCs118->GelaenderCsg
    GelaenderCsg
    rotate 24.0*z
    translate  165.2*z
  }
  object { // GelaenderCs119->GelaenderCsg
    GelaenderCsg
    rotate 12.0*z
    translate  166.6*z
  }
  object { // GelaenderCs120->GelaenderCsg
    GelaenderCsg
    rotate 0.0*z
    translate  168.0*z
  }
  object { // GelaenderCs121->GelaenderCsg
    GelaenderCsg
    rotate -12.0*z
    translate  169.4*z
  }
  object { // GelaenderCs122->GelaenderCsg
    GelaenderCsg
    rotate -24.0*z
    translate  170.8*z
  }
  object { // GelaenderCs123->GelaenderCsg
    GelaenderCsg
    rotate -36.0*z
    translate  172.2*z
  }
  object { // GelaenderCs124->GelaenderCsg
    GelaenderCsg
    rotate -48.0*z
    translate  173.6*z
  }
  object { // GelaenderCs125->GelaenderCsg
    GelaenderCsg
    rotate -60.0*z
    translate  175.0*z
  }
  object { // GelaenderCs126->GelaenderCsg
    GelaenderCsg
    rotate -72.0*z
    translate  176.4*z
  }
  object { // GelaenderCs127->GelaenderCsg
    GelaenderCsg
    rotate -84.0*z
    translate  177.8*z
  }
  object { // GelaenderCs128->GelaenderCsg
    GelaenderCsg
    rotate -96.0*z
    translate  179.2*z
  }
  object { // GelaenderCs129->GelaenderCsg
    GelaenderCsg
    rotate -108.0*z
    translate  180.6*z
  }
  object { // GelaenderCs130->GelaenderCsg
    GelaenderCsg
    rotate -120.0*z
    translate  182.0*z
  }
  object { // GelaenderCs131->GelaenderCsg
    GelaenderCsg
    rotate -132.0*z
    translate  183.4*z
  }
  object { // GelaenderCs132->GelaenderCsg
    GelaenderCsg
    rotate -144.0*z
    translate  184.8*z
  }
  object { // GelaenderCs133->GelaenderCsg
    GelaenderCsg
    rotate -156.0*z
    translate  186.2*z
  }
  object { // GelaenderCs134->GelaenderCsg
    GelaenderCsg
    rotate -168.0*z
    translate  187.6*z
  }
  object { // GelaenderCs135->GelaenderCsg
    GelaenderCsg
    rotate 180.0*z
    translate  189.0*z
  }
  object { // GelaenderCs136->GelaenderCsg
    GelaenderCsg
    rotate 168.0*z
    translate  190.4*z
  }
  object { // GelaenderCs137->GelaenderCsg
    GelaenderCsg
    rotate 156.0*z
    translate  191.8*z
  }
  object { // GelaenderCs138->GelaenderCsg
    GelaenderCsg
    rotate 144.0*z
    translate  193.2*z
  }
  object { // GelaenderCs139->GelaenderCsg
    GelaenderCsg
    rotate 132.0*z
    translate  194.6*z
  }
  object { // GelaenderCs140->GelaenderCsg
    GelaenderCsg
    rotate 120.0*z
    translate  196.0*z
  }
  object { // GelaenderCs141->GelaenderCsg
    GelaenderCsg
    rotate 108.0*z
    translate  197.4*z
  }
  object { // GelaenderCs142->GelaenderCsg
    GelaenderCsg
    rotate 96.0*z
    translate  198.8*z
  }
  object { // GelaenderCs143->GelaenderCsg
    GelaenderCsg
    rotate 84.0*z
    translate  200.2*z
  }
  object { // GelaenderCs144->GelaenderCsg
    GelaenderCsg
    rotate 72.0*z
    translate  201.6*z
  }
  object { // GelaenderCs145->GelaenderCsg
    GelaenderCsg
    rotate 60.0*z
    translate  203.0*z
  }
  object { // GelaenderCs146->GelaenderCsg
    GelaenderCsg
    rotate 48.0*z
    translate  204.4*z
  }
  object { // GelaenderCs147->GelaenderCsg
    GelaenderCsg
    rotate 36.0*z
    translate  205.8*z
  }
  object { // GelaenderCs148->GelaenderCsg
    GelaenderCsg
    rotate 24.0*z
    translate  207.2*z
  }
  object { // GelaenderCs149->GelaenderCsg
    GelaenderCsg
    rotate 12.0*z
    translate  208.6*z
  }
  object { // GelaenderCs150->GelaenderCsg
    GelaenderCsg
    rotate 0.0*z
    translate  210.0*z
  }
  object { // GelaenderCs151->GelaenderCsg
    GelaenderCsg
    rotate -12.0*z
    translate  211.4*z
  }
  object { // GelaenderCs152->GelaenderCsg
    GelaenderCsg
    rotate -24.0*z
    translate  212.8*z
  }
  object { // GelaenderCs153->GelaenderCsg
    GelaenderCsg
    rotate -36.0*z
    translate  214.2*z
  }
  object { // GelaenderCs154->GelaenderCsg
    GelaenderCsg
    rotate -48.0*z
    translate  215.6*z
  }
  object { // GelaenderCs155->GelaenderCsg
    GelaenderCsg
    rotate -60.0*z
    translate  217.0*z
  }
  object { // GelaenderCs156->GelaenderCsg
    GelaenderCsg
    rotate -72.0*z
    translate  218.4*z
  }
  object { // GelaenderCs157->GelaenderCsg
    GelaenderCsg
    rotate -84.0*z
    translate  219.8*z
  }
  object { // GelaenderCs158->GelaenderCsg
    GelaenderCsg
    rotate -96.0*z
    translate  221.2*z
  }
  object { // GelaenderCs159->GelaenderCsg
    GelaenderCsg
    rotate -108.0*z
    translate  222.6*z
  }
  object { // GelaenderCs160->GelaenderCsg
    GelaenderCsg
    rotate -120.0*z
    translate  224.0*z
  }
  object { // GelaenderCs161->GelaenderCsg
    GelaenderCsg
    rotate -132.0*z
    translate  225.4*z
  }
  object { // GelaenderCs162->GelaenderCsg
    GelaenderCsg
    rotate -144.0*z
    translate  226.8*z
  }
  object { // GelaenderCs163->GelaenderCsg
    GelaenderCsg
    rotate -156.0*z
    translate  228.2*z
  }
  object { // GelaenderCs164->GelaenderCsg
    GelaenderCsg
    rotate -168.0*z
    translate  229.6*z
  }
  object { // GelaenderCs165->GelaenderCsg
    GelaenderCsg
    rotate 180.0*z
    translate  231.0*z
  }
  object { // GelaenderCs166->GelaenderCsg
    GelaenderCsg
    rotate 168.0*z
    translate  232.4*z
  }
  object { // GelaenderCs167->GelaenderCsg
    GelaenderCsg
    rotate 156.0*z
    translate  233.8*z
  }
  object { // GelaenderCs168->GelaenderCsg
    GelaenderCsg
    rotate 144.0*z
    translate  235.2*z
  }
  object { // GelaenderCs169->GelaenderCsg
    GelaenderCsg
    rotate 132.0*z
    translate  236.6*z
  }
  object { // GelaenderCs170->GelaenderCsg
    GelaenderCsg
    rotate 120.0*z
    translate  238.0*z
  }
  object { // GelaenderCs171->GelaenderCsg
    GelaenderCsg
    rotate 108.0*z
    translate  239.4*z
  }
  object { // GelaenderCs172->GelaenderCsg
    GelaenderCsg
    rotate 96.0*z
    translate  240.8*z
  }
  object { // GelaenderCs173->GelaenderCsg
    GelaenderCsg
    rotate 84.0*z
    translate  242.2*z
  }
  object { // GelaenderCs174->GelaenderCsg
    GelaenderCsg
    rotate 72.0*z
    translate  243.6*z
  }
  object { // GelaenderCs175->GelaenderCsg
    GelaenderCsg
    rotate 60.0*z
    translate  245.0*z
  }
  object { // GelaenderCs176->GelaenderCsg
    GelaenderCsg
    rotate 48.0*z
    translate  246.4*z
  }
  object { // GelaenderCs177->GelaenderCsg
    GelaenderCsg
    rotate 36.0*z
    translate  247.8*z
  }
  object { // GelaenderCs178->GelaenderCsg
    GelaenderCsg
    rotate 24.0*z
    translate  249.2*z
  }
  object { // GelaenderCs179->GelaenderCsg
    GelaenderCsg
    rotate 12.0*z
    translate  250.6*z
  }
  object { // GelaenderCs180->GelaenderCsg
    GelaenderCsg
    rotate 0.0*z
    translate  252.0*z
  }
  object { // GelaenderCs181->GelaenderCsg
    GelaenderCsg
    rotate -12.0*z
    translate  253.4*z
  }
  object { // GelaenderCs182->GelaenderCsg
    GelaenderCsg
    rotate -24.0*z
    translate  254.8*z
  }
  object { // GelaenderCs183->GelaenderCsg
    GelaenderCsg
    rotate -36.0*z
    translate  256.2*z
  }
  object { // GelaenderCs184->GelaenderCsg
    GelaenderCsg
    rotate -48.0*z
    translate  257.6*z
  }
  object { // GelaenderCs185->GelaenderCsg
    GelaenderCsg
    rotate -60.0*z
    translate  259.0*z
  }
  object { // GelaenderCs186->GelaenderCsg
    GelaenderCsg
    rotate -72.0*z
    translate  260.4*z
  }
  object { // GelaenderCs187->GelaenderCsg
    GelaenderCsg
    rotate -84.0*z
    translate  261.8*z
  }
  object { // GelaenderCs188->GelaenderCsg
    GelaenderCsg
    rotate -96.0*z
    translate  263.2*z
  }
  object { // GelaenderCs189->GelaenderCsg
    GelaenderCsg
    rotate -108.0*z
    translate  264.6*z
  }
  object { // GelaenderCs190->GelaenderCsg
    GelaenderCsg
    rotate -120.0*z
    translate  266.0*z
  }
  object { // GelaenderCs191->GelaenderCsg
    GelaenderCsg
    rotate -132.0*z
    translate  267.4*z
  }
  object { // GelaenderCs192->GelaenderCsg
    GelaenderCsg
    rotate -144.0*z
    translate  268.8*z
  }
  object { // GelaenderCs193->GelaenderCsg
    GelaenderCsg
    rotate -156.0*z
    translate  270.2*z
  }
  object { // GelaenderCs194->GelaenderCsg
    GelaenderCsg
    rotate -168.0*z
    translate  271.6*z
  }
  object { // GelaenderCs195->GelaenderCsg
    GelaenderCsg
    rotate 180.0*z
    translate  273.0*z
  }
  object { // GelaenderCs196->GelaenderCsg
    GelaenderCsg
    rotate 168.0*z
    translate  274.4*z
  }
  object { // GelaenderCs197->GelaenderCsg
    GelaenderCsg
    rotate 156.0*z
    translate  275.8*z
  }
  object { // GelaenderCs198->GelaenderCsg
    GelaenderCsg
    rotate 144.0*z
    translate  277.2*z
  }
  object { // GelaenderCs199->GelaenderCsg
    GelaenderCsg
    rotate 132.0*z
    translate  278.6*z
  }
  object { // GelaenderCs200->GelaenderCsg
    GelaenderCsg
    rotate 120.0*z
    translate  280.0*z
  }
  object { // GelaenderCs201->GelaenderCsg
    GelaenderCsg
    rotate 108.0*z
    translate  281.4*z
  }
  object { // GelaenderCs202->GelaenderCsg
    GelaenderCsg
    rotate 96.0*z
    translate  282.8*z
  }
  object { // GelaenderCs203->GelaenderCsg
    GelaenderCsg
    rotate 84.0*z
    translate  284.2*z
  }
  object { // GelaenderCs204->GelaenderCsg
    GelaenderCsg
    rotate 72.0*z
    translate  285.6*z
  }
  object { // GelaenderCs205->GelaenderCsg
    GelaenderCsg
    rotate 60.0*z
    translate  287.0*z
  }
  object { // GelaenderCs206->GelaenderCsg
    GelaenderCsg
    rotate 48.0*z
    translate  288.4*z
  }
  object { // GelaenderCs207->GelaenderCsg
    GelaenderCsg
    rotate 36.0*z
    translate  289.8*z
  }
  object { // GelaenderCs208->GelaenderCsg
    GelaenderCsg
    rotate 24.0*z
    translate  291.2*z
  }
  object { // GelaenderCs209->GelaenderCsg
    GelaenderCsg
    rotate 12.0*z
    translate  292.6*z
  }
  object { // GelaenderCs210->GelaenderCsg
    GelaenderCsg
    rotate 0.0*z
    translate  294.0*z
  }
}


#declare FensterLoch1 = union {
  box { // Fenster5
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 2.0>
    translate  <-1.2, 0.0, 2.2>
  }
  box { // Fenster6
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 2.0>
    translate  <1.2, 0.0, 2.2>
  }
  box { // Fenster7
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 2.0>
    translate  <1.2, 0.0, -2.2>
  }
  box { // Fenster8
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 2.0>
    translate  <-1.2, 0.0, -2.2>
  }
  rotate -150.0*z
  translate  <6.25, -10.825318, 27.5>
}
#declare FensterLoch2 = union {
  box { // Fenster9
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 2.0>
    translate  <-1.2, 0.0, 2.2>
  }
  box { // Fenster10
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 2.0>
    translate  <1.2, 0.0, 2.2>
  }
  box { // Fenster11
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 2.0>
    translate  <1.2, 0.0, -2.2>
  }
  box { // Fenster12
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 2.0>
    translate  <-1.2, 0.0, -2.2>
  }
  rotate -300.0*z
  translate  <-10.825318, 6.25, 45.0>
}
#declare FensterLoch3 = union {
  box { // Fenster13
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 2.0>
    translate  <-1.2, 0.0, 2.2>
  }
  box { // Fenster14
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 2.0>
    translate  <1.2, 0.0, 2.2>
  }
  box { // Fenster15
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 2.0>
    translate  <1.2, 0.0, -2.2>
  }
  box { // Fenster16
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 2.0>
    translate  <-1.2, 0.0, -2.2>
  }
  rotate -450.0*z
  translate  <12.5, 0.0, 62.5>
}
#declare FensterLoch4 = union {
  box { // Fenster17
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 2.0>
    translate  <-1.2, 0.0, 2.2>
  }
  box { // Fenster18
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 2.0>
    translate  <1.2, 0.0, 2.2>
  }
  box { // Fenster19
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 2.0>
    translate  <1.2, 0.0, -2.2>
  }
  box { // Fenster20
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 2.0>
    translate  <-1.2, 0.0, -2.2>
  }
  rotate -600.0*z
  translate  <-10.825318, -6.25, 80.0>
}
#declare FensterLoch5 = union {
  box { // Fenster21
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 2.0>
    translate  <-1.2, 0.0, 2.2>
  }
  box { // Fenster22
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 2.0>
    translate  <1.2, 0.0, 2.2>
  }
  box { // Fenster23
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 2.0>
    translate  <1.2, 0.0, -2.2>
  }
  box { // Fenster24
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 2.0>
    translate  <-1.2, 0.0, -2.2>
  }
  rotate -750.0*z
  translate  <6.25, 10.825318, 97.5>
}
#declare FensterLoch6 = union {
  box { // Fenster25
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 2.0>
    translate  <-1.2, 0.0, 2.2>
  }
  box { // Fenster26
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 2.0>
    translate  <1.2, 0.0, 2.2>
  }
  box { // Fenster27
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 2.0>
    translate  <1.2, 0.0, -2.2>
  }
  box { // Fenster28
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 2.0>
    translate  <-1.2, 0.0, -2.2>
  }
  rotate -900.0*z
  translate  <0.0, -12.5, 115.0>
}
#declare FensterLoch7 = union {
  box { // Fenster29
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 2.0>
    translate  <-1.2, 0.0, 2.2>
  }
  box { // Fenster30
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 2.0>
    translate  <1.2, 0.0, 2.2>
  }
  box { // Fenster31
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 2.0>
    translate  <1.2, 0.0, -2.2>
  }
  box { // Fenster32
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 2.0>
    translate  <-1.2, 0.0, -2.2>
  }
  rotate -1050.0*z
  translate  <-6.25, 10.825318, 132.5>
}
#declare FensterLoch8 = union {
  box { // Fenster33
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 2.0>
    translate  <-1.2, 0.0, 2.2>
  }
  box { // Fenster34
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 2.0>
    translate  <1.2, 0.0, 2.2>
  }
  box { // Fenster35
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 2.0>
    translate  <1.2, 0.0, -2.2>
  }
  box { // Fenster36
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 2.0>
    translate  <-1.2, 0.0, -2.2>
  }
  rotate -1200.0*z
  translate  <10.825318, -6.25, 150.0>
}
#declare FensterLoch9 = union {
  box { // Fenster37
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 2.0>
    translate  <-1.2, 0.0, 2.2>
  }
  box { // Fenster38
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 2.0>
    translate  <1.2, 0.0, 2.2>
  }
  box { // Fenster39
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 2.0>
    translate  <1.2, 0.0, -2.2>
  }
  box { // Fenster40
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 2.0>
    translate  <-1.2, 0.0, -2.2>
  }
  rotate -1350.0*z
  translate  <-12.5, 0.0, 167.5>
}
#declare FensterLoch10 = union {
  box { // Fenster41
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 2.0>
    translate  <-1.2, 0.0, 2.2>
  }
  box { // Fenster42
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 2.0>
    translate  <1.2, 0.0, 2.2>
  }
  box { // Fenster43
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 2.0>
    translate  <1.2, 0.0, -2.2>
  }
  box { // Fenster44
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 2.0>
    translate  <-1.2, 0.0, -2.2>
  }
  rotate -1500.0*z
  translate  <10.825318, 6.25, 185.0>
}
#declare FensterLoch11 = union {
  box { // Fenster45
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 2.0>
    translate  <-1.2, 0.0, 2.2>
  }
  box { // Fenster46
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 2.0>
    translate  <1.2, 0.0, 2.2>
  }
  box { // Fenster47
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 2.0>
    translate  <1.2, 0.0, -2.2>
  }
  box { // Fenster48
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 2.0>
    translate  <-1.2, 0.0, -2.2>
  }
  rotate -1650.0*z
  translate  <-6.25, -10.825318, 202.5>
}
#declare FensterLoch12 = union {
  box { // Fenster49
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 2.0>
    translate  <-1.2, 0.0, 2.2>
  }
  box { // Fenster50
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 2.0>
    translate  <1.2, 0.0, 2.2>
  }
  box { // Fenster51
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 2.0>
    translate  <1.2, 0.0, -2.2>
  }
  box { // Fenster52
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 2.0>
    translate  <-1.2, 0.0, -2.2>
  }
  rotate -1800.0*z
  translate  <0.0, 12.5, 220.0>
}
#declare FensterLoch13 = union {
  box { // Fenster53
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 2.0>
    translate  <-1.2, 0.0, 2.2>
  }
  box { // Fenster54
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 2.0>
    translate  <1.2, 0.0, 2.2>
  }
  box { // Fenster55
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 2.0>
    translate  <1.2, 0.0, -2.2>
  }
  box { // Fenster56
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 2.0>
    translate  <-1.2, 0.0, -2.2>
  }
  rotate -1950.0*z
  translate  <6.25, -10.825318, 237.5>
}
#declare FensterLoch14 = union {
  box { // Fenster57
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 2.0>
    translate  <-1.2, 0.0, 2.2>
  }
  box { // Fenster58
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 2.0>
    translate  <1.2, 0.0, 2.2>
  }
  box { // Fenster59
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 2.0>
    translate  <1.2, 0.0, -2.2>
  }
  box { // Fenster60
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 2.0>
    translate  <-1.2, 0.0, -2.2>
  }
  rotate -2100.0*z
  translate  <-10.825318, 6.25, 255.0>
}
#declare FensterLoch15 = union {
  box { // Fenster61
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 2.0>
    translate  <-1.2, 0.0, 2.2>
  }
  box { // Fenster62
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 2.0>
    translate  <1.2, 0.0, 2.2>
  }
  box { // Fenster63
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 2.0>
    translate  <1.2, 0.0, -2.2>
  }
  box { // Fenster64
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 2.0>
    translate  <-1.2, 0.0, -2.2>
  }
  rotate -2250.0*z
  translate  <12.5, 0.0, 272.5>
}
#declare FensterLoch16 = union {
  box { // Fenster65
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 2.0>
    translate  <-1.2, 0.0, 2.2>
  }
  box { // Fenster66
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 2.0>
    translate  <1.2, 0.0, 2.2>
  }
  box { // Fenster67
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 2.0>
    translate  <1.2, 0.0, -2.2>
  }
  box { // Fenster68
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 2.0>
    translate  <-1.2, 0.0, -2.2>
  }
  rotate -2400.0*z
  translate  <-10.825318, -6.25, 290.0>
}
#declare FensterLoch = union {
  box { // Fenster1
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 2.0>
    translate  <-1.2, 0.0, 2.2>
  }
  box { // Fenster2
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 2.0>
    translate  <1.2, 0.0, 2.2>
  }
  box { // Fenster3
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 2.0>
    translate  <1.2, 0.0, -2.2>
  }
  box { // Fenster4
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 2.0>
    translate  <-1.2, 0.0, -2.2>
  }
  translate  <0.0, 12.5, 10.0>
}
difference { // WandMitFenster
  cylinder { // Wand
    <0,0,1>, <0,0,0>, 1
    scale <13.0, 13.0, 331.046906>
  }
  cylinder { // Wand1
    <0,0,1>, <0,0,0>, 1
    scale <12.5, 12.5, 333.0>
    translate  -0.607468*z
  }
  object { FensterLoch1 }
  object { FensterLoch2 }
  object { FensterLoch3 }
  object { FensterLoch4 }
  object { FensterLoch5 }
  object { FensterLoch6 }
  object { FensterLoch7 }
  object { FensterLoch8 }
  object { FensterLoch9 }
  object { FensterLoch10 }
  object { FensterLoch11 }
  object { FensterLoch12 }
  object { FensterLoch13 }
  object { FensterLoch14 }
  object { FensterLoch15 }
  object { FensterLoch16 }
  object { FensterLoch }
  texture {
    WhitePaint_Tex
  }
}


