
// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions


// ==== Additional Includes ====
#include "CHARS.INC"   // FIXME-add comments describing each of these
#include "CONSTS.INC"
#include "METALS.INC"
#include "SHAPES.INC"
#include "SHAPES2.INC"
#include "SHAPESQ.INC"
#include "SKIES.INC"
#include "STONES.INC"
#include "STONES2.INC"
#include "WOODMAPS.INC"
#include "WOODS.INC"

//*********************************************** THE VIEW OF THE PICTURE ***************************************

//**** THE SKY ****
sky_sphere {
    pigment {
        wrinkles
        turbulence 0.3
        omega 0.707
        octaves 5
        color_map {
            [0.0 color DustyRose * 2.5]
            [0.2 color Orange ]
            [0.8 color SlateBlue * 0.25]
            [1.0 color SkyBlue]
        }
        scale <0.5, 0.1, 1000>
    }
}

//**** MOUNTEN ****
height_field {
tga "d:\programs\paint\pov-prog.paz\mount.tga"
hierarchy
smooth
scale <70,70,70>
pigment { image_map {
		tga "d:\programs\paint\pov-prog.paz\earth.tga"}
		}
translate <5,0,-45>
}

//*********************************************** THE PLANE OF THE WRIGHT BROTHERS ********************************

#declare airplane=union {

superellipsoid{ <0.5,0.6>
texture {Yellow_Pine}
scale<1,2.7,0.2>
rotate<90,0,0>
}

superellipsoid{ <0.5,0.6>
texture {Yellow_Pine}
scale<1,2.7,0.2>
rotate<90,0,0>
translate <0,-2,0>
}

superellipsoid{ <0.5,0.6>
texture {Yellow_Pine}
scale<1,6.4,0.2>
rotate<90,0,0>
translate <-7,-2,0>
}

superellipsoid{ <0.5,0.6>
texture {Yellow_Pine}
scale<1,6.4,0.2>
rotate<90,0,0>
translate <-7,2,0>
}

#declare xx=-9.7
#while (xx<0)
       #declare yy= exp(xx)
       sphere{
               <xx,yy,0>, 0.14
               texture {T_Wood25}
               translate <0,-3.5,-0.7>
              }
       #declare xx=xx+0.01
       #declare yy=yy+1
#end

#declare xx=-9.7
#while (xx<0)
       #declare yy= exp(xx)
       sphere{
               <xx,yy,0>, 0.14
               texture {T_Wood25}
               translate <0,-3.5,0.7>
              }
       #declare xx=xx+0.01
       #declare yy=yy+1
#end

cylinder {
<0,-2.5,0.7>
<0,0,0.7>
0.14
texture {T_Wood25}
}

cylinder {
<0,-2.5,-0.7>
<0,0,-0.7>
0.14
texture {T_Wood25}
}

cylinder {
<0,-2,-2.2>
<0,0,-2.2>
0.14
texture {T_Wood25}
}

cylinder {
<0,-2,2.2>
<0,0,2.2>
0.14
texture {T_Wood25}
}

cylinder {
<0.65,-2,0.7>
<0.65,0,0.7>
0.14
texture {T_Wood25}
}

cylinder {
<0.65,-2,-0.7>
<0.65,0,-0.7>
0.14
texture {T_Wood25}
}

cylinder {
<-0.65,-2,0.7>
<-0.65,0,0.7>
0.14
texture {T_Wood25}
}

cylinder {
<-0.65,-2,-0.7>
<-0.65,0,-0.7>
0.14
texture {T_Wood25}
}

cylinder {
<0.6,-1,0.7>
<-0.6,-1,0.7>
0.14
texture {T_Wood25}
}

cylinder {
<0.6,-1,-0.7>
<-0.6,-1,-0.7>
0.14
texture {T_Wood25}
}

cylinder {
<0,-1,-0.7>
<0,-1,0.7>
0.14
texture {T_Wood25}
}

cylinder {
<-0.65,-1,0.7>
<-7.2,-2,0.7>
0.14
texture {T_Wood25}
}

cylinder {
<-0.65,-1,-0.7>
<-7.2,-2,-0.7>
0.14
texture {T_Wood25}
}

#declare stick=-5.4
#while (stick<5.5)

cylinder {
<-6.2,1.9,stick>
<-6.2,-2,stick>
0.14
texture {T_Wood25}
}

cylinder {
<-7.7,1.9,stick>
<-7.7,-2,stick>
0.14
texture {T_Wood25}
}

#declare stick=stick+1.7
#end

cylinder {
<-0.65,-3,0.7>
<-0.65,-3,-0.7>
0.14
texture {T_Wood25}
}

cylinder {
<-0.65,-3,0.7>
<-6.2,1.9,0.7>
0.14
texture {T_Wood25}
}

cylinder {
<-0.65,-3,-0.7>
<-6.2,1.9,-0.7>
0.14
texture {T_Wood25}
}

cylinder {
<-3.2,-3.6,0.7>
<-6.2,1.9,0.7>
0.14
texture {T_Wood25}
}

cylinder {
<-3.2,-3.6,-0.7>
<-6.2,1.9,-0.7>
0.14
texture {T_Wood25}
}

cylinder {
<-3.2,-3.6,-0.7>
<-3.2,-3.6,0.7>
0.14
texture {T_Wood25}
}

cylinder {
<-6.2,-2,-0.7>
<-6.2,-3.6,-0.7>
0.14
texture {T_Wood25}
}

cylinder {
<-7.4,-2,-0.7>
<-7.4,-3.6,-0.7>
0.14
texture {T_Wood25}
}

cylinder {
<-6.2,-2,0.7>
<-6.2,-3.6,0.7>
0.14
texture {T_Wood25}
}

cylinder {
<-7.4,-2,0.7>
<-7.4,-3.6,0.7>
0.14
texture {T_Wood25}
}

cylinder {
<-7.4,-2,-0.7>
<-6.2,-3.6,-0.7>
0.14
texture {T_Wood25}
}

cylinder {
<-7.4,-2,-0.7>
<-8.6,-3.6,-0.7>
0.14
texture {T_Wood25}
}

cylinder {
<-6.2,-2,-0.7>
<-5,-3.6,-0.7>
0.14
texture {T_Wood25}
}

cylinder {
<-7.4,-2,0.7>
<-6.2,-3.6,0.7>
0.14
texture {T_Wood25}
}

cylinder {
<-7.4,-2,0.7>
<-8.6,-3.6,0.7>
0.14
texture {T_Wood25}
}

cylinder {
<-5.44,-3.6,-0.7>
<-5.44,-3.6,0.7>
0.14
texture {T_Wood25}
}

cylinder {
<-7.7,-1.5,0>
<-12.4,-1.5,0>
0.14
texture {T_Wood25}
}

cylinder {
<-7.7,1.5,0>
<-12.4,1.5,0>
0.14
texture {T_Wood25}
}

cylinder {
<-12.4,-1.5,1>
<-12.4,-1.5,-1>
0.14
texture {T_Wood25}
}

cylinder {
<-12.4,1.5,1>
<-12.4,1.5,-1>
0.14
texture {T_Wood25}
}

superellipsoid{ <0.5,0.6>
texture {Yellow_Pine}
scale<1,1.6,0.1>
translate <-12.4,0,0.7>
}

superellipsoid{ <0.5,0.6>
texture {Yellow_Pine}
scale<1,1.6,0.1>
translate <-12.4,0,-0.7>
}

cylinder {
<-7.3,-2,0>
<-7.3,2,0>
0.2
texture {Aluminum}
}

cylinder {
<-7.3,2,-0.4>
<-7.3,-1,-0.4>
0.2
texture {Aluminum}
}

cylinder {
<-7.3,-2,0.4>
<-7.3,1,0.4>
0.2
texture {Aluminum}
}

difference {

cylinder {
<-6.8,-2,0>
<-7.8,-2,0>
1
texture {Aluminum}
}

box {
<-7.9,-2,-2>
<-6.7,-4,2>
}

}

cylinder {
<-7.2,0,-1.7>
<-7.4,0,-1.7>
0.5
texture {Aluminum}
}

cylinder {
<-7.2,0,1.7>
<-7.4,0,1.7>
0.5
texture {Aluminum}
}

cylinder {
<-6.1,0,-1.7>
<-8.5,0,-1.7>
0.14
texture {T_Wood25}
}

cylinder {
<-6.1,0,1.7>
<-8.5,0,1.7>
0.14
texture {T_Wood25}
}

cylinder {
<-8.5,0.6,-2.2>
<-8.5,-0.6,-1.2>
0.14
texture {T_Wood25}
}

cylinder {
<-8.5,0.6,2.2>
<-8.5,-0.6,1.2>
0.14
texture {T_Wood25}
}

cylinder {
<-7.3,0,-2.2>
<-7.3,-2,0>
0.07
texture {T_Wood25}
}

cylinder {
<-7.3,0.2,-1.2>
<-7.3,-2,0>
0.07
texture {T_Wood25}
}

cylinder {
<-7.3,0,2.2>
<-7.3,-2,0>
0.07
texture {T_Wood25}
}

cylinder {
<-7.3,0.2,1.2>
<-7.3,-2,0>
0.07
texture {T_Wood25}
}

}

object { airplane
       translate <69,73.75,-6>
}

//********************************************** THE WRIGHT BROTHERS *************************

//**** BODY ****
# declare body = union {
          lathe {
          linear_spline
          7,
          <0,0>
          <0.7,0>
          <1,2>
          <0.98,2.25>
          <0.9,2.36>
          <0.65,2.5>
          <0,2.51>
          translate <0,0,0>
          }
}

//**** NECK ****
# declare neck = union {
          lathe {
          linear_spline
          4,
          <0,0>
          <0.35,0>
          <0.25,0.6>
          <0,0.6>
          translate <0,2.5,0>
          }
}

//**** HEAD ****
# declare head = union {
          sphere {
          <0,3.3,-0.1>
          0.6
          scale <0.8,1,1>
          }
}

//**** HAND ****
# declare hand = union {
          cylinder {
          <0,0,0>
          <0,2,0>
          0.3
          }
}

//**** ELBOW ****
# declare elbow = union {
          sphere {
          <0,0,0>
          0.35
          }
}

//**** ARM ****
# declare arm = union {
          cone {
          <0,0,0>,0.3
          <-0.5,1.2,0>,0.22
          }
}

//**** AGAN ****
# declare agan = union {
          cylinder {
          <0,0,0>
          <0,-0.75,0>
          0.7
          }
}

//**** YARECH ****
# declare yarech = union {
          cone {
          <0,1.8,0>,0.31
          <0,0,0>,0.25
          }
}

//**** KNEE ****
# declare knee = union {
          sphere {
          <0,0,0>
          0.28
          }
}

//**** LEG ****
# declare leg = union {
          cone {
          <0,1.8,0>,0.25
          <0,0,0>,0.14
          }
          sphere {
          <0,0,0>
          0.145
          }
}

//**** FOOT ****
# declare foot = union {
          cylinder {
          <0,0,0>
          <0,0,0.95>
          0.145
          scale <1.1,0.7,1>
          pigment { color VeryDarkBrown}
          finish { Glossy}
          }
}

//**** EYES ****
# declare eyes = union {
          sphere {
          <0.15,3.37,-0.6>
          0.1
          pigment { color White}
          }

          sphere {
          <-0.15,3.37,-0.6>
          0.1
          pigment { color White}
          }

          sphere {
          <0.15,3.37,-0.7>
          0.025
          pigment { color Black}
          }

          sphere {
          <-0.15,3.37,-0.7>
          0.025
          pigment { color Black}
          }
}

//**** NOSE ****
# declare nose = union {
		  cone {
		  <0,3.29,-0.7>,0.02
		  <0,3.14,-0.72>,0.05
		  }
}

//**** EAR ****
# declare ear = union {
		  sphere {
		  <0,0,0>
		  0.15
		  scale <1,1.5,0.1>
		  }
}

//**** MOUTH ****
# declare mouth = union {
		  torus {
		  0.1,0.1
		  pigment { color DustyRose}
		  rotate <90,0,0>
		  scale <0.8,0.3,1>
		  translate <0,3,-0.6>
	      }
}

//**** EYE BROWS ****
# declare eyebrow = union {
          difference {
                     torus {
                     0.63,0.05
                     translate <0,3.52,0>
                     pigment { color Black}
                     }

                     box {
                     <-1,3.45,-0.62>
                     <1,3.58,1>
                     }

                     box {
                     <-0.08,3.45,-1>
                     <0.08,3.58,1>
                     }
                     }

                     sphere {
                     <-0.08,3.52,-0.63>,0.05
                     pigment { color Black}
                     }

                     sphere {
                     <0.08,3.52,-0.63>,0.05
                     pigment { color Black}
                     }
}

//**** PILOT'S LEATHER HAT ****
#declare hat = union {
         difference {
                    sphere {
                    <0,0,0>
                    0.6
                    hollow
                    }

                    box {
                    <-1,-1,-1>
                    <1,0,1>
                    }
         }

         difference {
                    cylinder {
                    <0,0,0>
                    <0,-0.57,0>
                    0.6
                    open
                    }

                    box {
                    <-0.55,-1,-0.7>
                    <0.55,-0.01,0.7>
                    }

                    box {
                    <-0.7,-1,-0.7>
                    <0.7,-0.01,-0.05>
                    }

                    box {
                    <-0.7,-1,0.7>
                    <0.7,-0.01,0.05>
                    }
         }
}

//**** GLASSES ****
# declare glasses = union {
		  difference {
		             cylinder {
  			         <-0.15,3.37,-0.6>
			         <-0.15,3.37,-0.75>
			         0.12
                     texture { Tom_Wood}
                     }

                     box {
                     <-0.15,3.55,-0.5>
                     <-0.03,3.3,-0.8>
                     }

                     cylinder {
  			         <-0.15,3.37,-0.5>
			         <-0.15,3.37,-0.8>
			         0.09
                     }
		  }

          difference {
		  	         cylinder {
  			         <0.15,3.37,-0.6>
			         <0.15,3.37,-0.75>
                     0.12
                     texture { Tom_Wood}
                     }

                     box {
                     <0.15,3.55,-0.5>
                     <0.03,3.3,-0.8>
                     }

                     cylinder {
  			         <0.15,3.37,-0.5>
			         <0.15,3.37,-0.8>
			         0.09
                     }
		  }

          difference {
		  	         cylinder {
  			         <0,3.26,-0.6>
			         <0,3.26,-0.75>
			         0.1
                     texture { Tom_Wood}
                     }

                     box {
                     <-0.2,0,-0.5>
                     <0.2,3.28,-0.8>
                     }

                     cylinder {
  			         <0,3.26,-0.5>
			         <0,3.26,-0.8>
			         0.07
                     }
		  }

          box {
          <-0.15,3.46,-0.6>
          <0.15,3.49,-0.75>
          texture { Tom_Wood}
          }

          difference {
                     object { head
                     texture { Tom_Wood}
                     }

                     box {
                     <-0.8,3.42,-0.8>
                     <0.8,5,0.8>
                     }

                     box {
                     <-0.8,3.35,-0.8>
                     <0.8,1,0.8>
                     }

                     box {
                     <-0.15,3.34,-0.8>
                     <0.15,3.43,0.8>
                     }
          }

          cylinder {
  	      <-0.15,3.37,-0.67>
		  <-0.15,3.37,-0.75>
		  0.09
          texture { Glass}
          }

          cylinder {
  	      <0.15,3.37,-0.67>
		  <0.15,3.37,-0.75>
		  0.09
          texture { Glass}
          }

          difference {
		  	         cylinder {
  			         <0,3.26,-0.6>
			         <0,3.26,-0.75>
			         0.13
                     texture { Glass}
                     }

                     box {
                     <-0.2,0,-0.5>
                     <0.2,3.28,-0.8>
                     }

                     cylinder {
  			         <0,3.26,-0.5>
			         <0,3.26,-0.8>
			         0.1
                     }
          }

          box {
          <-0.15,3.46,-0.67>
          <0.15,3.36,-0.75>
          texture { Glass}
          }

}

//**** HAIR ****
# declare hair = union {
          difference {
                     sphere {
                     <0,3.54,0>,0.6
                     pigment { BakersChoc}
                     finish { phong 0.68}
                     normal { bumps 10 scale 0.05}
                     }

                     box {
                     <-0.6,3.54,0.8>
                     <0.6,3,-0.8>
                     }
                     scale <0.9,1,1>
          }

}

//**** CIRCLE ****
# declare cir= union {
        sphere {
        <0,0,0>
        0.16
        }
}

//**** CYLINDER ****
# declare cyl= union {
        cylinder {
        <0,0,0>
        <0,1,0>
        0.16
        }
}

//**** THUMB ****
# declare thumb = union {
        object { cir
               translate <0,0,0>
               }
        object { cyl
               scale <1,0.5,1>
               translate <0,0.1,0>
               }
        object { cir
               translate <0,0.6,0>
               }
        object { cyl
               scale <1,0.5,1>
               translate <0,0.7,0>
               }
        object { cir
               translate <0,1.2,0>
               }
}

//**** GLOVE ****
# declare glove = union {
        cone {
        <0,1,0>,0.5
        <0,0,0>,0.8
        }

        cone {
        <0,1,0>,0.5
        <0,2,0>,0.65
        scale <1,1,0.5>
        }

//**** FINGERS ****
        object { cir
        translate <-0.49,2,0.1>
        }

        object { cir
        translate <-0.17,2,0.1>
        }

        object { cir
        translate <0.15,2,0.1>
        }

        object { cir
        translate <0.47,2,0.1>
        }

        object { cyl
        translate <-0.49,2.1,0.1>
        }

        object { cyl
        translate <-0.17,2.1,0.1>
        }

        object { cyl
        translate <0.15,2.1,0.1>
        }

        object { cyl
        translate <0.47,2.1,0.1>
        }

        object { cir
        translate <-0.49,3.1,0.1>
        }

        object { cir
        translate <-0.17,3.1,0.1>
        }

        object { cir
        translate <0.15,3.1,0.1>
        }

        object { cir
        translate <0.47,3.1,0.1>
        }

        object { cyl
        scale <1,0.5,1>
        translate <-0.49,3.2,0.1>
        }

        object { cyl
        scale <1,0.85,1>
        translate <-0.17,3.2,0.1>
        }

        object { cyl
        translate <0.15,3.2,0.1>
        }

        object { cyl
        scale <1,0.85,1>
        translate <0.47,3.2,0.1>
        }

        object { cir
        translate <-0.49,3.7,0.1>
        }

        object { cir
        translate <-0.17,4.05,0.1>
        }

        object { cir
        translate <0.15,4.2,0.1>
        }

        object { cir
        translate <0.47,4.05,0.1>
        }
}

//**** HAND GLOVES ****
# declare hnd_l = union {
          object { glove
          }

          object { thumb
          translate <0.65,1.8,0.1>
          }
}

# declare hnd_r = union {
          object { glove
          }

          object { thumb
          translate <-0.65,1.8,0.1>
          }
}

//**** PENTS ****
# declare pents = union {
		  object { yarech    /** RIGHT **/
                 translate <-0.39,-2.55,0>
          }
          object { yarech    /** LEFT **/
                 translate <0.39,-2.55,0>
          }
          object { knee      /** RIGHT **/
                 translate <-0.39,-2.55,0>
          }
          object { knee      /** LEFT **/
                 translate <0.39,-2.55,0>
		  }
		  difference {
		  			 object { leg       /** RIGHT **/
                 	 translate <-0.39,-4.35,0>
          			 }
					 box {
					 <-0.6,-3.7,1>
					 <0,-5,-1>
					 }
		  }
		  difference {
          			 object { leg       /** LEFT **/
                 	 translate <0.39,-4.35,0>
          			 }
					 box {
					 <0.6,-3.7,1>
					 <0,-5,-1>
					 }
		  }
		  difference {
		  			 object { agan}
					 box {
					 <-0.8,0.1,-0.8>
					 <0.8,-0.3,0.8>
					 }
		  }
		  torus {
		  0.15
		  0.1
		  translate <0.39,-3.7,0>
		  }
		  torus {
		  0.15
		  0.1
		  translate <-0.39,-3.7,0>
		  }
}

//**** SHIRT ****
# declare shirt = union {
		  object { body}
		  object { hand      /** RIGHT **/
                 rotate <0,0.6,-18>
                 translate <-1.3,0.3,0>
          }
          object { hand      /** LEFT **/
                 rotate <0,0.6,18>
                 translate <1.3,0.3,0>
          }
          object { elbow     /** RIGHT **/
                 translate <-1.3,0.3,0>
          }
          object { elbow     /** LEFT **/
                 translate <1.3,0.3,0>
          }
          object { arm       /** RIGHT **/
		  		 rotate <0,0,160>
                 translate <-1.3,0.3,0>
          }
          object { arm       /** LEFT **/
                 rotate <0,180,-152>
                 translate <1.3,0.3,0>
          }
		  object { agan}

}

//**** HUMAN1 ****
# declare human_a = union {
          object { head}
          object { neck}
		  difference {
		  			 object { leg       /** RIGHT **/
                 	 translate <-0.39,-4.35,0>
          			 }
					 box {
					 <0,0,-1>
					 <-1,-3.7,1>
					 }
		  }
		  difference {
	 		         object { leg       /** LEFT **/
                     translate <0.39,-4.35,0>
          			 }
					 box {
					 <0,0,-1>
					 <1,-3.7,1>
					 }
		  }
          object { foot      /** RIGHT **/
                 translate <-0.39,-4.35,-0.95>
          }
          object { foot      /** LEFT **/
                 translate <0.39,-4.35,-0.95>
          }
		  object { ear
			     translate <0.52,3.37,0>
		  }
		  object { ear
			     translate <-0.52,3.37,0>
		  }
		  object { mouth}
          object { eyes}
          object { nose}
		  object { hat
       		     pigment { color DarkBrown}
       			 scale <0.8,1.2,1.4>
				 translate <0,3.5,0>
       			 finish { phong 0.65}
       			 normal { dents 15 scale 0.1}
		  }
		  object { glasses}
          object { hnd_r     /** RIGHT **/
                 scale <0.4,0.4,0.4>
				 rotate <0,0,180>
                 translate <-1.31,-0.8,0>
                 pigment { color DimGrey}
                 finish { phong 0.4}
          }
          object { hnd_l     /** LEFT **/
                 scale <0.4,0.4,0.4>
				 rotate <0,0,190>
                 translate <1.45,-0.8,0>
                 pigment { color DimGrey}
                 finish { phong 0.4}
          }
		  object { pents
		  		 pigment { color DarkTan}
				 normal { wrinkles 10 scale 0.3}
		  }
		  object { shirt
				 pigment { color DarkOliveGreen}
				 normal { bumps 4 scale 0.15}
		  }
}

//**** HUMAN2 ****
# declare human_b = union {
          object { head}
          object { neck}
		  difference {
		  			 object { leg       /** RIGHT **/
                 	 translate <-0.39,-4.35,0>
          			 }
					 box {
					 <0,0,-1>
					 <-1,-3.7,1>
					 }
		  }
		  difference {
	 		         object { leg       /** LEFT **/
                     translate <0.39,-4.35,0>
          			 }
					 box {
					 <0,0,-1>
					 <1,-3.7,1>
					 }
		  }
          object { foot      /** RIGHT **/
                 translate <-0.39,-4.35,-0.95>
          }
          object { foot      /** LEFT **/
                 translate <0.39,-4.35,-0.95>
          }
		  object { ear
			     translate <0.52,3.37,0>
		  }
		  object { ear
			     translate <-0.52,3.37,0>
		  }
		  object { mouth}
          object { eyes}
          object { nose}
          object { eyebrow}
          object { hair}
		  object { hnd_r     /** RIGHT **/
                 scale <0.4,0.4,0.4>
				 rotate <0,0,180>
                 translate <-1.31,-0.8,0>
                 pigment { color DimGrey}
                 finish { phong 0.4}
          }
          object { hnd_l     /** LEFT **/
                 scale <0.4,0.4,0.4>
				 rotate <0,0,190>
                 translate <1.45,-0.8,0>
                 pigment { color DimGrey}
                 finish { phong 0.4}
          }
		  object { pents
		  		 pigment { color NewMidnightBlue}

				 normal { wrinkles 10 scale 0.3}
		  }
		  object { shirt
				 pigment { NavyBlue}
				 normal { bumps 4 scale 0.48}
		  }
}

object { human_a
       pigment { color Flesh}
	   scale 0.35
	   translate <66,72,-14>
       }

object { human_b
       pigment { color Flesh}
	   scale 0.35
	   translate <64,72,-14>
}


//**** LIGHTS AND CAMERA ****

light_source {
<7,3,-3>
color White
}

light_source {
<7,3,3>
color White
}

light_source {
<8.5,7,6.5>
color White
}

light_source {
<-8.5,20,6.5>
color White
}

light_source {
<37,100,-20>
color White
}

light_source {
<65,73,-20>
color White
}

camera {
location <67,75,-19>
look_at <62,70,0>
}
