/* IMPORTANT INFORMATION !
 * This file was created using an interactive text editor created specifically
 * for POVRAY and AUTOCAD. It allows the direct input of AUTOCAD information,
 * while inside the drawing construct, into the text file. It also supports a
 * series of macro add-on functions such as versions of WORM, CTDS, LATHE objects
 * SOR objects.
 * (C) Nathan G B O'Brien 1996
 */

#include "colors.inc"
#include "13glass1.col"

#include "golds.inc"

#declare Environment = on
#declare Main_light = on
#declare Main_column = on
#declare Main_body = on
#declare Main_glass = on
#declare Glass_effects = on
#declare Special_icons = on
#declare Main_floor = on

camera {
   location <2.500,3.600,-6.500>
   look_at <-1.900,3.600,5.350>
}

global_settings { assumed_gamma 1.5 }

//#if (Main_light = on)
//light_source {<10000,150000,200000> color White}
//#end

#if (Main_light = on)
light_source {<0,1500000000,2000000000> color White}
#end

light_source {<-2,5,-4> color White atmosphere off}

background {color <.9 .9 .8>}

#if (Environment = on)
atmosphere
{
  type 1            // Mie scattering
  samples 10        // Number of samples in first distance interval
  distance 3        // Atmosphere density, similar to fog
  scattering 1.5    // Reflectivity of atmosphere, determines brightness
  aa_level 10       // Level of binary subdivision in case of aa
  aa_threshold 0.1  // Threshold for aa to push in
  jitter 0.3        // Amount of sample jittering
  color rgbft <1,1,.5,.3,.3>
}
#end

#if (Main_body = on)
#include "body.inc"
object {Building}
#end

#if (Main_column = on)
#include "columns.inc"
object {Column_group1}
object {Arch_group1}
#end

#if (Main_glass = on)
#include "winset.inc"
object {Window_group}
#end

#if (Special_icons = on)
	#include "cross.inc"
	object {Cross scale .55 translate <0,0,4>}
	#include "altar.inc"
	object {Altar translate <0,0,3>}
	#include "icons.inc"
	object {Icons_group1}
#end

#if (Main_floor = on)
	#include "floor.inc"
	object {Floor}
#end
