/* IMPORTANT INFORMATION !
 * This file was created using an interactive text editor created specifically
 * for POVRAY and AUTOCAD. It allows the direct input of AUTOCAD information,
 * while inside the drawing construct, into the text file. It also supports a
 * series of macro add-on functions such as versions of WORM, CTDS, LATHE objects
 * SOR objects.
 * (C) Nathan G B O'Brien 1996
 */

#include "floor.col"
#declare Chk_scale = .5

#declare Floor =
union {

box {<-9,-.45,-2.25><9,-1,-0.25>
texture{checker texture{Floor1} texture{Floor3 scale .5} scale Chk_scale rotate <0,45,0>}
}

box {<-9,-.45,-0.25><9,-1,0>texture{Floor2}}

box {<-9,-.45,0><9,-.3,0.25>texture{Floor1}}
cylinder {<-9,-.35,0><9,-.35,0>,0.05 texture{Floor1}}

box {<-9,-.3,0.25><9,-.15,0.5>texture{Floor1}}
cylinder {<-9,-.2,.25><9,-.2,.25>,0.05 texture{Floor1}}

box {<-9,-.15,0.5><9,0,0.75>texture{Floor1}}
cylinder {<-9,-.05,.5><9,-.05,.5>,0.05 texture{Floor1}}

box {<-9,-1,0.75><9,0,1>texture{Floor2}}
box {<-9,-1,1><-3,0,3.4>
texture{checker texture{Floor1} texture{Floor3 scale .5} scale Chk_scale rotate <0,45,0>}
}
box {<3,-1,1><9,0,3.4>
texture{checker texture{Floor1} texture{Floor3 scale .5} scale Chk_scale rotate <0,45,0>}
}
box {<-3,-1,1><-2.75,0,5.35>texture{Floor2}}
box {<-3,-1,5.35><3,0,5.6>texture{Floor2}}
box {<2.75,-1,5.35><3,0,1>texture{Floor2}}

difference {
    box {<-2.75,-1,1><2.75,0,5.35>
	texture{checker texture{Floor1} texture{Floor3 scale .5} scale Chk_scale rotate <0,45,0>}
	}
    cylinder {<0,-2,3.175><0,1,3.175>,2.175 texture{Floor1}}
}

difference {
    cylinder {<0,-1,3.175><0,0,3.175>,2.175 texture{Floor2}}
    cylinder {<0,-2,3.175><0,1,3.175>,1.925 texture{Floor2}}
}

cylinder {<0,-1,3.175><0,-.01,3.175>,1.925 texture{Floor1}}

#declare Tri_mesh =
union {
    triangle {<0,0,0><0,0,1.925><0.341,0,1.3836> texture{Floor2}}
    triangle {<0,0,0><0,0,1.925><-0.341,0,1.3836> texture{Floor3 scale .5}}
}

#declare Tri_floor =
union {
#declare Count = 0
#while (Count < 13)
	object {Tri_mesh rotate <0,((360 / 13) * Count),0>}
	#declare Count = (Count + 1)
#end
}

object {Tri_floor translate <0,0,3.175>}

}

