//
// POV-Ray(tm) 3.0 tutorial example scene.
// Copyright 1996 by the POV-Ray Team
//

#include "g:\povwin3\comp\acatmos.inc"

light_source { < 3.90322 , -5.59328 , -11.4179 > color White atmosphere off}

global_settings { assumed_gamma 2.2 }

camera {
  //location <-10, 8, -19>
  location <-4, 8, -15>
  look_at <1, 5, 0>
  angle 82
}

background { color rgb<0.2, 0.4, 0.8>  }

light_source { <0, 19, 0> color red .5 green .5 blue .5 atmosphere off  }
light_source { <4,8,15> color White atmosphere off }


light_source {
  <40, 25, 0> color rgb <1, 1, 0>
  spotlight
  point_at <0, 5, 0>
  radius 20
  falloff 20
  tightness 1
  atmospheric_attenuation on
}

light_source {
  <40, 25, 0> color rgb <1, 0, 0>
  spotlight
  point_at <0, 5, 0>
  radius 20
  falloff 20
  tightness 1
  atmospheric_attenuation on
}

union {
  difference {
    box { <-21, -1, -21>, <21, 21, 21> }
    box { <-20, 0, -20>, <20, 20, 20> }
    box { <19.9, 5, -3>, <21.1, 15, 3> }
  }
  box { <20, 5, -0.25>, <21, 15, 0.25> }
  box { <20, 9.775, -3>, <21, 10.25, 3> }
  pigment {wood color_map {[0 Brown] [1 DarkBrown] } scale 10}
  finish { ambient 0.8 diffuse 0.5 }
}

atmosphere {
  type 1
  samples 50
  distance 40
  scattering 0.2
  aa_level 4
  aa_threshold 0.1
  jitter 0.4
}
