// Persistence of Vision Ray Tracer Scene Description File
// File: TREE.pov
// Vers: 3.00e Watcom Win32
// Desc: Object Definition Code for an LParser-like Tree
// Date: November 1, 1996
// Auth: Sonya Roberts
// Note: To change the appearance of the tree, modify the settings at the beginning
//       of the file.  If you want to create a number of different trees, create multiple
//       copies of this file with different settings, and number the Leaf and Tree #declare
//       statements (i.e., in TREE1.pov have Leaf1 and Tree1 objects).
//       Please note that you will need to #declare the variables True=1 and False=0 in your main
//       .POV file.
//       If you want more than 3 leaves on the final twigs, or want them in different positions,
//       you must edit the relevant section in the fifth loop.
//	 The colour of the trunk is set at the end of the file.

#declare Leaf=
object {
	sphere {<0,0,.05>,.1	scale <2,.015,3.5>}
	pigment {color PaleGreen}
	finish { ambient 0 diffuse 0.4 }
}

#declare Tree=
object {
	#debug "Creating Tree "
	#declare MaxSplits=6			// Maximum number of forks in a section of Tree (minimum of 1)
	#declare MinSplits=2			// Minimum nubmer of forks in a section of Tree (minimum of 1)
	#declare IncSplits=1.02			// To Increase Max. Splits near Branch Tips, Make > 1 - KEEP IT SMALL!  UNDER 1.1 PREFERRED!
	#declare BaseLen=.75			// Base Length (length of smallest twig)
	#declare LengthInc=1.75			// Factor By Which to Increase Base Length
	#declare MinXDeg=30			// Minimum X-rotation of forks
	#declare MaxXDeg=35			// Maximum X-rotation of forks
	#declare MinYDeg=0			// Minimum Y-rotation of forks
	#declare MaxYDeg=360			// Maximum Y-rotation of forks		// NOTE: 2nd-Level Branches always based on 360 degrees
	#declare MinZDeg=0			// Minimum Z-rotation of forks		// Z-rotations highly optional - not required at all
	#declare MaxZDeg=0			// Maximum Z-rotation of forks
	#declare SD1=seed(2)			// Seed for random numbers - changing only this will create a different tree of the same species
	#declare BallJoint=false		// Turns on and off the spheres used to smooth intersections of the branches and trunks
	union {
		cone {<0,0,0>,1,<0,BaseLen*(LengthInc*5),0>,.5}
		#if (BallJoint)
			sphere {<0,BaseLen*(LengthInc*5),0>,.5}
		#end
		#declare Loop1=int((rand(SD1)*((MaxSplits-MinSplits-1)+.9999999999))+MinSplits)	// How many forks?
		#declare Loop1Count=1
		#while (Loop1Count <= Loop1)
			#debug "."
			union {
				cone {<0,0,0>,.5,<0,BaseLen*(LengthInc*4),0>,.25}
				#if (BallJoint)
					sphere {<0,BaseLen*(LengthInc*4),0>,.25}
				#end
				#declare Loop2=int((rand(SD1)*(((MaxSplits*IncSplits)-MinSplits-1)+.9999999999))+MinSplits)	// How many forks?
				#declare Loop2Count=1
				#while (Loop2Count <= Loop2)
					#debug "."
					union {
						cone {<0,0,0>,.25,<0,BaseLen*(LengthInc*3),0>,.125}
						#if (BallJoint)
							sphere {<0,BaseLen*(LengthInc*3),0>,.125}
						#end
						#declare Loop3=int((rand(SD1)*(((MaxSplits*IncSplits*IncSplits)-MinSplits-1)+.9999999999))+MinSplits)
						#declare Loop3Count=1
						#while (Loop3Count <= Loop3)
							#debug "."
							union {
								cone {<0,0,0>,.125,<0,BaseLen*(LengthInc*2),0>,.0625}
								#if (BallJoint)
									sphere {<0,BaseLen*(LengthInc*2),0>,.0625}
								#end
								#declare Loop4=int((rand(SD1)*(((MaxSplits*IncSplits*IncSplits*IncSplits)-MinSplits-1)+.9999999999))+MinSplits)
								#declare Loop4Count=1
								#while (Loop4Count <= Loop4)
									#debug "."
									union {
										cone {<0,0,0>,.0625,<0,BaseLen*LengthInc,0>,.03125}
										#if (BallJoint)
											sphere {<0,BaseLen*LengthInc,0>,.03125}
										#end
										#declare Loop5=int((rand(SD1)*(((MaxSplits*IncSplits*IncSplits*IncSplits*IncSplits)-MinSplits-1)+.9999999999))+MinSplits)
										#declare Loop5Count=1
										#while (Loop5Count <= Loop5)
											#debug "."
											union {
												cone {<0,0,0>,.03125,<0,BaseLen,0>,.01}
												object {Leaf	rotate x*-90		translate <0,BaseLen,0>}
												object {Leaf	rotate x*MaxXDeg	rotate y*(MaxYDeg/2)	translate <0,BaseLen*.7,0>}
												object {Leaf	rotate x*MaxXDeg	rotate y*-(MaxYDeg/2)	translate <0,BaseLen*.4,0>}
												rotate x*(((rand(SD1))*(MaxXDeg-MinXDeg))+MinXDeg)
												rotate y*(((rand(SD1))*(MaxYDeg-MinYDeg))+MinYDeg)
												rotate z*(((rand(SD1))*(MaxZDeg-MinZDeg))+MinZDeg)
												translate <0,(BaseLen*LengthInc)*(Loop5Count/Loop5),0>
											}
											#declare Loop5Count = Loop5Count+1
										#end
										rotate x*(((rand(SD1))*(MaxXDeg-MinXDeg))+MinXDeg)
										rotate y*(((rand(SD1))*(MaxYDeg-MinYDeg))+MinYDeg)
										rotate z*(((rand(SD1))*(MaxZDeg-MinZDeg))+MinZDeg)
										translate <0,(BaseLen*(LengthInc*2))*(Loop4Count/Loop4),0>
									}
									#declare Loop4Count = Loop4Count+1
								#end
								rotate x*(((rand(SD1))*(MaxXDeg-MinXDeg))+MinXDeg)
								rotate y*(((rand(SD1))*(MaxYDeg-MinYDeg))+MinYDeg)
								rotate z*(((rand(SD1))*(MaxZDeg-MinZDeg))+MinZDeg)
								translate <0,(BaseLen*(LengthInc*3))*(Loop3Count/Loop3),0>
							}
							#declare Loop3Count = Loop3Count+1
						#end
						rotate x*(((rand(SD1))*(MaxXDeg-MinXDeg))+MinXDeg)
						rotate y*(((rand(SD1))*(MaxYDeg-MinYDeg))+MinYDeg)
						rotate z*(((rand(SD1))*(MaxZDeg-MinZDeg))+MinZDeg)
						translate <0,(BaseLen*(LengthInc*4))*(Loop2Count/Loop2),0>
					}
					#declare Loop2Count = Loop2Count+1
				#end
				rotate x*(((rand(SD1))*(MaxXDeg-MinXDeg))+MinXDeg)
				rotate y*(rand(SD1)*360)
				rotate z*(((rand(SD1))*(MaxZDeg-MinZDeg))+MinZDeg)
				translate <0,(BaseLen*(LengthInc*5))*(Loop1Count/Loop1),0>
			}
			#declare Loop1Count = Loop1Count+1
			#debug "\n"
		#end
	}
	pigment {color Brown}
	finish { ambient 0 diffuse 0.3 }
}
