// Persistence of Vision Ray Tracer Scene Description File
// File: ammo-base.inc
// Vers: 3
// Desc:
// Date: January 1997
// Auth: T.Terao

#include "colors.inc"
#include "shapes.inc"
#include "finish.inc"
#include "metals.inc"

#declare F_Amm_shell =		//brush up more.
finish {
	ambient 0.1
	diffuse 0.7
	phong 0.9
	specular 0.80
	roughness 0.01
	brilliance 7
	metallic
	crand 0.009
}

#declare F_Amm_bullet =		//decrease it lighter
finish {
	ambient 0.1
	diffuse 0.7
	phong 0.1
	specular 0.8
	roughness 0.01
	brilliance 4
	metallic
	crand 0.01
}

#declare F_Amm_primer =
finish {
	phong 1
	brilliance 6
	metallic
}


#declare void =
cylinder {
	<0,-0.001,0>,
	<0,0.03,0>,
	0.26
	open
}

#declare Ammo = union {

//0 (primer)
object {
  merge {
   cylinder{<0,0.01,0>,<0,0.1,0>,0.22}  //once again !!
   torus {0.21,0.01 translate 0.01*y}    //to round a sharp edge
   cylinder {<0,0,0>,<0,0.06,0>,0.21}

   torus {0.07,0.02 translate 0.01*y}    //center of primer
   cylinder{<0,-0.01,0>,<0,0.02,0>,0.07}
  }
  texture {
	pigment {P_Chrome4}
	normal {bumps 0.04 scale 0.04}
	finish {F_Amm_primer}
  }

}

//1-1 (rim-main)
 difference {
  object {
   union{
    cylinder{<0,0,0>,<0,0.07,0>,(0.465)}
    torus {0.465,0.035 translate 0.035*y}
   }
   texture {
		pigment {P_Brass5}
		normal {bumps 0.04 scale 0.04}
		finish {F_Amm_shell}
   }
  }
  object {void}
 }

//1-2 (rim-to round)                    //seems to be good
 torus {0.26,0.02 translate 0.02*y
    texture {
		pigment {P_Brass5}
		normal {bumps 0.04 scale 0.04}
		finish {F_Amm_shell}
    }
 }

//2 (shell, lower)

cylinder {
	<0,0.07,0>,
	<0,0.20,0>,
	0.42
	texture {
		pigment {P_Brass5}
		finish {F_Amm_shell}
	}
}

//3
object {
 union {
  cone {
	<0,0.20,0>,0.42
	<0,0.316,0>,0.496          //difficult to get a rounding contact
	open
  }
  torus {0.49,0.01 translate<0,0.32,0>
  }
  texture {
		pigment {P_Brass5}
		normal {bumps 0.04 scale 0.04}
		finish {F_Amm_shell}
  }
 }
}
//4 (shell, main)
cylinder {
	<0,0.32,0>,
	<0,1.2,0>,
	0.5
//	open
	texture {
		pigment {P_Brass5}
		normal {bumps 0.02 scale 0.02}
		finish {F_Amm_shell}
	}
}

//5 (shell, upper)
cylinder {
	<0,1.2,0>,
	<0,1.6,0>,
	0.5
//	open
	texture {
		pigment {P_Brass5}
		normal {bumps 0.02 scale 0.06}
		finish {F_Amm_shell}
	}
}
//6 (bullet)
superellipsoid {
	<1,1.03>
	texture {
		pigment {P_Copper2}
		normal {bumps 0.01 scale 0.01}
		finish {F_Amm_bullet}
	}
	scale <0.48,0.8,0.48>
	translate<0,1.6,0>
}

} // End of union "Ammo"

/*
object {Ammo
       rotate <90,20,0>

}

camera {
	location<0.5,1,-1>
	look_at<0,0,0>
}

background {color rgb<0.4,0.4,0.3>}

light_source {<-0.5,5,-0.5>color White}
light_source {<-1,4,-2>color White}
light_source {<1,1,-2>color White}
light_source {<-1,4,-5>color White}
light_source {<-2,3,-5>color White}
light_source {<-3,2,-5>color White}
light_source {<-1,2,2>color White}
*/
