#version 3.0
// global_settings { assumed_gamma 1.0 }

#include "colors.inc"
#include "textures.inc"
#include "shapes.inc"
#include "glass.inc"
#include "woods.inc"
#include "woodmaps.inc"
#include "golds.inc"
#include "metals.inc"
#include "stones.inc"

  global_settings {
  //  adc_bailout FLOAT
    max_intersections 22
    max_trace_level 22
  }

#declare Or =
	texture { T_Gold_1A
	finish{
	phong 0.3
        phong_size 90
	reflection 0.9}}

#declare Bois = 
	texture { pigment {P_WoodGrain4A color_map { M_Wood14A}turbulence 0.05}
		scale <1,1,1> }
	texture { pigment {P_WoodGrain4B color_map { M_Wood14B}turbulence 0.05}
		scale <1,1,1> }
	


#declare T_Glass = texture {
   pigment { color red 1.0 green 1.0 blue 1.0 filter 0.95 }
   finish {
      ambient 0.0
      diffuse 0.0
      reflection 0.33
      refraction on
      ior 1.47
      phong 0.3
      phong_size 90
      caustics 2
   }
}

// A rather boring texture but it renders quick
#declare plastic = texture {
   pigment { Red }
   finish {
      phong 2.0
      phong_size 80
      ambient 0.1
      diffuse 1.5
      // reflection 0.1
   }
}
  #declare verre2 = lathe {
           cubic_spline 
           24,
           <0.0,0.1>, <0.6,0.05>, <1.45,0.02>, <2.0,0.015>, <1.62,0.17>, <0.75,0.24>, <0.25,0.725>,
           <0.195,1.425>, <0.22,2.37>, <0.285,3.435>, <0.5,4.2>, <1.14,4.6>, <1.825,5.2>, <2.075,5.94>,
           <2.0,6.8>, <1.905,7.66>, <1.95,8.0>, <1.915,7.98>, <1.8,7.5>, <1.9,6.775>, <1.95,5.84>,
           <1.435,5.0>, <0.675,4.55>, <0.0,4.4>
           texture { T_Glass }
           scale 0.9
	   translate <0,0.75,0>
	   }


  // rang 1 etage 2        
  object { verre2 translate <0,-0.65,0>}
  object { verre2 translate < -5.1,-8,0.1> rotate <180,0,0> }
  object { verre2 translate <-10.1,-8,0> rotate <180,0,0> } 
  object { verre2 translate <  5.05,-8,0.05> rotate <180,0,0> } 
  object { verre2 translate < 10,-8,0> rotate <180,0,0> } 
  object { verre2 translate < 15,-8,-0.2> rotate <180,0,0> } 
  object { verre2 translate < 19.95,-8,0> rotate <180,0,0> } 
  object { verre2 translate < 25,-8,0.15> rotate <180,0,0> }
  
  // rang 2 etage 2
  object { verre2 translate <  0.1,-8,-5.5> rotate <180,0,0> }
  object { verre2 translate < -5,-8,-5.6> rotate <180,0,0> }
  object { verre2 translate <-10,-8,-5.5> rotate <180,0,0> } 
  object { verre2 translate <  5,-8,-5.5> rotate <180,0,0> } 
  object { verre2 translate < 9.95,-8,-5.4> rotate <180,0,0> } 
  object { verre2 translate < 15.05,-8,-5.5> rotate <180,0,0> } 
  object { verre2 translate < 20,-8,-5.5> rotate <180,0,0> } 
  object { verre2 translate < 25.1,-8,-5.5> rotate <180,0,0> }
  
   // rang 1 etage 3        
  object { verre2 translate <  0,-18,0.1> rotate <180,0,0> }
  object { verre2 translate < -5.05,-18,0> rotate <180,0,0> }
  object { verre2 translate <-10,-18,0.05> rotate <180,0,0> } 
  object { verre2 translate <  4.95,-18,0> rotate <180,0,0> } 
  object { verre2 translate < 10,-18,-0.05> rotate <180,0,0> } 
  object { verre2 translate < 15.1,-18,0> rotate <180,0,0> } 
  object { verre2 translate < 20,-18,-0.025> rotate <180,0,0> } 
  object { verre2 translate < 24.9,-18,0> rotate <180,0,0> }
  
  // rang 2 etage 3
  object { verre2 translate <  0.2,-18,-5.5> rotate <180,0,0> }
  object { verre2 translate < -5,-18,-5.55> rotate <180,0,0> }
  object { verre2 translate <-10.1,-18,-5.5> rotate <180,0,0> } 
  object { verre2 translate <  5,-18,-5.5> rotate <180,0,0> } 
  object { verre2 translate < 10,-18,-5.4> rotate <180,0,0> } 
  object { verre2 translate < 15.05,-18,-5.5> rotate <180,0,0> } 
  object { verre2 translate < 20,-18,-5.6> rotate <180,0,0> } 
  object { verre2 translate < 25.1,-18,-5.5> rotate <180,0,0> }

   // rang 1 etage 1        
  object { verre2 translate <  -0.1,2,0> rotate <180,0,0> }
  object { verre2 translate < -5.1,2,-0.1> rotate <180,0,0> }
  object { verre2 translate <-10,2,0> rotate <180,0,0> } 
  object { verre2 translate <  5.05,2,0> rotate <180,0,0> } 
  object { verre2 translate < 9.95,2,-0.05> rotate <180,0,0> } 
  object { verre2 translate < 15,2,0> rotate <180,0,0> } 
  object { verre2 translate < 20.15,2,0> rotate <180,0,0> } 
  object { verre2 translate < 25,2,0.1> rotate <180,0,0> }
  
  // rang 2 etage 1
  object { verre2 translate <  0,2,-5.65> rotate <180,0,0> }
  object { verre2 translate < -4.95,2,-5.5> rotate <180,0,0> }
  object { verre2 translate <-10,2,-5.51> rotate <180,0,0> } 
  object { verre2 translate <  4.9,2,-5.5> rotate <180,0,0> } 
  object { verre2 translate < 10,2,-5.4> rotate <180,0,0> } 
  object { verre2 translate < 15.1,2,-5.5> rotate <180,0,0> } 
  object { verre2 translate < 20,2,-5.525> rotate <180,0,0> } 
  object { verre2 translate < 25.1,2,-5.5> rotate <180,0,0> }


  object { superellipsoid { <0.025,0.25> } scale <20,7.5,0.5> rotate <90,0,0> translate <5, -0.5,4> texture { T_Glass }}
  object { superellipsoid { <0.025,0.25> } scale <20,7.5,0.5> rotate <90,0,0> translate <5,  9.5,4> texture { T_Glass }}
  object { superellipsoid { <0.025,0.25> } scale <20,7.5,0.5> rotate <90,0,0> translate <5,-10.5,4> texture { T_Glass }}

// bois
  object {
	cylinder {
	    <0, -30, 10>,     // Center of one end
	    <0, 20, 10>,     // Center of other end
	    3            // Radius
	    open           // Remove end caps

	    texture { Bois 
		finish {
			phong 2.0
		        phong_size 80
		        diffuse 2.0
			reflection 0.15}
	    }
	scale <4, 1, 1> translate <-28,0,0>}
  }

// fond miroir
plane { z, 10.5
     texture {pigment {image_map {tga "fondbar2.tga"}}
     finish {
	 phong 2.0
	 phong_size 80
        // diffuse 0.8 
	 reflection 0.95
     }
    scale 40 translate <-16,0,0>
    }
}

// armatures zinc
#declare pied = union {
	// gros exterieur
	cylinder {
	    <0, 0.25, 0>,     // Center of one end
	    <0, 9.75, 0>,     // Center of other end
	    0.5            // Radius
	texture { Or
	}}
	cylinder {
	    <0, -9.75, 0>,     // Center of one end
	    <0, -0.25, 0>,     // Center of other end
	    0.5            // Radius
	texture { Or
	}}
	cylinder {
	    <0, -19.75, 0>,     // Center of one end
	    <0, -10.25, 0>,     // Center of other end
	    0.5            // Radius
	texture { Or
	}}
	// joints noirs
	cylinder {
	    <0, -0.15, 0>,     // Center of one end
	    <0,  0.15, 0>,     // Center of other end
	    0.5            // Radius
	texture { pigment { color Black}}
	}
	cylinder {
	    <0,  9.85, 0>,     // Center of one end
	    <0, 10.15, 0>,     // Center of other end
	    0.5            // Radius
	texture { pigment { color Black}}
	}
	cylinder {
	    <0,  -9.85, 0>,     // Center of one end
	    <0, -10.15, 0>,     // Center of other end
	    0.5            // Radius
	texture { pigment { color Black}}
	}
	// fin interieur
	cylinder {
	    <0, -10.5, 0>,     // Center of one end
	    <0,  10.5, 0>,     // Center of other end
	    0.1            // Radius
	texture { Or
	}}
	// 1/2 sphere top
	
	difference {
	sphere { <0, 0, 0>, 0.5 texture { Or } }
	box { <-1, 0, -1>, <1, -1, 1> texture { Or }}
	
	translate <0,10.15,0>
	}

}   

object {pied translate <-12.8,0,-2.8> }
object {pied translate < 7.5,0,-2.8> }
// object {pied translate < 22.8,0,-2.8> }
object {pied translate <-12.8,0,7.8> }
object {pied translate < 7.5,0,7.8> }
// object {pied translate < 22.8,0,7.8> }


light_source {
   <50, 90, -70> color rgb <1, 0.95, 0.95>

  // The extended area light paramaters
  // area_light <6, 0, 0>, <0, 6, 0>, 9, 9
  // adaptive 0
  // jitter

}


 sky_sphere {
	pigment {
	    image_map { tga "fondbar2.tga" }
	scale 40
	}
 }


camera {
    direction <0, 0, 1.5>
    location <18, 21, -36>
    look_at <5.5, 5.5, 2>
}
