//  Persistance of Vision Raytracer V3.0
//  World definition file.
//
//  Contains 3 lights, 9 textures and 20 primitives.
//
//  This file was generated for POV-Ray V3.0 by
//  MORAY.EXE V2.5a.wat(c) 1991-1995 Lutz + Kretzschmar
//

//  Date : 02/06/1997    (06.02.1997)
//

//
//  This is the standard include file for POV-Ray. It is included with
//  every scene that Moray V2.0 exports for POV-Ray.
//





global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.8
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

atmosphere {
  type 4    // Rayleigh
  distance     10.0
  color <0.8,0.8,1.0,0.0,1.0>
  scattering   0.3
  samples      10
  jitter       0.0
  aa_threshold 1.0
  aa_level     3.0
}


#declare cam_loc = <7.061, -24.850, 8.602>    // use the x, y, and z of your camera
 #declare light_loc = <-0.450, 2.992, 8.618>  // use the x, y, and z of the light
                               // you wish to flare
 #declare lookat = <0.576, 4.701, 4.595>     // the look_at vector of your camera
 #declare sky_vect = <0.0, 0.0,  1.0>   // the sky vector of your camera
 #declare flare_type = "105mm"  // or whatever pre-defined flare you like
 #include "lnsflare.inc"       // create the lens flare


camera {  //  Camera Camera01
  location cam_loc
  direction <0.0,     0.0,  2.5650>
  sky       sky_vect
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  look_at   lookat
}

//    Other cameras are commented out.
/*
camera {  //  Camera SpotCam001
  location  <10.000, -19.741, 12.536> // Attached to Spot1
  direction <0.0,     0.0,  5.9558>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  look_at   <9.643, -18.864, 12.215> // Following Spot1
}

*/

// *******  L I G H T S *******
light_source { // AreaL001
  <-2.892, -3.551, 8.646>
  color  rgb<1.000, 1.000, 1.000>
  area_light <1.940, -0.486, 0.000>, <-0.218, -0.871, -1.787>, 3, 3
  adaptive 1
  jitter
  atmosphere off
}


light_source {   // Light001
  light_loc
  color rgb <1.000, 1.000, 1.000>
  atmosphere off
  shadowless
}

light_source {   // Spotlight Spot1
  <10.000, -19.741, 12.536>
  color  rgb <0.753, 0.753, 0.753>
  spotlight
    point_at  <9.643, -18.864, 12.215>
    falloff   4.8  // outer radius (in deg)
      radius    4.4  // inner radius
  atmospheric_attenuation on
}


// ********  TEXTURES  *******
//

#include "glass.inc"



// ********  REFERENCED OBJECTS  *******



// ********  OBJECTS  *******







#include "plaque.inc"

#declare plaque_Ref = object {
  plaque
  texture {
    DMFDarkOak1
  }
}
#declare plate_Ref = object {
  plate
  texture {
    Gold_Metal1
  }
}
#declare stud01_Ref = object {
  stud01
  texture {
    Gold_Texture1
  }
}
#declare stud02_Ref = object {
  stud02
  texture {
    Gold_Texture1
  }
}
#declare stud03_Ref = object {
  stud03
  texture {
    Gold_Texture1
  }
}
#declare stud04_Ref = object {
  stud04
  texture {
    Gold_Texture1
  }
}
#declare Texte_Ref = object {
  Texte
  texture {
    Black_Plastic
  }
}
union { // plaque_obj
  object { plaque_Ref }
  object { plate_Ref }
  object { stud01_Ref }
  object { stud02_Ref }
  object { stud03_Ref }
  object { stud04_Ref }
  object { Texte_Ref }
  scale 0.15
  rotate -45.0*x
  translate  <0.0, -0.01176, 2.1582>
}


#include "loupe.inc"

#declare Manche_Ref = object {
  Manche
  texture {
    Black_Plastic
  }
}
#declare Dorure_Ref = object {
  Dorure
  texture {
    Gold_Texture1
  }
}
#declare Inter_Ref = object {
  Inter
  texture {
    Chrome_Metal1
  }
}
#declare Dorure2_Ref = object {
  Dorure2
  texture {
    Gold_Texture1
  }
}
#declare Tour_Ref = object {
  Tour
  texture {
    Chrome_Metal1
  }
}
#declare Verre_Ref = object {
  Verre
  texture {
    Glass1
  }
}
union { // loupe_obj
  object { Manche_Ref }
  object { Dorure_Ref }
  object { Inter_Ref }
  object { Dorure2_Ref }
  object { Tour_Ref }
  object { Verre_Ref }
  scale 0.015
  rotate <91.709412, -1.46101, 130.50853>
  translate  <3.192329, 1.15845, 1.728831>
}


#include "globe.inc"

object {
  Globe
  texture {
    Glass4
  }
  scale 0.04
  translate  <0.000128, 5.070026, 6.05201>
}


#include "diamand.inc"

object {
  Diamand
  texture {
    Glass1
  }
  scale 0.03
  translate  <0.000088, 4.999792, 4.093932>
}


#include "socle.inc"

object {
  Socle
  texture {
    Brass_Texture1
  }
  scale 0.05
  translate  <0.0, -25.0, 1.573231>
}


#include "etagere.inc"

object {
  Etagere
  texture {
    DMFLightOak1
  }
  scale 0.1
}


