//  Lamps.inc - has Lamp and WallCandle objects
//  For POVRay for Windows v3.0

#include "flame.inc"

// ********************************  Lamp object *************************

#declare Lamp = union {

cylinder { // Wheel
  <0,0,1>, <0,0,0>, 1
  texture {
    T_Brass_3C
  }
  scale <0.25, 0.25, 0.01>
  rotate -90.0*y
  translate  <1.6, 0.0, 5.05>
}
cylinder { // Axel
  <0,0,1>, <0,0,0>, 1
  texture {
    T_Brass_3C
  }
  scale <0.05, 0.05, 1.0>
  rotate -90.0*y
  translate  <1.6, 0.0, 5.05>
}
#include "lampwick.inc"
object {   // Wick_Cap
  Wick_Cap_Raw
  texture {
    T_Brass_3C
  }
  scale <0.7, 0.7, 0.5>
  translate  5.09*z
}
#include "bowlcap.inc"
object {   // Bowl_Cap
  Bowl_Cap_Raw
  texture {
    T_Glass3
  }
  translate  3.63*z
}
#include "lampbowl.inc"
object {   // Lamp_Bowl
  Lamp_Bowl_Raw
  texture {
    T_Glass3
  }
  translate  3.1*z
}
object {   // Lamp_Bowl
  Lamp_Bowl_Raw
  texture {
    T_Yellow_Glass
  }
  translate  3.1*z
  scale <0.85, 0.85, 0.85>
}
#include "lampbase.inc"
object {   // Lamp_Base
  Lamp_Base_Raw
  texture {
    T_Glass3
  }
}
#include "schim.inc"
object {   // Chimney
  Chimney_Raw
  texture {
    T_Glass3
  }
  scale <0.85, 0.85, 1.4>
  translate  6.6*z
}
object {
  Flame1
  scale 0.1
  translate < 0, 0, 5.4 >
}
}

// ***********************************  WallCandle object **************************

#declare WallCandle = union {
  torus { // Brace
    1.5, 0.5  rotate -x*90
    texture {pigment { DMFWood1} }
    scale <0.4, 0.4, 0.25>
    rotate -90.0*y
    translate  1.8*y
  }
  cylinder { // WallMount
    <0,0,1>, <0,0,0>, 1
    texture {pigment { DMFWood1 rotate <90, 0, 0>} }
    scale <3.0, 3.0, 0.25>
    rotate -90.0*x
    translate  <0.0, 2.5, 2.0>
  }
  cylinder { // Wick
    <0,0,1>, <0,0,0>, 1
    texture {pigment { DMFWood1} }
    scale <0.025, 0.025, 0.7>
    translate  4.5*z
  }
  cylinder { // Candle
    <0,0,1>, <0,0,0>, 1
    texture {finish {Phong_Dull} pigment{ rgb <0.9, 0.9, 0.5> }}
    scale <0.4, 0.4, 4.0>
    translate  0.7*z
  }
  #include "cndlhold.inc"
  object {   // CandleHolder
    CandleHolder_Raw
    texture {pigment { DMFWood1} }
  }
  #include "chchim.inc"
//  #include "qchimney.inc"
  object {   // Chimney
    Chimney_Raw
    texture {
      T_Glass3
    }
    scale <1, 1, 1.4>
    translate  2.75*z
  }
  object {
    Flame2
    scale 0.045
    translate < 0, 0, 5.0 >
  }

  light_source
  {
    0*x
    color red 0.25  green 0.25  blue 0.1
    translate <0, 0, 5>
    area_light <1, 0, 0>, <0, 1, 0>, 2, 2
    adaptive 1
    jitter
  }
}
