// Persistence of Vision Ray Tracer Scene Description File
// File: bs-prism.pov
// Vers: 1
// Desc: A stand of prisms.  For the Internet RayTracing Competition Jan-Feb '97 
//       (Theme: Glass)
// Date: 2/22/97
// Auth: Bob Sewell

// ==== Standard POV-Ray Includes ====
#include "colors.inc"
#include "textures.inc"

// ==== Additional Includes ====
#include "glass.inc"
#include "metals.inc"
#include "woods.inc"
#include "specs.inc"
#include "prisms.inc"
#include "tree1.inc"
#include "willow1.inc"

#declare wall = object {
  polygon
  {
    5,
    <0, -7.5>, <0, 0>, <10, 0>, <10, -7.5>, <0, -7.5>
  }
  texture {
    pigment { rgb < 1, 1, 1 > }
    finish {
      ambient 0.2
      diffuse 0.5
      roughness 0.5
    }
  }
  rotate <90, 0, 0>
}

#declare ceiling = object {
polygon {
  5, // number of points
  <0, -7.5>, <0, 0>, <10, 0>, <10, -7.5>, <0, -7.5>
}
texture {
  pigment { rgb <1, 1, 1> }
  finish { ambient 0.2 diffuse 0.5 }
  }
}

#declare F_Glass4A =
finish {
    ambient 0.1
    diffuse 0.1
    reflection 0.25
    refraction 1
    ior 2.42   // IOR of Diamond
    specular 1
    roughness 0.001
}

#declare T_Old_Thick_Glass=
texture {
    finish { F_Glass4A }
//    normal { bumps scale <0.01, 0.85, 0.85> }  // gives old, bumpy glass texture
    pigment { color rgbf <0.8, 0.9, 0.85, 0.85> }
}

#declare WallPrismLights = union {
light_source {
   <-3, 9.0, 3>
   color Red
   spotlight
   point_at <-3, 10, 6>
   tightness 100
   radius 15
   falloff 16
}
light_source {
   <-2.7, 9.0, 3>
   color Orange
   spotlight
   point_at <-2.7, 10, 6>
   tightness 100
   radius 15
   falloff 16
}
light_source {
   <-2.4, 9.0, 3>
   color Yellow
   spotlight
   point_at <-2.4, 10, 6>
   tightness 100
   radius 15
   falloff 16
}
light_source {
   <-2.1, 9.0, 3>
   color Green
   spotlight
   point_at <-2.1, 10, 6>
   tightness 100
   radius 15
   falloff 16
}
light_source {
   <-1.8, 9.0, 3>
   color Blue
   spotlight
   point_at <-1.8, 10, 6>
   tightness 100
   radius 15
   falloff 16
}
light_source {
   <-1.5, 9.0, 3>
   color Violet
   spotlight
   point_at <-1.5, 10, 6>
   tightness 100
   radius 15
   falloff 16
}
}

#declare SeatPrismLights = union {
light_source {
   <-3, -3.0, 1.5>
   color Violet
   spotlight
   point_at <-3, -6.0, 0>
   tightness 100
   radius 15
   falloff 16
}
light_source {
   <-2.7, -3.0, 1.5>
   color Blue
   spotlight
   point_at <-2.7, -6.0, 0>
   tightness 100
   radius 15
   falloff 16
}
light_source {
   <-2.4, -3.0, 1.5>
   color Green
   spotlight
   point_at <-2.4, -6.0, 0>
   tightness 100
   radius 15
   falloff 16
}
light_source {
   <-2.1, -3.0, 1.5>
   color Yellow
   spotlight
   point_at <-2.1, -6.0, 0>
   tightness 100
   radius 15
   falloff 16
}
light_source {
   <-1.8, -3.0, 1.5>
   color Orange
   spotlight
   point_at <-1.8, -6.0, 0>
   tightness 100
   radius 15
   falloff 16
}
light_source {
   <-1.5, -3.0, 1.5>
   color Red
   spotlight
   point_at <-1.5, -6.0, 0>
   tightness 100
   radius 15
   falloff 16
}
}

#declare WindowPrismLights = union {
light_source {
   <-4.5, -3.0, 0>
   color Red
   spotlight
   point_at <-5.5, -3.0, 3>
   tightness 100
   radius 15
   falloff 16
}
light_source {
   <-4.5, -2.7, 0>
   color Orange
   spotlight
   point_at <-5.5, -2.7, 3>
   tightness 100
   radius 15
   falloff 16
}
light_source {
   <-4.5, -2.4, 0>
   color Yellow
   spotlight
   point_at <-5.5, -2.4, 3>
   tightness 100
   radius 15
   falloff 16
}
light_source {
   <-4, -2.1, 0>
   color Green
   spotlight
   point_at <-5.5, -2.1, 3>
   tightness 100
   radius 15
   falloff 16
}
light_source {
   <-4, -1.8, 0>
   color Blue
   spotlight
   point_at <-5.5, -1.8, 3>
   tightness 100
   radius 15
   falloff 16
}
light_source {
   <-4, -1.5, 0>
   color Violet
   spotlight
   point_at <-5.5, -1.5, 3>
   tightness 100
   radius 15
   falloff 16
}
}

#declare Music = object {
  polygon
  {
    5, // number of points
    <0, 0>, <0, 3.85>, <4.15, 3.85>, <4.15, 0>, <0, 0>
  }
  texture { pigment { image_map
   {
    gif "music.gif"
    map_type 0 
    interpolate 2
   }
   rotate <0, 0, 90>
   scale 4} }
}
camera {
  location  <15.0, -27.0, 10.0>
  direction <0.0,     0.0,  1.6>
  sky       <0.0,     0.0,  1.0>
  up        <0.0,     0.0,  1.0>
  right     <1.3333,  0.0,  0.0>
  look_at   <0.000, 0.000, 6.0>
}

// *******  L I G H T S *******

light_source {                 // Indoor Light
  <20.00, -25.00, 20.00>
  color rgb <0.3, 0.3, 0.3>
  shadowless
}

light_source {                 // Sun
  <-100.00, -75.00, 100.00>
  color rgb <1.0, 1.0, 1.0>
}

background { color red 0.2 green 0.4 blue 0.9 }

plane
{
  z, -10.0
  texture {
    normal { dents }
    pigment { Green }
  }
}

object { // Actually, this is the window seat...
  ceiling
  scale <2, 20, 1>
  translate <-12, 15, 0>
}

object { // Real Cieling
  ceiling
  scale <20, 20, 1>
  translate <-6, 15, 28>
}

object { // Floor
  ceiling
  scale <20, 20, 1>
  translate <-6, 15, -9>
}

object { // Wall under window seat
  wall
  scale <10, 1, 3>
  rotate <0, 0, -90>
  translate <8, 20, 0>
}

object { // far wall
  wall
  scale <10, 1, 15>
  translate <-6, 10, 28>
}

difference
{
object {
  wall
  scale <10, 1, 10>
  rotate <0, 0, -90>
  translate <-6, 20, 28>
}
box
{
  < -6.2, -20, 23 >
  < -5.8, 5, 3 >
  pigment { White }
}
}

box     // Window Pane
{
  < -6.1, -20, 23 >
  < -5.9, 5, 3 >
  texture { T_Old_Thick_Glass }
//    texture { T_Old_Glass }
}

box     // vertical frame-beam
{
  < -6.4, 6, 23 >
  < -5.6, 4.5, 3 >
  texture { T_Wood1 rotate <0, 0, 90> }
}

box     // horizontal frame-beam
{
  < -6.4, -20, 4.5 >
  < -5.6, 5, 3 >
  texture { T_Wood1 rotate <0, 90, 0> }
}

box     // horizontal cross-beam
{
  < -6.4, -20, 14 >
  < -5.6, 5, 13 >
  texture { T_Wood1 rotate <0, 90, 0> }
}

box     // vertical cross-beam
{
  < -6.4, -5, 23 >
  < -5.6, -6, 3 >
  texture { T_Wood1 rotate <0, 0, 90> }
}

object {
  Specs
  scale <0.5, 0.5, 0.5>
  rotate <0, 0, -10>
  translate <-1, -8, 0.75>
}

object {
  PrismStand
  scale <1, 1, 1.5>
  rotate <0, 0, 15>
  translate <2, 1, 4.1>
}

// ******************  Prism Lights *******************

object {
  WallPrismLights
  translate <-3.25, 0, -1.0>
}

object {
  WallPrismLights
  translate <0, 0, 4>
}

object {
  WallPrismLights
  translate <3, 0, -0.75>
}

object {
  WallPrismLights
  translate <4, 0, 4.5>
}

object {
  WallPrismLights
  translate <8, 0, 1.05>
}

object {
  WallPrismLights
  translate <11, 0, -1.75>
}

object {
  WallPrismLights
  translate <12, 0, 3.2>
}

object {
  SeatPrismLights
  translate <-1, 0, 0>
}

object {
  SeatPrismLights
  translate <1, -3, 0>
}

object {
  SeatPrismLights
  translate <4, -1.5, 0>
}

object {
  SeatPrismLights
  translate <7.5, -1, 0>
}

object {
  WindowPrismLights
  translate <0, 12.25, 1>
}

object {
  WindowPrismLights
  translate <0, -2, 0>
}

object {
  Music
  scale 2.5
  rotate <0, 0, -100>
  translate <-1.75, -4, 0.05>
}

object {
  tree
  scale 0.04
  rotate <90, 0, -10>
  translate <-15, 8, -5>
}

object {
  tree
  scale <0.05, 0.15, 0.05>
  rotate <90, 0, -90>
  translate <-160, 185, -10>
}

object {
  willow
  scale <0.04, 0.08, 0.04>
  rotate <90, 0, 10>
  translate <-85, 60, -10>
}
