#include "colors.inc"
#include "textures.inc"
#include "stones.inc"
#include "stone_b.inc"
#include "gallery.inc"
#include "lectern.inc"
#include "alter.inc"
#include "rail.inc"
#include "candle_s.inc"
#include "bench.inc"

// Camera definition
camera {
    location <3.99, 2, -3>
//      location <0,2, -7>
//  direction <0, 0, 10>
//  look_at z*0

    look_at <-2,1.5,0>
//      look_at <0,1.5,0>
}

//light_source { <200, 200, -500> color White }
//light_source { <200, 2, -500> color White }
//light_source { <0,40,10> color White }
light_source { <0,60,-200> color rgb <0.6,0.6,0.575> 

              area_light <5,0,0> <0,5,0> 5,5 
              adaptive 1
              jitter 

}  //light through door
light_source { <0,10,5> color White }   //light through window


background { color White }
/*
box { <-1.3,0,-11> <1.3,5.5,0.4>
pigment { color rgbt <1,1,1,1> }
halo {
      dust
      dust_type 1
      box_mapping
      constant
      color_map {
        [ 0 color rgbt <1,1,1,1.0> ]
        [ 1 color rgbt <1,1,1,0.9> ]
       }
      samples 10
     }
    hollow
    scale 5
  }
*/

//stain glass window
box { <-1.3,2,0.4> <1.3,6.1,0.41>
texture { pigment { image_map { gif "sglass.gif" //filter 255 , 1
                                       filter all 0.9 }
scale <1,1.6,1>
scale 2.6
translate<-1.3,2,0>
} }
//translate y*-0.5
}

union {
difference {
                        //back wall
box { <-4,0,0> <4,11,0.4>

}
union {
box { <-1.3,1.664,-0.1> <1.3,4.8,1.1> }
cylinder { <0,4.8,-0.1> <0,4.8,1.1> 1.3 }
}
box { <-0.5,1.664,-0.5> <0,4.8,0>             //first slope 
     rotate y*-10
     translate <1.3,0,0.4> }
box { <-0.5,1.664,-0.5> <0,4.8,0>             //first slope - left side 
     translate x*0.5
     rotate y*10
     translate <-1.3,0,0.4> }

box { <-1.417,1.664,0.1> <1.417,4.8,0.3> }    //level 0.1 section
box { <-0.6,1.664,-0.6> <0,4.8,0>             //second (main) slope 
     rotate y*-10
     translate <1.417,0,0.3> }
box { <-0.6,1.664,-0.6> <0,4.8,0>            //second (main) slope - left side
     translate x*0.6
     rotate y*10
     translate <-1.417,0,0.3> }

}
box { <-1.3,0,0.4> <1.3,0.524,0>              //bottom rotated stone
     rotate x*50
     translate y*1.664 }
box { <-0.2,1.664,0> <0,4.8,0.2>
     rotate y*45
     translate z*0.35 }
clipped_by { box { <-4.1,-0.1,-0.1> <4.1,9.1,0.401> } }

texture { StoneBrick scale 0.7 translate x*-0.2 }//scale 2.5 }
//translate y*-0.5
}

plane { <0,1,0>, 0
                //bottom
texture { checker texture { T_Grnt11 } 
                  texture { T_Grnt28 } 
         scale 1/4 }
}

box { <-5.5,0,0> <5.5,5.5,1>        //left wall 
texture { StoneBrick scale 0.7}//stone_texture scale 2.5 }
rotate y*-90
translate <-4,0,-5.5> }

box { <-5.5,0,0> <5.5,5.5,1>        //right wall 
pigment { color Brown }//stone_texture scale 2.5 }
rotate y*90
translate <4,0,-5.5> }

difference {
box { <-4,0,0> <4,11,0.4> }            //front door
box { <-1.5,0,-0.1> <1.5,3,0.5> }
cylinder { <0,0,-0.1> <0,0,0.5>, 1.5
          scale <1,1.666,1> 
          translate y*3 }

pigment { color Brown }
translate z*-11.4
}

box { <-0.5,0,-11> <0,8,0>            //roof  left
     rotate z*-40
     translate <-4,5.5,0> pigment { color Brown } }
box { <0,0,-11> <0.5,8,0>             //roof  right
     rotate z*40
     translate <4,5.5,0> pigment { color Brown } }


//gallery
object { gallery }

object { alter }                    //alter

box { <-1.5,0,-1.25> <1.5,0.2,0>    //alter slab
texture { pigment { color Gray10 }
          normal { bumps 0.4 scale 0.2 } 
        }
}

object {candle_stand
        translate<1.25,1.3,-0.5> }
light_source {                      //right candle spotlight
       <1.25,6,-0.5>  //1.25
       color candle_light
       spotlight
       radius 12
       falloff 16
       tightness 14
  
       area_light <1, 0, 0> <0, 0, 1>, 2, 2
       adaptive 1
       jitter

       point_at <1.25,3.2,-0.5>
     }
light_source { <3.5,2.985,-0.5> //0.501
               color candle_light
               fade_power 0.3 //0.3
               fade_distance 0.5 //0.5
               area_light <1,0,0>, <0,1,0>, 2, 2
               adaptive 1
               jitter
             } 
/*
light_source {                     //light to show candle sticks
       <3.5,2,-0.5>
       color candle_light
       cylinder
       radius 12
       falloff 17
       tightness 13
       point_at <1.25,2,-0.5>
     }
*/
object {candle_stand
        translate<-1.25,1.3,-0.5> }
light_source {                      //left candle spotlight
       <-1.25,6,-0.5>
       color candle_light
       spotlight
       radius 12
       falloff 16
       tightness 14
  
       area_light <1, 0, 0> <0, 0, 1>, 2, 2
       adaptive 1
       jitter

       point_at <-1.25,3.2,-0.5>
     }

object {Stand                       //lectern 
        rotate y*-30
        translate <2.35,0.9,-1.25> }

light_source {      //light on lectern
  <3.5,2.5,-0.5> //-4.5	
  color candle_light
  cylinder
  radius 1
  falloff 1.4
  tightness 1.1

  area_light <1,0,0>, <0,1,0>, 2, 2
  adaptive 1
  jitter

  point_at <2.35,1.6,-1.25> 
}

object {rail                             //railing
        translate <-4+1/3,1.5*1/3+0.1,-2.35> }
box { <0,0,-0.1> <3+1/3,0.1,0.1>
     texture { T_Grnt2 }
     translate <-4,0,-2.35> }
object {rail
        rotate y*180
        translate <4-1/3,1.5*1/3+0.1,-2.35> }
box { <0,0,-0.1> <3+1/3,0.1,0.1>
     texture { T_Grnt2 }
     translate <2/3,0,-2.35> }
object {bench                            //bench left side
        translate <-0.75,1,0>
        rotate y*-90
        scale 0.4
        translate <-2/3,0,-3.25> }  //-1

object {knee_stool                       //knee stool
        rotate y*-90
        scale 0.4
        translate <-2/3,0,-2.6> }
object {knee_stool                       //knee stool
        rotate y*-90
        scale 0.4
        translate <4,0,-2.6> }

object {bench                            //bench right side
        translate <-0.75,1,0>
        rotate y*-90
        scale 0.4
        translate <4,0,-3.25> } //4
#declare RugRed = color rgb<0.464,0,0.078>

union {                                            //rug
box { <-0.5,0,-5> <0.5,0.01,0> }    //walk way rug
box { <-0.5,0,-1.26> <0.5,0.21,0> } //alter slab rug  
texture { pigment { color RugRed }
          normal { bumps 0.025 scale 0.2 }
        }
}

/*
object {bench_side
        translate y*1
        rotate y*-90
        scale 1/2
        translate <-1,0,-3.25> }

object {bench_side
        translate y*1
        rotate y*-90
        scale 1/2
        translate <-3.95,0,-3.25> }


object {bench_side
        translate y*1
        rotate y*-90
        scale 1/2
        translate <1,0,-3.25> }  //0.75
*/        


box { <-5.5,0,-2.1> <5.5,0.1,0>        //gallery upper right
rotate y*90
translate <4,3.4,-5.5>
texture { pigment { DMFWood3 } } }