
// Persistence of Vision Ray Tracer Scene Description File
// File: coke.pov
// Vers: 3
// Desc: Smashed Coca-Cola bottle at a party
// Date: Feb 27 1997
// Auth: Mick McMullin
//

//#declare noGlass   = 1
//#declare noBottles = 1


#version 3
#include "coketex.inc"
#include "coketexm.inc"
#include "blobs.inc"
#include "bottle.inc"
#include "smash.inc"

global_settings
{
  assumed_gamma 1.0
  max_trace_level 20

}

// ----------------------------------------
camera
{
  location  <2, 14, -40>
  direction 1.5*z
  right     4/3*x
  look_at   <0.0, 10,  0.0>
}

sky_sphere
{
  pigment
  {
    gradient y
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source
{
  0*x // light's position (translated below)
  color rgb <0.5,0.5,0.3>  // light's color
  fade_distance 10
  fade_power    1
  translate <-30, 30, -30>
}

// ----------------------------------------
// Table top
// ----------------------------------------
union {
      box
      {
        <-20, -1, -5>  // one corner position <X1 Y1 Z1>
        < 29,  0, 29>  // other corner position <X2 Y2 Z2>
      }
      box
      {
        <-15, -8, 0>  // one corner position <X1 Y1 Z1>
        < 29,  -1, 24>  // other corner position <X2 Y2 Z2>
      }

  texture { Table_Top }
}

// ----------------------------------------
// Shelves
// ----------------------------------------
union {
      box { <-200, 17, 60> < -20,  19, 100> texture { Table_Top } }
      box { <-200, 48, 60> < -20,  50, 100> texture { Table_Top } }

      // back of shelves
      box { <-200, 15, 98> < -20,  59, 100> texture { Table_Top rotate <90,0,0>} }

      // side of shelves
      box { <-20, 18, 65> < -19,  59, 100> texture { Table_Top rotate <0,0,90>} }
      cylinder { <-20, 20 ,65> <-19, 20, 65>, 4 texture { Table_Top rotate <0,0,90>} }
      
      // some books...
      box { <-25, 19, 55> <-21, 45, 90>
          texture { pigment { rgb <0,0,0.7> } finish { crand 0.6 } }
          }
      box { <-4, 0, 0> <0, 23, 30> rotate <0,0,-10> translate <-35,19,60>
          texture { pigment { rgb <0.8,0,0> } finish { crand 0.6 } }
          }
      box { <-55, 19, 62> <-40, 25, 90>
          texture { pigment { rgb <0,0.8,0> } finish { crand 0.5 } }
          }
}

// ----------------------------------------
// Poster
// ----------------------------------------
box { <20, 10, 99.5> < 100,  59, 99.8>
      texture { pigment { mandel 50 // (2...1000) [256]
                          scale 50 translate <15,30,0> // zoom and move
                          color_map {
                                     [0.0 color rgb 0 ]
                                     [0.1 color rgb <0.8, 0, 0> ]
                                     [0.5 color rgb <0, 0.7, 0> ]
                                     [1.0 color rgb <0, 0, 0.7> ]
                                     }
                         } // END PIGMENT
               } // END TEXTURE
      rotate <0,0,3>
 }

// ----------------------------------------
// Room
// ----------------------------------------
box
{
  <-1000, 140, -1000>  // one corner position <X1 Y1 Z1>
  < 1000, 141, 1000>  // other corner position <X2 Y2 Z2>

  texture { Ceiling }
}

box
{
  <-1000, -1000, 100>  // one corner position <X1 Y1 Z1>
  < 1000, 1000, 101>  // other corner position <X2 Y2 Z2>

  texture { Wall }
}
box
{
  <-1000, -1000, -51>  // one corner position <X1 Y1 Z1>
  < 1000, 1000, -50>  // other corner position <X2 Y2 Z2>

  texture { Wall }
}
box
{
  <-51, -1000, -1000>  // one corner position <X1 Y1 Z1>
  <-50, 1000, -1000>  // other corner position <X2 Y2 Z2>

  texture { Wall }
}
box
{
  <100, -1000, -1000>  // one corner position <X1 Y1 Z1>
  <101, 1000, -1000>  // other corner position <X2 Y2 Z2>

  texture { Wall }
}


// ----------------------------------------
// Coke bottles
// ----------------------------------------
#ifndef (noBottles)

  union {
      intersection {
           object { Bottle1 }
           object { smash1 }
      }
      object { Powder_Pile }
      object { Straw }
      translate <2,0,0>
  }

  object { Bottle2 rotate <0,10,0>}

#end

//object { Powder_Pile translate <2, 0, 0> }  //*************************

object { Candle  pigment {rgb 0.9 } translate <11,0,5>}
