// Crystal include file
// For POVRAY's Feb 1997 competition
// Produced by The Butter-Fingered Juggler

// -------------------------------------------------------
// texture for final version only as it takes 10 times as long to compile
// S_Crystal after Swavoski (?) Crystal

#declare S_Crystal = texture {
pigment {color rgbf <0.9, 0.9, 0.95, 0.8>}

finish {
       diffuse 0.6
       ambient 0.1
       brilliance 4.0
       specular 0.9 roughness 0.03
       reflection 0.2
       refraction on
       ior 2.3
       }
}
/*
// Rough working texture (approx 10 times faster than above texture)

#declare S_Crystal = texture {
pigment {color White}
}
*/


#declare Brassy = texture {
        pigment {color Brass}
        finish {
         metallic
         ambient 0.15
         diffuse 0.7
         brilliance 6.0
         reflection 0.5
         phong 0.8
         phong_size 120
        }
     }

#declare Red_Velvet = texture {
    pigment {color Red}
    finish {crand 0.1}
    normal {wrinkles 0.2}
}

// ------------------------------------------------------
// Basic objects

#declare Crystal_Sphere = intersection {

#declare Angle = 0
#while (Angle < 120)
      plane {x, 4.7
            rotate <10*Angle, 0, 10*Angle>}
      plane {x, 4.7
            rotate <15*Angle, 20, 15*Angle>}
      plane {x, 4.7
            rotate <10*Angle, 40, 10*Angle>}
      plane {x, 4.7
            rotate <15*Angle, 60, 15*Angle>}
      plane {x, 4.7
            rotate <20*Angle, 80, 20*Angle>}
      plane {x, 4.7
            rotate <15*Angle, -20, 15*Angle>}
      plane {x, 4.7
            rotate <10*Angle, -40, 10*Angle>}
      plane {x, 4.7
            rotate <15*Angle, -60, 15*Angle>}
      plane {x, 4.7
            rotate <20*Angle, -80, 20*Angle>}

      #declare Angle = Angle + 10
#end

texture {S_Crystal}

} // end cry_sphere intersection

#declare Crystal_Sphere_Small = intersection {

#declare Angle = 0
#while (Angle < 120)
      plane {x, 3.35
            rotate <20*Angle, 0, 20*Angle>}
      plane {x, 3.35
            rotate <15*Angle, 25, 15*Angle>}
      plane {x, 3.35
            rotate <20*Angle, 50, 20*Angle>}
      plane {x, 3.35
            rotate <10*Angle, 75, 10*Angle>}
      plane {x, 3.35
            rotate <15*Angle, -25, 15*Angle>}
      plane {x, 3.35
            rotate <20*Angle, -50, 20*Angle>}
      plane {x, 3.35
            rotate <10*Angle, -75, 10*Angle>}

      #declare Angle = Angle + 10
#end

texture {S_Crystal}

} // end cry_sphere intersection

#declare Crystal_Wing = difference {

object {Crystal_Sphere
       rotate <0, 90, 0>
       scale <1, 1.5, 1>
       }
plane {z, -3 inverse}
sphere {<0, 6, -2>, 3}
sphere {<0, 5, 0>, 2
        scale <1, 2, 1>}

rotate <30, 0, 0>

texture {S_Crystal}
}

// ---------------------------------------------
// Baby Bird

#declare Baby_Bird = union {
object {Crystal_Sphere
       scale <1, 1.5, 1>
       clipped_by {plane { -y, 5} } }
object {Crystal_Sphere
       scale 0.75
       translate <0, 8, 0>}
cone {<0, 8, -3>, 1
      <0, 7.5, -6>, 0
      texture {S_Crystal} }
sphere {<2, 9, -2.5>, 0.5
       pigment {color Black} finish {Shiny} }
sphere {<-2, 9, -2.5>, 0.5
       pigment {color Black} finish {Shiny} }
object {Crystal_Wing
       translate <0, 0, -2>
       rotate <0, 90, 0>}
object {Crystal_Wing
       translate <0, 0, -2>
       rotate <0, -90, 0>}

} // end Baby_Bird

// ---------------------------------------------
// Pig

#declare Pig = union {
object {Crystal_Sphere
       scale <1, 1.2, 1>
       clipped_by {plane {y, 4.5}}
       clipped_by {plane {y, -3 inverse}}
}

object {Crystal_Sphere_Small
       translate <0, 6.5, 0>}

sphere {<1.5, 7.5, -3>, 0.3
       pigment {color Black}
       finish {Shiny} }
sphere {<-1.5, 7.5, -3>, 0.3
       pigment {color Black}
       finish {Shiny} }
cylinder {<-0.3, 5.5, -3.2>, <0.3, 5.5, -3.2>, 0.2
         pigment {color Black}
         finish {Shiny} }
// ears
cone {<2.85, 8.5, 0>, 0.7
     <4.5, 9.5, 0>, 0 }
cone {<-2.85, 8.5, 0>, 0.7
     <-4.5, 9.5, 0>, 0 }

// nose
cylinder {<0, 6.8, -3.3>, <0, 6.8, -4>, 0.7 }
sphere {<-0.2, 6.8, -4.1>, 0.2
       pigment {Black}
       finish {Shiny} }
sphere {<0.2, 6.8, -4.1>, 0.2
       pigment {Black}
       finish {Shiny} }
// arms
cone {<0, 0, 0>, 1
     <0, 4, 0>, 0
     scale <1.2, 1, 1>
     clipped_by {plane {x, 0} }
     rotate <0, 0, -25>
     translate <-4.8, 1, 0>
}
cone {<0, 0, 0>, 1
     <0, 4, 0>, 0
     scale <1.2, 1, 1>
     clipped_by {plane {x, 0 inverse} }
     rotate <0, 0, 25>
     translate <4.8, 1, 0>
}

texture {S_Crystal}
} // end pig union

// ----------------------------------------------------

// Baby hedgehog
#declare Hedgehog = union {

intersection {

#declare Angle = 0
#while (Angle < 120)
      plane {x, 4.7
            rotate <10*Angle, 0, 10*Angle>}
      plane {x, 4.7
            rotate <15*Angle, 20, 15*Angle>}
      plane {x, 4.7
            rotate <10*Angle, 40, 10*Angle>}
      plane {x, 4.7
            rotate <15*Angle, 60, 15*Angle>}
      plane {x, 4.7
            rotate <20*Angle, 80, 20*Angle>}
      plane {x, 4.7
            rotate <15*Angle, -20, 15*Angle>}
      plane {x, 4.7
            rotate <10*Angle, -40, 10*Angle>}
      plane {x, 4.7
            rotate <15*Angle, -60, 15*Angle>}
      plane {x, 4.7
            rotate <20*Angle, -80, 20*Angle>}

      #declare Angle = Angle + 10
#end
plane {y, 0 inverse}
plane {z, 4.3}
plane {z, -4.3 inverse}
}

#declare Angle = 1
#while (Angle < 6)
      cone {<4.7, 0, 0>, 0.5
            <5.7, 0, 0>, 0
            rotate <30*Angle, 20, 30*Angle> }
      cone {<4.7, 0, 0>, 0.5
           <5.7, 0, 0>, 0
           rotate <30*Angle, -20, 30*Angle> }
      cone {<4.7, 0, 0>, 0.5
           <5.7, 0, 0>, 0
           rotate <30*Angle, -60, 30*Angle> }
      #declare Angle = Angle + 1
#end

#declare Angle = 1
#while (Angle < 9)
       cone {<4.7, 0, 0>, 0.5
             <5.7, 0, 0>, 0
             rotate <20*Angle , 0, 20*Angle> }
      cone {<4.7, 0, 0>, 0.5
           <5.7, 0, 0>, 0
           rotate <20*Angle, 40, 20*Angle> }
      cone {<4.7, 0, 0>, 0.5
           <5.7, 0, 0>, 0
           rotate <20*Angle, -40, 20*Angle> }
      #declare Angle = Angle + 1
#end

// nose
cone {<0, 1.5, -4.3>, 1.5
      <0, 1.5, -8>, 0.2
      }
sphere {<0, 1.5, -8>, 0.3
       pigment {color Black}
       finish{Shiny} }
sphere {<1.2, 2, -4.5>, 0.3
       pigment {color Black}
       finish{Shiny} }
sphere {<-1.2, 2, -4.5>, 0.3
       pigment {color Black}
       finish{Shiny} }

scale <1, 2, 1>
texture {S_Crystal}

} // end Hedgehog union

// ----------------------------------------------------
// Bell

#declare Bell = union {

object {Crystal_Sphere
       rotate <90, 0, 0>
       scale <0.7, 1.1, 0.7>
       clipped_by {plane {y, -1.5 inverse}}
}

intersection {
#declare Angle = 0
#while (Angle <360)
       plane {x, 2.4
             rotate <0, 0, 30>
             rotate <0, Angle, 0>
             }
    #declare Angle = Angle + 20
#end
plane {y, 0.5}
plane {y, -2 inverse}

}
sphere {<0, 5.3, 0>, 1}
sphere {<0, 0, 0>, 1
       scale <1.1, 2.2, 1.1>
       translate <0, 7.5, 0>
}

texture {S_Crystal}
} // end bell union

// --------------------------------------------------
// Name plate

#declare Screw = union {
  torus {0.5, 0.02
    texture {Brassy}
    rotate <90, 0, 0>}
  difference {
    cylinder {<0, 0, 0>, <0, 0, -0.03>, 0.4 texture {Brassy}}
    cylinder {<-0.5, -0.5, -0.04>, <0.5, 0.5, 0>, 0.1 texture {Brassy}}
  }
}
#declare Plaque = union {
   object {Screw translate <-0.2, 1.55, -0.2>}
   object {Screw translate <7.2, 1.55, -0.2>}
   box {<0, 0.9, 0>, <7, 2, -0.1> texture {Brassy}}
   object {char_K
        pigment {color Black}
        scale <0.15, 0.15, 0.1>
        translate <1, 1.1, -0.12>
   }
   object {char_M
         pigment {color Black}
         scale <0.15, 0.15, 0.1>
         translate <2, 1.1, -0.12>
   }
   object {char_A
         pigment {color Black}
         scale <0.15, 0.15, 0.1>
         translate <2.7, 1.1, -0.12>
   }
   object {char_N
         pigment {color Black}
         scale <0.15, 0.15, 0.1>
         translate <3.4, 1.1, -0.12>
   }
   object {char_N
         pigment {color Black}
         scale <0.15, 0.15, 0.1>
         translate <4.1, 1.1, -0.12>
   }
   object {char_I
         pigment {color Black}
         scale <0.15, 0.15, 0.1>
         translate <4.7, 1.1, -0.12>
   }
   object {char_N
         pigment {color Black}
         scale <0.15, 0.15, 0.1>
         translate <5.3, 1.1, -0.12>
   }
   object {char_G
         pigment {color Black}
         scale <0.15, 0.15, 0.1>
         translate <6, 1.1, -0.12>
   }
}
