/***************************************************************************/
//		dive_in.pov
//
//		by:  Hero Ngauv
//		contact:  mroreo123@juno.com
/***************************************************************************/
#include "colors.inc"
#include "textures.inc"
#include "herotxtr.inc"

#declare Vector = <0,75,-65>
#declare Direction = 1
camera{
  location Vector
  direction <0,0,Direction>
  look_at <0,0,0>
}
light_source{ (Vector + <0,0,0>) color Gray25 }
light_source{ <0,0,0> color Gray95 }
global_settings{ max_trace_level 10 }
/***************************************************************************/
//				The Signature
/***************************************************************************/
text{
  ttf "isadora.ttf",
  "HERO  NGAUV", 0.001,0
  texture{
    pigment{ White transmit 1.25 }
    finish{ ambient 1 diffuse 0 }
  }
  no_shadow
  scale 1/20
  translate <0.35,-0.45,1>
  rotate x*49
  translate Vector
}
/***************************************************************************/
//				The Water
/***************************************************************************/
union{
  torus{ 75,50 clipped_by{ plane{ -y, -0 } } }
  torus{ 75,50 scale <1,5,1> clipped_by{ plane{ y, 0 } } }
  disc{ <0,50,0>, <0,1,0>, 1000000 75 }
  
  texture{
    pigment{ color SlateBlue }
    finish{ Metal }
    normal{ Water_Surface scale <10,100,10> }
  }
  hollow
}
sphere{ <0,0,0>, 10000
  texture{
    pigment{ color SlateBlue }
  }
  hollow
}
/***************************************************************************/
//				The Cables
/***************************************************************************/
union{
  merge{
  torus{ 250, 1 rotate <90,0,0> translate <250,0,0> rotate <0,60,0> }
  torus{ 250, 1 rotate <90,0,0> translate <250,0,0> rotate <0,120,0> }
  torus{ 250, 1 rotate <90,0,0> translate <250,0,0> rotate <0,180,0> }
  torus{ 250, 1 rotate <90,0,0> translate <250,0,0> rotate <0,240,0> }
  torus{ 250, 1 rotate <90,0,0> translate <250,0,0> rotate <0,300,0> }
  torus{ 250, 1 rotate <90,0,0> translate <250,0,0> rotate <0,360,0> }
  clipped_by{ plane{ -y, 0 } }
  }
  cylinder{ <0,0,0>,<0,-100,0>, 1 open }
  
  texture{
    pigment{ color White filter 0.9 }
    finish{
      diffuse 1
      specular 0.25
      roughness 0.005
      reflection 0.2
      refraction 1
      ior 1.5
    }
  }
  scale <1,2/5,1>
  rotate <0,-15,0>
  translate <0,-5,0>
  no_shadow
}
/***************************************************************************/
//				Spheres of Energy
/***************************************************************************/
#declare Ball =
sphere{ 0, 0.95
  texture{
    pigment{ rgbt 1 }
    halo{
      emitting
      linear
      samples 25
      turbulence 0.15
      lambda 2.5
      omega 0.6
      scale 0.85
      frequency 1
      color_map{
        [0.0 SlateBlue transmit 1]
        [0.5 color (White*2+SlateBlue)/3 transmit 0.5]
        [0.7 color (White*2+SlateBlue)/3 transmit 0]
        [0.8 color (White*2+SlateBlue)/3 transmit -0.5]
        [1.0 color (White*2+SlateBlue)/3 transmit -2.35]
      }
    }
  }
  hollow
  scale 10
  translate <0,0,0>
}
#declare S = seed(0)
#declare C = 0
#declare Distance = 100*3
#declare Number = 6*3
#while (C < Number)
  object{ Ball
    rotate <rand(S)*360,rand(S)*360,rand(S)*360>
    translate <0,-35+Distance/Number*C,0>
  }
  #declare C = C + 1
#end
/***************************************************************************/
//				Joint Rotations
/***************************************************************************/
#declare Neck_Rotation1       = <0,0,0>
#declare Neck_Rotation2       = <0,0,0>
#declare Neck_Rotation3       = <0,0,0>
                                      
#declare Head_Rotation1       = <0,0,0>
#declare Head_Rotation2       = <0,0,0>
#declare Head_Rotation3       = <0,0,0>
                                      
#declare Torso_Rotation1      = <-10,0,0>
#declare Torso_Rotation2      = <0,0,0>
#declare Torso_Rotation3      = <0,0,0>
                                      
#declare Lower_Body_Rotation1 = <0,0,0>
#declare Lower_Body_Rotation2 = <0,0,0>
#declare Lower_Body_Rotation3 = <0,0,0>
/***************************************************************************/
#declare R_Arm_Rotation1      = <0,0,0>
#declare R_Arm_Rotation2      = <0,0,10>
#declare R_Arm_Rotation3      = <20,0,0>
                                      
#declare R_Elbow_Rotation1    = <-20,0,0>	// -x only
#declare R_Elbow_Rotation2    = <0,0,0>
#declare R_Elbow_Rotation3    = <0,0,0>
                                      
#declare R_Hand_Rotation1     = <0,45,0>
#declare R_Hand_Rotation2     = <0,0,0>
#declare R_Hand_Rotation3     = <0,0,0>
                                      
#declare L_Arm_Rotation1      = <0,0,0>
#declare L_Arm_Rotation2      = <0,0,-10>
#declare L_Arm_Rotation3      = <20,0,0>
                                      
#declare L_Elbow_Rotation1    = <-20,0,0>	// -x only
#declare L_Elbow_Rotation2    = <0,0,0>
#declare L_Elbow_Rotation3    = <0,0,0>
                                      
#declare L_Hand_Rotation1     = <0,-45,0>
#declare L_Hand_Rotation2     = <0,0,0>
#declare L_Hand_Rotation3     = <0,0,0>
/***************************************************************************/
#declare R_Leg_Rotation1      = <0,0,-5>
#declare R_Leg_Rotation2      = <0,0,0>
#declare R_Leg_Rotation3      = <0,0,0>
                                      
#declare R_Knee_Rotation      = <5,0,0>	// +x only
                                      
#declare R_Foot_Rotation1     = <-5,0,0>
#declare R_Foot_Rotation2     = <0,0,0>
#declare R_Foot_Rotation3     = <0,0,0>
                                      
#declare L_Leg_Rotation1      = <0,0,0>
#declare L_Leg_Rotation2      = <-40,0,0>
#declare L_Leg_Rotation3      = <0,0,0>
                                      
#declare L_Knee_Rotation      = <15,0,0>	// +x only
                                      
#declare L_Foot_Rotation1     = <25,0,0>
#declare L_Foot_Rotation2     = <0,0,0>
#declare L_Foot_Rotation3     = <0,0,0>
/***************************************************************************/
//				The Glass Surfer
/***************************************************************************/
#include "person2.inc"
union{
  object{
    Person2
    texture{
      pigment{ color White filter 0.9 }
      finish{
        diffuse 1
        refraction 1
        ior 1.5
        specular 0.25
        roughness 0.005
      }
    }
    translate <0,0.5,0>
  }
  merge{
    torus{ 2.5, 1 }
    cylinder{ <0,1,0>,<0,-1,0>, 2.5 }
    box{ <2.5,1,0>,<-2.5,-1,-5> }
    cylinder{ <2.5,0,0>,<2.5,0,-5>, 1 }
    cylinder{ <-2.5,0,0>,<-2.5,0,-5>, 1 }
    sphere{ <2.5,0,-5>, 1 }
    sphere{ <-2.5,0,-5>, 1 }
    cylinder{ <2.5,0,-5>,<-2.5,0,-5>, 1 }
    
    texture{
      pigment{ color White filter 0.9 }
      finish{
        diffuse 1
        refraction 1
        ior 1.5
        specular 0.25
        roughness 0.005
      }
    }
    translate <0,0,5>
    scale <0.5,0.5,2>
    translate <0,0.5,-3>
  }
  rotate <30,0,0>
  translate <0,46,-55>
  rotate <0,-10,0>
}
