//IRTC Feb 97 - LORESCAN.INC (Low resolution scanner)

#declare Scan_wire =
union {
  difference {
    torus { 2, 0.125 }
    box { <-3, -1, -3> <3, 1, 0> }
    box { <0, -1, -3> <3, 1, 3> }
  }
  cylinder { <0, 0, 2> <10, 0, 2>, 0.125 }
  translate <2, 0, 0>
  rotate <0, 90, 0>
}

#declare unit_scan =
union {
  difference { // Focusing unit
    sphere { <0,0,0>, 2 }
    box { <-0.1875, -0.1667, -4> <0.1875, 0.1667, 4> }
    plane { z, 1.85 }
    texture { Glass2 }
    translate <0, 0, -1.85>
  }
}


#declare SX = 0
#declare SY = 0
#declare scan_plate_row =
union {
  #while (SX < 32)
    object { unit_scan translate <-5.8125 + SX * 0.375, -3.8333 + SY * 0.3333, 0> }
    #declare SX = SX + 1
  #end
}


#declare Lo_res_scan =
union {
  union {
    difference {
      box { <-6.5, -4.5, -0.25> <6.5, 4.5, 0.25> }
      box { <-6, -4, -1> <6, 4, 2> }
    }
    box { <-2, -7, -0.25> <2, -4.5, 0.25> }
    box { <-6.5, -7.5, -0.75> <6.5, -7, 0.75> }
    texture { pigment { White } }
  }
  object { Scan_wire translate <6.5, -7.25, 0> 
    texture { pigment { White } }
  }


  #declare SY = 0
  #while (SY < 24)
    object { scan_plate_row translate <0, SY * 0.3333, 0> }
    #declare SY = SY + 1
  #end

}

