Program Chaos12d_to_POV;

Uses CRT;

Const MaxPoints = 4;
      Ignore = 50;
      Radius = 0.025;

Type Coord = Record X,Y,Z:Real; End;

Var
   Points: Array [1..MaxPoints] of Coord;
   X, Y, Z:  Real;
   Dx, Dy, Dz:  Real;
   Next:  Integer;
   Cnt:  Integer;
   what:  Char;
   outfile:  Text;
   outfilename:  String;
   OutPoints:  Integer;
   ThreeD:Boolean;

Procedure WritePixel( X,Y,Z:Real );
    Begin
    {--
      The coordinates for Y & Z are swapped here so the object is in the
       X-Z plane, not the X-Y plane
    --}

    If ThreeD Then
        writeln( outfile, '    sphere { <',X:8:4, ',', Z:8:4, ',', Y:8:4, '> ', Radius:4:2, '  }' )
    Else
        writeln( outfile, '    sphere { <',X:8:4, ', 0.0, ', (Y+Radius/2):8:4, '> ', Radius:4:2, '  }' );
    { West, North, Up, radius }
    End;


Begin

Write('Output filename ?');
readln(outfilename);
assign( outfile, outfilename );
rewrite(outfile);
Write('How Many Points ? ');
Readln(OutPoints);
Write('(3)Dimensional or (2)Dimensional ? ');
What := ' ';
Repeat
    Readln(What);
    Until (What = '3') or (What = '2');

ThreeD := What = '3';

Writeln(outfile,'#declare sierpinski = merge');
Writeln(outfile,'    {');


Randomize;

Points[1].X := 1.0; { Left }
Points[1].Y := 0.0;

Points[2].X := -1.0; {Right}
Points[2].Y := 0.0;

Points[3].X := 0.0; {Top}
Points[3].Y := 1.0;
If ThreeD Then
    Begin
    Points[1].Z := 0.0; { insure Z is 0 }
    Points[2].Z := 0.0;

    Points[3].Y := 1.0; { Top Center of pyramid }
    Points[3].Z := Sqrt(3)/2;

    Points[4].X := 0.0;  { Back }
    Points[4].Y := 0.0;
    Points[4].Z := Sqrt(3);
    End;

X := Random;
Y := Random;
Z := Random;

{ Write corners }
With Points[1] Do WritePixel( X, Y, Z );
With Points[2] Do WritePixel( X, Y, Z );
With Points[3] Do WritePixel( X, Y, Z );
If ThreeD then
    With Points[4] Do WritePixel( X, Y, Z );

Cnt := 1;
While Cnt < (Ignore + outPoints) do
    Begin
    if Cnt > Ignore then
        writePixel( X, Y, Z );
    Inc(Cnt);

    If ThreeD then
        Next := Trunc(Random * MaxPoints) +1
    Else
        Next := Trunc(Random * Pred(MaxPoints)) +1;

    If X > Points[Next].X then
        Begin
        Dx := X - Points[Next].X;
        X := X - Dx / 2;
        End
    else
        Begin
        Dx := Points[Next].X - X;
        X := X + Dx / 2;
        End;

    If y > Points[Next].y then
        Begin
        Dy := y - Points[Next].y;
        Y := Y - Dy / 2;
        End
    else
        Begin
        Dy := Points[Next].y - y;
        Y := Y + Dy / 2;
        End;

    If ThreeD Then
        Begin
        If Z > Points[Next].z then
            Begin
            Dz := Z - Points[Next].z;
            Z := Z - Dz / 2;
            End
        else
            Begin
            Dz := Points[Next].z - Z;
            Z := Z + Dz / 2;
            End
        End
    End;
Writeln(outfile,'    }');
close(outfile);
End.