
// Persistence of Vision Ray Tracer Scene Description File
// File: fameduse.pov
// Vers: 3.0
// Date: A certain day of February '97
// Auth: Franck ANGELLA (angella@goelette.tsi.u-bordeaux.fr)


#include "colors.inc"
#include "shapes.inc"
#include "textures.inc"
#include "woods.inc"
#include "teak.map"
#include "stones.inc"


camera
{
   location <0.0, -0.5, 0.0>
   look_at <0.0, -0.5, 200.0>
}

light_source { <-5.0, -0.5, -5.0> color White shadowless}

light_source
{
  <10.0, 100.0, 0.0>
  color rgb <1,1,1>
  spotlight
  point_at <0, 0, 0>
  radius 15
  tightness 50
  falloff 16
}

background { color Blue }


fog
{
  distance 5
  fog_type 2
  fog_offset -1.20
  fog_alt 1.0
  turbulence 0.1
  turb_depth 0.2
  color <0.0, 0.8, 0.8>
}

fog
{
  distance 4
  fog_type 2
  fog_offset -1.20
  fog_alt 0.5
  turbulence 0.2
  turb_depth 0.2
  color <0.0, 0.5, 0.5>
}


#declare Fond = union
{
  plane
  {
    y, -5.0
    texture
    {
      pigment { color <0.2, 0.0, 0.5> }
    }
  }
  height_field
  {
    gif "plasma3.gif"
    //smooth
    scale <10.0, 0.2, 10.0>
    translate <-5.0, -0.9, -1.0>
    rotate 90*y
    texture { T_Stone16 scale 3 normal { bumps 1.0 } }
 //   texture { pigment { rgb<0.2, 0.0, 0.5> } normal { bumps 1.0 } }
  }
}

#declare Surface = object
{
  plane
  {
    y, 0.0
    texture
    {
      pigment { color rgbt<1.0, 1.0, 1.0, 0.6> }
      normal { bumps 5.0 scale 0.3 }
      finish { phong 1.0 reflection .1 ambient 0.5 diffuse 0.2 refraction 0.5 ior 1.33 }
    }
  }
  rotate 180*z
}

#declare Piles = merge
{
  cylinder { <0.0, -2.0, 0.0> <0.0, 0.5, 0.0> 0.1 }
  cylinder { <1.0, -2.0, 0.0> <1.0, 0.5, 0.0> 0.1 }
  cylinder { <-0.1, -2.0, 0.9> <0.0, 0.5, 1.0> 0.1 }
  cylinder { <1.0, -2.0, 1.0> <1.0, 0.5, 1.0> 0.1 }
  cylinder { <0.0, -2.0, 2.0> <0.0, 0.5, 2.0> 0.1 }
  cylinder { <1.1, -2.0, 1.95> <1.0, 0.5, 2.0> 0.1 }
}

#declare Ponton = difference
{
  box { <0.0, 0.1, -2.0> <1.0, 0.2, 2.0> }
  union
  {
    box { <0.2, 0.0, 0.2> <0.8, 0.3, 0.3> }
    box { <0.2, 0.0, 0.6> <0.8, 0.3, 0.7> }
    box { <0.2, 0.0, 1.0> <0.8, 0.3, 1.1> }
    box { <0.2, 0.0, 1.4> <0.8, 0.3, 1.5> }
  }
}

#declare Rondins = merge
{
  cylinder { <-0.02, -0.8, 1.11> <1.02, -0.3, 0.89> 0.02 }
  cylinder { <0.11, -0.7, 0.98> <0.11, -0.2, 2.02> 0.02 }
  cylinder { <0.11, -0.3, 1.02> <-0.11, -0.3, -0.02> 0.02 }
  cylinder { <0.89, -0.3, 0.98> <0.89, -0.2, 2.02> 0.02 }
}

#declare Pont = merge
{
  object { Piles }
  object { Ponton }
  object { Rondins }
  texture
  {
    pigment
    {
      P_WoodGrain4A
      color_map { M_Teak }
      scale 2
      rotate x*90
    }
    normal { ripples 5.0 scale 0.1 rotate 45 }
  }
  rotate -30.0*y
  translate 0.6*x
  translate 1.0*z
}

#declare Demi_Coque = difference
{
  sphere
  {
    <0.0, 0.0, 0.0>
    1.0
  }
  box
  {
    <-1.1, -1.1, -1.1>
    <0.0, 1.1, 1.1>
  }
  box
  {
    <-0.1, 0.0, -1.1>
    <1.1, 1.1, 1.1>
  }
  scale <0.5, 0.5, 1.0>
  texture
  {
    gradient z scale 0.1
    texture_map
    {
      [ 0.3 T_Wood19 finish { specular 0.50 roughness 0.1 ambient 0.25 } normal { bumps 2.0 scale 0.5 } ]
      [ 0.6 pigment { P_WoodGrain4A color_map { M_Teak } scale 2 } normal { bumps 2.0 scale 0.5 } ]
      [ 0.9 T_Wood19 finish { specular 0.50 roughness 0.1 ambient 0.25 } normal { bumps 2.0 scale 0.5 } ]
    }
  }
}

#declare Squelette_Coque = difference
{
  cylinder
  {
    <-0.05, 0.0, 0.0>
    <0.05, 0.0, 0.0>
    1.1
  }
  cylinder
  {
    <-0.5, 0.0, 0.0>
    <0.5, 0.0, 0.0>
    0.9
  }
  box
  {
    <-1.5, 0.0, -1.5>
    <1.5, 1.1, 1.5>
  }
  scale <0.5, 0.5, 1.0>
  pigment { P_WoodGrain4A color_map { M_Teak } scale 2 }
}

#declare Barque = merge
{
  object { Demi_Coque }
  object { Demi_Coque rotate 180*y }
  object { Squelette_Coque }
  rotate -5*z
  translate <-1.0, 0.1, 4.5>
}

#declare Rayon_Membrane_Superieure     = 8.0
#declare Epaisseur_Membrane_Superieure = 0.8
#declare Ecrase_Membrane_Superieure    = 0.9
#declare Hauteur_Membrane_Inferieure   = 9.0
#declare Rayon_Membrane_Inferieure     = 2.0
#declare Ecart_Membranes               = 1.0
#declare Largeur_Corps_Extremite       = 1.0
#declare Hauteur_Corps_Masse           = 20.0

#declare Texture_Filament = texture
{
  pigment { White filter 1.0 }
  finish
  {
    ambient 0.0
    diffuse 0.0
    reflection 0.25
    refraction 1.0
    ior 1.33
    specular 1.0
    roughness 0.001
    fade_distance 5.0
    fade_power 1.0
  }
}

#declare Texture_Meduse_Bump = texture
{
  pigment { White filter 1.0 }
  normal { bumps scale 2.0 }
  finish
  {
    ambient 0.0
    diffuse 0.0
    reflection 0.25
    refraction 1.0
    ior 1.33
    specular 1.0
    roughness 0.001
    fade_distance 5.0
    fade_power 1.0
    caustics 1.0
    irid
    { 0.35 thickness 0.5 turbulence 0.5 }
  }
}

#declare Texture_Meduse = texture
{
  pigment { White filter 1.0 }
  finish
  {
    ambient 0.0
    diffuse 0.0
    reflection 0.25
    refraction 1.0
    ior 1.33
    specular 1.0
    roughness 0.001
    fade_distance 5.0
    fade_power 1.0
    caustics 1.0
    irid
    { 0.35 thickness 0.5 turbulence 0.5 }
  }
}

#declare Membrane_Superieure = merge
{
  difference
  {
    sphere
    {
      <0.0, 0.0, 0.0>
      Rayon_Membrane_Superieure
    }
    box
    {
      <-Rayon_Membrane_Superieure-1.0, -Rayon_Membrane_Superieure-1.0, -Rayon_Membrane_Superieure-1.0 >
      <Rayon_Membrane_Superieure+1.0, 0.0, Rayon_Membrane_Superieure+1.0>
    }
    sphere
    {
      <0.0, 0.0, 0.0>
      Rayon_Membrane_Superieure-Epaisseur_Membrane_Superieure
    }
  }
  difference
  {
    torus
    {
      Rayon_Membrane_Superieure-Epaisseur_Membrane_Superieure/2
      Epaisseur_Membrane_Superieure/2
    }
    box
    {
      <-Rayon_Membrane_Superieure-1.0, Rayon_Membrane_Superieure+1.0, -Rayon_Membrane_Superieure-1.0 >
      <Rayon_Membrane_Superieure+1.0, 0.0, Rayon_Membrane_Superieure+1.0>
    }
  }
  hollow
}

#declare Membrane_Inferieure = sor
{
  6
  <4*Rayon_Membrane_Inferieure, 0.0>
  <4*Rayon_Membrane_Inferieure*2.0/3.0, 0.1>
  <4*Rayon_Membrane_Inferieure/3.0, Hauteur_Membrane_Inferieure*4.0/5.0>
  <4*Rayon_Membrane_Inferieure/6.0, Hauteur_Membrane_Inferieure*8.0/9.0>
  <0.1, Hauteur_Membrane_Inferieure-0.1>
  <0.0, Hauteur_Membrane_Inferieure>
  sturm
  hollow
}

#declare Corps_Masse = cone
{
  <0.0, 0.0, 0.0> Rayon_Membrane_Inferieure
  <0.0, -Hauteur_Corps_Masse, 0.0> Largeur_Corps_Extremite
  hollow
  translate (-Ecart_Membranes+Rayon_Membrane_Superieure-Hauteur_Membrane_Inferieure)*y
  //pigment { Red }
  texture { Texture_Meduse }
}

#declare Tete = merge
{
  object { Membrane_Superieure scale <1.0, Ecrase_Membrane_Superieure, 1.0> }
  object { Membrane_Inferieure translate <0.0, -Ecart_Membranes+Rayon_Membrane_Superieure-Hauteur_Membrane_Inferieure, 0.0> }
  //pigment { Red }
  texture { Texture_Meduse }
}

#declare Macaroni = difference
{
  torus
  {
    2.0 0.5
  }
  torus
  {
    2.0 0.4
  }
  box
  {
    <-5.0, -1.0, -5.0>
    <0.0, 1.0, 5.0>
  }
  box
  {
    <-5.0, -1.0, -5.0>
    <0.0, 1.0, 5.0>
    rotate y*45
  }
  //pigment { Red }
  texture { Texture_Meduse }
  hollow
}

#declare Meduse = merge
{
  object { Tete }
  object { Corps_Masse }
  scale 1/60.0
  translate -0.25*y
  translate 0.9*z
  translate -0.4*x
}

/*****************************************************/

#declare Max_Macaroni = 200
#declare Sens = 1
#declare Rrot1 = seed(0)
#declare Rrot2 = seed(1)
#declare Rrot3 = seed(2)
#declare Rtrans1 = seed(3)
#declare Rtrans2 = seed(4)
#declare Rtrans3 = seed(5)
#declare Rscal1 = seed(6)
#declare Rscal2 = seed(7)
#declare Rscal3 = seed(8)
#declare Trans_Type_xz = 0.5
#declare Trans_Type_y = 0.5
#declare Trans_Max_xz = 2.3
#declare Trans_Max_y = 15.0

#declare Count = 0
#while (Count < Max_Macaroni)
  object
  {
    Macaroni
    scale <rand(Rscal1), rand(Rscal2), rand(Rscal3)>
    rotate <rand(Rrot1)*360, rand(Rrot2)*360, rand(Rrot3)*360>
    translate <Sens*Trans_Max_xz*rand(Rtrans1)*Trans_Type_xz, -Trans_Max_y*cos(rand(Rtrans2)*3.14159/2)*Trans_Type_y, Sens*Trans_Max_xz*rand(Rtrans3)*Trans_Type_xz>
    scale <1.5, 2.5, 1.5>
    translate (-Ecart_Membranes+Rayon_Membrane_Superieure-Hauteur_Membrane_Inferieure)*y
    scale 1/60.0
    translate -0.25*y
    translate 0.9*z
    translate -0.4*x
  }
  #declare Count = Count+1
  #declare Sens = -Sens
#end

#declare Count = 0
#while (Count < Max_Macaroni)
  object
  {
    Macaroni
    scale <rand(Rscal1), rand(Rscal2), rand(Rscal3)>
    rotate <rand(Rrot1)*360, rand(Rrot2)*360, rand(Rrot3)*360>
    translate <Sens*Trans_Max_xz*rand(Rtrans1)*Trans_Type_xz, -Trans_Max_y*cos(rand(Rtrans2)*3.14159/2)*Trans_Type_y, Sens*Trans_Max_xz*rand(Rtrans3)*Trans_Type_xz>
    scale <1.5, 2.5, 1.5>
    translate (-Ecart_Membranes+Rayon_Membrane_Superieure-Hauteur_Membrane_Inferieure)*y
    scale 1/60.0
    translate -0.25*y
    translate 0.9*z
    translate -0.4*x
    translate <1.0, 0.0, 1.0>
  }
  #declare Count = Count+1
  #declare Sens = -Sens
#end

#declare N            = 50
#declare Nb_Filaments = 15
#declare D_max        = 0.2
#declare D_min        = 0.02
#declare L_min        = pi
#declare L_max        = 1.5*pi
#declare alpha_lim    = 1.0
#declare beta_lim     = 0.3
#declare gamma_lim    = 0.5
#declare delta_lim    = 0.5
#declare p_alpha_y    = seed(100)
#declare p_alpha_z    = seed(101)
#declare p_beta_y     = seed(102)
#declare p_beta_z     = seed(103)
#declare p_gamma_y    = seed(104)
#declare p_gamma_z    = seed(105)
#declare p_delta_y    = seed(106)
#declare p_delta_z    = seed(107)
#declare p_x_max      = seed(108)

#declare filament     = 0
#while (filament < Nb_Filaments )
  #declare X_max   = L_min+rand(p_x_max)*(L_max-L_min)
  #declare alpha_y = alpha_lim*2*(rand(p_alpha_y)-0.5)
  #declare alpha_z = alpha_lim*2*(rand(p_alpha_z)-0.5)
  #declare beta_y  = beta_lim*rand(p_beta_y)
  #declare beta_z  = beta_lim*rand(p_beta_z)
  #declare gamma_y = beta_lim*rand(p_gamma_y)
  #declare gamma_z = beta_lim*rand(p_gamma_z)
  #declare delta_y = beta_lim*rand(p_delta_y)
  #declare delta_z = beta_lim*rand(p_delta_z)
  #declare iter    = 0
  #while (iter < N)
    #declare x_1   = X_max*iter/N
    #declare x_2   = X_max*(iter+1)/N
    #declare f_1_x = x_1
    #declare f_2_x = x_2
    #declare f_1_y = sin(alpha_y*x_1)*(beta_y+gamma_y*x_1+delta_y*pow(x_1, 2))
    #declare f_2_y = sin(alpha_y*x_2)*(beta_y+gamma_y*x_2+delta_y*pow(x_2, 2))
    #declare f_1_z = sin(alpha_z*x_1)*(beta_z+gamma_z*x_1+delta_z*pow(x_1, 2))
    #declare f_2_z = sin(alpha_z*x_2)*(beta_z+gamma_z*x_2+delta_z*pow(x_2, 2))
    cone
    {
      <f_1_x, f_1_y, f_1_z> D_max+x_1*(D_min-D_max)/X_max
      <f_2_x, f_2_y, f_2_z> D_max+x_2*(D_min-D_max)/X_max
      open
      rotate -90*x
      rotate -90*z
      scale 1/10.0
      translate -0.25*y
      translate 0.9*z
      translate -0.4*x
      //pigment { Red }
      texture { Texture_Filament }
    }
    #declare iter = iter + 1
  #end
  #declare filament = filament +1
#end

#declare filament     = 0
#while (filament < Nb_Filaments )
  #declare X_max   = L_min+rand(p_x_max)*(L_max-L_min)
  #declare alpha_y = alpha_lim*2*(rand(p_alpha_y)-0.5)
  #declare alpha_z = alpha_lim*2*(rand(p_alpha_z)-0.5)
  #declare beta_y  = beta_lim*rand(p_beta_y)
  #declare beta_z  = beta_lim*rand(p_beta_z)
  #declare gamma_y = beta_lim*rand(p_gamma_y)
  #declare gamma_z = beta_lim*rand(p_gamma_z)
  #declare delta_y = beta_lim*rand(p_delta_y)
  #declare delta_z = beta_lim*rand(p_delta_z)
  #declare iter    = 0
  #while (iter < N)
    #declare x_1   = X_max*iter/N
    #declare x_2   = X_max*(iter+1)/N
    #declare f_1_x = x_1
    #declare f_2_x = x_2
    #declare f_1_y = sin(alpha_y*x_1)*(beta_y+gamma_y*x_1+delta_y*pow(x_1, 2))
    #declare f_2_y = sin(alpha_y*x_2)*(beta_y+gamma_y*x_2+delta_y*pow(x_2, 2))
    #declare f_1_z = sin(alpha_z*x_1)*(beta_z+gamma_z*x_1+delta_z*pow(x_1, 2))
    #declare f_2_z = sin(alpha_z*x_2)*(beta_z+gamma_z*x_2+delta_z*pow(x_2, 2))
    cone
    {
      <f_1_x, f_1_y, f_1_z> D_max+x_1*(D_min-D_max)/X_max
      <f_2_x, f_2_y, f_2_z> D_max+x_2*(D_min-D_max)/X_max
      open
      rotate -90*x
      rotate -90*z
      scale 1/10.0
      translate -0.25*y
      translate 0.9*z
      translate -0.4*x
      translate <1.0, 0.0, 1.0>
      //pigment { Red }
      texture { Texture_Filament }
    }
    #declare iter = iter + 1
  #end
  #declare filament = filament +1
#end



/*****************************************************/

object { Meduse }
object { Meduse translate <1.0, 0.0, 1.0> }
object { Fond }
object { Surface }
object { Pont }
object { Barque }
