//
//      GlsMenag.pov
//+
//      The Glass Menagerie
//-
//      rev 02/26/97 gls finalize layout of included pieces
//      rev 02/25/97 gls change positions of ant
//      rev 02/21/97 gls change to illuminate the eagle
//      rev 02/12/97 gls
//
//

#include "colors.inc"
#include "shapes.inc"
#include "textures.inc"

#include "metals.inc"
#include "skies.inc"
#include "glass.inc"

#declare xNoObjLoad=1
#declare xFastRender=1
#declare xFastLoad=1

// //////////////////////////////////////////////////

camera
        {
        location  <45.0, 50.0/2 ,-45>
//        location  <50.0 , 40.0/2 ,-50>
//  location  <20.0/2 , 20.0/2 ,-25.0/3>
        look_at   <0.0 , 0.0-2 , 0.0>

        aperture 0.2*4               // 0...N (bigger is narrower depth of field)
        // blur_samples 4             // # of rays per pixel
        //  focal_point <VECTOR>       // x,y,z point that is in focus
        }

// set viewer's position in the scene
//camera
//{
// (camera types)
//  perspective (default) | orthographic | fisheye |
//  ultra_wide_angle | omnimax | panoramic | cylinder 1
 // location  <0.0, 1.0, -6.0> // position of camera <X Y Z>
 // direction 2.0*z            // which way are we looking <X Y Z> & zoom
//  sky       y                // rarely used
 // up        y                // which way is +up <X Y Z>
//  right     4/3*x            // which way is +right <X Y Z> and aspect ratio
//  look_at   <0.0, 0.0,  0.0> // point center of view at this point <X Y Z>
//  angle FLOAT                // overrides "direction" with specific angle
//  normal { ripples 0.2 }     // perturb the camera lens with a pattern
// (focal blur extras)
//  aperture 0.2               // 0...N (bigger is narrower depth of field)
//  blur_samples 4             // # of rays per pixel
//  focal_point <VECTOR>       // x,y,z point that is in focus
//}



// //////////////////////////////////////////////////

#declare P_Lightning =
pigment {
    marble
    color_map {
        [0.0, 0.01          color rgbt <1.0, 1.0, 1.0, 0.0 >
                            color rgbt <0.94, 0.81, 0.99, 0.65 >]
        [0.01, 0.010001     color rgbt <0.94, 0.81, 0.99, 0.65 >
                            color rgbt <1.0, 1.0, 1.0, 1.00 >]
        [0.010001, 1.0      color rgbt <1.0, 1.0, 1.0, 1.00 >
                            color rgbt <1.0, 1.0, 1.0, 1.00 >]
    }
}

// Create an infinite sphere around scene and allow any texture on it
sky_sphere {
        S_Cloud1
#ifndef (FastRender)
        pigment { P_Lightning turbulence 0.5 scale .5 }
        pigment { P_Lightning turbulence 0.4 scale .7 rotate < 0, -5, 135 > }
        pigment { P_Lightning turbulence 0.45 scale .6 rotate < 0, 4, -140 > }
        pigment { P_Lightning turbulence 0.45 scale .4 rotate < -40, 4, -90 > }
#end
        }


// //////////////////////////////////////////////////

// create a regular point light source
light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <-20, 40, -20>
}
light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <20, 40, -80>
}

// //////////////////////////////////////////////////
//
//      The mirrored table top
// Capped Cylinder, closed [or open ended]
// cylinder { <END1>, <END2>, RADIUS [open] }
//  END1 = coord of one end of cylinder
//  END2 = coord of other end
// RADIUS = size of cylinder
// open = if present, cylinder is hollow, else capped
cylinder
        {
        0*y,  -2/3*y,  (10+2) * 3
#ifndef (FastRender)
        texture { T_Chrome_5E }
#else
        texture { pigment { Red } }
#end
        }


// //////////////////////////////////////////////////
//
//  Now, the signature (Using a TrueType font)...
//
text {
    ttf             // font type (only TrueType format for now)
    "timrom.ttf",   // Microsoft Windows-format TrueType font file name
    "GLS",          // the string to create
    0.5,            // the extrusion depth
    0               // offset
    texture { T_Gold_5E }
    rotate -60 * y      // rotate into view
//    rotate -45 * y      // rotate into view
    scale 4.0
    translate < -10, -20, -40>
}

// //////////////////////////////////////////////////
//
//      Default texture used by the objects
//
#declare F_Gls=
    finish {
        ambient 0.10
        diffuse 0.90
        phong 0.9 phong_size 60
//        phong 0.03 phong_size 1.0
    }

#ifdef (FastRender)
#declare Default= texture {
    finish {
        ambient 0.10
        diffuse 0.90
        phong 0.03
        phong_size 1.0
    }
    pigment { Green }

}
#else

#declare Default = texture {
    T_Dark_Green_Glass finish { F_Gls }
///    pigment { rgb <1.000, 1.000, 1.000> }
}
#end

#if(0)
T_Glass1 =
T_Glass2 =
T_Glass3 =
T_Glass4 =
T_Old_Glass=
T_Winebottle_Glass=
T_Beerbottle_Glass=
T_Ruby_Glass =
T_Green_Glass =
T_Dark_Green_Glass=
T_Yellow_Glass=
T_Orange_Glass=
T_Vicksbottle_Glass
#end

// //////////////////////////////////////////////////
//
//      Now, declare the objects that will be instanced
//      Note: change the default texture for each to use
//              all the colors of glass.
//
#ifndef (NoObjLoad)

#ifndef (FastLoad)

#declare Default = texture { T_Ruby_Glass finish { F_Gls } }
#declare objAnt2 = union { #include "3ds\ant2.inc" }

#declare Default = texture { T_Old_Glass finish { F_Gls } }
#declare objBird = object { #include "3ds\bird.inc" }

#declare Default = texture { T_Beerbottle_Glass finish { F_Gls } }
#declare objBull = object { #include "3ds\bull.inc" }

#declare Default = texture { T_Vicksbottle_Glass finish { F_Gls } }
#declare objCat = object { #include "3ds\cat.inc"  }

#declare Default = texture { T_Green_Glass finish { F_Gls } }
#declare objCoyote = object { #include "3ds\coyote.inc" }

#declare Default = texture { T_Dark_Green_Glass finish { F_Gls } }
#declare objDog = object { #include "3ds\dog.inc" }

#declare Default = texture { T_Yellow_Glass finish { F_Gls } }
#declare objDolphins = object { #include "3ds\dolphins.inc" }

#declare Default = texture { T_Orange_Glass finish { F_Gls } }
#declare objDuck = object { #include "3ds\duck.inc" }

#declare Default = texture { T_Winebottle_Glass finish { F_Gls } }
#declare objEagle = object { #include "3ds\eagle.inc" }

#declare Default = texture { T_Dark_Green_Glass finish { F_Gls } }
#declare objJaws = object { #include "3ds\jaws.inc" }
#else
#declare objAnt2 = box { <0, 0, 0>, <1, 1, 1> texture { pigment {White} } }
#declare objBird = box { <0, 0, 0>, <1, 1, 1> texture { pigment {White} } }
#declare objBull = box { <0, 0, 0>, <1, 1, 1> texture { pigment {White} } }
#declare objCat = box { <0, 0, 0>, <1, 1, 1> texture { pigment {White} } }
#declare objCoyote = box { <0, 0, 0>, <1, 1, 1> texture { pigment {White} } }
#declare objDog = box { <0, 0, 0>, <1, 1, 1> texture { pigment {White} } }
#declare objDolphins = box { <0, 0, 0>, <1, 1, 1> texture { pigment {White} } }
#declare objDuck = box { <0, 0, 0>, <1, 1, 1> texture { pigment {White} } }
#declare objEagle = box { <0, 0, 0>, <1, 1, 1> texture { pigment {White} } }
#declare objJaws = box { <0, 0, 0>, <1, 1, 1> texture { pigment {White} } }
#end

object { objCoyote translate <20, 0, 20> rotate <0, 0, 0> }
//object { objAnt2 translate <20, 0, 20 > rotate <0, 0, 0> }
//object { objJaws translate <20, 0, 20 > rotate <0, 90, 0> }
object { objEagle translate <20, 0, 20> rotate <0, 90, 0> }
object { objBird translate <20, 0, 20 > rotate <0, 180, 0> }
object { objCat translate <20, 0, 20 > rotate <0, 270, 0> }

//object { objCoyote translate <20, 0, 0> rotate <0, 0, 0> }
object { objAnt2 translate <20, 0, 0 > rotate <0, 0, 0> }
object { objDog translate <20, 0, 0> rotate <0, 90, 0> }
object { objDolphins translate <20, 0, 0> rotate <0, 180, 0> }
///object { objEagle translate <20, 0, 0> rotate <0, 270, 0> }
object { objJaws translate <20, 0, 0 > rotate <0, 270, 0> }

object { objBull scale <1.4, 1.4, 1.4> rotate <0, 0, 0> }


// //////////////////////////////////////////////////


#if( 0 )
#declare T_Glass1 =
#declare T_Glass2 =
#declare T_Glass3 =
#declare T_Glass4 =
#declare T_Old_Glass=
#declare T_Winebottle_Glass=
#declare T_Beerbottle_Glass=
#declare T_Ruby_Glass =
#declare T_Green_Glass =
#declare T_Dark_Green_Glass=
#declare T_Yellow_Glass=
#declare T_Orange_Glass=
#declare T_Vicksbottle_Glass=
#end



#declare Default = texture { T_Ruby_Glass }
#declare newDefault = texture { T_Old_Glass }


#declare oldDefault = texture {
    finish {
        ambient 0.10
        diffuse 0.90
        phong 1.00
        phong_size 49.0
    }
    pigment { rgb <1.000, 1.000, 1.000> }
}

#end
// //////////////////////////////////////////////////



// //////////////////////////////////////////////////
// //////////////////////////////////////////////////
// //////////////////////////////////////////////////
