//  Persistance of Vision Raytracer V2.2
//  World definition file.
//
//  Contains 1 lights, 18 textures and 100 primitives.
//
//  This file was generated for POV-Ray V2.2 by
//  MORAY.EXE V2.02.wat(c) 1991-1995 Lutz + Kretzschmar
//

//  Date : 02/19/1997    (19.02.1997)
//

#max_trace_level 5

//
//  This is the standard include file for POV-Ray. It is included with
//  every scene that Moray V2.0 exports for POV-Ray.
//





camera {  //  Camera StdCam
  location  <-38.734, 7.445, 4.983>
  //location  <99, -7.445, 4.983>
  direction <0.0,     0.0,  4.5404>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.3333,  0.0,  0.0>
  look_at   <-0.372, -0.558, 4.656>
  //look_at   <-38.734, 2.445, 4.983>
   aperture 0.15
   //focal_point <-0.029, 2.45, 5.51>
   focal_point <-12.58,0.818,5.768>
   blur_samples 200
   confidence 0.999            // default is 0.9
   variance 1/512             // default is 1/128 (0.0078125)
}

// *******  L I G H T S *******
light_source {   // Light1
  <-7.567, -36.646, 5.636>
  color rgb <0.906, 0.788, 0.612>
}
light_source
 {<-17.567,7,5.636>
  color rgb<0.3,0.3,0.3>
  shadowless}

// ********  TEXTURES  *******
//

#include "tankard.inc"



// ********  REFERENCED OBJECTS  *******

#declare Talt1 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-6.580317, -2.000000, 1.580317>, <-4.000000, -2.000000, 0.000000>, <-3.061922, -2.000000, -2.452680>, <-1.951269, -2.000000, 1.119831>,
      <-5.329233, -1.000000, 1.777857>, <-4.000000, -1.000000, 0.000000>, <-3.000000, -1.000000, 0.000000>, <-2.000000, -1.000000, 0.000000>,
      <-4.539074, 0.000000, 0.329233>, <-4.000000, 0.000000, 0.000000>, <-3.000000, 0.000000, 0.000000>, <-2.000000, 0.000000, 0.000000>,
      <-4.539074, 1.000000, 0.329233>, <-4.000000, 1.000000, 0.000000>, <-3.000000, 1.000000, 0.000000>, <-2.000000, 1.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.951269, -2.000000, 1.119831>, <-0.840616, -2.000000, 4.692342>, <0.347767, -2.000000, -2.597894>, <1.173883, -2.000000, -1.298947>,
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.658466>, <1.000000, -1.000000, 0.329233>,
      <-2.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>,
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <1.000000, 1.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.173883, -2.000000, -1.298947>, <2.000000, -2.000000, 0.000000>, <3.626950, -2.000000, 1.446809>, <5.219569, -2.000000, 2.763740>,
      <1.000000, -1.000000, 0.329233>, <2.000000, -1.000000, 0.000000>, <3.626950, -1.000000, 1.446809>, <4.692797, -1.000000, 2.138197>,
      <1.000000, 0.000000, 0.000000>, <2.000000, 0.000000, 0.000000>, <3.000000, 0.000000, 0.000000>, <4.000000, 0.000000, 0.000000>,
      <1.000000, 1.000000, 0.000000>, <2.000000, 1.000000, 0.000000>, <3.000000, 1.000000, 0.000000>, <4.000000, 1.000000, 0.000000>
    }
  }
  scale <6.675023, 4.536755, 1.6597>
  rotate <79.272179, 0.224739, 93.154884>
  translate  <65.900012, -1.427998, 22.178636>
}
#declare TaltFransar = difference { // TaltFransar
  object { Talt1 }
  box { // TaltCut1
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 2.0, 2.0>
    rotate <-3.286983, -2.049183, 6.071848>
    translate  <68.251882, -29.117131, 13.259589>
  }
  box { // TaltCut2
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 2.0, 2.0>
    rotate <-2.69429, 3.176776, 25.206116>
    translate  <68.628261, -2.203027, 13.5>
  }
  box { // TaltCut3
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 2.0, 2.0>
    rotate <2.158814, -1.135365, 11.862836>
    translate  <68.381885, -11.157193, 13.5>
  }
  box { // TaltCut4
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 2.0, 2.0>
    rotate <2.50663, 0.180795, -1.649144>
    translate  <68.511889, -19.640186, 13.277825>
  }
  box { // TaltCut5
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 2.0, 2.0>
    rotate <0.764901, 0.0, 4.237929>
    translate  <68.628261, 5.796973, 13.5>
  }
  box { // TaltCut6
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 1.796108, 2.0>
    rotate <1.86263, -2.819155, 28.510498>
    translate  <66.16246, 13.739629, 13.5>
  }
  box { // TaltCut7
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 2.0, 2.0>
    rotate <1.791749, -3.114361, 34.791759>
    translate  <66.16246, 21.682285, 13.5>
  }
  texture {
    Gul
  }
}




// ********  OBJECTS  *******

/*sphere
 {<-12.58,0.818,5.768>,1
  pigment{color rgb<1,1,0>}}
*/
plane { // SubPlane
  z,0
  texture {
    Vit
  }
  translate  <-0.402674, 10.40631, 2000091.467>
}


difference{ // GulDorr

  box { // d2
    <-1, -1, -1>, <1, 1, 1>
    scale <1.326424, 13.129799, 19.251249>
    rotate -2.32211*y
    translate  <-39.955743, -5.095314, -4.087164>
  }
  box { // d1
    <-1, -1, -1>, <1, 1, 1>
    scale <6.474091, 11.600473, 13.150945>
    translate  <-39.859461, -5.082756, 0.0>
  }
  texture {
    Gul
  }
}


sphere { // Himmel
  <0,0,0>,1
  texture {
    HimmelTex
    scale <0.996364, 1.0, 1.243663>
  translate <-0.003636, 0.000000, 0.989977>
  }
  scale <35628.402344, 50000.0, 6578.047363>
  translate  <85.031603, 13789.298531, 0.0>
}


difference { // GulaFRANSAR
  object { // TaltFransar1->TaltFransar
    TaltFransar
    texture {
      TaltTex
    }
    translate  -0.001*x
  }
  box { // GulFransCut1
    <-1, -1, -1>, <1, 1, 1>
    scale <4.851681, 2.750426, 2.67662>
    rotate <-3.936921, -1.687664, 6.341415>
    translate  <67.855424, -29.063967, 13.250588>
  }
  box { // GulFransCut2
    <-1, -1, -1>, <1, 1, 1>
    scale <4.851681, 2.750426, 2.67662>
    rotate <2.585017, -0.181057, -1.968543>
    translate  <68.330925, -19.666498, 13.166982>
  }
  box { // GulFransCut3
    <-1, -1, -1>, <1, 1, 1>
    scale <4.851681, 2.750426, 2.67662>
    rotate <2.563148, -0.195493, 12.136709>
    translate  <68.375544, -11.095575, 13.318438>
  }
  box { // GulFransCut4
    <-1, -1, -1>, <1, 1, 1>
    scale <4.851681, 2.750426, 2.67662>
    rotate <-5.655151, 2.2481, 25.088524>
    translate  <67.840121, -2.594529, 13.445031>
  }
  box { // GulFransCut5
    <-1, -1, -1>, <1, 1, 1>
    scale <4.851681, 2.750426, 2.67662>
    rotate <0.051818, 0.090542, 4.646594>
    translate  <67.617028, 5.799031, 13.305908>
  }
  box { // GulFransCut6
    <-1, -1, -1>, <1, 1, 1>
    scale <4.851681, 2.750426, 2.67662>
    rotate <2.987896, -2.684486, 28.241371>
    translate  <66.055378, 13.741139, 13.375469>
  }
  box { // GulFransCut7
    <-1, -1, -1>, <1, 1, 1>
    scale <6.301516, 2.735299, 2.609286>
    rotate <2.842412, -2.685368, 35.159763>
    translate  <66.099312, 21.693491, 13.375469>
  }
  box { // GulFransCUT1
    <-1, -1, -1>, <1, 1, 1>
    scale <2.686267, 3.688142, 0.801044>
    rotate <1.25818, -9.756778, -7.760725>
    translate  <67.185641, -24.616071, 12.948528>
  }
  box { // GulFransCUT2
    <-1, -1, -1>, <1, 1, 1>
    scale <3.856563, 2.406531, 1.094763>
    rotate <7.03937, -0.273208, 1.159665>
    translate  <67.944753, -15.637391, 13.041553>
  }
  box { // GulFransCUT3
    <-1, -1, -1>, <1, 1, 1>
    scale <3.856563, 2.406531, 1.094763>
    rotate <-3.904646, 1.720336, 15.271377>
    translate  <67.875572, -6.907573, 13.434822>
  }
  box { // GulFransCUT4
    <-1, -1, -1>, <1, 1, 1>
    scale <3.856563, 2.406531, 1.094763>
    rotate <-5.7358, 2.616122, 13.671821>
    translate  <65.806976, 1.083759, 12.779301>
  }
  box { // GulFransCUT5
    <-1, -1, -1>, <1, 1, 1>
    scale <3.856563, 2.406531, 1.094763>
    rotate <4.659925, 0.211607, 1.762076>
    translate  <65.548401, 9.142664, 13.047483>
  }
  box { // GulFransCUT6
    <-1, -1, -1>, <1, 1, 1>
    scale <3.856563, 2.406531, 1.094763>
    rotate <3.427319, -1.273582, 0.257543>
    translate  <65.591497, 17.804909, 13.047483>
  }
  box { // GulFransCUT7
    <-1, -1, -1>, <1, 1, 1>
    scale <0.910749, 9.110614, 1.310393>
    rotate <-2.593969, 0.992557, 15.786811>
    translate  <70.581363, -37.694038, 13.186092>
  }
  box { // GulFransCUT8
    <-1, -1, -1>, <1, 1, 1>
    scale <4.286506, 5.463582, 1.203712>
    rotate <3.406337, 0.376759, 0.398226>
    translate  <66.474125, 28.788388, 13.365415>
  }
  texture {
    TaltTex
  }
  translate  <-0.01, 0.0, 0.0>
}


sphere { // Sol
  <0,0,0>,1
  texture {
    SolTex
  }
  no_shadow
  translate  <-7.550404, -36.699153, 5.649427>
}


box { // TaltBakgrund
  <-1, -1, -1>, <1, 1, 1>
  texture {
    TaltTex
  }
  scale <64.268196, 45.482033, 1.912986>
  rotate -37.713169*y
  translate  <-84.776397, -0.729214, -5.401402>
}


object { // Kulle
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.814593, -1.881729, 0.000000>, <-0.991962, -1.991962, 0.000000>, <-0.400667, -1.991962, 0.000000>, <-0.226114, -2.000000, 0.000000>,
      <-2.718046, -0.989283, 0.000000>, <-0.991962, -1.000000, 1.679905>, <0.008038, -1.000000, 1.679905>, <1.000000, -1.000000, 0.000000>,
      <-0.663767, -0.010794, 0.000000>, <-0.497214, 0.000000, 1.679905>, <0.008038, 0.000000, 1.679905>, <1.000000, -0.064532, 0.000000>,
      <-2.718046, 1.010717, 0.000000>, <-0.991962, 1.000000, 1.679905>, <0.008038, 1.000000, 1.679905>, <1.000000, 1.000000, 0.000000>
    }
  }
  texture {
    MarkTex
  }
  scale 424.160889
  rotate 37.275181*z
  translate  <7476.782214, -6.066047, -282.501208>
}


sphere { // Mark2
  <0,0,0>,1
  texture {
    MarkTex
  }
  scale <1611.024048, 873.229431, 241.263321>
  translate  <6.322719, 0.0, -257.08626>
}


object { TaltFransar }


difference { // Taltvagg
  box { // Talt
    <-1, -1, -1>, <1, 1, 1>
    scale <0.549676, 43.621712, 34.060593>
    rotate -1.995378*y
    translate  <-39.949239, 0.0, 0.617825>
  }
  box { // Taltdorr
    <-1, -1, -1>, <1, 1, 1>
    scale <6.579333, 11.655428, 16.404339>
    translate  <-39.952677, -5.114605, -3.117792>
  }
  texture {
    TaltTex
  }
}


plane { // Mark
  z,0
  texture {
    MarkTex
  }
  scale <7362.584473, 2159.571533, 0.00001>
  rotate <-0.197811, 1.204955, -9.32348>
  translate  -150.0*z
}


#declare Kolet = intersection {
  sphere { // Kol
    <0,0,0>,1
    scale <48.084496, 10.954715, 4.210747>
    translate  <95.908209, 123.151279, -1.472053>
  }
  box { // CutKol
    <-1, -1, -1>, <1, 1, 1>
    scale <66.661179, 14.661819, 2.44888>
    translate  <96.737457, 123.236807, -3.819774>
  }
  texture {
    DMFWood3
  }
}
union { // Skepp
  object { Kolet }
  cylinder { // Skold1
    <0,0,1>, <0,0,0>, 1
    texture {
      TaltTex
    }
    scale <1.5, 1.5, 0.5>
    rotate <-90.0, 0.0, -12.609324>
    translate  <63.583963, 113.800728, -1.484186>
  }
  cylinder { // Skold2
    <0,0,1>, <0,0,0>, 1
    texture {
      TaltTex
    }
    scale <1.5, 1.5, 0.5>
    rotate <-90.0, 0.0, -8.718186>
    translate  <70.179175, 112.871294, -1.484186>
  }
  cylinder { // Skold3
    <0,0,1>, <0,0,0>, 1
    texture {
      TaltTex
    }
    scale <1.5, 1.5, 0.5>
    rotate <-90.0, 0.0, 16.473604>
    translate  <132.2284, 115.272258, -1.484186>
  }
  cylinder { // Skold4
    <0,0,1>, <0,0,0>, 1
    texture {
      TaltTex
    }
    scale <1.5, 1.5, 0.5>
    rotate <-90.0, 0.0, 13.616764>
    translate  <124.559826, 113.441327, -1.484186>
  }
  cylinder { // Skold5
    <0,0,1>, <0,0,0>, 1
    texture {
      TaltTex
    }
    scale <1.5, 1.5, 0.5>
    rotate -90.0*x
    translate  <114.952565, 112.472011, -1.484186>
  }
  cylinder { // Skold6
    <0,0,1>, <0,0,0>, 1
    texture {
      TaltTex
    }
    scale <1.5, 1.5, 0.5>
    rotate -90.0*x
    translate  <107.499394, 111.610397, -1.484186>
  }
  cylinder { // Skold7
    <0,0,1>, <0,0,0>, 1
    texture {
      TaltTex
    }
    scale <1.5, 1.5, 0.5>
    rotate -90.0*x
    translate  <98.053713, 111.071888, -1.484186>
  }
  cylinder { // Skold8
    <0,0,1>, <0,0,0>, 1
    texture {
      TaltTex
    }
    scale <1.5, 1.5, 0.5>
    rotate -90.0*x
    translate  <89.577348, 111.610397, -1.484186>
  }
  cylinder { // Skold9
    <0,0,1>, <0,0,0>, 1
    texture {
      TaltTex
    }
    scale <1.5, 1.5, 0.5>
    rotate -90.0*x
    translate  <82.630392, 112.36431, -1.688825>
  }
  cylinder { // Skold10
    <0,0,1>, <0,0,0>, 1
    texture {
      TaltTex
    }
    scale <1.5, 1.5, 0.5>
    rotate -90.0*x
    translate  <76.717395, 112.687415, -1.688825>
  }
  cylinder { // Mast1
    <0,0,1>, <0,0,0>, 1
    texture {
      DMFWood3
    }
    scale <0.5, 0.5, 17.098972>
    translate  <98.241148, 123.288707, -4.087177>
  }
  cylinder { // Mast2
    <0,0,1>, <0,0,0>, 1
    texture {
      DMFWood3
    }
    scale <0.2, 0.2, 20.0>
    rotate <-106.597977, 0.0, 0.0>
    translate  <97.835322, 114.311496, 12.267587>
  }
  cylinder { // FramHals
    <0,0,1>, <0,0,0>, 1
    texture {
      DMFWood3
    }
    scale <0.604217, 1.0, 4.166264>
    rotate <0.0, -15.703232, 0.0>
    translate  <49.913244, 123.172708, -1.583132>
  }
  sphere { // Huvud
    <0,0,0>,1
    texture {
      DMFWood3
    }
    scale <2.583132, 1.0, 1.197891>
    translate  <47.410473, 123.214541, 2.869426>
  }
  cylinder { // BakStav
    <0,0,1>, <0,0,0>, 1
    texture {
      DMFWood3
    }
    scale <0.4, 0.4, 7.530418>
    rotate 47.291115*y
    translate  <142.161167, 123.214541, -1.38524>
  }
  scale 7.0
  rotate -39.985191*z
  translate  <5861.01446, -1534.554228, -258.39505>
}


/*box { // Log6
  <-1, -1, -1>, <1, 1, 1>
  texture {
    EMBWood2
    rotate 9.750316*z
  }
  scale <16.0, 2.0, 1.0>
  translate  <0.042581, -12.157673, 1.098577>
} */


box { // Talttak
  <-1, -1, -1>, <1, 1, 1>
  texture {
    TaltTex
  }
  scale <55.491116, 39.12796, 0.319969>
  translate  <13.835098, -4.409497, 25.243056>
}


cylinder { // TaltPinne2
  <0,0,1>, <0,0,0>, 1
  texture {
    EMBWood2
  }
  scale <1.0, 1.0, 49.678139>
  rotate <1.569243, 0.685869, 0.462018>
  translate  <60.548917, -31.530617, -20.904301>
}


cylinder { // TaltPinne1
  <0,0,1>, <0,0,0>, 1
  texture {
    DMFWood3
  }
  scale <1.0, 1.0, 50.815502>
  rotate <-0.833246, 0.548147, -0.658061>
  translate  <60.47622, 23.790329, -20.895113>
}


plane { // Hav
  z,0
  texture {
    Water1
  }
  scale <8729.116211, 2316.696289, 188.3974>
  translate  <0.624577, 0.0, -288.640956>
}


/*box { // Log5
  <-1, -1, -1>, <1, 1, 1>
  texture {
    EMBWood2
    rotate 22.224487*z
  translate <0.000000, 0.027933, -0.893862>
  }
  scale <16.0, 2.0, 1.0>
  translate  <0.042581, 8.49174, 1.070315>
}


box { // Log4
  <-1, -1, -1>, <1, 1, 1>
  texture {
    EMBWood2
    rotate -14.472519*z
  translate <-0.037172, 0.098349, 0.782130>
  }
  scale <16.0, 2.0, 1.0>
  translate  <0.042581, 4.389725, 1.098577>
}


box { // Log3
  <-1, -1, -1>, <1, 1, 1>
  texture {
    EMBWood2
    rotate 100.100952*z
  }
  scale <16.0, 2.0, 1.0>
  translate  <0.042581, -8.027397, 1.098577>
}


box { // Log2
  <-1, -1, -1>, <1, 1, 1>
  texture {
    EMBWood2
    rotate -28.247715*z
  translate <-0.541263, -0.246632, -0.502798>
  }
  scale <16.0, 2.0, 1.0>
  translate  <0.042581, -3.864041, 1.098577>
}


box { // Log1
  <-1, -1, -1>, <1, 1, 1>
  texture {
    EMBWood2
  translate <-0.444668, 0.021549, 0.000000>
  }
  scale <16.0, 2.0, 1.0>
  translate  <0.042581, 0.254362, 1.098577>
}
  */

//
// Include file contains 'Propp'
//
#include "tankard.in1"
object {   // Propp
  Propp_Raw
  texture {
    //Brown_Agate1
    Glass2
    scale <1.041974, 1.168779, 1.993747>
  translate <0.006384, 0.002245, -1.143751>
  }
  scale <2.165114, 2.017714, 1.6>
  rotate <-131.941513, -86.566536, 176.320663>
  translate  <7.113987, 2.486099, 2.639857>
}


//
// Include file contains 'Karaff'
//
#include "tankard.in2"
#declare Karaff = object {
  Karaff_Raw
  texture {
    //Brown_Agate1
    Glass1
  }
  scale 2.0
  translate  <5.756503, -1.946979, 5.303242>
}
//
// Include file contains 'MJOD'
//
#include "tankard.in3"
#declare MJOD = object {
  MJOD_Raw
  texture {
    Mjod
  }
  scale 1.9
  translate  <9.490503, -4.356053, 5.303242>
}
#declare MMjodM = intersection {
  object { MJOD }
  plane { // MCut
    z,0
    translate  <9.490202, -4.37016, 4.018328>
  }
  texture {
    //Brown_Agate1
    Mjod
  }
  translate  <-3.734032, 2.409053, 0.0>
}
union { // Karaffen
  object { Karaff }
  object { MMjodM }
  translate  <5.019446, 6.467055, 0.0>
}


#declare Tankard = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.340533, -1.441171, 9.749005>, <1.327787, -1.443028, 9.716931>, <1.395947, -1.451646, 9.716931>, <1.408693, -1.449789, 9.749005>,
      <0.298582, -0.967999, 7.720560>, <0.550316, -1.042338, 9.646064>, <1.608343, -1.237229, 9.646064>, <1.608343, -1.097927, 7.720560>,
      <-0.328044, -0.257719, 7.872247>, <0.046848, -0.778226, 9.240369>, <1.608343, -0.843190, 9.240369>, <1.395860, -0.290201, 7.872247>,
      <-0.449089, 0.094674, 8.276458>, <-0.195242, -0.597663, 9.280191>, <1.528662, -0.630145, 9.280191>, <1.356020, 0.078433, 8.276458>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.408693, -1.449789, 9.749005>, <1.421439, -1.447933, 9.781078>, <1.353279, -1.439314, 9.781078>, <1.340533, -1.441171, 9.749005>,
      <1.608343, -1.097927, 7.720560>, <1.608343, -0.958624, 5.795055>, <0.046848, -0.893660, 5.795055>, <0.298582, -0.967999, 7.720560>,
      <1.395860, -0.290201, 7.872247>, <1.183378, 0.262789, 6.504125>, <-0.702936, 0.262789, 6.504125>, <-0.328044, -0.257719, 7.872247>,
      <1.356020, 0.078433, 8.276458>, <1.183378, 0.787010, 7.272724>, <-0.702936, 0.787010, 7.272724>, <-0.449089, 0.094674, 8.276458>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.449089, 0.094674, 8.276458>, <-0.195242, -0.597663, 9.280191>, <1.528662, -0.630145, 9.280191>, <1.356020, 0.078433, 8.276458>,
      <-0.570134, 0.447066, 8.680668>, <-0.437332, -0.417099, 9.320013>, <1.448981, -0.417099, 9.320013>, <1.316179, 0.447066, 8.680668>,
      <-0.759779, 0.847384, 9.905846>, <-0.702936, -0.152616, 9.905846>, <1.183378, -0.152616, 9.905846>, <1.183378, 0.847384, 9.905846>,
      <-0.879890, 1.234214, 11.929385>, <-0.851468, 0.195100, 11.929385>, <1.091689, 0.195100, 11.929385>, <1.091689, 1.234214, 11.929385>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.356020, 0.078433, 8.276458>, <1.183378, 0.787010, 7.272724>, <-0.702936, 0.787010, 7.272724>, <-0.449089, 0.094674, 8.276458>,
      <1.316179, 0.447066, 8.680668>, <1.183378, 1.311232, 8.041323>, <-0.702936, 1.311232, 8.041323>, <-0.570134, 0.447066, 8.680668>,
      <1.183378, 0.847384, 9.905846>, <1.183378, 1.847384, 9.905846>, <-0.816622, 1.847384, 9.905846>, <-0.759779, 0.847384, 9.905846>,
      <1.091689, 1.234214, 11.929385>, <1.091689, 2.273328, 11.929385>, <-0.908311, 2.273328, 11.929385>, <-0.879890, 1.234214, 11.929385>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.879890, 1.234214, 11.929385>, <-0.851468, 0.195100, 11.929385>, <1.091689, 0.195100, 11.929385>, <1.091689, 1.234214, 11.929385>,
      <-1.000000, 1.621044, 13.952923>, <-1.000000, 0.542815, 13.952923>, <1.000000, 0.542815, 13.952923>, <1.000000, 1.621044, 13.952923>,
      <-1.000000, 1.723954, 15.853908>, <-1.000000, 0.569126, 15.884873>, <1.000000, 0.569126, 15.884873>, <1.000000, 1.723954, 15.853908>,
      <-1.019920, 1.825231, 17.853908>, <-1.000000, 0.663763, 17.884873>, <1.000000, 0.663763, 17.884873>, <0.980080, 1.825231, 17.853908>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.091689, 1.234214, 11.929385>, <1.091689, 2.273328, 11.929385>, <-0.908311, 2.273328, 11.929385>, <-0.879890, 1.234214, 11.929385>,
      <1.000000, 1.621044, 13.952923>, <1.000000, 2.699273, 13.952923>, <-1.000000, 2.699273, 13.952923>, <-1.000000, 1.621044, 13.952923>,
      <1.000000, 1.723954, 15.853908>, <1.000000, 2.878783, 15.822942>, <-1.000000, 2.878783, 15.822942>, <-1.000000, 1.723954, 15.853908>,
      <0.980080, 1.825231, 17.853908>, <0.960159, 2.986700, 17.822942>, <-1.039841, 2.986700, 17.822942>, <-1.019920, 1.825231, 17.853908>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.019920, 1.825231, 17.853908>, <-1.000000, 0.663763, 17.884873>, <1.000000, 0.663763, 17.884873>, <0.980080, 1.825231, 17.853908>,
      <-1.039841, 1.926508, 19.853908>, <-1.000000, 0.758400, 19.884873>, <1.000000, 0.758400, 19.884873>, <0.960159, 1.926508, 19.853908>,
      <-1.205749, 1.742554, 21.791469>, <-1.192469, 0.711317, 21.822435>, <1.192469, 0.711317, 21.822435>, <1.179188, 1.742554, 21.791469>,
      <-1.076973, 1.568406, 22.769135>, <-0.977475, 0.131414, 22.633456>, <1.212351, 0.130804, 22.634457>, <1.204542, 1.566910, 22.770137>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.980080, 1.825231, 17.853908>, <0.960159, 2.986700, 17.822942>, <-1.039841, 2.986700, 17.822942>, <-1.019920, 1.825231, 17.853908>,
      <0.960159, 1.926508, 19.853908>, <0.920319, 3.094617, 19.822942>, <-1.079681, 3.094617, 19.822942>, <-1.039841, 1.926508, 19.853908>,
      <1.179188, 1.742554, 21.791469>, <1.165908, 2.773791, 21.760503>, <-1.219029, 2.773791, 21.760503>, <-1.205749, 1.742554, 21.791469>,
      <1.204542, 1.566910, 22.770137>, <1.196733, 3.003017, 22.905817>, <-1.176471, 3.005398, 22.904813>, <-1.076973, 1.568406, 22.769135>
    }
  }
  texture {
    //Brown_Agate1
    Glass1
  }
  scale <1.0, 1.333333, 0.3>
}
#declare MTankardM = difference {
  object { Tankard }
  plane { // CutTank
    z,0
    rotate <177.113083, 0.0, 8.112519>
    translate  <0.0, 2.389418, 5.715229>
  }
  texture {
    Glass1
  }
}
#declare Tankard2 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.340533, -1.441171, 9.749005>, <1.327787, -1.443028, 9.716931>, <1.395947, -1.451646, 9.716931>, <1.408693, -1.449789, 9.749005>,
      <0.298582, -0.967999, 7.720560>, <0.550316, -1.042338, 9.646064>, <1.608343, -1.237229, 9.646064>, <1.608343, -1.097927, 7.720560>,
      <-0.328044, -0.257719, 7.872247>, <0.046848, -0.778226, 9.240369>, <1.608343, -0.843190, 9.240369>, <1.395860, -0.290201, 7.872247>,
      <-0.449089, 0.094674, 8.276458>, <-0.195242, -0.597663, 9.280191>, <1.528662, -0.630145, 9.280191>, <1.356020, 0.078433, 8.276458>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.408693, -1.449789, 9.749005>, <1.421439, -1.447933, 9.781078>, <1.353279, -1.439314, 9.781078>, <1.340533, -1.441171, 9.749005>,
      <1.608343, -1.097927, 7.720560>, <1.608343, -0.958624, 5.795055>, <0.046848, -0.893660, 5.795055>, <0.298582, -0.967999, 7.720560>,
      <1.395860, -0.290201, 7.872247>, <1.183378, 0.262789, 6.504125>, <-0.702936, 0.262789, 6.504125>, <-0.328044, -0.257719, 7.872247>,
      <1.356020, 0.078433, 8.276458>, <1.183378, 0.787010, 7.272724>, <-0.702936, 0.787010, 7.272724>, <-0.449089, 0.094674, 8.276458>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.449089, 0.094674, 8.276458>, <-0.195242, -0.597663, 9.280191>, <1.528662, -0.630145, 9.280191>, <1.356020, 0.078433, 8.276458>,
      <-0.570134, 0.447066, 8.680668>, <-0.437332, -0.417099, 9.320013>, <1.448981, -0.417099, 9.320013>, <1.316179, 0.447066, 8.680668>,
      <-0.759779, 0.847384, 9.905846>, <-0.702936, -0.152616, 9.905846>, <1.183378, -0.152616, 9.905846>, <1.183378, 0.847384, 9.905846>,
      <-0.879890, 1.226699, 11.929385>, <-0.851468, 0.180070, 11.929385>, <1.091689, 0.180070, 11.929385>, <1.091689, 1.226699, 11.929385>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.356020, 0.078433, 8.276458>, <1.183378, 0.787010, 7.272724>, <-0.702936, 0.787010, 7.272724>, <-0.449089, 0.094674, 8.276458>,
      <1.316179, 0.447066, 8.680668>, <1.183378, 1.311232, 8.041323>, <-0.702936, 1.311232, 8.041323>, <-0.570134, 0.447066, 8.680668>,
      <1.183378, 0.847384, 9.905846>, <1.183378, 1.847384, 9.905846>, <-0.816622, 1.847384, 9.905846>, <-0.759779, 0.847384, 9.905846>,
      <1.091689, 1.226699, 11.929385>, <1.091689, 2.273328, 11.929385>, <-0.908311, 2.273328, 11.929385>, <-0.879890, 1.226699, 11.929385>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.879890, 1.226699, 11.929385>, <-0.851468, 0.180070, 11.929385>, <1.091689, 0.180070, 11.929385>, <1.091689, 1.226699, 11.929385>,
      <-1.000000, 1.606015, 13.952923>, <-1.000000, 0.512756, 13.952923>, <1.000000, 0.512756, 13.952923>, <1.000000, 1.606015, 13.952923>,
      <-1.000000, 1.683454, 15.853908>, <-1.000000, 0.488126, 15.884873>, <1.000000, 0.488126, 15.884873>, <1.000000, 1.683454, 15.853908>,
      <-1.019920, 1.786854, 17.853908>, <-1.000000, 0.582763, 17.884873>, <1.000000, 0.582763, 17.884873>, <0.980080, 1.786854, 17.853908>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.091689, 1.226699, 11.929385>, <1.091689, 2.273328, 11.929385>, <-0.908311, 2.273328, 11.929385>, <-0.879890, 1.226699, 11.929385>,
      <1.000000, 1.606015, 13.952923>, <1.000000, 2.699273, 13.952923>, <-1.000000, 2.699273, 13.952923>, <-1.000000, 1.606015, 13.952923>,
      <1.000000, 1.683454, 15.853908>, <1.000000, 2.878783, 15.822942>, <-1.000000, 2.878783, 15.822942>, <-1.000000, 1.683454, 15.853908>,
      <0.980080, 1.786854, 17.853908>, <0.960159, 2.986700, 17.822942>, <-1.039841, 2.986700, 17.822942>, <-1.019920, 1.786854, 17.853908>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.019920, 1.786854, 17.853908>, <-1.000000, 0.582763, 17.884873>, <1.000000, 0.582763, 17.884873>, <0.980080, 1.786854, 17.853908>,
      <-1.039841, 1.886008, 19.853908>, <-1.000000, 0.677400, 19.884873>, <1.000000, 0.677400, 19.884873>, <0.960159, 1.886008, 19.853908>,
      <-1.205749, 1.727525, 21.791469>, <-1.192469, 0.681259, 21.822435>, <1.192469, 0.681259, 21.822435>, <1.179188, 1.727525, 21.791469>,
      <-1.076973, 1.568406, 22.769135>, <-0.977475, 0.131414, 22.633456>, <1.212351, 0.130804, 22.634457>, <1.204542, 1.566910, 22.770137>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.980080, 1.786854, 17.853908>, <0.960159, 2.986700, 17.822942>, <-1.039841, 2.986700, 17.822942>, <-1.019920, 1.786854, 17.853908>,
      <0.960159, 1.886008, 19.853908>, <0.920319, 3.094617, 19.822942>, <-1.079681, 3.094617, 19.822942>, <-1.039841, 1.886008, 19.853908>,
      <1.179188, 1.727525, 21.791469>, <1.165908, 2.773791, 21.760503>, <-1.219029, 2.773791, 21.760503>, <-1.205749, 1.727525, 21.791469>,
      <1.204542, 1.566910, 22.770137>, <1.196733, 3.003017, 22.905817>, <-1.176471, 3.005398, 22.904813>, <-1.076973, 1.568406, 22.769135>
    }
  }
  scale <1.05, 1.4, 0.315>
  translate  <0.0, 0.0, -0.110631>
}
#declare MittKoppardel = intersection {
  object { Tankard2 }
  box { // CutTank2
    <-1, -1, -1>, <1, 1, 1>
    scale <1.718551, 1.43035, 0.912202>
    rotate <-50.0, -0.15, 13.0>
    translate  <0.256393, 0.887713, 3.099785>
  }
  texture {
    Copper_Metal1
  }
}
#declare Tankard1 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.340533, -1.468567, 9.962683>, <1.327787, -1.470424, 9.930610>, <1.395947, -1.479042, 9.930610>, <1.408693, -1.477185, 9.962683>,
      <0.298582, -0.967999, 7.720560>, <0.550316, -1.042338, 9.646064>, <1.608343, -1.237229, 9.646064>, <1.608343, -1.097927, 7.720560>,
      <-0.328044, -0.257719, 7.872247>, <0.046848, -0.778226, 9.240369>, <1.608343, -0.843190, 9.240369>, <1.395860, -0.290201, 7.872247>,
      <-0.449089, 0.094674, 8.276458>, <-0.195242, -0.597663, 9.280191>, <1.528662, -0.630145, 9.280191>, <1.356020, 0.078433, 8.276458>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.408693, -1.477185, 9.962683>, <1.421439, -1.475329, 9.994756>, <1.353279, -1.466710, 9.994756>, <1.340533, -1.468567, 9.962683>,
      <1.608343, -1.097927, 7.720560>, <1.608343, -0.958624, 5.795055>, <0.046848, -0.893660, 5.795055>, <0.298582, -0.967999, 7.720560>,
      <1.395860, -0.290201, 7.872247>, <1.183378, 0.262789, 6.504125>, <-0.702936, 0.262789, 6.504125>, <-0.328044, -0.257719, 7.872247>,
      <1.356020, 0.078433, 8.276458>, <1.183378, 0.787010, 7.272724>, <-0.702936, 0.787010, 7.272724>, <-0.449089, 0.094674, 8.276458>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.449089, 0.094674, 8.276458>, <-0.195242, -0.597663, 9.280191>, <1.528662, -0.630145, 9.280191>, <1.356020, 0.078433, 8.276458>,
      <-0.570134, 0.447066, 8.680668>, <-0.437332, -0.417099, 9.320013>, <1.448981, -0.417099, 9.320013>, <1.316179, 0.447066, 8.680668>,
      <-0.759779, 0.847384, 9.905846>, <-0.702936, -0.152616, 9.905846>, <1.183378, -0.152616, 9.905846>, <1.183378, 0.847384, 9.905846>,
      <-0.879890, 1.234214, 11.929385>, <-0.851468, 0.195100, 11.929385>, <1.091689, 0.195100, 11.929385>, <1.091689, 1.234214, 11.929385>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.356020, 0.078433, 8.276458>, <1.183378, 0.787010, 7.272724>, <-0.702936, 0.787010, 7.272724>, <-0.449089, 0.094674, 8.276458>,
      <1.316179, 0.447066, 8.680668>, <1.183378, 1.311232, 8.041323>, <-0.702936, 1.311232, 8.041323>, <-0.570134, 0.447066, 8.680668>,
      <1.183378, 0.847384, 9.905846>, <1.183378, 1.847384, 9.905846>, <-0.816622, 1.847384, 9.905846>, <-0.759779, 0.847384, 9.905846>,
      <1.091689, 1.234214, 11.929385>, <1.091689, 2.273328, 11.929385>, <-0.908311, 2.273328, 11.929385>, <-0.879890, 1.234214, 11.929385>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.879890, 1.234214, 11.929385>, <-0.851468, 0.195100, 11.929385>, <1.091689, 0.195100, 11.929385>, <1.091689, 1.234214, 11.929385>,
      <-1.000000, 1.621044, 13.952923>, <-1.000000, 0.542815, 13.952923>, <1.000000, 0.542815, 13.952923>, <1.000000, 1.621044, 13.952923>,
      <-1.000000, 1.723954, 15.853908>, <-1.000000, 0.569126, 15.884873>, <1.000000, 0.569126, 15.884873>, <1.000000, 1.723954, 15.853908>,
      <-1.019920, 1.825231, 17.853908>, <-1.000000, 0.663763, 17.884873>, <1.000000, 0.663763, 17.884873>, <0.980080, 1.825231, 17.853908>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.091689, 1.234214, 11.929385>, <1.091689, 2.273328, 11.929385>, <-0.908311, 2.273328, 11.929385>, <-0.879890, 1.234214, 11.929385>,
      <1.000000, 1.621044, 13.952923>, <1.000000, 2.699273, 13.952923>, <-1.000000, 2.699273, 13.952923>, <-1.000000, 1.621044, 13.952923>,
      <1.000000, 1.723954, 15.853908>, <1.000000, 2.878783, 15.822942>, <-1.000000, 2.878783, 15.822942>, <-1.000000, 1.723954, 15.853908>,
      <0.980080, 1.825231, 17.853908>, <0.960159, 2.986700, 17.822942>, <-1.039841, 2.986700, 17.822942>, <-1.019920, 1.825231, 17.853908>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.019920, 1.825231, 17.853908>, <-1.000000, 0.663763, 17.884873>, <1.000000, 0.663763, 17.884873>, <0.980080, 1.825231, 17.853908>,
      <-1.039841, 1.926508, 19.853908>, <-1.000000, 0.758400, 19.884873>, <1.000000, 0.758400, 19.884873>, <0.960159, 1.926508, 19.853908>,
      <-1.205749, 1.742554, 21.791469>, <-1.192469, 0.711317, 21.822435>, <1.192469, 0.711317, 21.822435>, <1.179188, 1.742554, 21.791469>,
      <-1.076973, 1.568406, 22.769135>, <-0.977475, 0.131414, 22.633456>, <1.212351, 0.130804, 22.634457>, <1.204542, 1.566910, 22.770137>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.980080, 1.825231, 17.853908>, <0.960159, 2.986700, 17.822942>, <-1.039841, 2.986700, 17.822942>, <-1.019920, 1.825231, 17.853908>,
      <0.960159, 1.926508, 19.853908>, <0.920319, 3.094617, 19.822942>, <-1.079681, 3.094617, 19.822942>, <-1.039841, 1.926508, 19.853908>,
      <1.179188, 1.742554, 21.791469>, <1.165908, 2.773791, 21.760503>, <-1.219029, 2.773791, 21.760503>, <-1.205749, 1.742554, 21.791469>,
      <1.204542, 1.566910, 22.770137>, <1.196733, 3.003017, 22.905817>, <-1.176471, 3.005398, 22.904813>, <-1.076973, 1.568406, 22.769135>
    }
  }
  scale <1.05, 1.4, 0.315>
  translate  <0.0, 0.004036, -0.112649>
}
#declare Spets = intersection {
  object { Tankard1 }
  plane { // CutTankSpets
    z,0
    rotate <-83.0, -7.0, 15.0>
    translate  <0.677471, -0.860791, 2.599997>
  }
  texture {
    Copper_Metal1
  }
}
#declare Ben1 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.235669, -2.760970, 0.013150>, <-0.235669, -2.995979, 0.003948>, <0.235669, -2.995979, 0.003948>, <0.235669, -2.760970, 0.013150>,
      <-0.578667, 0.000000, 2.000000>, <-0.578667, -0.541401, 2.000000>, <0.578667, -0.541401, 2.000000>, <0.578667, 0.000000, 2.000000>,
      <-0.843137, 0.000000, 4.000000>, <-0.843137, -0.815029, 4.000000>, <0.843137, -0.815029, 4.000000>, <0.843137, 0.000000, 4.000000>,
      <-1.000000, 0.948093, 6.421632>, <-1.000000, -0.528448, 7.436091>, <1.000000, -0.528448, 7.436091>, <1.000000, 0.948093, 6.421632>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.235669, -2.760970, 0.013150>, <0.235669, -2.525961, 0.022353>, <-0.235669, -2.525961, 0.022353>, <-0.235669, -2.760970, 0.013150>,
      <0.578667, 0.000000, 2.000000>, <0.578667, 0.541401, 2.000000>, <-0.578667, 0.541401, 2.000000>, <-0.578667, 0.000000, 2.000000>,
      <0.843137, 0.000000, 4.000000>, <0.843137, 0.815029, 4.000000>, <-0.843137, 0.815029, 4.000000>, <-0.843137, 0.000000, 4.000000>,
      <1.000000, 0.948093, 6.421632>, <1.000000, 2.424633, 5.407172>, <-1.000000, 2.424633, 5.407172>, <-1.000000, 0.948093, 6.421632>
    }
  }
  texture {
    Copper_Metal1
  }
  scale 0.2
  rotate <-35.0, -10.0, -130.0>
  translate  <-0.941395, 1.315606, 1.816875>
}
#declare Fot1 = union {
  object { Ben1 }
  sphere { // FotFot1
    <0,0,0>,1
    texture {
      Copper_Metal1
    }
    scale <0.382873, 0.218354, 0.062262>
    rotate <0.0, 0.0, -40.431137>
    translate  <-1.231526, 1.628846, 2.061269>
  }
  sphere { // FotKlot1
    <0,0,0>,1
    texture {
      Copper_Metal1
    }
    scale <0.098077, 0.059207, 0.073488>
    rotate <0.0, 0.0, -41.082355>
    translate  <-1.276364, 1.667392, 2.092584>
  }
  sphere { // FotKlot2
    <0,0,0>,1
    texture {
      Copper_Metal1
    }
    scale 0.05
    translate  <-1.294832, 1.610329, 2.106781>
  }
  sphere { // FotKlot3
    <0,0,0>,1
    texture {
      Copper_Metal1
    }
    scale 0.05
    translate  <-1.21496, 1.687039, 2.106934>
  }
  sphere { // FotKlot4
    <0,0,0>,1
    texture {
      Copper_Metal1
    }
    scale 0.05
    translate  <-1.222093, 1.568756, 2.107324>
  }
  sphere { // FotKlot5
    <0,0,0>,1
    texture {
      Copper_Metal1
    }
    scale 0.05
    translate  <-1.162605, 1.631338, 2.107038>
  }
  sphere { // FotKlot6
    <0,0,0>,1
    texture {
      Copper_Metal1
    }
    scale 0.04
    translate  <-1.269861, 1.566562, 2.098407>
  }
  sphere { // FotKlot7
    <0,0,0>,1
    texture {
      Copper_Metal1
    }
    scale 0.04
    translate  <-1.163073, 1.677251, 2.098639>
  }
}
#declare Ben3 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.235669, -2.760970, 0.013150>, <-0.235669, -2.995979, 0.003948>, <0.235669, -2.995979, 0.003948>, <0.235669, -2.760970, 0.013150>,
      <-0.578667, 0.000000, 2.000000>, <-0.578667, -0.541401, 2.000000>, <0.578667, -0.541401, 2.000000>, <0.578667, 0.000000, 2.000000>,
      <-0.843137, 0.000000, 4.000000>, <-0.843137, -0.815029, 4.000000>, <0.843137, -0.815029, 4.000000>, <0.843137, 0.000000, 4.000000>,
      <-1.000000, 0.948093, 6.421632>, <-1.000000, -0.528448, 7.436091>, <1.000000, -0.528448, 7.436091>, <1.000000, 0.948093, 6.421632>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.235669, -2.760970, 0.013150>, <0.235669, -2.525961, 0.022353>, <-0.235669, -2.525961, 0.022353>, <-0.235669, -2.760970, 0.013150>,
      <0.578667, 0.000000, 2.000000>, <0.578667, 0.541401, 2.000000>, <-0.578667, 0.541401, 2.000000>, <-0.578667, 0.000000, 2.000000>,
      <0.843137, 0.000000, 4.000000>, <0.843137, 0.815029, 4.000000>, <-0.843137, 0.815029, 4.000000>, <-0.843137, 0.000000, 4.000000>,
      <1.000000, 0.948093, 6.421632>, <1.000000, 2.424633, 5.407172>, <-1.000000, 2.424633, 5.407172>, <-1.000000, 0.948093, 6.421632>
    }
  }
  texture {
    Copper_Metal1
  }
  scale 0.2
  rotate <-35.0, -10.0, -130.0>
  translate  <-0.941395, 1.315606, 1.816875>
}
#declare Fot2 = union {
  object { Ben3 }
  sphere { // FotFot2
    <0,0,0>,1
    texture {
      Copper_Metal1
    }
    scale <0.382873, 0.218354, 0.062262>
    rotate <0.0, 0.0, -40.431137>
    translate  <-1.231526, 1.628846, 2.061269>
  }
  sphere { // FotKlot8
    <0,0,0>,1
    texture {
      Copper_Metal1
    }
    scale <0.098077, 0.059207, 0.073488>
    rotate <0.0, 0.0, -41.082355>
    translate  <-1.276364, 1.667392, 2.092584>
  }
  sphere { // FotKlot9
    <0,0,0>,1
    texture {
      Copper_Metal1
    }
    scale 0.05
    translate  <-1.294832, 1.610329, 2.106781>
  }
  sphere { // FotKlot10
    <0,0,0>,1
    texture {
      Copper_Metal1
    }
    scale 0.05
    translate  <-1.21496, 1.687039, 2.106934>
  }
  sphere { // FotKlot11
    <0,0,0>,1
    texture {
      Copper_Metal1
    }
    scale 0.05
    translate  <-1.222093, 1.568756, 2.107324>
  }
  sphere { // FotKlot12
    <0,0,0>,1
    texture {
      Copper_Metal1
    }
    scale 0.05
    translate  <-1.162605, 1.631338, 2.107038>
  }
  sphere { // FotKlot13
    <0,0,0>,1
    texture {
      Copper_Metal1
    }
    scale 0.04
    translate  <-1.269861, 1.566562, 2.098407>
  }
  sphere { // FotKlot14
    <0,0,0>,1
    texture {
      Copper_Metal1
    }
    scale 0.04
    translate  <-1.163073, 1.677251, 2.098639>
  }
  rotate -87.58416*z
  translate  <-0.266496, 0.789969, 0.0>
}
union { // HelaHornet
  object { MTankardM }
  object { MittKoppardel }
  object { Spets }
  object { Fot1 }
  torus { // Kant
    1.5, 0.05  rotate -x*90
    texture {
      Copper_Metal1
    }
    scale <0.712588, 0.779806, 0.947845>
    rotate -2.672151*x
    translate  <-0.016776, 2.468579, 5.746869>
  }
  cylinder { // UnderKant
    <0,0,1>, <0,0,0>, 1 open
    texture {
      Copper_Bump
    }
    scale <1.03548, 1.191724, 0.202639>
    rotate -2.541322*x
    translate  <-0.029001, 2.455747, 5.51964>
  }
  object { Fot2 }
  torus { // MittKant2
    1.5, 0.05  rotate -x*90
    texture {
      Copper_Metal1
    }
    scale <0.665024, 0.557589, 0.581867>
    rotate <-50.0, -0.15, 13.0>
    translate  <0.098306, 1.601177, 3.606024>
  }
  torus { // MittKant1
    1.5, 0.065  rotate -x*90
    texture {
      Copper_Metal1
    }
    scale <0.60964, 0.337607, 0.307238>
    rotate <-51.20562, -5.972675, 12.79926>
    translate  <0.467736, 0.252424, 2.568855>
  }
  torus { // SpetsKant
    1.5, 0.12  rotate -x*90
    texture {
      Copper_Metal1
    }
    scale <0.424092, 0.201373, 0.252369>
    rotate <-80.939621, 7.112113, 14.93797>
    translate  <0.81836, -0.801741, 2.412706>
  }
  torus { // Thread1
    1.5, 0.015  rotate -x*90
    texture {
      Chrome_Metal1
    }
    scale <0.675272, 0.755001, 1.057443>
    rotate <-31.305099, 0.030944, 13.173394>
    translate  <-0.01803, 200.26592, 4.932718>
  }
  torus { // Thread2
    1.5, 0.015  rotate -x*90
    texture {
      Chrome_Metal1
    }
    scale <0.675272, 0.70905, 0.911409>
    rotate <-14.383465, 0.0, 13.36621>
    translate  <-0.000059, 200.203519, 4.600649>
  }
  torus { // Thread3
    1.5, 0.015  rotate -x*90
    texture {
      Chrome_Metal1
    }
    scale <0.670041, 0.661772, 1.090026>
    rotate <-43.307022, 0.0, 13.36621>
    translate  <0.019019, 100.934758, 4.17428>
  }
  torus { // Thread4
    1.5, 0.015  rotate -x*90
    texture {
      Chrome_Metal1
    }
    scale <0.676093, 0.594622, 0.924554>
    rotate <-28.510971, 0.0, 13.36621>
    translate  <0.05122, 100.842342, 3.93529>
  }
  rotate 8.747164*z
  translate  <-11.127363, -1.49807, 0.0>
}


union{   //DA TABLE

/*box { // Log9
  <-1, -1, -1>, <1, 1, 1>
  texture {
    EMBWood2
    rotate 22.224487*z
  translate <0.000000, 0.027933, -0.893862>
  }
  scale <16.0, 2.0, 1.0>
  translate  <0.042581, -20.419373, 1.041797>
} */
superellipsoid
 {<0.1,0.1>
  texture {
    EMBWood2
    rotate 22.224487*z
  translate <0.000000, 0.027933, -0.893862>
  }
  scale<14,1.9,1>
  translate  <-1.542581, -20.419, 1.098577>
  }



/*box { // Log8
  <-1, -1, -1>, <1, 1, 1>
  texture {
    EMBWood2
    rotate 22.224487*z
  translate <0.000000, 0.027933, -0.893862>
  }
  scale <16.0, 2.0, 1.0>
  translate  <0.042581, -24.580044, 0.984761>
} */
superellipsoid
 {<0.1,0.1>
  texture {
    EMBWood2
    rotate 22.224487*z
  translate <0.000000, 0.027933, -0.893862>
  }
  scale<14,1.9,1>
  translate  <-1.542581, -24.580, 1.098577>
  }



/*box { // Log7
  <-1, -1, -1>, <1, 1, 1>
  texture {
    EMBWood2
    rotate 22.224487*z
  translate <0.000000, 0.027933, -0.893862>
  }
  scale <16.0, 2.0, 1.0>
  translate  <0.042581, -16.304753, 1.041797>
}*/
superellipsoid
 {<0.1,0.1>
  texture {
    EMBWood2
    rotate 22.224487*z
  translate <0.000000, 0.027933, -0.893862>
  }
  scale<14,1.9,1>
  translate  <-1.542581, -16.304, 1.098577>
  }



/*box { // Log6
  <-1, -1, -1>, <1, 1, 1>
  texture {
    EMBWood2
    rotate 9.750316*z
  }
  scale <16.0, 2.0, 1.0>
  translate  <0.042581, -12.157673, 1.098577>
} */
superellipsoid
 {<0.1,0.1>
  texture {
    EMBWood2
      rotate 9.750316*z
  }
  scale<14,1.9,1>
  translate  <-1.542581, -12.157, 1.098577>
  }



/*box { // Log5
  <-1, -1, -1>, <1, 1, 1>
  texture {
    EMBWood2
    rotate 22.224487*z
  translate <0.000000, 0.027933, -0.893862>
  }
  scale <16.0, 2.0, 1.0>
  translate  <0.042581, 8.49174, 1.070315>
} */
superellipsoid
 {<0.1,0.1>
  texture {
    EMBWood2
    rotate 22.224487*z
  translate <0.000000, 0.027933, -0.893862>
  }
  scale<14,1.9,1>
  translate  <-1.542581, 8.491, 1.098577>
  }



/*box { // Log4
  <-1, -1, -1>, <1, 1, 1>
  texture {
    EMBWood2
    rotate -14.472519*z
  translate <-0.037172, 0.098349, 0.782130>
  }
  scale <16.0, 2.0, 1.0>
  translate  <0.042581, 4.389725, 1.098577>
} */
superellipsoid
 {<0.1,0.1>
  texture {
    EMBWood2
    translate <-0.444668, 0.021549, -0.04>
    //rotate -14.472519*z
  //translate <-0.037172, 0.098349, 0.782130>
  }
  scale<14,1.9,1>
  translate  <-1.542581, 4.389, 1.098577>
  }



/*box { // Log3
  <-1, -1, -1>, <1, 1, 1>
  texture {
    EMBWood2
    rotate 100.100952*z
  }
  scale <16.0, 2.0, 1.0>
  translate  <0.042581, -8.027397, 1.098577>
} */
superellipsoid
 {<0.1,0.1>
  texture {
    EMBWood2
      rotate 100.100952*z
  }
  scale<14,1.9,1>
  translate  <-1.542581, -8.027, 1.098577>
  }



/*box { // Log2
  <-1, -1, -1>, <1, 1, 1>
  texture {
    EMBWood2
    rotate -28.247715*z
  translate <-0.541263, -0.246632, -0.502798>
  }
  scale <16.0, 2.0, 1.0>
  translate  <0.042581, -3.864041, 1.098577>
} */
superellipsoid
 {<0.1,0.1>
  texture {
    EMBWood2
    rotate -28.247715*z
  translate <-0.541263, -0.246632, -0.502798>
  }
  scale<14,1.9,1>
  translate  <-1.542581, -3.864, 1.098577>
  }



/*box { // Log1
  <-1, -1, -1>, <1, 1, 1>
  texture {
    EMBWood2
  translate <-0.444668, 0.021549, 0.000000>
  }
  scale <16.0, 2.0, 1.0>
  translate  <0.042581, 0.254362, 1.098577>
} */
superellipsoid
 {<0.1,0.1>
  texture {
    EMBWood2
    translate <-0.444668, 0.021549, 0.000000>
  }
  scale<14,1.9,1>
  translate  <-1.542581, 0.254, 1.098577>
  }


   scale <1.1,0.7,1>
    } //SLUT P 'DA TABLE'