/*
background {color rgb <1,1,1>}

camera{
location <0,350,0>
   angle 30
   look_at <0,0,0>
}

light_source{ <-120,150,-350>
   color rgb <1,1,1>
}
*/

#declare GHLTEX=
texture {
   finish {
       ambient <0.5,0.3,0.20>*.7
       diffuse 0.6
       phong 0.5
       phong_size 70
       }
    normal {bumps .1 scale <3,5,.5>}
    pigment { // rgb <.2,1,.1>}
       gradient x
       color_map {
          [0 color rgb <.2,1,.1>]
          [0.1 color rgb <.2,1,.1>]
          [.4 color rgb <.7,1,.4>]
          [.9 color rgb <.2,1,.1>]
          }
       scale 200
       translate x*-40
    }
}
#declare GHLTEX01=
texture {
   finish {
       ambient <0.5,0.3,0.20>*.7
       diffuse 0.6
       phong 0.5
       phong_size 70
       }
    normal {bumps .1 scale <3,5,.5>}
    pigment { rgb <.2,1,.1>}
}

#declare GHLTEX02=
texture {
   finish {
       ambient <0.5,0.3,0.20>*.7
       diffuse 0.6
       phong 0.7
       phong_size 100
       }
    normal {crackle 7 scale <.4,.15,.15>}
    pigment { rgbf <.2,1,.1,.5>}
}

#declare RADI07C = .75
#declare STRE07C = 2
#declare DENS07C = STRE07C*pow((1-pow(RADI07C,2)),2)
#declare L07C1=
blob{
   threshold DENS07C
      sphere {0,1,STRE07C
         scale <10/RADI07C,13/RADI07C,14/RADI07C>
         translate <-27,12,0>
      }
      sphere {0,1,STRE07C
         scale <9/RADI07C,13.3/RADI07C,13/RADI07C>
         rotate z*-7
         translate <-15.5,12,0>
      }
      sphere {0,1,STRE07C
         scale <6/RADI07C,12.8/RADI07C,7/RADI07C>
         rotate z*7
         translate <-35.5,12,0>
      }
      cylinder {<0,0,0>,<-10,0,0>,1,STRE07C
         scale <2.2/RADI07C,11/RADI07C,10/RADI07C>
         translate <-10,12,0>
      }

      sphere {0,1,-4
         scale <38,8,12.5>
         translate <-27,27.5,-9>
      }
      sphere {0,1,-4
         scale <38,8,12.5>
         translate <-27,27.5,9>
      }
      cylinder {<-40,0,0><-10,0,0>,1,-2 scale <1,10,20>
      }
      cylinder {<0,0,20><0,0,-20>,1,-50 scale <20,30,1>
      rotate z*-35
      translate x*-1
      }
    cylinder {<0,0,20><0,0,-20>,1,-10 scale <20,30,1>
      rotate z*-40
      translate <-12,-2,0>
      }
}

#declare L07C2=
blob{
   threshold DENS07C
   cylinder {<0,0,0><1,0,0>,1,STRE07C
   rotate z*-3
         scale <6/RADI07C,9/RADI07C,7/RADI07C>
         translate <-31,11,0>
      }
      cylinder {<-31,0,-4><-31,4,-2>,(2/RADI07C),STRE07C
      }
      cylinder {<-31,0,4><-31,4,2>,(2/RADI07C),STRE07C
      }
      cylinder {<-14,0,-4><-17,4,-2>,(2/RADI07C),STRE07C
      }
      cylinder {<-14,0,4><-17,4,2>,(2/RADI07C),STRE07C
      }
      cylinder {<0,0,-7><-3,4,-2>,(2/RADI07C),STRE07C
      }
      cylinder {<0,0,7><-3,4,2>,(2/RADI07C),STRE07C
      }
}

#declare L07C3=
#declare X0=0
#declare Y0=0
#declare XS=0
#declare YS=0
#declare R=1
#declare D=2.5
#declare RC=20
#declare A0= 0
#declare N=1.02
#declare M=(1/N)
#declare LX0=(RC*cos(A0))
#declare LY0=(RC*sin(A0))
#declare Count=8
#declare Countn=((Count+1)/2)
#declare C=R
blob{threshold DENS07C
     sphere {0,R,STRE07C scale<.7/RADI07C,.6/RADI07C,.6/RADI07C>
        rotate x*(degrees(A0)) translate<XS,YS,0>
        scale <.99,.99,.9> rotate z*90 rotate y*180
           }
        #while (Count>=1)
           #if (Count<=Countn+1)
           #declare N=M*.95
           #else
           #end
           #if (Count<=Countn/2)
           #declare N=M*.89
           #else
           #end
           #declare R=(R*N)
           #declare A=(A0+(2*asin(R/(RC*D))))
           #declare LX=(RC*cos(A))
           #declare LY=(RC*sin(A))
           #declare X=(X0+(LX-LX0))
           #declare Y=(Y0+(LY-LY0))
           #declare X1=(X+XS)
           #declare Y1=(Y+YS)
           #declare AA=degrees(A)
           sphere { <0,0,0>,R,STRE07C scale<.7/RADI07C,.6/RADI07C,.6/RADI07C>
              rotate z*AA translate<X1,Y1,0>
              scale <.99,.99,.9> rotate z*90 rotate y*180
           }
           #declare A0=A
           #declare Y0=Y
           #declare X0=X
           #declare LX0=LX
           #declare LY0=LY
           #declare Count=Count-1
        #end
#declare X0=0
#declare Y0=0
#declare XS=0
#declare YS=0
#declare R=1
#declare D=2.5
#declare RC=20
#declare A0= 0
#declare N=1.05
#declare M=(1/N)
#declare LX0=(RC*cos(A0))
#declare LY0=(RC*sin(A0))
#declare Count=8
#declare Countn=((Count+1)/2)
#declare C=R

     sphere {0,R,STRE07C scale<.7/RADI07C,.6/RADI07C,.6/RADI07C>
        rotate x*(degrees(A0)) translate<XS,YS,0>
         rotate z*86 rotate y*180 translate y*-.6
           }
        #while (Count>=1)
           #if (Count<=Countn+1)
           #declare N=M*.95
           #else
           #end
           #if (Count<=Countn/2)
           #declare N=M*.89
           #else
           #end
           #declare R=(R*N)
           #declare A=(A0+(2*asin(R/(RC*D))))
           #declare LX=(RC*cos(A))
           #declare LY=(RC*sin(A))
           #declare X=(X0+(LX-LX0))
           #declare Y=(Y0+(LY-LY0))
           #declare X1=(X+XS)
           #declare Y1=(Y+YS)
           #declare AA=degrees(A)
           sphere { <0,0,0>,R,STRE07C scale<.7/RADI07C,.6/RADI07C,.6/RADI07C>
              rotate z*AA translate<X1,Y1,0>
               rotate z*86 rotate y*180 translate y*-.6
           }
           #declare A0=A
           #declare Y0=Y
           #declare X0=X
           #declare LX0=LX
           #declare LY0=LY
           #declare Count=Count-1
        #end
}
#declare L07C=
merge{
object {L07C1 scale <.9,1,.6>
             translate <-5,.95,0>
             texture{GHLTEX01}}

object {L07C2 texture{GHLTEX01}}
object {L07C3 scale 11 rotate x*180 rotate z*-5 translate <-15,7,0>
             texture{GHLTEX}}
}

#declare HEAD01=
blob{threshold DENS07C
     cylinder {<0,.2,0>,<0,-.2,0>,1,STRE07C scale<1.1/RADI07C,1.3/RADI07C,.9/RADI07C>
        translate y*-.3}

     cylinder {<0,.4,0>,<0,-.4,0>,1,STRE07C scale<.6/RADI07C,.78/RADI07C,.6/RADI07C>
        rotate x*-12 translate z*-.3 translate y*.15}

     cylinder {<0,.4,0>,<0,-.4,0>,1,STRE07C scale<.6/RADI07C,.78/RADI07C,.6/RADI07C>
        rotate x*-90 translate z*.5 translate y*.8}

     cylinder {<0,0,0>,<0,-10,0>,1,-2 scale<.7/RADI07C,.3/RADI07C,1/RADI07C>
        translate y*-1}

    sphere {0,1.5,STRE07C scale<.1/RADI07C,.1/RADI07C,.2/RADI07C>
       translate <-.6,0.7,-.5>}
    sphere {0,1.5,STRE07C scale<.1/RADI07C,.1/RADI07C,.2/RADI07C>
       translate <.6,0.7,-.5>}
     }

#declare HEAD02=
union{
   sphere {0,1 scale <.5,.7,.6>*.6 rotate z*-17 translate <-.8,0.7,-.2>}
   sphere {0,1 scale <.5,.7,.6>*.6 rotate z*17 translate <.8,0.7,-.2>}
}
#declare HEAD03a=
blob{threshold DENS07C
     cylinder {<0,.2,0>,<0,-.2,0>,1,STRE07C scale<.9/RADI07C,.9/RADI07C,.8/RADI07C>
        translate <0,-.3,-0.1>}
     }
#declare HEAD03b=
blob{threshold DENS07C
     sphere {0,1,STRE07C scale<.39/RADI07C,.6/RADI07C,.35/RADI07C> rotate x*-10
        translate <-0.25,-1.2,-.2>}
     sphere {0,1,STRE07C scale<.39/RADI07C,.6/RADI07C,.35/RADI07C> rotate x*-10
        translate <0.25,-1.2,-.2>}
     }
#declare HEAD03c=
union{
   sphere {0,1 scale <.3,.5,0.45>  rotate  z*37 translate <-.6,-1.35,0>}
   sphere {0,1 scale <.3,.5,0.45>  rotate  z*-37 translate <.6,-1.35,0>}
}

#declare HEAD03d1=
blob{threshold DENS07C

     cylinder {<0,0,0><0,0,-3>1,STRE07C scale 0.15
     }
     cylinder {<0,0,0><-5,0,0>1,STRE07C scale 0.15
        rotate z*-10
     }
     cylinder {<0,0,0><-4,0,0>1,STRE07C scale 0.15
        rotate z*76
        translate x*-.75
        rotate z*-10
     }
     cylinder {<0,0,0><-3,0,0>1,STRE07C scale 0.15
        rotate <0,-10,58>
        translate x*-.6
        rotate z*76
        translate x*-.75
        rotate z*-10
      }
      sphere {0,1,STRE07C scale 0.2
        translate x*-.35
        rotate <0,-10,58>
        translate x*-.6
        rotate z*76
        translate x*-.75
        rotate z*-10
      }
rotate y*-78
translate <-1.2,-1.1,0.6>
}

#declare HEAD03d2=
blob{threshold DENS07C

     cylinder {<0,0,0><0,0,-3>1,STRE07C scale 0.15
     }
     cylinder {<0,0,0><-4,0,0>1,STRE07C scale 0.15
        rotate z*48
     }
     cylinder {<0,0,0><-3,0,0>1,STRE07C scale 0.15
        rotate <0,-15,58>
        translate x*-.6
        rotate z*48
      }
      sphere {0,1,STRE07C scale 0.2
        translate x*-.35
        rotate <0,-15,58>
        translate x*-.6
        rotate z*48
      }
rotate y*-78
translate <-1.1,-1.4,0.6>
}

#declare HEAD03d3=
blob{threshold DENS07C

     cylinder {<0,0,0><0,0,-3>1,STRE07C scale 0.15
     }
     cylinder {<0,0,0><5,0,0>1,STRE07C scale 0.15
        rotate z*10
     }
     cylinder {<0,0,0><4,0,0>1,STRE07C scale 0.15
        rotate z*-76
        translate x*.75
        rotate z*10
     }
     cylinder {<0,0,0><3,0,0>1,STRE07C scale 0.15
        rotate <0,10,-58>
        translate x*.6
        rotate z*-76
        translate x*.75
        rotate z*10
      }
      sphere {0,1,STRE07C scale 0.2
        translate x*.35
        rotate <0,10,-58>
        translate x*.6
        rotate z*-76
        translate x*.75
        rotate z*10
      }
rotate y*78
translate <1.2,-1.1,0.6>
}

#declare HEAD03d4=
blob{threshold DENS07C

     cylinder {<0,0,0><0,0,-3>1,STRE07C scale 0.15
     }
     cylinder {<0,0,0><4,0,0>1,STRE07C scale 0.15
        rotate z*-48
     }
     cylinder {<0,0,0><3,0,0>1,STRE07C scale 0.15
        rotate <0,15,-58>
        translate x*.6
        rotate z*-48
      }
      sphere {0,1,STRE07C scale 0.2
        translate x*.35
        rotate <0,15,-58>
        translate x*.6
        rotate z*-48
      }
rotate y*78
translate <1.1,-1.4,0.6>
}

#declare X0=0
#declare Y0=0
#declare XS=0
#declare YS=0
#declare R=.18
#declare D=1.5
#declare RC=7
#declare A0=0
#declare N=1.05
#declare M=(1/N)
#declare LX0=(RC*cos(A0))
#declare LY0=(RC*sin(A0))
#declare Count=30
#declare Countn=((Count+1)/2)
#declare ANT01=
blob{threshold DENS07C
     cylinder {<XS,YS,0>,<XS,YS-.2,0>,R,STRE07C scale<.4,1,.4>}
     sphere {<0,0,0>,R,5 scale<.4,1,.4> rotate<0,0,A0> translate<XS,YS,0>}
        #while (Count>=1)
           #if (Count<Countn)
           #declare N=M
           #else
           #end
           #declare R=(R*N)
           #declare A=(A0+(2*asin(R/(RC*D))))
           #declare LX=(RC*cos(A))
           #declare LY=(RC*sin(A))
           #declare X=(X0+(LX-LX0))
           #declare Y=(Y0+(LY-LY0))
           #declare X1=(X+XS)
           #declare Y1=(Y+YS)
           #declare AA=degrees(A)
           sphere { <0,0,0>,R,STRE07C scale<.4,1,.4> rotate<0,0,AA> translate<X1,Y1,0>
           }
           #declare A0=A
           #declare Y0=Y
           #declare X0=X
           #declare LX0=LX
           #declare LY0=LY
           #declare Count=Count-1
        #end
     }

#declare WIN01=
prism {
  linear_sweep
  quadratic_spline
  0, 0.02, 25,

<-0.591,-0.083>,
<0,0>,
<0.591,0.083>,
<1.336,0.093>,
<2.641,-0.03>,
<4.039,-0.207>,
<4.784,-0.279>,
<5.447,-0.383>,
<5.851,-0.518>,
<5.975,-0.632>,
<6.027,-0.767>,
<5.975,-0.902>,
<5.851,-1.006>,
<5.582,-1.089>,
<5.105,-1.13>,
<4.256,-1.141>,
<3.355,-1.141>,
<2.568,-1.089>,
<1.75,-0.964>,
<1.025,-0.84>,
<0.466,-0.663>,
<0.073,-0.435>,
<-0.009,-0.165>,
<0,0>,
<-0.082,0.27>
texture {GHLTEX02}
rotate x*180}

# declare HEAD=
merge {
object {HEAD01}
object {HEAD02 texture {GHLTEX01} finish{reflection .2} pigment {color rgb <.35,1,.2>}}
object {HEAD03a}
object {HEAD03b}
object {HEAD03b rotate y*180 translate <0,-.1,.1>}
object {HEAD03c}
object {HEAD03d1}
object {HEAD03d2}
object {HEAD03d3}
object {HEAD03d4}
object {ANT01 rotate y*-90 rotate x*-35 rotate y*15 translate <-.7,0.9,-.9>}
object {ANT01 rotate y*-90 rotate x*-35 rotate y*-15 translate <.7,0.9,-.9>}
cylinder {<0,0,0><0,0,1.7>1 scale <.7,1.3,1> translate y*-.3}
texture {GHLTEX01}
}
/*
object {HEAD  scale 6 rotate y*90 translate <-46,15,0>}
object {L07C}
object {WIN01 scale <16,18,17> rotate x*(90+38) rotate y*-2.5 translate <-20,23,-2.5>}
object {WIN01 scale <16,18,17> rotate x*(90-38) rotate y*2.5 translate <-20,23,2.5>}
*/
