
// Persistence of Vision Ray Tracer Scene Description File
// File: glass.pov
// Vers: 3
// Desc: IRTC - entry Jan/Feb 1997 - Topic - Glass
// Date: 02/19/1997
// Auth: Morgan Fraser
// Computer: Pentium 133 - 32 MB RAM

#version 3

#include "colors.inc"
#include "finish.inc"
#include "glass.inc"
#include "woods.inc"
#include "metals.inc"

//#declare QUICK=1
//#declare SIMPLELIGHT=1
//#declare NOHALOS=1
//#declare NOCANDLES=1

#declare R1=seed(50)
global_settings
{
  assumed_gamma 1.0
  ambient_light 0.03
  max_trace_level 25
  max_intersections 256
}

// ----------------------------------------
camera
{
//  fisheye
//  angle 150
//  location  <0.0, 12*5+7, -150.0>
  location  <0.0, 12*5+7, -30.0+12*4>
//  direction 1.5*z
  direction 0.8*z
  right     4/3*x
  look_at   <0.0, 20.0,  150.0+12*4>
//  look_at   <0.0, 12*5+7,  900.0>
//    aperture 5
//    blur_samples 4
//  focal_point <0,0,300>
}

sky_sphere
{
#ifdef (QUICK)
  pigment
  {
    color rgb<0.5,0.5,0.5>
  }
#else
  pigment
  {
    quilted
    turbulence 2.5
    color_map { [0.0 color rgb <0.3,0.02,0.2>] [0.8 color rgb 0.7] [1.0 color rgb <0.7,0.1,0.01>] }
    scale <1.5,0.5,1>
  }
#end
}

#ifndef (QUICK)
plane {y, 12*40
  texture {
    pigment {
      bozo
      turbulence 3
      color_map{[0.0 color rgb <1,1,1>]
                [0.2 color rgb <0.5,0.6,0.55>]
                [0.4 color rgbft<0,0,0,1,1>]
                [1.0 color rgbft<0,0,0,1,1>]}
      scale <60,30,30>*10
    }
  }
  hollow
}
#end

#ifndef (SIMPLELIGHT)
#else
light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <100, 80, -100>
}
#end

// ----------------------------------------

#declare Candle1Base=prism{
    linear_spline
    -1
    1
    6
    <0,10>,<7,0>,<9,0>,<9,2>,<2,11>,<0,10>
    rotate<-90,0,0>
  }

#declare Candle1Flame=union{
  object{
  intersection{
  sphere{
    <0,1,0>,1.3
    scale<5,20,5>
    hollow
  }
  box{<-9,0,-9>,<9,70,9>   hollow }
  texture{
    pigment{
      color rgbft<0,0,0,0,1>
    }
  }
  hollow
  }
  #ifndef (NOHALOS)
    halo {
      emitting
      spherical_mapping
      turbulence 1
      linear
      color_map{
        [0.0 rgbft<1,1,1,0,1>]
        [0.22 rgbft<1,.2,.1,0.01,0.99>]
        [0.2 rgbft<1,.5,.3,0.1,0.9>]
        [0.6 rgbft<.8,.2,.1,0,.7>]
        [1.0 rgbft<1,0,0,0,.1>]
      }
      scale <4,9,4>
    }
    #end
  }
    #ifndef (SIMPLELIGHT)
      light_source{
        <0,1,0>
        color <0.75,0.6,0.5>*2
        //area_light <0,15,0>,<0,0,0.1>,5,1
        fade_distance 18
        fade_power 1.9
        //adaptive 1
        //jitter
      }
    #end
  translate<0,12*5-0.25+.7>
}


#declare Candle1=union{
  cylinder{<0,3,0>,<0,5*12,0>,1.5}
  box{<-1.7,3,-1.7>,<1.7,2.5,1.7>}
  object{Candle1Flame}
  intersection{
    prism{
      linear_spline
      -6
      6
      13
      <3,0>,<3.5,0.25>,<4,0.25>,<4.5,0.5>,<4.75,0.6>,<4.5,0.9>,<-4.5,0.9>,
      <-4.75,0.6>,<-4.5,0.5>,<-4,0.25>,<-3.5,0.25>,<-3,0>,<3,0>
      rotate<-90,0,0>
      translate<0,12*5-0.25,0>
      }
    prism{
      linear_spline
      -6
      6
      13
      <3,0>,<3.5,0.25>,<4,0.25>,<4.5,0.5>,<4.75,0.6>,<4.5,0.9>,<-4.5,0.9>,
      <-4.75,0.6>,<-4.5,0.5>,<-4,0.25>,<-3.5,0.25>,<-3,0>,<3,0>
      rotate<-90,0,0>
      translate<0,12*5-0.251,0>
      rotate<0,90,0>
      }
  }
  object{Candle1Base}
  object{Candle1Base rotate<0,90,0>}
  object{Candle1Base rotate<0,180,0>}
  object{Candle1Base rotate<0,270,0>}
  #ifdef (QUICK)
  texture {
    pigment{
      color Brown
    }
  }
  #else
  texture {
    pigment{
      gradient y
      turbulence 1.9
      color_map{
       [0.0 rgb <0.3,0.1,0.1>*0.8]
       [0.3 rgb <0.01,0.01,0.01>]
       [0.5 rgb <0.1,0.03,0.08>]
       [1.0 rgb <0.3,0.1,0.1>*0.8]
      }
    }
    normal{
      radial
      frequency 12
      turbulence .1
    }
  }
  #end
  rotate<0,45,0>
}

#declare Cup=union{
  lathe {
    //linear_spline
    //quadratic_spline
    cubic_spline
    19
    <0,.1>,<3,0>,<3,0.1>,<.2,.3>,<1,.4>,<2.1,.9>,<2.4,1.3>,<2.7,2.2>,<3,2.9>,<3,3>,<2.9,3>,
    <2.8,2.9>,<2.6,2.2>,<2.3,1.3>,<2.0,0.9>,<0.9,.4>,<0.25,0.25>,<0,.2>,<0,0.1>
  }
  scale <4,5,4>
  //translate<0,10,0>
  //texture{pigment{Yellow}}
}

#ifndef (QUICK)
#declare T_FloorMid=texture{
            pigment {
             crackle
             turbulence 1.2
             color_map{
               [0.0 rgb<0.6,0.44,0.42>]
               [0.1 rgb<0.18,0.17,0.22>]
               [1.0 rgb<0.11,0.12,0.13>]
             }
             scale 4
            }
            finish {
              phong .3
              roughness 2
              reflection 0.1
            }
}
      texture{
        pigment{
          bozo
          turbulence 1
          color_map{
            [0.0 rgbft<1,1,1,0,1>]
            [0.6 rgbft<1,1,1,0,1>]
            [0.9 rgbft<0.6,0.6,0.6,0,0>]
            [1.0 rgbft<0.02,0.07,0.1,0,0.8>]
          }
          scale 4
        }
        finish {
          Dull
        }
      }
#else
#declare T_FloorMid=texture{
            pigment {rgb<0.11,0.12,0.13>*3}
            }
#end

#ifndef (QUICK)
#declare T_Wall=texture{
       pigment{
         marble
         turbulence 0.3
         color_map{
           [0.0 rgb <0.4,0.35,0.32>*0.3]
           [1.0 rgb <.2,.15,.11>]
         }
         rotate<0,90,0>
         scale<1,1,12>
       }
       normal{
         bozo
         turbulence 2
         scale<5,40,5>
       }
       finish{
         ambient 0.15
         brilliance 2
         diffuse 0.5
         metallic
         specular 0.80
         roughness 1/10
         reflection 0.03
       }
    }
    texture {
      pigment{
        crackle
        turbulence 0.5
        color_map{
          [0.0 rgbft<.1,.01,.005,0,0>]
          [0.13 rgbft<.1,.01,.005,0,.02>]
          [0.15 rgbft<.3,.1,.1,0,1>]
          [1.0 rgbft<1,1,1,0,1>]
        }
        scale 15
      }
    }
#else
   #declare T_Wall=texture{
       pigment {DarkWood}
   }
#end

#declare T_Column=  texture{
   pigment{
     bozo
     turbulence 3
     color_map{
       [0.0 rgb <.2,.05,.01>]
       [1.0 rgb <.6,0,0>]
      }
      scale 10
    }
   normal {
    crackle
    scale 4
   }
  }
  texture {
   pigment{
     agate
     turbulence 1.7
     color_map{
       [0.0 rgbft<1,1,1,0,1>]
       [0.8 rgbft<1,1,1,0,9>]
       [0.85 rgbft<0.4,0.4,0.4,.3,.5>]
       [1.0 rgbft<0.6,0.6,0.7,.1,.05>]
      }
     scale 10
   }
   finish{
     reflection .1
     roughness .3
     phong .4
    }
  }

#declare ArchDoor=union{
  blob{
    threshold 0.5
    #declare Count=0
    #while (Count<27)
      sphere { <24,Count*2,0>,4+rand(R1)*1-0.5,1}
      sphere { <-24,Count*2,0>,4+rand(R1)*1-0.5,1}
      sphere { <-24+Count/26*48,26*2+40-((Count/26-0.5)*(Count/26-0.5)*4)*40,0>,6,1}
      #declare Count=Count+1
    #end
    texture{T_Column}
  }
  union{
    cylinder{
      <0,0,-2>,<0,0,2>,23
      scale<1,38/24,1>
      translate<0,26*2,0>
    }
    box{<-23,26*2,-1.9>,<23,.5,1.9>}
    // Handle
    union{
      torus{
        3,0.5
        rotate<90,0,0>
      }
      cylinder{<-2.5,3.5,0>,<2.5,3.5,0>,0.3}
      texture{pigment{Yellow}}
      translate<0,-3.5,0>
      rotate<25,0,0>
      translate<0,3.5,0>
      translate<-12,12*3,-2>
    }
    #ifdef (QUICK)
      texture{pigment{Brown}}
    #else
      texture{T_Wood12 rotate<90,0,0>scale 20}
    #end
    translate<-23,0,0>
    rotate<0,75,0>
    translate<23,0,0>
  }
  texture {pigment{Yellow}}
  //scale <1.4,1.2,1>
}
#declare ArchDoor2=union{
  blob{
    threshold 0.5
    #declare Count=0
    #while (Count<27)
      sphere { <24,Count*2,0>,4+rand(R1)*1-0.5,1}
      sphere { <-24,Count*2,0>,4+rand(R1)*1-0.5,1}
      sphere { <-24+Count/26*48,26*2+40-((Count/26-0.5)*(Count/26-0.5)*4)*40,0>,6,1}
      #declare Count=Count+1
    #end
    texture{T_Column}
  }
  union{
    cylinder{
      <0,0,-2>,<0,0,2>,23
      scale<1,38/24,1>
      translate<0,26*2,0>
    }
    box{<-23,26*2,-1.9>,<23,.5,1.9>}
    // Handle
    union{
      torus{
        3,0.5
        rotate<90,0,0>
      }
      cylinder{<-2.5,3.5,0>,<2.5,3.5,0>,0.3}
      texture{pigment{Yellow}}
      translate<0,-3.5,0>
      rotate<25,0,0>
      translate<0,3.5,0>
      translate<-12,12*3,-2>
    }
    #ifdef (QUICK)
      texture{pigment{Brown}}
    #else
      texture{T_Wood12 rotate<90,0,0>scale 20}
    #end
    translate<-23,0,0>
    rotate<0,25,0>
    translate<23,0,0>
  }
  texture {pigment{Yellow}}
  scale <-1,1,1>
}

#declare RoomColumn=union{
  cylinder{
     <0,20*12,0>,<0,-40*12,0>,12
     }
  box{
    <-15,0,-15>,<15,1,15>
  }
  box{
    <-14,1.01,-14>,<14,2,14>
  }
  box{
    <-13,2-0.01,-13>,<14,6,13>
  }
  box{
    <-15,6.01,-15>,<15,7,15>
  }
  box{
    <-14,7.01,-14>,<14,8,14>
  }

 #ifndef (QUICK)
  texture{T_Column}
  #else
    texture{pigment{Red}}
  #end
 }

 #declare Sculpture=union{
   julia_fractal{
      <-0.083,.1,-0.83,-0.025>
      quaternion
      cube
      max_iteration 8
      precision 15
     scale <7,4,1>
    }
   julia_fractal{
      <-0.183,.1,-0.83,-0.025>
      quaternion
      cube
      max_iteration 8
      precision 15
     scale <2,5,.5>
     translate<0,4,0>
    }
    #ifdef (QUICK)
      texture{pigment{Green}}
    #else
      texture{
        pigment{
          bozo
          turbulence 2
          color_map{
            [0.0 rgbf<0.05,0.7,0.05,.6>]
            [0.5 rgbf<.1,.6,.1,.4>]
            [0.7 rgbf<.02,.2,.16,.8>]
            [1.0 rgbf<.3,.5,.3,.9>]
          }
        }
        finish {
          ambient 0.1
          diffuse 0.1
          reflection .25
          refraction 1
          ior 1.8
          specular 1
          roughness 0.001
        }
      }
    #end
    }

 #declare Sculpture3=union{
   julia_fractal{
      <-0.083,.11,-0.84,-0.025>
      quaternion
      cube
      max_iteration 8
      precision 15
     scale <7,4,1>
    }
   julia_fractal{
      <-0.183,.09,-0.82,-0.025>
      quaternion
      cube
      max_iteration 8
      precision 15
     scale <2,5,.7>
     translate<0,5,0>
    }
    #ifdef (QUICK)
      texture{pigment{Green}}
    #else
      texture{
        pigment{
          granite
          turbulence 2
          color_map{
            [0.0 rgbf<0.05,0.7,0.05,.6>]
            [0.5 rgbf<.1,.6,.1,.4>]
            [0.7 rgbf<.02,.2,.16,.8>]
            [1.0 rgbf<.3,.5,.3,.9>]
          }
        }
        finish {
          ambient 0.1
          diffuse 0.1
          reflection .25
          refraction 1
          ior 1.8
          specular 1
          roughness 0.001
        }
      }
    #end
    }

// Good side sculpture   
#declare Sculpture2=merge{
  sphere{<-4*12,-2*12+6,0>,8}
  sphere{<4*12,-2*12+6,0>,8}
  sphere{<-3*12,6,2*12>,6}
  sphere{<3*12,6,2*12>,6}
  sphere{<0,12*3,0>,12}
  sphere{<0,12*6,16>,12
    pigment{color rgbft<1.0,1.0,1.0,.9,.2>}
    finish {ambient 0.3
       reflection .45
      }
    }
  sphere{<-4*12,12*5,0>,4}
  sphere{<4*12,12*5,0>,4}
  union{
    cylinder{<-4*12,-2*12+6,0>,<-3*12,6,2*12>,1.5}
    cylinder{<4*12,-2*12+6,0>,<3*12,6,2*12>,1.5}
    cylinder{<0,12*3,0>,<-3*12,6,2*12>,3}
    cylinder{<0,12*3,0>,<3*12,6,2*12>,3}
    cylinder{<0,12*3,0>,<0,12*6,16>,5}
    cylinder{<-4*12,12*5,0>,<0,12*6,16>,2}
    cylinder{<4*12,12*5,0>,<0,12*6,16>,2}
    pigment{color rgbf<.95,.95,.5,.9>}
    finish{reflection .4}
  }

   julia_fractal{
      <-0.183,.1,-0.83,-0.025>
      quaternion
      cube
      max_iteration 8
      precision 15
     scale <20,40,5>
     translate<-12*5,12*3,1>
     pigment{
       bozo
       turbulence 1.5
       color_map{
         [0.0 rgbf<.95,.6,.6,.9>]
         [1.0 rgbf<.8,.7,.65,.7>]
       }
     }
     finish{ior 2.3}
    }
   julia_fractal{
      <-0.183,.15,-0.83,-0.025>
      quaternion
      cube
      max_iteration 8
      precision 15
     scale <20,40,5>
     translate<12*5,12*3,1>
     pigment{
       bozo
       turbulence 1.5
       color_map{
         [0.0 rgbf<.6,.6,.95,.9>]
         [1.0 rgbf<.65,.7,.8,.7>]
       }
     }
     finish{ior 2.3}
    }

  texture{
    pigment{color rgbf<.9,.9,.9,.9>}
  }

  finish {
     ambient 0.1
     diffuse 0.1
     reflection .25
     refraction 1
     ior 1.8
     specular 1
     roughness 0.001
   }
}

#declare Room=union{
   #declare Count=0
   #while (Count<4)
     union{
      box {
        <-4*12-0.1,4*12,-20+150*Count>,<-6*12+0.1,-12*5-0.1,90+150*Count>}
      box {
        <4*12+0.1,4*12,-20+150*Count>,<6*12-0.1,-12*5-0.1,90+150*Count>}
       hollow
       texture {
         pigment{Clear}
       }
  #ifndef (NOHALOS)
    halo {
      glowing
      planar_mapping
      turbulence 0.1
      linear
      color_map{
        [0.0 rgbft<1,1,1,0,1>]
        [0.18 rgbft<1,.2,.1,0.01,0.99>]
        [0.2 rgbft<1,.5,.3,0.1,0.9>]
        [0.3 rgbft<.8,.2,.1,0,.7>]
        [1.0 rgbft<1,0,0,0,.1>]
      }
      scale <4,12,4>
      translate<0,-12,0>
    }
    #end
     }
     // include light sources
     #ifndef (SIMPLELIGHT)
      //box {
      //  <-4*12-0.1,4*12,-20+150*Count>,<-6*12+0.1,-12*5-0.1,90+150*Count>}
      light_source{
        <-5*12+0.5,-1,30+150*Count>
        color <0.95,0.6,0.4>
        fade_distance 12
        fade_power 1.4
        //jitter
      }
      light_source{
        <5*12+0.5,-1,30+150*Count>
        color <0.5,0.1,0.1>*.2
        fade_distance 12
        fade_power 1
        //jitter
      }
     #end
     #declare Count=Count+1
   #end
   difference{
      box{<-12*15,0,-12*30>,
          <12*15,-12*6,12*150>}
      #declare Count=0
      #while (Count<4)
         box{
            <-4*12,0.1,-20+150*Count>,<-6*12,-12*5,90+150*Count>
            }
         box{
            <4*12,0.1,-20+150*Count>,<6*12,-12*5-0.1,90+150*Count>
            }
         #declare Count=Count+1
      #end
      texture {
        #ifndef (QUICK)
          brick
          texture{
            pigment {
             granite
             color_map{
               [0.0 rgb<0.6,0.64,0.62>]
               [0.1 rgb<0.18,0.17,0.22>*0.1]
               [1.0 rgb<0.11,0.12,0.13>*0.1]
             }
             scale 2
            }
           }
          texture { T_FloorMid
          }
          brick_size <30,20,12>
          mortar 1.7
          turbulence 0.5
          rotate<90,0,0>
          translate<0,2.4,0>
        #else
            pigment {rgb<0.11,0.12,0.13>*3}
        #end
      }
   }
   object {RoomColumn
    translate<-11*12,0,15*12>
    }
   object {RoomColumn
    translate<11*12,0,15*12>
    }
   object {RoomColumn
    translate<-11*12,0,40*12>
    }
   object {RoomColumn
    translate<11*12,0,40*12>
    }
    
   // 2 Corner Columns
   union{
     cylinder{<-12*15,0,12*70>,<-12*15,20*12,12*70>,6}
     cylinder{<12*15,0,12*70>,<12*15,20*12,12*70>,6}
     #ifndef (QUICK)
       texture{T_Column}
     #else
       texture{pigment{Red}}
     #end
   }
   box{
     <-12*15,-12,-12*30>,
     <-12*16,20*12,12*70>
     texture {T_Wall}
     }
   box{
     <12*15,-12,-12*30>,
     <12*16,20*12,12*70>
     texture {T_Wall}
     }
   
   // Wall Sculpture to right side
   object{Sculpture
    rotate<0,90,0>
    scale 20
    translate<12*15,2*12,12*30>
    }
    
   // Wall Sculpture to left side
   object{Sculpture3
    rotate<0,90,0>
    scale 20
    translate<-12*15,2*12,12*30>
    }
    
   // Sculpture on far wall
   object{Sculpture2
    rotate<0,180,0>
    scale <.65,1,1>
    //scale 1
    //translate<-12*15,2*12,12*30>
    translate<0,2*12,12*70>
    }
     
   // The wall behind you
     box {
       <12*16,-12,-12*30>,
       <-12*16,20*12,-12*31>
     }
   // This is far wall - cut door into it
   difference{
     box {
       <12*16,-12,12*70>,
       <-12*16,20*12,12*71>
     }
     union{
       cylinder{
         <0,0,-1>,<0,0,6*12>,23
         scale<1,38/24,1>
         translate<0,26*2,0>
       }
       box{<-23,26*2,-1.01>,<23,.5,6*12+0.01>}
       scale <1.4,.9,1>
       translate<-12*8,0,12*70>
     }
     union{
       cylinder{
         <0,0,-1>,<0,0,6*12>,23
         scale<1,38/24,1>
         translate<0,26*2,0>
       }
       box{<-23,26*2,-1.01>,<23,.5,6*12+0.01>}
       scale <1.4,.9,1>
       translate<12*8,0,12*70>
     }
     texture {T_Wall rotate<0,90,0>}
   }
   // Cup on far wall
   union {
     object{Cup}
     scale <5,5,1>
     //texture{pigment{Green}}
     #ifndef(QUICK)
      texture{T_Column}
     #else
      texture{pigment{Red}}
     #end
     translate<0,12*11,12*70>
   }
   object {ArchDoor scale <1.4,.9,1> translate<-12*8,0,12*70>}
   object {ArchDoor2 scale <1.4,.9,1> translate<12*8,0,12*70>}
   // Walls for area beyond End Doors
   union {
     box {
       <12*16,-1,12*120>,
       <-12*16,10*12,12*121>
     }
     box {
       <12*15,9*12,12*71>,
       <-12*15,10*12,12*120>
     }
     box {
       <-12*16,-1*12,12*71>,
       <-12*15,10*12,12*120>
     }
     box {
       <12*16,-1*12,12*71>,
       <12*15,10*12,12*120>
     }
   }
   // The cieling portion
   union{
     box {
       <12*16,20*12,12*70>,
       <-12*16,21*12,-12*30>
       }
     // texturise with random blocks
     #declare Count=1
     #while (Count<400)
       #declare YStart=12*30*rand(R1)+12*40
       #declare XStart=-12*16+rand(R1)*12*32
       box{<XStart,20*12,YStart>,<XStart+rand(R1)*12,20*12-rand(R1)*6,YStart+rand(R1)*12*8>
         #ifdef (QUICK)
           texture{pigment{Orange}}
         #end
       }
       #declare Count=Count+1
     #end
     #ifndef(QUICK)
       texture{
         pigment{
           granite
           color_map{
             [0.0 rgb<.7,.7,.7>]
             [0.5 rgb<.2,.1,.15>]
             [0.8 rgb<.7,.4,.2>]
             [1.0 rgb<.2,.1,.1>]
           }
         }
         finish{
           reflection 0.3
           phong .4
         }
         scale 12*3
       }
     #end
   }
     texture {
       pigment {DarkWood}
     }
}

#declare AltarCandle=union{
  cylinder{
    <0,0,0>,<0,15,0>,0.5
  }
  sor {
    6
    <9,0>,<3,.7>,<.9,3.5>,<1.2,4>,<0.55,5>,<0.2,9>
    sturm
    //texture{pigment{Yellow}}
    texture{T_Gold_5A}
  }
  #ifndef (SIMPLELIGHT)
  light_source{
    <0,18,0>
    color rgb <1,1,1>*2
    fade_distance 18
    fade_power 2
  }
  #end
  #ifndef (NOHALOS)
   sphere{<0,0,0>,12
    hollow
    texture{ pigment{Clear}}
    halo {
      emitting
      spherical_mapping
      turbulence <0.1,.1,0.1>
      linear
      color_map{
        [0.0 rgbft<1,1,1,0,1>]
        [0.7 rgbft<1,1,1,0,.95>]
        [1.0 rgbft<1,1,1,0,.03>]
      }
    }
    scale <8,12,8>
    //scale 2
    translate<0,18,0>
   }
  #end
  texture{
    pigment{White}
    finish{
      phong 0.4
      ambient 0.4
     }
   }
}

#declare Altar=union{
  box{
    <-3*12,0,-1*12>,<3*12,2.5,1*12>
   }
  box{
    <-3*12,17-0.01,-1*12>,<3*12,17.5,1*12>
   }
  box{
    <-3*12-0.5,16.5,-1*12-0.5>,<3*12+0.5,17,1*12+0.5>
   }
  box {
    <-3*12+1,16.51,-1*12+1>,<-1*12,2.49,1*12-1>
   }
  box {
    <3*12-1,16.51,-1*12+1>,<1*12,2.49,1*12-1>
   }
  object{Cup
    #ifndef (QUICK)
      texture{
       material_map{
        gif "runes1.gif"
        map_type 2
        once
        texture {
          T_Old_Glass
         }
        texture{
          //pigment{Red}
          pigment { color rgbf <0.78, 0.38, 0.38, 0.7> }
          finish  {
             ambient 0.1
             diffuse 0.1
             reflection 0.1
             refraction 1
             ior 1.05
             specular 0.8
             roughness 0.003
             phong 1
             phong_size 400
           }
        }
       }
       scale 6
       translate<0,8,0>
       rotate<0,50,0>
      }
    #else
      texture{
       material_map{
        gif "runes1.gif"
        map_type 2
        once
        texture{pigment{Blue}}
        texture{pigment{Red}}
       }
       scale 6
       translate<0,8,0>
       //rotate<0,50,0>
      }
    #end
    translate<0,17.5,0>
   }
  object{AltarCandle translate<2*12,17.5,0>}
  object{AltarCandle translate<-2*12,17.5,0>}
  
  // Lettering on base
  text{ttf "runic.ttf",
     "Euil",
     1,0
     scale <8,8,1>
     translate<-2.5*12,7,-1*12+1-1.0>
     #ifdef(QUICK)
       texture{pigment{Red}}
     #end
  }

  text{ttf "runic.ttf",
     "Euil",
     1,0
     scale <8,8,1>
     translate<-2.5*12,7,-1*12+1-1.0>
     #ifdef(QUICK)
       texture{pigment{Red}}
     #end
     rotate<0,180,0>
  }

  text{ttf "runic.ttf",
     "Good",
     1,0
     scale <7,7,1>
     translate<1.3*12,7,-1*12+1-1.0>
     #ifdef(QUICK)
       texture{pigment{Red}}
     #end
  }

  text{ttf "runic.ttf",
     "Good",
     1,0
     scale <7,7,1>
     translate<1.3*12,7,-1*12+1-1.0>
     #ifdef(QUICK)
       texture{pigment{Red}}
     #end
     rotate<0,180,0>
  }

  text{ttf "runic.ttf",
     "In Uilla Dominum Est Sed Puella In Tablum Est Canis Canam Amare ",
     1,0
     scale <2,2,1>
     translate<-2.5*12,0.6,-1*12-0.3>
     #ifdef(QUICK)
       texture{pigment{Red}}
     #end
  }
  
  text{ttf "runic.ttf",
     "In Uilla Dominum Est Sed Puella In Tablum Est Canis Canam Amare ",
     1,0
     scale <2,2,1>
     translate<-2.5*12,0.6,-1*12-0.3>
     #ifdef(QUICK)
       texture{pigment{Red}}
     #end
     rotate<0,180,0>
  }
  
  #ifndef (QUICK)
  texture{
   pigment{ marble
    turbulence 4
    color_map{
     [0.0 rgb<0.3,0.25,0.2>]
     [1.0 rgb<0.1,0.08,0.11>]
    }
   }
  }
  #else
  texture{
   pigment{Yellow}
  }
  #end
}


#ifndef (NOCANDLES)
#declare Count=-1
#while (Count<4)
  object{Candle1
    rotate<0,rand(R1)*360,0>
    translate<-7*12+rand(R1)*6-3,0,50+Count*150>
  }
  object{Candle1
    rotate<0,rand(R1)*360,0>
    translate<7*12+rand(R1)*6-3,0,50+Count*150>
  }
  #declare Count=Count+1
#end
#end
// The ground
//plane { y*-1, 0 pigment {color rgb <0.2,0.5,0.3>} hollow }
//object {ArchDoor}
object {Room}
//object {Cup translate<0,0,100> pigment{Red}}
//object{Candle1}
object{Altar translate<0,0,12*8>}
object{Altar rotate<0,180,0> translate<0,0,12*33>}
//object {RoomColumn translate<0,0,100>}
/*object{Sculpture2
 scale 1
 translate<0,0,12*10>
 }*/
