
//
// MYTREE.POV
// this is a modified version of "sample-1.pov"
// "sample-1" was a sample file for "ptd_tree.inc"
// this file needs "mytree.inc", which is a modified
// version of ptd_tree
//
// cloud textures are modified versions of the
// textures in "skies.inc"
//

// Set up a simple scene.

        #include "colors.inc"
        #include "textures.inc"
        #include "skies.inc"
        #include "golds.inc"
        #include "stones.inc"
        #include "glass.inc"

        #default { finish { Shiny } }

        camera { location < 0, 8, -22>
        look_at < -3, 7, 0> }

        light_source { < -10, 70, 100 > color rgb 1 }
        light_source { <    0, 10, 100 > color White shadowless }

#declare P_Cloud9 =
pigment {
    wrinkles
    turbulence 0.65
    octaves 6
    omega 0.7
    lambda 2
    color_map {
        [0.0, 0.1   color red 0.85 green 0.85 blue 0.85
                    color red 0.75 green 0.75 blue 0.75]
        [0.1, 0.5   color red 0.75 green 0.75 blue 0.75
                    color rgb <0.4, 0.4, 0.4>  ]
        [0.5, 1.001 color rgb <0.4, 0.4, 0.4>
                    color rgb <0.4, 0.4, 0.4> ]
    }
    scale <6, 1, 6>
}

#declare S_Cloud9 =
sky_sphere {
    pigment {
        gradient y
        pigment_map {
            [0.10 rgb .4 ]
            [0.25 P_Cloud9 scale 0.15 ]
        }
    }
}

        background { White }
        sky_sphere { S_Cloud9 rotate y * 180 }

        plane { y, 0
                pigment {
                  bozo
                  color_map {
                    [0 color rgb .8]
                    [1 color rgb 1]
                  }
                  turbulence 1
                  scale 3
                }
                //normal { crackle 1 scale 1 }
                finish { specular 0 diffuse .5 ambient .5 }
         }

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Now set all of the variables for the tree. read "ptd_tree.txt" to
// find out what all these things do!
//
        #declare TREE_RAND = seed(0)
        #declare Wiggle_Flag = on
        #declare Branches_On_End_Flag = on

        #declare Number_Of_Large_Branches = 5
        #declare Number_Of_Medium_Branches = 6
        #declare Number_Of_Small_Branches = 5
        #declare Number_Of_Tiny_Branches = 5

        #declare Large_Branch_Minimum_Angle = 20
        #declare Large_Branch_Maximum_Angle = 80

        #declare Medium_Branch_Minimum_Angle = 20
        #declare Medium_Branch_Maximum_Angle = 80

        #declare Small_Branch_Minimum_Angle = 20
        #declare Small_Branch_Maximum_Angle = 80

        #declare Tiny_Branch_Minimum_Angle = 20
        #declare Tiny_Branch_Maximum_Angle = 80

        #declare Tree_Trunk_Size = 7

        #declare Large_Branch_Size_Min = 3.5
        #declare Large_Branch_Size_Max = 4

        #declare Medium_Branch_Size_Min = 2.5
        #declare Medium_Branch_Size_Max = 3.5

        #declare Small_Branch_Size_Min = 0.5
        #declare Small_Branch_Size_Max = 3.5

        #declare Tiny_Branch_Size_Min = 0
        #declare Tiny_Branch_Size_Max = 2.0


        #declare Leaf_Type = -1

        #declare TREE_MESH_SIZE = 200

        #declare Leaf_Texture = texture { T_Stone18 scale 0.5 }
        #declare Bark_Texture = texture { T_Stone14
                normal { bumps 2.0 scale 0.1 } }


//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Now go and build the tree, then show it.

        #include "mytree.inc"

        object { Complete_Tree rotate y * 180 }

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// End of this file.
