
// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3
// Desc:
// Date: 1/18/97 - 2/23/97
// Auth:


// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions
#include "glass.inc"
#include "metals.inc"


#include "flasks.inc" //contains the glass flask objects
//#include "coil.inc"   //contains the coil object ## never finished it!!
#include "area.inc"
#include "syringe.inc"
//#include "test.inc"

global_settings { assumed_gamma 1.8 }
global_settings { ambient_light  3 }       
global_settings { max_trace_level 20 }




//visible objects

object { erlen_fifty translate <-10, 0, 15> }
object { grad_10 translate <-14, 6.725 + 0.25, 19> }
object { pear_25 
			translate <0, -8, 0>
			scale 0.44
			rotate <0, 45, 0>   // this move is only to orient the label
			rotate <0, 0, -100>
			rotate <0, 30, 0>
			translate < -6, 1.9, 18>
		}
object { syringe  
			rotate <0, 30, 0>
			translate <-11, 0.4, 10> }
object { syringe
			rotate <0, 40, 0>
			translate <-14.5, 0.4, 9.5> }
			
			
// objects that should not be directly visible

object { erlen_fifty translate <-25, 0, 17> }

object { grad_10 rotate <0, 90, 0> translate <-3, 6.725 + 0.25, 4> }
object { grad_10 rotate <0, 192, 0> translate <-21, 6.725 + 0.25, 11> }

object { pear_25
			translate <0, -8, 0>
			scale 0.44
			rotate <0, -45, 0>
			rotate <0, 0, 100>
			rotate <0, 30, 0>
			translate <-19, 1.9, 17>
		}
		
object { syringe translate <-6, 0.4, 2> }



camera
{
  perspective
  location  <-10 , 8 ,-15>
  look_at   <-10 , 5, 5>
  angle 25
}



/* this is a pretty good camera
camera
{
  perspective
  location  <-10 , 5 ,-10>
  look_at   <-7 , 1, 5>
  angle 25
}

*/



light_source
{
  0*x
  color red 1.0  green 1.0  blue 1.0
  translate <-60, 10, -21>
}

/*
light_source
{
  0*x
  color red 1.0 green 1.0 blue 1.0
  translate <-5, 12, -20>
}
*/














/*
//back wall
box
{
  <-100, -100, 50>
  < 100,  500,  50.1>
  texture {
  pigment { White }
  //checker
  //  color red .5 green .5 blue .7
  //  color red 0 green 1 blue 0
  //}
  //scale <9,9,1>
  }

}

box { <-100, -100, -50>, <100, 100, -50.1>
      pigment {White}
}

*/



/* old version of pear
lathe {
    cubic_spline
    18,
    <0, 0>, <1, 1>, <1.8, 2>, <2.6, 3>, <3.2, 4>,
    <3.7, 5>, <4.2, 6>, <4.5, 7>, <4.3, 8>, <3.6, 9>,
    <2, 10>, <2, 10.1>, <2, 11>, <2, 12>, <1.6, 12>,
    <1.6, 11>, <1.6, 10.1>, <1.6, 10>
    //sturm
    pigment {Red}
  }

*/

// here is the pear shaped flask
/* taken out for the time-being

*/


// 50 ml rbf
/*
lathe {
      cubic_spline
      25,
      <0, 0>, <1, 0.19>, <1.44, 0.5>, <1.89, 1>, <2.12, 1.5>
      <2.24, 2>, <2.24, 2.5>, <2.10, 3>, <1.85, 3.5>, <1.38, 4>,
      <1, 4.2>, <1, 5.2>,

      <0.8, 5.2>, <0.8, 4.2>, <1.18, 4>, <1.65, 3.5>, <1.9, 3>,
      <2.04, 2.5>, <2.04, 2>, <1.92, 1.5>, <1.69, 1>, <1.24, 0.5>,
      <0.8, 0.19>, <0, 0.19>, <0, 0>
      //sturm
      pigment {
         image_map {
           png "test.png"
           map_type 1
         }
       }
    }
*/
//end roundbottom












