// Persistence Of Vision raytracer version 3.0 sample file.
// File by Dieter Bayer

#version 3.0

#include "colors.inc"
#include "glass.inc"
#include "skies.inc"
#include "woods.inc"
#include "stones.inc"
#include "round.inc"
#include "metals.inc"

global_settings {
  assumed_gamma 2.2
  ambient_light White
  max_trace_level 35
  max_intersections 200
}

#declare H = 750000
camera {
   location <-1.25, H+14, -150>
   angle 3
   look_at <-1.25, H+.8, 0>
}

light_source{ <0, H+12, -10>
  color Gray50 
  area_light <1, 0, 0>, <0, 0, 1>, 3, 3
  adaptive 1
  jitter
}
light_source{ <1.5, H+12, -12>
  color White
  area_light <1, 0, 0>, <0, 0, 1>, 3, 3
  adaptive 1
  jitter
}
light_source{ <-8, H+20, 25>      // sun
  color rgb <.9,.9,.8>
  area_light <1, 0, 0>, <0, 0, 1>, 3, 3
  adaptive 1
  jitter
}

background { White }
sky_sphere { S_Cloud2 scale .05 rotate<11.025, -20, -3>}

fog {
  distance 50
  color rgbt<.1, .1, .1, 0.9>
  turbulence 0.2
  turb_depth 0.3
}

/***************************************************Wall**********************************************************/

difference { // wall
  box {
    <20, 20, 2> <-20, -20, 2.5>
    pigment {
      image_map {
        gif "wallpaper.gif"
      }
      translate <.29, .2, 0>
      scale <10, 4, 1>
    }
  }
  box {
    <2.25, -.25, 0> <-2.25, 2.45, 3>
    pigment {color LightBlue}
  }
  scale 1.5
  translate <0, H, 0>
}
box {
  <20, 20, 2.5> <-20, 20.1, -20>
  pigment { color White }
  scale <10, 1, 4>
  translate <0, H, 0>
}
box {
  <20, 20, 2.5> <20.1, -20, -20>
    pigment {
      image_map {
        gif "wallpaper.gif"
      }
    }
  translate <0, H, 0>
}
box {
  <-20.1, 20, 2.5> <-20, -20, -20>
    pigment {
      image_map {
        gif "wallpaper.gif"
      }
    }
  translate <0, H, 0>
}

/****************************************************Window********************************************************/

#declare P_Brass   = color rgb <0.65, 0.5, 0.25>
#declare F_MetalD  =
finish {
    //ambient 0.15
    brilliance 3
    diffuse 0.7
    metallic
    specular 0.80
    roughness 1/250
    reflection 0.25
}
#declare T_Brass = texture { pigment { P_Brass } finish { F_MetalD  } }
#declare screw =
  difference {
    cone {
      <0, 0, .23>, 0 <0, 0, .19> .02
      texture { T_Brass }
    }
    box {
      <-.1, .003, .15> <.1, -.003, .1975>
      texture { T_Brass }
    }
  }

#declare cut_out =
  cone {
    <0, 0, .23>, 0 <0, 0, .19> .025
    texture { T_Brass }
  }

union {  // handle
  difference {
    blob {
      threshold 0.6
      sphere {<0, 0, 0> .15, .9 scale <8, 1.5, 1.2>}
      cylinder {<.45, 0, .085>, <.45, 0, .2> .1, .95 scale <1, .75, 1>}
      cylinder {<-.45, 0, .085>, <-.45, 0, .2> .1, .95 scale <1, .75, 1>}
      sphere {<.55, 0, .9> .25, .9 scale <1, 1, .25>}
      sphere {<-.55, 0, .9> .25, .9 scale <1, 1, .25>}
      texture { T_Brass }
    } // end blob
    object { cut_out translate <-.575, 0, 0> rotate <0, 0, 5> }
    object { cut_out translate <-.575, 0, 0> rotate <0, 0, -5> }
    object { cut_out translate <.575, 0, 0> rotate <0, 0, 5> }
    object { cut_out translate <.575, 0, 0> rotate <0, 0, -5> }
  } // end difference
  object { screw rotate <0, 0, 10> translate <-.575, 0, .02> rotate <0, 0, 5> }
  object { screw rotate <0, 0, 50> translate <-.575, 0, .02> rotate <0, 0, -5> }
  object { screw rotate <0, 0, 30> translate <.575, 0, .02> rotate <0, 0, 5> }
  object { screw rotate <0, 0, 80> translate <.575, 0, .02> rotate <0, 0, -5> }
  scale .75
  rotate <0, 0, 0>
  translate <1, H-.15, 2.88>
} // end union

union { // window
  object { Rounded_Box
    pigment { color White }
    //finish { reflection .005 }
    scale <7.75, .225, 1>
    translate <0, -.45, .10>
  }
  object { Rounded_Box
    pigment { color White }
    //finish { reflection .005 }
    scale <.5, 8.1, .3>
    rotate <0, 5, 0>
    translate <-3.375, 3.4, .35>
  }
  object { Rounded_Box
    pigment { color White }
    //finish { reflection .005 }
    scale <.15, 8, .15>
    translate <-3.07, 3.45, .5>
  }
  cylinder {
    <0, -.375, 0> <0, 7.45, 0> .28
    pigment { color White }
    //finish { reflection .005 }
    translate <-3.285, 0, .55>
  }
  /*object { Rounded_Box
    pigment { color White }
    finish { reflection .005 }
    scale <.5, 8.1, .3>
    rotate <0, 5, 0>
    translate <3.375, 3.4, .35>
  }
  object { Rounded_Box
    pigment { color White }
    finish { reflection .005 }
    scale <.15, 8, .15>
    translate <3.07, 3.45, .5>
  }
  cylinder {
    <0, -.375, 0> <0, 7.45, 0> .28
    pigment { color White }
    finish { reflection .005 }
    translate <3.285, 0, .55>
  } */
  difference {
    box {
      <.25, 0, .15> <-.25, 4, -.15>
      pigment { color White }
      //finish { reflection .005 }
    }
    box {
      <.5, 5, .5> <-.5, -.1, -.5>
      pigment { color White }
      //finish { reflection .005 }
      rotate <0, 45, 0>
      translate <.72, 0, -.30>
    }
    rotate <0, 0, 0>
    translate <-2.8, 0, .7>
  }
  /*difference {
    box {
      <.25, 0, .15> <-.25, 4, -.15>
      pigment { color White }
      finish { reflection .005 }
    }
    box {
      <.5, 5, .5> <-.5, -.1, -.5>
      pigment { color White }
      finish { reflection .005 }
      rotate <0, 45, 0>
      translate <-.72, 0, -.30>
    }
    rotate <0, 0, 0>
    translate <2.8, 0, .7>
  }
  difference {
    box {
      <4, .25, .15> <-4, -.25, -.15>
      pigment { color White }
      finish { reflection .005 }
    }
    box {
      <5, .5, .5> <-5, -.5, -.5>
      pigment { color White }
      finish { reflection .005 }
      rotate <45, 0, 0>
      translate <0, -.72, -.30>
    }
    rotate <0, 0, 0>
    translate <0, 4, .7>
  }  */
  difference {
    box {
      <4, .25, .15> <-4, -.25, -.15>
      pigment { color White }
      //finish { reflection .005 }
    }
    box {
      <5, .5, .5> <-5, -.5, -.5>
      pigment { color White }
      //finish { reflection .005 }
      rotate <45, 0, 0>
      translate <0, .72, -.30>
    }
    rotate <0, 0, 0>
    translate <0, -.1, .7>
  }
  box {
    <3, 8, 0> <-3, 0, .1>
    texture {
      pigment { color rgbf<1.0, 1.0, 1.0, 1.0> }
      finish  { F_Glass1 }
    }
    translate <0, 0, .7>
  }
  translate <0, H, 2.5>
} // end union window

/****************************************************Dresser*******************************************************/

union { // dresser
  superellipsoid { <.1, .1>
    texture {
      T_Wood32
      finish { reflection 0.05 }
      rotate<0, 90, 0>
    }
    scale <2, .05, 1.5>
    rotate <0, 0, 0>
  }
  superellipsoid { <.05, .05>
    texture {
      T_Wood32
      finish { reflection 0.05 }
      rotate<0, -90, 0>
    }
    scale <1.85, 1, 1.4>
    rotate <0, 0, 0>
    translate <0, -.955, .1>
  }
  superellipsoid { <.05, .1>
    texture {
      T_Wood32
      finish { reflection 0.05 }
      rotate<0, 0, 0>
      translate<1, -1.25, 0>
    }
    scale <1.65, .4, .5>
    rotate <0, 0, 0>
    translate <0, -.6, -.85>
  }
  cylinder {
    <0, -.6, 0> <0, -.6, -1.4> .05
    texture {T_Brass}
  }
  difference {
    sphere {
      <0, 0, 0> .09
      texture {T_Brass}
    }
    box {
      <.2, .2, .2> <-.2, -.2, 0>
      texture {T_Brass}
    }
    scale <1, 1, .5>
    translate <0, -.6, -1.4>
  } // end difference
  scale <1.85, 1.85, 2.25>
  translate <0, H-.7, -1>
}  // end union dresser
/*union {
  object { quarter scale .45 translate <0, 0, 0>}
  object { nickle scale .45 rotate <180, 20, -7> translate <.25, .03, 0> }
  object { quarter scale .45 rotate <0, 70, 180> translate <-.1, .0175, .5> }
  object { dime scale .45 rotate <-7, 0, 4> translate <.1, .015, .3> }
  rotate <-2.5, 0, 0>
  translate <-2.5, H-.59, -3.5>
} */

/****************************************************Lamp*****************************************************/

#declare Glass =
texture {
    finish { F_Glass4 caustics .6 }
    pigment { color rgbf <1, 1, 1, .8> }
}

#declare swivl =
  union {
    torus { .2, .05
      texture { T_Chrome_1A }
      translate <0, -.35, 0>
    }
    torus { .17, .04
      texture { T_Chrome_1A }
      translate <0, -.28, 0>
    }
    torus { .15, .03
      texture { T_Chrome_1A }
      translate <0, -.23, 0>
    }
    torus { .125, .03
      texture { T_Chrome_1A }
      translate <0, -.185, 0>
    }
    sphere {
      <0, 0, 0> .2
      texture { T_Chrome_1A }
    }
  }

#declare rod =
  box {
    <.2, .25,.2> <-.2, -.25, -.2>
    texture { T_Chrome_1A }
    rotate <0, 45, 0>
  }

#declare tooth_swivl =
  difference {
    object { swivl }
    difference {
      cylinder {
        <-.4, 0, 0> <.1414, 0, 0> .201
        texture { T_Chrome_1A }
      }
      #declare Count=0
      #while (Count < 180)
        object{ rod rotate <Count, 0, 0> translate <.2775, 0, 0>}
        #declare Count=Count+15
      #end
    }
  }

#declare Lightbulb =
  merge {
    sphere { <0,0,0>,1 }
    cylinder { <0,0,1>, <0,0,0>, 1
      scale <0.35, 0.35, 1.0>
      translate  0.5*z
    }
    texture {
      pigment {color rgb <1, 1, 1>}
      finish {ambient .8 diffuse .6}
    }
    rotate -90*x
    scale .5
  }

union { // lamp
  union {
    union {
      object { tooth_swivl }
      union { // screw
        blob {
          threshold 0.6
          cylinder {<.1, 0, 0> <-.1, 0, 0>.75, 1 scale <1, 1, .85>}
          cylinder {<.3 1, -.015>, <.3, -1, -.015> .4, -.85}
          cylinder {<-.3, -1, -.015>, <-.3, 1, -.015> .4, -.85}
          texture { T_Chrome_1A }
          scale <1, 1.5, 1>
        } // end blob
        blob {
          threshold 0.6
          cylinder {<0, 0, -.2>, <0, 0, -.4> .22, 1}
          texture { T_Chrome_1A }
        } // end blob
        scale .45
        rotate <0, 90, 0>
        translate <.35, 0, 0>
      } // end union
    }
    #declare angl1 = 7.5*18
    object { tooth_swivl rotate <angl1, 180, 0>}
    cylinder {
      <0, 0, 0> <0, -4, 0> .2
      texture { T_Wood1 }
      translate <0, -.35, 0>
      rotate <angl1, 180, 0>
    }
    /*cylinder {
      <0, 0, 0> <0, -4, 0> .05
      pigment { color Gray20 }
      translate <0, -.35, 0>
      rotate <angl1, 180, 0>
    }*/
    translate <0, 1.2, 0>
  }
  union {
    union {
      object { tooth_swivl }
      union { // screw
        blob {
          threshold 0.6
          cylinder {<.1, 0, 0> <-.1, 0, 0>.75, 1 scale <1, 1, .85>}
          cylinder {<.3 1, -.015>, <.3, -1, -.015> .4, -.85}
          cylinder {<-.3, -1, -.015>, <-.3, 1, -.015> .4, -.85}
          texture { T_Chrome_1A }
          scale <1, 1.5, 1>
        } // end blob
        blob {
          threshold 0.6
          cylinder {<0, 0, -.2>, <0, 0, -.4> .22, 1}
          texture { T_Chrome_1A }
        } // end blob
        scale .45
        rotate <0, 90, 0>
        translate <.35, 0, 0>
      } // end union
    }
    #declare angl2 = -7.5*11
    object { tooth_swivl rotate <angl2, 180, 0>}
    cylinder {
      <0, 0, 0> <0, -3, 0> .2
      texture { T_Wood1 }
      translate <0, -.35, 0>
      rotate <angl2, 180, 0>
    }
    /*cylinder {
      <0, 0, 0> <0, -3, 0> .05
      pigment { color Gray20 }
      translate <0, -.35, 0>
      rotate <angl2, 180, 0>
    }*/
    translate <0, 4.65, 0>
    rotate <180-angl1, 0, 0>
    translate <0, 1.2, 0>
  }
  union {
    object {
      union {
        difference {
          blob {
            threshold 0.6
            sphere { <0, 0, 0> 1.5, 1}
            cylinder { <.5, .35, 0> <1.4, .45, 0> .35, .7}
            texture { T_Chrome_1A }
            rotate <0, 0, 0>
          }
          box {
            <2, 0, 2> <-2, -2, -2>
            texture { T_Chrome_1A }
          }
          box {
            <.775, 1, 1> <2, -1, -1>
            texture { T_Chrome_1A }
          }
          sphere {
            <0, 0, 0> .7
            texture { T_Chrome_1A }
          }
        } // end difference
        cylinder {
          <0, 0, 0> <.3, 0, 0> .1
          pigment { color Black }
          finish { reflection .01 }
          translate <.4, .3, 0>
        }
        object { Lightbulb
          scale .6
          rotate <0, 0, -90>
          translate <0, .35, 0>
        }
        blob {
          threshold 0.6
          cylinder { <0, .35, 0> <.3, .35, 0> .475, 1}
          texture { T_Chrome_1A }
          translate <.8, 0, 0>
        }
        cylinder {
          <0, 0, 0> <.2, 0, 0> .025
          texture { T_Chrome_1A }
          translate <1.2, .35, 0>
        }
        translate <-1.4, -.35, 0>
        rotate <0, 0, -90>
      }
      rotate <0, 0, 25>
      rotate <0, -75, 0>             // to rotate the lamp top
    }
    cylinder {
      <0, 0, 0> <0, -.3, 0> .135
      texture { T_Chrome_1A }
    }
    scale 2
    translate <0, -.05, 0>            // move lamp top to the end of the rod
    translate <0, 3.5, 0>
    rotate <180-angl2, 0, 0>
    translate <0, 4.65, 0>
    rotate <180-angl1, 0, 0>
    translate <0, 1.2, 0>
  }
  union { // base
    cylinder {
      <0, 0, 0> <0, .2, 0> 1
      texture { T_Chrome_1A }
    }
    sphere {
      <0, -.3, 0> .85
      texture { T_Chrome_1A }
    }
    torus { .65, .075
      texture { T_Chrome_1A }
      translate <0, .2, 0>
    }
    scale 1.5
  }
  scale .5
  rotate <0, -70, 0>
  translate <-2, H-.61, 0>
} // end union lamp

/****************************************************Hills****************************************************/

height_field {
  gif "HILL.gif"
  smooth
  pigment {
    image_map {
      gif "HILL.gif"
      map_type 0
    }
  }
  pigment { Green }
  translate <-.6, -.4, -.5>
  scale <37, 1.25, 27>
  translate <0, H-6, 90>
 }

/****************************************************Pig******************************************************/


#declare Pink = color red 0.737255 green 0.560784 blue 0.560784
#declare Pink_Glass =
texture {
    finish { F_Glass4 }
    pigment { color rgbf <1, 0.7, 0.7, 0.8> }
}

/*  difference { // body
    difference {
      blob {
        threshold 0.6
        cylinder {<-.175, 0, 0>, <.175, 0, 0>, 2, .9} // body
        cylinder {<0, -.7, 0>, <0, -1.2, 0> .25, .7 rotate<25, 0, 30> translate<.3, 0, -.1>} // front right
        cylinder {<0, -.7, 0>, <0, -1.2, 0> .25, .7 rotate<-25, 0, 30> translate<.3, 0, .1>} // front left
        cylinder {<0, -.7, 0>, <0, -1.15, 0> .25, .7 rotate<25, 0, -22> translate<-.4, 0, -.1>} // back right
        cylinder {<0, -.7, 0>, <0, -1.15, 0> .25, .7 rotate<-25, 0, -22> translate<-.4, 0, .1>} // back left
        sphere {<0, 0, 0> .9, 1 translate<1.35, .35, 0>}
        cylinder {<.6, 0, 0>, <.65, 0, 0> .725, 1 rotate<0, 0, -15> translate<1.45, .21, 0>}
        sphere {<0, 0, 0> .6, -1 translate<2.5, -.055, 0>}
        pigment {color Pink}
      }
      box {  // coin hole
        <.35 1, .075> <-.35, .3, -.075>
        pigment {color Clear}
      }
      union {
        sphere {
          <0, 0, 0>, .075
          pigment {color Pink}
          scale <1, 1.5, 1>
          rotate <20, 0, 0>
          translate <2.185, .08, .15>
        }
        sphere {
          <0, 0, 0>, .075
          pigment {color Pink}
          scale <1, 1.5, 1>
          rotate <-20, 0, 0>
          translate <2.185, .08, -.15>
        }
      } // end union
    } // end difference outer body
    blob {
      threshold 0.6
      cylinder {<-.175, 0, 0>, <.175, 0, 0>, 2, .9} // body
      cylinder {<0, -.7, 0>, <0, -1.2, 0> .25, .7 rotate<25, 0, 30> translate<.3, 0, -.1>} // front right
      cylinder {<0, -.7, 0>, <0, -1.2, 0> .25, .7 rotate<-25, 0, 30> translate<.3, 0, .1>} // front left
      cylinder {<0, -.7, 0>, <0, -1.15, 0> .25, .7 rotate<25, 0, -22> translate<-.4, 0, -.1>} // back right
      cylinder {<0, -.7, 0>, <0, -1.15, 0> .25, .7 rotate<-25, 0, -22> translate<-.4, 0, .1>} // back left
      sphere {<0, 0, 0> .9, 1 translate<1.35, .35, 0>}
      cylinder {<.6, 0, 0>, <.65, 0, 0> .725, 1 rotate<0, 0, -15> translate<1.45, .21, 0>}
      sphere {<0, 0, 0> .6, -1 translate<2.5, -.055, 0>}
      pigment {color Pink}
      scale <.94, .925, .925>
      translate <.01, .015, 0>
    } */


union { // body
  difference { // body
    difference {
      blob {
        threshold 0.6
        cylinder {<-.175, 0, 0>, <.175, 0, 0>, 2, .9} // body
        cylinder {<0, -.7, 0>, <0, -1.2, 0> .25, .7 rotate<25, 0, 30> translate<.3, 0, -.1>} // front right
        cylinder {<0, -.7, 0>, <0, -1.2, 0> .25, .7 rotate<-25, 0, 30> translate<.3, 0, .1>} // front left
        cylinder {<0, -.7, 0>, <0, -1.15, 0> .25, .7 rotate<25, 0, -22> translate<-.4, 0, -.1>} // back right
        cylinder {<0, -.7, 0>, <0, -1.15, 0> .25, .7 rotate<-25, 0, -22> translate<-.4, 0, .1>} // back left
        sphere {<0, 0, 0> .9, 1 translate<1.35, .35, 0>}
        cylinder {<.6, 0, 0>, <.65, 0, 0> .725, 1 rotate<0, 0, -15> translate<1.45, .21, 0>}
        sphere {<0, 0, 0> .6, -1 translate<2.5, -.055, 0>}
        texture {Pink_Glass}
      }
      box {  // coin hole
        <.35 1, .075> <-.35, .3, -.075>
        pigment {color Clear}
      }
      union {
        sphere {
          <0, 0, 0>, .075
          texture {Pink_Glass}
          scale <1, 1.5, 1>
          rotate <20, 0, 0>
          translate <2.185, .08, .15>
        }
        sphere {
          <0, 0, 0>, .075
          texture {Pink_Glass}
          scale <1, 1.5, 1>
          rotate <-20, 0, 0>
          translate <2.185, .08, -.15>
        }
      } // end union
    } // end difference outer body
    difference { // inner body
      blob {
        threshold 0.6
        cylinder {<-.175, 0, 0>, <.175, 0, 0>, 2, .9} // body
        cylinder {<0, -.7, 0>, <0, -1.2, 0> .25, .7 rotate<25, 0, 30> translate<.3, 0, -.1>} // front right
        cylinder {<0, -.7, 0>, <0, -1.2, 0> .25, .7 rotate<-25, 0, 30> translate<.3, 0, .1>} // front left
        cylinder {<0, -.7, 0>, <0, -1.15, 0> .25, .7 rotate<25, 0, -22> translate<-.4, 0, -.1>} // back right
        cylinder {<0, -.7, 0>, <0, -1.15, 0> .25, .7 rotate<-25, 0, -22> translate<-.4, 0, .1>} // back left
        sphere {<0, 0, 0> .9, 1 translate<1.35, .35, 0>}
        cylinder {<.6, 0, 0>, <.65, 0, 0> .725, 1 rotate<0, 0, -15> translate<1.45, .21, 0>}
        sphere {<0, 0, 0> .6, -1 translate<2.5, -.055, 0>}
        texture {Pink_Glass}
      }
      box {  // coin hole
        <.35 1, .075> <-.35, .3, -.075>
        pigment {color Clear}
     }
      scale .99
    } // end difference inner body
  } // end difference body
  union { // ears
    difference {  // ear right
      blob {
        threshold 0.6
        sphere {<0, 0, 0>, 1, .9}
        cylinder {<0, 0, 0>, <0, .8, 0>, .5, .9}
        cylinder {<0, 1, 0>, <0, -.5, 0>, .25, -.9  rotate<-20, 0, 0> translate<0, 0, -.1>}
        cylinder {<0, 1, 0>, <0, -.5, 0>, .3, -.9  rotate<-20, 0, 0> translate<0, 0, -.2>}
        cylinder {<0, 1, 0>, <0, -.5, 0>, .35, -.9  rotate<-20, 0, 0> translate<0, 0, -.3>}
        texture {Pink_Glass}
        scale .3
        rotate <-7, 0, 0>
        translate <0, .575, 0>
        rotate <0, 0, 30>
      }
      sphere {
        <0, 0, 0>, .595
        texture {Pink_Glass}
      }
    }
    difference {  // ear left
      blob {
        threshold 0.6
        sphere {<0, 0, 0>, 1, .9}
        cylinder {<0, 0, 0>, <0, .8, 0>, .5, .9}
        cylinder {<0, 1, 0>, <0, -.5, 0>, .25, -.9  rotate<-20, 0, 0> translate<0, 0, -.1>}
        cylinder {<0, 1, 0>, <0, -.5, 0>, .3, -.9  rotate<-20, 0, 0> translate<0, 0, -.2>}
        cylinder {<0, 1, 0>, <0, -.5, 0>, .35, -.9  rotate<-20, 0, 0> translate<0, 0, -.3>}
        texture {Pink_Glass}
        scale .3
        rotate <-7, 0, 0>
        translate <0, .575, 0>
        rotate <0, 0, -30>
      }
      sphere {
        <0, 0, 0>, .595
        texture {Pink_Glass}
      }
    }
    rotate <0, -90, 0>
    translate <1.25, .3, 0>
  } // end union ears
  union { // right eye
    difference {
      sphere {
        <0, 0, 0>, .1
        pigment {color Black}
        finish {reflection .15 phong 0.9 phong_size 60}
        scale <1, 1.5, 1>
        translate <.53, 0, 0>
        rotate <0, 15, 45>
      }
      sphere {
        <0, 0, 0>, .595
        pigment {color Black}
      }
      hollow
    }
    difference {
      difference {
        torus {
          .4, .2
          pigment {color Black}
          finish {reflection .15 phong 0.9 phong_size 60}
          rotate <0, 0, 0>
        }
        box {
          <1, .5, 0> <-1, -.5, -.75>
          pigment {color Black}
        }
        box {
          <-.75, .5, 1> <0, -.5, -1>
          pigment {color Black}
        }
        scale .35
        rotate <0, 45, 90>
        translate <.51, 0, 0>
        rotate <0, 15, 55>
      }
      sphere {
        <0, 0, 0>, .595
        pigment {color Black}
      }
    }
    hollow
    rotate <0, 0, 0>
    translate <1.23, .31, 0>
  } // end right eye
  union { // left eye
    difference {
      sphere {
        <0, 0, 0>, .1
        pigment {color Black}
        finish {reflection .15 phong 0.9 phong_size 60}
        scale <1, 1.5, 1>
        translate <.53, 0, 0>
        rotate <0, -15, 45>
      }
      sphere {
        <0, 0, 0>, .595
        pigment {color Black}
      }
      hollow
    } // end difference left eye
    difference {
      difference {
        torus {
         .4, .2
          pigment {color Black}
          finish {reflection .15 phong 0.9 phong_size 60}
          rotate <0, 0, 0>
        }
        box {
          <1, .5, 0> <-1, -.5, -.75>
          pigment {color Black}
        }
        box {
          <-.75, .5, 1> <0, -.5, -1>
          pigment {color Black}
        }
        scale .35
        rotate <0, 45, 90>
        translate <.51, 0, 0>
        rotate <0, -15, 55>
      }
      sphere {
        <0, 0, 0>, .595
        pigment {color Black}
      }
    }
    hollow
    rotate <0, 0, 0>
    translate <1.23, .31, 0>
  } // end left eye
  union { // tail
    cylinder {
      <0, 0, 0>, <0, .1, 0>, .05
      texture {Pink_Glass}
    }
    difference {
      torus {
        .1, .05
        texture {Pink_Glass}
      }
      box {
        <.2, .1, 0> <-.2, -.1, -.2>
        texture {Pink_Glass}
      }
      box {
        <.2, .1, .2> <0, -.1, -.2>
        texture {Pink_Glass}
      }
      rotate <-90, 0, 0>
      translate <.1, .1, 0>
    } // end difference
    difference {
      torus {
        .1, .05
        texture {Pink_Glass}
      }
      box {
        <.2, .1, 0> <-.2, -.1, -.2>
        texture {Pink_Glass}
      }
      box {
        <.2, .1, .2> <0, -.1, -.2>
        texture {Pink_Glass}
      }
      rotate <0, 90, 0>
      translate <0, 0, -.1>
      rotate <10, 0, 0>
      translate <.1, .2, 0>
    } // end difference
    difference {
      torus {
        .2, .05
        texture {Pink_Glass}
      }
      box {
        <.4, .1, 0> <-.4, -.1, -.4>
        texture {Pink_Glass}
      }
      box {
        <.4, .1, .4> <0, -.1, -.4>
        texture {Pink_Glass}
      }
      rotate <0, 180, 0>
      translate <-.2, 0, -.2>
      rotate <10, 0, -10>
      translate <.1937, .182, .105>
    } // end difference
    difference {
      torus {
        .2, .05
        texture {Pink_Glass}
      }
      box {
        <.4, .1, 0> <-.4, -.1, -.4>
        texture {Pink_Glass}
      }
      box {
        <.4, .1, .4> <0, -.1, -.4>
        texture {Pink_Glass}
      }
      rotate <0, -90, 0>
      translate <-.2, 0, -.2>
      rotate <-10, 0, -10>
      translate <.21875, .319, .105>
    } // end difference
    difference {
      torus {
        .2, .05
        texture {Pink_Glass}
      }
      box {
        <.4, .1, 0> <-.4, -.1, -.4>
        texture {Pink_Glass}
      }
      box {
        <.4, .1, .4> <0, -.1, -.4>
        texture {Pink_Glass}
      }
      translate <-.2, 0, -.2>
      rotate <-10, 0, 10>
      translate <.2065, .4565, .0975>
    } // end difference
    difference {
      torus {
        .175, .05
        texture {Pink_Glass}
      }
      box {
        <.4, .1, 0> <-.4, -.1, -.4>
        texture {Pink_Glass}
      }
      box {
        <.4, .1, .4> <0, -.1, -.4>
        texture {Pink_Glass}
      }
      rotate <0, 90, 0>
      translate <-.175, 0, -.175>
      rotate <-10, 0, 10>
      translate <.182, .452, .09775>
    } // end difference
    difference {
      sphere {
        <0, 0, 0>, .05
        texture {Pink_Glass}
        hollow
      }
      box {
        <-.06, -.06, .06> <-.06, -.06, 0>
        pigment {color Clear}
      }
      translate <.1855, .422, -.08>
    }
    scale 1
    rotate <0, -45, 60>
    translate <-.8, .5, 0>
  }  // end union tail

    rotate <0, 0, -1>
    rotate <0, 50, 0>
    translate <0, H+.47, -2>
  } // end difference body


/**************************************************Tree**************************************************/

        #declare TREE_RAND = seed(2)
        #declare Wiggle_Flag = on
        #declare Branches_On_End_Flag = on

        #declare Number_Of_Large_Branches = 4
        #declare Number_Of_Medium_Branches = 4
        #declare Number_Of_Small_Branches = 5

        #declare Large_Branch_Minimum_Angle = 20
        #declare Large_Branch_Maximum_Angle = 50

        #declare Medium_Branch_Minimum_Angle = 20
        #declare Medium_Branch_Maximum_Angle = 50

        #declare Small_Branch_Minimum_Angle = 20
        #declare Small_Branch_Maximum_Angle = 50

        #declare Tree_Trunk_Size = 6

        #declare Large_Branch_Size_Min = 2
        #declare Large_Branch_Size_Max = 3

        #declare Medium_Branch_Size_Min = 2
        #declare Medium_Branch_Size_Max = 3

        #declare Small_Branch_Size_Min = 2
        #declare Small_Branch_Size_Max = 3

        #declare Leaf_Type = 5

        #declare TREE_MESH_SIZE = 200

        #declare Leaf_Texture = texture { T_Stone18 scale 0.5 }
        #declare Bark_Texture = texture { T_Stone14
                normal { bumps 2.0 scale 0.1 } }

        #include "ptd_tree.inc"

        object { Complete_Tree rotate y * 140 scale .45 translate <4.5, H-8.25, 75>}


