//=============================================================================
// Definition of Chess Boards
//
// Version 1.0 - Initial release; January 5, 1997
// by Peter R. Jones  [pjones@powerup.com.au]
//
// This file should be used in conjunction with "CHESSSET.INC"
//
// You may use this file to generate your own scenes.  However, if you do so,
// please acknowledge my efforts in designing this chess set - and I would be
// interested to hear about any pictures generated with this file.  Thanks.
// You may also modify the design of the pieces, or add more textures, or make
// whatever other "improvements" you can think of - on two conditions:
//    1: Please leave this portion of the comment intact.
//    2: Please email me a copy of your modifications - any that I choose to
//       incorporate into my own file will, of course, be acknowledged.
//=============================================================================

#include "woods.inc"

#ifndef (Chess_SquareSize)
  #declare Chess_SquareSize = 30
  #end

#ifndef (Chess_BoardBorder)
  #declare Chess_BoardBorder = 25
  #end

#ifndef (Chess_DividerW)
  #declare Chess_DividerW = 2
  #end

#ifndef (Chess_DividerH)
  #declare Chess_DividerH = 1
  #end

#ifndef (Chess_BoardThick)
  #declare Chess_BoardThick = 25
  #end

#declare board_Black = texture { T_Wood32 scale 30 rotate <10,10,10> }
#declare board_White = texture { T_Wood31 scale 30 rotate <7,7,8> }
#declare board_BoxT = texture { T_Wood34 translate <50,50,50> scale <20,10,20> rotate <5,5,5>  }
#declare board_DivT = texture {
  pigment { color Yellow }
  }

#declare board_Square = object {
  box {
    <0-Chess_SquareSize/2,Chess_BoardThick/2,0-Chess_SquareSize/2>,
    <Chess_SquareSize/2,Chess_BoardThick,Chess_SquareSize/2>
    }
  }

#declare brdSize = 8*Chess_SquareSize + 9*Chess_DividerW + 2*Chess_BoardBorder
#declare brdSize1 = brdSize - 2*Chess_BoardBorder

#declare board_Box = difference {
  box { <0-brdSize/2,0,0-brdSize/2>, <brdSize/2,Chess_BoardThick,brdSize/2> }
  box { <0-brdSize1/2,Chess_BoardThick/2,0-brdSize1/2>, <brdSize1/2,Chess_BoardThick+1,brdSize1/2> }
  texture { board_BoxT }
  }

#declare board_Divider = object {
  box {
    <0-Chess_DividerW/2,Chess_BoardThick/2,0-brdSize1/2>,
    <Chess_DividerW/2,Chess_BoardThick + Chess_DividerH,brdSize1/2>
    }
  texture { board_DivT }
  }

#declare ChessBoard = union {
  object { board_Box }
  #declare idxDiv = -4
  #while (idxDiv < 5)
    object { board_Divider translate <idxDiv*(Chess_SquareSize + Chess_DividerW),0,0> }
    object { board_Divider translate <idxDiv*(Chess_SquareSize + Chess_DividerW),0,0> rotate <0,90,0>}
    #declare idxDiv = idxDiv + 1
    #end
  #declare idxSqrX = 1
  #while (idxSqrX < 9)
    #declare brdX = (idxSqrX-4.5)*(Chess_SquareSize+Chess_DividerW)
    #declare idxSqrY = 1
    #while (idxSqrY < 9)
      #declare brdY = (idxSqrY-4.5)*(Chess_SquareSize+Chess_DividerW)
      #if (mod((idxSqrX+idxSqrY),2) = 0)
        #declare brdColor = texture { board_Black }
      #else
        #declare brdColor = texture { board_White }
        #end
      object { board_Square translate <brdX,0,brdY> texture { brdColor } }
      #declare idxSqrY = idxSqrY + 1
      #end
    #declare idxSqrX = idxSqrX + 1
    #end
  }

#declare ChessSet = union {
  #declare idxPawn = 1
  #declare brdOfs = Chess_SquareSize + Chess_DividerW
  #while (idxPawn < 9)
    #declare brdX = (idxPawn-4.5)*brdOfs
    object { Pawn translate <brdX,Chess_BoardThick,-2.5*brdOfs> texture { T_ChessWhite } }
    object { Pawn translate <brdX,Chess_BoardThick,2.5*brdOfs> texture { T_ChessBlack } }
    #declare posWhite = <brdX,Chess_BoardThick,-3.5*brdOfs>
    #declare posBlack = <brdX,Chess_BoardThick,3.5*brdOfs>
    #switch (idxPawn)
      #case (1)
        object { Rook translate posWhite texture { T_ChessWhite } }
        object { Rook translate posBlack texture { T_ChessBlack } }
        #break
      #case (2)
        object { Knight translate posWhite texture { T_ChessWhite } }
        object { Knight translate posBlack texture { T_ChessBlack } }
        #break
      #case (3)
        object { Bishop translate posWhite texture { T_ChessWhite } }
        object { Bishop translate posBlack texture { T_ChessBlack } }
        #break
      #case (4)
        object { Queen translate posWhite texture { T_ChessWhite } }
        object { Queen translate posBlack texture { T_ChessBlack } }
        #break
      #case (5)
        object { King translate posWhite texture { T_ChessWhite } }
        object { King translate posBlack texture { T_ChessBlack } }
        #break
      #case (6)
        object { Bishop translate posWhite texture { T_ChessWhite } }
        object { Bishop translate posBlack texture { T_ChessBlack } }
        #break
      #case (7)
        object { Knight translate posWhite texture { T_ChessWhite } }
        object { Knight translate posBlack texture { T_ChessBlack } }
        #break
      #case (8)
        object { Rook translate posWhite texture { T_ChessWhite } }
        object { Rook translate posBlack texture { T_ChessBlack } }
        #break
      #end
    #declare idxPawn = idxPawn + 1
    #end
  }

