//=============================================================================
// Definition of Textures for Chess Sets
//
// Version 1.0 - Initial release; January 5, 1997
// by Peter R. Jones  [pjones@powerup.com.au]
//
// This file should be used in conjunction with "CHESSSET.INC"
//
// You may use this file to generate your own scenes.  However, if you do so,
// please acknowledge my efforts in designing this chess set - and I would be
// interested to hear about any pictures generated with this file.  Thanks.
// You may also modify the design of the pieces, or add more textures, or make
// whatever other "improvements" you can think of - on two conditions:
//    1: Please leave this portion of the comment intact.
//    2: Please email me a copy of your modifications - any that I choose to
//       incorporate into my own file will, of course, be acknowledged.
//=============================================================================
// Textures currently defined in this file are as follows:
//
//   Chess_Wood             *Light and Dark Oak
//   Chess_Glass             Clear Glass and Dark-Brown Glass
//   Chess_Gold              Silver and Gold
//   Chess_Bronze            Pewter and Bronze
//   Chess_Stone            *Marble and Jade
//   Chess_Default           White and Black
//
// Each of these must have a corresponding value #declared by the file
// which #includes this file; otherwise the default textures will not
// be #declared.  Of course these textures may be used without the
// added nicety of automatically selecting a set of textures for the
// chess set...
//=============================================================================


//=============================================================================
// Texture declarations follow here:

#declare TW_Chess_Glass = texture {
  pigment { color rgbf <0.93,0.93,0.99,0.75> }
  finish {
    ambient 0.1
    diffuse 0.1
    reflection 0.1
    refraction 1
    ior 1.45
    specular 0.8
    roughness 0.003
    phong 1.0
    phong_size 400
    }
  }

#declare TB_Chess_Glass = texture {
  pigment { color rgbf <0.7,0.5,0.1,0.70> }
  finish {
    ambient 0.1
    diffuse 0.1
    reflection 0.25
    refraction 1
    ior 1.5
    specular 1
    roughness 0.001
    }
  }

#declare TW_Chess_Default = texture {
  pigment { color rgb <1,1,0.95> }
  finish { phong 0.9 phong_size 40 }
  }

#declare TB_Chess_Default = texture {
  pigment { color rgb <0.05,0.05,0.05> }
  finish { phong 0.9 phong_size 40 }
  }

//=============================================================================
// The following section is the intelligent part.

#ifndef (ChessSet_Texture)
#declare ChessSet_Texture = 99
#end

#switch (ChessSet_Texture)
  #case (2)
    #declare T_ChessWhite = texture { TW_Chess_Glass }
    #declare T_ChessBlack = texture { TB_Chess_Glass }
    #break
  #else              // case 99 or not declared
    #declare T_ChessWhite = texture { TW_Chess_Default }
    #declare T_ChessBlack = texture { TB_Chess_Default }
  #end

