

// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions


// create a regular point light source
light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <-20, 40, -20>
}

camera
{
  location  <0.0 , 2.0 ,-5.0>
  look_at   <0.0 , 0.0 , 0.0>
}


#declare P_Cloud2 =
pigment {
    wrinkles
    turbulence 0.65
    octaves 6
    omega 0.7
    lambda 2
    color_map {
         [0.0, 0.1   color Black
                    color Gray50]
        [0.1, 0.5   color Firebrick
                    color IndianRed ]
        [0.5, 1.001 color Red
                    color DustyRose]
    }
    scale <6, 1, 6>
}


#declare Hell_Sky =
sky_sphere {
    pigment {
        gradient y
        pigment_map {
            [0.00 rgb <0.184, 0.184, 0.309> ]
            [0.15 P_Cloud2 scale <0.05, 0.40, 0.05> rotate z*30 ]
            [0.45 P_Cloud2 scale <0.25, 0.15, 0.50> ]
        }
    }
}

// 
