#include "colors.inc"
#include "textures.inc"
#include "skies.inc"
#declare Quick_Glass=1  
#include "rb_glass.inc"


sky_sphere { S_Cloud2 }

//#declare CAM=1 // uncomment for top view
#ifdef(CAM)
camera {
       location < 0, 7, 0 >
       look_at  < 0, 0, 0 >
       }
#else
camera {
       location  < -2.5, 3.0, -2.5 >
       look_at   < -1.5, 2.45, 0 >
       }
#end


light_source { < 0, 25, 30 >  White*0.8 }
light_source { < -2, 7, -3 >  White
             spotlight
             point_at < -2,2,-1 >
             radius 10
             falloff 20
             }
light_source { < -1, 7.8, -1 > White*.80 shadowless }

declare Floor =  difference {
plane { y,0 pigment { checker White, Black } }
plane { z,6 pigment { Clear }  inverse }
}

declare Roof =  difference {
plane { y,8 pigment { White }  }
plane { z,6 pigment { Clear }  inverse }
}

#declare Sills = union {
intersection { // left window sill
             box { <-3, 2, 5.4 > < -0.25, 7, 6.6 > }
             box { <-2.9, 2.1, 5.3 > < -0.35, 6.9, 6.7 > inverse }
             texture { S_Wood }
             }
intersection { // right window sill
             box { <0.25, 2, 5.4 > < 3, 7, 6.6 > }
             box { <0.35, 2.1, 5.3 > < 2.9, 6.9, 6.7 > inverse }
             texture { S_Wood }
             }
intersection { // left window frame
             box { < -3, 2, 5.7 > < -0.25, 7, 6.2 > }
             box { < -2.8, 2.2, 5.6 > < -0.45, 6.8, 6.3 > inverse }
             pigment { Black }
             finish { metallic }
             }
intersection { // right window frame
             box { <0.25, 2, 5.7 > < 3, 7, 6.2 > }
             box { <0.45, 2.2, 5.6 > < 2.8, 6.8, 6.3 > inverse }
             pigment { Black }
             finish { metallic }
             }
union {
      box { < -1.725, 2, 5.89 > < -1.525, 7, 6.01 > }
      box { < 1.525, 2, 5.89 > < 1.725, 7, 6.01 > }
      box { < -3, 4.4, 5.89 > < -0.25, 4.6, 6.01 > }
      box { < 0.25, 4.4, 5.89 > < 3, 4.6, 6.01 > }
      pigment { Black }
      finish { metallic }
      }
union { // window glass
      box { < -3, 2, 5.9 > < -0.25, 7, 6.0 > }
      box { < 0.25, 2, 5.9 > < 3, 7, 6.0 >   }
      pigment { rgbf < 1, 1, 1, 0.7 > }
      finish { reflection 0.2 refraction 1.0 ior 1.5 roughness 0.05 }
      }
}


#declare Z_Wall = union {
difference {
           union {
           box { < -10, 0, 5.5 > < 10, 8, 6.5 > texture { W_Paper } }
           box { < -10, 0, 5.45 > < 10, 0.3, 5.5 >
               texture { S_Wood rotate z*10 scale < 0.1, 0.5, 0.1 >} }
           }
union {
      box { <-3, 2, 5.4 > < -0.25, 7, 6.6 > }
      box { <0.25, 2, 5.4 > < 3, 7, 6.6 > }
      pigment { Clear }
      }
      }
object { Sills }
}

#declare RX_Wall =
union {
box { < 9, 0, 6.5 > < 10, 8, -6.5 > texture { W_Paper } }
box { < 8.95, 0, 6.6 > < 9, 0.3, -6.5 >
               texture { S_Wood rotate y*45 scale < 0.1, 0.5, 0.1 >} }
}

#declare LX_Wall =
union {
box { < -9, 0, 6.5 > < -10, 8, -6.5 > texture { W_Paper } }
box { < -8.95, 0, 6.6 > < -9, 0.3, -6.5 >
               texture { S_Wood rotate y*45 scale < 0.1, 0.5, 0.1 >} }
}


object { Floor }
object { Table }
object { Eye_Storm translate < -2, 2.325, -1 > }
object { Z_Wall }
object { Z_Wall translate z*-12}
object { RX_Wall }
object { LX_Wall }
object { Lamp  translate < 6.5, 0, 4.0 > }
object { Roof }
object { DBoard scale < 0.08, 0.08, 0.08 >  translate < 5, 5, 5 > }
object { Dart  scale  < 0.08, 0.08, 0.08 >
               rotate < 45, 0, -5 >
               translate < -1.5, 2.05, -1.5 > }
object { Dart  scale  < 0.08, 0.08, 0.08 >
               rotate < 45, 0, -5 >
               translate < -1.0, 2.05, -1.0 > }
object { Dart  scale  < 0.08, 0.08, 0.08 >
               rotate < 45, 0, -5 >
               translate < -1.0, 2.05, -0.7 > }



