#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions

#declare Crystal =
colour_map { [ 0    colour rgbt<.1,.3,.7,.5>]
             [ 0.25 colour rgbt<.3,.6,.6,.3>]
             [ 0.5  colour rgbt<.4,.7,.7,.6>]
             [ 0.75 colour rgbt<.5,.5,.8,.4>]
             [ 1    colour rgbt<.1,.3,.7,.5>]
           }

#declare Glass =
texture {
    pigment { color rgbf<1.0, 1.0, 1.0, 0.7> }
    finish {
           specular 1
           roughness 0.001
           ambient 0
           diffuse 0
           reflection 0.1
    }
}

#declare Grass =
texture{
        pigment {color rgb<0.2,0.8,0.1>}
        normal{
               bumps 0.6
               scale 0.3
               }
}

// set viewer's position in the scene

camera
{
  location  <2.0, 1.5, -6.0>
  direction 2.0*z
  up        y
  right     4/3*x
  look_at   <0.0, 0.0,  0.0>
}

//light sources -> 3 inside the room & one outside


light_source
{
  0*x                     // light's position (translated below)
  color rgb <1,1,1>       // light's color
  spotlight               // this kind of light source
  translate <0, 80, 0> // <x y z> position of light
  point_at <0, .5, 0>      // direction of spotlight
  radius 1                // hotspot (inner, in degrees)
  tightness 50            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 1.5               // intensity falloff radius (outer, in degrees)
}

light_source
{
  0*x                     // light's position (translated below)
  color rgb <1,1,1>       // light's color
  spotlight               // this kind of light source
  translate <-4.1,.655, -80> // <x y z> position of light
  point_at <-4.1,.655, 7.1>      // direction of spotlight
  radius 1                // hotspot (inner, in degrees)
  tightness 50            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 1.5               // intensity falloff radius (outer, in degrees)
}

light_source
{
  0*x // light's position (translated below)
  color rgb<.25,.25,.25>  // light's color
  translate <-20, 20, -20>
}

light_source
{
  0*x // light's position (translated below)
  color rgb<.25,.25,.25>  // light's color
  translate <20, 20, -20>
}

light_source
{
  0*x // light's position (translated below)
  color White  // light's color
  translate <20, 20,20>
}

//sky
sky_sphere{
           pigment{ colour rgb<0.2,0.4,0.8>}
}

//main box

union{
      box{
          <-.5,-.5,-.5>
          < .5, .5, .5>
          texture{
                  Rosewood
          }
      }
      box{
          <-.6,-.4,.6>
          <.6,-.6,-.6>
          texture{Rosewood}
          }
}

sphere{
       <0,0,0>,.507
       texture{ Glass }
       scale<1,2,1>
}

//Wall with Door

difference{
             plane{
              z, 7
              pigment{
                      DMFWood1
                      }
              }
              box{
                  <-.7,1.5,7.8>
                  <+.5,-.49,6.2>
                  texture{
                          pigment { color rgbf<1,1,1,1>}
                          }
                 }
}

//Floor

box
{
  <-10,-.5,7>
  <10,-.6,-10>
  pigment{
          White_Marble
  }
}

sphere{
       <0,0,0>,.507
       texture{ Glass }
       scale<1,2,1>
}

//Exit sign

difference{
           box{
               <-3,1.2,7.1>
               <-1.5,.7,6.9>
               texture{
                       Gold_Texture
               }
           }
           text{
                ttf "timrom.ttf","Exit",0.2,0
                texture
                       { pigment { color Black } }
                scale<.8,.5,1>
                translate<-2.9,.8,6.8>
                }
}

//Garden

box{
    <-10,-.6,50>
    < 10,-.4,7.1>
    texture{
            Grass
            }
}

//vase

sor
{
    9, // # of points
    <0,0> // list of <u,v> points
    <2,1>
    <5,2>
    <4,4>
    <3,5>
    <2,7>
    <2.5,9>
    <3,10>
    <0,10>
    texture {
            pigment{
                    gradient x
                    colour_map{Crystal}
                    }
            finish{
                   ambient<0.3,0.5,0.7>
                   }
            }
    scale <.04,.04,.04>
    translate<0,.4,0>
    no_shadow
}

// Antique sign

difference{
           box{
               <-.4,+.4,-.6>
               <+.4,-.2,-.4>
               texture{
                       Gold_Texture
                       }
           }
           union{
                 text{
                      ttf "timrom.ttf"
                      "Antique",.2,0
                      pigment{colour Black}
                      scale<.2,.3,1>
                      translate<-.38,.2,-.65>
                 }
                 text{
                      ttf "timrom.ttf"
                      "Vase",.2,0
                      pigment{colour Black}
                      scale<.2,.3,1>
                      translate<-.25,-.1,-.65>
                 }
           }
}

//guard post

union{
      cylinder{ <1.2,-.5,-.6>
                <1.2,-.3,-.6>
                .2
                texture{Silver_Texture}
              }
      cylinder{ <1.2,-.31,-.6>
                <1.2,.5,-.6>
                .15
                pigment{colour Red}
              }
      sphere{ <1.2,.7,-.6>
              .15
                texture{Silver_Texture}
              }
}

union{
      cylinder{ <-1.2,-.5,-.6>
                <-1.2,-.3,-.6>
                .2
                texture{Silver_Texture}
              }
      cylinder{ <-1.2,-.31,-.6>
                <-1.2,.5,-.6>
                .15
                pigment{colour Red}
              }
      sphere{ <-1.2,.7,-.6>
              .15
                texture{Silver_Texture}
              }
}

union{
      cylinder{ <1.2,-.5,.6>
                <1.2,-.3,.6>
                .2
                texture{Silver_Texture}
              }
      cylinder{ <1.2,-.31,.6>
                <1.2,.5,.6>
                .15
                pigment{colour Red}
              }
      sphere{ <1.2,.7,.6>
              .15
                texture{Silver_Texture}
              }
}

union{
      cylinder{ <-1.2,-.5,.6>
                <-1.2,-.3,.6>
                .2
                texture{Silver_Texture}
              }
      cylinder{ <-1.2,-.31,.6>
                <-1.2,.5,.6>
                .15
                pigment{colour Red}
              }
      sphere{ <-1.2,.7,.6>
              .15
                texture{Silver_Texture}
              }
}

// wires

cylinder{
         <-1.2,.5,.6>
         <1.2,.5,.6>
         .05
         pigment{colour Red}
}

cylinder{
         <-1.2,.5,-.6>
         <1.2,.5,-.6>
         .05
         pigment{colour Red}
}

cylinder{
         <1.2,.5,-.6>
         <1.2,.5,.6>
         .05
         pigment{colour Red}
}

cylinder{
         <-1.2,.5,-.6>
         <-1.2,.5,.6>
         .05
         pigment{colour Red}
}

// quilt sign

difference{
           box{
               <-8,1.2,7.1>
               <-6,.2,6.9>
               texture{Gold_Texture}
           }
           union{
                 text{ ttf "timrom.ttf"
                       "Rare",.2,0
                       pigment{colour Black}
                       scale<.8,.4,1>
                       translate<-7.7,.8,6.85>
                 }
                 text{ ttf "timrom.ttf"
                       "Quilt",.2,0
                       pigment{colour Black}
                       scale<.8,.4,1>
                       translate<-7.9,.4,6.85>
                 }
           }
}

//Quilt

box{
    <-5,1.4,6.7>
    <-3.2,0,6.71>
    texture{
            pigment{ checker pigment{Red},pigment{Green} }
            finish{ Shiny}
            normal{ quilted 1}
            scale<.2,.2,.2>
            }
    no_shadow
}
//36 min 48 sec AA 0.3
