
#declare FrameTexture = texture {
	pigment {rgbt <1, 1, 1, 0.95>}
	finish {
		refraction 1
		reflection 0.5
		specular 0.6
		roughness 0.002
		diffuse 0.7
		ior 1.003
	}
}

#declare FrameFill = object {
	polygon { 5,
		<-1,0>,<-1,2>,
		<1,2>,<1,0>,<-1,0>
		texture { FrameTexture }
	}
}
#declare FilledUnitFrame = union {
	box { <-1, -1, -1>, <1, 1, 1>		// bottom
		scale <1.0, 0.1, 0.05>
	}
	box { <-1, -1, -1>, <1, 1, 1>		//top
		scale <1.0, 0.1, 0.05>
		translate < 0, 1.9, 0 >
	}
	box { <-1, -1, -1>, <1, 1, 1>		//right
		scale <1.0, 0.1, 0.05>
		rotate <0, 0, 90>
		translate <0.9,0.9,0>
	}
	box { <-1, -1, -1>, <1, 1, 1>		//left
		scale <1.0, 0.1, 0.05>
		rotate <0, 0, 90>
		translate <-0.9,0.9,0>
	}
	object { FrameFill }
}

#declare EmptyUnitFrame = union {
	box { <-1, -1, -1>, <1, 1, 1>		// bottom
		scale <1.0, 0.1, 0.05>
	}
	box { <-1, -1, -1>, <1, 1, 1>		//top
		scale <1.0, 0.1, 0.05>
		translate < 0, 1.9, 0 >
	}
	box { <-1, -1, -1>, <1, 1, 1>		//right
		scale <1.0, 0.1, 0.05>
		rotate <0, 0, 90>
		translate <0.9,0.9,0>
	}
	box { <-1, -1, -1>, <1, 1, 1>		//left
		scale <1.0, 0.1, 0.05>
		rotate <0, 0, 90>
		translate <-0.9,0.9,0>
	}
}


#declare ThinUnitFrame = union {
	box { <-1, -1, -1>, <1, 1, 1>		//bottom
		scale <1.0, 0.05, 0.03>
	}
	box { <-1, -1, -1>, <1, 1, 1>		//top
		scale <1.0, 0.05, 0.03>
		translate < 0, 1.9, 0 >
	}
	box { <-1, -1, -1>, <1, 1, 1>		//right
		scale <1.0, 0.05, 0.03>
		rotate <0, 0, 90>
		translate <0.95,0.95,0>
	}
	box { <-1, -1, -1>, <1, 1, 1>		//left
		scale <1.0, 0.05, 0.03>
		rotate <0, 0, 90>
		translate <-0.95,0.95,0>
	}
}

#declare SixScale  = <0.33, 0.5, 0.5>
#declare SixOneClosedWindowF = union {	//	Six over One Closed Window
	object { ThinUnitFrame		// bottom sash
	}
	object { ThinUnitFrame			// top sash frame
		translate <0.0, 1.95, -0.05>
	}
	object { ThinUnitFrame			// br
		scale SixScale
		translate <0.6, 1.95, -0.05>
	}
	object { ThinUnitFrame			// tr
		scale SixScale
		translate <0.6, 2.95, -0.05>
	}
   	object { ThinUnitFrame			// bm
		scale SixScale
		translate <0.0, 1.95, -0.05>
	}
	object { ThinUnitFrame			// tm
		scale SixScale
		translate <0.0, 2.95, -0.05>
	}
 	object { ThinUnitFrame			// bl
		scale SixScale
		translate <-0.6, 1.95, -0.05>
	}
	object { ThinUnitFrame			// tl
		scale SixScale
		translate <-0.6, 2.95, -0.05>
	}
	object { FilledUnitFrame					// casting
		scale <1.25 ,2.29,1.4>
		translate <0, -0.25, -0.05>
	}
}

#declare SixOneClosedWindowE = union {	//	Six over One Closed Window
	object { ThinUnitFrame		// bottom sash
	}
	object { ThinUnitFrame			// top sash frame
		translate <0.0, 1.95, -0.05>
	}
	object { ThinUnitFrame			// br
		scale SixScale
		translate <0.6, 1.95, -0.05>
	}
	object { ThinUnitFrame			// tr
		scale SixScale
		translate <0.6, 2.95, -0.05>
	}
   	object { ThinUnitFrame			// bm
		scale SixScale
		translate <0.0, 1.95, -0.05>
	}
	object { ThinUnitFrame			// tm
		scale SixScale
		translate <0.0, 2.95, -0.05>
	}
 	object { ThinUnitFrame			// bl
		scale SixScale
		translate <-0.6, 1.95, -0.05>
	}
	object { ThinUnitFrame			// tl
		scale SixScale
		translate <-0.6, 2.95, -0.05>
	}
	object { EmptyUnitFrame					// casting
		scale <1.25 ,2.29,1.4>
		translate <0, -0.25, -0.05>
	}
}


