#declare FrameThickness = 0.0125

#declare SGFilter = 1.0
#declare SGTransmit = 0.3
#declare SGFinish = finish {
	specular 1
	roughness 0.00025
	ambient 1
	diffuse 0
	refraction 1
	reflection 0.2
	ior 1.1
	caustics 0.8
}
#declare SGRed		= pigment { Red transmit SGTransmit filter SGFilter }
#declare SGYellow	= pigment { Yellow transmit SGTransmit filter SGFilter }
#declare SGBlue	= pigment { Blue transmit SGTransmit filter SGFilter }
#declare SGScarlet	= pigment { Scarlet transmit SGTransmit filter SGFilter }
#declare SGOrange	= pigment { Orange transmit SGTransmit filter SGFilter }
#declare SGPink	= pigment { NeonPink transmit SGTransmit filter SGFilter }
#declare SGGreen	= pigment { Green transmit SGTransmit filter SGFilter }
#declare SGWhite	= pigment { White transmit SGTransmit filter SGFilter }
#declare SGViolet	= pigment { Med_Purple transmit SGTransmit filter SGFilter }

#declare SGRedTexture	= texture { pigment { SGRed } finish { SGFinish }}
#declare SGYellowTexture	= texture { pigment { SGYellow } finish { SGFinish }}
#declare SGBlueTexture	= texture { pigment { SGBlue } finish { SGFinish }}
#declare SGOrangeTexture	= texture { pigment { SGOrange } finish { SGFinish }}
#declare SGPinkTexture	= texture { pigment { SGPink } finish { SGFinish }}
#declare SGGreenTexture	= texture { pigment { SGGreen } finish { SGFinish }}
#declare SGScarletTexture	= texture { pigment { SGScarlet } finish { SGFinish }}
#declare SGWhiteTexture	= texture { pigment { SGWhite } finish { SGFinish }}
#declare SGVioletTexture	= texture { pigment { SGViolet } finish { SGFinish }}

/*	These are the settings for the central picture */

#declare PicturePigment = pigment {		// the picture of the castle
	image_map {
		gif "castle.gif" transmit all 0.3 filter all 1.0
	}
}

#declare OutlinePigment = pigment {		// the black outline of the castle
	image_map {
		gif "outline.gif"
		transmit 255, 0
		filter 255, 1
	}
}

#declare PictureTexture = texture {		// the picture texture
	pigment { PicturePigment }
	finish { F_Glass1 ambient 0.5 }
}

#declare OutlineTexture = texture {		// the outline texture
	pigment { OutlinePigment }
	finish { ambient 1 }
}

#declare TextureLayer =					// the picture and the outline
	texture { OutlineTexture }
	texture { PictureTexture }

//------------------------------------------------------------------------------------------

#declare CornerSPane = object {
	polygon
	{
		7, // number of points
		<-1, -3.75>, <-1, 1>, <3.75, 1>, <3.75, -.75>, <1, -.75>, <1, -3.75>, <-1, -3.75>
	}
}

#declare BasicSGlassPane =
union {
	box
	{
	  <-1, -1, -1>  // one corner position <X1 Y1 Z1>
	  < 1,  1,  1>  // other corner position <X2 Y2 Z2>
	  scale <2,.0125,FrameThickness>
	  pigment { Black }
	}
	box
	{
		<-1, -1, -1>  // one corner position <X1 Y1 Z1>
		< 1,  1,  1>  // other corner position <X2 Y2 Z2>
		scale <0.0125,1, FrameThickness>
 		pigment { Black }
	}
	difference {
		merge {
			box
			{
				<-1, -1, -1>  // one corner position <X1 Y1 Z1>
				< 1,  1,  1>  // other corner position <X2 Y2 Z2>
				scale <2,1,.05>
			}
			sphere
			{
				<0, 0, 0> // center of sphere <X Y Z>
				0.5       // radius of sphere
				scale <2, 0.7,.14>
				translate <1, .5, 0>
			}
			sphere
			{
				<0, 0, 0> // center of sphere <X Y Z>
				0.5       // radius of sphere
				scale <2, 0.7,.14>
				translate <-1, -.5, 0>
			}
		}
		sphere
		{
			<0, 0, 0> // center of sphere <X Y Z>
			0.5       // radius of sphere
			scale <2, 0.7,.14>
			translate <-1, .5, -.1>
		}
		sphere
		{
			<0, 0, 0> // center of sphere <X Y Z>
			0.5       // radius of sphere
			scale <2, 0.7,.14>
			translate <1, -.5, -.1>
		}
	}
}

//	-------------------- The Stainwed Glass Frame ----------------------

#declare FrameObject =
union {
	box		//bottom
	{
	  <-1, -1, -1>  // one corner position <X1 Y1 Z1>
	  < 1,  1,  1>  // other corner position <X2 Y2 Z2>
	  scale < 2, .05, FrameThickness>
	 }
	box		//top
	{
	  <-1, -1, -1>  // one corner position <X1 Y1 Z1>
	  < 1,  1,  1>  // other corner position <X2 Y2 Z2>
	  scale < 2, .05, FrameThickness>
	  translate 4*y
	 }

	box		//left
	{
	  <0, -1, -1>  // one corner position <X1 Y1 Z1>
	  < 1,  1,  1>  // other corner position <X2 Y2 Z2>
	  scale < 4, .05, FrameThickness>
	  rotate 90*z
	  translate 1.95*x
	}
	box		//right
	{
	  <0, -1, -1>  // one corner position <X1 Y1 Z1>
	  < 1,  1,  1>  // other corner position <X2 Y2 Z2>
	  scale < 4, .05, FrameThickness>
	  rotate 90*z
	  translate -1.95*x
	}
}

#declare HalfRoundTop =
object {
	union {
		cylinder
		{
			< 0.0,  0.0, FrameThickness/2>, < 0.0,  0.0, -FrameThickness/2>, 2   //along z
			open
		}
		cylinder
		{
			< 0.0,  0.0, FrameThickness>, < 0.0,  0.0, -FrameThickness/2>, 1.90   //along z
			open
		}
		disc
		{
			<0, 0, -0.0>  // center position
			z,         // normal vector
			2.0,       // outer radius
			1.9        // optional hole radius
			translate -(FrameThickness/2)*z
		}
	}
	clipped_by { plane { -y, 0 }}
}

#declare OutterStrut = object  {
	box
	{
	  < 0, -1, -1>  // one corner position <X1 Y1 Z1>
	  < 1,  1,  1>  // other corner position <X2 Y2 Z2>
	  scale < .4, .025, FrameThickness>
	  rotate 90*z
	 }
}

#declare TopRayOutter = object  {
	box
	{
	  < 0, -1, -1>  // one corner position <X1 Y1 Z1>
	  < 1,  1,  1>  // other corner position <X2 Y2 Z2>
	  scale < 2, .025, FrameThickness>
	  rotate 90*z
	 }
	 clipped_by { cylinder { <0, 0, -.5>,<0, 0, .5>, 1.6 inverse}}
}

#declare TopRayInner = object  {
	box
	{
	  < 0, -1, -1>  // one corner position <X1 Y1 Z1>
	  < 1,  1,  1>  // other corner position <X2 Y2 Z2>
	  scale < 2, .025, FrameThickness>
	  rotate 90*z
	 }
	 clipped_by { cylinder { <0, 0, -.5>,<0, 0, .5>, 1.0 inverse}}
 	 clipped_by { cylinder { <0, 0, -.5>,<0, 0, .5>, 1.6 }}
}

#declare StainedGlassWindow =
union {
	object { FrameObject }
	object { FrameObject scale <0.8, 0.8, 1> translate 0.4*y}
	object { HalfRoundTop translate 4*y}
	object { HalfRoundTop scale <.8, .8, 1> translate 4*y}
	object { HalfRoundTop scale <.5, .5, 1> translate 4*y}
	object { OutterStrut }
	object { OutterStrut translate 1*x}
	object { OutterStrut translate -1*x}
	object { OutterStrut translate <0, 3.6, 0>}
	object { OutterStrut translate <1, 3.6, 0>}
	object { OutterStrut translate <-1, 3.6, 0>}
	object { OutterStrut rotate 90*z translate <2, 1, 0>}
	object { OutterStrut rotate 90*z translate <2, 2, 0>}
	object { OutterStrut rotate 90*z translate <2, 3, 0>}
	object { OutterStrut rotate 90*z translate <-1.6, 1, 0>}
	object { OutterStrut rotate 90*z translate <-1.6, 2, 0>}
	object { OutterStrut rotate 90*z translate <-1.6, 3, 0>}
	object { TopRayInner rotate 30*z translate 4*y}
	object { TopRayOutter rotate 60*z translate 4*y}
	object { TopRayOutter rotate 0*z translate 4*y}
	object { TopRayInner rotate -30*z translate 4*y}
	object { TopRayOutter rotate -60*z translate 4*y}

	object { BasicSGlassPane scale <.25,.16,.5> translate <.5,.20,0> texture { SGYellowTexture }}
	object { BasicSGlassPane scale <.25,.16,.5> translate <-.5,.20,0> texture { SGGreenTexture }}
	object { BasicSGlassPane scale <.25,.16,.5> translate <.5,3.8,0> texture { SGGreenTexture }}
	object { BasicSGlassPane scale <.25,.16,.5> translate <-.5,3.8,0> texture { SGYellowTexture }}
	object { BasicSGlassPane scale <.25,.16,.5> rotate 90*z translate <1.75,1.5,0> texture { SGBlueTexture }}
	object { BasicSGlassPane scale <.25,.16,.5> rotate 90*z translate <-1.75,1.5,0> texture { SGRedTexture }}
	object { BasicSGlassPane scale <.25,.16,.5> rotate 90*z translate <1.75,2.5,0> texture { SGRedTexture }}
	object { BasicSGlassPane scale <.25,.16,.5> rotate 90*z translate <-1.75,2.5,0> texture { SGBlueTexture }}
	union {
		object { CornerSPane scale .2 translate < -1.75, 3.75, -.025> }
		object { CornerSPane rotate 180*x scale .2 translate < -1.75, 0.25, -.025> }
		object { CornerSPane rotate 180*y scale .2 translate < 1.75, 3.75, -.025> }
		object { CornerSPane rotate 180*y rotate 180*x scale .2 translate < 1.75, 0.25, -.025> }
		texture { SGScarletTexture }
	}
	object {		// middle left
		disc { < 0, 0, 0>, z, 1.6, 1.0
			clipped_by { plane { -y, 0}}
			clipped_by { plane { x, 0} rotate 30*z }
		}
		texture { SGGreenTexture }
		translate 4*y
	}
	object {		// middle right
		disc { < 0, 0, 0>, z, 1.6, 1.0
			clipped_by { plane { -y, 0}}
			clipped_by { plane { -x, 0} rotate 30*z }
			clipped_by { plane { x, 0} rotate -30*z }
		}
		texture { SGRedTexture }
		translate 4*y
	}
	object {		// middle right
		disc { < 0, 0, 0>, z, 1.6, 1.0
			clipped_by { plane { -y, 0}}
			clipped_by { plane { -x, 0} rotate -30*z }
		}
		texture { SGBlueTexture }
		translate 4*y
	}
	object {		// outter left
		disc { < 0, 0, 0>, z, 2.0, 1.6
			clipped_by { plane { -y, 0}}
			clipped_by { plane { x, 0} rotate 60*z }
		}
		texture { SGYellowTexture }
		translate 4*y
	}
	object {		// outter top left
		disc { < 0, 0, 0>, z, 2.0, 1.6
			clipped_by { plane { -y, 0}}
			clipped_by { plane { -x, 0} rotate 60*z }
			clipped_by { plane { x, 0}}
		}
		texture { SGOrangeTexture }
		translate 4*y
	}
	object {		// outter top right
		disc { < 0, 0, 0>, z, 2.0, 1.6
			clipped_by { plane { -y, 0}}
			clipped_by { plane { -x, 0}}
			clipped_by { plane { x, 0} rotate -60*z}
		}
		texture { SGPinkTexture }
		translate 4*y
	}
	object {		// outter right
		disc { < 0, 0, 0>, z, 2.0, 1.6
			clipped_by { plane { -y, 0}}
			clipped_by { plane { -x, 0} rotate -60*z }
		}
		texture {	SGVioletTexture}
		translate 4*y
	}
	object {		// center
		disc { < 0, 0, 0>, z, 1.0
			clipped_by { plane { -y, 0}}
		}
		texture {   SGWhiteTexture }
		translate 4*y
	}

	polygon { 5, <0,0>, <1,0>,<1,1>,<0,1>,<0,0> texture {TextureLayer}
		scale <3.2, 3.15,1> translate <-1.6,.4,0>}
	pigment { Black }
}

