//  Persistance of Vision Raytracer V3.0
//  World definition file.
//
//  Contains 4 lights, 7 textures and 145 primitives.
//
//  This file was generated for POV-Ray V3.0 by
//  MORAY.EXE V2.5a.wat(c) 1991-1995 Lutz + Kretzschmar
//

//  Date : 02/21/1997    (21.02.1997)
//

//
//  This is the standard include file for POV-Ray. It is included with
//  every scene that Moray exports for POV-Ray.
//





global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.8
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 20
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

camera {  //  Camera StdCam
  location  <-3.600, -2.550, 17.200>
  direction <0.0,     0.0,  3.5850>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  look_at   <0.123, 0.256, 3.550>
}

//    Other cameras are commented out.
/*
camera {  //  Camera SpotCam001
  location  <4.450, -4.100, 13.850> // Attached to SpotL001
  direction <0.0,     0.0,  1.5392>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  look_at   <3.993, -3.665, 13.074> // Following SpotL001
}

*/

/*
camera {  //  Camera SpotCam002
  location  <-5.850, -3.300, 13.950> // Attached to SpotL002
  direction <0.0,     0.0,  1.8665>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  look_at   <-5.484, -3.089, 13.044> // Following SpotL002
}

*/

/*
camera {  //  Camera SpotCam003
  location  <0.150, 6.300, 14.350> // Attached to SpotL003
  direction <0.0,     0.0,  1.8665>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  look_at   <0.149, 5.794, 13.487> // Following SpotL003
}

*/

/*
camera {  //  Camera SpotCam004
  location  <8.120, -15.306, 2.850> // Attached to SpotL004
  direction <0.0,     0.0,  0.2332>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  look_at   <7.661, -14.417, 2.850> // Following SpotL004
}

*/

// *******  L I G H T S *******
light_source {   // Spotlight SpotL004
  <8.120, -15.306, 2.850>
  color  rgb <1.000, 1.000, 1.000>
  spotlight
    point_at  <7.661, -14.417, 2.850>
    falloff   65.0  // outer radius (in deg)
      radius    12.5  // inner radius
  atmosphere off
}

light_source {   // Spotlight SpotL003
  <0.150, 6.300, 14.350>
  color  rgb <1.000, 1.000, 1.000>
  spotlight
    point_at  <0.149, 5.794, 13.487>
    falloff   15.0  // outer radius (in deg)
      radius    7.5  // inner radius
  atmosphere off
}

light_source {   // Spotlight SpotL002
  <-5.850, -3.300, 13.950>
  color  rgb <1.000, 1.000, 1.000>
  spotlight
    point_at  <-5.484, -3.089, 13.044>
    falloff   15.0  // outer radius (in deg)
      radius    7.5  // inner radius
  atmosphere off
}

light_source {   // Spotlight SpotL001
  <4.450, -4.100, 13.850>
  color  rgb <1.000, 1.000, 1.000>
  spotlight
    point_at  <3.993, -3.665, 13.074>
    falloff   18.0  // outer radius (in deg)
      radius    9.0  // inner radius
  atmosphere off
}


// ********  TEXTURES  *******
//

#include "galil12b.inc"



// ********  REFERENCED OBJECTS  *******

#declare TwoCut4 = union {
  plane { // TwoPlaneCut8
    z,0
    rotate <180.0, 0.0, 180.0>
    translate  <-0.8, 0.0, 1.0>
  }
  plane { // TwoPlaneCut9
    z,0
    rotate <-180.0, -32.5, 180.0>
    translate  <0.35, 0.0, 0.8>
  }
}
#declare TwoUpper4 = intersection {
  torus { // TwoTop4
    0.8, 0.2  rotate -x*90
    rotate -90.0*x
    translate  1.0*z
  }
  object { TwoCut4 }
}
#declare Two4 = union {
  object { TwoUpper4 }
  sphere { // TwoSphere12
    <0,0,0>,1
    scale 0.2
    translate  <-0.8, 0.0, 1.0>
  }
  cylinder { // TwoCyl4
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 1.55>
    rotate 90.0*y
    translate  <-0.8, 0.0, -1.8>
  }
  sphere { // TwoSphere13
    <0,0,0>,1
    scale 0.2
    translate  <0.75, 0.0, -1.8>
  }
  sphere { // TwoSphere14
    <0,0,0>,1
    scale 0.2
    translate  <-0.8, 0.0, -1.8>
  }
  cylinder { // TwoBody4
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 2.85>
    rotate <-180.0, -32.5, -180.0>
    translate  <0.7, 0.0, 0.6>
  }
  translate  <0.8, 0.0, 2.0>
}
#declare SixUpper = intersection {
  torus { // SixUpperBody
    0.8, 0.2  rotate -x*90
    rotate -90.0*x
    translate  1.0*z
  }
  plane { // SixUpperCut
    z,0
    rotate <-180.0, 0.0, -180.0>
    translate  <-0.8, 0.0, 1.0>
  }
}
#declare Six = union {
  torus { // SixBody
    1.6, 0.4  rotate -x*90
    scale <-0.65, -0.5, -0.5>
    rotate <90.0, 90.0, 0.0>
    translate  -0.65*z
  }
  object { SixUpper }
  cylinder { // SixCyl
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 1.65>
    translate  <-0.8, 0.0, -0.65>
  }
  sphere { // SixSphere
    <0,0,0>,1
    scale 0.2
    translate  <0.8, 0.0, 1.0>
  }
  translate  <2.95, 0.0, 1.95>
}
#declare n26 = union {
  object { Two4 }
  object { Six }
  scale 0.3
  rotate <90.0, 0.0, 0.0>
  translate  <-0.55, 0.55, 0.0>
}
#declare TwoCut3 = union {
  plane { // TwoPlaneCut6
    z,0
    rotate <180.0, 0.0, 180.0>
    translate  <-0.8, 0.0, 1.0>
  }
  plane { // TwoPlaneCut7
    z,0
    rotate <-180.0, -32.5, 180.0>
    translate  <0.35, 0.0, 0.8>
  }
}
#declare TwoUpper3 = intersection {
  torus { // TwoTop3
    0.8, 0.2  rotate -x*90
    rotate -90.0*x
    translate  1.0*z
  }
  object { TwoCut3 }
}
#declare Two3 = union {
  object { TwoUpper3 }
  sphere { // TwoSphere9
    <0,0,0>,1
    scale 0.2
    translate  <-0.8, 0.0, 1.0>
  }
  cylinder { // TwoCyl3
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 1.55>
    rotate 90.0*y
    translate  <-0.8, 0.0, -1.8>
  }
  sphere { // TwoSphere10
    <0,0,0>,1
    scale 0.2
    translate  <0.75, 0.0, -1.8>
  }
  sphere { // TwoSphere11
    <0,0,0>,1
    scale 0.2
    translate  <-0.8, 0.0, -1.8>
  }
  cylinder { // TwoBody3
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 2.85>
    rotate <-180.0, -32.5, -180.0>
    translate  <0.7, 0.0, 0.6>
  }
  translate  <0.8, 0.0, 2.0>
}
#declare Four = union {
  cylinder { // FourCyl
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 1.8>
    translate  -0.8*x
  }
  sphere { // FourSphere
    <0,0,0>,1
    scale 0.2
    translate  0.8*z
  }
  sphere { // FourSphere2
    <0,0,0>,1
    scale 0.2
    translate  <-0.8, 0.0, 1.8>
  }
  sphere { // FourSphere3
    <0,0,0>,1
    scale 0.2
    translate  -1.8*z
  }
  sphere { // FourSphere5
    <0,0,0>,1
    scale 0.2
    translate  0.8*x
  }
  sphere { // FourSphere4
    <0,0,0>,1
    scale 0.2
    translate  -0.8*x
  }
  cylinder { // FourCyl2
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 1.6>
    rotate 90.0*y
    translate  -0.8*x
  }
  cylinder { // FourCyl3
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 2.6>
    rotate <0.0, 0.0, 0.0>
    translate  -1.8*z
  }
  translate  <2.95, 0.0, 2.0>
}
#declare n24 = union {
  object { Two3 }
  object { Four }
  scale 0.3
  rotate 90.0*x
  translate  <-0.55, 0.55, 0.0>
}
#declare TwoCut1 = union {
  plane { // TwoPlaneCut1
    z,0
    rotate <180.0, 0.0, 180.0>
    translate  <-0.8, 0.0, 1.0>
  }
  plane { // TwoPlaneCut3
    z,0
    rotate <-180.0, -32.5, 180.0>
    translate  <0.35, 0.0, 0.8>
  }
}
#declare TwoUpper1 = intersection {
  torus { // TwoTop1
    0.8, 0.2  rotate -x*90
    rotate -90.0*x
    translate  1.0*z
  }
  object { TwoCut1 }
}
#declare Two1 = union {
  object { TwoUpper1 }
  sphere { // TwoSphere1
    <0,0,0>,1
    scale 0.2
    translate  <-0.8, 0.0, 1.0>
  }
  cylinder { // TwoCyl1
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 1.55>
    rotate 90.0*y
    translate  <-0.8, 0.0, -1.8>
  }
  sphere { // TwoSphere4
    <0,0,0>,1
    scale 0.2
    translate  <0.75, 0.0, -1.8>
  }
  sphere { // TwoSphere5
    <0,0,0>,1
    scale 0.2
    translate  <-0.8, 0.0, -1.8>
  }
  cylinder { // TwoBody1
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 2.85>
    rotate <-180.0, -32.5, -180.0>
    translate  <0.7, 0.0, 0.6>
  }
  translate  <0.8, 0.0, 2.0>
}
#declare TwoCut2 = union {
  plane { // TwoPlaneCut4
    z,0
    rotate <180.0, 0.0, 180.0>
    translate  <-0.8, 0.0, 1.0>
  }
  plane { // TwoPlaneCut5
    z,0
    rotate <-180.0, -32.5, 180.0>
    translate  <0.35, 0.0, 0.8>
  }
}
#declare TwoUpper2 = intersection {
  torus { // TwoTop2
    0.8, 0.2  rotate -x*90
    rotate -90.0*x
    translate  1.0*z
  }
  object { TwoCut2 }
}
#declare Two2 = union {
  object { TwoUpper2 }
  sphere { // TwoSphere6
    <0,0,0>,1
    scale 0.2
    translate  <-0.8, 0.0, 1.0>
  }
  cylinder { // TwoCyl2
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 1.55>
    rotate 90.0*y
    translate  <-0.8, 0.0, -1.8>
  }
  sphere { // TwoSphere7
    <0,0,0>,1
    scale 0.2
    translate  <0.75, 0.0, -1.8>
  }
  sphere { // TwoSphere8
    <0,0,0>,1
    scale 0.2
    translate  <-0.8, 0.0, -1.8>
  }
  cylinder { // TwoBody2
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 2.85>
    rotate <-180.0, -32.5, -180.0>
    translate  <0.7, 0.0, 0.6>
  }
  translate  <2.95, 0.0, 2.0>
}
#declare n22 = union {
  object { Two1 }
  object { Two2 }
  scale 0.3
  rotate 90.0*x
  translate  <-0.55, 0.6, 0.0>
}
#declare One = union {
  cylinder { // OneBody
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 3.6>
    translate  -1.8*z
  }
  sphere { // OneBot
    <0,0,0>,1
    scale 0.2
    translate  -1.8*z
  }
  sphere { // OneBot1
    <0,0,0>,1
    scale 0.2
    translate  1.8*z
  }
  translate  2.0*z
}
#declare Eight = union {
  torus { // EightUpper
    1.5, 0.5  rotate -x*90
    scale <0.45, 0.35, 0.35>
    rotate <90.0, 90.0, 0.0>
    translate  1.1*z
  }
  torus { // EightLower
    1.6, 0.4  rotate -x*90
    scale <-0.65, -0.5, -0.5>
    rotate <90.0, 90.0, 0.0>
    translate  -0.65*z
  }
  translate  <1.4, 0.0, 1.95>
}
#declare N18 = union {
  object { One }
  object { Eight }
  scale 0.3
  rotate 90.0*x
  translate  <-0.3, 0.6, 0.0>
}
#declare TwoCut = union {
  plane { // TwoPlaneCut
    z,0
    rotate <180.0, 0.0, 180.0>
    translate  <-0.8, 0.0, 1.0>
  }
  plane { // TwoPlaneCut2
    z,0
    rotate <-180.0, -32.5, 180.0>
    translate  <0.35, 0.0, 0.8>
  }
}
#declare TwoUpper = intersection {
  torus { // TwoTop
    0.8, 0.2  rotate -x*90
    rotate -90.0*x
    translate  1.0*z
  }
  object { TwoCut }
}
#declare Two = union {
  object { TwoUpper }
  sphere { // TwoSphere
    <0,0,0>,1
    scale 0.2
    translate  <-0.8, 0.0, 1.0>
  }
  cylinder { // TwoCyl
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 1.55>
    rotate 90.0*y
    translate  <-0.8, 0.0, -1.8>
  }
  sphere { // TwoSphere2
    <0,0,0>,1
    scale 0.2
    translate  <0.75, 0.0, -1.8>
  }
  sphere { // TwoSphere3
    <0,0,0>,1
    scale 0.2
    translate  <-0.8, 0.0, -1.8>
  }
  cylinder { // TwoBody
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 2.85>
    rotate <-180.0, -32.5, -180.0>
    translate  <0.7, 0.0, 0.6>
  }
  translate  <0.8, 0.0, 2.0>
}
#declare n20 = union {
  object { Two }
  torus { // Zero
    1.7, 0.3  rotate -x*90
    scale <1.0, 0.5, 1.0>
    rotate <-90.0, -90.0, 0.0>
    translate  <2.9, 0.0, 2.0>
  }
  scale 0.3
  rotate 90.0*x
  translate  <-0.55, 0.6, 0.0>
}




// ********  OBJECTS  *******

#declare GlassPeak = difference {
  cylinder { // TopCyl
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 1.0>
    translate  -0.4*z
  }
  torus { // TopTorus
    0.7025, 0.67  rotate -x*90
    scale <1.0, 1.0, 1.7>
    translate  0.75*z
  }
  translate  9.4*z
}
#declare TopAirUnion = merge {
  torus { // GTopAir
    0.3, 0.3  rotate -x*90
  }
  cylinder { // TopAirFill
    <0,0,1>, <0,0,0>, 1 
    scale <0.3, 0.3, 0.6>
    translate  -0.3*z
  }
}
#declare TopAirFinal = difference {
  object { TopAirUnion }
  cylinder { // TopNoAirLow
    <0,0,1>, <0,0,0>, 1 
    scale <0.6, 0.6, 0.3>
    translate  -0.3*z
  }
  texture {
    Air_Tex1
  }
  translate  8.6*z
}
#declare TubeTop = union {
  sphere { // TopSphere
    <0,0,0>,1
    scale 0.17
    translate  10.1*z
  }
  object { GlassPeak }
  object { TopAirFinal }
  translate  -3.0*z
}
#declare Tube = difference {
  cylinder { // Body
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 6.0>
  }
  cylinder { // InnerBody
    <0,0,1>, <0,0,0>, 1 
    texture {
      WhiteWaterTex1
    }
    scale <0.6, 0.6, 5.35>
    translate  0.25*z
  }
}
#declare GalGlassBody = union {
  torus { // Bottom
    1.25, 0.75  rotate -x*90
    scale <0.5, 0.5, 0.2>
  }
  object { TubeTop }
  object { Tube }
  texture {
    Glass_Tex1
  }
}
#declare BalloonPeak = difference {
  cylinder { // CylPart
    <0,0,1>, <0,0,0>, 1 
    scale 0.5
    translate  0.65*z
  }
  torus { // TorusPart
    0.55, 0.45  rotate -x*90
    translate  1.15*z
  }
}
#declare GlassBody = merge {
  sphere { // TopSphere1
    <0,0,0>,1
    scale 0.175
    translate  1.2*z
  }
  object { BalloonPeak }
  sphere { // BodyForm
    <0,0,0>,1
    scale <1.0, 1.0, 0.8>
  }
  torus { // GlassRing
    1.2, 0.3  rotate -x*90
    scale <0.15, 0.15, 0.2>
    rotate -90.0*x
    translate  -0.95*z
  }
  texture {
    Glass_Tex1
  }
}
#declare BalloonAir = intersection {
  sphere { // InsideAir
    <0,0,0>,1
    scale <0.92, 0.92, 0.71>
  }
  sphere { // NoAir
    <0,0,0>,1
    scale <7.0, 7.0, 10.0>
    translate  10.0*z
  }
  texture {
    Air_Tex1
  }
}
#declare BalloonWater = difference {
  sphere { // InsideWater
    <0,0,0>,1
    scale <0.92, 0.92, 0.71>
  }
  sphere { // NoWater
    <0,0,0>,1
    scale <7.0, 7.0, 10.0>
    translate  10.0*z
  }
  texture {
    Ballwater_tex1
  }
}
#declare GlassWithWater = union {
  object { GlassBody }
  object { BalloonAir }
  object { BalloonWater }
}
#declare LabelWithHole = difference {
  cylinder { // LabelToken
    <0,0,1>, <0,0,0>, 1 
  }
  cylinder { // LabelHole
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 1.0>
    translate  -0.5*y
  }
}
#declare Temp26a1 = object { 
  height_field {
    gif "G:\GFX\MORAY\MAPS\26.GIF"
    water_level 0.0099
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  scale 0.6
  rotate -90.0*z
  translate  -0.2*z
}
#declare BalloonLabel = difference {
  object { LabelWithHole }
  torus { // LabelEdge
    0.875, 0.025  rotate -x*90
  }
  torus { // LabelEdge1
    0.875, 0.025  rotate -x*90
    translate  1.0*z
  }
  object { Temp26a1 }
  object { n26 }
  object { // n27->n26
    n26
    rotate 180.0*y
    translate  1.0*z
  }
  texture {
    Chrome_Tex1
  }
  scale <0.4, 0.4, 0.1>
  rotate <-90.0, 0.0, -90.0>
  translate  <-0.05, 0.0, -1.35>
}
#declare Balloon = union {
  object { GlassWithWater }
  object { BalloonLabel }
  scale 0.3
  translate  <0.2, 0.0, 8.1>
}
#declare BalloonPeak1 = difference {
  cylinder { // CylPart1
    <0,0,1>, <0,0,0>, 1 
    scale 0.5
    translate  0.65*z
  }
  torus { // TorusPart1
    0.55, 0.45  rotate -x*90
    translate  1.15*z
  }
}
#declare GlassBody1 = merge {
  sphere { // TopSphere2
    <0,0,0>,1
    scale 0.175
    translate  1.2*z
  }
  object { BalloonPeak1 }
  sphere { // BodyForm1
    <0,0,0>,1
    scale <1.0, 1.0, 0.8>
  }
  torus { // GlassRing1
    1.2, 0.3  rotate -x*90
    scale <0.15, 0.15, 0.2>
    rotate -90.0*x
    translate  -0.95*z
  }
  texture {
    Glass_Tex1
  }
}
#declare BalloonAir1 = intersection {
  sphere { // InsideAir1
    <0,0,0>,1
    scale <0.92, 0.92, 0.71>
  }
  sphere { // NoAir1
    <0,0,0>,1
    scale <7.0, 7.0, 10.0>
    translate  10.0*z
  }
  texture {
    Air_Tex1
  }
}
#declare BalloonWater1 = difference {
  sphere { // InsideWater1
    <0,0,0>,1
    scale <0.92, 0.92, 0.71>
  }
  sphere { // NoWater1
    <0,0,0>,1
    scale <7.0, 7.0, 10.0>
    translate  10.0*z
  }
  texture {
    Ballwater_tex1
  }
}
#declare GlassWithWate1 = union {
  object { GlassBody1 }
  object { BalloonAir1 }
  object { BalloonWater1 }
}
#declare LabelWithHole1 = difference {
  cylinder { // LabelToken1
    <0,0,1>, <0,0,0>, 1 
  }
  cylinder { // LabelHole1
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 1.0>
    translate  -0.5*y
  }
}
#declare BalloonLabel1 = difference {
  object { LabelWithHole1 }
  torus { // LabelEdge2
    0.875, 0.025  rotate -x*90
  }
  torus { // LabelEdge3
    0.875, 0.025  rotate -x*90
    translate  1.0*z
  }
  object { n24 }
  object { // n25->n24
    n24
    rotate <180.0, 0.0, 180.0>
    translate  1.0*z
  }
  texture {
    Chrome_Tex1
  }
  scale <0.4, 0.4, 0.1>
  rotate <-90.0, 0.0, -90.0>
  translate  <-0.05, 0.0, -1.35>
}
#declare Balloon1 = union {
  object { GlassWithWate1 }
  object { BalloonLabel1 }
  scale 0.3
  rotate -20.0*z
  translate  <-0.2, 0.1, 7.7>
}
#declare BalloonPeak2 = difference {
  cylinder { // CylPart2
    <0,0,1>, <0,0,0>, 1 
    scale 0.5
    translate  0.65*z
  }
  torus { // TorusPart2
    0.55, 0.45  rotate -x*90
    translate  1.15*z
  }
}
#declare GlassBody2 = merge {
  sphere { // TopSphere3
    <0,0,0>,1
    scale 0.175
    translate  1.2*z
  }
  object { BalloonPeak2 }
  sphere { // BodyForm2
    <0,0,0>,1
    scale <1.0, 1.0, 0.8>
  }
  torus { // GlassRing2
    1.2, 0.3  rotate -x*90
    scale <0.15, 0.15, 0.2>
    rotate -90.0*x
    translate  -0.95*z
  }
  texture {
    Glass_Tex1
  }
}
#declare BalloonAir2 = intersection {
  sphere { // InsideAir2
    <0,0,0>,1
    scale <0.92, 0.92, 0.71>
  }
  sphere { // NoAir2
    <0,0,0>,1
    scale <7.0, 7.0, 10.0>
    translate  10.0*z
  }
  texture {
    Air_Tex1
  }
}
#declare BalloonWater2 = difference {
  sphere { // InsideWater2
    <0,0,0>,1
    scale <0.92, 0.92, 0.71>
  }
  sphere { // NoWater2
    <0,0,0>,1
    scale <7.0, 7.0, 10.0>
    translate  10.0*z
  }
  texture {
    Ballwater_tex1
  }
}
#declare GlassWithWate2 = union {
  object { GlassBody2 }
  object { BalloonAir2 }
  object { BalloonWater2 }
}
#declare LabelWithHole2 = difference {
  cylinder { // LabelToken2
    <0,0,1>, <0,0,0>, 1 
  }
  cylinder { // LabelHole2
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 1.0>
    translate  -0.5*y
  }
}
#declare BalloonLabel2 = difference {
  object { LabelWithHole2 }
  torus { // LabelEdge4
    0.875, 0.025  rotate -x*90
  }
  torus { // LabelEdge5
    0.875, 0.025  rotate -x*90
    translate  1.0*z
  }
  object { n22 }
  object { // n23->n22
    n22
    rotate <0.0, 180.0, 0.0>
    translate  <-0.05, 0.0, 1.0>
  }
  texture {
    Chrome_Tex1
  }
  scale <0.4, 0.4, 0.1>
  rotate <-90.0, 0.0, -90.0>
  translate  <-0.05, 0.0, -1.35>
}
#declare Balloon2 = union {
  object { GlassWithWate2 }
  object { BalloonLabel2 }
  scale 0.3
  rotate -60.0*z
  translate  <0.1, -0.1, 7.3>
}
#declare UpperBalloons = union {
  object { Balloon }
  object { Balloon1 }
  object { Balloon2 }
  translate  -3.0*z
}
#declare BalloonPeak3 = difference {
  cylinder { // CylPart3
    <0,0,1>, <0,0,0>, 1 
    scale 0.5
    translate  0.65*z
  }
  torus { // TorusPart3
    0.55, 0.45  rotate -x*90
    translate  1.15*z
  }
}
#declare GlassBody3 = merge {
  sphere { // TopSphere4
    <0,0,0>,1
    scale 0.175
    translate  1.2*z
  }
  object { BalloonPeak3 }
  sphere { // BodyForm3
    <0,0,0>,1
    scale <1.0, 1.0, 0.8>
  }
  torus { // GlassRing3
    1.2, 0.3  rotate -x*90
    scale <0.15, 0.15, 0.2>
    rotate -90.0*x
    translate  -0.95*z
  }
  texture {
    Glass_Tex1
  }
}
#declare BalloonAir3 = intersection {
  sphere { // InsideAir3
    <0,0,0>,1
    scale <0.92, 0.92, 0.71>
  }
  sphere { // NoAir3
    <0,0,0>,1
    scale <7.0, 7.0, 10.0>
    translate  10.0*z
  }
  texture {
    Air_Tex1
  }
}
#declare BalloonWater3 = difference {
  sphere { // InsideWater3
    <0,0,0>,1
    scale <0.92, 0.92, 0.71>
  }
  sphere { // NoWater3
    <0,0,0>,1
    scale <7.0, 7.0, 10.0>
    translate  10.0*z
  }
  texture {
    Ballwater_tex1
  }
}
#declare GlassWithWate3 = union {
  object { GlassBody3 }
  object { BalloonAir3 }
  object { BalloonWater3 }
}
#declare LabelWithHole3 = difference {
  cylinder { // LabelToken3
    <0,0,1>, <0,0,0>, 1 
  }
  cylinder { // LabelHole3
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 1.0>
    translate  -0.5*y
  }
}
#declare BalloonLabel3 = difference {
  object { LabelWithHole3 }
  torus { // LabelEdge6
    0.875, 0.025  rotate -x*90
  }
  torus { // LabelEdge7
    0.875, 0.025  rotate -x*90
    translate  1.0*z
  }
  object { N18 }
  object { // N19->N18
    N18
    rotate 180.0*y
    translate  <0.05, 0.0, 1.0>
  }
  texture {
    Chrome_Tex1
  }
  scale <0.4, 0.4, 0.1>
  rotate <-90.0, 0.0, -90.0>
  translate  <-0.05, 0.0, -1.35>
}
#declare Balloon3 = union {
  object { GlassWithWate3 }
  object { BalloonLabel3 }
  scale 0.3
  rotate -60.0*z
  translate  <0.1, -0.1, 0.8>
}
#declare BalloonPeak4 = difference {
  cylinder { // CylPart4
    <0,0,1>, <0,0,0>, 1 
    scale 0.5
    translate  0.65*z
  }
  torus { // TorusPart4
    0.55, 0.45  rotate -x*90
    translate  1.15*z
  }
}
#declare GlassBody4 = merge {
  sphere { // TopSphere5
    <0,0,0>,1
    scale 0.175
    translate  1.2*z
  }
  object { BalloonPeak4 }
  sphere { // BodyForm4
    <0,0,0>,1
    scale <1.0, 1.0, 0.8>
  }
  torus { // GlassRing4
    1.2, 0.3  rotate -x*90
    scale <0.15, 0.15, 0.2>
    rotate -90.0*x
    translate  -0.95*z
  }
  texture {
    Glass_Tex1
  }
}
#declare BalloonAir4 = intersection {
  sphere { // InsideAir4
    <0,0,0>,1
    scale <0.92, 0.92, 0.71>
  }
  sphere { // NoAir4
    <0,0,0>,1
    scale <7.0, 7.0, 10.0>
    translate  10.0*z
  }
  texture {
    Air_Tex1
  }
}
#declare BalloonWater4 = difference {
  sphere { // InsideWater4
    <0,0,0>,1
    scale <0.92, 0.92, 0.71>
  }
  sphere { // NoWater4
    <0,0,0>,1
    scale <7.0, 7.0, 10.0>
    translate  10.0*z
  }
  texture {
    Ballwater_tex1
  }
}
#declare GlassWithWate4 = union {
  object { GlassBody4 }
  object { BalloonAir4 }
  object { BalloonWater4 }
}
#declare LabelWithHole4 = difference {
  cylinder { // LabelToken4
    <0,0,1>, <0,0,0>, 1 
  }
  cylinder { // LabelHole4
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 1.0>
    translate  -0.5*y
  }
}
#declare BalloonLabel4 = difference {
  object { LabelWithHole4 }
  torus { // LabelEdge8
    0.875, 0.025  rotate -x*90
  }
  torus { // LabelEdge9
    0.875, 0.025  rotate -x*90
    translate  1.0*z
  }
  object { n20 }
  object { // n21->n20
    n20
    rotate <0.0, 180.0, 0.0>
    translate  1.0*z
  }
  texture {
    Chrome_Tex1
  }
  scale <0.4, 0.4, 0.1>
  rotate <-90.0, 0.0, -90.0>
  translate  <-0.05, 0.0, -1.35>
}
#declare Balloon4 = union {
  object { GlassWithWate4 }
  object { BalloonLabel4 }
  scale 0.3
  rotate -95.0*z
  translate  <0.1, -0.1, 2.5>
}
union { // Thermometer
  object { GalGlassBody }
  object { UpperBalloons }
  object { Balloon3 }
  object { Balloon4 }
  translate  <0.0, 0.013118, 0.157417>
}


union { // Room1
  plane { // Floor
    z,0
  }
  plane { // Wall
    z,0
    rotate <90.0, 0.0, 35.0>
    translate  <-0.05, 6.4, 0.0>
  }
  texture {
    Blue_Tex1
  }
}










