// TWISTS.POV -- By Roy Mitchell Harper

// Here's where the hearts and gems live.


// To get a feel for how I got the hearts and gems to spin around in
//   their intricate dance, follow this explanation (and please forgive
//   me if I talk "down" too much. I'm trying to make this accessible
//   to those with very limited 3D graphics experience):

// Imagine, if you will, a small box at 0, 0, 0. Okay, now, push the
//   box up into the Z direction (Z is the up and down axis in this
//   example) by two units. All is well so far, you've got a box
//   floating at 0, 0, 2 -- two units above the origin.

// Next, start rotating the box around the Y axis. In this file, Y is
//   the front to back, or "closer and farther away" axis. Rotating
//   around this axis is like turning a large crank that's attached to
//   the wall (the axis of rotation is the shaft of the crank). This
//   rotation makes the box spin clockwise in front of you. (It's kind
//   of like an odd second hand on an "art deco" style clock). Just let
//   it spin there for a while to get used to it.

// Now, take the cube _and_ it's rotation (the cube and the invisible
//   "machine" that's spinning the cube around) and move it 10 units to
//   the right. Now, you've got a cube spinning clockwise, but it's
//   been moved to the right.

// Here's where the fun begins. Now slowly rotate this entire
//   contraption around the Z (up and down) axis. The box is making a
//   bunch of little loops, but the little loops are forming one big
//   loop -- like making a good sized circle out of a coiled phone
//   cord.

// With this way of doing things (move, rotate, move rotate), there's no
//   end to the intricate (and animated) designs that can be easily
//   created.

// For those brave souls who wish to see the details of how I animated
//   these hearts and gems, scroll to the bottom of this file. Hopefully
//   I left clear enough comments to help you understand what I've done.


#declare fClearTextures = yes   // Setting this to "no" makes test
                                //   renders conveniently faster.

/* Uncomment this section and you can do a little playing around
//   with just the items in this file.

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.8
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 20
  number_of_waves 10
}

background { color <0.000,0.000,0.000> }

camera {  //  Camera StdCam
  location  <0.000, -35.000, 0.000>
  direction <0.0,     0.0,  1.9067>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  look_at   <0.000, 0.000, 0.000>
}

// *******  L I G H T S *******
light_source {   // Light1
  <100.000, -200.000, 300.000>
  color rgb <1.000, 1.000, 1.000>
}

// ******* Floor *******
#declare FloorTexture = texture {
   pigment {
     checker
       color rgb<0.504, 0.000, 0.000>
       color rgb<0.000, 0.000, 1.000>
       //scale     <2.0000, 2.0000, 2.0000>
   }
   finish {
     diffuse 1.000
     ambient 0.100
   }
}

plane { // FloorPlane
  z,0
  texture {
    FloorTexture
  }
  translate  -3.0*z
}

// End of section to uncomment
*/


// ******* Textures *******

//  $MRX$: 'HeartTexture'
#declare HeartTexture = texture {
   pigment {
     #if (fClearTextures)
       color rgbf<1.000, 0.000, 0.000, 0.940>
     #else
       color rgbf<1.000, 0.000, 0.000, 0.000>
     #end
   }
   finish {
     diffuse 1.000
     ambient 1.000
     #if (fClearTextures)
       refraction 1
     #else
       refraction 0
     #end
     ior 1.500
     specular 1.000
     roughness 0.0510
     fade_power 2
     fade_distance 1.5
   }
}

//  $MRX$: 'GemTexture'
#declare GemTexture = texture {
   pigment {
     #if (fClearTextures)
       color rgbf<0.000, 0.400, 1.000, 0.940>
     #else
       color rgbf<0.000, 0.400, 1.000, 0.000>
     #end
   }
   finish {
     diffuse 1.000
     ambient 1.000
     #if (fClearTextures)
       refraction 1
     #else
       refraction 0
     #end
     ior 1.500
     specular 1.000
     roughness 0.0210
     fade_power 2
     fade_distance 1
   }
}


// ********  REFERENCED OBJECTS  *******

///////////////////////////////////////////////////////////////////////
// Heart1
///////////////////////////////////////////////////////////////////////

#declare CSG001 = intersection {
  plane { // Plane1
    z,0
    scale 0.2
    rotate <180.0, -75.0, 180.0>
    translate  -1.0*x
  }
  plane { // Plane2
    z,0
    scale 0.2
    rotate <180.0, -105.0, 180.0>
    translate  -1.0*x
  }
}
#declare lsca1 = intersection {
  object { CSG001 }
  object { // CSG2->CSG001
    CSG001
    rotate -36.0*z
  }
  object { // CSG3->CSG001
    CSG001
    rotate -72.0*z
  }
  object { // CSG4->CSG001
    CSG001
    rotate -108.0*z
  }
  object { // CSG5->CSG001
    CSG001
    rotate -144.0*z
  }
}
#declare CSG10 = intersection {
  plane { // Plane3
    z,0
    scale 0.2
    rotate <180.0, -50.0, 180.0>
    translate  <-0.933, 0.0, -0.25>
  }
  plane { // Plane4
    z,0
    scale 0.2
    rotate <180.0, -130.0, 180.0>
    translate  <-0.933, 0.0, 0.25>
  }
}
#declare lsca2 = intersection {
  object { CSG10 }
  object { // CSG11->CSG10
    CSG10
    rotate -36.0*z
  }
  object { // CSG12->CSG10
    CSG10
    rotate -72.0*z
  }
  object { // CSG13->CSG10
    CSG10
    rotate -108.0*z
  }
  object { // CSG14->CSG10
    CSG10
    rotate -144.0*z
  }
  rotate -18.0*z
}
#declare CSG19 = intersection {
  plane { // Plane5
    z,0
    scale 0.2
    rotate <180.0, -30.0, 180.0>
    translate  <-0.723, 0.0, -0.5>
  }
  plane { // Plane6
    z,0
    scale 0.2
    rotate <180.0, -150.0, 180.0>
    translate  <-0.723, 0.0, 0.5>
  }
}
#declare lsca3 = intersection {
  object { CSG19 }
  object { // CSG20->CSG19
    CSG19
    rotate -36.0*z
  }
  object { // CSG21->CSG19
    CSG19
    rotate -72.0*z
  }
  object { // CSG22->CSG19
    CSG19
    rotate -108.0*z
  }
  object { // CSG23->CSG19
    CSG19
    rotate -144.0*z
  }
}
#declare CSG002 = intersection {
  plane { // Plane002
    z,0
    scale 0.2
    rotate -75.0*y
    translate  -3.0*x
  }
  plane { // Plane8
    z,0
    scale 0.2
    rotate <180.0, -75.0, 180.0>
    translate  -3.0*x
  }
}
#declare llca1 = intersection {
  object { CSG002 }
  object { // CSG6->CSG002
    CSG002
    rotate 14.1*z
  }
  object { // CSG7->CSG002
    CSG002
    rotate 28.200001*z
  }
  object { // CSG8->CSG002
    CSG002
    rotate 42.299999*z
  }
  object { // CSG9->CSG002
    CSG002
    rotate 56.400002*z
  }
  object { // CSG15->CSG002
    CSG002
    rotate 70.5*z
  }
}
#declare CSG38 = intersection {
  plane { // Plane9
    z,0
    scale 0.2
    rotate -50.0*y
    translate  <-2.933, 0.0, 0.25>
  }
  plane { // Plane10
    z,0
    scale 0.2
    rotate <180.0, -50.0, 180.0>
    translate  <-2.933, 0.0, -0.25>
  }
}
#declare llca2 = intersection {
  object { CSG38 }
  object { // CSG39->CSG38
    CSG38
    rotate 14.1*z
  }
  object { // CSG40->CSG38
    CSG38
    rotate 28.200001*z
  }
  object { // CSG41->CSG38
    CSG38
    rotate 42.299999*z
  }
  object { // CSG42->CSG38
    CSG38
    rotate 56.400002*z
  }
  rotate 7.05*z
}
#declare CSG48 = intersection {
  plane { // Plane11
    z,0
    scale 0.2
    rotate -30.0*y
    translate  <-2.723, 0.0, 0.5>
  }
  plane { // Plane15
    z,0
    scale 0.2
    rotate <180.0, -30.0, 180.0>
    translate  <-2.723, 0.0, -0.5>
  }
}
#declare llca3 = intersection {
  object { CSG48 }
  object { // CSG49->CSG48
    CSG48
    rotate 14.1*z
  }
  object { // CSG50->CSG48
    CSG48
    rotate 28.200001*z
  }
  object { // CSG51->CSG48
    CSG48
    rotate 42.299999*z
  }
  object { // CSG52->CSG48
    CSG48
    rotate 56.400002*z
  }
  object { // CSG53->CSG48
    CSG48
    rotate 70.5*z
  }
}
#declare CSG004 = intersection {
  plane { // Plane004
    z,0
    scale 0.2
    rotate -6.5*y
    translate  0.75*z
  }
  plane { // Plane005
    z,0
    scale 0.2
    rotate <180.0, -6.5, 180.0>
    translate  -0.75*z
  }
}




// ********  OBJECTS  *******

#declare LeftSmCirc1 = intersection {
  object { lsca1 }
  object { lsca2 }
  object { lsca3 }
  plane { // Plane7
    z,0
    scale <1.0, 0.2, 0.2>
    rotate 90.0*x
  }
  translate  <-1.0, 0.667, 0.0>
}
#declare RightSmCirc1 = intersection {
  object { // lscb1->lsca1
    lsca1
    rotate <180.0, 0.0, 180.0>
  }
  object { // lscb2->lsca2
    lsca2
    rotate <180.0, 0.0, 180.0>
  }
  object { // lscb3->lsca3
    lsca3
    rotate <180.0, 0.0, 180.0>
  }
  plane { // Plane12
    z,0
    scale <1.0, 0.2, 0.2>
    rotate 90.0*x
  }
  translate  <1.0, 0.667, 0.0>
}
#declare LargeCircs1 = intersection {
  object { llca1 }
  object { llca2 }
  object { llca3 }
  object { // llcb1->llca1
    llca1
    rotate <180.0, 0.0, 180.0>
    translate  -2.0*x
  }
  object { // llcb2->llca2
    llca2
    rotate <-180.0, 0.0, -180.0>
    translate  -2.0*x
  }
  object { // llcb3->llca3
    llca3
    rotate <180.0, 0.0, 180.0>
    translate  -2.0*x
  }
  plane { // Plane003
    z,0
    scale <2.0, 0.2, 0.2>
    rotate -90.0*x
    translate  -1.0*x
  }
  translate  <1.0, 0.667, 0.0>
}
#declare CSG003 = merge {
  object { LeftSmCirc1 }
  object { RightSmCirc1 }
  object { LargeCircs1 }
}
#declare Heart1 = intersection { // Heart1
  object { CSG003 }
  object { CSG004 }
  object { // CSG16->CSG004
    CSG004
    rotate -36.0*z
  }
  object { // CSG17->CSG004
    CSG004
    rotate -72.0*z
  }
  object { // CSG18->CSG004
    CSG004
    rotate -108.0*z
  }
  object { // CSG24->CSG004
    CSG004
    rotate -144.0*z
  }
  object { // CSG25->CSG004
    CSG004
    rotate 180.0*z
  }
  object { // CSG26->CSG004
    CSG004
    rotate 144.0*z
  }
  object { // CSG27->CSG004
    CSG004
    rotate 108.0*z
  }
  object { // CSG28->CSG004
    CSG004
    rotate 72.0*z
  }
  object { // CSG29->CSG004
    CSG004
    rotate 36.0*z
  }
  texture {
    HeartTexture
  }
  bounded_by { // Bound00001
    box {
      <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
      scale <2.001, 1.91, 0.751>
      translate  -0.242*y
    }
  }
  scale <0.4, 0.4, 0.4>
}

///////////////////////////////////////////////////////////////////////
// Gem1
///////////////////////////////////////////////////////////////////////

#declare CSG69 = union {
  plane { // Plane13
    z,0
    scale <1.0, 0.2, 0.2>
    rotate <-133.0, 0.0, -45.0>
    translate  <-0.7071, -0.7071, 0.3333>
  }
}
#declare CSG73 = union {
  plane { // Plane14
    z,0
    scale <1.0, 0.2, 0.2>
    rotate <-47.0, 0.0, -45.0>
    translate  <-0.7071, -0.7071, -0.3333>
  }
}

#declare Gem1 = difference { // Gem1
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    rotate -45.0*z
  }
  object { CSG69 }
  object { // CSG70->CSG69
    CSG69
    rotate -90.0*z
  }
  object { // CSG71->CSG69
    CSG69
    rotate 180.0*z
  }
  object { // CSG72->CSG69
    CSG69
    rotate 90.0*z
  }
  object { CSG73 }
  object { // CSG74->CSG73
    CSG73
    rotate -90.0*z
  }
  object { // CSG75->CSG73
    CSG73
    rotate 180.0*z
  }
  object { // CSG76->CSG73
    CSG73
    rotate 90.0*z
  }
  texture {
    GemTexture
  }
  scale <0.5, 1.0, 0.25>
}



///////////////////////////////////////////////////////////////////////
// Here's where the cool stuff lives
///////////////////////////////////////////////////////////////////////

// The spinning hearts

#declare nHeartCount        = 0        // Counter for creating hearts
#declare nHeartsAroundLoop  = 12       // Count of hearts in each small
                                       //   loop
#declare nLoopsAroundCircle = 6        // Total number of small loops
                                       //   around the large loop
#declare nTotalHearts       = nHeartsAroundLoop * nLoopsAroundCircle
                                       // Total number of hearts in the
                                       //   image.
#declare nHeartClock        = clock    // Makes the heart animation a
                                       //   bit more independent of the
                                       //   clock value.

// As nHeartClock moves from 0 to 1, the first heart will move to the
//   exact location where heart #2 started. Hence, a nice cyclical
//   animation.

union {
  #while (nHeartCount < nTotalHearts)
    object {
      Heart1
      // First, make it stand up (it starts out laying down)
      rotate <90, 0, 0>

      // Spin it around on it's tail around Z
      rotate <0, 0, (nHeartCount + clock) * (270 / nHeartsAroundLoop)>

      // It's now ready to be moved away from the origin.
      // Undo the any undesirable future rotations here.
      rotate <0, -(nHeartCount + clock) * (360 / nHeartsAroundLoop), 0>

      // Move it out a little bit toward +Z, then rotate about the Y axis
      translate <0, 0, 2>
      rotate <0, (nHeartCount + clock) * (360 / nHeartsAroundLoop), 0>

      // Now move it further out toward -X and rotate about the Z axis.
      // This is the big loop.
      translate <-12, 0, 0>
      rotate <0, 0, (nHeartCount + clock) * (360 / nTotalHearts)>
    }
    #declare  nHeartCount = nHeartCount + 1
  #end
  rotate <0, 0, 13.5>
  translate <0, 0, 0.75>
}


// The ribbon of Gems -- In addition to all the moves and rotates given
//                         to the hearts, the gems have one extra move
//                         and rotate thrown in to make them spin
//                         around the hearts as the hearts go around
//                         the circle.

#declare nGemCount          = 0        // Counter for creating hearts
#declare nGemsAroundHeart   = 8        // This is how many gems to spin
                                       //   around in their extra "move
                                       //   and spin"
#declare nTotalGems         = nGemsAroundHeart * nHeartsAroundLoop * nLoopsAroundCircle
                                       // Total number of gems in the
                                       //   image.
#declare nGemClock          = clock * 2// Makes the gem animation a bit
                                       //   more independent of the
                                       //   clock value.

// As nGemClock moves from 0 to 1, the first heart will move to the
//   exact location where gem #2 started. Hence, a nice cyclical
//   animation.

#declare nGemLoopsToHearts  = 0.3333   // This is the number of times
                                       //   the ribbon of gems goes
                                       //   around each heart.

union {
  #while (nGemCount < nTotalGems)
    object {
      Gem1

      // Set the scale
      scale <0.225, 0.225, 0.225>

      // First, make it stand up (it starts out laying down)
      rotate <90, 0, 0>

      // Spin it around on it's tail around Z
      rotate <0, 0, (nGemCount + nGemClock) * nTotalGems * 24 / 360>

      // It's now ready to be moved away from the origin.
      // Undo the any undesirable future rotations here.
      rotate <0, -(nGemCount + nGemClock) * (360 / nGemsAroundHeart * nGemLoopsToHearts), 0>
      rotate <0, -(nGemCount + nGemClock) * (360 / (nGemsAroundHeart * nHeartsAroundLoop)), 0>

      // Innermost loop: Move it out toward +Z, then rotate it around Y
      translate <0, 0, 1.25>
      rotate <0, (nGemCount + nGemClock) * (360 / nGemsAroundHeart * nGemLoopsToHearts), 0>

      // Move it out a little bit toward +Z, then rotate about the Y axis
      translate <0, 0, 2>
      rotate <0, (nGemCount + nGemClock) * (360 / (nGemsAroundHeart * nHeartsAroundLoop)), 0>

      // Now move it further out toward -X and rotate about the Z axis.
      // This is the big loop.
      translate <-12, 0, 0>
      rotate <0, 0, (nGemCount + nGemClock) * (360 / nTotalGems)>
    }
    #declare  nGemCount = nGemCount + 1
  #end
  rotate <0, 0, 13.5>
  translate <0, 0, 0.75>
}
