
// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3
// Desc: Vidro 5, para entrar na IRTC de jan-fev/97
// Date: Fev, 25, 1997
// Auth: Afonso C. M. Klein (afklein@net.em.com.br)


// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions
#include "shapes.inc"
#include "shapesq.inc"

#declare Fire_Map = texture
{
  pigment
  {
    wood
    turbulence 0.2  omega 0.8
    color_map
    {
      [0.00 color rgb<1.000, 1.000, 1.000>]
      [0.08 color rgbf<0.980, 1.000, 0.016, 0.078>]
      [0.29 color rgbf<1.000, 0.737, 0.012, 0.400>]
      [0.53 color rgbf<1.000, 0.157, 0.008, 0.667>]
      [0.79 color rgbf<1.000, 1.000, 1.000, 1.000>]
      [1.00 color rgbf<1.000, 1.000, 1.000, 1.000>]
    }
    scale <0.2, 0.45, 0.1>
  }
  finish {
    ambient 1.0
  }
  translate <0.0, -3.25, 0.0>
}
// fim da declarao da textura

camera
{
  location  <1 , 1.5, -2>
  look_at   <1.5 , 3.5 , 0.0>
}

object{
 union {
  box {<-4, -0.5,-2.5><4.5,0,2.5>     texture{pigment{color White}}}
  box {<-4.5,0,-2.5><-4,8,2.5>        texture{pigment{color White}}}
  box {<-4.5,0,2.5><4.5,8,3>          texture{pigment{color White}}}
  box {<-4.5,0,-2.5><4.5,8,-3>        texture{pigment{color White}}}
  box {<4,0,-2.5><4.5,8,3>            texture{pigment{color White}}}
  box {<-4,8,-2.5><4.5,8.5,2.5>       texture{pigment{color White}}}
 }
 hollow
}

#include "lustre2.inc"
rotate <0, 0, 0>
translate <0, 9, 0>
scale <1/2, 1/2, 1/2>
}

#include "vela2.inc"
translate <6 , 3 , 0.0>
scale <0.5, 1, 0.5>
}

#include "copo1.inc"
texture {Glass3}
translate <2.6, 2.5,0.9>
}
#include "copo1.inc"
texture {Glass3}
translate <1.9, 2.5, 0>
}
#include "copo2.inc"
texture {Glass3}
translate <0.8, 2.5, 0>
}
#include "copo3.inc"
texture {Glass3}
translate <-0.4, 2.5, 1>
}

#include "garrafa1.inc"
texture {NBwinebottle}
translate <5.5,6,3>
scale <0.3, 0.5,0.3>
}
#include "garrafa2.inc"
texture {Yellow_Glass}
translate <3,2.5,2>
}
#include "garrafa2.inc"
texture {Ruby_Glass}
scale <0.7, 1, 0.7>
translate <2,2.5,2>
}
